<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class control extends indexbase {

    
    public function control_run() {
        $_tpl = "question_index";
        if (false === $this->existsTplFile($_tpl)) {
            $this->control_list();
        }
        else {
            $this->getMeta('ch_question_index');
            $page_title = $this->metawrap['title'];
            $page_description = $this->metawrap['description'];
            $page_keyword = $this->metawrap['keyword'];
            $var_array = array(
                'page_title'=>$page_title,
                'page_description'=>$page_description,
                'page_keyword'=>$page_keyword,
            );
            TPL::assign($var_array);
            TPL::display($this->getTPLFile($_tpl));
        }
    }

    
    public function control_list() {
        $this->pagesize = intval(parent::$cfg['questionpagesize']) > 0 ? intval(parent::$cfg['questionpagesize']) : 10;
        $searchsql = "";
        
        $model = parent::model("quetopic", "im");
        list($total, $data) = $model->getList(
            array(
                "page"=>$this->page,
                "pagesize"=>$this->pagesize,
                "searchsql"=>$searchsql,
                "orderby"=>"",
            )
        );
        unset($model);

        
        $this->getMeta('ch_question_list');
        $page_title = $this->metawrap['title'];
        $page_description = $this->metawrap['description'];
        $page_keyword = $this->metawrap['keyword'];
        $url = XRequest::getPhpSelf()."?c=question&a=list";
        $showpage = XPage::index($total, $this->pagesize, $this->page, $url, 10);
        $var_array = array(
            'page'=>$this->page,
            'nextpage'=>$this->page+1,
            'prepage'=>$this->page-1,
            'pagecount'=>ceil($total/$this->pagesize),
            'pagesize'=>$this->pagesize,
            'total'=>$total,
            'showpage'=>$showpage,
            'question'=>$data,
            'page_title'=>$page_title,
            'page_keyword'=>$page_keyword,
            'page_description'=>$page_description,
        );
        TPL::assign($var_array);
        TPL::display($this->getTPLFile("question_list"));
    }

    
    public function control_detail() {
        $id = XRequest::getInt("id");
        if ($id < 1) {
            XHandle::halt("参数错误", "", 1);
        }
        
        $model = parent::model("quetopic", "im");
        $_data = $model->getOneData($id);
        if (empty($_data)) {
            XHandle::halt("对不起，信息不存在或未审核", "", 1);
        }
        $previous_item = $model->getPrevious($id); 
        if (!empty($previous_item)) {
            $previous_item = "<a href='".$previous_item['url']."'>".$previous_item['topicname']."</a>";
        }
        else {
            $previous_item = '没有了';
        }
        $next_item = $model->getNext($id); 
        if (!empty($next_item)) {
            $next_item = "<a href='".$next_item['url']."'>".$next_item['topicname']."</a>";
        }
        else {
            $next_item = '没有了';
        }
        unset($model);

        $this->getMeta('ch_question_detail');
        $page_title = str_ireplace(
            array('{title}'), array($_data['topicname']), $this->metawrap['title']
        );
        $page_description = str_ireplace(
            array('{title}'), array($_data['topicname']), $this->metawrap['description']
        );
        $page_keyword = str_ireplace(
            array('{title}'), array($_data['topicname']), $this->metawrap['keyword']
        );
        $var_array = array(
            'question'=>$_data,
            'page_title'=>$page_title,
            'page_keyword'=>$page_keyword,
            'page_description'=>$page_description,
            'previous_item'=>$previous_item,
            'next_item'=>$next_item,
            'id'=>$id,
        );
        TPL::assign($var_array);
        TPL::display($this->getTPLFile("question_detail"));
    }

    
    public function control_poll() {
        $res = false;
        $topicid = XRequest::getInt("topicid");
        if ($topicid < 1) {
            XHandle::halt("参数错误", "", 1);
        }
        
        $model = parent::model("question", "im");
        if (false === $model->checkCanPoll($topicid)) {
            XHandle::halt("您已投过票了", "", 1);
        }
        $question_list = $model->getVolist("v.topicid='{$topicid}'", "", 1000);
        foreach ($question_list as $key=>$value) {
            $_option_id = XRequest::getInt("question_".$value['queid']);
            if ($_option_id > 0) {
                $res = $model->doPolls($value['queid'], $_option_id);
            }
        }
        if (true === $res) {
            
            $model->addPollLog($topicid);
            XHandle::halt("投票成功", parent::$urlpath."index.php?c=question&a=detail&id=".$topicid, 0);
        }
        else {
            XHandle::halt("投票失败", "", 1);
        }
    }
}
?>
