<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
	exit('OECMS Access Denied');
}
class indexbase extends X {
    protected $pagesize = 20;
    protected $page = 1;
    protected $smtpl = NULL;
    protected $metawrap = null;
    protected $gb_c = NULL;
    protected $gb_a = NULL;
    protected $appfile = "index.php";

    
    public function __construct() {
        $this->gb_c = GB_OECMS_C;
        $this->gb_a = GB_OECMS_A;
        $this->appfile  = parent::$urlpath.$this->appfile;
        $path_info = $GLOBALS['path_info'];
        if (!empty($path_info) && isset($path_info['page'])) {
            $this->page = intval($path_info['page']);
        }
        else {
            $this->page = intval(XRequest::getArgs('page'));
        }
        if ($this->page<1) {
            $this->page = 1;
        }
        $this->_loadMenu();
        if (isset($_GET['oecms'])) {
            X::poweredBy();
        }
        
        $var_array = array(
            "c"=>$this->gb_c,
            "a"=>$this->gb_a,
            "time"=>time(),
        );
        TPL::assign($var_array);
    }
    
    
    public function existsTplFile($tplname) {
        $res = false;
        if (!empty($tplname)) {
            $tplfile = parent::$tplpath.$tplname.".tpl";
            if (file_exists(BASE_ROOT.$tplfile)) {
                $res = true;
            }
        }
        return $res;
    }
    
    
    public function getTPLFile($tplname) {
        $tplfile = parent::$tplpath.$tplname.".tpl";
        if (!file_exists(BASE_ROOT.$tplfile)) {
            XHandle::halt('模板文件['.$tplfile.']不存在，请检查！', '', 1);
        }
        else {
            return $tplfile;
        }
    }

    
    protected function view($var_args, $tplname=null) {
        if (empty($tplname)) {
            $tplname = $this->c();
        }
        $tpl_file = $this->getTPLFile($tplname);
        TPL::assign($var_args);
        TPL::display($tpl_file);
    }
    
    protected function fetch($var_args, $tplname=null) {
        if (empty($tplname)) {
            $tplname = $this->c();
        }
        $tpl_file = $this->getTPLFile($tplname);
        TPL::assign($var_args);
        $tpl_data = TPL::fetch($tpl_file);
        return $tpl_data;
    }

    protected function c() { 
        return $this->gb_c;
    }
    protected function url($url_items=null) { 
        $_url = $this->appfile."?c=".$this->c();
        if (!empty($url_items)) {
            $_url .= "&".$url_items;
        }
        return $_url;
    }

    
    public function getMeta($idmark) {
        $model_seo = parent::model('seo', 'im');
        $data = $model_seo->getOneData($idmark);
        unset($model_seo);
        $this->metawrap = $data;
        return $data;
    }
    
    
    private function _loadMenu() {
        $model_seo = parent::model('seo', 'im');
        $model_seo->loadChLabel();
        unset($model_seo);
    }
}
?>
