<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class control extends wapbase {
    
    public function control_run() {
        $this->control_list();
    }

    
    public function control_list() {
        $this->pagesize = intval(parent::$cfg['wap_articlepagesize']);
        if ($this->pagesize <= 0) {
            $this->pagesize = 10;
        }
        $model = M("guestbook", "im");
        list($total, $data) = $model->getList(
            array(
                'page'=>$this->page,
                'pagesize'=>$this->pagesize,
                'searchsql'=>"",
                'orderby'=>"",
            )
        );
        unset($model);
        
        $url = $this->wapfile."?c=guestbook&a=list";
        $showpage = XPage::wapindex($total, $this->pagesize, $this->page, $url, 10);
        
        list($page_title, $page_description, $page_keyword) = XSeo::buildSeo("ch_guestbook");
        $prepage = $nextpage = $pagecount = 0;
        if (!empty($data)) {
            $pagecount = ceil($total/$this->pagesize);
            if ($pagecount > $this->page) {
                $nextpage = $this->page+1;
            }
            if ($this->page > 1) {
                $prepage = ($this->page-1);
            }
        }
        $var_array = array(
            'page'=>$this->page,
            'nextpage'=>$nextpage,
            'prepage'=>$prepage,
            'pagecount'=>$pagecount,
            'pagesize'=>$this->pagesize,
            'total'=>$total,
            'showpage'=>$showpage,
            'guestbook'=>$data,
            'page_title'=>$page_title,
            'page_keyword'=>$page_keyword,
            'page_description'=>$page_description,
        );
        $this->view($var_array, "guestbook_list");
    }

    
    public function control_message(){
        list($page_title, $page_description, $page_keyword) = XSeo::buildSeo("ch_guestbook");
        $var_array = array(
            'page_title'=>$page_title,
            'page_keyword'=>$page_keyword,
            'page_description'=>$page_description,
        );
        $this->view($var_array, "guestbook_message");
    }
    
    
    public function control_saveadd() {
        $args = $this->_validAdd();
        $model = parent::model('guestbook','im');
        $result = $model->doAdd($args);
        unset($model);
        if (true === $result) {
            XHandle::halt('留言成功', parent::$wapfile."c=guestbook", 0);
        }
        else {
            XHandle::halt('留言失败', '', 1);
        }
    }
    
    private function _validAdd() {
        $args = XRequest::getGpc(array(
            'title', 'username', 'email', 'content',
            'qq', 'msn', 'address', 'telephone', 'mobile',
            'checkcode', 
        ));
        if (empty($args['title'])) {
            XHandle::halt('请填写标题', '', 1);
        }
        if (empty($args['username'])) {
            XHandle::halt('请填写姓名', '', 1);
        }
        if (empty($args['email'])) {
            XHandle::halt('请填写邮箱', '', 1);
        }
		else {
			if (false === XValid::isEmail($args['email'])) {
				XHandle::halt('邮箱格式不正确', '', 1);
			}
		}
        if (empty($args['content'])) {
            XHandle::halt('请填写留言内容', '', 1);
        }
        parent::loadUtil('session');
        if ($args['checkcode'] != XSession::get('verifycode')) {
            XHandle::halt('验证码不正确', '', 1);
        }
        unset($args['checkcode']);
        return $args;
    }
}
?>
