<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class control extends wapbase {
    private $cid = 0; 
    private $id = 0; 
    private $treeid = 0; 
    private $rootid = 0; 
    private $catinfo = array(); 
    private $_tplname = NULL;

    
    public function control_run() {
        $this->_getIndexItems();
        list($page_title, $page_description, $page_keyword) = XSeo::buildSeo("ch_hr_index", null, $this->catinfo);
        $var_array = array(
            'catinfo'=>$this->catinfo,
            'treeid'=>$this->treeid,
            'rootid'=>$this->rootid,
            'cid'=>$this->cid,
            'page_title'=>$page_title,
            'page_description'=>$page_description,
            'page_keyword'=>$page_keyword,
        );
        $this->view($var_array, $this->_tplname);
    }

    
    public function control_list() {
        $this->_getListItems();
        $searchsql = "";
        
        $searchsql .= " AND v.treeid='{$this->treeid}'";
        
        if ($this->cid>0) {
            $m = parent::model('category', 'am');
            $childs = $m->getChildIDs($this->cid);
            if (!empty($childs)) {
                $searchsql .= " AND v.catid IN (".$childs.$this->cid.")";
            }
            else {
                $searchsql .= " AND v.catid='".$this->cid."'";
            }
            unset($m);
        }
        
        if ($this->catinfo['pagemax']<1) {
            $this->pagesize = intval(parent::$cfg['wap_hrpagesize']);
        }
        else {
            $this->pagesize = $this->catinfo['pagemax'];
        }
        if ($this->pagesize <= 0) {
            $this->pagesize = 10;
        }
        
        if ($this->catinfo['orderby'] == 1) {
            $orderby = ' ORDER BY v.updatetime DESC';
        }
        elseif ($this->catinfo['orderby'] == 2) {
            $orderby = ' ORDER BY v.addtime DESC';
        }
        elseif ($this->catinfo['orderby'] == 3) {
            $orderby = ' ORDER BY v.hits DESC';
        }
        elseif ($this->catinfo['orderby'] == 4) {
            $orderby = ' ORDER BY v.hrid DESC';
        }
        elseif ($this->catinfo['orderby'] == 5) {
            $orderby = ' ORDER BY v.hrid ASC';
        }
        else {
            $orderby = ' ORDER BY v.addtime DESC';
        }
        
        $model = M('hr', 'im');
        list($total, $data) = $model->getList(
            array(
                'page'=>$this->page,
                'pagesize'=>$this->pagesize,
                'searchsql'=>$searchsql,
                'orderby'=>$orderby,
            )
        );
        unset($model);
        
        $url = $this->wapfile."?c=hr&a=list&cid=".$this->cid;
        $showpage = XPage::wapindex($total, $this->pagesize, $this->page, $url, 10);
        
        list($page_title, $page_description, $page_keyword) = XSeo::buildSeo("ch_hr_list", array("page"=>$this->page), $this->catinfo);
        $prepage = $nextpage = $pagecount = 0;
        if (!empty($data)) {
            $pagecount = ceil($total/$this->pagesize);
            if ($pagecount > $this->page) {
                $nextpage = $this->page+1;
            }
            if ($this->page > 1) {
                $prepage = ($this->page-1);
            }
        }
        $var_array = array(
            'page'=>$this->page,
            'nextpage'=>$nextpage,
            'prepage'=>$prepage,
            'pagecount'=>$pagecount,
            'pagesize'=>$this->pagesize,
            'total'=>$total,
            'showpage'=>$showpage,
            'treeid'=>$this->treeid,
            'rootid'=>$this->rootid,
            'catid'=>$this->cid,
            'cid'=>$this->cid,
            'hr'=>$data,
            'catinfo'=>$this->catinfo,
            'page_title'=>$page_title,
            'page_keyword'=>$page_keyword,
            'page_description'=>$page_description,
        );
        $this->view($var_array, $this->_tplname);
    }

    
    public function control_detail() {
        $this->_getDetailItems();
        
        $model = M('hr', 'im');
        list($data, $attr, $this->catinfo) = $model->getOneData($this->id);
        if (empty($data)) {
            XHandle::halt("对不起，信息不存在！", "", 1);
        }
        $previous_item = $model->getPrevious($data['treeid'], $this->id);
        if (!empty($previous_item)) {
            $previous_item = "<a href='".$previous_item['wapurl']."'>".$previous_item['title']."</a>";
        }
        else {
            $previous_item = '没有了';
        }
        $next_item = $model->getNext($data['treeid'], $this->id);
        if (!empty($next_item)) {
            $next_item = "<a href='".$next_item['wapurl']."'>".$next_item['title']."</a>";
        }
        else {
            $next_item = '没有了';
        }
        unset($model);
        $this->treeid = intval($this->catinfo['treeid']);
        $this->rootid = intval($this->catinfo['rootid']);
        
        list($page_title, $page_description, $page_keyword) = XSeo::buildSeo("ch_hr_detail", $data, $this->catinfo);
        $var_array = array(
            'hr'=>$data,
            'attr'=>$attr,
            'catinfo'=>$this->catinfo,
            'page_title'=>$page_title,
            'page_keyword'=>$page_keyword,
            'page_description'=>$page_description,
            'treeid'=>$this->treeid,
            'rootid'=>$this->rootid,
            'previous_item'=>$previous_item,
            'next_item'=>$next_item,
            'id'=>$this->id,
        );
        $this->view($var_array, $this->_tplname);
    }

    
    private function _getIndexItems() {
        $this->cid = XRequest::getInt('cid');
        if ($this->cid<1) {
            XHandle::halt("对不起，栏目/分类ID有错！", "", 1);
        }
        
        $m_cat = M('category', 'im');
        $this->catinfo = $m_cat->getOneData($this->cid);
        unset($m_cat);
        if (empty($this->catinfo)) {
            XHandle::halt("对不起，载入栏目/分类失败！", "", 1);
        }
        else {
            
            if ($this->catinfo['treeid'] == 0) {
                $this->treeid = $this->cid;
                $this->rootid = $this->cid;
            }
            else {
                $this->treeid = $this->catinfo['treeid'];
                $this->rootid = $this->catinfo['rootid'];
            }
            
            $this->_tplname = "hr_index";
            if (false === $this->existsTplFile($this->_tplname)) {
                
                $this->_tplname = "";
                $this->control_list();
                exit;
            }
        }
    }

    
    private function _getListItems() {
        $this->cid = XRequest::getInt('cid');
        if ($this->cid<1) {
            XHandle::halt("对不起，栏目/分类ID有错！", "", 1);
        }
        
        $m_cat = M('category', 'im');
        $this->catinfo = $m_cat->getOneData($this->cid);
        unset($m_cat);
        if (empty($this->catinfo)) {
            XHandle::halt("对不起，载入栏目/分类失败！", "", 1);
        }
        else {
            
            if ($this->catinfo['treeid'] == 0) {
                $this->treeid = $this->cid;
                $this->rootid = $this->cid;
            }
            else {
                $this->treeid = $this->catinfo['treeid'];
                $this->rootid = $this->catinfo['rootid'];
            }
            
            $this->_tplname = "hr_list";
        }
    }

    
    private function _getDetailItems() {
        $this->id = XRequest::getInt('id');
        if ($this->id<1) {
            XHandle::halt("对不起，内容ID参数无效！", "", 1);
        }
        $this->_tplname = "hr_detail";
    }
}
?>
