<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
	exit('OECMS Access Denied');
}
class wapbase extends X {
    protected $pagesize = 20; 
    protected $page = 1; 
    protected $wap_skin = "wap";
    protected $wap_tplpath = "";
    protected $wapfile = "wap.php";
    protected $gb_c = NULL;
    protected $gb_a = NULL;
    protected $metawrap = null;

    
    public function __construct() {
        $this->gb_c = GB_OECMS_C;
        $this->gb_a = GB_OECMS_A;
        if (!empty(parent::$cfg['wap_skin'])) {
            $this->wap_skin = parent::$cfg['wap_skin'];
        }
        $this->wap_tplpath = "tpl/".$this->wap_skin."/";
        $this->wapfile = PATH_URL.$this->wapfile;
        $this->page = intval(XRequest::getArgs('page'));
        if ($this->page<1) {
            $this->page = 1;
        }
        $this->_loadMenu();
        $var_array = array(
            "c"=>$this->gb_c,
            "a"=>$this->gb_a,
            "time"=>time(),
            "waptplpath"=>$this->wap_tplpath,
            "skinpath"=>PATH_URL.$this->wap_tplpath,
            "wapfile"=>$this->wapfile,
        );
        TPL::assign($var_array);
        if (isset($_GET['oecms'])) {
            X::poweredBy();
        }
    }
    
    
    protected function existsTplFile($tplname) {
        $res = false;
        if (!empty($tplname)) {
            $tplfile = $this->wap_tplpath.$tplname.".tpl";
            if (file_exists(BASE_ROOT.$tplfile)) {
                $res = true;
            }
        }
        return $res;
    }
    
    
    protected function getTPLFile($tplname) {
        $tplfile = $this->wap_tplpath.$tplname.".tpl";
        if (!file_exists(BASE_ROOT.$tplfile)) {
            XHandle::halt("Wap模板文件{$tplfile}不存在，请检查！", "", 1);
        }
        else {
            return $tplfile;
        }
    }

    
    protected function view($var_args, $tplname=null) {
        if (empty($tplname)) {
            $tplname = $this->c();
        }
        $tpl_file = $this->getTPLFile($tplname);
        TPL::assign($var_args);
        TPL::display($tpl_file);
    }
    
    protected function fetch($var_args, $tplname=null) {
        if (empty($tplname)) {
            $tplname = $this->c();
        }
        $tpl_file = $this->getTPLFile($tplname);
        TPL::assign($var_args);
        $tpl_data = TPL::fetch($tpl_file);
        return $tpl_data;
    }

    protected function c() { 
        return $this->gb_c;
    }
    protected function url($url_items=null) { 
        $_url = $this->wapfile."?c=".$this->c();
        if (!empty($url_items)) {
            $_url .= "&".$url_items;
        }
        return $_url;
    }
    
    
    protected function getMeta($idmark) {
        $model_seo = M("seo", "im");
        $data = $model_seo->getOneData($idmark);
        unset($model_seo);
        $this->metawrap = $data;
        return $data;
    }
    
    
    private function _loadMenu() {
        $model_seo = M("seo", "im");
        $model_seo->loadChLabel();
        unset($model_seo);
    }
}
?>
