<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class XAssemble extends X {
    public static function __init() {
        self::_initConfig();
    }
    private static function _initConfig() {
        parent::loadLib('option');
        parent::loadUtil("filter");
        parent::loadUtil("request");
        $nonce_templet = XOption::get('nonce_templet');
        $site_base = XOption::get('site_base');
        $site_footer = XOption::get('site_footer');
        $index_style = XOption::get('index_style');
        $main_style = XOPtion::get('main_style');
        $wap_config = XOPtion::get('wap_config');
        $rewrite_config = XOption::get('site_rewrite');
        if (!empty($site_base['logo'])) {
            $site_base['logo'] = self::$urlpath . $site_base['logo'];
        }
        $config = array(
            'site_footer' => $site_footer,
            'templet' => $nonce_templet,
        );
        if (!empty($site_base)) {
            $config = array_merge($config, $site_base);
        }
        if (!empty($index_style)) {
            $config = array_merge($config, $index_style);
        }
        if (!empty($main_style)) {
            $config = array_merge($config, $main_style);
        }
        if (!empty($rewrite_config)) {
            $config = array_merge($config, $rewrite_config);
        }
        if (!empty($wap_config)) {
            $config = array_merge($config, $wap_config);
        }
        parent::$tplpath = parent::$tplpath . $config['templet'] . '/';
        parent::$skinpath = parent::$urlpath . parent::$tplpath;
        parent::$cfg = $config;
        unset($config);
    }
}
?>
