<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}

class XSeo extends X{
    
    public static function getSeo($chname) {
        $seo_data = parent::$obj->fetch_first("SELECT title, keyword, description FROM ".DB_PREFIX."seo WHERE idmark='{$chname}'");
        if (!empty($seo_data)) {
            $seo_data['title'] = str_ireplace("{sitename}", parent::$cfg['sitename'], $seo_data['title']);
            $seo_data['keyword'] = str_ireplace("{sitename}", parent::$cfg['sitename'], $seo_data['keyword']);
            $seo_data['description'] = str_ireplace("{sitename}", parent::$cfg['sitename'], $seo_data['description']);
        }
        return $seo_data;
    }

    
    public static function buildSeo($chname, $datainfo=null, $catinfo=null) {
        $page_title = null;
        $page_keyword = null;
        $page_description = null;
        $seo = self::getSeo($chname);
        if (!empty($seo)) {
            $page_title = $seo['title']; 
            $page_description = $seo['description']; 
            $page_keyword = $seo['keyword']; 
            switch ($chname) {

                
                case "ch_about_detail":
                    $meta_title = $datainfo['metatitle'];
                    if (empty($meta_title)) {
                        $meta_title = trim($datainfo['title']);
                    }
                    $page_title = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_article_index":
                    $page_title = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_article_list":
                    $page_title = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_article_detail":
                    $page_title = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $datainfo['catname'], $datainfo['metatitle'], $datainfo['metadescription'], $datainfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $datainfo['catname'], $datainfo['metatitle'], $datainfo['metadescription'], $datainfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $datainfo['catname'], $datainfo['metatitle'], $datainfo['metadescription'], $datainfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_product_index":
                    $page_title = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_product_list":
                    $page_title = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_product_detail":
                    $page_title = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['productname'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['productname'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['productname'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_photo_index":
                    $page_title = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_photo_list":
                    $page_title = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_photo_detail":
                    $page_title = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_hr_index":
                    $page_title = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_hr_list":
                    $page_title = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_hr_detail":
                    $page_title = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_download_index":
                    $page_title = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_download_list":
                    $page_title = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{page}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['page'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;

                
                case "ch_download_detail":
                    $page_title = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_title
                    );
                    $page_description = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_description
                    );
                    $page_keyword = str_ireplace(
                        array('{title}', '{metadescription}', '{metakeyword}', '{cat.name}', '{cat.metatitle}', '{cat.metadescription}', '{cat.metakeyword}') ,
                        array($datainfo['title'], $datainfo['metadescription'], $datainfo['metakeyword'], $catinfo['catname'], $catinfo['metatitle'], $catinfo['metadescription'], $catinfo['metakeyword']),
                        $page_keyword
                    );
                    break;


                default;
            }
        }
        return array($page_title, $page_description, $page_keyword);
    }
}
?>
