<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class quecommentIModel extends X {
    private $tbname = "question_comment";
    private $pkid = "commentid";

    
    public function getList($items) {
        $pagesize = intval($items['pagesize']);
        $where = " WHERE v.flag='1'".$items['searchsql'];
        $start = ($items['page']-1)*$pagesize;
        if (empty($items['orderby'])) {
            $items['orderby'] = " ORDER BY v.{$this->pkid} DESC";
        }
        $countsql = "SELECT COUNT(*) AS my_count FROM ".DB_PREFIX."{$this->tbname} AS v".$where;
        $total = parent::$obj->fetch_count($countsql);
        $sql = "SELECT v.*, t.topicname".
                " FROM ".DB_PREFIX."{$this->tbname} AS v".
                " LEFT JOIN ".DB_PREFIX."question_topic AS t ON v.topicid=t.topicid".
                $where.$items['orderby']." LIMIT {$start}, {$pagesize}";
        $data = parent::$obj->getall($sql);
        return array($total, $this->_handleList($data));
    }
    
    
    public function getVolist($where='', $orderby='', $num=0, $limit='') {
        $sql = "SELECT v.*, t.topicname".
                " FROM ".DB_PREFIX."{$this->tbname} AS v".
                " LEFT JOIN ".DB_PREFIX."question_topic AS t ON v.topicid=t.topicid".
                " WHERE v.flag='1'";
        $sql .= !empty($where) ? ' AND '.$where : '';
        $sql .= !empty($orderby) ? " ".$orderby : " ORDER BY v.{$this->pkid} DESC";
        if (!empty($limit)) {
            $sql .= " LIMIT {$limit}";
        }
        else {
            $num = intval($num)<1 ? 10 : intval($num);
            $sql .= " LIMIT 0, {$num}";
        }
        $data = parent::$obj->getall($sql);
        return $this->_handleList($data);
    }

    
    private function _handleList($data) {
        if (!empty($data)) {
            $i = 1;
            foreach($data as $key=>$value) {
                $data[$key]['url'] = PATH_URL."index.php?c=question&a=detail&id=".$value['topicid'];
                $data[$key]['i'] = $i;
                $i = ($i+1);
            }
        }
        return $data;
    }

    
    public function addtoComment($args) {
        $res = false;
        if (intval(parent::$cfg['auditcomment']) == 1) {
            $flag = 0;
        }
        else {
            $flag = 1;
        }
        $commentid = parent::$obj->fetch_newid("SELECT MAX({$this->pkid}) FROM ".DB_PREFIX."{$this->tbname}", 1);
        $args = array_merge(array(
            "commentid"=>$commentid,
            "addtime"=>time(),
            "flag"=>$flag,
            "ip"=>XRequest::getip(),
        ), $args);
        $res = parent::$obj->insert(DB_PREFIX."{$this->tbname}", $args);
        return $res;
    }
}
?>
