<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class quetopicIModel extends X {
    private $tbname = "question_topic";
    private $pkid = "topicid";

    
    public function getList($items) {
        $pagesize = intval($items['pagesize']);
        $where = " WHERE v.flag='1'".$items['searchsql'];
        $start = ($items['page']-1)*$pagesize;
        if (empty($items['orderby'])) {
            $items['orderby'] = " ORDER BY v.{$this->pkid} DESC";
        }
        $countsql = "SELECT COUNT(*) AS my_count FROM ".DB_PREFIX."{$this->tbname} AS v".$where;
        $total = parent::$obj->fetch_count($countsql);
        $sql = "SELECT v.*".
                " FROM ".DB_PREFIX."{$this->tbname} AS v".
                $where.$items['orderby']." LIMIT {$start}, {$pagesize}";
        $data = parent::$obj->getall($sql);
        return array($total, $this->_handleList($data));
    }
    
    
    public function getVolist($where='', $orderby='', $num=0, $limit='') {
        $sql = "SELECT v.*".
                " FROM ".DB_PREFIX."{$this->tbname} AS v".
                " WHERE v.flag='1'";
        $sql .= !empty($where) ? ' AND '.$where : '';
        $sql .= !empty($orderby) ? " ".$orderby : " ORDER BY v.{$this->pkid} DESC";
        if (!empty($limit)) {
            $sql .= " LIMIT {$limit}";
        }
        else {
            $num = intval($num)<1 ? 10 : intval($num);
            $sql .= " LIMIT 0, {$num}";
        }
        $data = parent::$obj->getall($sql);
        return $this->_handleList($data);
    }
    
    
    public function getOneData($id) {
        $_data = null;
        $sql = "SELECT v.*".
                " FROM ".DB_PREFIX."{$this->tbname} AS v".
                " WHERE v.{$this->pkid}='{$id}' AND v.flag='1'";
        $_data = parent::$obj->fetch_first($sql);
        if (!empty($_data)) {
            $_data['url'] = PATH_URL."index.php?c=question&a=detail&id=".$id;
            $_data['wapurl'] = PATH_URL."wap.php?c=question&a=detail&id=".$id;
            
            $up_array = array(
                "hits"=>"[[hits+1]]",
            );
            parent::$obj->update(DB_PREFIX."{$this->tbname}", $up_array, "{$this->pkid}='{$id}'");
        }
        return $_data;
    }
    
    
    public function getPrevious($id) {
        $_sql = "SELECT v.* FROM ".DB_PREFIX."{$this->tbname} AS v".
                " WHERE v.flag='1' AND v.{$this->pkid}<{$id}".
                " ORDER BY v.{$this->pkid} DESC LIMIT 0, 1";
        $_data = parent::$obj->fetch_first($_sql);
        if (!empty($_data)) {
            $rows['url'] = PATH_URL."index.php?c=question&a=detail&id=".$_data['topicid'];
            
        }
        return $_data;
    }
    
    
    public function getNext($id) {
        $_sql = "SELECT v.* FROM ".DB_PREFIX."{$this->tbname} AS v".
                " WHERE v.flag='1' AND v.{$this->pkid}>{$id}".
                " ORDER BY v.{$this->pkid} ASC LIMIT 0, 1";
        $_data = parent::$obj->fetch_first($_sql);
        if (!empty($_data)) {
            $rows['url'] = PATH_URL."index.php?c=question&a=detail&id=".$_data['topicid'];
            
        }
        return $_data;
    }
    
    
    private function _handleList($data) {
        if (!empty($data)) {
            $i = 1;
            foreach($data as $key=>$value) {
                $data[$key]['url'] = PATH_URL."index.php?c=question&a=detail&id=".$value['topicid'];
                
                $data[$key]['i'] = $i;
                $i = ($i+1); 
            }
        } 
        return $data;
    }
}
?>
