 
DROP TABLE IF EXISTS `ad`;

CREATE TABLE `ad` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `image_width` int(10) unsigned NOT NULL COMMENT '图片宽度',
  `image_height` int(10) unsigned NOT NULL COMMENT '图片高度',
  `name` varchar(32) NOT NULL COMMENT '广告名称',
  `intro` text NOT NULL COMMENT '介绍',
  `start_date` date NOT NULL COMMENT '广告起始时间',
  `end_date` date NOT NULL COMMENT '广告结束时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已经被删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='广告表';

/*Data for the table `ad` */

insert  into `ad`(`id`,`image_width`,`image_height`,`name`,`intro`,`start_date`,`end_date`,`create_time`,`is_delete`) values (1,746,465,'首页Banner广告','首页广告轮','2015-09-01','2015-09-08','2015-08-06 10:59:07',0);

/*Table structure for table `ad_images` */

DROP TABLE IF EXISTS `ad_images`;

CREATE TABLE `ad_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告图片id',
  `ad_id` int(10) unsigned NOT NULL COMMENT '所对应的广告的id',
  `image_path` varchar(100) NOT NULL COMMENT '图片地址',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `link_url` varchar(100) NOT NULL COMMENT '链接的url',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COMMENT='广告图片列表';


insert  into `ad_images`(`id`,`ad_id`,`image_path`,`create_time`,`link_url`) values (21,1,'/uploads/ad/20160104145800_261.png','2016-01-04 14:58:00','http://www.123phpshop.com');

DROP TABLE IF EXISTS `area`;

CREATE TABLE `area` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '区域id',
  `name` varchar(30) NOT NULL COMMENT '区域名称',
  `pid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '上级区域id',
  `level_depth` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '区域的深度级别',
  `level_path` varchar(100) NOT NULL COMMENT '区域的级别路径',
  `child_num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '下级区域数量',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3276 DEFAULT CHARSET=utf8 COMMENT='区域表';

/*Data for the table `area` */

insert  into `area`(`id`,`name`,`pid`,`level_depth`,`level_path`,`child_num`) values (1,'北京',0,1,'_北京_',0),(2,'北京',1,2,'_北京_北京_',0),(3,'东城区',2,3,'_北京_北京_东城区_',0),(4,'西城区',2,3,'_北京_北京_西城区_',0),(5,'崇文区',2,3,'_北京_北京_崇文区_',0),(6,'宣武区',2,3,'_北京_北京_宣武区_',0),(7,'朝阳区',2,3,'_北京_北京_朝阳区_',0),(8,'丰台区',2,3,'_北京_北京_丰台区_',0),(9,'石景山区',2,3,'_北京_北京_石景山区_',0),(10,'海淀区',2,3,'_北京_北京_海淀区_',0),(11,'门头沟区',2,3,'_北京_北京_门头沟区_',0),(12,'房山区',2,3,'_北京_北京_房山区_',0),(13,'通州区',2,3,'_北京_北京_通州区_',0),(14,'顺义区',2,3,'_北京_北京_顺义区_',0),(15,'昌平区',2,3,'_北京_北京_昌平区_',0),(16,'大兴区',2,3,'_北京_北京_大兴区_',0),(17,'怀柔区',2,3,'_北京_北京_怀柔区_',0),(18,'平谷区',2,3,'_北京_北京_平谷区_',0),(19,'密云县',2,3,'_北京_北京_密云县_',0),(20,'延庆县',2,3,'_北京_北京_延庆县_',0),(21,'上海',0,1,'_上海_',0),(22,'上海',21,2,'_上海_上海_',0),(23,'黄浦区',22,3,'_上海_上海_黄浦区_',0),(24,'卢湾区',22,3,'_上海_上海_卢湾区_',0),(25,'徐汇区',22,3,'_上海_上海_徐汇区_',0),(26,'长宁区',22,3,'_上海_上海_长宁区_',0),(27,'静安区',22,3,'_上海_上海_静安区_',0),(28,'普陀区',22,3,'_上海_上海_普陀区_',0),(29,'闸北区',22,3,'_上海_上海_闸北区_',0),(30,'虹口区',22,3,'_上海_上海_虹口区_',0),(31,'杨浦区',22,3,'_上海_上海_杨浦区_',0),(32,'闵行区',22,3,'_上海_上海_闵行区_',0),(33,'宝山区',22,3,'_上海_上海_宝山区_',0),(34,'嘉定区',22,3,'_上海_上海_嘉定区_',0),(35,'浦东新区',22,3,'_上海_上海_浦东新区_',0),(36,'金山区',22,3,'_上海_上海_金山区_',0),(37,'松江区',22,3,'_上海_上海_松江区_',0),(38,'青浦区',22,3,'_上海_上海_青浦区_',0),(39,'南汇区',22,3,'_上海_上海_南汇区_',0),(40,'奉贤区',22,3,'_上海_上海_奉贤区_',0),(41,'崇明县',22,3,'_上海_上海_崇明县_',0),(42,'天津',0,1,'_天津_',0),(43,'天津',42,2,'_天津_天津_',0),(44,'和平区',43,3,'_天津_天津_和平区_',0),(45,'河东区',43,3,'_天津_天津_河东区_',0),(46,'河西区',43,3,'_天津_天津_河西区_',0),(47,'南开区',43,3,'_天津_天津_南开区_',0),(48,'河北区',43,3,'_天津_天津_河北区_',0),(49,'红桥区',43,3,'_天津_天津_红桥区_',0),(50,'塘沽区',43,3,'_天津_天津_塘沽区_',0),(51,'汉沽区',43,3,'_天津_天津_汉沽区_',0),(52,'大港区',43,3,'_天津_天津_大港区_',0),(53,'东丽区',43,3,'_天津_天津_东丽区_',0),(54,'西青区',43,3,'_天津_天津_西青区_',0),(55,'津南区',43,3,'_天津_天津_津南区_',0),(56,'北辰区',43,3,'_天津_天津_北辰区_',0),(57,'武清区',43,3,'_天津_天津_武清区_',0),(58,'宝坻区',43,3,'_天津_天津_宝坻区_',0),(59,'宁河县',43,3,'_天津_天津_宁河县_',0),(60,'静海县',43,3,'_天津_天津_静海县_',0),(61,'蓟　县',43,3,'_天津_天津_蓟　县_',0),(62,'重庆',0,1,'_重庆_',0),(63,'重庆',62,2,'_重庆_重庆_',0),(64,'万州区',63,3,'_重庆_重庆_万州区_',0),(65,'涪陵区',63,3,'_重庆_重庆_涪陵区_',0),(66,'渝中区',63,3,'_重庆_重庆_渝中区_',0),(67,'大渡口区',63,3,'_重庆_重庆_大渡口区_',0),(68,'江北区',63,3,'_重庆_重庆_江北区_',0),(69,'沙坪坝区',63,3,'_重庆_重庆_沙坪坝区_',0),(70,'九龙坡区',63,3,'_重庆_重庆_九龙坡区_',0),(71,'南岸区',63,3,'_重庆_重庆_南岸区_',0),(72,'北碚区',63,3,'_重庆_重庆_北碚区_',0),(73,'万盛区',63,3,'_重庆_重庆_万盛区_',0),(74,'双桥区',63,3,'_重庆_重庆_双桥区_',0),(75,'渝北区',63,3,'_重庆_重庆_渝北区_',0),(76,'巴南区',63,3,'_重庆_重庆_巴南区_',0),(77,'黔江区',63,3,'_重庆_重庆_黔江区_',0),(78,'长寿区',63,3,'_重庆_重庆_长寿区_',0),(79,'江津市',63,3,'_重庆_重庆_江津市_',0),(80,'合川市',63,3,'_重庆_重庆_合川市_',0),(81,'永川市',63,3,'_重庆_重庆_永川市_',0),(82,'南川市',63,3,'_重庆_重庆_南川市_',0),(83,'綦江县',63,3,'_重庆_重庆_綦江县_',0),(84,'潼南县',63,3,'_重庆_重庆_潼南县_',0),(85,'铜梁县',63,3,'_重庆_重庆_铜梁县_',0),(86,'大足县',63,3,'_重庆_重庆_大足县_',0),(87,'荣昌县',63,3,'_重庆_重庆_荣昌县_',0),(88,'璧山县',63,3,'_重庆_重庆_璧山县_',0),(89,'梁平县',63,3,'_重庆_重庆_梁平县_',0),(90,'城口县',63,3,'_重庆_重庆_城口县_',0),(91,'丰都县',63,3,'_重庆_重庆_丰都县_',0),(92,'垫江县',63,3,'_重庆_重庆_垫江县_',0),(93,'武隆县',63,3,'_重庆_重庆_武隆县_',0),(94,'忠　县',63,3,'_重庆_重庆_忠　县_',0),(95,'开　县',63,3,'_重庆_重庆_开　县_',0),(96,'云阳县',63,3,'_重庆_重庆_云阳县_',0),(97,'奉节县',63,3,'_重庆_重庆_奉节县_',0),(98,'巫山县',63,3,'_重庆_重庆_巫山县_',0),(99,'巫溪县',63,3,'_重庆_重庆_巫溪县_',0),(100,'石柱土家族自治县',63,3,'_重庆_重庆_石柱土家族自治县_',0),(101,'秀山土家族苗族自治县',63,3,'_重庆_重庆_秀山土家族苗族自治县_',0),(102,'酉阳土家族苗族自治县',63,3,'_重庆_重庆_酉阳土家族苗族自治县_',0),(103,'彭水苗族土家族自治县',63,3,'_重庆_重庆_彭水苗族土家族自治县_',0),(104,'四川',0,1,'_四川_',0),(105,'成都市',104,2,'_四川_成都市_',0),(106,'锦江区',105,3,'_四川_成都市_锦江区_',0),(107,'青羊区',105,3,'_四川_成都市_青羊区_',0),(108,'金牛区',105,3,'_四川_成都市_金牛区_',0),(109,'武侯区',105,3,'_四川_成都市_武侯区_',0),(110,'成华区',105,3,'_四川_成都市_成华区_',0),(111,'龙泉驿区',105,3,'_四川_成都市_龙泉驿区_',0),(112,'青白江区',105,3,'_四川_成都市_青白江区_',0),(113,'新都区',105,3,'_四川_成都市_新都区_',0),(114,'温江县',105,3,'_四川_成都市_温江县_',0),(115,'金堂县',105,3,'_四川_成都市_金堂县_',0),(116,'双流县',105,3,'_四川_成都市_双流县_',0),(117,'郫　县',105,3,'_四川_成都市_郫　县_',0),(118,'大邑县',105,3,'_四川_成都市_大邑县_',0),(119,'蒲江县',105,3,'_四川_成都市_蒲江县_',0),(120,'新津县',105,3,'_四川_成都市_新津县_',0),(121,'都江堰市',105,3,'_四川_成都市_都江堰市_',0),(122,'彭州市',105,3,'_四川_成都市_彭州市_',0),(123,'邛崃市',105,3,'_四川_成都市_邛崃市_',0),(124,'崇州市',105,3,'_四川_成都市_崇州市_',0),(125,'自贡市',104,2,'_四川_自贡市_',0),(126,'自流井区',125,3,'_四川_自贡市_自流井区_',0),(127,'贡井区',125,3,'_四川_自贡市_贡井区_',0),(128,'大安区',125,3,'_四川_自贡市_大安区_',0),(129,'沿滩区',125,3,'_四川_自贡市_沿滩区_',0),(130,'荣　县',125,3,'_四川_自贡市_荣　县_',0),(131,'富顺县',125,3,'_四川_自贡市_富顺县_',0),(132,'攀枝花市',104,2,'_四川_攀枝花市_',0),(133,'东　区',132,3,'_四川_攀枝花市_东　区_',0),(134,'西　区',132,3,'_四川_攀枝花市_西　区_',0),(135,'仁和区',132,3,'_四川_攀枝花市_仁和区_',0),(136,'米易县',132,3,'_四川_攀枝花市_米易县_',0),(137,'盐边县',132,3,'_四川_攀枝花市_盐边县_',0),(138,'泸州市',104,2,'_四川_泸州市_',0),(139,'江阳区',138,3,'_四川_泸州市_江阳区_',0),(140,'纳溪区',138,3,'_四川_泸州市_纳溪区_',0),(141,'龙马潭区',138,3,'_四川_泸州市_龙马潭区_',0),(142,'泸　县',138,3,'_四川_泸州市_泸　县_',0),(143,'合江县',138,3,'_四川_泸州市_合江县_',0),(144,'叙永县',138,3,'_四川_泸州市_叙永县_',0),(145,'古蔺县',138,3,'_四川_泸州市_古蔺县_',0),(146,'德阳市',104,2,'_四川_德阳市_',0),(147,'旌阳区',146,3,'_四川_德阳市_旌阳区_',0),(148,'中江县',146,3,'_四川_德阳市_中江县_',0),(149,'罗江县',146,3,'_四川_德阳市_罗江县_',0),(150,'广汉市',146,3,'_四川_德阳市_广汉市_',0),(151,'什邡市',146,3,'_四川_德阳市_什邡市_',0),(152,'绵竹市',146,3,'_四川_德阳市_绵竹市_',0),(153,'绵阳市',104,2,'_四川_绵阳市_',0),(154,'涪城区',153,3,'_四川_绵阳市_涪城区_',0),(155,'游仙区',153,3,'_四川_绵阳市_游仙区_',0),(156,'三台县',153,3,'_四川_绵阳市_三台县_',0),(157,'盐亭县',153,3,'_四川_绵阳市_盐亭县_',0),(158,'安　县',153,3,'_四川_绵阳市_安　县_',0),(159,'梓潼县',153,3,'_四川_绵阳市_梓潼县_',0),(160,'北川羌族自治县',153,3,'_四川_绵阳市_北川羌族自治县_',0),(161,'平武县',153,3,'_四川_绵阳市_平武县_',0),(162,'江油市',153,3,'_四川_绵阳市_江油市_',0),(163,'广元市',104,2,'_四川_广元市_',0),(164,'市中区',163,3,'_四川_广元市_市中区_',0),(165,'元坝区',163,3,'_四川_广元市_元坝区_',0),(166,'朝天区',163,3,'_四川_广元市_朝天区_',0),(167,'旺苍县',163,3,'_四川_广元市_旺苍县_',0),(168,'青川县',163,3,'_四川_广元市_青川县_',0),(169,'剑阁县',163,3,'_四川_广元市_剑阁县_',0),(170,'苍溪县',163,3,'_四川_广元市_苍溪县_',0),(171,'遂宁市',104,2,'_四川_遂宁市_',0),(172,'船山区',171,3,'_四川_遂宁市_船山区_',0),(173,'安居区',171,3,'_四川_遂宁市_安居区_',0),(174,'蓬溪县',171,3,'_四川_遂宁市_蓬溪县_',0),(175,'射洪县',171,3,'_四川_遂宁市_射洪县_',0),(176,'大英县',171,3,'_四川_遂宁市_大英县_',0),(177,'内江市',104,2,'_四川_内江市_',0),(178,'市中区',177,3,'_四川_内江市_市中区_',0),(179,'东兴区',177,3,'_四川_内江市_东兴区_',0),(180,'威远县',177,3,'_四川_内江市_威远县_',0),(181,'资中县',177,3,'_四川_内江市_资中县_',0),(182,'隆昌县',177,3,'_四川_内江市_隆昌县_',0),(183,'乐山市',104,2,'_四川_乐山市_',0),(184,'市中区',183,3,'_四川_乐山市_市中区_',0),(185,'沙湾区',183,3,'_四川_乐山市_沙湾区_',0),(186,'五通桥区',183,3,'_四川_乐山市_五通桥区_',0),(187,'金口河区',183,3,'_四川_乐山市_金口河区_',0),(188,'犍为县',183,3,'_四川_乐山市_犍为县_',0),(189,'井研县',183,3,'_四川_乐山市_井研县_',0),(190,'夹江县',183,3,'_四川_乐山市_夹江县_',0),(191,'沐川县',183,3,'_四川_乐山市_沐川县_',0),(192,'峨边彝族自治县',183,3,'_四川_乐山市_峨边彝族自治县_',0),(193,'马边彝族自治县',183,3,'_四川_乐山市_马边彝族自治县_',0),(194,'峨眉山市',183,3,'_四川_乐山市_峨眉山市_',0),(195,'南充市',104,2,'_四川_南充市_',0),(196,'顺庆区',195,3,'_四川_南充市_顺庆区_',0),(197,'高坪区',195,3,'_四川_南充市_高坪区_',0),(198,'嘉陵区',195,3,'_四川_南充市_嘉陵区_',0),(199,'南部县',195,3,'_四川_南充市_南部县_',0),(200,'营山县',195,3,'_四川_南充市_营山县_',0),(201,'蓬安县',195,3,'_四川_南充市_蓬安县_',0),(202,'仪陇县',195,3,'_四川_南充市_仪陇县_',0),(203,'西充县',195,3,'_四川_南充市_西充县_',0),(204,'阆中市',195,3,'_四川_南充市_阆中市_',0),(205,'眉山市',104,2,'_四川_眉山市_',0),(206,'东坡区',205,3,'_四川_眉山市_东坡区_',0),(207,'仁寿县',205,3,'_四川_眉山市_仁寿县_',0),(208,'彭山县',205,3,'_四川_眉山市_彭山县_',0),(209,'洪雅县',205,3,'_四川_眉山市_洪雅县_',0),(210,'丹棱县',205,3,'_四川_眉山市_丹棱县_',0),(211,'青神县',205,3,'_四川_眉山市_青神县_',0),(212,'宜宾市',104,2,'_四川_宜宾市_',0),(213,'翠屏区',212,3,'_四川_宜宾市_翠屏区_',0),(214,'宜宾县',212,3,'_四川_宜宾市_宜宾县_',0),(215,'南溪县',212,3,'_四川_宜宾市_南溪县_',0),(216,'江安县',212,3,'_四川_宜宾市_江安县_',0),(217,'长宁县',212,3,'_四川_宜宾市_长宁县_',0),(218,'高　县',212,3,'_四川_宜宾市_高　县_',0),(219,'珙　县',212,3,'_四川_宜宾市_珙　县_',0),(220,'筠连县',212,3,'_四川_宜宾市_筠连县_',0),(221,'兴文县',212,3,'_四川_宜宾市_兴文县_',0),(222,'屏山县',212,3,'_四川_宜宾市_屏山县_',0),(223,'广安市',104,2,'_四川_广安市_',0),(224,'广安区',223,3,'_四川_广安市_广安区_',0),(225,'岳池县',223,3,'_四川_广安市_岳池县_',0),(226,'武胜县',223,3,'_四川_广安市_武胜县_',0),(227,'邻水县',223,3,'_四川_广安市_邻水县_',0),(228,'华莹市',223,3,'_四川_广安市_华莹市_',0),(229,'达州市',104,2,'_四川_达州市_',0),(230,'通川区',229,3,'_四川_达州市_通川区_',0),(231,'达　县',229,3,'_四川_达州市_达　县_',0),(232,'宣汉县',229,3,'_四川_达州市_宣汉县_',0),(233,'开江县',229,3,'_四川_达州市_开江县_',0),(234,'大竹县',229,3,'_四川_达州市_大竹县_',0),(235,'渠　县',229,3,'_四川_达州市_渠　县_',0),(236,'万源市',229,3,'_四川_达州市_万源市_',0),(237,'雅安市',104,2,'_四川_雅安市_',0),(238,'雨城区',237,3,'_四川_雅安市_雨城区_',0),(239,'名山县',237,3,'_四川_雅安市_名山县_',0),(240,'荥经县',237,3,'_四川_雅安市_荥经县_',0),(241,'汉源县',237,3,'_四川_雅安市_汉源县_',0),(242,'石棉县',237,3,'_四川_雅安市_石棉县_',0),(243,'天全县',237,3,'_四川_雅安市_天全县_',0),(244,'芦山县',237,3,'_四川_雅安市_芦山县_',0),(245,'宝兴县',237,3,'_四川_雅安市_宝兴县_',0),(246,'巴中市',104,2,'_四川_巴中市_',0),(247,'巴州区',246,3,'_四川_巴中市_巴州区_',0),(248,'通江县',246,3,'_四川_巴中市_通江县_',0),(249,'南江县',246,3,'_四川_巴中市_南江县_',0),(250,'平昌县',246,3,'_四川_巴中市_平昌县_',0),(251,'资阳市',104,2,'_四川_资阳市_',0),(252,'雁江区',251,3,'_四川_资阳市_雁江区_',0),(253,'安岳县',251,3,'_四川_资阳市_安岳县_',0),(254,'乐至县',251,3,'_四川_资阳市_乐至县_',0),(255,'简阳市',251,3,'_四川_资阳市_简阳市_',0),(256,'阿坝藏族羌族自治州',104,2,'_四川_阿坝藏族羌族自治州_',0),(257,'汶川县',256,3,'_四川_阿坝藏族羌族自治州_汶川县_',0),(258,'理　县',256,3,'_四川_阿坝藏族羌族自治州_理　县_',0),(259,'茂　县',256,3,'_四川_阿坝藏族羌族自治州_茂　县_',0),(260,'松潘县',256,3,'_四川_阿坝藏族羌族自治州_松潘县_',0),(261,'九寨沟县',256,3,'_四川_阿坝藏族羌族自治州_九寨沟县_',0),(262,'金川县',256,3,'_四川_阿坝藏族羌族自治州_金川县_',0),(263,'小金县',256,3,'_四川_阿坝藏族羌族自治州_小金县_',0),(264,'黑水县',256,3,'_四川_阿坝藏族羌族自治州_黑水县_',0),(265,'马尔康县',256,3,'_四川_阿坝藏族羌族自治州_马尔康县_',0),(266,'壤塘县',256,3,'_四川_阿坝藏族羌族自治州_壤塘县_',0),(267,'阿坝县',256,3,'_四川_阿坝藏族羌族自治州_阿坝县_',0),(268,'若尔盖县',256,3,'_四川_阿坝藏族羌族自治州_若尔盖县_',0),(269,'红原县',256,3,'_四川_阿坝藏族羌族自治州_红原县_',0),(270,'甘孜藏族自治州',104,2,'_四川_甘孜藏族自治州_',0),(271,'康定县',270,3,'_四川_甘孜藏族自治州_康定县_',0),(272,'泸定县',270,3,'_四川_甘孜藏族自治州_泸定县_',0),(273,'丹巴县',270,3,'_四川_甘孜藏族自治州_丹巴县_',0),(274,'九龙县',270,3,'_四川_甘孜藏族自治州_九龙县_',0),(275,'雅江县',270,3,'_四川_甘孜藏族自治州_雅江县_',0),(276,'道孚县',270,3,'_四川_甘孜藏族自治州_道孚县_',0),(277,'炉霍县',270,3,'_四川_甘孜藏族自治州_炉霍县_',0),(278,'甘孜县',270,3,'_四川_甘孜藏族自治州_甘孜县_',0),(279,'新龙县',270,3,'_四川_甘孜藏族自治州_新龙县_',0),(280,'德格县',270,3,'_四川_甘孜藏族自治州_德格县_',0),(281,'白玉县',270,3,'_四川_甘孜藏族自治州_白玉县_',0),(282,'石渠县',270,3,'_四川_甘孜藏族自治州_石渠县_',0),(283,'色达县',270,3,'_四川_甘孜藏族自治州_色达县_',0),(284,'理塘县',270,3,'_四川_甘孜藏族自治州_理塘县_',0),(285,'巴塘县',270,3,'_四川_甘孜藏族自治州_巴塘县_',0),(286,'乡城县',270,3,'_四川_甘孜藏族自治州_乡城县_',0),(287,'稻城县',270,3,'_四川_甘孜藏族自治州_稻城县_',0),(288,'得荣县',270,3,'_四川_甘孜藏族自治州_得荣县_',0),(289,'凉山彝族自治州',104,2,'_四川_凉山彝族自治州_',0),(290,'西昌市',289,3,'_四川_凉山彝族自治州_西昌市_',0),(291,'木里藏族自治县',289,3,'_四川_凉山彝族自治州_木里藏族自治县_',0),(292,'盐源县',289,3,'_四川_凉山彝族自治州_盐源县_',0),(293,'德昌县',289,3,'_四川_凉山彝族自治州_德昌县_',0),(294,'会理县',289,3,'_四川_凉山彝族自治州_会理县_',0),(295,'会东县',289,3,'_四川_凉山彝族自治州_会东县_',0),(296,'宁南县',289,3,'_四川_凉山彝族自治州_宁南县_',0),(297,'普格县',289,3,'_四川_凉山彝族自治州_普格县_',0),(298,'布拖县',289,3,'_四川_凉山彝族自治州_布拖县_',0),(299,'金阳县',289,3,'_四川_凉山彝族自治州_金阳县_',0),(300,'昭觉县',289,3,'_四川_凉山彝族自治州_昭觉县_',0),(301,'喜德县',289,3,'_四川_凉山彝族自治州_喜德县_',0),(302,'冕宁县',289,3,'_四川_凉山彝族自治州_冕宁县_',0),(303,'越西县',289,3,'_四川_凉山彝族自治州_越西县_',0),(304,'甘洛县',289,3,'_四川_凉山彝族自治州_甘洛县_',0),(305,'美姑县',289,3,'_四川_凉山彝族自治州_美姑县_',0),(306,'雷波县',289,3,'_四川_凉山彝族自治州_雷波县_',0),(307,'贵州',0,1,'_贵州_',0),(308,'贵阳市',307,2,'_贵州_贵阳市_',0),(309,'南明区',308,3,'_贵州_贵阳市_南明区_',0),(310,'云岩区',308,3,'_贵州_贵阳市_云岩区_',0),(311,'花溪区',308,3,'_贵州_贵阳市_花溪区_',0),(312,'乌当区',308,3,'_贵州_贵阳市_乌当区_',0),(313,'白云区',308,3,'_贵州_贵阳市_白云区_',0),(314,'小河区',308,3,'_贵州_贵阳市_小河区_',0),(315,'开阳县',308,3,'_贵州_贵阳市_开阳县_',0),(316,'息烽县',308,3,'_贵州_贵阳市_息烽县_',0),(317,'修文县',308,3,'_贵州_贵阳市_修文县_',0),(318,'清镇市',308,3,'_贵州_贵阳市_清镇市_',0),(319,'六盘水市',307,2,'_贵州_六盘水市_',0),(320,'钟山区',319,3,'_贵州_六盘水市_钟山区_',0),(321,'六枝特区',319,3,'_贵州_六盘水市_六枝特区_',0),(322,'水城县',319,3,'_贵州_六盘水市_水城县_',0),(323,'盘　县',319,3,'_贵州_六盘水市_盘　县_',0),(324,'遵义市',307,2,'_贵州_遵义市_',0),(325,'红花岗区',324,3,'_贵州_遵义市_红花岗区_',0),(326,'汇川区',324,3,'_贵州_遵义市_汇川区_',0),(327,'遵义县',324,3,'_贵州_遵义市_遵义县_',0),(328,'桐梓县',324,3,'_贵州_遵义市_桐梓县_',0),(329,'绥阳县',324,3,'_贵州_遵义市_绥阳县_',0),(330,'正安县',324,3,'_贵州_遵义市_正安县_',0),(331,'道真仡佬族苗族自治县',324,3,'_贵州_遵义市_道真仡佬族苗族自治县_',0),(332,'务川仡佬族苗族自治县',324,3,'_贵州_遵义市_务川仡佬族苗族自治县_',0),(333,'凤冈县',324,3,'_贵州_遵义市_凤冈县_',0),(334,'湄潭县',324,3,'_贵州_遵义市_湄潭县_',0),(335,'余庆县',324,3,'_贵州_遵义市_余庆县_',0),(336,'习水县',324,3,'_贵州_遵义市_习水县_',0),(337,'赤水市',324,3,'_贵州_遵义市_赤水市_',0),(338,'仁怀市',324,3,'_贵州_遵义市_仁怀市_',0),(339,'安顺市',307,2,'_贵州_安顺市_',0),(340,'西秀区',339,3,'_贵州_安顺市_西秀区_',0),(341,'平坝县',339,3,'_贵州_安顺市_平坝县_',0),(342,'普定县',339,3,'_贵州_安顺市_普定县_',0),(343,'镇宁布依族苗族自治县',339,3,'_贵州_安顺市_镇宁布依族苗族自治县_',0),(344,'关岭布依族苗族自治县',339,3,'_贵州_安顺市_关岭布依族苗族自治县_',0),(345,'紫云苗族布依族自治县',339,3,'_贵州_安顺市_紫云苗族布依族自治县_',0),(346,'铜仁地区',307,2,'_贵州_铜仁地区_',0),(347,'铜仁市',346,3,'_贵州_铜仁地区_铜仁市_',0),(348,'江口县',346,3,'_贵州_铜仁地区_江口县_',0),(349,'玉屏侗族自治县',346,3,'_贵州_铜仁地区_玉屏侗族自治县_',0),(350,'石阡县',346,3,'_贵州_铜仁地区_石阡县_',0),(351,'思南县',346,3,'_贵州_铜仁地区_思南县_',0),(352,'印江土家族苗族自治县',346,3,'_贵州_铜仁地区_印江土家族苗族自治县_',0),(353,'德江县',346,3,'_贵州_铜仁地区_德江县_',0),(354,'沿河土家族自治县',346,3,'_贵州_铜仁地区_沿河土家族自治县_',0),(355,'松桃苗族自治县',346,3,'_贵州_铜仁地区_松桃苗族自治县_',0),(356,'万山特区',346,3,'_贵州_铜仁地区_万山特区_',0),(357,'黔西南布依族苗族自治州',307,2,'_贵州_黔西南布依族苗族自治州_',0),(358,'兴义市',357,3,'_贵州_黔西南布依族苗族自治州_兴义市_',0),(359,'兴仁县',357,3,'_贵州_黔西南布依族苗族自治州_兴仁县_',0),(360,'普安县',357,3,'_贵州_黔西南布依族苗族自治州_普安县_',0),(361,'晴隆县',357,3,'_贵州_黔西南布依族苗族自治州_晴隆县_',0),(362,'贞丰县',357,3,'_贵州_黔西南布依族苗族自治州_贞丰县_',0),(363,'望谟县',357,3,'_贵州_黔西南布依族苗族自治州_望谟县_',0),(364,'册亨县',357,3,'_贵州_黔西南布依族苗族自治州_册亨县_',0),(365,'安龙县',357,3,'_贵州_黔西南布依族苗族自治州_安龙县_',0),(366,'毕节地区',307,2,'_贵州_毕节地区_',0),(367,'毕节市',366,3,'_贵州_毕节地区_毕节市_',0),(368,'大方县',366,3,'_贵州_毕节地区_大方县_',0),(369,'黔西县',366,3,'_贵州_毕节地区_黔西县_',0),(370,'金沙县',366,3,'_贵州_毕节地区_金沙县_',0),(371,'织金县',366,3,'_贵州_毕节地区_织金县_',0),(372,'纳雍县',366,3,'_贵州_毕节地区_纳雍县_',0),(373,'威宁彝族回族苗族自治县',366,3,'_贵州_毕节地区_威宁彝族回族苗族自治县_',0),(374,'赫章县',366,3,'_贵州_毕节地区_赫章县_',0),(375,'黔东南苗族侗族自治州',307,2,'_贵州_黔东南苗族侗族自治州_',0),(376,'凯里市',375,3,'_贵州_黔东南苗族侗族自治州_凯里市_',0),(377,'黄平县',375,3,'_贵州_黔东南苗族侗族自治州_黄平县_',0),(378,'施秉县',375,3,'_贵州_黔东南苗族侗族自治州_施秉县_',0),(379,'三穗县',375,3,'_贵州_黔东南苗族侗族自治州_三穗县_',0),(380,'镇远县',375,3,'_贵州_黔东南苗族侗族自治州_镇远县_',0),(381,'岑巩县',375,3,'_贵州_黔东南苗族侗族自治州_岑巩县_',0),(382,'天柱县',375,3,'_贵州_黔东南苗族侗族自治州_天柱县_',0),(383,'锦屏县',375,3,'_贵州_黔东南苗族侗族自治州_锦屏县_',0),(384,'剑河县',375,3,'_贵州_黔东南苗族侗族自治州_剑河县_',0),(385,'台江县',375,3,'_贵州_黔东南苗族侗族自治州_台江县_',0),(386,'黎平县',375,3,'_贵州_黔东南苗族侗族自治州_黎平县_',0),(387,'榕江县',375,3,'_贵州_黔东南苗族侗族自治州_榕江县_',0),(388,'从江县',375,3,'_贵州_黔东南苗族侗族自治州_从江县_',0),(389,'雷山县',375,3,'_贵州_黔东南苗族侗族自治州_雷山县_',0),(390,'麻江县',375,3,'_贵州_黔东南苗族侗族自治州_麻江县_',0),(391,'丹寨县',375,3,'_贵州_黔东南苗族侗族自治州_丹寨县_',0),(392,'黔南布依族苗族自治州',307,2,'_贵州_黔南布依族苗族自治州_',0),(393,'都匀市',392,3,'_贵州_黔南布依族苗族自治州_都匀市_',0),(394,'福泉市',392,3,'_贵州_黔南布依族苗族自治州_福泉市_',0),(395,'荔波县',392,3,'_贵州_黔南布依族苗族自治州_荔波县_',0),(396,'贵定县',392,3,'_贵州_黔南布依族苗族自治州_贵定县_',0),(397,'瓮安县',392,3,'_贵州_黔南布依族苗族自治州_瓮安县_',0),(398,'独山县',392,3,'_贵州_黔南布依族苗族自治州_独山县_',0),(399,'平塘县',392,3,'_贵州_黔南布依族苗族自治州_平塘县_',0),(400,'罗甸县',392,3,'_贵州_黔南布依族苗族自治州_罗甸县_',0),(401,'长顺县',392,3,'_贵州_黔南布依族苗族自治州_长顺县_',0),(402,'龙里县',392,3,'_贵州_黔南布依族苗族自治州_龙里县_',0),(403,'惠水县',392,3,'_贵州_黔南布依族苗族自治州_惠水县_',0),(404,'三都水族自治县',392,3,'_贵州_黔南布依族苗族自治州_三都水族自治县_',0),(405,'云南',0,1,'_云南_',0),(406,'昆明市',405,2,'_云南_昆明市_',0),(407,'五华区',406,3,'_云南_昆明市_五华区_',0),(408,'盘龙区',406,3,'_云南_昆明市_盘龙区_',0),(409,'官渡区',406,3,'_云南_昆明市_官渡区_',0),(410,'西山区',406,3,'_云南_昆明市_西山区_',0),(411,'东川区',406,3,'_云南_昆明市_东川区_',0),(412,'呈贡县',406,3,'_云南_昆明市_呈贡县_',0),(413,'晋宁县',406,3,'_云南_昆明市_晋宁县_',0),(414,'富民县',406,3,'_云南_昆明市_富民县_',0),(415,'宜良县',406,3,'_云南_昆明市_宜良县_',0),(416,'石林彝族自治县',406,3,'_云南_昆明市_石林彝族自治县_',0),(417,'嵩明县',406,3,'_云南_昆明市_嵩明县_',0),(418,'禄劝彝族苗族自治县',406,3,'_云南_昆明市_禄劝彝族苗族自治县_',0),(419,'寻甸回族彝族自治县',406,3,'_云南_昆明市_寻甸回族彝族自治县_',0),(420,'安宁市',406,3,'_云南_昆明市_安宁市_',0),(421,'曲靖市',405,2,'_云南_曲靖市_',0),(422,'麒麟区',421,3,'_云南_曲靖市_麒麟区_',0),(423,'马龙县',421,3,'_云南_曲靖市_马龙县_',0),(424,'陆良县',421,3,'_云南_曲靖市_陆良县_',0),(425,'师宗县',421,3,'_云南_曲靖市_师宗县_',0),(426,'罗平县',421,3,'_云南_曲靖市_罗平县_',0),(427,'富源县',421,3,'_云南_曲靖市_富源县_',0),(428,'会泽县',421,3,'_云南_曲靖市_会泽县_',0),(429,'沾益县',421,3,'_云南_曲靖市_沾益县_',0),(430,'宣威市',421,3,'_云南_曲靖市_宣威市_',0),(431,'玉溪市',405,2,'_云南_玉溪市_',0),(432,'红塔区',431,3,'_云南_玉溪市_红塔区_',0),(433,'江川县',431,3,'_云南_玉溪市_江川县_',0),(434,'澄江县',431,3,'_云南_玉溪市_澄江县_',0),(435,'通海县',431,3,'_云南_玉溪市_通海县_',0),(436,'华宁县',431,3,'_云南_玉溪市_华宁县_',0),(437,'易门县',431,3,'_云南_玉溪市_易门县_',0),(438,'峨山彝族自治县',431,3,'_云南_玉溪市_峨山彝族自治县_',0),(439,'新平彝族傣族自治县',431,3,'_云南_玉溪市_新平彝族傣族自治县_',0),(440,'元江哈尼族彝族傣族自治县',431,3,'_云南_玉溪市_元江哈尼族彝族傣族自治县_',0),(441,'保山市',405,2,'_云南_保山市_',0),(442,'隆阳区',441,3,'_云南_保山市_隆阳区_',0),(443,'施甸县',441,3,'_云南_保山市_施甸县_',0),(444,'腾冲县',441,3,'_云南_保山市_腾冲县_',0),(445,'龙陵县',441,3,'_云南_保山市_龙陵县_',0),(446,'昌宁县',441,3,'_云南_保山市_昌宁县_',0),(447,'昭通市',405,2,'_云南_昭通市_',0),(448,'昭阳区',447,3,'_云南_昭通市_昭阳区_',0),(449,'鲁甸县',447,3,'_云南_昭通市_鲁甸县_',0),(450,'巧家县',447,3,'_云南_昭通市_巧家县_',0),(451,'盐津县',447,3,'_云南_昭通市_盐津县_',0),(452,'大关县',447,3,'_云南_昭通市_大关县_',0),(453,'永善县',447,3,'_云南_昭通市_永善县_',0),(454,'绥江县',447,3,'_云南_昭通市_绥江县_',0),(455,'镇雄县',447,3,'_云南_昭通市_镇雄县_',0),(456,'彝良县',447,3,'_云南_昭通市_彝良县_',0),(457,'威信县',447,3,'_云南_昭通市_威信县_',0),(458,'水富县',447,3,'_云南_昭通市_水富县_',0),(459,'丽江市',405,2,'_云南_丽江市_',0),(460,'古城区',459,3,'_云南_丽江市_古城区_',0),(461,'玉龙纳西族自治县',459,3,'_云南_丽江市_玉龙纳西族自治县_',0),(462,'永胜县',459,3,'_云南_丽江市_永胜县_',0),(463,'华坪县',459,3,'_云南_丽江市_华坪县_',0),(464,'宁蒗彝族自治县',459,3,'_云南_丽江市_宁蒗彝族自治县_',0),(465,'思茅市',405,2,'_云南_思茅市_',0),(466,'翠云区',465,3,'_云南_思茅市_翠云区_',0),(467,'普洱哈尼族彝族自治县',465,3,'_云南_思茅市_普洱哈尼族彝族自治县_',0),(468,'墨江哈尼族自治县',465,3,'_云南_思茅市_墨江哈尼族自治县_',0),(469,'景东彝族自治县',465,3,'_云南_思茅市_景东彝族自治县_',0),(470,'景谷傣族彝族自治县',465,3,'_云南_思茅市_景谷傣族彝族自治县_',0),(471,'镇沅彝族哈尼族拉祜族自治县',465,3,'_云南_思茅市_镇沅彝族哈尼族拉祜族自治县_',0),(472,'江城哈尼族彝族自治县',465,3,'_云南_思茅市_江城哈尼族彝族自治县_',0),(473,'孟连傣族拉祜族佤族自治县',465,3,'_云南_思茅市_孟连傣族拉祜族佤族自治县_',0),(474,'澜沧拉祜族自治县',465,3,'_云南_思茅市_澜沧拉祜族自治县_',0),(475,'西盟佤族自治县',465,3,'_云南_思茅市_西盟佤族自治县_',0),(476,'临沧市',405,2,'_云南_临沧市_',0),(477,'临翔区',476,3,'_云南_临沧市_临翔区_',0),(478,'凤庆县',476,3,'_云南_临沧市_凤庆县_',0),(479,'云　县',476,3,'_云南_临沧市_云　县_',0),(480,'永德县',476,3,'_云南_临沧市_永德县_',0),(481,'镇康县',476,3,'_云南_临沧市_镇康县_',0),(482,'双江拉祜族佤族布朗族傣族自治县',476,3,'_云南_临沧市_双江拉祜族佤族布朗族傣族自治县_',0),(483,'耿马傣族佤族自治县',476,3,'_云南_临沧市_耿马傣族佤族自治县_',0),(484,'沧源佤族自治县',476,3,'_云南_临沧市_沧源佤族自治县_',0),(485,'楚雄彝族自治州',405,2,'_云南_楚雄彝族自治州_',0),(486,'楚雄市',485,3,'_云南_楚雄彝族自治州_楚雄市_',0),(487,'双柏县',485,3,'_云南_楚雄彝族自治州_双柏县_',0),(488,'牟定县',485,3,'_云南_楚雄彝族自治州_牟定县_',0),(489,'南华县',485,3,'_云南_楚雄彝族自治州_南华县_',0),(490,'姚安县',485,3,'_云南_楚雄彝族自治州_姚安县_',0),(491,'大姚县',485,3,'_云南_楚雄彝族自治州_大姚县_',0),(492,'永仁县',485,3,'_云南_楚雄彝族自治州_永仁县_',0),(493,'元谋县',485,3,'_云南_楚雄彝族自治州_元谋县_',0),(494,'武定县',485,3,'_云南_楚雄彝族自治州_武定县_',0),(495,'禄丰县',485,3,'_云南_楚雄彝族自治州_禄丰县_',0),(496,'红河哈尼族彝族自治州',405,2,'_云南_红河哈尼族彝族自治州_',0),(497,'个旧市',496,3,'_云南_红河哈尼族彝族自治州_个旧市_',0),(498,'开远市',496,3,'_云南_红河哈尼族彝族自治州_开远市_',0),(499,'蒙自县',496,3,'_云南_红河哈尼族彝族自治州_蒙自县_',0),(500,'屏边苗族自治县',496,3,'_云南_红河哈尼族彝族自治州_屏边苗族自治县_',0),(501,'建水县',496,3,'_云南_红河哈尼族彝族自治州_建水县_',0),(502,'石屏县',496,3,'_云南_红河哈尼族彝族自治州_石屏县_',0),(503,'弥勒县',496,3,'_云南_红河哈尼族彝族自治州_弥勒县_',0),(504,'泸西县',496,3,'_云南_红河哈尼族彝族自治州_泸西县_',0),(505,'元阳县',496,3,'_云南_红河哈尼族彝族自治州_元阳县_',0),(506,'红河县',496,3,'_云南_红河哈尼族彝族自治州_红河县_',0),(507,'金平苗族瑶族傣族自治县',496,3,'_云南_红河哈尼族彝族自治州_金平苗族瑶族傣族自治县_',0),(508,'绿春县',496,3,'_云南_红河哈尼族彝族自治州_绿春县_',0),(509,'河口瑶族自治县',496,3,'_云南_红河哈尼族彝族自治州_河口瑶族自治县_',0),(510,'文山壮族苗族自治州',405,2,'_云南_文山壮族苗族自治州_',0),(511,'文山县',510,3,'_云南_文山壮族苗族自治州_文山县_',0),(512,'砚山县',510,3,'_云南_文山壮族苗族自治州_砚山县_',0),(513,'西畴县',510,3,'_云南_文山壮族苗族自治州_西畴县_',0),(514,'麻栗坡县',510,3,'_云南_文山壮族苗族自治州_麻栗坡县_',0),(515,'马关县',510,3,'_云南_文山壮族苗族自治州_马关县_',0),(516,'丘北县',510,3,'_云南_文山壮族苗族自治州_丘北县_',0),(517,'广南县',510,3,'_云南_文山壮族苗族自治州_广南县_',0),(518,'富宁县',510,3,'_云南_文山壮族苗族自治州_富宁县_',0),(519,'西双版纳傣族自治州',405,2,'_云南_西双版纳傣族自治州_',0),(520,'景洪市',519,3,'_云南_西双版纳傣族自治州_景洪市_',0),(521,'勐海县',519,3,'_云南_西双版纳傣族自治州_勐海县_',0),(522,'勐腊县',519,3,'_云南_西双版纳傣族自治州_勐腊县_',0),(523,'大理白族自治州',405,2,'_云南_大理白族自治州_',0),(524,'大理市',523,3,'_云南_大理白族自治州_大理市_',0),(525,'漾濞彝族自治县',523,3,'_云南_大理白族自治州_漾濞彝族自治县_',0),(526,'祥云县',523,3,'_云南_大理白族自治州_祥云县_',0),(527,'宾川县',523,3,'_云南_大理白族自治州_宾川县_',0),(528,'弥渡县',523,3,'_云南_大理白族自治州_弥渡县_',0),(529,'南涧彝族自治县',523,3,'_云南_大理白族自治州_南涧彝族自治县_',0),(530,'巍山彝族回族自治县',523,3,'_云南_大理白族自治州_巍山彝族回族自治县_',0),(531,'永平县',523,3,'_云南_大理白族自治州_永平县_',0),(532,'云龙县',523,3,'_云南_大理白族自治州_云龙县_',0),(533,'洱源县',523,3,'_云南_大理白族自治州_洱源县_',0),(534,'剑川县',523,3,'_云南_大理白族自治州_剑川县_',0),(535,'鹤庆县',523,3,'_云南_大理白族自治州_鹤庆县_',0),(536,'德宏傣族景颇族自治州',405,2,'_云南_德宏傣族景颇族自治州_',0),(537,'瑞丽市',536,3,'_云南_德宏傣族景颇族自治州_瑞丽市_',0),(538,'潞西市',536,3,'_云南_德宏傣族景颇族自治州_潞西市_',0),(539,'梁河县',536,3,'_云南_德宏傣族景颇族自治州_梁河县_',0),(540,'盈江县',536,3,'_云南_德宏傣族景颇族自治州_盈江县_',0),(541,'陇川县',536,3,'_云南_德宏傣族景颇族自治州_陇川县_',0),(542,'怒江傈僳族自治州',405,2,'_云南_怒江傈僳族自治州_',0),(543,'泸水县',542,3,'_云南_怒江傈僳族自治州_泸水县_',0),(544,'福贡县',542,3,'_云南_怒江傈僳族自治州_福贡县_',0),(545,'贡山独龙族怒族自治县',542,3,'_云南_怒江傈僳族自治州_贡山独龙族怒族自治县_',0),(546,'兰坪白族普米族自治县',542,3,'_云南_怒江傈僳族自治州_兰坪白族普米族自治县_',0),(547,'迪庆藏族自治州',405,2,'_云南_迪庆藏族自治州_',0),(548,'香格里拉县',547,3,'_云南_迪庆藏族自治州_香格里拉县_',0),(549,'德钦县',547,3,'_云南_迪庆藏族自治州_德钦县_',0),(550,'维西傈僳族自治县',547,3,'_云南_迪庆藏族自治州_维西傈僳族自治县_',0),(551,'西藏',0,1,'_西藏_',0),(552,'拉萨市',551,2,'_西藏_拉萨市_',0),(553,'城关区',552,3,'_西藏_拉萨市_城关区_',0),(554,'林周县',552,3,'_西藏_拉萨市_林周县_',0),(555,'当雄县',552,3,'_西藏_拉萨市_当雄县_',0),(556,'尼木县',552,3,'_西藏_拉萨市_尼木县_',0),(557,'曲水县',552,3,'_西藏_拉萨市_曲水县_',0),(558,'堆龙德庆县',552,3,'_西藏_拉萨市_堆龙德庆县_',0),(559,'达孜县',552,3,'_西藏_拉萨市_达孜县_',0),(560,'墨竹工卡县',552,3,'_西藏_拉萨市_墨竹工卡县_',0),(561,'昌都地区',551,2,'_西藏_昌都地区_',0),(562,'昌都县',561,3,'_西藏_昌都地区_昌都县_',0),(563,'江达县',561,3,'_西藏_昌都地区_江达县_',0),(564,'贡觉县',561,3,'_西藏_昌都地区_贡觉县_',0),(565,'类乌齐县',561,3,'_西藏_昌都地区_类乌齐县_',0),(566,'丁青县',561,3,'_西藏_昌都地区_丁青县_',0),(567,'察雅县',561,3,'_西藏_昌都地区_察雅县_',0),(568,'八宿县',561,3,'_西藏_昌都地区_八宿县_',0),(569,'左贡县',561,3,'_西藏_昌都地区_左贡县_',0),(570,'芒康县',561,3,'_西藏_昌都地区_芒康县_',0),(571,'洛隆县',561,3,'_西藏_昌都地区_洛隆县_',0),(572,'边坝县',561,3,'_西藏_昌都地区_边坝县_',0),(573,'山南地区',551,2,'_西藏_山南地区_',0),(574,'乃东县',573,3,'_西藏_山南地区_乃东县_',0),(575,'扎囊县',573,3,'_西藏_山南地区_扎囊县_',0),(576,'贡嘎县',573,3,'_西藏_山南地区_贡嘎县_',0),(577,'桑日县',573,3,'_西藏_山南地区_桑日县_',0),(578,'琼结县',573,3,'_西藏_山南地区_琼结县_',0),(579,'曲松县',573,3,'_西藏_山南地区_曲松县_',0),(580,'措美县',573,3,'_西藏_山南地区_措美县_',0),(581,'洛扎县',573,3,'_西藏_山南地区_洛扎县_',0),(582,'加查县',573,3,'_西藏_山南地区_加查县_',0),(583,'隆子县',573,3,'_西藏_山南地区_隆子县_',0),(584,'错那县',573,3,'_西藏_山南地区_错那县_',0),(585,'浪卡子县',573,3,'_西藏_山南地区_浪卡子县_',0),(586,'日喀则地区',551,2,'_西藏_日喀则地区_',0),(587,'日喀则市',586,3,'_西藏_日喀则地区_日喀则市_',0),(588,'南木林县',586,3,'_西藏_日喀则地区_南木林县_',0),(589,'江孜县',586,3,'_西藏_日喀则地区_江孜县_',0),(590,'定日县',586,3,'_西藏_日喀则地区_定日县_',0),(591,'萨迦县',586,3,'_西藏_日喀则地区_萨迦县_',0),(592,'拉孜县',586,3,'_西藏_日喀则地区_拉孜县_',0),(593,'昂仁县',586,3,'_西藏_日喀则地区_昂仁县_',0),(594,'谢通门县',586,3,'_西藏_日喀则地区_谢通门县_',0),(595,'白朗县',586,3,'_西藏_日喀则地区_白朗县_',0),(596,'仁布县',586,3,'_西藏_日喀则地区_仁布县_',0),(597,'康马县',586,3,'_西藏_日喀则地区_康马县_',0),(598,'定结县',586,3,'_西藏_日喀则地区_定结县_',0),(599,'仲巴县',586,3,'_西藏_日喀则地区_仲巴县_',0),(600,'亚东县',586,3,'_西藏_日喀则地区_亚东县_',0),(601,'吉隆县',586,3,'_西藏_日喀则地区_吉隆县_',0),(602,'聂拉木县',586,3,'_西藏_日喀则地区_聂拉木县_',0),(603,'萨嘎县',586,3,'_西藏_日喀则地区_萨嘎县_',0),(604,'岗巴县',586,3,'_西藏_日喀则地区_岗巴县_',0),(605,'那曲地区',551,2,'_西藏_那曲地区_',0),(606,'那曲县',605,3,'_西藏_那曲地区_那曲县_',0),(607,'嘉黎县',605,3,'_西藏_那曲地区_嘉黎县_',0),(608,'比如县',605,3,'_西藏_那曲地区_比如县_',0),(609,'聂荣县',605,3,'_西藏_那曲地区_聂荣县_',0),(610,'安多县',605,3,'_西藏_那曲地区_安多县_',0),(611,'申扎县',605,3,'_西藏_那曲地区_申扎县_',0),(612,'索　县',605,3,'_西藏_那曲地区_索　县_',0),(613,'班戈县',605,3,'_西藏_那曲地区_班戈县_',0),(614,'巴青县',605,3,'_西藏_那曲地区_巴青县_',0),(615,'尼玛县',605,3,'_西藏_那曲地区_尼玛县_',0),(616,'阿里地区',551,2,'_西藏_阿里地区_',0),(617,'普兰县',616,3,'_西藏_阿里地区_普兰县_',0),(618,'札达县',616,3,'_西藏_阿里地区_札达县_',0),(619,'噶尔县',616,3,'_西藏_阿里地区_噶尔县_',0),(620,'日土县',616,3,'_西藏_阿里地区_日土县_',0),(621,'革吉县',616,3,'_西藏_阿里地区_革吉县_',0),(622,'改则县',616,3,'_西藏_阿里地区_改则县_',0),(623,'措勤县',616,3,'_西藏_阿里地区_措勤县_',0),(624,'林芝地区',551,2,'_西藏_林芝地区_',0),(625,'林芝县',624,3,'_西藏_林芝地区_林芝县_',0),(626,'工布江达县',624,3,'_西藏_林芝地区_工布江达县_',0),(627,'米林县',624,3,'_西藏_林芝地区_米林县_',0),(628,'墨脱县',624,3,'_西藏_林芝地区_墨脱县_',0),(629,'波密县',624,3,'_西藏_林芝地区_波密县_',0),(630,'察隅县',624,3,'_西藏_林芝地区_察隅县_',0),(631,'朗　县',624,3,'_西藏_林芝地区_朗　县_',0),(632,'河南',0,1,'_河南_',0),(633,'郑州市',632,2,'_河南_郑州市_',0),(634,'中原区',633,3,'_河南_郑州市_中原区_',0),(635,'二七区',633,3,'_河南_郑州市_二七区_',0),(636,'管城回族区',633,3,'_河南_郑州市_管城回族区_',0),(637,'金水区',633,3,'_河南_郑州市_金水区_',0),(638,'上街区',633,3,'_河南_郑州市_上街区_',0),(639,'邙山区',633,3,'_河南_郑州市_邙山区_',0),(640,'中牟县',633,3,'_河南_郑州市_中牟县_',0),(641,'巩义市',633,3,'_河南_郑州市_巩义市_',0),(642,'荥阳市',633,3,'_河南_郑州市_荥阳市_',0),(643,'新密市',633,3,'_河南_郑州市_新密市_',0),(644,'新郑市',633,3,'_河南_郑州市_新郑市_',0),(645,'登封市',633,3,'_河南_郑州市_登封市_',0),(646,'开封市',632,2,'_河南_开封市_',0),(647,'龙亭区',646,3,'_河南_开封市_龙亭区_',0),(648,'顺河回族区',646,3,'_河南_开封市_顺河回族区_',0),(649,'鼓楼区',646,3,'_河南_开封市_鼓楼区_',0),(650,'南关区',646,3,'_河南_开封市_南关区_',0),(651,'郊　区',646,3,'_河南_开封市_郊　区_',0),(652,'杞　县',646,3,'_河南_开封市_杞　县_',0),(653,'通许县',646,3,'_河南_开封市_通许县_',0),(654,'尉氏县',646,3,'_河南_开封市_尉氏县_',0),(655,'开封县',646,3,'_河南_开封市_开封县_',0),(656,'兰考县',646,3,'_河南_开封市_兰考县_',0),(657,'洛阳市',632,2,'_河南_洛阳市_',0),(658,'老城区',657,3,'_河南_洛阳市_老城区_',0),(659,'西工区',657,3,'_河南_洛阳市_西工区_',0),(660,'廛河回族区',657,3,'_河南_洛阳市_廛河回族区_',0),(661,'涧西区',657,3,'_河南_洛阳市_涧西区_',0),(662,'吉利区',657,3,'_河南_洛阳市_吉利区_',0),(663,'洛龙区',657,3,'_河南_洛阳市_洛龙区_',0),(664,'孟津县',657,3,'_河南_洛阳市_孟津县_',0),(665,'新安县',657,3,'_河南_洛阳市_新安县_',0),(666,'栾川县',657,3,'_河南_洛阳市_栾川县_',0),(667,'嵩　县',657,3,'_河南_洛阳市_嵩　县_',0),(668,'汝阳县',657,3,'_河南_洛阳市_汝阳县_',0),(669,'宜阳县',657,3,'_河南_洛阳市_宜阳县_',0),(670,'洛宁县',657,3,'_河南_洛阳市_洛宁县_',0),(671,'伊川县',657,3,'_河南_洛阳市_伊川县_',0),(672,'偃师市',657,3,'_河南_洛阳市_偃师市_',0),(673,'平顶山市',632,2,'_河南_平顶山市_',0),(674,'新华区',673,3,'_河南_平顶山市_新华区_',0),(675,'卫东区',673,3,'_河南_平顶山市_卫东区_',0),(676,'石龙区',673,3,'_河南_平顶山市_石龙区_',0),(677,'湛河区',673,3,'_河南_平顶山市_湛河区_',0),(678,'宝丰县',673,3,'_河南_平顶山市_宝丰县_',0),(679,'叶　县',673,3,'_河南_平顶山市_叶　县_',0),(680,'鲁山县',673,3,'_河南_平顶山市_鲁山县_',0),(681,'郏　县',673,3,'_河南_平顶山市_郏　县_',0),(682,'舞钢市',673,3,'_河南_平顶山市_舞钢市_',0),(683,'汝州市',673,3,'_河南_平顶山市_汝州市_',0),(684,'安阳市',632,2,'_河南_安阳市_',0),(685,'文峰区',684,3,'_河南_安阳市_文峰区_',0),(686,'北关区',684,3,'_河南_安阳市_北关区_',0),(687,'殷都区',684,3,'_河南_安阳市_殷都区_',0),(688,'龙安区',684,3,'_河南_安阳市_龙安区_',0),(689,'安阳县',684,3,'_河南_安阳市_安阳县_',0),(690,'汤阴县',684,3,'_河南_安阳市_汤阴县_',0),(691,'滑　县',684,3,'_河南_安阳市_滑　县_',0),(692,'内黄县',684,3,'_河南_安阳市_内黄县_',0),(693,'林州市',684,3,'_河南_安阳市_林州市_',0),(694,'鹤壁市',632,2,'_河南_鹤壁市_',0),(695,'鹤山区',694,3,'_河南_鹤壁市_鹤山区_',0),(696,'山城区',694,3,'_河南_鹤壁市_山城区_',0),(697,'淇滨区',694,3,'_河南_鹤壁市_淇滨区_',0),(698,'浚　县',694,3,'_河南_鹤壁市_浚　县_',0),(699,'淇　县',694,3,'_河南_鹤壁市_淇　县_',0),(700,'新乡市',632,2,'_河南_新乡市_',0),(701,'红旗区',700,3,'_河南_新乡市_红旗区_',0),(702,'卫滨区',700,3,'_河南_新乡市_卫滨区_',0),(703,'凤泉区',700,3,'_河南_新乡市_凤泉区_',0),(704,'牧野区',700,3,'_河南_新乡市_牧野区_',0),(705,'新乡县',700,3,'_河南_新乡市_新乡县_',0),(706,'获嘉县',700,3,'_河南_新乡市_获嘉县_',0),(707,'原阳县',700,3,'_河南_新乡市_原阳县_',0),(708,'延津县',700,3,'_河南_新乡市_延津县_',0),(709,'封丘县',700,3,'_河南_新乡市_封丘县_',0),(710,'长垣县',700,3,'_河南_新乡市_长垣县_',0),(711,'卫辉市',700,3,'_河南_新乡市_卫辉市_',0),(712,'辉县市',700,3,'_河南_新乡市_辉县市_',0),(713,'焦作市',632,2,'_河南_焦作市_',0),(714,'解放区',713,3,'_河南_焦作市_解放区_',0),(715,'中站区',713,3,'_河南_焦作市_中站区_',0),(716,'马村区',713,3,'_河南_焦作市_马村区_',0),(717,'山阳区',713,3,'_河南_焦作市_山阳区_',0),(718,'修武县',713,3,'_河南_焦作市_修武县_',0),(719,'博爱县',713,3,'_河南_焦作市_博爱县_',0),(720,'武陟县',713,3,'_河南_焦作市_武陟县_',0),(721,'温　县',713,3,'_河南_焦作市_温　县_',0),(722,'济源市',713,3,'_河南_焦作市_济源市_',0),(723,'沁阳市',713,3,'_河南_焦作市_沁阳市_',0),(724,'孟州市',713,3,'_河南_焦作市_孟州市_',0),(725,'濮阳市',632,2,'_河南_濮阳市_',0),(726,'华龙区',725,3,'_河南_濮阳市_华龙区_',0),(727,'清丰县',725,3,'_河南_濮阳市_清丰县_',0),(728,'南乐县',725,3,'_河南_濮阳市_南乐县_',0),(729,'范　县',725,3,'_河南_濮阳市_范　县_',0),(730,'台前县',725,3,'_河南_濮阳市_台前县_',0),(731,'濮阳县',725,3,'_河南_濮阳市_濮阳县_',0),(732,'许昌市',632,2,'_河南_许昌市_',0),(733,'魏都区',732,3,'_河南_许昌市_魏都区_',0),(734,'许昌县',732,3,'_河南_许昌市_许昌县_',0),(735,'鄢陵县',732,3,'_河南_许昌市_鄢陵县_',0),(736,'襄城县',732,3,'_河南_许昌市_襄城县_',0),(737,'禹州市',732,3,'_河南_许昌市_禹州市_',0),(738,'长葛市',732,3,'_河南_许昌市_长葛市_',0),(739,'漯河市',632,2,'_河南_漯河市_',0),(740,'源汇区',739,3,'_河南_漯河市_源汇区_',0),(741,'郾城区',739,3,'_河南_漯河市_郾城区_',0),(742,'召陵区',739,3,'_河南_漯河市_召陵区_',0),(743,'舞阳县',739,3,'_河南_漯河市_舞阳县_',0),(744,'临颍县',739,3,'_河南_漯河市_临颍县_',0),(745,'三门峡市',632,2,'_河南_三门峡市_',0),(746,'湖滨区',745,3,'_河南_三门峡市_湖滨区_',0),(747,'渑池县',745,3,'_河南_三门峡市_渑池县_',0),(748,'陕　县',745,3,'_河南_三门峡市_陕　县_',0),(749,'卢氏县',745,3,'_河南_三门峡市_卢氏县_',0),(750,'义马市',745,3,'_河南_三门峡市_义马市_',0),(751,'灵宝市',745,3,'_河南_三门峡市_灵宝市_',0),(752,'南阳市',632,2,'_河南_南阳市_',0),(753,'宛城区',752,3,'_河南_南阳市_宛城区_',0),(754,'卧龙区',752,3,'_河南_南阳市_卧龙区_',0),(755,'南召县',752,3,'_河南_南阳市_南召县_',0),(756,'方城县',752,3,'_河南_南阳市_方城县_',0),(757,'西峡县',752,3,'_河南_南阳市_西峡县_',0),(758,'镇平县',752,3,'_河南_南阳市_镇平县_',0),(759,'内乡县',752,3,'_河南_南阳市_内乡县_',0),(760,'淅川县',752,3,'_河南_南阳市_淅川县_',0),(761,'社旗县',752,3,'_河南_南阳市_社旗县_',0),(762,'唐河县',752,3,'_河南_南阳市_唐河县_',0),(763,'新野县',752,3,'_河南_南阳市_新野县_',0),(764,'桐柏县',752,3,'_河南_南阳市_桐柏县_',0),(765,'邓州市',752,3,'_河南_南阳市_邓州市_',0),(766,'商丘市',632,2,'_河南_商丘市_',0),(767,'梁园区',766,3,'_河南_商丘市_梁园区_',0),(768,'睢阳区',766,3,'_河南_商丘市_睢阳区_',0),(769,'民权县',766,3,'_河南_商丘市_民权县_',0),(770,'睢　县',766,3,'_河南_商丘市_睢　县_',0),(771,'宁陵县',766,3,'_河南_商丘市_宁陵县_',0),(772,'柘城县',766,3,'_河南_商丘市_柘城县_',0),(773,'虞城县',766,3,'_河南_商丘市_虞城县_',0),(774,'夏邑县',766,3,'_河南_商丘市_夏邑县_',0),(775,'永城市',766,3,'_河南_商丘市_永城市_',0),(776,'信阳市',632,2,'_河南_信阳市_',0),(777,'师河区',776,3,'_河南_信阳市_师河区_',0),(778,'平桥区',776,3,'_河南_信阳市_平桥区_',0),(779,'罗山县',776,3,'_河南_信阳市_罗山县_',0),(780,'光山县',776,3,'_河南_信阳市_光山县_',0),(781,'新　县',776,3,'_河南_信阳市_新　县_',0),(782,'商城县',776,3,'_河南_信阳市_商城县_',0),(783,'固始县',776,3,'_河南_信阳市_固始县_',0),(784,'潢川县',776,3,'_河南_信阳市_潢川县_',0),(785,'淮滨县',776,3,'_河南_信阳市_淮滨县_',0),(786,'息　县',776,3,'_河南_信阳市_息　县_',0),(787,'周口市',632,2,'_河南_周口市_',0),(788,'川汇区',787,3,'_河南_周口市_川汇区_',0),(789,'扶沟县',787,3,'_河南_周口市_扶沟县_',0),(790,'西华县',787,3,'_河南_周口市_西华县_',0),(791,'商水县',787,3,'_河南_周口市_商水县_',0),(792,'沈丘县',787,3,'_河南_周口市_沈丘县_',0),(793,'郸城县',787,3,'_河南_周口市_郸城县_',0),(794,'淮阳县',787,3,'_河南_周口市_淮阳县_',0),(795,'太康县',787,3,'_河南_周口市_太康县_',0),(796,'鹿邑县',787,3,'_河南_周口市_鹿邑县_',0),(797,'项城市',787,3,'_河南_周口市_项城市_',0),(798,'驻马店市',632,2,'_河南_驻马店市_',0),(799,'驿城区',798,3,'_河南_驻马店市_驿城区_',0),(800,'西平县',798,3,'_河南_驻马店市_西平县_',0),(801,'上蔡县',798,3,'_河南_驻马店市_上蔡县_',0),(802,'平舆县',798,3,'_河南_驻马店市_平舆县_',0),(803,'正阳县',798,3,'_河南_驻马店市_正阳县_',0),(804,'确山县',798,3,'_河南_驻马店市_确山县_',0),(805,'泌阳县',798,3,'_河南_驻马店市_泌阳县_',0),(806,'汝南县',798,3,'_河南_驻马店市_汝南县_',0),(807,'遂平县',798,3,'_河南_驻马店市_遂平县_',0),(808,'新蔡县',798,3,'_河南_驻马店市_新蔡县_',0),(809,'湖北',0,1,'_湖北_',0),(810,'武汉市',809,2,'_湖北_武汉市_',0),(811,'江岸区',810,3,'_湖北_武汉市_江岸区_',0),(812,'江汉区',810,3,'_湖北_武汉市_江汉区_',0),(813,'乔口区',810,3,'_湖北_武汉市_乔口区_',0),(814,'汉阳区',810,3,'_湖北_武汉市_汉阳区_',0),(815,'武昌区',810,3,'_湖北_武汉市_武昌区_',0),(816,'青山区',810,3,'_湖北_武汉市_青山区_',0),(817,'洪山区',810,3,'_湖北_武汉市_洪山区_',0),(818,'东西湖区',810,3,'_湖北_武汉市_东西湖区_',0),(819,'汉南区',810,3,'_湖北_武汉市_汉南区_',0),(820,'蔡甸区',810,3,'_湖北_武汉市_蔡甸区_',0),(821,'江夏区',810,3,'_湖北_武汉市_江夏区_',0),(822,'黄陂区',810,3,'_湖北_武汉市_黄陂区_',0),(823,'新洲区',810,3,'_湖北_武汉市_新洲区_',0),(824,'黄石市',809,2,'_湖北_黄石市_',0),(825,'黄石港区',824,3,'_湖北_黄石市_黄石港区_',0),(826,'西塞山区',824,3,'_湖北_黄石市_西塞山区_',0),(827,'下陆区',824,3,'_湖北_黄石市_下陆区_',0),(828,'铁山区',824,3,'_湖北_黄石市_铁山区_',0),(829,'阳新县',824,3,'_湖北_黄石市_阳新县_',0),(830,'大冶市',824,3,'_湖北_黄石市_大冶市_',0),(831,'十堰市',809,2,'_湖北_十堰市_',0),(832,'茅箭区',831,3,'_湖北_十堰市_茅箭区_',0),(833,'张湾区',831,3,'_湖北_十堰市_张湾区_',0),(834,'郧　县',831,3,'_湖北_十堰市_郧　县_',0),(835,'郧西县',831,3,'_湖北_十堰市_郧西县_',0),(836,'竹山县',831,3,'_湖北_十堰市_竹山县_',0),(837,'竹溪县',831,3,'_湖北_十堰市_竹溪县_',0),(838,'房　县',831,3,'_湖北_十堰市_房　县_',0),(839,'丹江口市',831,3,'_湖北_十堰市_丹江口市_',0),(840,'宜昌市',809,2,'_湖北_宜昌市_',0),(841,'西陵区',840,3,'_湖北_宜昌市_西陵区_',0),(842,'伍家岗区',840,3,'_湖北_宜昌市_伍家岗区_',0),(843,'点军区',840,3,'_湖北_宜昌市_点军区_',0),(844,'猇亭区',840,3,'_湖北_宜昌市_猇亭区_',0),(845,'夷陵区',840,3,'_湖北_宜昌市_夷陵区_',0),(846,'远安县',840,3,'_湖北_宜昌市_远安县_',0),(847,'兴山县',840,3,'_湖北_宜昌市_兴山县_',0),(848,'秭归县',840,3,'_湖北_宜昌市_秭归县_',0),(849,'长阳土家族自治县',840,3,'_湖北_宜昌市_长阳土家族自治县_',0),(850,'五峰土家族自治县',840,3,'_湖北_宜昌市_五峰土家族自治县_',0),(851,'宜都市',840,3,'_湖北_宜昌市_宜都市_',0),(852,'当阳市',840,3,'_湖北_宜昌市_当阳市_',0),(853,'枝江市',840,3,'_湖北_宜昌市_枝江市_',0),(854,'襄樊市',809,2,'_湖北_襄樊市_',0),(855,'襄城区',854,3,'_湖北_襄樊市_襄城区_',0),(856,'樊城区',854,3,'_湖北_襄樊市_樊城区_',0),(857,'襄阳区',854,3,'_湖北_襄樊市_襄阳区_',0),(858,'南漳县',854,3,'_湖北_襄樊市_南漳县_',0),(859,'谷城县',854,3,'_湖北_襄樊市_谷城县_',0),(860,'保康县',854,3,'_湖北_襄樊市_保康县_',0),(861,'老河口市',854,3,'_湖北_襄樊市_老河口市_',0),(862,'枣阳市',854,3,'_湖北_襄樊市_枣阳市_',0),(863,'宜城市',854,3,'_湖北_襄樊市_宜城市_',0),(864,'鄂州市',809,2,'_湖北_鄂州市_',0),(865,'梁子湖区',864,3,'_湖北_鄂州市_梁子湖区_',0),(866,'华容区',864,3,'_湖北_鄂州市_华容区_',0),(867,'鄂城区',864,3,'_湖北_鄂州市_鄂城区_',0),(868,'荆门市',809,2,'_湖北_荆门市_',0),(869,'东宝区',868,3,'_湖北_荆门市_东宝区_',0),(870,'掇刀区',868,3,'_湖北_荆门市_掇刀区_',0),(871,'京山县',868,3,'_湖北_荆门市_京山县_',0),(872,'沙洋县',868,3,'_湖北_荆门市_沙洋县_',0),(873,'钟祥市',868,3,'_湖北_荆门市_钟祥市_',0),(874,'孝感市',809,2,'_湖北_孝感市_',0),(875,'孝南区',874,3,'_湖北_孝感市_孝南区_',0),(876,'孝昌县',874,3,'_湖北_孝感市_孝昌县_',0),(877,'大悟县',874,3,'_湖北_孝感市_大悟县_',0),(878,'云梦县',874,3,'_湖北_孝感市_云梦县_',0),(879,'应城市',874,3,'_湖北_孝感市_应城市_',0),(880,'安陆市',874,3,'_湖北_孝感市_安陆市_',0),(881,'汉川市',874,3,'_湖北_孝感市_汉川市_',0),(882,'荆州市',809,2,'_湖北_荆州市_',0),(883,'沙市区',882,3,'_湖北_荆州市_沙市区_',0),(884,'荆州区',882,3,'_湖北_荆州市_荆州区_',0),(885,'公安县',882,3,'_湖北_荆州市_公安县_',0),(886,'监利县',882,3,'_湖北_荆州市_监利县_',0),(887,'江陵县',882,3,'_湖北_荆州市_江陵县_',0),(888,'石首市',882,3,'_湖北_荆州市_石首市_',0),(889,'洪湖市',882,3,'_湖北_荆州市_洪湖市_',0),(890,'松滋市',882,3,'_湖北_荆州市_松滋市_',0),(891,'黄冈市',809,2,'_湖北_黄冈市_',0),(892,'黄州区',891,3,'_湖北_黄冈市_黄州区_',0),(893,'团风县',891,3,'_湖北_黄冈市_团风县_',0),(894,'红安县',891,3,'_湖北_黄冈市_红安县_',0),(895,'罗田县',891,3,'_湖北_黄冈市_罗田县_',0),(896,'英山县',891,3,'_湖北_黄冈市_英山县_',0),(897,'浠水县',891,3,'_湖北_黄冈市_浠水县_',0),(898,'蕲春县',891,3,'_湖北_黄冈市_蕲春县_',0),(899,'黄梅县',891,3,'_湖北_黄冈市_黄梅县_',0),(900,'麻城市',891,3,'_湖北_黄冈市_麻城市_',0),(901,'武穴市',891,3,'_湖北_黄冈市_武穴市_',0),(902,'咸宁市',809,2,'_湖北_咸宁市_',0),(903,'咸安区',902,3,'_湖北_咸宁市_咸安区_',0),(904,'嘉鱼县',902,3,'_湖北_咸宁市_嘉鱼县_',0),(905,'通城县',902,3,'_湖北_咸宁市_通城县_',0),(906,'崇阳县',902,3,'_湖北_咸宁市_崇阳县_',0),(907,'通山县',902,3,'_湖北_咸宁市_通山县_',0),(908,'赤壁市',902,3,'_湖北_咸宁市_赤壁市_',0),(909,'随州市',809,2,'_湖北_随州市_',0),(910,'曾都区',909,3,'_湖北_随州市_曾都区_',0),(911,'广水市',909,3,'_湖北_随州市_广水市_',0),(912,'恩施土家族苗族自治州',809,2,'_湖北_恩施土家族苗族自治州_',0),(913,'恩施市',912,3,'_湖北_恩施土家族苗族自治州_恩施市_',0),(914,'利川市',912,3,'_湖北_恩施土家族苗族自治州_利川市_',0),(915,'建始县',912,3,'_湖北_恩施土家族苗族自治州_建始县_',0),(916,'巴东县',912,3,'_湖北_恩施土家族苗族自治州_巴东县_',0),(917,'宣恩县',912,3,'_湖北_恩施土家族苗族自治州_宣恩县_',0),(918,'咸丰县',912,3,'_湖北_恩施土家族苗族自治州_咸丰县_',0),(919,'来凤县',912,3,'_湖北_恩施土家族苗族自治州_来凤县_',0),(920,'鹤峰县',912,3,'_湖北_恩施土家族苗族自治州_鹤峰县_',0),(921,'省直辖行政单位',809,2,'_湖北_省直辖行政单位_',0),(922,'仙桃市',921,3,'_湖北_省直辖行政单位_仙桃市_',0),(923,'潜江市',921,3,'_湖北_省直辖行政单位_潜江市_',0),(924,'天门市',921,3,'_湖北_省直辖行政单位_天门市_',0),(925,'神农架林区',921,3,'_湖北_省直辖行政单位_神农架林区_',0),(926,'湖南',0,1,'_湖南_',0),(927,'长沙市',926,2,'_湖南_长沙市_',0),(928,'芙蓉区',927,3,'_湖南_长沙市_芙蓉区_',0),(929,'天心区',927,3,'_湖南_长沙市_天心区_',0),(930,'岳麓区',927,3,'_湖南_长沙市_岳麓区_',0),(931,'开福区',927,3,'_湖南_长沙市_开福区_',0),(932,'雨花区',927,3,'_湖南_长沙市_雨花区_',0),(933,'长沙县',927,3,'_湖南_长沙市_长沙县_',0),(934,'望城县',927,3,'_湖南_长沙市_望城县_',0),(935,'宁乡县',927,3,'_湖南_长沙市_宁乡县_',0),(936,'浏阳市',927,3,'_湖南_长沙市_浏阳市_',0),(937,'株洲市',926,2,'_湖南_株洲市_',0),(938,'荷塘区',937,3,'_湖南_株洲市_荷塘区_',0),(939,'芦淞区',937,3,'_湖南_株洲市_芦淞区_',0),(940,'石峰区',937,3,'_湖南_株洲市_石峰区_',0),(941,'天元区',937,3,'_湖南_株洲市_天元区_',0),(942,'株洲县',937,3,'_湖南_株洲市_株洲县_',0),(943,'攸　县',937,3,'_湖南_株洲市_攸　县_',0),(944,'茶陵县',937,3,'_湖南_株洲市_茶陵县_',0),(945,'炎陵县',937,3,'_湖南_株洲市_炎陵县_',0),(946,'醴陵市',937,3,'_湖南_株洲市_醴陵市_',0),(947,'湘潭市',926,2,'_湖南_湘潭市_',0),(948,'雨湖区',947,3,'_湖南_湘潭市_雨湖区_',0),(949,'岳塘区',947,3,'_湖南_湘潭市_岳塘区_',0),(950,'湘潭县',947,3,'_湖南_湘潭市_湘潭县_',0),(951,'湘乡市',947,3,'_湖南_湘潭市_湘乡市_',0),(952,'韶山市',947,3,'_湖南_湘潭市_韶山市_',0),(953,'衡阳市',926,2,'_湖南_衡阳市_',0),(954,'珠晖区',953,3,'_湖南_衡阳市_珠晖区_',0),(955,'雁峰区',953,3,'_湖南_衡阳市_雁峰区_',0),(956,'石鼓区',953,3,'_湖南_衡阳市_石鼓区_',0),(957,'蒸湘区',953,3,'_湖南_衡阳市_蒸湘区_',0),(958,'南岳区',953,3,'_湖南_衡阳市_南岳区_',0),(959,'衡阳县',953,3,'_湖南_衡阳市_衡阳县_',0),(960,'衡南县',953,3,'_湖南_衡阳市_衡南县_',0),(961,'衡山县',953,3,'_湖南_衡阳市_衡山县_',0),(962,'衡东县',953,3,'_湖南_衡阳市_衡东县_',0),(963,'祁东县',953,3,'_湖南_衡阳市_祁东县_',0),(964,'耒阳市',953,3,'_湖南_衡阳市_耒阳市_',0),(965,'常宁市',953,3,'_湖南_衡阳市_常宁市_',0),(966,'邵阳市',926,2,'_湖南_邵阳市_',0),(967,'双清区',966,3,'_湖南_邵阳市_双清区_',0),(968,'大祥区',966,3,'_湖南_邵阳市_大祥区_',0),(969,'北塔区',966,3,'_湖南_邵阳市_北塔区_',0),(970,'邵东县',966,3,'_湖南_邵阳市_邵东县_',0),(971,'新邵县',966,3,'_湖南_邵阳市_新邵县_',0),(972,'邵阳县',966,3,'_湖南_邵阳市_邵阳县_',0),(973,'隆回县',966,3,'_湖南_邵阳市_隆回县_',0),(974,'洞口县',966,3,'_湖南_邵阳市_洞口县_',0),(975,'绥宁县',966,3,'_湖南_邵阳市_绥宁县_',0),(976,'新宁县',966,3,'_湖南_邵阳市_新宁县_',0),(977,'城步苗族自治县',966,3,'_湖南_邵阳市_城步苗族自治县_',0),(978,'武冈市',966,3,'_湖南_邵阳市_武冈市_',0),(979,'岳阳市',926,2,'_湖南_岳阳市_',0),(980,'岳阳楼区',979,3,'_湖南_岳阳市_岳阳楼区_',0),(981,'云溪区',979,3,'_湖南_岳阳市_云溪区_',0),(982,'君山区',979,3,'_湖南_岳阳市_君山区_',0),(983,'岳阳县',979,3,'_湖南_岳阳市_岳阳县_',0),(984,'华容县',979,3,'_湖南_岳阳市_华容县_',0),(985,'湘阴县',979,3,'_湖南_岳阳市_湘阴县_',0),(986,'平江县',979,3,'_湖南_岳阳市_平江县_',0),(987,'汨罗市',979,3,'_湖南_岳阳市_汨罗市_',0),(988,'临湘市',979,3,'_湖南_岳阳市_临湘市_',0),(989,'常德市',926,2,'_湖南_常德市_',0),(990,'武陵区',989,3,'_湖南_常德市_武陵区_',0),(991,'鼎城区',989,3,'_湖南_常德市_鼎城区_',0),(992,'安乡县',989,3,'_湖南_常德市_安乡县_',0),(993,'汉寿县',989,3,'_湖南_常德市_汉寿县_',0),(994,'澧　县',989,3,'_湖南_常德市_澧　县_',0),(995,'临澧县',989,3,'_湖南_常德市_临澧县_',0),(996,'桃源县',989,3,'_湖南_常德市_桃源县_',0),(997,'石门县',989,3,'_湖南_常德市_石门县_',0),(998,'津市市',989,3,'_湖南_常德市_津市市_',0),(999,'张家界市',926,2,'_湖南_张家界市_',0),(1000,'永定区',999,3,'_湖南_张家界市_永定区_',0),(1001,'武陵源区',999,3,'_湖南_张家界市_武陵源区_',0),(1002,'慈利县',999,3,'_湖南_张家界市_慈利县_',0),(1003,'桑植县',999,3,'_湖南_张家界市_桑植县_',0),(1004,'益阳市',926,2,'_湖南_益阳市_',0),(1005,'资阳区',1004,3,'_湖南_益阳市_资阳区_',0),(1006,'赫山区',1004,3,'_湖南_益阳市_赫山区_',0),(1007,'南　县',1004,3,'_湖南_益阳市_南　县_',0),(1008,'桃江县',1004,3,'_湖南_益阳市_桃江县_',0),(1009,'安化县',1004,3,'_湖南_益阳市_安化县_',0),(1010,'沅江市',1004,3,'_湖南_益阳市_沅江市_',0),(1011,'郴州市',926,2,'_湖南_郴州市_',0),(1012,'北湖区',1011,3,'_湖南_郴州市_北湖区_',0),(1013,'苏仙区',1011,3,'_湖南_郴州市_苏仙区_',0),(1014,'桂阳县',1011,3,'_湖南_郴州市_桂阳县_',0),(1015,'宜章县',1011,3,'_湖南_郴州市_宜章县_',0),(1016,'永兴县',1011,3,'_湖南_郴州市_永兴县_',0),(1017,'嘉禾县',1011,3,'_湖南_郴州市_嘉禾县_',0),(1018,'临武县',1011,3,'_湖南_郴州市_临武县_',0),(1019,'汝城县',1011,3,'_湖南_郴州市_汝城县_',0),(1020,'桂东县',1011,3,'_湖南_郴州市_桂东县_',0),(1021,'安仁县',1011,3,'_湖南_郴州市_安仁县_',0),(1022,'资兴市',1011,3,'_湖南_郴州市_资兴市_',0),(1023,'永州市',926,2,'_湖南_永州市_',0),(1024,'芝山区',1023,3,'_湖南_永州市_芝山区_',0),(1025,'冷水滩区',1023,3,'_湖南_永州市_冷水滩区_',0),(1026,'祁阳县',1023,3,'_湖南_永州市_祁阳县_',0),(1027,'东安县',1023,3,'_湖南_永州市_东安县_',0),(1028,'双牌县',1023,3,'_湖南_永州市_双牌县_',0),(1029,'道　县',1023,3,'_湖南_永州市_道　县_',0),(1030,'江永县',1023,3,'_湖南_永州市_江永县_',0),(1031,'宁远县',1023,3,'_湖南_永州市_宁远县_',0),(1032,'蓝山县',1023,3,'_湖南_永州市_蓝山县_',0),(1033,'新田县',1023,3,'_湖南_永州市_新田县_',0),(1034,'江华瑶族自治县',1023,3,'_湖南_永州市_江华瑶族自治县_',0),(1035,'怀化市',926,2,'_湖南_怀化市_',0),(1036,'鹤城区',1035,3,'_湖南_怀化市_鹤城区_',0),(1037,'中方县',1035,3,'_湖南_怀化市_中方县_',0),(1038,'沅陵县',1035,3,'_湖南_怀化市_沅陵县_',0),(1039,'辰溪县',1035,3,'_湖南_怀化市_辰溪县_',0),(1040,'溆浦县',1035,3,'_湖南_怀化市_溆浦县_',0),(1041,'会同县',1035,3,'_湖南_怀化市_会同县_',0),(1042,'麻阳苗族自治县',1035,3,'_湖南_怀化市_麻阳苗族自治县_',0),(1043,'新晃侗族自治县',1035,3,'_湖南_怀化市_新晃侗族自治县_',0),(1044,'芷江侗族自治县',1035,3,'_湖南_怀化市_芷江侗族自治县_',0),(1045,'靖州苗族侗族自治县',1035,3,'_湖南_怀化市_靖州苗族侗族自治县_',0),(1046,'通道侗族自治县',1035,3,'_湖南_怀化市_通道侗族自治县_',0),(1047,'洪江市',1035,3,'_湖南_怀化市_洪江市_',0),(1048,'娄底市',926,2,'_湖南_娄底市_',0),(1049,'娄星区',1048,3,'_湖南_娄底市_娄星区_',0),(1050,'双峰县',1048,3,'_湖南_娄底市_双峰县_',0),(1051,'新化县',1048,3,'_湖南_娄底市_新化县_',0),(1052,'冷水江市',1048,3,'_湖南_娄底市_冷水江市_',0),(1053,'涟源市',1048,3,'_湖南_娄底市_涟源市_',0),(1054,'湘西土家族苗族自治州',926,2,'_湖南_湘西土家族苗族自治州_',0),(1055,'吉首市',1054,3,'_湖南_湘西土家族苗族自治州_吉首市_',0),(1056,'泸溪县',1054,3,'_湖南_湘西土家族苗族自治州_泸溪县_',0),(1057,'凤凰县',1054,3,'_湖南_湘西土家族苗族自治州_凤凰县_',0),(1058,'花垣县',1054,3,'_湖南_湘西土家族苗族自治州_花垣县_',0),(1059,'保靖县',1054,3,'_湖南_湘西土家族苗族自治州_保靖县_',0),(1060,'古丈县',1054,3,'_湖南_湘西土家族苗族自治州_古丈县_',0),(1061,'永顺县',1054,3,'_湖南_湘西土家族苗族自治州_永顺县_',0),(1062,'龙山县',1054,3,'_湖南_湘西土家族苗族自治州_龙山县_',0),(1063,'广东',0,1,'_广东_',0),(1064,'广州市',1063,2,'_广东_广州市_',0),(1065,'东山区',1064,3,'_广东_广州市_东山区_',0),(1066,'荔湾区',1064,3,'_广东_广州市_荔湾区_',0),(1067,'越秀区',1064,3,'_广东_广州市_越秀区_',0),(1068,'海珠区',1064,3,'_广东_广州市_海珠区_',0),(1069,'天河区',1064,3,'_广东_广州市_天河区_',0),(1070,'芳村区',1064,3,'_广东_广州市_芳村区_',0),(1071,'白云区',1064,3,'_广东_广州市_白云区_',0),(1072,'黄埔区',1064,3,'_广东_广州市_黄埔区_',0),(1073,'番禺区',1064,3,'_广东_广州市_番禺区_',0),(1074,'花都区',1064,3,'_广东_广州市_花都区_',0),(1075,'增城市',1064,3,'_广东_广州市_增城市_',0),(1076,'从化市',1064,3,'_广东_广州市_从化市_',0),(1077,'韶关市',1063,2,'_广东_韶关市_',0),(1078,'武江区',1077,3,'_广东_韶关市_武江区_',0),(1079,'浈江区',1077,3,'_广东_韶关市_浈江区_',0),(1080,'曲江区',1077,3,'_广东_韶关市_曲江区_',0),(1081,'始兴县',1077,3,'_广东_韶关市_始兴县_',0),(1082,'仁化县',1077,3,'_广东_韶关市_仁化县_',0),(1083,'翁源县',1077,3,'_广东_韶关市_翁源县_',0),(1084,'乳源瑶族自治县',1077,3,'_广东_韶关市_乳源瑶族自治县_',0),(1085,'新丰县',1077,3,'_广东_韶关市_新丰县_',0),(1086,'乐昌市',1077,3,'_广东_韶关市_乐昌市_',0),(1087,'南雄市',1077,3,'_广东_韶关市_南雄市_',0),(1088,'深圳市',1063,2,'_广东_深圳市_',0),(1089,'罗湖区',1088,3,'_广东_深圳市_罗湖区_',0),(1090,'福田区',1088,3,'_广东_深圳市_福田区_',0),(1091,'南山区',1088,3,'_广东_深圳市_南山区_',0),(1092,'宝安区',1088,3,'_广东_深圳市_宝安区_',0),(1093,'龙岗区',1088,3,'_广东_深圳市_龙岗区_',0),(1094,'盐田区',1088,3,'_广东_深圳市_盐田区_',0),(1095,'珠海市',1063,2,'_广东_珠海市_',0),(1096,'香洲区',1095,3,'_广东_珠海市_香洲区_',0),(1097,'斗门区',1095,3,'_广东_珠海市_斗门区_',0),(1098,'金湾区',1095,3,'_广东_珠海市_金湾区_',0),(1099,'汕头市',1063,2,'_广东_汕头市_',0),(1100,'龙湖区',1099,3,'_广东_汕头市_龙湖区_',0),(1101,'金平区',1099,3,'_广东_汕头市_金平区_',0),(1102,'濠江区',1099,3,'_广东_汕头市_濠江区_',0),(1103,'潮阳区',1099,3,'_广东_汕头市_潮阳区_',0),(1104,'潮南区',1099,3,'_广东_汕头市_潮南区_',0),(1105,'澄海区',1099,3,'_广东_汕头市_澄海区_',0),(1106,'南澳县',1099,3,'_广东_汕头市_南澳县_',0),(1107,'佛山市',1063,2,'_广东_佛山市_',0),(1108,'禅城区',1107,3,'_广东_佛山市_禅城区_',0),(1109,'南海区',1107,3,'_广东_佛山市_南海区_',0),(1110,'顺德区',1107,3,'_广东_佛山市_顺德区_',0),(1111,'三水区',1107,3,'_广东_佛山市_三水区_',0),(1112,'高明区',1107,3,'_广东_佛山市_高明区_',0),(1113,'江门市',1063,2,'_广东_江门市_',0),(1114,'蓬江区',1113,3,'_广东_江门市_蓬江区_',0),(1115,'江海区',1113,3,'_广东_江门市_江海区_',0),(1116,'新会区',1113,3,'_广东_江门市_新会区_',0),(1117,'台山市',1113,3,'_广东_江门市_台山市_',0),(1118,'开平市',1113,3,'_广东_江门市_开平市_',0),(1119,'鹤山市',1113,3,'_广东_江门市_鹤山市_',0),(1120,'恩平市',1113,3,'_广东_江门市_恩平市_',0),(1121,'湛江市',1063,2,'_广东_湛江市_',0),(1122,'赤坎区',1121,3,'_广东_湛江市_赤坎区_',0),(1123,'霞山区',1121,3,'_广东_湛江市_霞山区_',0),(1124,'坡头区',1121,3,'_广东_湛江市_坡头区_',0),(1125,'麻章区',1121,3,'_广东_湛江市_麻章区_',0),(1126,'遂溪县',1121,3,'_广东_湛江市_遂溪县_',0),(1127,'徐闻县',1121,3,'_广东_湛江市_徐闻县_',0),(1128,'廉江市',1121,3,'_广东_湛江市_廉江市_',0),(1129,'雷州市',1121,3,'_广东_湛江市_雷州市_',0),(1130,'吴川市',1121,3,'_广东_湛江市_吴川市_',0),(1131,'茂名市',1063,2,'_广东_茂名市_',0),(1132,'茂南区',1131,3,'_广东_茂名市_茂南区_',0),(1133,'茂港区',1131,3,'_广东_茂名市_茂港区_',0),(1134,'电白县',1131,3,'_广东_茂名市_电白县_',0),(1135,'高州市',1131,3,'_广东_茂名市_高州市_',0),(1136,'化州市',1131,3,'_广东_茂名市_化州市_',0),(1137,'信宜市',1131,3,'_广东_茂名市_信宜市_',0),(1138,'肇庆市',1063,2,'_广东_肇庆市_',0),(1139,'端州区',1138,3,'_广东_肇庆市_端州区_',0),(1140,'鼎湖区',1138,3,'_广东_肇庆市_鼎湖区_',0),(1141,'广宁县',1138,3,'_广东_肇庆市_广宁县_',0),(1142,'怀集县',1138,3,'_广东_肇庆市_怀集县_',0),(1143,'封开县',1138,3,'_广东_肇庆市_封开县_',0),(1144,'德庆县',1138,3,'_广东_肇庆市_德庆县_',0),(1145,'高要市',1138,3,'_广东_肇庆市_高要市_',0),(1146,'四会市',1138,3,'_广东_肇庆市_四会市_',0),(1147,'惠州市',1063,2,'_广东_惠州市_',0),(1148,'惠城区',1147,3,'_广东_惠州市_惠城区_',0),(1149,'惠阳区',1147,3,'_广东_惠州市_惠阳区_',0),(1150,'博罗县',1147,3,'_广东_惠州市_博罗县_',0),(1151,'惠东县',1147,3,'_广东_惠州市_惠东县_',0),(1152,'龙门县',1147,3,'_广东_惠州市_龙门县_',0),(1153,'梅州市',1063,2,'_广东_梅州市_',0),(1154,'梅江区',1153,3,'_广东_梅州市_梅江区_',0),(1155,'梅　县',1153,3,'_广东_梅州市_梅　县_',0),(1156,'大埔县',1153,3,'_广东_梅州市_大埔县_',0),(1157,'丰顺县',1153,3,'_广东_梅州市_丰顺县_',0),(1158,'五华县',1153,3,'_广东_梅州市_五华县_',0),(1159,'平远县',1153,3,'_广东_梅州市_平远县_',0),(1160,'蕉岭县',1153,3,'_广东_梅州市_蕉岭县_',0),(1161,'兴宁市',1153,3,'_广东_梅州市_兴宁市_',0),(1162,'汕尾市',1063,2,'_广东_汕尾市_',0),(1163,'城　区',1162,3,'_广东_汕尾市_城　区_',0),(1164,'海丰县',1162,3,'_广东_汕尾市_海丰县_',0),(1165,'陆河县',1162,3,'_广东_汕尾市_陆河县_',0),(1166,'陆丰市',1162,3,'_广东_汕尾市_陆丰市_',0),(1167,'河源市',1063,2,'_广东_河源市_',0),(1168,'源城区',1167,3,'_广东_河源市_源城区_',0),(1169,'紫金县',1167,3,'_广东_河源市_紫金县_',0),(1170,'龙川县',1167,3,'_广东_河源市_龙川县_',0),(1171,'连平县',1167,3,'_广东_河源市_连平县_',0),(1172,'和平县',1167,3,'_广东_河源市_和平县_',0),(1173,'东源县',1167,3,'_广东_河源市_东源县_',0),(1174,'阳江市',1063,2,'_广东_阳江市_',0),(1175,'江城区',1174,3,'_广东_阳江市_江城区_',0),(1176,'阳西县',1174,3,'_广东_阳江市_阳西县_',0),(1177,'阳东县',1174,3,'_广东_阳江市_阳东县_',0),(1178,'阳春市',1174,3,'_广东_阳江市_阳春市_',0),(1179,'清远市',1063,2,'_广东_清远市_',0),(1180,'清城区',1179,3,'_广东_清远市_清城区_',0),(1181,'佛冈县',1179,3,'_广东_清远市_佛冈县_',0),(1182,'阳山县',1179,3,'_广东_清远市_阳山县_',0),(1183,'连山壮族瑶族自治县',1179,3,'_广东_清远市_连山壮族瑶族自治县_',0),(1184,'连南瑶族自治县',1179,3,'_广东_清远市_连南瑶族自治县_',0),(1185,'清新县',1179,3,'_广东_清远市_清新县_',0),(1186,'英德市',1179,3,'_广东_清远市_英德市_',0),(1187,'连州市',1179,3,'_广东_清远市_连州市_',0),(1188,'东莞市',1063,2,'_广东_东莞市_',0),(1189,'东莞市',1188,3,'_广东_东莞市_东莞市_',0),(1190,'中山市',1063,2,'_广东_中山市_',0),(1191,'中山市',1190,3,'_广东_中山市_中山市_',0),(1192,'潮州市',1063,2,'_广东_潮州市_',0),(1193,'湘桥区',1192,3,'_广东_潮州市_湘桥区_',0),(1194,'潮安县',1192,3,'_广东_潮州市_潮安县_',0),(1195,'饶平县',1192,3,'_广东_潮州市_饶平县_',0),(1196,'揭阳市',1063,2,'_广东_揭阳市_',0),(1197,'榕城区',1196,3,'_广东_揭阳市_榕城区_',0),(1198,'揭东县',1196,3,'_广东_揭阳市_揭东县_',0),(1199,'揭西县',1196,3,'_广东_揭阳市_揭西县_',0),(1200,'惠来县',1196,3,'_广东_揭阳市_惠来县_',0),(1201,'普宁市',1196,3,'_广东_揭阳市_普宁市_',0),(1202,'云浮市',1063,2,'_广东_云浮市_',0),(1203,'云城区',1202,3,'_广东_云浮市_云城区_',0),(1204,'新兴县',1202,3,'_广东_云浮市_新兴县_',0),(1205,'郁南县',1202,3,'_广东_云浮市_郁南县_',0),(1206,'云安县',1202,3,'_广东_云浮市_云安县_',0),(1207,'罗定市',1202,3,'_广东_云浮市_罗定市_',0),(1208,'广西',0,1,'_广西_',0),(1209,'南宁市',1208,2,'_广西_南宁市_',0),(1210,'兴宁区',1209,3,'_广西_南宁市_兴宁区_',0),(1211,'青秀区',1209,3,'_广西_南宁市_青秀区_',0),(1212,'江南区',1209,3,'_广西_南宁市_江南区_',0),(1213,'西乡塘区',1209,3,'_广西_南宁市_西乡塘区_',0),(1214,'良庆区',1209,3,'_广西_南宁市_良庆区_',0),(1215,'邕宁区',1209,3,'_广西_南宁市_邕宁区_',0),(1216,'武鸣县',1209,3,'_广西_南宁市_武鸣县_',0),(1217,'隆安县',1209,3,'_广西_南宁市_隆安县_',0),(1218,'马山县',1209,3,'_广西_南宁市_马山县_',0),(1219,'上林县',1209,3,'_广西_南宁市_上林县_',0),(1220,'宾阳县',1209,3,'_广西_南宁市_宾阳县_',0),(1221,'横　县',1209,3,'_广西_南宁市_横　县_',0),(1222,'柳州市',1208,2,'_广西_柳州市_',0),(1223,'城中区',1222,3,'_广西_柳州市_城中区_',0),(1224,'鱼峰区',1222,3,'_广西_柳州市_鱼峰区_',0),(1225,'柳南区',1222,3,'_广西_柳州市_柳南区_',0),(1226,'柳北区',1222,3,'_广西_柳州市_柳北区_',0),(1227,'柳江县',1222,3,'_广西_柳州市_柳江县_',0),(1228,'柳城县',1222,3,'_广西_柳州市_柳城县_',0),(1229,'鹿寨县',1222,3,'_广西_柳州市_鹿寨县_',0),(1230,'融安县',1222,3,'_广西_柳州市_融安县_',0),(1231,'融水苗族自治县',1222,3,'_广西_柳州市_融水苗族自治县_',0),(1232,'三江侗族自治县',1222,3,'_广西_柳州市_三江侗族自治县_',0),(1233,'桂林市',1208,2,'_广西_桂林市_',0),(1234,'秀峰区',1233,3,'_广西_桂林市_秀峰区_',0),(1235,'叠彩区',1233,3,'_广西_桂林市_叠彩区_',0),(1236,'象山区',1233,3,'_广西_桂林市_象山区_',0),(1237,'七星区',1233,3,'_广西_桂林市_七星区_',0),(1238,'雁山区',1233,3,'_广西_桂林市_雁山区_',0),(1239,'阳朔县',1233,3,'_广西_桂林市_阳朔县_',0),(1240,'临桂县',1233,3,'_广西_桂林市_临桂县_',0),(1241,'灵川县',1233,3,'_广西_桂林市_灵川县_',0),(1242,'全州县',1233,3,'_广西_桂林市_全州县_',0),(1243,'兴安县',1233,3,'_广西_桂林市_兴安县_',0),(1244,'永福县',1233,3,'_广西_桂林市_永福县_',0),(1245,'灌阳县',1233,3,'_广西_桂林市_灌阳县_',0),(1246,'龙胜各族自治县',1233,3,'_广西_桂林市_龙胜各族自治县_',0),(1247,'资源县',1233,3,'_广西_桂林市_资源县_',0),(1248,'平乐县',1233,3,'_广西_桂林市_平乐县_',0),(1249,'荔蒲县',1233,3,'_广西_桂林市_荔蒲县_',0),(1250,'恭城瑶族自治县',1233,3,'_广西_桂林市_恭城瑶族自治县_',0),(1251,'梧州市',1208,2,'_广西_梧州市_',0),(1252,'万秀区',1251,3,'_广西_梧州市_万秀区_',0),(1253,'蝶山区',1251,3,'_广西_梧州市_蝶山区_',0),(1254,'长洲区',1251,3,'_广西_梧州市_长洲区_',0),(1255,'苍梧县',1251,3,'_广西_梧州市_苍梧县_',0),(1256,'藤　县',1251,3,'_广西_梧州市_藤　县_',0),(1257,'蒙山县',1251,3,'_广西_梧州市_蒙山县_',0),(1258,'岑溪市',1251,3,'_广西_梧州市_岑溪市_',0),(1259,'北海市',1208,2,'_广西_北海市_',0),(1260,'海城区',1259,3,'_广西_北海市_海城区_',0),(1261,'银海区',1259,3,'_广西_北海市_银海区_',0),(1262,'铁山港区',1259,3,'_广西_北海市_铁山港区_',0),(1263,'合浦县',1259,3,'_广西_北海市_合浦县_',0),(1264,'防城港市',1208,2,'_广西_防城港市_',0),(1265,'港口区',1264,3,'_广西_防城港市_港口区_',0),(1266,'防城区',1264,3,'_广西_防城港市_防城区_',0),(1267,'上思县',1264,3,'_广西_防城港市_上思县_',0),(1268,'东兴市',1264,3,'_广西_防城港市_东兴市_',0),(1269,'钦州市',1208,2,'_广西_钦州市_',0),(1270,'钦南区',1269,3,'_广西_钦州市_钦南区_',0),(1271,'钦北区',1269,3,'_广西_钦州市_钦北区_',0),(1272,'灵山县',1269,3,'_广西_钦州市_灵山县_',0),(1273,'浦北县',1269,3,'_广西_钦州市_浦北县_',0),(1274,'贵港市',1208,2,'_广西_贵港市_',0),(1275,'港北区',1274,3,'_广西_贵港市_港北区_',0),(1276,'港南区',1274,3,'_广西_贵港市_港南区_',0),(1277,'覃塘区',1274,3,'_广西_贵港市_覃塘区_',0),(1278,'平南县',1274,3,'_广西_贵港市_平南县_',0),(1279,'桂平市',1274,3,'_广西_贵港市_桂平市_',0),(1280,'玉林市',1208,2,'_广西_玉林市_',0),(1281,'玉州区',1280,3,'_广西_玉林市_玉州区_',0),(1282,'容　县',1280,3,'_广西_玉林市_容　县_',0),(1283,'陆川县',1280,3,'_广西_玉林市_陆川县_',0),(1284,'博白县',1280,3,'_广西_玉林市_博白县_',0),(1285,'兴业县',1280,3,'_广西_玉林市_兴业县_',0),(1286,'北流市',1280,3,'_广西_玉林市_北流市_',0),(1287,'百色市',1208,2,'_广西_百色市_',0),(1288,'右江区',1287,3,'_广西_百色市_右江区_',0),(1289,'田阳县',1287,3,'_广西_百色市_田阳县_',0),(1290,'田东县',1287,3,'_广西_百色市_田东县_',0),(1291,'平果县',1287,3,'_广西_百色市_平果县_',0),(1292,'德保县',1287,3,'_广西_百色市_德保县_',0),(1293,'靖西县',1287,3,'_广西_百色市_靖西县_',0),(1294,'那坡县',1287,3,'_广西_百色市_那坡县_',0),(1295,'凌云县',1287,3,'_广西_百色市_凌云县_',0),(1296,'乐业县',1287,3,'_广西_百色市_乐业县_',0),(1297,'田林县',1287,3,'_广西_百色市_田林县_',0),(1298,'西林县',1287,3,'_广西_百色市_西林县_',0),(1299,'隆林各族自治县',1287,3,'_广西_百色市_隆林各族自治县_',0),(1300,'贺州市',1208,2,'_广西_贺州市_',0),(1301,'八步区',1300,3,'_广西_贺州市_八步区_',0),(1302,'昭平县',1300,3,'_广西_贺州市_昭平县_',0),(1303,'钟山县',1300,3,'_广西_贺州市_钟山县_',0),(1304,'富川瑶族自治县',1300,3,'_广西_贺州市_富川瑶族自治县_',0),(1305,'河池市',1208,2,'_广西_河池市_',0),(1306,'金城江区',1305,3,'_广西_河池市_金城江区_',0),(1307,'南丹县',1305,3,'_广西_河池市_南丹县_',0),(1308,'天峨县',1305,3,'_广西_河池市_天峨县_',0),(1309,'凤山县',1305,3,'_广西_河池市_凤山县_',0),(1310,'东兰县',1305,3,'_广西_河池市_东兰县_',0),(1311,'罗城仫佬族自治县',1305,3,'_广西_河池市_罗城仫佬族自治县_',0),(1312,'环江毛南族自治县',1305,3,'_广西_河池市_环江毛南族自治县_',0),(1313,'巴马瑶族自治县',1305,3,'_广西_河池市_巴马瑶族自治县_',0),(1314,'都安瑶族自治县',1305,3,'_广西_河池市_都安瑶族自治县_',0),(1315,'大化瑶族自治县',1305,3,'_广西_河池市_大化瑶族自治县_',0),(1316,'宜州市',1305,3,'_广西_河池市_宜州市_',0),(1317,'来宾市',1208,2,'_广西_来宾市_',0),(1318,'兴宾区',1317,3,'_广西_来宾市_兴宾区_',0),(1319,'忻城县',1317,3,'_广西_来宾市_忻城县_',0),(1320,'象州县',1317,3,'_广西_来宾市_象州县_',0),(1321,'武宣县',1317,3,'_广西_来宾市_武宣县_',0),(1322,'金秀瑶族自治县',1317,3,'_广西_来宾市_金秀瑶族自治县_',0),(1323,'合山市',1317,3,'_广西_来宾市_合山市_',0),(1324,'崇左市',1208,2,'_广西_崇左市_',0),(1325,'江洲区',1324,3,'_广西_崇左市_江洲区_',0),(1326,'扶绥县',1324,3,'_广西_崇左市_扶绥县_',0),(1327,'宁明县',1324,3,'_广西_崇左市_宁明县_',0),(1328,'龙州县',1324,3,'_广西_崇左市_龙州县_',0),(1329,'大新县',1324,3,'_广西_崇左市_大新县_',0),(1330,'天等县',1324,3,'_广西_崇左市_天等县_',0),(1331,'凭祥市',1324,3,'_广西_崇左市_凭祥市_',0),(1332,'陕西',0,1,'_陕西_',0),(1333,'西安市',1332,2,'_陕西_西安市_',0),(1334,'新城区',1333,3,'_陕西_西安市_新城区_',0),(1335,'碑林区',1333,3,'_陕西_西安市_碑林区_',0),(1336,'莲湖区',1333,3,'_陕西_西安市_莲湖区_',0),(1337,'灞桥区',1333,3,'_陕西_西安市_灞桥区_',0),(1338,'未央区',1333,3,'_陕西_西安市_未央区_',0),(1339,'雁塔区',1333,3,'_陕西_西安市_雁塔区_',0),(1340,'阎良区',1333,3,'_陕西_西安市_阎良区_',0),(1341,'临潼区',1333,3,'_陕西_西安市_临潼区_',0),(1342,'长安区',1333,3,'_陕西_西安市_长安区_',0),(1343,'蓝田县',1333,3,'_陕西_西安市_蓝田县_',0),(1344,'周至县',1333,3,'_陕西_西安市_周至县_',0),(1345,'户　县',1333,3,'_陕西_西安市_户　县_',0),(1346,'高陵县',1333,3,'_陕西_西安市_高陵县_',0),(1347,'铜川市',1332,2,'_陕西_铜川市_',0),(1348,'王益区',1347,3,'_陕西_铜川市_王益区_',0),(1349,'印台区',1347,3,'_陕西_铜川市_印台区_',0),(1350,'耀州区',1347,3,'_陕西_铜川市_耀州区_',0),(1351,'宜君县',1347,3,'_陕西_铜川市_宜君县_',0),(1352,'宝鸡市',1332,2,'_陕西_宝鸡市_',0),(1353,'渭滨区',1352,3,'_陕西_宝鸡市_渭滨区_',0),(1354,'金台区',1352,3,'_陕西_宝鸡市_金台区_',0),(1355,'陈仓区',1352,3,'_陕西_宝鸡市_陈仓区_',0),(1356,'凤翔县',1352,3,'_陕西_宝鸡市_凤翔县_',0),(1357,'岐山县',1352,3,'_陕西_宝鸡市_岐山县_',0),(1358,'扶风县',1352,3,'_陕西_宝鸡市_扶风县_',0),(1359,'眉　县',1352,3,'_陕西_宝鸡市_眉　县_',0),(1360,'陇　县',1352,3,'_陕西_宝鸡市_陇　县_',0),(1361,'千阳县',1352,3,'_陕西_宝鸡市_千阳县_',0),(1362,'麟游县',1352,3,'_陕西_宝鸡市_麟游县_',0),(1363,'凤　县',1352,3,'_陕西_宝鸡市_凤　县_',0),(1364,'太白县',1352,3,'_陕西_宝鸡市_太白县_',0),(1365,'咸阳市',1332,2,'_陕西_咸阳市_',0),(1366,'秦都区',1365,3,'_陕西_咸阳市_秦都区_',0),(1367,'杨凌区',1365,3,'_陕西_咸阳市_杨凌区_',0),(1368,'渭城区',1365,3,'_陕西_咸阳市_渭城区_',0),(1369,'三原县',1365,3,'_陕西_咸阳市_三原县_',0),(1370,'泾阳县',1365,3,'_陕西_咸阳市_泾阳县_',0),(1371,'乾　县',1365,3,'_陕西_咸阳市_乾　县_',0),(1372,'礼泉县',1365,3,'_陕西_咸阳市_礼泉县_',0),(1373,'永寿县',1365,3,'_陕西_咸阳市_永寿县_',0),(1374,'彬　县',1365,3,'_陕西_咸阳市_彬　县_',0),(1375,'长武县',1365,3,'_陕西_咸阳市_长武县_',0),(1376,'旬邑县',1365,3,'_陕西_咸阳市_旬邑县_',0),(1377,'淳化县',1365,3,'_陕西_咸阳市_淳化县_',0),(1378,'武功县',1365,3,'_陕西_咸阳市_武功县_',0),(1379,'兴平市',1365,3,'_陕西_咸阳市_兴平市_',0),(1380,'渭南市',1332,2,'_陕西_渭南市_',0),(1381,'临渭区',1380,3,'_陕西_渭南市_临渭区_',0),(1382,'华　县',1380,3,'_陕西_渭南市_华　县_',0),(1383,'潼关县',1380,3,'_陕西_渭南市_潼关县_',0),(1384,'大荔县',1380,3,'_陕西_渭南市_大荔县_',0),(1385,'合阳县',1380,3,'_陕西_渭南市_合阳县_',0),(1386,'澄城县',1380,3,'_陕西_渭南市_澄城县_',0),(1387,'蒲城县',1380,3,'_陕西_渭南市_蒲城县_',0),(1388,'白水县',1380,3,'_陕西_渭南市_白水县_',0),(1389,'富平县',1380,3,'_陕西_渭南市_富平县_',0),(1390,'韩城市',1380,3,'_陕西_渭南市_韩城市_',0),(1391,'华阴市',1380,3,'_陕西_渭南市_华阴市_',0),(1392,'延安市',1332,2,'_陕西_延安市_',0),(1393,'宝塔区',1392,3,'_陕西_延安市_宝塔区_',0),(1394,'延长县',1392,3,'_陕西_延安市_延长县_',0),(1395,'延川县',1392,3,'_陕西_延安市_延川县_',0),(1396,'子长县',1392,3,'_陕西_延安市_子长县_',0),(1397,'安塞县',1392,3,'_陕西_延安市_安塞县_',0),(1398,'志丹县',1392,3,'_陕西_延安市_志丹县_',0),(1399,'吴旗县',1392,3,'_陕西_延安市_吴旗县_',0),(1400,'甘泉县',1392,3,'_陕西_延安市_甘泉县_',0),(1401,'富　县',1392,3,'_陕西_延安市_富　县_',0),(1402,'洛川县',1392,3,'_陕西_延安市_洛川县_',0),(1403,'宜川县',1392,3,'_陕西_延安市_宜川县_',0),(1404,'黄龙县',1392,3,'_陕西_延安市_黄龙县_',0),(1405,'黄陵县',1392,3,'_陕西_延安市_黄陵县_',0),(1406,'汉中市',1332,2,'_陕西_汉中市_',0),(1407,'汉台区',1406,3,'_陕西_汉中市_汉台区_',0),(1408,'南郑县',1406,3,'_陕西_汉中市_南郑县_',0),(1409,'城固县',1406,3,'_陕西_汉中市_城固县_',0),(1410,'洋　县',1406,3,'_陕西_汉中市_洋　县_',0),(1411,'西乡县',1406,3,'_陕西_汉中市_西乡县_',0),(1412,'勉　县',1406,3,'_陕西_汉中市_勉　县_',0),(1413,'宁强县',1406,3,'_陕西_汉中市_宁强县_',0),(1414,'略阳县',1406,3,'_陕西_汉中市_略阳县_',0),(1415,'镇巴县',1406,3,'_陕西_汉中市_镇巴县_',0),(1416,'留坝县',1406,3,'_陕西_汉中市_留坝县_',0),(1417,'佛坪县',1406,3,'_陕西_汉中市_佛坪县_',0),(1418,'榆林市',1332,2,'_陕西_榆林市_',0),(1419,'榆阳区',1418,3,'_陕西_榆林市_榆阳区_',0),(1420,'神木县',1418,3,'_陕西_榆林市_神木县_',0),(1421,'府谷县',1418,3,'_陕西_榆林市_府谷县_',0),(1422,'横山县',1418,3,'_陕西_榆林市_横山县_',0),(1423,'靖边县',1418,3,'_陕西_榆林市_靖边县_',0),(1424,'定边县',1418,3,'_陕西_榆林市_定边县_',0),(1425,'绥德县',1418,3,'_陕西_榆林市_绥德县_',0),(1426,'米脂县',1418,3,'_陕西_榆林市_米脂县_',0),(1427,'佳　县',1418,3,'_陕西_榆林市_佳　县_',0),(1428,'吴堡县',1418,3,'_陕西_榆林市_吴堡县_',0),(1429,'清涧县',1418,3,'_陕西_榆林市_清涧县_',0),(1430,'子洲县',1418,3,'_陕西_榆林市_子洲县_',0),(1431,'安康市',1332,2,'_陕西_安康市_',0),(1432,'汉滨区',1431,3,'_陕西_安康市_汉滨区_',0),(1433,'汉阴县',1431,3,'_陕西_安康市_汉阴县_',0),(1434,'石泉县',1431,3,'_陕西_安康市_石泉县_',0),(1435,'宁陕县',1431,3,'_陕西_安康市_宁陕县_',0),(1436,'紫阳县',1431,3,'_陕西_安康市_紫阳县_',0),(1437,'岚皋县',1431,3,'_陕西_安康市_岚皋县_',0),(1438,'平利县',1431,3,'_陕西_安康市_平利县_',0),(1439,'镇坪县',1431,3,'_陕西_安康市_镇坪县_',0),(1440,'旬阳县',1431,3,'_陕西_安康市_旬阳县_',0),(1441,'白河县',1431,3,'_陕西_安康市_白河县_',0),(1442,'商洛市',1332,2,'_陕西_商洛市_',0),(1443,'商州区',1442,3,'_陕西_商洛市_商州区_',0),(1444,'洛南县',1442,3,'_陕西_商洛市_洛南县_',0),(1445,'丹凤县',1442,3,'_陕西_商洛市_丹凤县_',0),(1446,'商南县',1442,3,'_陕西_商洛市_商南县_',0),(1447,'山阳县',1442,3,'_陕西_商洛市_山阳县_',0),(1448,'镇安县',1442,3,'_陕西_商洛市_镇安县_',0),(1449,'柞水县',1442,3,'_陕西_商洛市_柞水县_',0),(1450,'甘肃',0,1,'_甘肃_',0),(1451,'兰州市',1450,2,'_甘肃_兰州市_',0),(1452,'城关区',1451,3,'_甘肃_兰州市_城关区_',0),(1453,'七里河区',1451,3,'_甘肃_兰州市_七里河区_',0),(1454,'西固区',1451,3,'_甘肃_兰州市_西固区_',0),(1455,'安宁区',1451,3,'_甘肃_兰州市_安宁区_',0),(1456,'红古区',1451,3,'_甘肃_兰州市_红古区_',0),(1457,'永登县',1451,3,'_甘肃_兰州市_永登县_',0),(1458,'皋兰县',1451,3,'_甘肃_兰州市_皋兰县_',0),(1459,'榆中县',1451,3,'_甘肃_兰州市_榆中县_',0),(1460,'嘉峪关市',1450,2,'_甘肃_嘉峪关市_',0),(1461,'市辖区',1460,3,'_甘肃_嘉峪关市_市辖区_',0),(1462,'金昌市',1450,2,'_甘肃_金昌市_',0),(1463,'金川区',1462,3,'_甘肃_金昌市_金川区_',0),(1464,'永昌县',1462,3,'_甘肃_金昌市_永昌县_',0),(1465,'白银市',1450,2,'_甘肃_白银市_',0),(1466,'白银区',1465,3,'_甘肃_白银市_白银区_',0),(1467,'平川区',1465,3,'_甘肃_白银市_平川区_',0),(1468,'靖远县',1465,3,'_甘肃_白银市_靖远县_',0),(1469,'会宁县',1465,3,'_甘肃_白银市_会宁县_',0),(1470,'景泰县',1465,3,'_甘肃_白银市_景泰县_',0),(1471,'天水市',1450,2,'_甘肃_天水市_',0),(1472,'秦城区',1471,3,'_甘肃_天水市_秦城区_',0),(1473,'北道区',1471,3,'_甘肃_天水市_北道区_',0),(1474,'清水县',1471,3,'_甘肃_天水市_清水县_',0),(1475,'秦安县',1471,3,'_甘肃_天水市_秦安县_',0),(1476,'甘谷县',1471,3,'_甘肃_天水市_甘谷县_',0),(1477,'武山县',1471,3,'_甘肃_天水市_武山县_',0),(1478,'张家川回族自治县',1471,3,'_甘肃_天水市_张家川回族自治县_',0),(1479,'武威市',1450,2,'_甘肃_武威市_',0),(1480,'凉州区',1479,3,'_甘肃_武威市_凉州区_',0),(1481,'民勤县',1479,3,'_甘肃_武威市_民勤县_',0),(1482,'古浪县',1479,3,'_甘肃_武威市_古浪县_',0),(1483,'天祝藏族自治县',1479,3,'_甘肃_武威市_天祝藏族自治县_',0),(1484,'张掖市',1450,2,'_甘肃_张掖市_',0),(1485,'甘州区',1484,3,'_甘肃_张掖市_甘州区_',0),(1486,'肃南裕固族自治县',1484,3,'_甘肃_张掖市_肃南裕固族自治县_',0),(1487,'民乐县',1484,3,'_甘肃_张掖市_民乐县_',0),(1488,'临泽县',1484,3,'_甘肃_张掖市_临泽县_',0),(1489,'高台县',1484,3,'_甘肃_张掖市_高台县_',0),(1490,'山丹县',1484,3,'_甘肃_张掖市_山丹县_',0),(1491,'平凉市',1450,2,'_甘肃_平凉市_',0),(1492,'崆峒区',1491,3,'_甘肃_平凉市_崆峒区_',0),(1493,'泾川县',1491,3,'_甘肃_平凉市_泾川县_',0),(1494,'灵台县',1491,3,'_甘肃_平凉市_灵台县_',0),(1495,'崇信县',1491,3,'_甘肃_平凉市_崇信县_',0),(1496,'华亭县',1491,3,'_甘肃_平凉市_华亭县_',0),(1497,'庄浪县',1491,3,'_甘肃_平凉市_庄浪县_',0),(1498,'静宁县',1491,3,'_甘肃_平凉市_静宁县_',0),(1499,'酒泉市',1450,2,'_甘肃_酒泉市_',0),(1500,'肃州区',1499,3,'_甘肃_酒泉市_肃州区_',0),(1501,'金塔县',1499,3,'_甘肃_酒泉市_金塔县_',0),(1502,'安西县',1499,3,'_甘肃_酒泉市_安西县_',0),(1503,'肃北蒙古族自治县',1499,3,'_甘肃_酒泉市_肃北蒙古族自治县_',0),(1504,'阿克塞哈萨克族自治县',1499,3,'_甘肃_酒泉市_阿克塞哈萨克族自治县_',0),(1505,'玉门市',1499,3,'_甘肃_酒泉市_玉门市_',0),(1506,'敦煌市',1499,3,'_甘肃_酒泉市_敦煌市_',0),(1507,'庆阳市',1450,2,'_甘肃_庆阳市_',0),(1508,'西峰区',1507,3,'_甘肃_庆阳市_西峰区_',0),(1509,'庆城县',1507,3,'_甘肃_庆阳市_庆城县_',0),(1510,'环　县',1507,3,'_甘肃_庆阳市_环　县_',0),(1511,'华池县',1507,3,'_甘肃_庆阳市_华池县_',0),(1512,'合水县',1507,3,'_甘肃_庆阳市_合水县_',0),(1513,'正宁县',1507,3,'_甘肃_庆阳市_正宁县_',0),(1514,'宁　县',1507,3,'_甘肃_庆阳市_宁　县_',0),(1515,'镇原县',1507,3,'_甘肃_庆阳市_镇原县_',0),(1516,'定西市',1450,2,'_甘肃_定西市_',0),(1517,'安定区',1516,3,'_甘肃_定西市_安定区_',0),(1518,'通渭县',1516,3,'_甘肃_定西市_通渭县_',0),(1519,'陇西县',1516,3,'_甘肃_定西市_陇西县_',0),(1520,'渭源县',1516,3,'_甘肃_定西市_渭源县_',0),(1521,'临洮县',1516,3,'_甘肃_定西市_临洮县_',0),(1522,'漳　县',1516,3,'_甘肃_定西市_漳　县_',0),(1523,'岷　县',1516,3,'_甘肃_定西市_岷　县_',0),(1524,'陇南市',1450,2,'_甘肃_陇南市_',0),(1525,'武都区',1524,3,'_甘肃_陇南市_武都区_',0),(1526,'成　县',1524,3,'_甘肃_陇南市_成　县_',0),(1527,'文　县',1524,3,'_甘肃_陇南市_文　县_',0),(1528,'宕昌县',1524,3,'_甘肃_陇南市_宕昌县_',0),(1529,'康　县',1524,3,'_甘肃_陇南市_康　县_',0),(1530,'西和县',1524,3,'_甘肃_陇南市_西和县_',0),(1531,'礼　县',1524,3,'_甘肃_陇南市_礼　县_',0),(1532,'徽　县',1524,3,'_甘肃_陇南市_徽　县_',0),(1533,'两当县',1524,3,'_甘肃_陇南市_两当县_',0),(1534,'临夏回族自治州',1450,2,'_甘肃_临夏回族自治州_',0),(1535,'临夏市',1534,3,'_甘肃_临夏回族自治州_临夏市_',0),(1536,'临夏县',1534,3,'_甘肃_临夏回族自治州_临夏县_',0),(1537,'康乐县',1534,3,'_甘肃_临夏回族自治州_康乐县_',0),(1538,'永靖县',1534,3,'_甘肃_临夏回族自治州_永靖县_',0),(1539,'广河县',1534,3,'_甘肃_临夏回族自治州_广河县_',0),(1540,'和政县',1534,3,'_甘肃_临夏回族自治州_和政县_',0),(1541,'东乡族自治县',1534,3,'_甘肃_临夏回族自治州_东乡族自治县_',0),(1542,'积石山保安族东乡族撒拉族自治县',1534,3,'_甘肃_临夏回族自治州_积石山保安族东乡族撒拉族自治县_',0),(1543,'甘南藏族自治州',1450,2,'_甘肃_甘南藏族自治州_',0),(1544,'合作市',1543,3,'_甘肃_甘南藏族自治州_合作市_',0),(1545,'临潭县',1543,3,'_甘肃_甘南藏族自治州_临潭县_',0),(1546,'卓尼县',1543,3,'_甘肃_甘南藏族自治州_卓尼县_',0),(1547,'舟曲县',1543,3,'_甘肃_甘南藏族自治州_舟曲县_',0),(1548,'迭部县',1543,3,'_甘肃_甘南藏族自治州_迭部县_',0),(1549,'玛曲县',1543,3,'_甘肃_甘南藏族自治州_玛曲县_',0),(1550,'碌曲县',1543,3,'_甘肃_甘南藏族自治州_碌曲县_',0),(1551,'夏河县',1543,3,'_甘肃_甘南藏族自治州_夏河县_',0),(1552,'青海',0,1,'_青海_',0),(1553,'西宁市',1552,2,'_青海_西宁市_',0),(1554,'城东区',1553,3,'_青海_西宁市_城东区_',0),(1555,'城中区',1553,3,'_青海_西宁市_城中区_',0),(1556,'城西区',1553,3,'_青海_西宁市_城西区_',0),(1557,'城北区',1553,3,'_青海_西宁市_城北区_',0),(1558,'大通回族土族自治县',1553,3,'_青海_西宁市_大通回族土族自治县_',0),(1559,'湟中县',1553,3,'_青海_西宁市_湟中县_',0),(1560,'湟源县',1553,3,'_青海_西宁市_湟源县_',0),(1561,'海东地区',1552,2,'_青海_海东地区_',0),(1562,'平安县',1561,3,'_青海_海东地区_平安县_',0),(1563,'民和回族土族自治县',1561,3,'_青海_海东地区_民和回族土族自治县_',0),(1564,'乐都县',1561,3,'_青海_海东地区_乐都县_',0),(1565,'互助土族自治县',1561,3,'_青海_海东地区_互助土族自治县_',0),(1566,'化隆回族自治县',1561,3,'_青海_海东地区_化隆回族自治县_',0),(1567,'循化撒拉族自治县',1561,3,'_青海_海东地区_循化撒拉族自治县_',0),(1568,'海北藏族自治州',1552,2,'_青海_海北藏族自治州_',0),(1569,'门源回族自治县',1568,3,'_青海_海北藏族自治州_门源回族自治县_',0),(1570,'祁连县',1568,3,'_青海_海北藏族自治州_祁连县_',0),(1571,'海晏县',1568,3,'_青海_海北藏族自治州_海晏县_',0),(1572,'刚察县',1568,3,'_青海_海北藏族自治州_刚察县_',0),(1573,'黄南藏族自治州',1552,2,'_青海_黄南藏族自治州_',0),(1574,'同仁县',1573,3,'_青海_黄南藏族自治州_同仁县_',0),(1575,'尖扎县',1573,3,'_青海_黄南藏族自治州_尖扎县_',0),(1576,'泽库县',1573,3,'_青海_黄南藏族自治州_泽库县_',0),(1577,'河南蒙古族自治县',1573,3,'_青海_黄南藏族自治州_河南蒙古族自治县_',0),(1578,'海南藏族自治州',1552,2,'_青海_海南藏族自治州_',0),(1579,'共和县',1578,3,'_青海_海南藏族自治州_共和县_',0),(1580,'同德县',1578,3,'_青海_海南藏族自治州_同德县_',0),(1581,'贵德县',1578,3,'_青海_海南藏族自治州_贵德县_',0),(1582,'兴海县',1578,3,'_青海_海南藏族自治州_兴海县_',0),(1583,'贵南县',1578,3,'_青海_海南藏族自治州_贵南县_',0),(1584,'果洛藏族自治州',1552,2,'_青海_果洛藏族自治州_',0),(1585,'玛沁县',1584,3,'_青海_果洛藏族自治州_玛沁县_',0),(1586,'班玛县',1584,3,'_青海_果洛藏族自治州_班玛县_',0),(1587,'甘德县',1584,3,'_青海_果洛藏族自治州_甘德县_',0),(1588,'达日县',1584,3,'_青海_果洛藏族自治州_达日县_',0),(1589,'久治县',1584,3,'_青海_果洛藏族自治州_久治县_',0),(1590,'玛多县',1584,3,'_青海_果洛藏族自治州_玛多县_',0),(1591,'玉树藏族自治州',1552,2,'_青海_玉树藏族自治州_',0),(1592,'玉树县',1591,3,'_青海_玉树藏族自治州_玉树县_',0),(1593,'杂多县',1591,3,'_青海_玉树藏族自治州_杂多县_',0),(1594,'称多县',1591,3,'_青海_玉树藏族自治州_称多县_',0),(1595,'治多县',1591,3,'_青海_玉树藏族自治州_治多县_',0),(1596,'囊谦县',1591,3,'_青海_玉树藏族自治州_囊谦县_',0),(1597,'曲麻莱县',1591,3,'_青海_玉树藏族自治州_曲麻莱县_',0),(1598,'海西蒙古族藏族自治州',1552,2,'_青海_海西蒙古族藏族自治州_',0),(1599,'格尔木市',1598,3,'_青海_海西蒙古族藏族自治州_格尔木市_',0),(1600,'德令哈市',1598,3,'_青海_海西蒙古族藏族自治州_德令哈市_',0),(1601,'乌兰县',1598,3,'_青海_海西蒙古族藏族自治州_乌兰县_',0),(1602,'都兰县',1598,3,'_青海_海西蒙古族藏族自治州_都兰县_',0),(1603,'天峻县',1598,3,'_青海_海西蒙古族藏族自治州_天峻县_',0),(1604,'宁夏',0,1,'_宁夏_',0),(1605,'银川市',1604,2,'_宁夏_银川市_',0),(1606,'兴庆区',1605,3,'_宁夏_银川市_兴庆区_',0),(1607,'西夏区',1605,3,'_宁夏_银川市_西夏区_',0),(1608,'金凤区',1605,3,'_宁夏_银川市_金凤区_',0),(1609,'永宁县',1605,3,'_宁夏_银川市_永宁县_',0),(1610,'贺兰县',1605,3,'_宁夏_银川市_贺兰县_',0),(1611,'灵武市',1605,3,'_宁夏_银川市_灵武市_',0),(1612,'石嘴山市',1604,2,'_宁夏_石嘴山市_',0),(1613,'大武口区',1612,3,'_宁夏_石嘴山市_大武口区_',0),(1614,'惠农区',1612,3,'_宁夏_石嘴山市_惠农区_',0),(1615,'平罗县',1612,3,'_宁夏_石嘴山市_平罗县_',0),(1616,'吴忠市',1604,2,'_宁夏_吴忠市_',0),(1617,'利通区',1616,3,'_宁夏_吴忠市_利通区_',0),(1618,'盐池县',1616,3,'_宁夏_吴忠市_盐池县_',0),(1619,'同心县',1616,3,'_宁夏_吴忠市_同心县_',0),(1620,'青铜峡市',1616,3,'_宁夏_吴忠市_青铜峡市_',0),(1621,'固原市',1604,2,'_宁夏_固原市_',0),(1622,'原州区',1621,3,'_宁夏_固原市_原州区_',0),(1623,'西吉县',1621,3,'_宁夏_固原市_西吉县_',0),(1624,'隆德县',1621,3,'_宁夏_固原市_隆德县_',0),(1625,'泾源县',1621,3,'_宁夏_固原市_泾源县_',0),(1626,'彭阳县',1621,3,'_宁夏_固原市_彭阳县_',0),(1627,'海原县',1621,3,'_宁夏_固原市_海原县_',0),(1628,'中卫市',1604,2,'_宁夏_中卫市_',0),(1629,'沙坡头区',1628,3,'_宁夏_中卫市_沙坡头区_',0),(1630,'中宁县',1628,3,'_宁夏_中卫市_中宁县_',0),(1631,'新疆',0,1,'_新疆_',0),(1632,'乌鲁木齐市',1631,2,'_新疆_乌鲁木齐市_',0),(1633,'天山区',1632,3,'_新疆_乌鲁木齐市_天山区_',0),(1634,'沙依巴克区',1632,3,'_新疆_乌鲁木齐市_沙依巴克区_',0),(1635,'新市区',1632,3,'_新疆_乌鲁木齐市_新市区_',0),(1636,'水磨沟区',1632,3,'_新疆_乌鲁木齐市_水磨沟区_',0),(1637,'头屯河区',1632,3,'_新疆_乌鲁木齐市_头屯河区_',0),(1638,'达坂城区',1632,3,'_新疆_乌鲁木齐市_达坂城区_',0),(1639,'东山区',1632,3,'_新疆_乌鲁木齐市_东山区_',0),(1640,'乌鲁木齐县',1632,3,'_新疆_乌鲁木齐市_乌鲁木齐县_',0),(1641,'克拉玛依市',1631,2,'_新疆_克拉玛依市_',0),(1642,'独山子区',1641,3,'_新疆_克拉玛依市_独山子区_',0),(1643,'克拉玛依区',1641,3,'_新疆_克拉玛依市_克拉玛依区_',0),(1644,'白碱滩区',1641,3,'_新疆_克拉玛依市_白碱滩区_',0),(1645,'乌尔禾区',1641,3,'_新疆_克拉玛依市_乌尔禾区_',0),(1646,'吐鲁番地区',1631,2,'_新疆_吐鲁番地区_',0),(1647,'吐鲁番市',1646,3,'_新疆_吐鲁番地区_吐鲁番市_',0),(1648,'鄯善县',1646,3,'_新疆_吐鲁番地区_鄯善县_',0),(1649,'托克逊县',1646,3,'_新疆_吐鲁番地区_托克逊县_',0),(1650,'哈密地区',1631,2,'_新疆_哈密地区_',0),(1651,'哈密市',1650,3,'_新疆_哈密地区_哈密市_',0),(1652,'巴里坤哈萨克自治县',1650,3,'_新疆_哈密地区_巴里坤哈萨克自治县_',0),(1653,'伊吾县',1650,3,'_新疆_哈密地区_伊吾县_',0),(1654,'昌吉回族自治州',1631,2,'_新疆_昌吉回族自治州_',0),(1655,'昌吉市',1654,3,'_新疆_昌吉回族自治州_昌吉市_',0),(1656,'阜康市',1654,3,'_新疆_昌吉回族自治州_阜康市_',0),(1657,'米泉市',1654,3,'_新疆_昌吉回族自治州_米泉市_',0),(1658,'呼图壁县',1654,3,'_新疆_昌吉回族自治州_呼图壁县_',0),(1659,'玛纳斯县',1654,3,'_新疆_昌吉回族自治州_玛纳斯县_',0),(1660,'奇台县',1654,3,'_新疆_昌吉回族自治州_奇台县_',0),(1661,'吉木萨尔县',1654,3,'_新疆_昌吉回族自治州_吉木萨尔县_',0),(1662,'木垒哈萨克自治县',1654,3,'_新疆_昌吉回族自治州_木垒哈萨克自治县_',0),(1663,'博尔塔拉蒙古自治州',1631,2,'_新疆_博尔塔拉蒙古自治州_',0),(1664,'博乐市',1663,3,'_新疆_博尔塔拉蒙古自治州_博乐市_',0),(1665,'精河县',1663,3,'_新疆_博尔塔拉蒙古自治州_精河县_',0),(1666,'温泉县',1663,3,'_新疆_博尔塔拉蒙古自治州_温泉县_',0),(1667,'巴音郭楞蒙古自治州',1631,2,'_新疆_巴音郭楞蒙古自治州_',0),(1668,'库尔勒市',1667,3,'_新疆_巴音郭楞蒙古自治州_库尔勒市_',0),(1669,'轮台县',1667,3,'_新疆_巴音郭楞蒙古自治州_轮台县_',0),(1670,'尉犁县',1667,3,'_新疆_巴音郭楞蒙古自治州_尉犁县_',0),(1671,'若羌县',1667,3,'_新疆_巴音郭楞蒙古自治州_若羌县_',0),(1672,'且末县',1667,3,'_新疆_巴音郭楞蒙古自治州_且末县_',0),(1673,'焉耆回族自治县',1667,3,'_新疆_巴音郭楞蒙古自治州_焉耆回族自治县_',0),(1674,'和静县',1667,3,'_新疆_巴音郭楞蒙古自治州_和静县_',0),(1675,'和硕县',1667,3,'_新疆_巴音郭楞蒙古自治州_和硕县_',0),(1676,'博湖县',1667,3,'_新疆_巴音郭楞蒙古自治州_博湖县_',0),(1677,'阿克苏地区',1631,2,'_新疆_阿克苏地区_',0),(1678,'阿克苏市',1677,3,'_新疆_阿克苏地区_阿克苏市_',0),(1679,'温宿县',1677,3,'_新疆_阿克苏地区_温宿县_',0),(1680,'库车县',1677,3,'_新疆_阿克苏地区_库车县_',0),(1681,'沙雅县',1677,3,'_新疆_阿克苏地区_沙雅县_',0),(1682,'新和县',1677,3,'_新疆_阿克苏地区_新和县_',0),(1683,'拜城县',1677,3,'_新疆_阿克苏地区_拜城县_',0),(1684,'乌什县',1677,3,'_新疆_阿克苏地区_乌什县_',0),(1685,'阿瓦提县',1677,3,'_新疆_阿克苏地区_阿瓦提县_',0),(1686,'柯坪县',1677,3,'_新疆_阿克苏地区_柯坪县_',0),(1687,'克孜勒苏柯尔克孜自治州',1631,2,'_新疆_克孜勒苏柯尔克孜自治州_',0),(1688,'阿图什市',1687,3,'_新疆_克孜勒苏柯尔克孜自治州_阿图什市_',0),(1689,'阿克陶县',1687,3,'_新疆_克孜勒苏柯尔克孜自治州_阿克陶县_',0),(1690,'阿合奇县',1687,3,'_新疆_克孜勒苏柯尔克孜自治州_阿合奇县_',0),(1691,'乌恰县',1687,3,'_新疆_克孜勒苏柯尔克孜自治州_乌恰县_',0),(1692,'喀什地区',1631,2,'_新疆_喀什地区_',0),(1693,'喀什市',1692,3,'_新疆_喀什地区_喀什市_',0),(1694,'疏附县',1692,3,'_新疆_喀什地区_疏附县_',0),(1695,'疏勒县',1692,3,'_新疆_喀什地区_疏勒县_',0),(1696,'英吉沙县',1692,3,'_新疆_喀什地区_英吉沙县_',0),(1697,'泽普县',1692,3,'_新疆_喀什地区_泽普县_',0),(1698,'莎车县',1692,3,'_新疆_喀什地区_莎车县_',0),(1699,'叶城县',1692,3,'_新疆_喀什地区_叶城县_',0),(1700,'麦盖提县',1692,3,'_新疆_喀什地区_麦盖提县_',0),(1701,'岳普湖县',1692,3,'_新疆_喀什地区_岳普湖县_',0),(1702,'伽师县',1692,3,'_新疆_喀什地区_伽师县_',0),(1703,'巴楚县',1692,3,'_新疆_喀什地区_巴楚县_',0),(1704,'塔什库尔干塔吉克自治县',1692,3,'_新疆_喀什地区_塔什库尔干塔吉克自治县_',0),(1705,'和田地区',1631,2,'_新疆_和田地区_',0),(1706,'和田市',1705,3,'_新疆_和田地区_和田市_',0),(1707,'和田县',1705,3,'_新疆_和田地区_和田县_',0),(1708,'墨玉县',1705,3,'_新疆_和田地区_墨玉县_',0),(1709,'皮山县',1705,3,'_新疆_和田地区_皮山县_',0),(1710,'洛浦县',1705,3,'_新疆_和田地区_洛浦县_',0),(1711,'策勒县',1705,3,'_新疆_和田地区_策勒县_',0),(1712,'于田县',1705,3,'_新疆_和田地区_于田县_',0),(1713,'民丰县',1705,3,'_新疆_和田地区_民丰县_',0),(1714,'伊犁哈萨克自治州',1631,2,'_新疆_伊犁哈萨克自治州_',0),(1715,'伊宁市',1714,3,'_新疆_伊犁哈萨克自治州_伊宁市_',0),(1716,'奎屯市',1714,3,'_新疆_伊犁哈萨克自治州_奎屯市_',0),(1717,'伊宁县',1714,3,'_新疆_伊犁哈萨克自治州_伊宁县_',0),(1718,'察布查尔锡伯自治县',1714,3,'_新疆_伊犁哈萨克自治州_察布查尔锡伯自治县_',0),(1719,'霍城县',1714,3,'_新疆_伊犁哈萨克自治州_霍城县_',0),(1720,'巩留县',1714,3,'_新疆_伊犁哈萨克自治州_巩留县_',0),(1721,'新源县',1714,3,'_新疆_伊犁哈萨克自治州_新源县_',0),(1722,'昭苏县',1714,3,'_新疆_伊犁哈萨克自治州_昭苏县_',0),(1723,'特克斯县',1714,3,'_新疆_伊犁哈萨克自治州_特克斯县_',0),(1724,'尼勒克县',1714,3,'_新疆_伊犁哈萨克自治州_尼勒克县_',0),(1725,'塔城地区',1631,2,'_新疆_塔城地区_',0),(1726,'塔城市',1725,3,'_新疆_塔城地区_塔城市_',0),(1727,'乌苏市',1725,3,'_新疆_塔城地区_乌苏市_',0),(1728,'额敏县',1725,3,'_新疆_塔城地区_额敏县_',0),(1729,'沙湾县',1725,3,'_新疆_塔城地区_沙湾县_',0),(1730,'托里县',1725,3,'_新疆_塔城地区_托里县_',0),(1731,'裕民县',1725,3,'_新疆_塔城地区_裕民县_',0),(1732,'和布克赛尔蒙古自治县',1725,3,'_新疆_塔城地区_和布克赛尔蒙古自治县_',0),(1733,'阿勒泰地区',1631,2,'_新疆_阿勒泰地区_',0),(1734,'阿勒泰市',1733,3,'_新疆_阿勒泰地区_阿勒泰市_',0),(1735,'布尔津县',1733,3,'_新疆_阿勒泰地区_布尔津县_',0),(1736,'富蕴县',1733,3,'_新疆_阿勒泰地区_富蕴县_',0),(1737,'福海县',1733,3,'_新疆_阿勒泰地区_福海县_',0),(1738,'哈巴河县',1733,3,'_新疆_阿勒泰地区_哈巴河县_',0),(1739,'青河县',1733,3,'_新疆_阿勒泰地区_青河县_',0),(1740,'吉木乃县',1733,3,'_新疆_阿勒泰地区_吉木乃县_',0),(1741,'省直辖行政单位',1631,2,'_新疆_省直辖行政单位_',0),(1742,'石河子市',1741,3,'_新疆_省直辖行政单位_石河子市_',0),(1743,'阿拉尔市',1741,3,'_新疆_省直辖行政单位_阿拉尔市_',0),(1744,'图木舒克市',1741,3,'_新疆_省直辖行政单位_图木舒克市_',0),(1745,'五家渠市',1741,3,'_新疆_省直辖行政单位_五家渠市_',0),(1746,'河北',0,1,'_河北_',0),(1747,'石家庄市',1746,2,'_河北_石家庄市_',0),(1748,'长安区',1747,3,'_河北_石家庄市_长安区_',0),(1749,'桥东区',1747,3,'_河北_石家庄市_桥东区_',0),(1750,'桥西区',1747,3,'_河北_石家庄市_桥西区_',0),(1751,'新华区',1747,3,'_河北_石家庄市_新华区_',0),(1752,'井陉矿区',1747,3,'_河北_石家庄市_井陉矿区_',0),(1753,'裕华区',1747,3,'_河北_石家庄市_裕华区_',0),(1754,'井陉县',1747,3,'_河北_石家庄市_井陉县_',0),(1755,'正定县',1747,3,'_河北_石家庄市_正定县_',0),(1756,'栾城县',1747,3,'_河北_石家庄市_栾城县_',0),(1757,'行唐县',1747,3,'_河北_石家庄市_行唐县_',0),(1758,'灵寿县',1747,3,'_河北_石家庄市_灵寿县_',0),(1759,'高邑县',1747,3,'_河北_石家庄市_高邑县_',0),(1760,'深泽县',1747,3,'_河北_石家庄市_深泽县_',0),(1761,'赞皇县',1747,3,'_河北_石家庄市_赞皇县_',0),(1762,'无极县',1747,3,'_河北_石家庄市_无极县_',0),(1763,'平山县',1747,3,'_河北_石家庄市_平山县_',0),(1764,'元氏县',1747,3,'_河北_石家庄市_元氏县_',0),(1765,'赵　县',1747,3,'_河北_石家庄市_赵　县_',0),(1766,'辛集市',1747,3,'_河北_石家庄市_辛集市_',0),(1767,'藁城市',1747,3,'_河北_石家庄市_藁城市_',0),(1768,'晋州市',1747,3,'_河北_石家庄市_晋州市_',0),(1769,'新乐市',1747,3,'_河北_石家庄市_新乐市_',0),(1770,'鹿泉市',1747,3,'_河北_石家庄市_鹿泉市_',0),(1771,'唐山市',1746,2,'_河北_唐山市_',0),(1772,'路南区',1771,3,'_河北_唐山市_路南区_',0),(1773,'路北区',1771,3,'_河北_唐山市_路北区_',0),(1774,'古冶区',1771,3,'_河北_唐山市_古冶区_',0),(1775,'开平区',1771,3,'_河北_唐山市_开平区_',0),(1776,'丰南区',1771,3,'_河北_唐山市_丰南区_',0),(1777,'丰润区',1771,3,'_河北_唐山市_丰润区_',0),(1778,'滦　县',1771,3,'_河北_唐山市_滦　县_',0),(1779,'滦南县',1771,3,'_河北_唐山市_滦南县_',0),(1780,'乐亭县',1771,3,'_河北_唐山市_乐亭县_',0),(1781,'迁西县',1771,3,'_河北_唐山市_迁西县_',0),(1782,'玉田县',1771,3,'_河北_唐山市_玉田县_',0),(1783,'唐海县',1771,3,'_河北_唐山市_唐海县_',0),(1784,'遵化市',1771,3,'_河北_唐山市_遵化市_',0),(1785,'迁安市',1771,3,'_河北_唐山市_迁安市_',0),(1786,'秦皇岛市',1746,2,'_河北_秦皇岛市_',0),(1787,'海港区',1786,3,'_河北_秦皇岛市_海港区_',0),(1788,'山海关区',1786,3,'_河北_秦皇岛市_山海关区_',0),(1789,'北戴河区',1786,3,'_河北_秦皇岛市_北戴河区_',0),(1790,'青龙满族自治县',1786,3,'_河北_秦皇岛市_青龙满族自治县_',0),(1791,'昌黎县',1786,3,'_河北_秦皇岛市_昌黎县_',0),(1792,'抚宁县',1786,3,'_河北_秦皇岛市_抚宁县_',0),(1793,'卢龙县',1786,3,'_河北_秦皇岛市_卢龙县_',0),(1794,'邯郸市',1746,2,'_河北_邯郸市_',0),(1795,'邯山区',1794,3,'_河北_邯郸市_邯山区_',0),(1796,'丛台区',1794,3,'_河北_邯郸市_丛台区_',0),(1797,'复兴区',1794,3,'_河北_邯郸市_复兴区_',0),(1798,'峰峰矿区',1794,3,'_河北_邯郸市_峰峰矿区_',0),(1799,'邯郸县',1794,3,'_河北_邯郸市_邯郸县_',0),(1800,'临漳县',1794,3,'_河北_邯郸市_临漳县_',0),(1801,'成安县',1794,3,'_河北_邯郸市_成安县_',0),(1802,'大名县',1794,3,'_河北_邯郸市_大名县_',0),(1803,'涉　县',1794,3,'_河北_邯郸市_涉　县_',0),(1804,'磁　县',1794,3,'_河北_邯郸市_磁　县_',0),(1805,'肥乡县',1794,3,'_河北_邯郸市_肥乡县_',0),(1806,'永年县',1794,3,'_河北_邯郸市_永年县_',0),(1807,'邱　县',1794,3,'_河北_邯郸市_邱　县_',0),(1808,'鸡泽县',1794,3,'_河北_邯郸市_鸡泽县_',0),(1809,'广平县',1794,3,'_河北_邯郸市_广平县_',0),(1810,'馆陶县',1794,3,'_河北_邯郸市_馆陶县_',0),(1811,'魏　县',1794,3,'_河北_邯郸市_魏　县_',0),(1812,'曲周县',1794,3,'_河北_邯郸市_曲周县_',0),(1813,'武安市',1794,3,'_河北_邯郸市_武安市_',0),(1814,'邢台市',1746,2,'_河北_邢台市_',0),(1815,'桥东区',1814,3,'_河北_邢台市_桥东区_',0),(1816,'桥西区',1814,3,'_河北_邢台市_桥西区_',0),(1817,'邢台县',1814,3,'_河北_邢台市_邢台县_',0),(1818,'临城县',1814,3,'_河北_邢台市_临城县_',0),(1819,'内丘县',1814,3,'_河北_邢台市_内丘县_',0),(1820,'柏乡县',1814,3,'_河北_邢台市_柏乡县_',0),(1821,'隆尧县',1814,3,'_河北_邢台市_隆尧县_',0),(1822,'任　县',1814,3,'_河北_邢台市_任　县_',0),(1823,'南和县',1814,3,'_河北_邢台市_南和县_',0),(1824,'宁晋县',1814,3,'_河北_邢台市_宁晋县_',0),(1825,'巨鹿县',1814,3,'_河北_邢台市_巨鹿县_',0),(1826,'新河县',1814,3,'_河北_邢台市_新河县_',0),(1827,'广宗县',1814,3,'_河北_邢台市_广宗县_',0),(1828,'平乡县',1814,3,'_河北_邢台市_平乡县_',0),(1829,'威　县',1814,3,'_河北_邢台市_威　县_',0),(1830,'清河县',1814,3,'_河北_邢台市_清河县_',0),(1831,'临西县',1814,3,'_河北_邢台市_临西县_',0),(1832,'南宫市',1814,3,'_河北_邢台市_南宫市_',0),(1833,'沙河市',1814,3,'_河北_邢台市_沙河市_',0),(1834,'保定市',1746,2,'_河北_保定市_',0),(1835,'新市区',1834,3,'_河北_保定市_新市区_',0),(1836,'北市区',1834,3,'_河北_保定市_北市区_',0),(1837,'南市区',1834,3,'_河北_保定市_南市区_',0),(1838,'满城县',1834,3,'_河北_保定市_满城县_',0),(1839,'清苑县',1834,3,'_河北_保定市_清苑县_',0),(1840,'涞水县',1834,3,'_河北_保定市_涞水县_',0),(1841,'阜平县',1834,3,'_河北_保定市_阜平县_',0),(1842,'徐水县',1834,3,'_河北_保定市_徐水县_',0),(1843,'定兴县',1834,3,'_河北_保定市_定兴县_',0),(1844,'唐　县',1834,3,'_河北_保定市_唐　县_',0),(1845,'高阳县',1834,3,'_河北_保定市_高阳县_',0),(1846,'容城县',1834,3,'_河北_保定市_容城县_',0),(1847,'涞源县',1834,3,'_河北_保定市_涞源县_',0),(1848,'望都县',1834,3,'_河北_保定市_望都县_',0),(1849,'安新县',1834,3,'_河北_保定市_安新县_',0),(1850,'易　县',1834,3,'_河北_保定市_易　县_',0),(1851,'曲阳县',1834,3,'_河北_保定市_曲阳县_',0),(1852,'蠡　县',1834,3,'_河北_保定市_蠡　县_',0),(1853,'顺平县',1834,3,'_河北_保定市_顺平县_',0),(1854,'博野县',1834,3,'_河北_保定市_博野县_',0),(1855,'雄　县',1834,3,'_河北_保定市_雄　县_',0),(1856,'涿州市',1834,3,'_河北_保定市_涿州市_',0),(1857,'定州市',1834,3,'_河北_保定市_定州市_',0),(1858,'安国市',1834,3,'_河北_保定市_安国市_',0),(1859,'高碑店市',1834,3,'_河北_保定市_高碑店市_',0),(1860,'张家口市',1746,2,'_河北_张家口市_',0),(1861,'桥东区',1860,3,'_河北_张家口市_桥东区_',0),(1862,'桥西区',1860,3,'_河北_张家口市_桥西区_',0),(1863,'宣化区',1860,3,'_河北_张家口市_宣化区_',0),(1864,'下花园区',1860,3,'_河北_张家口市_下花园区_',0),(1865,'宣化县',1860,3,'_河北_张家口市_宣化县_',0),(1866,'张北县',1860,3,'_河北_张家口市_张北县_',0),(1867,'康保县',1860,3,'_河北_张家口市_康保县_',0),(1868,'沽源县',1860,3,'_河北_张家口市_沽源县_',0),(1869,'尚义县',1860,3,'_河北_张家口市_尚义县_',0),(1870,'蔚　县',1860,3,'_河北_张家口市_蔚　县_',0),(1871,'阳原县',1860,3,'_河北_张家口市_阳原县_',0),(1872,'怀安县',1860,3,'_河北_张家口市_怀安县_',0),(1873,'万全县',1860,3,'_河北_张家口市_万全县_',0),(1874,'怀来县',1860,3,'_河北_张家口市_怀来县_',0),(1875,'涿鹿县',1860,3,'_河北_张家口市_涿鹿县_',0),(1876,'赤城县',1860,3,'_河北_张家口市_赤城县_',0),(1877,'崇礼县',1860,3,'_河北_张家口市_崇礼县_',0),(1878,'承德市',1746,2,'_河北_承德市_',0),(1879,'双桥区',1878,3,'_河北_承德市_双桥区_',0),(1880,'双滦区',1878,3,'_河北_承德市_双滦区_',0),(1881,'鹰手营子矿区',1878,3,'_河北_承德市_鹰手营子矿区_',0),(1882,'承德县',1878,3,'_河北_承德市_承德县_',0),(1883,'兴隆县',1878,3,'_河北_承德市_兴隆县_',0),(1884,'平泉县',1878,3,'_河北_承德市_平泉县_',0),(1885,'滦平县',1878,3,'_河北_承德市_滦平县_',0),(1886,'隆化县',1878,3,'_河北_承德市_隆化县_',0),(1887,'丰宁满族自治县',1878,3,'_河北_承德市_丰宁满族自治县_',0),(1888,'宽城满族自治县',1878,3,'_河北_承德市_宽城满族自治县_',0),(1889,'围场满族蒙古族自治县',1878,3,'_河北_承德市_围场满族蒙古族自治县_',0),(1890,'沧州市',1746,2,'_河北_沧州市_',0),(1891,'新华区',1890,3,'_河北_沧州市_新华区_',0),(1892,'运河区',1890,3,'_河北_沧州市_运河区_',0),(1893,'沧　县',1890,3,'_河北_沧州市_沧　县_',0),(1894,'青　县',1890,3,'_河北_沧州市_青　县_',0),(1895,'东光县',1890,3,'_河北_沧州市_东光县_',0),(1896,'海兴县',1890,3,'_河北_沧州市_海兴县_',0),(1897,'盐山县',1890,3,'_河北_沧州市_盐山县_',0),(1898,'肃宁县',1890,3,'_河北_沧州市_肃宁县_',0),(1899,'南皮县',1890,3,'_河北_沧州市_南皮县_',0),(1900,'吴桥县',1890,3,'_河北_沧州市_吴桥县_',0),(1901,'献　县',1890,3,'_河北_沧州市_献　县_',0),(1902,'孟村回族自治县',1890,3,'_河北_沧州市_孟村回族自治县_',0),(1903,'泊头市',1890,3,'_河北_沧州市_泊头市_',0),(1904,'任丘市',1890,3,'_河北_沧州市_任丘市_',0),(1905,'黄骅市',1890,3,'_河北_沧州市_黄骅市_',0),(1906,'河间市',1890,3,'_河北_沧州市_河间市_',0),(1907,'廊坊市',1746,2,'_河北_廊坊市_',0),(1908,'安次区',1907,3,'_河北_廊坊市_安次区_',0),(1909,'广阳区',1907,3,'_河北_廊坊市_广阳区_',0),(1910,'固安县',1907,3,'_河北_廊坊市_固安县_',0),(1911,'永清县',1907,3,'_河北_廊坊市_永清县_',0),(1912,'香河县',1907,3,'_河北_廊坊市_香河县_',0),(1913,'大城县',1907,3,'_河北_廊坊市_大城县_',0),(1914,'文安县',1907,3,'_河北_廊坊市_文安县_',0),(1915,'大厂回族自治县',1907,3,'_河北_廊坊市_大厂回族自治县_',0),(1916,'霸州市',1907,3,'_河北_廊坊市_霸州市_',0),(1917,'三河市',1907,3,'_河北_廊坊市_三河市_',0),(1918,'衡水市',1746,2,'_河北_衡水市_',0),(1919,'桃城区',1918,3,'_河北_衡水市_桃城区_',0),(1920,'枣强县',1918,3,'_河北_衡水市_枣强县_',0),(1921,'武邑县',1918,3,'_河北_衡水市_武邑县_',0),(1922,'武强县',1918,3,'_河北_衡水市_武强县_',0),(1923,'饶阳县',1918,3,'_河北_衡水市_饶阳县_',0),(1924,'安平县',1918,3,'_河北_衡水市_安平县_',0),(1925,'故城县',1918,3,'_河北_衡水市_故城县_',0),(1926,'景　县',1918,3,'_河北_衡水市_景　县_',0),(1927,'阜城县',1918,3,'_河北_衡水市_阜城县_',0),(1928,'冀州市',1918,3,'_河北_衡水市_冀州市_',0),(1929,'深州市',1918,3,'_河北_衡水市_深州市_',0),(1930,'山西',0,1,'_山西_',0),(1931,'太原市',1930,2,'_山西_太原市_',0),(1932,'小店区',1931,3,'_山西_太原市_小店区_',0),(1933,'迎泽区',1931,3,'_山西_太原市_迎泽区_',0),(1934,'杏花岭区',1931,3,'_山西_太原市_杏花岭区_',0),(1935,'尖草坪区',1931,3,'_山西_太原市_尖草坪区_',0),(1936,'万柏林区',1931,3,'_山西_太原市_万柏林区_',0),(1937,'晋源区',1931,3,'_山西_太原市_晋源区_',0),(1938,'清徐县',1931,3,'_山西_太原市_清徐县_',0),(1939,'阳曲县',1931,3,'_山西_太原市_阳曲县_',0),(1940,'娄烦县',1931,3,'_山西_太原市_娄烦县_',0),(1941,'古交市',1931,3,'_山西_太原市_古交市_',0),(1942,'大同市',1930,2,'_山西_大同市_',0),(1943,'城　区',1942,3,'_山西_大同市_城　区_',0),(1944,'矿　区',1942,3,'_山西_大同市_矿　区_',0),(1945,'南郊区',1942,3,'_山西_大同市_南郊区_',0),(1946,'新荣区',1942,3,'_山西_大同市_新荣区_',0),(1947,'阳高县',1942,3,'_山西_大同市_阳高县_',0),(1948,'天镇县',1942,3,'_山西_大同市_天镇县_',0),(1949,'广灵县',1942,3,'_山西_大同市_广灵县_',0),(1950,'灵丘县',1942,3,'_山西_大同市_灵丘县_',0),(1951,'浑源县',1942,3,'_山西_大同市_浑源县_',0),(1952,'左云县',1942,3,'_山西_大同市_左云县_',0),(1953,'大同县',1942,3,'_山西_大同市_大同县_',0),(1954,'阳泉市',1930,2,'_山西_阳泉市_',0),(1955,'城　区',1954,3,'_山西_阳泉市_城　区_',0),(1956,'矿　区',1954,3,'_山西_阳泉市_矿　区_',0),(1957,'郊　区',1954,3,'_山西_阳泉市_郊　区_',0),(1958,'平定县',1954,3,'_山西_阳泉市_平定县_',0),(1959,'盂　县',1954,3,'_山西_阳泉市_盂　县_',0),(1960,'长治市',1930,2,'_山西_长治市_',0),(1961,'城　区',1960,3,'_山西_长治市_城　区_',0),(1962,'郊　区',1960,3,'_山西_长治市_郊　区_',0),(1963,'长治县',1960,3,'_山西_长治市_长治县_',0),(1964,'襄垣县',1960,3,'_山西_长治市_襄垣县_',0),(1965,'屯留县',1960,3,'_山西_长治市_屯留县_',0),(1966,'平顺县',1960,3,'_山西_长治市_平顺县_',0),(1967,'黎城县',1960,3,'_山西_长治市_黎城县_',0),(1968,'壶关县',1960,3,'_山西_长治市_壶关县_',0),(1969,'长子县',1960,3,'_山西_长治市_长子县_',0),(1970,'武乡县',1960,3,'_山西_长治市_武乡县_',0),(1971,'沁　县',1960,3,'_山西_长治市_沁　县_',0),(1972,'沁源县',1960,3,'_山西_长治市_沁源县_',0),(1973,'潞城市',1960,3,'_山西_长治市_潞城市_',0),(1974,'晋城市',1930,2,'_山西_晋城市_',0),(1975,'城　区',1974,3,'_山西_晋城市_城　区_',0),(1976,'沁水县',1974,3,'_山西_晋城市_沁水县_',0),(1977,'阳城县',1974,3,'_山西_晋城市_阳城县_',0),(1978,'陵川县',1974,3,'_山西_晋城市_陵川县_',0),(1979,'泽州县',1974,3,'_山西_晋城市_泽州县_',0),(1980,'高平市',1974,3,'_山西_晋城市_高平市_',0),(1981,'朔州市',1930,2,'_山西_朔州市_',0),(1982,'朔城区',1981,3,'_山西_朔州市_朔城区_',0),(1983,'平鲁区',1981,3,'_山西_朔州市_平鲁区_',0),(1984,'山阴县',1981,3,'_山西_朔州市_山阴县_',0),(1985,'应　县',1981,3,'_山西_朔州市_应　县_',0),(1986,'右玉县',1981,3,'_山西_朔州市_右玉县_',0),(1987,'怀仁县',1981,3,'_山西_朔州市_怀仁县_',0),(1988,'晋中市',1930,2,'_山西_晋中市_',0),(1989,'榆次区',1988,3,'_山西_晋中市_榆次区_',0),(1990,'榆社县',1988,3,'_山西_晋中市_榆社县_',0),(1991,'左权县',1988,3,'_山西_晋中市_左权县_',0),(1992,'和顺县',1988,3,'_山西_晋中市_和顺县_',0),(1993,'昔阳县',1988,3,'_山西_晋中市_昔阳县_',0),(1994,'寿阳县',1988,3,'_山西_晋中市_寿阳县_',0),(1995,'太谷县',1988,3,'_山西_晋中市_太谷县_',0),(1996,'祁　县',1988,3,'_山西_晋中市_祁　县_',0),(1997,'平遥县',1988,3,'_山西_晋中市_平遥县_',0),(1998,'灵石县',1988,3,'_山西_晋中市_灵石县_',0),(1999,'介休市',1988,3,'_山西_晋中市_介休市_',0),(2000,'运城市',1930,2,'_山西_运城市_',0),(2001,'盐湖区',2000,3,'_山西_运城市_盐湖区_',0),(2002,'临猗县',2000,3,'_山西_运城市_临猗县_',0),(2003,'万荣县',2000,3,'_山西_运城市_万荣县_',0),(2004,'闻喜县',2000,3,'_山西_运城市_闻喜县_',0),(2005,'稷山县',2000,3,'_山西_运城市_稷山县_',0),(2006,'新绛县',2000,3,'_山西_运城市_新绛县_',0),(2007,'绛　县',2000,3,'_山西_运城市_绛　县_',0),(2008,'垣曲县',2000,3,'_山西_运城市_垣曲县_',0),(2009,'夏　县',2000,3,'_山西_运城市_夏　县_',0),(2010,'平陆县',2000,3,'_山西_运城市_平陆县_',0),(2011,'芮城县',2000,3,'_山西_运城市_芮城县_',0),(2012,'永济市',2000,3,'_山西_运城市_永济市_',0),(2013,'河津市',2000,3,'_山西_运城市_河津市_',0),(2014,'忻州市',1930,2,'_山西_忻州市_',0),(2015,'忻府区',2014,3,'_山西_忻州市_忻府区_',0),(2016,'定襄县',2014,3,'_山西_忻州市_定襄县_',0),(2017,'五台县',2014,3,'_山西_忻州市_五台县_',0),(2018,'代　县',2014,3,'_山西_忻州市_代　县_',0),(2019,'繁峙县',2014,3,'_山西_忻州市_繁峙县_',0),(2020,'宁武县',2014,3,'_山西_忻州市_宁武县_',0),(2021,'静乐县',2014,3,'_山西_忻州市_静乐县_',0),(2022,'神池县',2014,3,'_山西_忻州市_神池县_',0),(2023,'五寨县',2014,3,'_山西_忻州市_五寨县_',0),(2024,'岢岚县',2014,3,'_山西_忻州市_岢岚县_',0),(2025,'河曲县',2014,3,'_山西_忻州市_河曲县_',0),(2026,'保德县',2014,3,'_山西_忻州市_保德县_',0),(2027,'偏关县',2014,3,'_山西_忻州市_偏关县_',0),(2028,'原平市',2014,3,'_山西_忻州市_原平市_',0),(2029,'临汾市',1930,2,'_山西_临汾市_',0),(2030,'尧都区',2029,3,'_山西_临汾市_尧都区_',0),(2031,'曲沃县',2029,3,'_山西_临汾市_曲沃县_',0),(2032,'翼城县',2029,3,'_山西_临汾市_翼城县_',0),(2033,'襄汾县',2029,3,'_山西_临汾市_襄汾县_',0),(2034,'洪洞县',2029,3,'_山西_临汾市_洪洞县_',0),(2035,'古　县',2029,3,'_山西_临汾市_古　县_',0),(2036,'安泽县',2029,3,'_山西_临汾市_安泽县_',0),(2037,'浮山县',2029,3,'_山西_临汾市_浮山县_',0),(2038,'吉　县',2029,3,'_山西_临汾市_吉　县_',0),(2039,'乡宁县',2029,3,'_山西_临汾市_乡宁县_',0),(2040,'大宁县',2029,3,'_山西_临汾市_大宁县_',0),(2041,'隰　县',2029,3,'_山西_临汾市_隰　县_',0),(2042,'永和县',2029,3,'_山西_临汾市_永和县_',0),(2043,'蒲　县',2029,3,'_山西_临汾市_蒲　县_',0),(2044,'汾西县',2029,3,'_山西_临汾市_汾西县_',0),(2045,'侯马市',2029,3,'_山西_临汾市_侯马市_',0),(2046,'霍州市',2029,3,'_山西_临汾市_霍州市_',0),(2047,'吕梁市',1930,2,'_山西_吕梁市_',0),(2048,'离石区',2047,3,'_山西_吕梁市_离石区_',0),(2049,'文水县',2047,3,'_山西_吕梁市_文水县_',0),(2050,'交城县',2047,3,'_山西_吕梁市_交城县_',0),(2051,'兴　县',2047,3,'_山西_吕梁市_兴　县_',0),(2052,'临　县',2047,3,'_山西_吕梁市_临　县_',0),(2053,'柳林县',2047,3,'_山西_吕梁市_柳林县_',0),(2054,'石楼县',2047,3,'_山西_吕梁市_石楼县_',0),(2055,'岚　县',2047,3,'_山西_吕梁市_岚　县_',0),(2056,'方山县',2047,3,'_山西_吕梁市_方山县_',0),(2057,'中阳县',2047,3,'_山西_吕梁市_中阳县_',0),(2058,'交口县',2047,3,'_山西_吕梁市_交口县_',0),(2059,'孝义市',2047,3,'_山西_吕梁市_孝义市_',0),(2060,'汾阳市',2047,3,'_山西_吕梁市_汾阳市_',0),(2061,'内蒙古',0,1,'_内蒙古_',0),(2062,'呼和浩特市',2061,2,'_内蒙古_呼和浩特市_',0),(2063,'新城区',2062,3,'_内蒙古_呼和浩特市_新城区_',0),(2064,'回民区',2062,3,'_内蒙古_呼和浩特市_回民区_',0),(2065,'玉泉区',2062,3,'_内蒙古_呼和浩特市_玉泉区_',0),(2066,'赛罕区',2062,3,'_内蒙古_呼和浩特市_赛罕区_',0),(2067,'土默特左旗',2062,3,'_内蒙古_呼和浩特市_土默特左旗_',0),(2068,'托克托县',2062,3,'_内蒙古_呼和浩特市_托克托县_',0),(2069,'和林格尔县',2062,3,'_内蒙古_呼和浩特市_和林格尔县_',0),(2070,'清水河县',2062,3,'_内蒙古_呼和浩特市_清水河县_',0),(2071,'武川县',2062,3,'_内蒙古_呼和浩特市_武川县_',0),(2072,'包头市',2061,2,'_内蒙古_包头市_',0),(2073,'东河区',2072,3,'_内蒙古_包头市_东河区_',0),(2074,'昆都仑区',2072,3,'_内蒙古_包头市_昆都仑区_',0),(2075,'青山区',2072,3,'_内蒙古_包头市_青山区_',0),(2076,'石拐区',2072,3,'_内蒙古_包头市_石拐区_',0),(2077,'白云矿区',2072,3,'_内蒙古_包头市_白云矿区_',0),(2078,'九原区',2072,3,'_内蒙古_包头市_九原区_',0),(2079,'土默特右旗',2072,3,'_内蒙古_包头市_土默特右旗_',0),(2080,'固阳县',2072,3,'_内蒙古_包头市_固阳县_',0),(2081,'达尔罕茂明安联合旗',2072,3,'_内蒙古_包头市_达尔罕茂明安联合旗_',0),(2082,'乌海市',2061,2,'_内蒙古_乌海市_',0),(2083,'海勃湾区',2082,3,'_内蒙古_乌海市_海勃湾区_',0),(2084,'海南区',2082,3,'_内蒙古_乌海市_海南区_',0),(2085,'乌达区',2082,3,'_内蒙古_乌海市_乌达区_',0),(2086,'赤峰市',2061,2,'_内蒙古_赤峰市_',0),(2087,'红山区',2086,3,'_内蒙古_赤峰市_红山区_',0),(2088,'元宝山区',2086,3,'_内蒙古_赤峰市_元宝山区_',0),(2089,'松山区',2086,3,'_内蒙古_赤峰市_松山区_',0),(2090,'阿鲁科尔沁旗',2086,3,'_内蒙古_赤峰市_阿鲁科尔沁旗_',0),(2091,'巴林左旗',2086,3,'_内蒙古_赤峰市_巴林左旗_',0),(2092,'巴林右旗',2086,3,'_内蒙古_赤峰市_巴林右旗_',0),(2093,'林西县',2086,3,'_内蒙古_赤峰市_林西县_',0),(2094,'克什克腾旗',2086,3,'_内蒙古_赤峰市_克什克腾旗_',0),(2095,'翁牛特旗',2086,3,'_内蒙古_赤峰市_翁牛特旗_',0),(2096,'喀喇沁旗',2086,3,'_内蒙古_赤峰市_喀喇沁旗_',0),(2097,'宁城县',2086,3,'_内蒙古_赤峰市_宁城县_',0),(2098,'敖汉旗',2086,3,'_内蒙古_赤峰市_敖汉旗_',0),(2099,'通辽市',2061,2,'_内蒙古_通辽市_',0),(2100,'科尔沁区',2099,3,'_内蒙古_通辽市_科尔沁区_',0),(2101,'科尔沁左翼中旗',2099,3,'_内蒙古_通辽市_科尔沁左翼中旗_',0),(2102,'科尔沁左翼后旗',2099,3,'_内蒙古_通辽市_科尔沁左翼后旗_',0),(2103,'开鲁县',2099,3,'_内蒙古_通辽市_开鲁县_',0),(2104,'库伦旗',2099,3,'_内蒙古_通辽市_库伦旗_',0),(2105,'奈曼旗',2099,3,'_内蒙古_通辽市_奈曼旗_',0),(2106,'扎鲁特旗',2099,3,'_内蒙古_通辽市_扎鲁特旗_',0),(2107,'霍林郭勒市',2099,3,'_内蒙古_通辽市_霍林郭勒市_',0),(2108,'鄂尔多斯市',2061,2,'_内蒙古_鄂尔多斯市_',0),(2109,'东胜区',2108,3,'_内蒙古_鄂尔多斯市_东胜区_',0),(2110,'达拉特旗',2108,3,'_内蒙古_鄂尔多斯市_达拉特旗_',0),(2111,'准格尔旗',2108,3,'_内蒙古_鄂尔多斯市_准格尔旗_',0),(2112,'鄂托克前旗',2108,3,'_内蒙古_鄂尔多斯市_鄂托克前旗_',0),(2113,'鄂托克旗',2108,3,'_内蒙古_鄂尔多斯市_鄂托克旗_',0),(2114,'杭锦旗',2108,3,'_内蒙古_鄂尔多斯市_杭锦旗_',0),(2115,'乌审旗',2108,3,'_内蒙古_鄂尔多斯市_乌审旗_',0),(2116,'伊金霍洛旗',2108,3,'_内蒙古_鄂尔多斯市_伊金霍洛旗_',0),(2117,'呼伦贝尔市',2061,2,'_内蒙古_呼伦贝尔市_',0),(2118,'海拉尔区',2117,3,'_内蒙古_呼伦贝尔市_海拉尔区_',0),(2119,'阿荣旗',2117,3,'_内蒙古_呼伦贝尔市_阿荣旗_',0),(2120,'莫力达瓦达斡尔族自治旗',2117,3,'_内蒙古_呼伦贝尔市_莫力达瓦达斡尔族自治旗_',0),(2121,'鄂伦春自治旗',2117,3,'_内蒙古_呼伦贝尔市_鄂伦春自治旗_',0),(2122,'鄂温克族自治旗',2117,3,'_内蒙古_呼伦贝尔市_鄂温克族自治旗_',0),(2123,'陈巴尔虎旗',2117,3,'_内蒙古_呼伦贝尔市_陈巴尔虎旗_',0),(2124,'新巴尔虎左旗',2117,3,'_内蒙古_呼伦贝尔市_新巴尔虎左旗_',0),(2125,'新巴尔虎右旗',2117,3,'_内蒙古_呼伦贝尔市_新巴尔虎右旗_',0),(2126,'满洲里市',2117,3,'_内蒙古_呼伦贝尔市_满洲里市_',0),(2127,'牙克石市',2117,3,'_内蒙古_呼伦贝尔市_牙克石市_',0),(2128,'扎兰屯市',2117,3,'_内蒙古_呼伦贝尔市_扎兰屯市_',0),(2129,'额尔古纳市',2117,3,'_内蒙古_呼伦贝尔市_额尔古纳市_',0),(2130,'根河市',2117,3,'_内蒙古_呼伦贝尔市_根河市_',0),(2131,'巴彦淖尔市',2061,2,'_内蒙古_巴彦淖尔市_',0),(2132,'临河区',2131,3,'_内蒙古_巴彦淖尔市_临河区_',0),(2133,'五原县',2131,3,'_内蒙古_巴彦淖尔市_五原县_',0),(2134,'磴口县',2131,3,'_内蒙古_巴彦淖尔市_磴口县_',0),(2135,'乌拉特前旗',2131,3,'_内蒙古_巴彦淖尔市_乌拉特前旗_',0),(2136,'乌拉特中旗',2131,3,'_内蒙古_巴彦淖尔市_乌拉特中旗_',0),(2137,'乌拉特后旗',2131,3,'_内蒙古_巴彦淖尔市_乌拉特后旗_',0),(2138,'杭锦后旗',2131,3,'_内蒙古_巴彦淖尔市_杭锦后旗_',0),(2139,'乌兰察布市',2061,2,'_内蒙古_乌兰察布市_',0),(2140,'集宁区',2139,3,'_内蒙古_乌兰察布市_集宁区_',0),(2141,'卓资县',2139,3,'_内蒙古_乌兰察布市_卓资县_',0),(2142,'化德县',2139,3,'_内蒙古_乌兰察布市_化德县_',0),(2143,'商都县',2139,3,'_内蒙古_乌兰察布市_商都县_',0),(2144,'兴和县',2139,3,'_内蒙古_乌兰察布市_兴和县_',0),(2145,'凉城县',2139,3,'_内蒙古_乌兰察布市_凉城县_',0),(2146,'察哈尔右翼前旗',2139,3,'_内蒙古_乌兰察布市_察哈尔右翼前旗_',0),(2147,'察哈尔右翼中旗',2139,3,'_内蒙古_乌兰察布市_察哈尔右翼中旗_',0),(2148,'察哈尔右翼后旗',2139,3,'_内蒙古_乌兰察布市_察哈尔右翼后旗_',0),(2149,'四子王旗',2139,3,'_内蒙古_乌兰察布市_四子王旗_',0),(2150,'丰镇市',2139,3,'_内蒙古_乌兰察布市_丰镇市_',0),(2151,'兴安盟',2061,2,'_内蒙古_兴安盟_',0),(2152,'乌兰浩特市',2151,3,'_内蒙古_兴安盟_乌兰浩特市_',0),(2153,'阿尔山市',2151,3,'_内蒙古_兴安盟_阿尔山市_',0),(2154,'科尔沁右翼前旗',2151,3,'_内蒙古_兴安盟_科尔沁右翼前旗_',0),(2155,'科尔沁右翼中旗',2151,3,'_内蒙古_兴安盟_科尔沁右翼中旗_',0),(2156,'扎赉特旗',2151,3,'_内蒙古_兴安盟_扎赉特旗_',0),(2157,'突泉县',2151,3,'_内蒙古_兴安盟_突泉县_',0),(2158,'锡林郭勒盟',2061,2,'_内蒙古_锡林郭勒盟_',0),(2159,'二连浩特市',2158,3,'_内蒙古_锡林郭勒盟_二连浩特市_',0),(2160,'锡林浩特市',2158,3,'_内蒙古_锡林郭勒盟_锡林浩特市_',0),(2161,'阿巴嘎旗',2158,3,'_内蒙古_锡林郭勒盟_阿巴嘎旗_',0),(2162,'苏尼特左旗',2158,3,'_内蒙古_锡林郭勒盟_苏尼特左旗_',0),(2163,'苏尼特右旗',2158,3,'_内蒙古_锡林郭勒盟_苏尼特右旗_',0),(2164,'东乌珠穆沁旗',2158,3,'_内蒙古_锡林郭勒盟_东乌珠穆沁旗_',0),(2165,'西乌珠穆沁旗',2158,3,'_内蒙古_锡林郭勒盟_西乌珠穆沁旗_',0),(2166,'太仆寺旗',2158,3,'_内蒙古_锡林郭勒盟_太仆寺旗_',0),(2167,'镶黄旗',2158,3,'_内蒙古_锡林郭勒盟_镶黄旗_',0),(2168,'正镶白旗',2158,3,'_内蒙古_锡林郭勒盟_正镶白旗_',0),(2169,'正蓝旗',2158,3,'_内蒙古_锡林郭勒盟_正蓝旗_',0),(2170,'多伦县',2158,3,'_内蒙古_锡林郭勒盟_多伦县_',0),(2171,'阿拉善盟',2061,2,'_内蒙古_阿拉善盟_',0),(2172,'阿拉善左旗',2171,3,'_内蒙古_阿拉善盟_阿拉善左旗_',0),(2173,'阿拉善右旗',2171,3,'_内蒙古_阿拉善盟_阿拉善右旗_',0),(2174,'额济纳旗',2171,3,'_内蒙古_阿拉善盟_额济纳旗_',0),(2175,'江苏',0,1,'_江苏_',0),(2176,'南京市',2175,2,'_江苏_南京市_',0),(2177,'玄武区',2176,3,'_江苏_南京市_玄武区_',0),(2178,'白下区',2176,3,'_江苏_南京市_白下区_',0),(2179,'秦淮区',2176,3,'_江苏_南京市_秦淮区_',0),(2180,'建邺区',2176,3,'_江苏_南京市_建邺区_',0),(2181,'鼓楼区',2176,3,'_江苏_南京市_鼓楼区_',0),(2182,'下关区',2176,3,'_江苏_南京市_下关区_',0),(2183,'浦口区',2176,3,'_江苏_南京市_浦口区_',0),(2184,'栖霞区',2176,3,'_江苏_南京市_栖霞区_',0),(2185,'雨花台区',2176,3,'_江苏_南京市_雨花台区_',0),(2186,'江宁区',2176,3,'_江苏_南京市_江宁区_',0),(2187,'六合区',2176,3,'_江苏_南京市_六合区_',0),(2188,'溧水县',2176,3,'_江苏_南京市_溧水县_',0),(2189,'高淳县',2176,3,'_江苏_南京市_高淳县_',0),(2190,'无锡市',2175,2,'_江苏_无锡市_',0),(2191,'崇安区',2190,3,'_江苏_无锡市_崇安区_',0),(2192,'南长区',2190,3,'_江苏_无锡市_南长区_',0),(2193,'北塘区',2190,3,'_江苏_无锡市_北塘区_',0),(2194,'锡山区',2190,3,'_江苏_无锡市_锡山区_',0),(2195,'惠山区',2190,3,'_江苏_无锡市_惠山区_',0),(2196,'滨湖区',2190,3,'_江苏_无锡市_滨湖区_',0),(2197,'江阴市',2190,3,'_江苏_无锡市_江阴市_',0),(2198,'宜兴市',2190,3,'_江苏_无锡市_宜兴市_',0),(2199,'徐州市',2175,2,'_江苏_徐州市_',0),(2200,'鼓楼区',2199,3,'_江苏_徐州市_鼓楼区_',0),(2201,'云龙区',2199,3,'_江苏_徐州市_云龙区_',0),(2202,'九里区',2199,3,'_江苏_徐州市_九里区_',0),(2203,'贾汪区',2199,3,'_江苏_徐州市_贾汪区_',0),(2204,'泉山区',2199,3,'_江苏_徐州市_泉山区_',0),(2205,'丰　县',2199,3,'_江苏_徐州市_丰　县_',0),(2206,'沛　县',2199,3,'_江苏_徐州市_沛　县_',0),(2207,'铜山县',2199,3,'_江苏_徐州市_铜山县_',0),(2208,'睢宁县',2199,3,'_江苏_徐州市_睢宁县_',0),(2209,'新沂市',2199,3,'_江苏_徐州市_新沂市_',0),(2210,'邳州市',2199,3,'_江苏_徐州市_邳州市_',0),(2211,'常州市',2175,2,'_江苏_常州市_',0),(2212,'天宁区',2211,3,'_江苏_常州市_天宁区_',0),(2213,'钟楼区',2211,3,'_江苏_常州市_钟楼区_',0),(2214,'戚墅堰区',2211,3,'_江苏_常州市_戚墅堰区_',0),(2215,'新北区',2211,3,'_江苏_常州市_新北区_',0),(2216,'武进区',2211,3,'_江苏_常州市_武进区_',0),(2217,'溧阳市',2211,3,'_江苏_常州市_溧阳市_',0),(2218,'金坛市',2211,3,'_江苏_常州市_金坛市_',0),(2219,'苏州市',2175,2,'_江苏_苏州市_',0),(2220,'沧浪区',2219,3,'_江苏_苏州市_沧浪区_',0),(2221,'平江区',2219,3,'_江苏_苏州市_平江区_',0),(2222,'金阊区',2219,3,'_江苏_苏州市_金阊区_',0),(2223,'虎丘区',2219,3,'_江苏_苏州市_虎丘区_',0),(2224,'吴中区',2219,3,'_江苏_苏州市_吴中区_',0),(2225,'相城区',2219,3,'_江苏_苏州市_相城区_',0),(2226,'常熟市',2219,3,'_江苏_苏州市_常熟市_',0),(2227,'张家港市',2219,3,'_江苏_苏州市_张家港市_',0),(2228,'昆山市',2219,3,'_江苏_苏州市_昆山市_',0),(2229,'吴江市',2219,3,'_江苏_苏州市_吴江市_',0),(2230,'太仓市',2219,3,'_江苏_苏州市_太仓市_',0),(2231,'南通市',2175,2,'_江苏_南通市_',0),(2232,'崇川区',2231,3,'_江苏_南通市_崇川区_',0),(2233,'港闸区',2231,3,'_江苏_南通市_港闸区_',0),(2234,'海安县',2231,3,'_江苏_南通市_海安县_',0),(2235,'如东县',2231,3,'_江苏_南通市_如东县_',0),(2236,'启东市',2231,3,'_江苏_南通市_启东市_',0),(2237,'如皋市',2231,3,'_江苏_南通市_如皋市_',0),(2238,'通州市',2231,3,'_江苏_南通市_通州市_',0),(2239,'海门市',2231,3,'_江苏_南通市_海门市_',0),(2240,'连云港市',2175,2,'_江苏_连云港市_',0),(2241,'连云区',2240,3,'_江苏_连云港市_连云区_',0),(2242,'新浦区',2240,3,'_江苏_连云港市_新浦区_',0),(2243,'海州区',2240,3,'_江苏_连云港市_海州区_',0),(2244,'赣榆县',2240,3,'_江苏_连云港市_赣榆县_',0),(2245,'东海县',2240,3,'_江苏_连云港市_东海县_',0),(2246,'灌云县',2240,3,'_江苏_连云港市_灌云县_',0),(2247,'灌南县',2240,3,'_江苏_连云港市_灌南县_',0),(2248,'淮安市',2175,2,'_江苏_淮安市_',0),(2249,'清河区',2248,3,'_江苏_淮安市_清河区_',0),(2250,'楚州区',2248,3,'_江苏_淮安市_楚州区_',0),(2251,'淮阴区',2248,3,'_江苏_淮安市_淮阴区_',0),(2252,'清浦区',2248,3,'_江苏_淮安市_清浦区_',0),(2253,'涟水县',2248,3,'_江苏_淮安市_涟水县_',0),(2254,'洪泽县',2248,3,'_江苏_淮安市_洪泽县_',0),(2255,'盱眙县',2248,3,'_江苏_淮安市_盱眙县_',0),(2256,'金湖县',2248,3,'_江苏_淮安市_金湖县_',0),(2257,'盐城市',2175,2,'_江苏_盐城市_',0),(2258,'亭湖区',2257,3,'_江苏_盐城市_亭湖区_',0),(2259,'盐都区',2257,3,'_江苏_盐城市_盐都区_',0),(2260,'响水县',2257,3,'_江苏_盐城市_响水县_',0),(2261,'滨海县',2257,3,'_江苏_盐城市_滨海县_',0),(2262,'阜宁县',2257,3,'_江苏_盐城市_阜宁县_',0),(2263,'射阳县',2257,3,'_江苏_盐城市_射阳县_',0),(2264,'建湖县',2257,3,'_江苏_盐城市_建湖县_',0),(2265,'东台市',2257,3,'_江苏_盐城市_东台市_',0),(2266,'大丰市',2257,3,'_江苏_盐城市_大丰市_',0),(2267,'扬州市',2175,2,'_江苏_扬州市_',0),(2268,'广陵区',2267,3,'_江苏_扬州市_广陵区_',0),(2269,'邗江区',2267,3,'_江苏_扬州市_邗江区_',0),(2270,'郊　区',2267,3,'_江苏_扬州市_郊　区_',0),(2271,'宝应县',2267,3,'_江苏_扬州市_宝应县_',0),(2272,'仪征市',2267,3,'_江苏_扬州市_仪征市_',0),(2273,'高邮市',2267,3,'_江苏_扬州市_高邮市_',0),(2274,'江都市',2267,3,'_江苏_扬州市_江都市_',0),(2275,'镇江市',2175,2,'_江苏_镇江市_',0),(2276,'京口区',2275,3,'_江苏_镇江市_京口区_',0),(2277,'润州区',2275,3,'_江苏_镇江市_润州区_',0),(2278,'丹徒区',2275,3,'_江苏_镇江市_丹徒区_',0),(2279,'丹阳市',2275,3,'_江苏_镇江市_丹阳市_',0),(2280,'扬中市',2275,3,'_江苏_镇江市_扬中市_',0),(2281,'句容市',2275,3,'_江苏_镇江市_句容市_',0),(2282,'泰州市',2175,2,'_江苏_泰州市_',0),(2283,'海陵区',2282,3,'_江苏_泰州市_海陵区_',0),(2284,'高港区',2282,3,'_江苏_泰州市_高港区_',0),(2285,'兴化市',2282,3,'_江苏_泰州市_兴化市_',0),(2286,'靖江市',2282,3,'_江苏_泰州市_靖江市_',0),(2287,'泰兴市',2282,3,'_江苏_泰州市_泰兴市_',0),(2288,'姜堰市',2282,3,'_江苏_泰州市_姜堰市_',0),(2289,'宿迁市',2175,2,'_江苏_宿迁市_',0),(2290,'宿城区',2289,3,'_江苏_宿迁市_宿城区_',0),(2291,'宿豫区',2289,3,'_江苏_宿迁市_宿豫区_',0),(2292,'沭阳县',2289,3,'_江苏_宿迁市_沭阳县_',0),(2293,'泗阳县',2289,3,'_江苏_宿迁市_泗阳县_',0),(2294,'泗洪县',2289,3,'_江苏_宿迁市_泗洪县_',0),(2295,'浙江',0,1,'_浙江_',0),(2296,'杭州市',2295,2,'_浙江_杭州市_',0),(2297,'上城区',2296,3,'_浙江_杭州市_上城区_',0),(2298,'下城区',2296,3,'_浙江_杭州市_下城区_',0),(2299,'江干区',2296,3,'_浙江_杭州市_江干区_',0),(2300,'拱墅区',2296,3,'_浙江_杭州市_拱墅区_',0),(2301,'西湖区',2296,3,'_浙江_杭州市_西湖区_',0),(2302,'滨江区',2296,3,'_浙江_杭州市_滨江区_',0),(2303,'萧山区',2296,3,'_浙江_杭州市_萧山区_',0),(2304,'余杭区',2296,3,'_浙江_杭州市_余杭区_',0),(2305,'桐庐县',2296,3,'_浙江_杭州市_桐庐县_',0),(2306,'淳安县',2296,3,'_浙江_杭州市_淳安县_',0),(2307,'建德市',2296,3,'_浙江_杭州市_建德市_',0),(2308,'富阳市',2296,3,'_浙江_杭州市_富阳市_',0),(2309,'临安市',2296,3,'_浙江_杭州市_临安市_',0),(2310,'宁波市',2295,2,'_浙江_宁波市_',0),(2311,'海曙区',2310,3,'_浙江_宁波市_海曙区_',0),(2312,'江东区',2310,3,'_浙江_宁波市_江东区_',0),(2313,'江北区',2310,3,'_浙江_宁波市_江北区_',0),(2314,'北仑区',2310,3,'_浙江_宁波市_北仑区_',0),(2315,'镇海区',2310,3,'_浙江_宁波市_镇海区_',0),(2316,'鄞州区',2310,3,'_浙江_宁波市_鄞州区_',0),(2317,'象山县',2310,3,'_浙江_宁波市_象山县_',0),(2318,'宁海县',2310,3,'_浙江_宁波市_宁海县_',0),(2319,'余姚市',2310,3,'_浙江_宁波市_余姚市_',0),(2320,'慈溪市',2310,3,'_浙江_宁波市_慈溪市_',0),(2321,'奉化市',2310,3,'_浙江_宁波市_奉化市_',0),(2322,'温州市',2295,2,'_浙江_温州市_',0),(2323,'鹿城区',2322,3,'_浙江_温州市_鹿城区_',0),(2324,'龙湾区',2322,3,'_浙江_温州市_龙湾区_',0),(2325,'瓯海区',2322,3,'_浙江_温州市_瓯海区_',0),(2326,'洞头县',2322,3,'_浙江_温州市_洞头县_',0),(2327,'永嘉县',2322,3,'_浙江_温州市_永嘉县_',0),(2328,'平阳县',2322,3,'_浙江_温州市_平阳县_',0),(2329,'苍南县',2322,3,'_浙江_温州市_苍南县_',0),(2330,'文成县',2322,3,'_浙江_温州市_文成县_',0),(2331,'泰顺县',2322,3,'_浙江_温州市_泰顺县_',0),(2332,'瑞安市',2322,3,'_浙江_温州市_瑞安市_',0),(2333,'乐清市',2322,3,'_浙江_温州市_乐清市_',0),(2334,'嘉兴市',2295,2,'_浙江_嘉兴市_',0),(2335,'秀城区',2334,3,'_浙江_嘉兴市_秀城区_',0),(2336,'秀洲区',2334,3,'_浙江_嘉兴市_秀洲区_',0),(2337,'嘉善县',2334,3,'_浙江_嘉兴市_嘉善县_',0),(2338,'海盐县',2334,3,'_浙江_嘉兴市_海盐县_',0),(2339,'海宁市',2334,3,'_浙江_嘉兴市_海宁市_',0),(2340,'平湖市',2334,3,'_浙江_嘉兴市_平湖市_',0),(2341,'桐乡市',2334,3,'_浙江_嘉兴市_桐乡市_',0),(2342,'湖州市',2295,2,'_浙江_湖州市_',0),(2343,'吴兴区',2342,3,'_浙江_湖州市_吴兴区_',0),(2344,'南浔区',2342,3,'_浙江_湖州市_南浔区_',0),(2345,'德清县',2342,3,'_浙江_湖州市_德清县_',0),(2346,'长兴县',2342,3,'_浙江_湖州市_长兴县_',0),(2347,'安吉县',2342,3,'_浙江_湖州市_安吉县_',0),(2348,'绍兴市',2295,2,'_浙江_绍兴市_',0),(2349,'越城区',2348,3,'_浙江_绍兴市_越城区_',0),(2350,'绍兴县',2348,3,'_浙江_绍兴市_绍兴县_',0),(2351,'新昌县',2348,3,'_浙江_绍兴市_新昌县_',0),(2352,'诸暨市',2348,3,'_浙江_绍兴市_诸暨市_',0),(2353,'上虞市',2348,3,'_浙江_绍兴市_上虞市_',0),(2354,'嵊州市',2348,3,'_浙江_绍兴市_嵊州市_',0),(2355,'金华市',2295,2,'_浙江_金华市_',0),(2356,'婺城区',2355,3,'_浙江_金华市_婺城区_',0),(2357,'金东区',2355,3,'_浙江_金华市_金东区_',0),(2358,'武义县',2355,3,'_浙江_金华市_武义县_',0),(2359,'浦江县',2355,3,'_浙江_金华市_浦江县_',0),(2360,'磐安县',2355,3,'_浙江_金华市_磐安县_',0),(2361,'兰溪市',2355,3,'_浙江_金华市_兰溪市_',0),(2362,'义乌市',2355,3,'_浙江_金华市_义乌市_',0),(2363,'东阳市',2355,3,'_浙江_金华市_东阳市_',0),(2364,'永康市',2355,3,'_浙江_金华市_永康市_',0),(2365,'衢州市',2295,2,'_浙江_衢州市_',0),(2366,'柯城区',2365,3,'_浙江_衢州市_柯城区_',0),(2367,'衢江区',2365,3,'_浙江_衢州市_衢江区_',0),(2368,'常山县',2365,3,'_浙江_衢州市_常山县_',0),(2369,'开化县',2365,3,'_浙江_衢州市_开化县_',0),(2370,'龙游县',2365,3,'_浙江_衢州市_龙游县_',0),(2371,'江山市',2365,3,'_浙江_衢州市_江山市_',0),(2372,'舟山市',2295,2,'_浙江_舟山市_',0),(2373,'定海区',2372,3,'_浙江_舟山市_定海区_',0),(2374,'普陀区',2372,3,'_浙江_舟山市_普陀区_',0),(2375,'岱山县',2372,3,'_浙江_舟山市_岱山县_',0),(2376,'嵊泗县',2372,3,'_浙江_舟山市_嵊泗县_',0),(2377,'台州市',2295,2,'_浙江_台州市_',0),(2378,'椒江区',2377,3,'_浙江_台州市_椒江区_',0),(2379,'黄岩区',2377,3,'_浙江_台州市_黄岩区_',0),(2380,'路桥区',2377,3,'_浙江_台州市_路桥区_',0),(2381,'玉环县',2377,3,'_浙江_台州市_玉环县_',0),(2382,'三门县',2377,3,'_浙江_台州市_三门县_',0),(2383,'天台县',2377,3,'_浙江_台州市_天台县_',0),(2384,'仙居县',2377,3,'_浙江_台州市_仙居县_',0),(2385,'温岭市',2377,3,'_浙江_台州市_温岭市_',0),(2386,'临海市',2377,3,'_浙江_台州市_临海市_',0),(2387,'丽水市',2295,2,'_浙江_丽水市_',0),(2388,'莲都区',2387,3,'_浙江_丽水市_莲都区_',0),(2389,'青田县',2387,3,'_浙江_丽水市_青田县_',0),(2390,'缙云县',2387,3,'_浙江_丽水市_缙云县_',0),(2391,'遂昌县',2387,3,'_浙江_丽水市_遂昌县_',0),(2392,'松阳县',2387,3,'_浙江_丽水市_松阳县_',0),(2393,'云和县',2387,3,'_浙江_丽水市_云和县_',0),(2394,'庆元县',2387,3,'_浙江_丽水市_庆元县_',0),(2395,'景宁畲族自治县',2387,3,'_浙江_丽水市_景宁畲族自治县_',0),(2396,'龙泉市',2387,3,'_浙江_丽水市_龙泉市_',0),(2397,'安徽',0,1,'_安徽_',0),(2398,'合肥市',2397,2,'_安徽_合肥市_',0),(2399,'瑶海区',2398,3,'_安徽_合肥市_瑶海区_',0),(2400,'庐阳区',2398,3,'_安徽_合肥市_庐阳区_',0),(2401,'蜀山区',2398,3,'_安徽_合肥市_蜀山区_',0),(2402,'包河区',2398,3,'_安徽_合肥市_包河区_',0),(2403,'长丰县',2398,3,'_安徽_合肥市_长丰县_',0),(2404,'肥东县',2398,3,'_安徽_合肥市_肥东县_',0),(2405,'肥西县',2398,3,'_安徽_合肥市_肥西县_',0),(2406,'芜湖市',2397,2,'_安徽_芜湖市_',0),(2407,'镜湖区',2406,3,'_安徽_芜湖市_镜湖区_',0),(2408,'马塘区',2406,3,'_安徽_芜湖市_马塘区_',0),(2409,'新芜区',2406,3,'_安徽_芜湖市_新芜区_',0),(2410,'鸠江区',2406,3,'_安徽_芜湖市_鸠江区_',0),(2411,'芜湖县',2406,3,'_安徽_芜湖市_芜湖县_',0),(2412,'繁昌县',2406,3,'_安徽_芜湖市_繁昌县_',0),(2413,'南陵县',2406,3,'_安徽_芜湖市_南陵县_',0),(2414,'蚌埠市',2397,2,'_安徽_蚌埠市_',0),(2415,'龙子湖区',2414,3,'_安徽_蚌埠市_龙子湖区_',0),(2416,'蚌山区',2414,3,'_安徽_蚌埠市_蚌山区_',0),(2417,'禹会区',2414,3,'_安徽_蚌埠市_禹会区_',0),(2418,'淮上区',2414,3,'_安徽_蚌埠市_淮上区_',0),(2419,'怀远县',2414,3,'_安徽_蚌埠市_怀远县_',0),(2420,'五河县',2414,3,'_安徽_蚌埠市_五河县_',0),(2421,'固镇县',2414,3,'_安徽_蚌埠市_固镇县_',0),(2422,'淮南市',2397,2,'_安徽_淮南市_',0),(2423,'大通区',2422,3,'_安徽_淮南市_大通区_',0),(2424,'田家庵区',2422,3,'_安徽_淮南市_田家庵区_',0),(2425,'谢家集区',2422,3,'_安徽_淮南市_谢家集区_',0),(2426,'八公山区',2422,3,'_安徽_淮南市_八公山区_',0),(2427,'潘集区',2422,3,'_安徽_淮南市_潘集区_',0),(2428,'凤台县',2422,3,'_安徽_淮南市_凤台县_',0),(2429,'马鞍山市',2397,2,'_安徽_马鞍山市_',0),(2430,'金家庄区',2429,3,'_安徽_马鞍山市_金家庄区_',0),(2431,'花山区',2429,3,'_安徽_马鞍山市_花山区_',0),(2432,'雨山区',2429,3,'_安徽_马鞍山市_雨山区_',0),(2433,'当涂县',2429,3,'_安徽_马鞍山市_当涂县_',0),(2434,'淮北市',2397,2,'_安徽_淮北市_',0),(2435,'杜集区',2434,3,'_安徽_淮北市_杜集区_',0),(2436,'相山区',2434,3,'_安徽_淮北市_相山区_',0),(2437,'烈山区',2434,3,'_安徽_淮北市_烈山区_',0),(2438,'濉溪县',2434,3,'_安徽_淮北市_濉溪县_',0),(2439,'铜陵市',2397,2,'_安徽_铜陵市_',0),(2440,'铜官山区',2439,3,'_安徽_铜陵市_铜官山区_',0),(2441,'狮子山区',2439,3,'_安徽_铜陵市_狮子山区_',0),(2442,'郊　区',2439,3,'_安徽_铜陵市_郊　区_',0),(2443,'铜陵县',2439,3,'_安徽_铜陵市_铜陵县_',0),(2444,'安庆市',2397,2,'_安徽_安庆市_',0),(2445,'迎江区',2444,3,'_安徽_安庆市_迎江区_',0),(2446,'大观区',2444,3,'_安徽_安庆市_大观区_',0),(2447,'郊　区',2444,3,'_安徽_安庆市_郊　区_',0),(2448,'怀宁县',2444,3,'_安徽_安庆市_怀宁县_',0),(2449,'枞阳县',2444,3,'_安徽_安庆市_枞阳县_',0),(2450,'潜山县',2444,3,'_安徽_安庆市_潜山县_',0),(2451,'太湖县',2444,3,'_安徽_安庆市_太湖县_',0),(2452,'宿松县',2444,3,'_安徽_安庆市_宿松县_',0),(2453,'望江县',2444,3,'_安徽_安庆市_望江县_',0),(2454,'岳西县',2444,3,'_安徽_安庆市_岳西县_',0),(2455,'桐城市',2444,3,'_安徽_安庆市_桐城市_',0),(2456,'黄山市',2397,2,'_安徽_黄山市_',0),(2457,'屯溪区',2456,3,'_安徽_黄山市_屯溪区_',0),(2458,'黄山区',2456,3,'_安徽_黄山市_黄山区_',0),(2459,'徽州区',2456,3,'_安徽_黄山市_徽州区_',0),(2460,'歙　县',2456,3,'_安徽_黄山市_歙　县_',0),(2461,'休宁县',2456,3,'_安徽_黄山市_休宁县_',0),(2462,'黟　县',2456,3,'_安徽_黄山市_黟　县_',0),(2463,'祁门县',2456,3,'_安徽_黄山市_祁门县_',0),(2464,'滁州市',2397,2,'_安徽_滁州市_',0),(2465,'琅琊区',2464,3,'_安徽_滁州市_琅琊区_',0),(2466,'南谯区',2464,3,'_安徽_滁州市_南谯区_',0),(2467,'来安县',2464,3,'_安徽_滁州市_来安县_',0),(2468,'全椒县',2464,3,'_安徽_滁州市_全椒县_',0),(2469,'定远县',2464,3,'_安徽_滁州市_定远县_',0),(2470,'凤阳县',2464,3,'_安徽_滁州市_凤阳县_',0),(2471,'天长市',2464,3,'_安徽_滁州市_天长市_',0),(2472,'明光市',2464,3,'_安徽_滁州市_明光市_',0),(2473,'阜阳市',2397,2,'_安徽_阜阳市_',0),(2474,'颍州区',2473,3,'_安徽_阜阳市_颍州区_',0),(2475,'颍东区',2473,3,'_安徽_阜阳市_颍东区_',0),(2476,'颍泉区',2473,3,'_安徽_阜阳市_颍泉区_',0),(2477,'临泉县',2473,3,'_安徽_阜阳市_临泉县_',0),(2478,'太和县',2473,3,'_安徽_阜阳市_太和县_',0),(2479,'阜南县',2473,3,'_安徽_阜阳市_阜南县_',0),(2480,'颍上县',2473,3,'_安徽_阜阳市_颍上县_',0),(2481,'界首市',2473,3,'_安徽_阜阳市_界首市_',0),(2482,'宿州市',2397,2,'_安徽_宿州市_',0),(2483,'墉桥区',2482,3,'_安徽_宿州市_墉桥区_',0),(2484,'砀山县',2482,3,'_安徽_宿州市_砀山县_',0),(2485,'萧　县',2482,3,'_安徽_宿州市_萧　县_',0),(2486,'灵璧县',2482,3,'_安徽_宿州市_灵璧县_',0),(2487,'泗　县',2482,3,'_安徽_宿州市_泗　县_',0),(2488,'巢湖市',2397,2,'_安徽_巢湖市_',0),(2489,'居巢区',2488,3,'_安徽_巢湖市_居巢区_',0),(2490,'庐江县',2488,3,'_安徽_巢湖市_庐江县_',0),(2491,'无为县',2488,3,'_安徽_巢湖市_无为县_',0),(2492,'含山县',2488,3,'_安徽_巢湖市_含山县_',0),(2493,'和　县',2488,3,'_安徽_巢湖市_和　县_',0),(2494,'六安市',2397,2,'_安徽_六安市_',0),(2495,'金安区',2494,3,'_安徽_六安市_金安区_',0),(2496,'裕安区',2494,3,'_安徽_六安市_裕安区_',0),(2497,'寿　县',2494,3,'_安徽_六安市_寿　县_',0),(2498,'霍邱县',2494,3,'_安徽_六安市_霍邱县_',0),(2499,'舒城县',2494,3,'_安徽_六安市_舒城县_',0),(2500,'金寨县',2494,3,'_安徽_六安市_金寨县_',0),(2501,'霍山县',2494,3,'_安徽_六安市_霍山县_',0),(2502,'亳州市',2397,2,'_安徽_亳州市_',0),(2503,'谯城区',2502,3,'_安徽_亳州市_谯城区_',0),(2504,'涡阳县',2502,3,'_安徽_亳州市_涡阳县_',0),(2505,'蒙城县',2502,3,'_安徽_亳州市_蒙城县_',0),(2506,'利辛县',2502,3,'_安徽_亳州市_利辛县_',0),(2507,'池州市',2397,2,'_安徽_池州市_',0),(2508,'贵池区',2507,3,'_安徽_池州市_贵池区_',0),(2509,'东至县',2507,3,'_安徽_池州市_东至县_',0),(2510,'石台县',2507,3,'_安徽_池州市_石台县_',0),(2511,'青阳县',2507,3,'_安徽_池州市_青阳县_',0),(2512,'宣城市',2397,2,'_安徽_宣城市_',0),(2513,'宣州区',2512,3,'_安徽_宣城市_宣州区_',0),(2514,'郎溪县',2512,3,'_安徽_宣城市_郎溪县_',0),(2515,'广德县',2512,3,'_安徽_宣城市_广德县_',0),(2516,'泾　县',2512,3,'_安徽_宣城市_泾　县_',0),(2517,'绩溪县',2512,3,'_安徽_宣城市_绩溪县_',0),(2518,'旌德县',2512,3,'_安徽_宣城市_旌德县_',0),(2519,'宁国市',2512,3,'_安徽_宣城市_宁国市_',0),(2520,'福建',0,1,'_福建_',0),(2521,'福州市',2520,2,'_福建_福州市_',0),(2522,'鼓楼区',2521,3,'_福建_福州市_鼓楼区_',0),(2523,'台江区',2521,3,'_福建_福州市_台江区_',0),(2524,'仓山区',2521,3,'_福建_福州市_仓山区_',0),(2525,'马尾区',2521,3,'_福建_福州市_马尾区_',0),(2526,'晋安区',2521,3,'_福建_福州市_晋安区_',0),(2527,'闽侯县',2521,3,'_福建_福州市_闽侯县_',0),(2528,'连江县',2521,3,'_福建_福州市_连江县_',0),(2529,'罗源县',2521,3,'_福建_福州市_罗源县_',0),(2530,'闽清县',2521,3,'_福建_福州市_闽清县_',0),(2531,'永泰县',2521,3,'_福建_福州市_永泰县_',0),(2532,'平潭县',2521,3,'_福建_福州市_平潭县_',0),(2533,'福清市',2521,3,'_福建_福州市_福清市_',0),(2534,'长乐市',2521,3,'_福建_福州市_长乐市_',0),(2535,'厦门市',2520,2,'_福建_厦门市_',0),(2536,'思明区',2535,3,'_福建_厦门市_思明区_',0),(2537,'海沧区',2535,3,'_福建_厦门市_海沧区_',0),(2538,'湖里区',2535,3,'_福建_厦门市_湖里区_',0),(2539,'集美区',2535,3,'_福建_厦门市_集美区_',0),(2540,'同安区',2535,3,'_福建_厦门市_同安区_',0),(2541,'翔安区',2535,3,'_福建_厦门市_翔安区_',0),(2542,'莆田市',2520,2,'_福建_莆田市_',0),(2543,'城厢区',2542,3,'_福建_莆田市_城厢区_',0),(2544,'涵江区',2542,3,'_福建_莆田市_涵江区_',0),(2545,'荔城区',2542,3,'_福建_莆田市_荔城区_',0),(2546,'秀屿区',2542,3,'_福建_莆田市_秀屿区_',0),(2547,'仙游县',2542,3,'_福建_莆田市_仙游县_',0),(2548,'三明市',2520,2,'_福建_三明市_',0),(2549,'梅列区',2548,3,'_福建_三明市_梅列区_',0),(2550,'三元区',2548,3,'_福建_三明市_三元区_',0),(2551,'明溪县',2548,3,'_福建_三明市_明溪县_',0),(2552,'清流县',2548,3,'_福建_三明市_清流县_',0),(2553,'宁化县',2548,3,'_福建_三明市_宁化县_',0),(2554,'大田县',2548,3,'_福建_三明市_大田县_',0),(2555,'尤溪县',2548,3,'_福建_三明市_尤溪县_',0),(2556,'沙　县',2548,3,'_福建_三明市_沙　县_',0),(2557,'将乐县',2548,3,'_福建_三明市_将乐县_',0),(2558,'泰宁县',2548,3,'_福建_三明市_泰宁县_',0),(2559,'建宁县',2548,3,'_福建_三明市_建宁县_',0),(2560,'永安市',2548,3,'_福建_三明市_永安市_',0),(2561,'泉州市',2520,2,'_福建_泉州市_',0),(2562,'鲤城区',2561,3,'_福建_泉州市_鲤城区_',0),(2563,'丰泽区',2561,3,'_福建_泉州市_丰泽区_',0),(2564,'洛江区',2561,3,'_福建_泉州市_洛江区_',0),(2565,'泉港区',2561,3,'_福建_泉州市_泉港区_',0),(2566,'惠安县',2561,3,'_福建_泉州市_惠安县_',0),(2567,'安溪县',2561,3,'_福建_泉州市_安溪县_',0),(2568,'永春县',2561,3,'_福建_泉州市_永春县_',0),(2569,'德化县',2561,3,'_福建_泉州市_德化县_',0),(2570,'金门县',2561,3,'_福建_泉州市_金门县_',0),(2571,'石狮市',2561,3,'_福建_泉州市_石狮市_',0),(2572,'晋江市',2561,3,'_福建_泉州市_晋江市_',0),(2573,'南安市',2561,3,'_福建_泉州市_南安市_',0),(2574,'漳州市',2520,2,'_福建_漳州市_',0),(2575,'芗城区',2574,3,'_福建_漳州市_芗城区_',0),(2576,'龙文区',2574,3,'_福建_漳州市_龙文区_',0),(2577,'云霄县',2574,3,'_福建_漳州市_云霄县_',0),(2578,'漳浦县',2574,3,'_福建_漳州市_漳浦县_',0),(2579,'诏安县',2574,3,'_福建_漳州市_诏安县_',0),(2580,'长泰县',2574,3,'_福建_漳州市_长泰县_',0),(2581,'东山县',2574,3,'_福建_漳州市_东山县_',0),(2582,'南靖县',2574,3,'_福建_漳州市_南靖县_',0),(2583,'平和县',2574,3,'_福建_漳州市_平和县_',0),(2584,'华安县',2574,3,'_福建_漳州市_华安县_',0),(2585,'龙海市',2574,3,'_福建_漳州市_龙海市_',0),(2586,'南平市',2520,2,'_福建_南平市_',0),(2587,'延平区',2586,3,'_福建_南平市_延平区_',0),(2588,'顺昌县',2586,3,'_福建_南平市_顺昌县_',0),(2589,'浦城县',2586,3,'_福建_南平市_浦城县_',0),(2590,'光泽县',2586,3,'_福建_南平市_光泽县_',0),(2591,'松溪县',2586,3,'_福建_南平市_松溪县_',0),(2592,'政和县',2586,3,'_福建_南平市_政和县_',0),(2593,'邵武市',2586,3,'_福建_南平市_邵武市_',0),(2594,'武夷山市',2586,3,'_福建_南平市_武夷山市_',0),(2595,'建瓯市',2586,3,'_福建_南平市_建瓯市_',0),(2596,'建阳市',2586,3,'_福建_南平市_建阳市_',0),(2597,'龙岩市',2520,2,'_福建_龙岩市_',0),(2598,'新罗区',2597,3,'_福建_龙岩市_新罗区_',0),(2599,'长汀县',2597,3,'_福建_龙岩市_长汀县_',0),(2600,'永定县',2597,3,'_福建_龙岩市_永定县_',0),(2601,'上杭县',2597,3,'_福建_龙岩市_上杭县_',0),(2602,'武平县',2597,3,'_福建_龙岩市_武平县_',0),(2603,'连城县',2597,3,'_福建_龙岩市_连城县_',0),(2604,'漳平市',2597,3,'_福建_龙岩市_漳平市_',0),(2605,'宁德市',2520,2,'_福建_宁德市_',0),(2606,'蕉城区',2605,3,'_福建_宁德市_蕉城区_',0),(2607,'霞浦县',2605,3,'_福建_宁德市_霞浦县_',0),(2608,'古田县',2605,3,'_福建_宁德市_古田县_',0),(2609,'屏南县',2605,3,'_福建_宁德市_屏南县_',0),(2610,'寿宁县',2605,3,'_福建_宁德市_寿宁县_',0),(2611,'周宁县',2605,3,'_福建_宁德市_周宁县_',0),(2612,'柘荣县',2605,3,'_福建_宁德市_柘荣县_',0),(2613,'福安市',2605,3,'_福建_宁德市_福安市_',0),(2614,'福鼎市',2605,3,'_福建_宁德市_福鼎市_',0),(2615,'江西',0,1,'_江西_',0),(2616,'南昌市',2615,2,'_江西_南昌市_',0),(2617,'东湖区',2616,3,'_江西_南昌市_东湖区_',0),(2618,'西湖区',2616,3,'_江西_南昌市_西湖区_',0),(2619,'青云谱区',2616,3,'_江西_南昌市_青云谱区_',0),(2620,'湾里区',2616,3,'_江西_南昌市_湾里区_',0),(2621,'青山湖区',2616,3,'_江西_南昌市_青山湖区_',0),(2622,'南昌县',2616,3,'_江西_南昌市_南昌县_',0),(2623,'新建县',2616,3,'_江西_南昌市_新建县_',0),(2624,'安义县',2616,3,'_江西_南昌市_安义县_',0),(2625,'进贤县',2616,3,'_江西_南昌市_进贤县_',0),(2626,'景德镇市',2615,2,'_江西_景德镇市_',0),(2627,'昌江区',2626,3,'_江西_景德镇市_昌江区_',0),(2628,'珠山区',2626,3,'_江西_景德镇市_珠山区_',0),(2629,'浮梁县',2626,3,'_江西_景德镇市_浮梁县_',0),(2630,'乐平市',2626,3,'_江西_景德镇市_乐平市_',0),(2631,'萍乡市',2615,2,'_江西_萍乡市_',0),(2632,'安源区',2631,3,'_江西_萍乡市_安源区_',0),(2633,'湘东区',2631,3,'_江西_萍乡市_湘东区_',0),(2634,'莲花县',2631,3,'_江西_萍乡市_莲花县_',0),(2635,'上栗县',2631,3,'_江西_萍乡市_上栗县_',0),(2636,'芦溪县',2631,3,'_江西_萍乡市_芦溪县_',0),(2637,'九江市',2615,2,'_江西_九江市_',0),(2638,'庐山区',2637,3,'_江西_九江市_庐山区_',0),(2639,'浔阳区',2637,3,'_江西_九江市_浔阳区_',0),(2640,'九江县',2637,3,'_江西_九江市_九江县_',0),(2641,'武宁县',2637,3,'_江西_九江市_武宁县_',0),(2642,'修水县',2637,3,'_江西_九江市_修水县_',0),(2643,'永修县',2637,3,'_江西_九江市_永修县_',0),(2644,'德安县',2637,3,'_江西_九江市_德安县_',0),(2645,'星子县',2637,3,'_江西_九江市_星子县_',0),(2646,'都昌县',2637,3,'_江西_九江市_都昌县_',0),(2647,'湖口县',2637,3,'_江西_九江市_湖口县_',0),(2648,'彭泽县',2637,3,'_江西_九江市_彭泽县_',0),(2649,'瑞昌市',2637,3,'_江西_九江市_瑞昌市_',0),(2650,'新余市',2615,2,'_江西_新余市_',0),(2651,'渝水区',2650,3,'_江西_新余市_渝水区_',0),(2652,'分宜县',2650,3,'_江西_新余市_分宜县_',0),(2653,'鹰潭市',2615,2,'_江西_鹰潭市_',0),(2654,'月湖区',2653,3,'_江西_鹰潭市_月湖区_',0),(2655,'余江县',2653,3,'_江西_鹰潭市_余江县_',0),(2656,'贵溪市',2653,3,'_江西_鹰潭市_贵溪市_',0),(2657,'赣州市',2615,2,'_江西_赣州市_',0),(2658,'章贡区',2657,3,'_江西_赣州市_章贡区_',0),(2659,'赣　县',2657,3,'_江西_赣州市_赣　县_',0),(2660,'信丰县',2657,3,'_江西_赣州市_信丰县_',0),(2661,'大余县',2657,3,'_江西_赣州市_大余县_',0),(2662,'上犹县',2657,3,'_江西_赣州市_上犹县_',0),(2663,'崇义县',2657,3,'_江西_赣州市_崇义县_',0),(2664,'安远县',2657,3,'_江西_赣州市_安远县_',0),(2665,'龙南县',2657,3,'_江西_赣州市_龙南县_',0),(2666,'定南县',2657,3,'_江西_赣州市_定南县_',0),(2667,'全南县',2657,3,'_江西_赣州市_全南县_',0),(2668,'宁都县',2657,3,'_江西_赣州市_宁都县_',0),(2669,'于都县',2657,3,'_江西_赣州市_于都县_',0),(2670,'兴国县',2657,3,'_江西_赣州市_兴国县_',0),(2671,'会昌县',2657,3,'_江西_赣州市_会昌县_',0),(2672,'寻乌县',2657,3,'_江西_赣州市_寻乌县_',0),(2673,'石城县',2657,3,'_江西_赣州市_石城县_',0),(2674,'瑞金市',2657,3,'_江西_赣州市_瑞金市_',0),(2675,'南康市',2657,3,'_江西_赣州市_南康市_',0),(2676,'吉安市',2615,2,'_江西_吉安市_',0),(2677,'吉州区',2676,3,'_江西_吉安市_吉州区_',0),(2678,'青原区',2676,3,'_江西_吉安市_青原区_',0),(2679,'吉安县',2676,3,'_江西_吉安市_吉安县_',0),(2680,'吉水县',2676,3,'_江西_吉安市_吉水县_',0),(2681,'峡江县',2676,3,'_江西_吉安市_峡江县_',0),(2682,'新干县',2676,3,'_江西_吉安市_新干县_',0),(2683,'永丰县',2676,3,'_江西_吉安市_永丰县_',0),(2684,'泰和县',2676,3,'_江西_吉安市_泰和县_',0),(2685,'遂川县',2676,3,'_江西_吉安市_遂川县_',0),(2686,'万安县',2676,3,'_江西_吉安市_万安县_',0),(2687,'安福县',2676,3,'_江西_吉安市_安福县_',0),(2688,'永新县',2676,3,'_江西_吉安市_永新县_',0),(2689,'井冈山市',2676,3,'_江西_吉安市_井冈山市_',0),(2690,'宜春市',2615,2,'_江西_宜春市_',0),(2691,'袁州区',2690,3,'_江西_宜春市_袁州区_',0),(2692,'奉新县',2690,3,'_江西_宜春市_奉新县_',0),(2693,'万载县',2690,3,'_江西_宜春市_万载县_',0),(2694,'上高县',2690,3,'_江西_宜春市_上高县_',0),(2695,'宜丰县',2690,3,'_江西_宜春市_宜丰县_',0),(2696,'靖安县',2690,3,'_江西_宜春市_靖安县_',0),(2697,'铜鼓县',2690,3,'_江西_宜春市_铜鼓县_',0),(2698,'丰城市',2690,3,'_江西_宜春市_丰城市_',0),(2699,'樟树市',2690,3,'_江西_宜春市_樟树市_',0),(2700,'高安市',2690,3,'_江西_宜春市_高安市_',0),(2701,'抚州市',2615,2,'_江西_抚州市_',0),(2702,'临川区',2701,3,'_江西_抚州市_临川区_',0),(2703,'南城县',2701,3,'_江西_抚州市_南城县_',0),(2704,'黎川县',2701,3,'_江西_抚州市_黎川县_',0),(2705,'南丰县',2701,3,'_江西_抚州市_南丰县_',0),(2706,'崇仁县',2701,3,'_江西_抚州市_崇仁县_',0),(2707,'乐安县',2701,3,'_江西_抚州市_乐安县_',0),(2708,'宜黄县',2701,3,'_江西_抚州市_宜黄县_',0),(2709,'金溪县',2701,3,'_江西_抚州市_金溪县_',0),(2710,'资溪县',2701,3,'_江西_抚州市_资溪县_',0),(2711,'东乡县',2701,3,'_江西_抚州市_东乡县_',0),(2712,'广昌县',2701,3,'_江西_抚州市_广昌县_',0),(2713,'上饶市',2615,2,'_江西_上饶市_',0),(2714,'信州区',2713,3,'_江西_上饶市_信州区_',0),(2715,'上饶县',2713,3,'_江西_上饶市_上饶县_',0),(2716,'广丰县',2713,3,'_江西_上饶市_广丰县_',0),(2717,'玉山县',2713,3,'_江西_上饶市_玉山县_',0),(2718,'铅山县',2713,3,'_江西_上饶市_铅山县_',0),(2719,'横峰县',2713,3,'_江西_上饶市_横峰县_',0),(2720,'弋阳县',2713,3,'_江西_上饶市_弋阳县_',0),(2721,'余干县',2713,3,'_江西_上饶市_余干县_',0),(2722,'鄱阳县',2713,3,'_江西_上饶市_鄱阳县_',0),(2723,'万年县',2713,3,'_江西_上饶市_万年县_',0),(2724,'婺源县',2713,3,'_江西_上饶市_婺源县_',0),(2725,'德兴市',2713,3,'_江西_上饶市_德兴市_',0),(2726,'山东',0,1,'_山东_',0),(2727,'济南市',2726,2,'_山东_济南市_',0),(2728,'历下区',2727,3,'_山东_济南市_历下区_',0),(2729,'市中区',2727,3,'_山东_济南市_市中区_',0),(2730,'槐荫区',2727,3,'_山东_济南市_槐荫区_',0),(2731,'天桥区',2727,3,'_山东_济南市_天桥区_',0),(2732,'历城区',2727,3,'_山东_济南市_历城区_',0),(2733,'长清区',2727,3,'_山东_济南市_长清区_',0),(2734,'平阴县',2727,3,'_山东_济南市_平阴县_',0),(2735,'济阳县',2727,3,'_山东_济南市_济阳县_',0),(2736,'商河县',2727,3,'_山东_济南市_商河县_',0),(2737,'章丘市',2727,3,'_山东_济南市_章丘市_',0),(2738,'青岛市',2726,2,'_山东_青岛市_',0),(2739,'市南区',2738,3,'_山东_青岛市_市南区_',0),(2740,'市北区',2738,3,'_山东_青岛市_市北区_',0),(2741,'四方区',2738,3,'_山东_青岛市_四方区_',0),(2742,'黄岛区',2738,3,'_山东_青岛市_黄岛区_',0),(2743,'崂山区',2738,3,'_山东_青岛市_崂山区_',0),(2744,'李沧区',2738,3,'_山东_青岛市_李沧区_',0),(2745,'城阳区',2738,3,'_山东_青岛市_城阳区_',0),(2746,'胶州市',2738,3,'_山东_青岛市_胶州市_',0),(2747,'即墨市',2738,3,'_山东_青岛市_即墨市_',0),(2748,'平度市',2738,3,'_山东_青岛市_平度市_',0),(2749,'胶南市',2738,3,'_山东_青岛市_胶南市_',0),(2750,'莱西市',2738,3,'_山东_青岛市_莱西市_',0),(2751,'淄博市',2726,2,'_山东_淄博市_',0),(2752,'淄川区',2751,3,'_山东_淄博市_淄川区_',0),(2753,'张店区',2751,3,'_山东_淄博市_张店区_',0),(2754,'博山区',2751,3,'_山东_淄博市_博山区_',0),(2755,'临淄区',2751,3,'_山东_淄博市_临淄区_',0),(2756,'周村区',2751,3,'_山东_淄博市_周村区_',0),(2757,'桓台县',2751,3,'_山东_淄博市_桓台县_',0),(2758,'高青县',2751,3,'_山东_淄博市_高青县_',0),(2759,'沂源县',2751,3,'_山东_淄博市_沂源县_',0),(2760,'枣庄市',2726,2,'_山东_枣庄市_',0),(2761,'市中区',2760,3,'_山东_枣庄市_市中区_',0),(2762,'薛城区',2760,3,'_山东_枣庄市_薛城区_',0),(2763,'峄城区',2760,3,'_山东_枣庄市_峄城区_',0),(2764,'台儿庄区',2760,3,'_山东_枣庄市_台儿庄区_',0),(2765,'山亭区',2760,3,'_山东_枣庄市_山亭区_',0),(2766,'滕州市',2760,3,'_山东_枣庄市_滕州市_',0),(2767,'东营市',2726,2,'_山东_东营市_',0),(2768,'东营区',2767,3,'_山东_东营市_东营区_',0),(2769,'河口区',2767,3,'_山东_东营市_河口区_',0),(2770,'垦利县',2767,3,'_山东_东营市_垦利县_',0),(2771,'利津县',2767,3,'_山东_东营市_利津县_',0),(2772,'广饶县',2767,3,'_山东_东营市_广饶县_',0),(2773,'烟台市',2726,2,'_山东_烟台市_',0),(2774,'芝罘区',2773,3,'_山东_烟台市_芝罘区_',0),(2775,'福山区',2773,3,'_山东_烟台市_福山区_',0),(2776,'牟平区',2773,3,'_山东_烟台市_牟平区_',0),(2777,'莱山区',2773,3,'_山东_烟台市_莱山区_',0),(2778,'长岛县',2773,3,'_山东_烟台市_长岛县_',0),(2779,'龙口市',2773,3,'_山东_烟台市_龙口市_',0),(2780,'莱阳市',2773,3,'_山东_烟台市_莱阳市_',0),(2781,'莱州市',2773,3,'_山东_烟台市_莱州市_',0),(2782,'蓬莱市',2773,3,'_山东_烟台市_蓬莱市_',0),(2783,'招远市',2773,3,'_山东_烟台市_招远市_',0),(2784,'栖霞市',2773,3,'_山东_烟台市_栖霞市_',0),(2785,'海阳市',2773,3,'_山东_烟台市_海阳市_',0),(2786,'潍坊市',2726,2,'_山东_潍坊市_',0),(2787,'潍城区',2786,3,'_山东_潍坊市_潍城区_',0),(2788,'寒亭区',2786,3,'_山东_潍坊市_寒亭区_',0),(2789,'坊子区',2786,3,'_山东_潍坊市_坊子区_',0),(2790,'奎文区',2786,3,'_山东_潍坊市_奎文区_',0),(2791,'临朐县',2786,3,'_山东_潍坊市_临朐县_',0),(2792,'昌乐县',2786,3,'_山东_潍坊市_昌乐县_',0),(2793,'青州市',2786,3,'_山东_潍坊市_青州市_',0),(2794,'诸城市',2786,3,'_山东_潍坊市_诸城市_',0),(2795,'寿光市',2786,3,'_山东_潍坊市_寿光市_',0),(2796,'安丘市',2786,3,'_山东_潍坊市_安丘市_',0),(2797,'高密市',2786,3,'_山东_潍坊市_高密市_',0),(2798,'昌邑市',2786,3,'_山东_潍坊市_昌邑市_',0),(2799,'济宁市',2726,2,'_山东_济宁市_',0),(2800,'市中区',2799,3,'_山东_济宁市_市中区_',0),(2801,'任城区',2799,3,'_山东_济宁市_任城区_',0),(2802,'微山县',2799,3,'_山东_济宁市_微山县_',0),(2803,'鱼台县',2799,3,'_山东_济宁市_鱼台县_',0),(2804,'金乡县',2799,3,'_山东_济宁市_金乡县_',0),(2805,'嘉祥县',2799,3,'_山东_济宁市_嘉祥县_',0),(2806,'汶上县',2799,3,'_山东_济宁市_汶上县_',0),(2807,'泗水县',2799,3,'_山东_济宁市_泗水县_',0),(2808,'梁山县',2799,3,'_山东_济宁市_梁山县_',0),(2809,'曲阜市',2799,3,'_山东_济宁市_曲阜市_',0),(2810,'兖州市',2799,3,'_山东_济宁市_兖州市_',0),(2811,'邹城市',2799,3,'_山东_济宁市_邹城市_',0),(2812,'泰安市',2726,2,'_山东_泰安市_',0),(2813,'泰山区',2812,3,'_山东_泰安市_泰山区_',0),(2814,'岱岳区',2812,3,'_山东_泰安市_岱岳区_',0),(2815,'宁阳县',2812,3,'_山东_泰安市_宁阳县_',0),(2816,'东平县',2812,3,'_山东_泰安市_东平县_',0),(2817,'新泰市',2812,3,'_山东_泰安市_新泰市_',0),(2818,'肥城市',2812,3,'_山东_泰安市_肥城市_',0),(2819,'威海市',2726,2,'_山东_威海市_',0),(2820,'环翠区',2819,3,'_山东_威海市_环翠区_',0),(2821,'文登市',2819,3,'_山东_威海市_文登市_',0),(2822,'荣成市',2819,3,'_山东_威海市_荣成市_',0),(2823,'乳山市',2819,3,'_山东_威海市_乳山市_',0),(2824,'日照市',2726,2,'_山东_日照市_',0),(2825,'东港区',2824,3,'_山东_日照市_东港区_',0),(2826,'岚山区',2824,3,'_山东_日照市_岚山区_',0),(2827,'五莲县',2824,3,'_山东_日照市_五莲县_',0),(2828,'莒　县',2824,3,'_山东_日照市_莒　县_',0),(2829,'莱芜市',2726,2,'_山东_莱芜市_',0),(2830,'莱城区',2829,3,'_山东_莱芜市_莱城区_',0),(2831,'钢城区',2829,3,'_山东_莱芜市_钢城区_',0),(2832,'临沂市',2726,2,'_山东_临沂市_',0),(2833,'兰山区',2832,3,'_山东_临沂市_兰山区_',0),(2834,'罗庄区',2832,3,'_山东_临沂市_罗庄区_',0),(2835,'河东区',2832,3,'_山东_临沂市_河东区_',0),(2836,'沂南县',2832,3,'_山东_临沂市_沂南县_',0),(2837,'郯城县',2832,3,'_山东_临沂市_郯城县_',0),(2838,'沂水县',2832,3,'_山东_临沂市_沂水县_',0),(2839,'苍山县',2832,3,'_山东_临沂市_苍山县_',0),(2840,'费　县',2832,3,'_山东_临沂市_费　县_',0),(2841,'平邑县',2832,3,'_山东_临沂市_平邑县_',0),(2842,'莒南县',2832,3,'_山东_临沂市_莒南县_',0),(2843,'蒙阴县',2832,3,'_山东_临沂市_蒙阴县_',0),(2844,'临沭县',2832,3,'_山东_临沂市_临沭县_',0),(2845,'德州市',2726,2,'_山东_德州市_',0),(2846,'德城区',2845,3,'_山东_德州市_德城区_',0),(2847,'陵　县',2845,3,'_山东_德州市_陵　县_',0),(2848,'宁津县',2845,3,'_山东_德州市_宁津县_',0),(2849,'庆云县',2845,3,'_山东_德州市_庆云县_',0),(2850,'临邑县',2845,3,'_山东_德州市_临邑县_',0),(2851,'齐河县',2845,3,'_山东_德州市_齐河县_',0),(2852,'平原县',2845,3,'_山东_德州市_平原县_',0),(2853,'夏津县',2845,3,'_山东_德州市_夏津县_',0),(2854,'武城县',2845,3,'_山东_德州市_武城县_',0),(2855,'乐陵市',2845,3,'_山东_德州市_乐陵市_',0),(2856,'禹城市',2845,3,'_山东_德州市_禹城市_',0),(2857,'聊城市',2726,2,'_山东_聊城市_',0),(2858,'东昌府区',2857,3,'_山东_聊城市_东昌府区_',0),(2859,'阳谷县',2857,3,'_山东_聊城市_阳谷县_',0),(2860,'莘　县',2857,3,'_山东_聊城市_莘　县_',0),(2861,'茌平县',2857,3,'_山东_聊城市_茌平县_',0),(2862,'东阿县',2857,3,'_山东_聊城市_东阿县_',0),(2863,'冠　县',2857,3,'_山东_聊城市_冠　县_',0),(2864,'高唐县',2857,3,'_山东_聊城市_高唐县_',0),(2865,'临清市',2857,3,'_山东_聊城市_临清市_',0),(2866,'滨州市',2726,2,'_山东_滨州市_',0),(2867,'滨城区',2866,3,'_山东_滨州市_滨城区_',0),(2868,'惠民县',2866,3,'_山东_滨州市_惠民县_',0),(2869,'阳信县',2866,3,'_山东_滨州市_阳信县_',0),(2870,'无棣县',2866,3,'_山东_滨州市_无棣县_',0),(2871,'沾化县',2866,3,'_山东_滨州市_沾化县_',0),(2872,'博兴县',2866,3,'_山东_滨州市_博兴县_',0),(2873,'邹平县',2866,3,'_山东_滨州市_邹平县_',0),(2874,'荷泽市',2726,2,'_山东_荷泽市_',0),(2875,'牡丹区',2874,3,'_山东_荷泽市_牡丹区_',0),(2876,'曹　县',2874,3,'_山东_荷泽市_曹　县_',0),(2877,'单　县',2874,3,'_山东_荷泽市_单　县_',0),(2878,'成武县',2874,3,'_山东_荷泽市_成武县_',0),(2879,'巨野县',2874,3,'_山东_荷泽市_巨野县_',0),(2880,'郓城县',2874,3,'_山东_荷泽市_郓城县_',0),(2881,'鄄城县',2874,3,'_山东_荷泽市_鄄城县_',0),(2882,'定陶县',2874,3,'_山东_荷泽市_定陶县_',0),(2883,'东明县',2874,3,'_山东_荷泽市_东明县_',0),(2884,'辽宁',0,1,'_辽宁_',0),(2885,'沈阳市',2884,2,'_辽宁_沈阳市_',0),(2886,'和平区',2885,3,'_辽宁_沈阳市_和平区_',0),(2887,'沈河区',2885,3,'_辽宁_沈阳市_沈河区_',0),(2888,'大东区',2885,3,'_辽宁_沈阳市_大东区_',0),(2889,'皇姑区',2885,3,'_辽宁_沈阳市_皇姑区_',0),(2890,'铁西区',2885,3,'_辽宁_沈阳市_铁西区_',0),(2891,'苏家屯区',2885,3,'_辽宁_沈阳市_苏家屯区_',0),(2892,'东陵区',2885,3,'_辽宁_沈阳市_东陵区_',0),(2893,'新城子区',2885,3,'_辽宁_沈阳市_新城子区_',0),(2894,'于洪区',2885,3,'_辽宁_沈阳市_于洪区_',0),(2895,'辽中县',2885,3,'_辽宁_沈阳市_辽中县_',0),(2896,'康平县',2885,3,'_辽宁_沈阳市_康平县_',0),(2897,'法库县',2885,3,'_辽宁_沈阳市_法库县_',0),(2898,'新民市',2885,3,'_辽宁_沈阳市_新民市_',0),(2899,'大连市',2884,2,'_辽宁_大连市_',0),(2900,'中山区',2899,3,'_辽宁_大连市_中山区_',0),(2901,'西岗区',2899,3,'_辽宁_大连市_西岗区_',0),(2902,'沙河口区',2899,3,'_辽宁_大连市_沙河口区_',0),(2903,'甘井子区',2899,3,'_辽宁_大连市_甘井子区_',0),(2904,'旅顺口区',2899,3,'_辽宁_大连市_旅顺口区_',0),(2905,'金州区',2899,3,'_辽宁_大连市_金州区_',0),(2906,'长海县',2899,3,'_辽宁_大连市_长海县_',0),(2907,'瓦房店市',2899,3,'_辽宁_大连市_瓦房店市_',0),(2908,'普兰店市',2899,3,'_辽宁_大连市_普兰店市_',0),(2909,'庄河市',2899,3,'_辽宁_大连市_庄河市_',0),(2910,'鞍山市',2884,2,'_辽宁_鞍山市_',0),(2911,'铁东区',2910,3,'_辽宁_鞍山市_铁东区_',0),(2912,'铁西区',2910,3,'_辽宁_鞍山市_铁西区_',0),(2913,'立山区',2910,3,'_辽宁_鞍山市_立山区_',0),(2914,'千山区',2910,3,'_辽宁_鞍山市_千山区_',0),(2915,'台安县',2910,3,'_辽宁_鞍山市_台安县_',0),(2916,'岫岩满族自治县',2910,3,'_辽宁_鞍山市_岫岩满族自治县_',0),(2917,'海城市',2910,3,'_辽宁_鞍山市_海城市_',0),(2918,'抚顺市',2884,2,'_辽宁_抚顺市_',0),(2919,'新抚区',2918,3,'_辽宁_抚顺市_新抚区_',0),(2920,'东洲区',2918,3,'_辽宁_抚顺市_东洲区_',0),(2921,'望花区',2918,3,'_辽宁_抚顺市_望花区_',0),(2922,'顺城区',2918,3,'_辽宁_抚顺市_顺城区_',0),(2923,'抚顺县',2918,3,'_辽宁_抚顺市_抚顺县_',0),(2924,'新宾满族自治县',2918,3,'_辽宁_抚顺市_新宾满族自治县_',0),(2925,'清原满族自治县',2918,3,'_辽宁_抚顺市_清原满族自治县_',0),(2926,'本溪市',2884,2,'_辽宁_本溪市_',0),(2927,'平山区',2926,3,'_辽宁_本溪市_平山区_',0),(2928,'溪湖区',2926,3,'_辽宁_本溪市_溪湖区_',0),(2929,'明山区',2926,3,'_辽宁_本溪市_明山区_',0),(2930,'南芬区',2926,3,'_辽宁_本溪市_南芬区_',0),(2931,'本溪满族自治县',2926,3,'_辽宁_本溪市_本溪满族自治县_',0),(2932,'桓仁满族自治县',2926,3,'_辽宁_本溪市_桓仁满族自治县_',0),(2933,'丹东市',2884,2,'_辽宁_丹东市_',0),(2934,'元宝区',2933,3,'_辽宁_丹东市_元宝区_',0),(2935,'振兴区',2933,3,'_辽宁_丹东市_振兴区_',0),(2936,'振安区',2933,3,'_辽宁_丹东市_振安区_',0),(2937,'宽甸满族自治县',2933,3,'_辽宁_丹东市_宽甸满族自治县_',0),(2938,'东港市',2933,3,'_辽宁_丹东市_东港市_',0),(2939,'凤城市',2933,3,'_辽宁_丹东市_凤城市_',0),(2940,'锦州市',2884,2,'_辽宁_锦州市_',0),(2941,'古塔区',2940,3,'_辽宁_锦州市_古塔区_',0),(2942,'凌河区',2940,3,'_辽宁_锦州市_凌河区_',0),(2943,'太和区',2940,3,'_辽宁_锦州市_太和区_',0),(2944,'黑山县',2940,3,'_辽宁_锦州市_黑山县_',0),(2945,'义　县',2940,3,'_辽宁_锦州市_义　县_',0),(2946,'凌海市',2940,3,'_辽宁_锦州市_凌海市_',0),(2947,'北宁市',2940,3,'_辽宁_锦州市_北宁市_',0),(2948,'营口市',2884,2,'_辽宁_营口市_',0),(2949,'站前区',2948,3,'_辽宁_营口市_站前区_',0),(2950,'西市区',2948,3,'_辽宁_营口市_西市区_',0),(2951,'鲅鱼圈区',2948,3,'_辽宁_营口市_鲅鱼圈区_',0),(2952,'老边区',2948,3,'_辽宁_营口市_老边区_',0),(2953,'盖州市',2948,3,'_辽宁_营口市_盖州市_',0),(2954,'大石桥市',2948,3,'_辽宁_营口市_大石桥市_',0),(2955,'阜新市',2884,2,'_辽宁_阜新市_',0),(2956,'海州区',2955,3,'_辽宁_阜新市_海州区_',0),(2957,'新邱区',2955,3,'_辽宁_阜新市_新邱区_',0),(2958,'太平区',2955,3,'_辽宁_阜新市_太平区_',0),(2959,'清河门区',2955,3,'_辽宁_阜新市_清河门区_',0),(2960,'细河区',2955,3,'_辽宁_阜新市_细河区_',0),(2961,'阜新蒙古族自治县',2955,3,'_辽宁_阜新市_阜新蒙古族自治县_',0),(2962,'彰武县',2955,3,'_辽宁_阜新市_彰武县_',0),(2963,'辽阳市',2884,2,'_辽宁_辽阳市_',0),(2964,'白塔区',2963,3,'_辽宁_辽阳市_白塔区_',0),(2965,'文圣区',2963,3,'_辽宁_辽阳市_文圣区_',0),(2966,'宏伟区',2963,3,'_辽宁_辽阳市_宏伟区_',0),(2967,'弓长岭区',2963,3,'_辽宁_辽阳市_弓长岭区_',0),(2968,'太子河区',2963,3,'_辽宁_辽阳市_太子河区_',0),(2969,'辽阳县',2963,3,'_辽宁_辽阳市_辽阳县_',0),(2970,'灯塔市',2963,3,'_辽宁_辽阳市_灯塔市_',0),(2971,'盘锦市',2884,2,'_辽宁_盘锦市_',0),(2972,'双台子区',2971,3,'_辽宁_盘锦市_双台子区_',0),(2973,'兴隆台区',2971,3,'_辽宁_盘锦市_兴隆台区_',0),(2974,'大洼县',2971,3,'_辽宁_盘锦市_大洼县_',0),(2975,'盘山县',2971,3,'_辽宁_盘锦市_盘山县_',0),(2976,'铁岭市',2884,2,'_辽宁_铁岭市_',0),(2977,'银州区',2976,3,'_辽宁_铁岭市_银州区_',0),(2978,'清河区',2976,3,'_辽宁_铁岭市_清河区_',0),(2979,'铁岭县',2976,3,'_辽宁_铁岭市_铁岭县_',0),(2980,'西丰县',2976,3,'_辽宁_铁岭市_西丰县_',0),(2981,'昌图县',2976,3,'_辽宁_铁岭市_昌图县_',0),(2982,'调兵山市',2976,3,'_辽宁_铁岭市_调兵山市_',0),(2983,'开原市',2976,3,'_辽宁_铁岭市_开原市_',0),(2984,'朝阳市',2884,2,'_辽宁_朝阳市_',0),(2985,'双塔区',2984,3,'_辽宁_朝阳市_双塔区_',0),(2986,'龙城区',2984,3,'_辽宁_朝阳市_龙城区_',0),(2987,'朝阳县',2984,3,'_辽宁_朝阳市_朝阳县_',0),(2988,'建平县',2984,3,'_辽宁_朝阳市_建平县_',0),(2989,'喀喇沁左翼蒙古族自治县',2984,3,'_辽宁_朝阳市_喀喇沁左翼蒙古族自治县_',0),(2990,'北票市',2984,3,'_辽宁_朝阳市_北票市_',0),(2991,'凌源市',2984,3,'_辽宁_朝阳市_凌源市_',0),(2992,'葫芦岛市',2884,2,'_辽宁_葫芦岛市_',0),(2993,'连山区',2992,3,'_辽宁_葫芦岛市_连山区_',0),(2994,'龙港区',2992,3,'_辽宁_葫芦岛市_龙港区_',0),(2995,'南票区',2992,3,'_辽宁_葫芦岛市_南票区_',0),(2996,'绥中县',2992,3,'_辽宁_葫芦岛市_绥中县_',0),(2997,'建昌县',2992,3,'_辽宁_葫芦岛市_建昌县_',0),(2998,'兴城市',2992,3,'_辽宁_葫芦岛市_兴城市_',0),(2999,'吉林',0,1,'_吉林_',0),(3000,'长春市',2999,2,'_吉林_长春市_',0),(3001,'南关区',3000,3,'_吉林_长春市_南关区_',0),(3002,'宽城区',3000,3,'_吉林_长春市_宽城区_',0),(3003,'朝阳区',3000,3,'_吉林_长春市_朝阳区_',0),(3004,'二道区',3000,3,'_吉林_长春市_二道区_',0),(3005,'绿园区',3000,3,'_吉林_长春市_绿园区_',0),(3006,'双阳区',3000,3,'_吉林_长春市_双阳区_',0),(3007,'农安县',3000,3,'_吉林_长春市_农安县_',0),(3008,'九台市',3000,3,'_吉林_长春市_九台市_',0),(3009,'榆树市',3000,3,'_吉林_长春市_榆树市_',0),(3010,'德惠市',3000,3,'_吉林_长春市_德惠市_',0),(3011,'吉林市',2999,2,'_吉林_吉林市_',0),(3012,'昌邑区',3011,3,'_吉林_吉林市_昌邑区_',0),(3013,'龙潭区',3011,3,'_吉林_吉林市_龙潭区_',0),(3014,'船营区',3011,3,'_吉林_吉林市_船营区_',0),(3015,'丰满区',3011,3,'_吉林_吉林市_丰满区_',0),(3016,'永吉县',3011,3,'_吉林_吉林市_永吉县_',0),(3017,'蛟河市',3011,3,'_吉林_吉林市_蛟河市_',0),(3018,'桦甸市',3011,3,'_吉林_吉林市_桦甸市_',0),(3019,'舒兰市',3011,3,'_吉林_吉林市_舒兰市_',0),(3020,'磐石市',3011,3,'_吉林_吉林市_磐石市_',0),(3021,'四平市',2999,2,'_吉林_四平市_',0),(3022,'铁西区',3021,3,'_吉林_四平市_铁西区_',0),(3023,'铁东区',3021,3,'_吉林_四平市_铁东区_',0),(3024,'梨树县',3021,3,'_吉林_四平市_梨树县_',0),(3025,'伊通满族自治县',3021,3,'_吉林_四平市_伊通满族自治县_',0),(3026,'公主岭市',3021,3,'_吉林_四平市_公主岭市_',0),(3027,'双辽市',3021,3,'_吉林_四平市_双辽市_',0),(3028,'辽源市',2999,2,'_吉林_辽源市_',0),(3029,'龙山区',3028,3,'_吉林_辽源市_龙山区_',0),(3030,'西安区',3028,3,'_吉林_辽源市_西安区_',0),(3031,'东丰县',3028,3,'_吉林_辽源市_东丰县_',0),(3032,'东辽县',3028,3,'_吉林_辽源市_东辽县_',0),(3033,'通化市',2999,2,'_吉林_通化市_',0),(3034,'东昌区',3033,3,'_吉林_通化市_东昌区_',0),(3035,'二道江区',3033,3,'_吉林_通化市_二道江区_',0),(3036,'通化县',3033,3,'_吉林_通化市_通化县_',0),(3037,'辉南县',3033,3,'_吉林_通化市_辉南县_',0),(3038,'柳河县',3033,3,'_吉林_通化市_柳河县_',0),(3039,'梅河口市',3033,3,'_吉林_通化市_梅河口市_',0),(3040,'集安市',3033,3,'_吉林_通化市_集安市_',0),(3041,'白山市',2999,2,'_吉林_白山市_',0),(3042,'八道江区',3041,3,'_吉林_白山市_八道江区_',0),(3043,'抚松县',3041,3,'_吉林_白山市_抚松县_',0),(3044,'靖宇县',3041,3,'_吉林_白山市_靖宇县_',0),(3045,'长白朝鲜族自治县',3041,3,'_吉林_白山市_长白朝鲜族自治县_',0),(3046,'江源县',3041,3,'_吉林_白山市_江源县_',0),(3047,'临江市',3041,3,'_吉林_白山市_临江市_',0),(3048,'松原市',2999,2,'_吉林_松原市_',0),(3049,'宁江区',3048,3,'_吉林_松原市_宁江区_',0),(3050,'前郭尔罗斯蒙古族自治县',3048,3,'_吉林_松原市_前郭尔罗斯蒙古族自治县_',0),(3051,'长岭县',3048,3,'_吉林_松原市_长岭县_',0),(3052,'乾安县',3048,3,'_吉林_松原市_乾安县_',0),(3053,'扶余县',3048,3,'_吉林_松原市_扶余县_',0),(3054,'白城市',2999,2,'_吉林_白城市_',0),(3055,'洮北区',3054,3,'_吉林_白城市_洮北区_',0),(3056,'镇赉县',3054,3,'_吉林_白城市_镇赉县_',0),(3057,'通榆县',3054,3,'_吉林_白城市_通榆县_',0),(3058,'洮南市',3054,3,'_吉林_白城市_洮南市_',0),(3059,'大安市',3054,3,'_吉林_白城市_大安市_',0),(3060,'延边朝鲜族自治州',2999,2,'_吉林_延边朝鲜族自治州_',0),(3061,'延吉市',3060,3,'_吉林_延边朝鲜族自治州_延吉市_',0),(3062,'图们市',3060,3,'_吉林_延边朝鲜族自治州_图们市_',0),(3063,'敦化市',3060,3,'_吉林_延边朝鲜族自治州_敦化市_',0),(3064,'珲春市',3060,3,'_吉林_延边朝鲜族自治州_珲春市_',0),(3065,'龙井市',3060,3,'_吉林_延边朝鲜族自治州_龙井市_',0),(3066,'和龙市',3060,3,'_吉林_延边朝鲜族自治州_和龙市_',0),(3067,'汪清县',3060,3,'_吉林_延边朝鲜族自治州_汪清县_',0),(3068,'安图县',3060,3,'_吉林_延边朝鲜族自治州_安图县_',0),(3069,'黑龙江',0,1,'_黑龙江_',0),(3070,'哈尔滨市',3069,2,'_黑龙江_哈尔滨市_',0),(3071,'道里区',3070,3,'_黑龙江_哈尔滨市_道里区_',0),(3072,'南岗区',3070,3,'_黑龙江_哈尔滨市_南岗区_',0),(3073,'道外区',3070,3,'_黑龙江_哈尔滨市_道外区_',0),(3074,'香坊区',3070,3,'_黑龙江_哈尔滨市_香坊区_',0),(3075,'动力区',3070,3,'_黑龙江_哈尔滨市_动力区_',0),(3076,'平房区',3070,3,'_黑龙江_哈尔滨市_平房区_',0),(3077,'松北区',3070,3,'_黑龙江_哈尔滨市_松北区_',0),(3078,'呼兰区',3070,3,'_黑龙江_哈尔滨市_呼兰区_',0),(3079,'依兰县',3070,3,'_黑龙江_哈尔滨市_依兰县_',0),(3080,'方正县',3070,3,'_黑龙江_哈尔滨市_方正县_',0),(3081,'宾　县',3070,3,'_黑龙江_哈尔滨市_宾　县_',0),(3082,'巴彦县',3070,3,'_黑龙江_哈尔滨市_巴彦县_',0),(3083,'木兰县',3070,3,'_黑龙江_哈尔滨市_木兰县_',0),(3084,'通河县',3070,3,'_黑龙江_哈尔滨市_通河县_',0),(3085,'延寿县',3070,3,'_黑龙江_哈尔滨市_延寿县_',0),(3086,'阿城市',3070,3,'_黑龙江_哈尔滨市_阿城市_',0),(3087,'双城市',3070,3,'_黑龙江_哈尔滨市_双城市_',0),(3088,'尚志市',3070,3,'_黑龙江_哈尔滨市_尚志市_',0),(3089,'五常市',3070,3,'_黑龙江_哈尔滨市_五常市_',0),(3090,'齐齐哈尔市',3069,2,'_黑龙江_齐齐哈尔市_',0),(3091,'龙沙区',3090,3,'_黑龙江_齐齐哈尔市_龙沙区_',0),(3092,'建华区',3090,3,'_黑龙江_齐齐哈尔市_建华区_',0),(3093,'铁锋区',3090,3,'_黑龙江_齐齐哈尔市_铁锋区_',0),(3094,'昂昂溪区',3090,3,'_黑龙江_齐齐哈尔市_昂昂溪区_',0),(3095,'富拉尔基区',3090,3,'_黑龙江_齐齐哈尔市_富拉尔基区_',0),(3096,'碾子山区',3090,3,'_黑龙江_齐齐哈尔市_碾子山区_',0),(3097,'梅里斯达斡尔族区',3090,3,'_黑龙江_齐齐哈尔市_梅里斯达斡尔族区_',0),(3098,'龙江县',3090,3,'_黑龙江_齐齐哈尔市_龙江县_',0),(3099,'依安县',3090,3,'_黑龙江_齐齐哈尔市_依安县_',0),(3100,'泰来县',3090,3,'_黑龙江_齐齐哈尔市_泰来县_',0),(3101,'甘南县',3090,3,'_黑龙江_齐齐哈尔市_甘南县_',0),(3102,'富裕县',3090,3,'_黑龙江_齐齐哈尔市_富裕县_',0),(3103,'克山县',3090,3,'_黑龙江_齐齐哈尔市_克山县_',0),(3104,'克东县',3090,3,'_黑龙江_齐齐哈尔市_克东县_',0),(3105,'拜泉县',3090,3,'_黑龙江_齐齐哈尔市_拜泉县_',0),(3106,'讷河市',3090,3,'_黑龙江_齐齐哈尔市_讷河市_',0),(3107,'鸡西市',3069,2,'_黑龙江_鸡西市_',0),(3108,'鸡冠区',3107,3,'_黑龙江_鸡西市_鸡冠区_',0),(3109,'恒山区',3107,3,'_黑龙江_鸡西市_恒山区_',0),(3110,'滴道区',3107,3,'_黑龙江_鸡西市_滴道区_',0),(3111,'梨树区',3107,3,'_黑龙江_鸡西市_梨树区_',0),(3112,'城子河区',3107,3,'_黑龙江_鸡西市_城子河区_',0),(3113,'麻山区',3107,3,'_黑龙江_鸡西市_麻山区_',0),(3114,'鸡东县',3107,3,'_黑龙江_鸡西市_鸡东县_',0),(3115,'虎林市',3107,3,'_黑龙江_鸡西市_虎林市_',0),(3116,'密山市',3107,3,'_黑龙江_鸡西市_密山市_',0),(3117,'鹤岗市',3069,2,'_黑龙江_鹤岗市_',0),(3118,'向阳区',3117,3,'_黑龙江_鹤岗市_向阳区_',0),(3119,'工农区',3117,3,'_黑龙江_鹤岗市_工农区_',0),(3120,'南山区',3117,3,'_黑龙江_鹤岗市_南山区_',0),(3121,'兴安区',3117,3,'_黑龙江_鹤岗市_兴安区_',0),(3122,'东山区',3117,3,'_黑龙江_鹤岗市_东山区_',0),(3123,'兴山区',3117,3,'_黑龙江_鹤岗市_兴山区_',0),(3124,'萝北县',3117,3,'_黑龙江_鹤岗市_萝北县_',0),(3125,'绥滨县',3117,3,'_黑龙江_鹤岗市_绥滨县_',0),(3126,'双鸭山市',3069,2,'_黑龙江_双鸭山市_',0),(3127,'尖山区',3126,3,'_黑龙江_双鸭山市_尖山区_',0),(3128,'岭东区',3126,3,'_黑龙江_双鸭山市_岭东区_',0),(3129,'四方台区',3126,3,'_黑龙江_双鸭山市_四方台区_',0),(3130,'宝山区',3126,3,'_黑龙江_双鸭山市_宝山区_',0),(3131,'集贤县',3126,3,'_黑龙江_双鸭山市_集贤县_',0),(3132,'友谊县',3126,3,'_黑龙江_双鸭山市_友谊县_',0),(3133,'宝清县',3126,3,'_黑龙江_双鸭山市_宝清县_',0),(3134,'饶河县',3126,3,'_黑龙江_双鸭山市_饶河县_',0),(3135,'大庆市',3069,2,'_黑龙江_大庆市_',0),(3136,'萨尔图区',3135,3,'_黑龙江_大庆市_萨尔图区_',0),(3137,'龙凤区',3135,3,'_黑龙江_大庆市_龙凤区_',0),(3138,'让胡路区',3135,3,'_黑龙江_大庆市_让胡路区_',0),(3139,'红岗区',3135,3,'_黑龙江_大庆市_红岗区_',0),(3140,'大同区',3135,3,'_黑龙江_大庆市_大同区_',0),(3141,'肇州县',3135,3,'_黑龙江_大庆市_肇州县_',0),(3142,'肇源县',3135,3,'_黑龙江_大庆市_肇源县_',0),(3143,'林甸县',3135,3,'_黑龙江_大庆市_林甸县_',0),(3144,'杜尔伯特蒙古族自治县',3135,3,'_黑龙江_大庆市_杜尔伯特蒙古族自治县_',0),(3145,'伊春市',3069,2,'_黑龙江_伊春市_',0),(3146,'伊春区',3145,3,'_黑龙江_伊春市_伊春区_',0),(3147,'南岔区',3145,3,'_黑龙江_伊春市_南岔区_',0),(3148,'友好区',3145,3,'_黑龙江_伊春市_友好区_',0),(3149,'西林区',3145,3,'_黑龙江_伊春市_西林区_',0),(3150,'翠峦区',3145,3,'_黑龙江_伊春市_翠峦区_',0),(3151,'新青区',3145,3,'_黑龙江_伊春市_新青区_',0),(3152,'美溪区',3145,3,'_黑龙江_伊春市_美溪区_',0),(3153,'金山屯区',3145,3,'_黑龙江_伊春市_金山屯区_',0),(3154,'五营区',3145,3,'_黑龙江_伊春市_五营区_',0),(3155,'乌马河区',3145,3,'_黑龙江_伊春市_乌马河区_',0),(3156,'汤旺河区',3145,3,'_黑龙江_伊春市_汤旺河区_',0),(3157,'带岭区',3145,3,'_黑龙江_伊春市_带岭区_',0),(3158,'乌伊岭区',3145,3,'_黑龙江_伊春市_乌伊岭区_',0),(3159,'红星区',3145,3,'_黑龙江_伊春市_红星区_',0),(3160,'上甘岭区',3145,3,'_黑龙江_伊春市_上甘岭区_',0),(3161,'嘉荫县',3145,3,'_黑龙江_伊春市_嘉荫县_',0),(3162,'铁力市',3145,3,'_黑龙江_伊春市_铁力市_',0),(3163,'佳木斯市',3069,2,'_黑龙江_佳木斯市_',0),(3164,'永红区',3163,3,'_黑龙江_佳木斯市_永红区_',0),(3165,'向阳区',3163,3,'_黑龙江_佳木斯市_向阳区_',0),(3166,'前进区',3163,3,'_黑龙江_佳木斯市_前进区_',0),(3167,'东风区',3163,3,'_黑龙江_佳木斯市_东风区_',0),(3168,'郊　区',3163,3,'_黑龙江_佳木斯市_郊　区_',0),(3169,'桦南县',3163,3,'_黑龙江_佳木斯市_桦南县_',0),(3170,'桦川县',3163,3,'_黑龙江_佳木斯市_桦川县_',0),(3171,'汤原县',3163,3,'_黑龙江_佳木斯市_汤原县_',0),(3172,'抚远县',3163,3,'_黑龙江_佳木斯市_抚远县_',0),(3173,'同江市',3163,3,'_黑龙江_佳木斯市_同江市_',0),(3174,'富锦市',3163,3,'_黑龙江_佳木斯市_富锦市_',0),(3175,'七台河市',3069,2,'_黑龙江_七台河市_',0),(3176,'新兴区',3175,3,'_黑龙江_七台河市_新兴区_',0),(3177,'桃山区',3175,3,'_黑龙江_七台河市_桃山区_',0),(3178,'茄子河区',3175,3,'_黑龙江_七台河市_茄子河区_',0),(3179,'勃利县',3175,3,'_黑龙江_七台河市_勃利县_',0),(3180,'牡丹江市',3069,2,'_黑龙江_牡丹江市_',0),(3181,'东安区',3180,3,'_黑龙江_牡丹江市_东安区_',0),(3182,'阳明区',3180,3,'_黑龙江_牡丹江市_阳明区_',0),(3183,'爱民区',3180,3,'_黑龙江_牡丹江市_爱民区_',0),(3184,'西安区',3180,3,'_黑龙江_牡丹江市_西安区_',0),(3185,'东宁县',3180,3,'_黑龙江_牡丹江市_东宁县_',0),(3186,'林口县',3180,3,'_黑龙江_牡丹江市_林口县_',0),(3187,'绥芬河市',3180,3,'_黑龙江_牡丹江市_绥芬河市_',0),(3188,'海林市',3180,3,'_黑龙江_牡丹江市_海林市_',0),(3189,'宁安市',3180,3,'_黑龙江_牡丹江市_宁安市_',0),(3190,'穆棱市',3180,3,'_黑龙江_牡丹江市_穆棱市_',0),(3191,'黑河市',3069,2,'_黑龙江_黑河市_',0),(3192,'爱辉区',3191,3,'_黑龙江_黑河市_爱辉区_',0),(3193,'嫩江县',3191,3,'_黑龙江_黑河市_嫩江县_',0),(3194,'逊克县',3191,3,'_黑龙江_黑河市_逊克县_',0),(3195,'孙吴县',3191,3,'_黑龙江_黑河市_孙吴县_',0),(3196,'北安市',3191,3,'_黑龙江_黑河市_北安市_',0),(3197,'五大连池市',3191,3,'_黑龙江_黑河市_五大连池市_',0),(3198,'绥化市',3069,2,'_黑龙江_绥化市_',0),(3199,'北林区',3198,3,'_黑龙江_绥化市_北林区_',0),(3200,'望奎县',3198,3,'_黑龙江_绥化市_望奎县_',0),(3201,'兰西县',3198,3,'_黑龙江_绥化市_兰西县_',0),(3202,'青冈县',3198,3,'_黑龙江_绥化市_青冈县_',0),(3203,'庆安县',3198,3,'_黑龙江_绥化市_庆安县_',0),(3204,'明水县',3198,3,'_黑龙江_绥化市_明水县_',0),(3205,'绥棱县',3198,3,'_黑龙江_绥化市_绥棱县_',0),(3206,'安达市',3198,3,'_黑龙江_绥化市_安达市_',0),(3207,'肇东市',3198,3,'_黑龙江_绥化市_肇东市_',0),(3208,'海伦市',3198,3,'_黑龙江_绥化市_海伦市_',0),(3209,'大兴安岭地区',3069,2,'_黑龙江_大兴安岭地区_',0),(3210,'呼玛县',3209,3,'_黑龙江_大兴安岭地区_呼玛县_',0),(3211,'塔河县',3209,3,'_黑龙江_大兴安岭地区_塔河县_',0),(3212,'漠河县',3209,3,'_黑龙江_大兴安岭地区_漠河县_',0),(3213,'海南',0,1,'_海南_',0),(3214,'海口市',3213,2,'_海南_海口市_',0),(3215,'秀英区',3214,3,'_海南_海口市_秀英区_',0),(3216,'龙华区',3214,3,'_海南_海口市_龙华区_',0),(3217,'琼山区',3214,3,'_海南_海口市_琼山区_',0),(3218,'美兰区',3214,3,'_海南_海口市_美兰区_',0),(3219,'三亚市',3213,2,'_海南_三亚市_',0),(3220,'市辖区',3219,3,'_海南_三亚市_市辖区_',0),(3221,'省直辖县级行政单位',3213,2,'_海南_省直辖县级行政单位_',0),(3222,'五指山市',3221,3,'_海南_省直辖县级行政单位_五指山市_',0),(3223,'琼海市',3221,3,'_海南_省直辖县级行政单位_琼海市_',0),(3224,'儋州市',3221,3,'_海南_省直辖县级行政单位_儋州市_',0),(3225,'文昌市',3221,3,'_海南_省直辖县级行政单位_文昌市_',0),(3226,'万宁市',3221,3,'_海南_省直辖县级行政单位_万宁市_',0),(3227,'东方市',3221,3,'_海南_省直辖县级行政单位_东方市_',0),(3228,'定安县',3221,3,'_海南_省直辖县级行政单位_定安县_',0),(3229,'屯昌县',3221,3,'_海南_省直辖县级行政单位_屯昌县_',0),(3230,'澄迈县',3221,3,'_海南_省直辖县级行政单位_澄迈县_',0),(3231,'临高县',3221,3,'_海南_省直辖县级行政单位_临高县_',0),(3232,'白沙黎族自治县',3221,3,'_海南_省直辖县级行政单位_白沙黎族自治县_',0),(3233,'昌江黎族自治县',3221,3,'_海南_省直辖县级行政单位_昌江黎族自治县_',0),(3234,'乐东黎族自治县',3221,3,'_海南_省直辖县级行政单位_乐东黎族自治县_',0),(3235,'陵水黎族自治县',3221,3,'_海南_省直辖县级行政单位_陵水黎族自治县_',0),(3236,'保亭黎族苗族自治县',3221,3,'_海南_省直辖县级行政单位_保亭黎族苗族自治县_',0),(3237,'琼中黎族苗族自治县',3221,3,'_海南_省直辖县级行政单位_琼中黎族苗族自治县_',0),(3238,'西沙群岛',3221,3,'_海南_省直辖县级行政单位_西沙群岛_',0),(3239,'南沙群岛',3221,3,'_海南_省直辖县级行政单位_南沙群岛_',0),(3240,'中沙群岛的岛礁及其海域',3221,3,'_海南_省直辖县级行政单位_中沙群岛的岛礁及其海域_',0),(3241,'台湾',0,1,'_台湾_',0),(3242,'台湾',3241,2,'_台湾_台湾_',0),(3243,'台北市',3242,3,'_台湾_台湾_台北市_',0),(3244,'高雄市',3242,3,'_台湾_台湾_高雄市_',0),(3245,'马祖县',3242,3,'_台湾_台湾_马祖县_',0),(3246,'金门县',3242,3,'_台湾_台湾_金门县_',0),(3247,'基隆市',3242,3,'_台湾_台湾_基隆市_',0),(3248,'台中市',3242,3,'_台湾_台湾_台中市_',0),(3249,'新竹市',3242,3,'_台湾_台湾_新竹市_',0),(3250,'台南市',3242,3,'_台湾_台湾_台南市_',0),(3251,'嘉义市',3242,3,'_台湾_台湾_嘉义市_',0),(3252,'台北县',3242,3,'_台湾_台湾_台北县_',0),(3253,'台东县',3242,3,'_台湾_台湾_台东县_',0),(3254,'澎湖县',3242,3,'_台湾_台湾_澎湖县_',0),(3255,'花莲县',3242,3,'_台湾_台湾_花莲县_',0),(3256,'屏东县',3242,3,'_台湾_台湾_屏东县_',0),(3257,'高雄县',3242,3,'_台湾_台湾_高雄县_',0),(3258,'台南县',3242,3,'_台湾_台湾_台南县_',0),(3259,'嘉义县',3242,3,'_台湾_台湾_嘉义县_',0),(3260,'云林县',3242,3,'_台湾_台湾_云林县_',0),(3261,'南投县',3242,3,'_台湾_台湾_南投县_',0),(3262,'彰化县',3242,3,'_台湾_台湾_彰化县_',0),(3263,'台中县',3242,3,'_台湾_台湾_台中县_',0),(3264,'苗栗县',3242,3,'_台湾_台湾_苗栗县_',0),(3265,'桃园县',3242,3,'_台湾_台湾_桃园县_',0),(3266,'宜兰县',3242,3,'_台湾_台湾_宜兰县_',0),(3267,'新竹县',3242,3,'_台湾_台湾_新竹县_',0),(3268,'香港',0,1,'_香港_',0),(3269,'香港',3268,2,'_香港_香港_',0),(3270,'香港岛',3269,3,'_香港_香港_香港岛_',0),(3271,'九龙',3269,3,'_香港_香港_九龙_',0),(3272,'新界',3269,3,'_香港_香港_新界_',0),(3273,'澳门',0,1,'_澳门_',0),(3274,'澳门',3273,2,'_澳门_澳门_',0),(3275,'澳门',3274,3,'_澳门_澳门_澳门_',0);

/*Table structure for table `brands` */

DROP TABLE IF EXISTS `brands`;

CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌id',
  `name` varchar(32) NOT NULL COMMENT '品牌名称',
  `image_path` varchar(100) DEFAULT NULL COMMENT '图片地址',
  `desc` text COMMENT '介绍',
  `url` varchar(100) DEFAULT NULL COMMENT '品牌的网址',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '品牌排序',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `product_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品数量',
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已经删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='品牌表';

/*Data for the table `brands` */

/*Table structure for table `catalog` */

DROP TABLE IF EXISTS `catalog`;

CREATE TABLE `catalog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `name` varchar(255) NOT NULL COMMENT '分类名称',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '上级id',
  `product_num` int(11) NOT NULL DEFAULT '0' COMMENT '产品数量',
  `is_delete` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否被删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `email_templates`;

CREATE TABLE `email_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '模板ID',
  `name` varchar(32) NOT NULL COMMENT '模板名称',
  `code` int(11) NOT NULL COMMENT '模板代码',
  `title` varchar(50) NOT NULL COMMENT '邮件标题',
  `content` text COMMENT '邮件内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_delete` tinyint(1) unsigned DEFAULT '0' COMMENT '是否删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

/*Data for the table `email_templates` */

/*Table structure for table `express_company` */

DROP TABLE IF EXISTS `express_company`;

CREATE TABLE `express_company` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '快递公司id',
  `code` varchar(200) DEFAULT NULL COMMENT '代码',
  `name` varchar(200) DEFAULT NULL COMMENT '名称',
  `disabled` enum('true','false') DEFAULT 'false' COMMENT '是否启用',
  `ordernum` smallint(4) unsigned DEFAULT NULL COMMENT '订单数量',
  `website` varchar(200) DEFAULT NULL COMMENT '网站地址',
  `request_url` varchar(200) DEFAULT NULL COMMENT '请求url',
  PRIMARY KEY (`id`),
  KEY `ind_disabled` (`disabled`) USING BTREE,
  KEY `ind_ordernum` (`ordernum`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

/*Data for the table `express_company` */

insert  into `express_company`(`id`,`code`,`name`,`disabled`,`ordernum`,`website`,`request_url`) values (1,'EMS','中国邮政EMS','true',1,'http://www.ems.com.cn/','http://www.ems.com.cn/'),(2,'STO','申通快递','false',2,'http://www.sto.cn/','http://www.sto.cn/'),(3,'YTO','圆通速递','false',3,'http://www.yto.net.cn/','http://www.yto.net.cn/'),(4,'SF','顺丰速运','false',4,'http://www.sf-express.com/','http://www.sf-express.com/'),(5,'YUNDA','韵达快递','false',5,'http://www.yundaex.com/','http://www.yundaex.com/'),(6,'ZTO','中通速递','false',6,'http://www.zto.cn/','http://www.zto.cn/'),(7,'ZJS','宅急送','false',7,'http://www.zjs.com.cn/','http://www.zjs.com.cn/'),(8,'TTKDEX','天天快递','false',8,'http://www.ttkd.cn/','http://www.ttkd.cn/'),(9,'LBEX','龙邦快递','false',9,'http://www.lbex.com.cn/','http://www.lbex.com.cn/'),(10,'APEX','全一快递','false',10,'http://www.apex100.com/','http://www.apex100.com/'),(11,'HTKY','汇通速递','false',11,'http://www.htky365.com/','http://www.htky365.com/'),(12,'CNMH','民航快递','false',12,'http://www.cae.com.cn/','http://www.cae.com.cn/'),(13,'AIRFEX','亚风速递','false',13,'http://www.airfex.cn/','http://www.airfex.cn/'),(14,'CNKJ','快捷速递','false',14,'http://www.fastexpress.com.cn/','http://www.fastexpress.com.cn/'),(15,'DDS','DDS快递','false',15,'http://www.qc-dds.net/','http://www.qc-dds.net/'),(16,'HOAU','华宇物流','false',16,'http://www.hoau.net/','http://www.hoau.net/'),(17,'CRE','中铁快运','false',17,'http://www.cre.cn/','http://www.cre.cn/'),(18,'FedEx','FedEx','false',18,'http://www.fedex.com/cn/','http://www.fedex.com/cn/'),(19,'UPS','UPS','false',19,'http://www.ups.com/','http://www.ups.com/'),(20,'DHL','DHL','false',20,'http://www.cn.dhl.com/','http://www.cn.dhl.com/'),(21,'CYEXP','长宇','false',20,'http://www.cyexp.com/','http://www.cyexp.com/'),(22,'DBL','德邦物流','false',20,'http://www.deppon.com/','http://www.deppon.com/'),(23,'POST','POST','false',20,'http://www.183yf.cn/','http://www.183yf.cn/'),(24,'CCES','CCES','false',20,'http://www.cces.com.cn/','http://www.cces.com.cn/'),(25,'DTW','大田','false',20,'http://www.dtw.com.cn/','http://www.dtw.com.cn/'),(26,'ANTO','安得','false',20,'http://www.annto.com/','http://www.annto.com/'),(27,'其他','其他','false',50,'',''),(28,'BAM','平邮','false',1,'','');

/*Table structure for table `friend_links` */

DROP TABLE IF EXISTS `friend_links`;

CREATE TABLE `friend_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '友情链接id',
  `link_text` varchar(255) DEFAULT NULL COMMENT '链接文字',
  `link_url` varchar(255) DEFAULT NULL COMMENT '链接网址',
  `link_image` varchar(255) DEFAULT NULL COMMENT '链接图片',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_delete` tinyint(1) unsigned DEFAULT '0' COMMENT '是否被删除',
  `sort` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*Data for the table `friend_links` */

insert  into `friend_links`(`id`,`link_text`,`link_url`,`link_image`,`create_time`,`is_delete`,`sort`) values (1,'123phpmall','http://www.123phpmall.com',NULL,'2015-11-02 17:23:29',0,20),(2,'123phpshop','http://www.123phpshop.com',NULL,'2015-11-02 17:24:00',0,100),(3,'苹果公司','http://www.apple.com',NULL,'2015-11-19 09:02:26',0,10),(4,'IBM','http://www.ibm.com',NULL,'2015-12-03 17:59:55',0,100),(5,'谷歌','http://www.google.com',NULL,'2015-12-03 18:02:07',0,100);

/*Table structure for table `member` */

DROP TABLE IF EXISTS `member`;

CREATE TABLE `member` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `username` varchar(255) NOT NULL COMMENT '用户名',
  `password` varchar(255) DEFAULT NULL COMMENT '密码',
  `mobile` varchar(255) DEFAULT NULL COMMENT '手机',
  `email` varchar(255) DEFAULT NULL COMMENT '邮件',
  `register_at` varchar(255) DEFAULT NULL COMMENT '注册时间',
  `mobile_confirmed` varchar(255) DEFAULT NULL COMMENT '手机是否通过验证',
  `birth_date` date DEFAULT NULL COMMENT '生日',
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否被删除',
  `last_login_at` varchar(255) DEFAULT NULL COMMENT '最后一次登录时间',
  `last_login_ip` varchar(15) DEFAULT NULL COMMENT '最后一次登录ip',
  `role_id` int(10) unsigned DEFAULT '1' COMMENT '角色id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `member_consignee`;

CREATE TABLE `member_consignee` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '收货人id',
  `label` varchar(255) DEFAULT NULL COMMENT '标签',
  `consignee` varchar(255) DEFAULT NULL COMMENT '收货人姓名',
  `mobile` varchar(255) DEFAULT NULL COMMENT '收货人手机',
  `tel` varchar(255) DEFAULT NULL COMMENT '收货人电话',
  `province` varchar(11) DEFAULT NULL COMMENT '省份',
  `city` varchar(11) DEFAULT NULL COMMENT '城市',
  `distict` varchar(11) DEFAULT NULL COMMENT '区县',
  `address` varchar(255) DEFAULT NULL COMMENT '具体地址',
  `member_id` int(11) DEFAULT NULL COMMENT '用户的id',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `menu`;

CREATE TABLE `menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '菜单id',
  `name` varchar(255) NOT NULL COMMENT '名称',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '上级id',
  `is_feature` tinyint(1) DEFAULT '0' COMMENT '是否为功能',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `news`;

CREATE TABLE `news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章id',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `content` text COMMENT '内容',
  `publish_time` datetime DEFAULT NULL COMMENT '发布时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_delete` tinyint(255) NOT NULL DEFAULT '0' COMMENT '是否被删除',
  `clicks` int(255) NOT NULL DEFAULT '0' COMMENT '点击量',
  `from` varchar(255) DEFAULT NULL COMMENT '来源网址',
  `from_text` varchar(255) DEFAULT NULL COMMENT '来源显示文字',
  `catalog_id` int(11) NOT NULL COMMENT '分类id',
  `is_published` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否被发布',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

/*Data for the table `news` */

insert  into `news`(`id`,`title`,`content`,`publish_time`,`create_time`,`is_delete`,`clicks`,`from`,`from_text`,`catalog_id`,`is_published`) values (20,'123PHPSHOPV1.5上线啦！','<p>亲爱的用户：</p><p><br/></p><p>你好！</p><p>&nbsp; &nbsp;</p><p>&nbsp; &nbsp;欢迎使用123PHPSHOP V1.5。123PHPSHOP是一款由上海序程信息科技有限公司出品的，用最流行网站编程语言PHP语言编写的免费商城软件，您可以通过这个软件迅速搭建起来属于自己的商城系统。除了这款免费软件之外，序程信息科技有限公司还提供企业级的服务支持，详细请垂询13391334121，或是访问官网网站的相关页面：http://www.123phpshop.com/services.php.希望您使用愉快！</p><p style=\"text-align: center;\"><img src=\"/uploads/image/20160104/1451890696869629.png\" title=\"1451890696869629.png\" alt=\"20151220170332_738.png\"/></p>','2016-01-04 14:58:18','2015-09-26 11:47:54',0,0,'http://www.123phpshop.com','本站',1,1);


DROP TABLE IF EXISTS `news_catalog`;

CREATE TABLE `news_catalog` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '新闻分类id',
  `name` varchar(255) NOT NULL COMMENT '名称',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '上级id',
  `is_delete` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否被删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

/*Data for the table `news_catalog` */

insert  into `news_catalog`(`id`,`name`,`pid`,`is_delete`) values (1,'网站公告',0,0);

/*Table structure for table `order_item` */

DROP TABLE IF EXISTS `order_item`;

CREATE TABLE `order_item` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单产品id',
  `product_id` int(11) DEFAULT NULL COMMENT '产品id',
  `quantity` int(11) DEFAULT NULL COMMENT '数量',
  `should_pay_price` decimal(10,2) DEFAULT NULL COMMENT '应付价格',
  `actual_pay_price` decimal(10,2) DEFAULT NULL COMMENT '实际付款价格',
  `order_id` varchar(255) DEFAULT NULL COMMENT '订单id',
  `attr_value` varchar(255) DEFAULT NULL COMMENT '属性值',
  `is_present` tinyint(1) unsigned DEFAULT '0' COMMENT '是否是赠品',
  `is_delete` tinyint(1) unsigned DEFAULT '0' COMMENT '是否已经被删除',
  `is_special_price` tinyint(1) DEFAULT '0' COMMENT '是否是优惠产品',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=665 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `order_log`;

CREATE TABLE `order_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单处理id',
  `order_id` int(10) unsigned NOT NULL COMMENT '订单的id',
  `message` varchar(50) NOT NULL COMMENT '订单处理日志内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '发生时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=252 DEFAULT CHARSET=utf8 COMMENT='订单处理日志';


DROP TABLE IF EXISTS `order_promotion`;

CREATE TABLE `order_promotion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `order_id` int(10) unsigned NOT NULL COMMENT '订单id',
  `promotion_id` int(10) unsigned NOT NULL COMMENT '促销id',
  `promotion_fee` decimal(10,2) NOT NULL COMMENT '促销的金额，或是产品id',
  `promotion_presents` varchar(50) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='订单促销的映射表';


DROP TABLE IF EXISTS `orders`;

CREATE TABLE `orders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单id',
  `sn` varchar(255) NOT NULL COMMENT '订单编号',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `should_paid` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '应付金额',
  `actual_paid` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '实付金额',
  `order_status` smallint(3) NOT NULL DEFAULT '0' COMMENT '-300已经退款-200经退货-100已经撤销0未付款100已经付款200已经发货300已经收货',
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否被删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `shipping_method` tinyint(255) NOT NULL COMMENT '配送方式',
  `payment_method` varchar(255) NOT NULL COMMENT '支付方法',
  `invoice_is_needed` tinyint(1) DEFAULT '0' COMMENT '是否需要发票',
  `invoice_title` varchar(255) DEFAULT NULL COMMENT '发票抬头',
  `invoice_message` varchar(255) DEFAULT NULL COMMENT '发票内容',
  `delivery_at` datetime DEFAULT NULL COMMENT '可收货时间',
  `pay_at` datetime NOT NULL COMMENT '支付时间',
  `refund_at` datetime NOT NULL COMMENT '退款时间',
  `please_delivery_at` tinyint(1) NOT NULL DEFAULT '1' COMMENT '请在此时间段发货',
  `memo` varchar(255) DEFAULT NULL COMMENT '注释',
  `express_company_id` smallint(5) unsigned NOT NULL COMMENT '快递公司id',
  `express_sn` varchar(40) NOT NULL COMMENT '快递单号',
  `is_order_product_commented` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单是否评论完毕',
  `consignee_id` int(11) DEFAULT NULL COMMENT '收货人id',
  `consignee_name` varchar(30) DEFAULT NULL COMMENT '收货人姓名',
  `consignee_province` varchar(30) DEFAULT NULL COMMENT '收货人省份',
  `consignee_city` varchar(30) DEFAULT NULL COMMENT '收货人城市',
  `consignee_district` varchar(30) DEFAULT NULL COMMENT '收货人区县',
  `consignee_address` varchar(60) DEFAULT NULL COMMENT '收货人地址',
  `consignee_zip` char(6) DEFAULT NULL COMMENT '收货人邮编',
  `consignee_mobile` char(11) DEFAULT NULL COMMENT '收货人手机号码',
  `products_total` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '产品总金额',
  `shipping_fee` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '运费总金额',
  `promotion_fee` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '享受优惠的费用',
  `merge_to` int(10) unsigned DEFAULT '0' COMMENT '合并到的订单sn',
  `promotion_id` text COMMENT '享受的促销的id数组',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=273 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `pay_alipay`;

CREATE TABLE `pay_alipay` (
  `id` tinyint(1) unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(32) NOT NULL COMMENT '帐号',
  `security_code` varchar(32) NOT NULL COMMENT '交易安全校验码',
  `cooperate_user_info` varchar(32) NOT NULL COMMENT '合作者身份ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='支付宝支付配置';

DROP TABLE IF EXISTS `pay_log`;

CREATE TABLE `pay_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '支付log的id',
  `order_sn` varchar(32) NOT NULL COMMENT '订单id',
  `result` text NOT NULL COMMENT '结果',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=93 DEFAULT CHARSET=utf8 COMMENT='支付日志';


DROP TABLE IF EXISTS `pay_method`;

CREATE TABLE `pay_method` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '支付方式id',
  `name` varchar(30) NOT NULL COMMENT '名称',
  `folder` varchar(30) NOT NULL COMMENT '文件夹名称',
  `is_activated` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否被激活',
  `www` varchar(100) NOT NULL COMMENT '网址',
  `logo` varchar(100) NOT NULL COMMENT 'logo',
  `intro` text NOT NULL COMMENT '介绍',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='支付方式';

/*Data for the table `pay_method` */

insert  into `pay_method`(`id`,`name`,`folder`,`is_activated`,`www`,`logo`,`intro`) values (1,'支付宝','/admin/pay/pay_alipay',0,'http://www.alipay.com','','支付宝，中国第一支付品牌');

/*Table structure for table `privilege` */

DROP TABLE IF EXISTS `privilege`;

CREATE TABLE `privilege` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL COMMENT '名称',
  `is_menu` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '是否为菜单',
  `file_name` varchar(100) DEFAULT NULL COMMENT '相应的文件名称',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级权限的id',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序',
  `is_delete` tinyint(1) DEFAULT '0' COMMENT '是否被删除了，默认为否',
  `para` varchar(100) DEFAULT NULL COMMENT '文件的其他query_string',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=191 DEFAULT CHARSET=utf8 COMMENT='权限表';

/*Data for the table `privilege` */

insert  into `privilege`(`id`,`name`,`is_menu`,`file_name`,`pid`,`sort`,`is_delete`,`para`) values (1,'访问后台所有内容',0,'/admin',0,20000,0,NULL),(2,'广告管理',1,'',0,500,0,NULL),(3,'添加广告',1,'/admin/ad/add.php',2,200,0,NULL),(4,'查看广告详细',0,'/admin/ad/detail.php',2,20000,0,NULL),(5,'删除广告',0,'/admin/ad/remove.php',2,20000,0,NULL),(6,'订单管理',1,'',0,400,0,NULL),(7,'商品管理',1,'',0,200,0,NULL),(8,'促销管理',1,NULL,0,300,0,NULL),(9,'报告管理',1,'',0,600,1,NULL),(10,'权限管理',1,'',0,900,0,NULL),(11,'系统设置',1,'',0,1000,0,NULL),(14,'用户列表',1,'/admin/users/index.php',13,100,0,NULL),(15,'添加用户',1,'/admin/users/add.php',13,200,0,NULL),(16,'管理员列表',1,'/admin/admin/index.php',10,100,0,NULL),(17,'数据库备份',0,'/admin/db/backup.php',12,20000,0,NULL),(18,'支付方式',1,'/admin/pay_method/index.php',11,100,0,NULL),(19,'添加支付',1,'/admin/pay_method/add.php',11,200,0,NULL),(20,'配送方式',1,'/admin/shipping_method/index.php',11,300,0,NULL),(21,'添加配送方式',1,'/admin/shipping_method/add.php',11,400,0,NULL),(23,'邮件服务器',1,'/admin/mail/index.php',11,700,0,NULL),(24,'邮件发送设置',1,'/admin/mail/send_when.php',11,800,0,NULL),(25,'邮件模板列表',1,'/admin/email_template/index.php',11,900,0,NULL),(26,'添加邮件模板',1,'/admin/email_template/add.php',11,1000,0,NULL),(27,'区域管理',1,'/admin/area/index.php',11,1100,0,NULL),(28,'友情链接',1,'/admin/friend_links/index.php',11,1200,0,NULL),(29,'添加链接',1,'/admin/friend_links/add.php',11,1300,0,NULL),(32,'角色列表',1,'/admin/roles/index.php',10,300,0,NULL),(31,'添加管理员',1,'/admin/admin/add.php',10,200,0,NULL),(33,'添加角色',1,'/admin/roles/add.php',10,400,0,NULL),(34,'权限列表',1,'/admin/privileges/index.php',10,500,0,NULL),(35,'添加权限',1,'/admin/privileges/add.php',10,600,0,NULL),(36,'密码设置',1,'/admin/admin/update_password.php',10,700,0,NULL),(37,'访问统计',1,NULL,9,100,0,NULL),(38,'促销列表',1,'/admin/promotion/index.php',8,100,0,NULL),(39,'添加促销',1,'/admin/promotion/add.php',8,200,0,NULL),(40,'商品列表',1,'/admin/product/index.php',7,100,0,NULL),(41,'添加商品',1,'/admin/product/add.php',7,200,0,NULL),(42,'商品分类',1,'/admin/catalog/index.php',7,300,0,NULL),(43,'品牌管理',1,'/admin/brands/index.php',7,400,0,NULL),(44,'添加品牌',1,'/admin/brands/add.php',7,500,0,NULL),(45,'商品类型',1,'/admin/product_type/index.php',7,600,0,NULL),(46,'商品类型添加',0,'/admin/product_type',7,20000,0,NULL),(47,'商品评论',1,'/admin/user_comments/index.php',7,700,0,NULL),(48,'商品咨询',1,'/admin/user_consult/index.php',7,800,0,NULL),(49,'商品回收站',1,'/admin/product/recycled.php',7,900,0,NULL),(50,'商品导出',1,'/admin/product/export.php',7,1000,0,NULL),(51,'商品导入',1,'/admin/product/import.php',7,1100,0,NULL),(52,'虚拟商品列表',1,'/admin/product/vindex.php',7,1200,0,NULL),(53,'添加虚拟商品',1,'/admin/product/vadd.php',7,1300,0,NULL),(54,'订单列表',1,'/admin/order/index.php',6,100,0,NULL),(55,'添加订单',1,'/admin/order/add.php',6,200,0,NULL),(56,'订单合并',1,'/admin/order/merge.php',6,300,0,NULL),(57,'发货订单',1,'/admin/order/index.php',6,400,0,'?status=0'),(58,'退货订单',1,'/admin/order/index.php',6,500,0,'?status=-150'),(59,'订单回收站',1,'/admin/order/recycle.php',6,600,0,NULL),(60,'广告列表',1,'/admin/ad/index.php',2,100,0,NULL),(61,'删除用户',0,'/admin/users/remove.php',13,20000,0,NULL),(62,'更新用户信息',0,'/admin/users/update.php',13,20000,0,NULL),(63,'友情链接删除',0,'/admin/friend_links/remove.php',11,20000,0,NULL),(64,'友情链接更新',0,'/admin/friend_links/update.php',11,20000,0,NULL),(65,'邮件模板删除',0,'/admin/email_template/remove.php',11,20000,0,NULL),(66,'管理员删除',0,'/admin/admin/remove.php',10,20000,0,NULL),(67,'删除订单',0,'/admin/order/remove.php',6,20000,0,NULL),(68,'更新广告',0,'/admin/ad/update.php',2,20000,0,NULL),(69,'更新订单',0,'/admin/order/update_order_user.php',6,20000,0,NULL),(98,'商品分类添加',0,'/admin/catalog/index.php',7,20000,0,NULL),(71,'删除订单的产品',0,'/admin/order/remove_order_item.php',6,20000,0,NULL),(72,'查看订单详情',0,'/admin/order/detail.php',6,20000,0,NULL),(73,'邮件模板删除',0,'/admin/email_template/remove.php',11,20000,0,NULL),(74,'邮件模板更新',0,'/admin/email_template/update.php',11,20000,0,NULL),(75,'激活配送方式',0,'/admin/shipping_method/activate.php',11,20000,0,NULL),(76,'激活支付方式',0,'/admin/pay_method/activate.php',11,20000,0,NULL),(77,'停用配送方式',0,'/admin/pay_method/deactivate.php',11,20000,0,NULL),(78,'配送方式停用',0,'/admin/shipping_method/deactivate.php',11,20000,0,NULL),(79,'停用支付方式',0,'/admin/pay_method/deactivate.php',11,20000,0,NULL),(80,'删除促销',0,'/admin/promotion/remove.php',8,20000,0,NULL),(81,'更新促销',0,'/admin/promotion/update.php',8,20000,0,NULL),(82,'删除商品',0,'/admin/product/remove.php',7,20000,0,NULL),(83,'恢复回收站商品',0,'/admin/product/unrecycled.php',7,20000,0,NULL),(84,'回复商品咨询',0,'/admin/user_consult/replay.php',7,20000,0,NULL),(85,'删除商品评论',0,'/admin/user_comments/remove.php',7,20000,0,NULL),(86,'商品咨询删除',0,'/admin/user_consult/remove.php',7,20000,0,NULL),(87,'商品类型删除',0,'/admin/product_type/remove.php',7,20000,0,NULL),(88,'商品类型更新',0,'/admin/product_type/update.php',7,20000,0,NULL),(89,'商品类型的属性添加',0,'/admin/attr_group/add.php',7,20000,0,NULL),(91,'删除角色',0,'/admin/roles/remove.php',10,20000,0,NULL),(92,'角色编辑',0,'/admin/roles/edit.php',10,20000,0,NULL),(93,'权限删除',0,'/admin/privileges/remove.php',10,20000,0,NULL),(94,'权限编辑',0,'/admin/privileges/edit.php',10,20000,0,NULL),(95,'更新订单的收货人',0,'/admin/order/update_order_user.php',6,20000,0,NULL),(96,'为订单添加商品',0,'/admin/order/add_order_item.php',6,20000,0,NULL),(97,'删除订单中的商品',0,'/admin/order/remove_order_item.php',6,20000,0,NULL),(99,'商品分类删除',0,'/admin/product_type/remove.php',7,20000,0,NULL),(100,'商品分类更新',0,'/admin',7,20000,0,NULL),(101,'品牌删除',0,'/admin/brands/remove.php',7,20000,0,NULL),(102,'品牌更新',0,'/admin/brands/update.php',7,20000,0,NULL),(103,'商品类型属性删除',0,'/admin/attr_group/remove.php',7,20000,0,NULL),(104,'商品类型的属性更新',0,'/admin/attr_group/update.php',7,20000,0,NULL),(105,'设置商品的属性',0,'/admin',7,20000,1,NULL),(106,'商品更新',0,'/admin/product/update.php',7,20000,0,NULL),(107,'控制面板',1,'/admin/_main.php',0,100,0,NULL),(13,'用户管理',1,'',0,700,0,NULL),(109,'文章管理',1,'',0,800,0,NULL),(110,'数据库管理',1,'/admin/db/backup.php',0,1100,0,NULL),(111,'数据库导出',1,'/admin/db/backup.php',110,100,0,NULL),(112,'文章列表',1,'/admin/news/index.php',109,100,0,NULL),(113,'文章分类',1,'/admin/news_catalog/index.php',109,200,0,NULL),(114,'文章回收站',1,'/admin/news/recycled.php',109,300,0,NULL),(115,'快递公司',1,'/.buildpath',10,NULL,1,NULL),(116,'店铺信息',1,'/admin/info.php',11,1300,0,NULL),(118,'快递公司',1,'/admin/express_company/index.php',11,50,0,NULL),(119,'权限测试',0,'',0,NULL,1,NULL),(120,'添加文章',1,NULL,109,NULL,1,NULL),(121,'删除文章',0,'/admin/news/remove.php',109,2000,0,NULL),(122,'文章更新',0,'/admin/news/update.php',109,2000,0,NULL),(123,'文章分类添加',0,'/admin/news_catalog/index.php',109,2000,0,NULL),(124,'文章分类删除',0,'/admin/news_catalog/remove.php',109,2000,0,NULL),(125,'文章分类更新',0,'/admin/news_catalog/update.php',109,2000,0,NULL),(126,'文章添加',0,'/admin/news/add.php',109,2000,0,NULL),(127,'文章恢复',0,'/admin/news/unrecycle.php',109,2000,0,NULL),(128,'管理员更新',0,'/admin/admin/update.php',10,2000,0,NULL),(129,'后台首页',0,'/admin/index.php',0,NULL,0,NULL),(130,'添加产品的时候检查产品名称是否存在',0,'/admin/product/ajax_product_name.php',7,NULL,1,NULL),(131,'更新产品的时候检查产品名称是否已经存在',0,'/admin/product/ajax_update_product_name.php',7,NULL,1,NULL),(132,'广告图片删除',0,'/admin/add_images/remove.php',2,2000,0,NULL),(133,'前端添加管理员时检查邮件是否存在',1,'/admin/admin/ajax_email.php',10,20000,1,NULL),(134,'前端添加管理员时检查手机是否已经存在',1,'/admin/admin/ajax_mobile.php',10,2000,1,NULL),(135,'添加管理员时前端检查用户名是否已经存在',1,'/admin/admin/ajax_username.php',10,2000,1,NULL),(136,'前端更新管理员时检查邮件是否存在',1,'/admin/admin/ajax_update_email.php',10,2000,1,NULL),(137,'前端更新管理员时检查手机是否存在',1,'/admin/admin/ajax_update_mobile.php',10,2000,1,NULL),(138,'前端更新管理员时检查用户名是否存在',1,'/admin/admin/ajax_update_username.php',10,2000,1,NULL),(139,'查看管理员详细',0,'/admin/admin/detail.php',10,2000,0,NULL),(140,'为角色分配权限',0,'/admin/roles/assign.php',10,2000,0,NULL),(141,'查看商品分类属性详细',0,'/admin/attr_group/detail.php',7,20000,0,NULL),(142,'查看商品属性列表',0,'/admin/attr_group/index.php',7,20000,0,NULL),(143,'查看品牌详细',0,'/admin/brands/detail.php',7,2000,0,NULL),(144,'分类删除',0,'/admin/catalog/remove.php',7,2000,0,NULL),(145,'分类更新',0,'/admin/catalog/update.php',7,2000,0,NULL),(146,'快递公司激活',0,'/admin/express_company/activate.php',11,2000,0,NULL),(147,'快递公司停用',0,'/admin/express_company/deactivate.php',11,2000,0,NULL),(148,'快递公司详细',0,'/admin/express_company/detail.php',11,20000,0,NULL),(149,'快递公司更新',0,'/admin/express_company/update.php',11,2000,0,NULL),(150,'订单添加收货人',0,'/admin/order/add_consignee.php',6,2000,0,NULL),(151,'订单发货',0,'/admin/order/delivery.php',6,2000,0,NULL),(152,'订单退款',0,'/admin/order/refund.php',6,20000,0,NULL),(153,'订单退货',0,'/admin/order/return.php',6,20000,0,NULL),(154,'订单恢复',0,'/admin/order/unrecycle.php',6,2000,0,NULL),(155,'订单更新',0,'/admin/order/update.php',6,2000,0,NULL),(156,'支付宝设置',0,'/admin/pay/pay_alipay/index.php',11,2000,0,NULL),(157,'支付更新',0,'/admin/pay_method/update.php',11,2000,0,NULL),(158,'商品详情',1,'/admin/product/detail.php',11,20000,1,NULL),(159,'商品图片删除',0,'/admin/product_images/remove.php',7,20000,0,NULL),(160,'商品类型详细',0,'/admin/product_type/detail.php',7,20000,0,NULL),(161,'促销详细',0,'/admin/promotion/detail.php',8,2000,0,NULL),(162,'快递方式详细',0,'/admin/shipping_method/detail.php',11,20000,0,NULL),(163,'快递方式删除',0,'/admin/shipping_method/remove.php',11,20000,0,NULL),(164,'快递方式更新',0,'/admin/shipping_method/update.php',11,2000,0,NULL),(165,'配送区域详细',0,'/admin/shipping_method_area/detail.php',11,20000,0,NULL),(166,'配区域ems添加',0,'/admin/shipping_method_area/ems/add.php',11,20000,0,NULL),(167,'配区域ems更新',0,'/admin/shipping_method_area/ems/update.php',11,20000,0,NULL),(168,'配送方式列表',1,'/admin/shipping_method/index.php',11,20000,0,NULL),(169,'配送区域列表',0,'/admin/shipping_method_area/index.php',11,20000,0,NULL),(170,'配送区域删除',0,'/admin/shipping_method_area/remove.php',11,20000,0,NULL),(171,'配送区域申通添加',0,'/admin/shipping_method_area/shunfeng/add.php',11,2000,0,NULL),(172,'配送区域申通更新',0,'/admin/shipping_method_area/shentong/update.php',11,2000,0,NULL),(173,'配送区域顺风更新',0,'/admin/shipping_method_area/shunfeng/update.php',11,2000,0,NULL),(174,'配送区域顺风添加',0,'/admin/shipping_method_area/shunfeng/add.php',11,2000,0,NULL),(175,'配送区域圆通添加',0,'/admin/shipping_method_area/yuantong/add.php',11,2000,0,NULL),(176,'配送区域圆通更新',0,'/admin/shipping_method_area/yuantong/update.php',11,2000,0,NULL),(177,'配送区域中通添加',0,'/admin/shipping_method_area/zhongtong/add.php',11,2000,0,NULL),(178,'配送区域中通编辑',0,'/admin/shipping_method_area/zhongtong/update.php',11,20000,0,NULL),(179,'用户详细信息',0,'/admin/users/detail.php',13,20000,0,NULL),(180,'商品咨询详细',0,'/admin/user_consult/detail.php',7,2000,0,NULL),(181,'模板管理',1,'/admin/theme/index.php',0,1050,0,NULL),(182,'添加模板',1,'/admin/theme/add.php',181,1060,0,NULL),(183,'删除权限',0,NULL,11,20000,0,NULL),(184,'更新权限',1,'/admin/theme/update.php',11,20000,0,NULL),(185,'读写分离',1,'/admin/db/reader_writer.php',110,400,0,NULL),(186,'修改表前缀',1,'/admin/db/table_prefix.php',110,300,0,NULL),(187,'数据库恢复',1,'/admin/db/restore.php',110,200,0,NULL),(188,'高速缓存',1,NULL,0,1200,0,NULL),(189,'Redis',1,'/admin/cache/redis.php',188,100,0,NULL),(190,'Memcached',1,'/admin/cache/memcach.php',188,200,0,NULL);

/*Table structure for table `product` */

DROP TABLE IF EXISTS `product`;

CREATE TABLE `product` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) DEFAULT NULL COMMENT '产品名称',
  `ad_text` varchar(255) DEFAULT NULL COMMENT '广告语，一般显示于产品名称的下面',
  `catalog_id` int(11) DEFAULT NULL COMMENT '分类id',
  `product_type_id` int(11) DEFAULT '0' COMMENT '产品类型id',
  `cata_path` varchar(100) NOT NULL COMMENT '分类路径',
  `brand_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '品牌的id',
  `weight` decimal(10,2) unsigned NOT NULL COMMENT '重量：克',
  `unit` varchar(10) NOT NULL COMMENT '单位，如箱，盒或是支',
  `is_shipping_free` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否免运费',
  `meta_keywords` varchar(100) DEFAULT NULL COMMENT 'meta关键词',
  `meta_desc` varchar(100) DEFAULT NULL COMMENT 'meta描述',
  `is_virtual` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否为虚拟物品',
  `intro` varchar(10000) DEFAULT NULL COMMENT '介绍',
  `price` decimal(10,2) unsigned DEFAULT NULL COMMENT '价格',
  `is_promotion` tinyint(1) unsigned DEFAULT '0' COMMENT '是否优惠',
  `promotion_price` decimal(10,2) unsigned DEFAULT NULL COMMENT '优惠价格',
  `promotion_start` date DEFAULT NULL COMMENT '优惠起始时间',
  `promotion_end` date DEFAULT NULL COMMENT '优惠结束时间',
  `market_price` decimal(10,2) unsigned DEFAULT NULL COMMENT '市场价',
  `pointers` int(11) unsigned DEFAULT '1' COMMENT '返点的倍数',
  `sold_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '销量',
  `rated_num` int(11) unsigned DEFAULT '0' COMMENT '评价数量',
  `commented_num` int(11) unsigned DEFAULT '0' COMMENT '评论数量',
  `consulted_num` int(11) unsigned DEFAULT '0' COMMENT '咨询数量',
  `on_sheft_time` datetime DEFAULT NULL COMMENT '上架时间',
  `is_on_sheft` tinyint(1) unsigned DEFAULT '0' COMMENT '是否上架',
  `is_hot` tinyint(1) unsigned DEFAULT '0' COMMENT '是否为热销产品',
  `is_season` tinyint(1) unsigned DEFAULT '0' COMMENT '是否当季产品',
  `is_recommanded` tinyint(1) unsigned DEFAULT '0' COMMENT '是否为推荐产品',
  `description` varchar(255) DEFAULT NULL COMMENT '商家备注',
  `tags` text NOT NULL COMMENT '标签',
  `store_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '库存',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `is_delete` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否已被删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `product_comment`;

CREATE TABLE `product_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '评论id',
  `order_id` int(10) unsigned NOT NULL COMMENT '订单id',
  `product_id` int(10) unsigned NOT NULL COMMENT '产品id',
  `user_id` int(10) unsigned NOT NULL COMMENT '用户id',
  `message` varchar(300) NOT NULL COMMENT '内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `response_to` int(10) unsigned NOT NULL COMMENT '回复给',
  `is_delete` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否被删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='产品评论';


DROP TABLE IF EXISTS `product_consult`;

CREATE TABLE `product_consult` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '咨询id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `content` varchar(255) DEFAULT NULL COMMENT '内容',
  `to_question` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '回答的问题id',
  `product_id` int(10) unsigned NOT NULL COMMENT '产品id',
  `is_delete` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否被删除',
  `is_replied` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否被回答过了',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `product_images`;

CREATE TABLE `product_images` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '图片id',
  `product_id` int(11) DEFAULT NULL COMMENT '产品id',
  `image_files` varchar(255) DEFAULT NULL COMMENT '图片文件',
  `uploader_id` int(10) unsigned NOT NULL COMMENT '上传人员id',
  `is_download` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否是文件下载',
  `tags` varchar(300) NOT NULL COMMENT '标签',
  `support_versions` varchar(100) NOT NULL COMMENT '支持版本',
  `is_delete` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否被删除',
  `create_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `product_import`;

CREATE TABLE `product_import` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_path` varchar(100) DEFAULT NULL COMMENT '导入文件的path',
  `user_id` int(10) unsigned DEFAULT NULL COMMENT '用户的id',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8 COMMENT='产品导入的历史记录';


DROP TABLE IF EXISTS `product_type`;

CREATE TABLE `product_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品类型id',
  `name` varchar(32) NOT NULL COMMENT '类型名称',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级id',
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='产品类型';


DROP TABLE IF EXISTS `product_type_attr`;

CREATE TABLE `product_type_attr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品类型属性的id',
  `name` varchar(32) NOT NULL COMMENT '商品类型属性名称',
  `is_selectable` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否可选',
  `input_method` tinyint(1) NOT NULL DEFAULT '1' COMMENT '输入方法',
  `selectable_value` text COMMENT '可选属性类型',
  `product_type_id` int(10) unsigned NOT NULL COMMENT '产品类型的id',
  `is_delete` tinyint(1) unsigned DEFAULT '0' COMMENT '是否已经删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COMMENT='产品类型的属性列表';


DROP TABLE IF EXISTS `product_type_attr_val`;

CREATE TABLE `product_type_attr_val` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品类型属性值的id',
  `product_id` int(10) unsigned NOT NULL COMMENT '商品id',
  `product_type_attr_id` int(10) unsigned NOT NULL COMMENT '商品类型属性的id',
  `product_type_attr_value` varchar(50) NOT NULL COMMENT '商品类型属性的值',
  `price` decimal(10,2) NOT NULL COMMENT '价格',
  `is_delete` tinyint(1) unsigned DEFAULT '0' COMMENT '是否被删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=103 DEFAULT CHARSET=utf8 COMMENT='产品类型的属性的价值';


DROP TABLE IF EXISTS `promotion`;

CREATE TABLE `promotion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(32) NOT NULL COMMENT ' 促销名称',
  `start_date` date NOT NULL COMMENT '开始日期',
  `end_date` date NOT NULL COMMENT '结束日期',
  `promotion_limit` tinyint(1) unsigned NOT NULL COMMENT '促销范围1:全场2某种类3某品牌4某商品',
  `amount_lower_limit` decimal(10,2) NOT NULL COMMENT '享受促销的商品金额下线',
  `promotion_limit_value` text,
  `amount_uper_limit` decimal(10,2) NOT NULL COMMENT '享受促销的商品金额上限',
  `promotion_type` tinyint(1) unsigned NOT NULL COMMENT '促销种类1是满赠2满减3满折',
  `present_products` text CHARACTER SET latin1 COMMENT '满赠商品id',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `promotion_type_val` varchar(32) DEFAULT NULL,
  `is_delete` tinyint(1) unsigned DEFAULT '0' COMMENT '是否已经被删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `role`;

CREATE TABLE `role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色id',
  `name` varchar(255) DEFAULT NULL COMMENT '角色名称',
  `pid` int(11) DEFAULT NULL COMMENT '上级id',
  `privileges` text NOT NULL COMMENT '所具有的权限的id',
  `is_delete` tinyint(1) DEFAULT '0' COMMENT '是否被删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

/*Data for the table `role` */

insert  into `role`(`id`,`name`,`pid`,`privileges`,`is_delete`) values (1,'系统管理员',0,'1',0),(6,'商品管理员',0,'6,54,55,56,57,58,59,67,69,71,72,95,96,97,7,40,41,42,43,44,45,46,47,48,49,50,51,52,53,98,82,83,84,85,86,87,88,89,99,100,101,102,103,104,105,106',1),(9,'商品管理员',0,'2,3,4,60,6,54,55,56,57,58,59,67,69,71,72,95,96,97,150,151,152,153,154,155,7,40,41,42,43,44,45,46,47,48,49,50,51,52,53,98,82,83,84,85,86,87,88,89,99,100,101,102,103,104,105,106,130,131,141,142,143,144,145,159,160,180,8,38,39,80,81,161,10,16,32,31,33,34,35,36,66,91,92,93,94,115,128,133,134,135,136,137,138,139,140,129',0),(10,'测死',0,'',1);


DROP TABLE IF EXISTS `shipping_method`;

CREATE TABLE `shipping_method` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配送方式id',
  `name` varchar(32) NOT NULL COMMENT '配送方式名称',
  `desc` text NOT NULL COMMENT '描述',
  `config_file_path` char(100) DEFAULT NULL COMMENT '添加配送区域文件的位置',
  `is_activated` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否被激活，默认为否',
  `is_cod` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为货到付款， 默认为否',
  `is_free` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否免费，默认为否',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_delete` tinyint(1) DEFAULT '0' COMMENT '是否被删除',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='配送方式表';

/*Data for the table `shipping_method` */

insert  into `shipping_method`(`id`,`name`,`desc`,`config_file_path`,`is_activated`,`is_cod`,`is_free`,`create_time`,`is_delete`) values (3,'顺丰速递','顺丰速递','shunfeng',1,0,0,'2015-09-28 09:53:11',0),(4,'圆通速递','圆通速递','yuantong',1,0,0,'2015-09-29 10:28:57',0),(5,'申通速递','申通速递','shentong',1,0,0,'2015-09-29 10:34:58',0),(6,'中通速递','中通速递','zhongtong',1,0,0,'2015-09-29 10:35:17',0),(7,'EMS快递','EMS','EMS',1,0,0,'2015-10-07 09:31:58',0);

/*Table structure for table `shipping_method_area` */

DROP TABLE IF EXISTS `shipping_method_area`;

CREATE TABLE `shipping_method_area` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配送方式支持区域id',
  `shipping_method_id` tinyint(3) unsigned NOT NULL COMMENT '配送方式id',
  `area` text NOT NULL COMMENT '配送区域',
  `shipping_by_quantity` tinyint(1) unsigned DEFAULT '0' COMMENT '是否按照商品数量进行计算',
  `basic_fee` decimal(10,2) unsigned DEFAULT NULL COMMENT '基本费',
  `first_kg_fee` decimal(10,2) unsigned DEFAULT NULL COMMENT '首千克费用',
  `continue_kg_fee` decimal(10,2) unsigned DEFAULT NULL COMMENT '续千克费用',
  `free_quota` decimal(10,2) unsigned DEFAULT NULL COMMENT '免费额度',
  `name` varchar(32) NOT NULL COMMENT '区域名称',
  `cod_fee` decimal(10,2) unsigned DEFAULT NULL COMMENT '货到付款后费用',
  `single_product_fee` decimal(10,2) unsigned DEFAULT NULL COMMENT '单件商品费用',
  `half_kg_fee` decimal(10,2) unsigned DEFAULT NULL COMMENT '首500克费用',
  `continue_half_kg_fee` decimal(10,2) unsigned DEFAULT NULL COMMENT '续500克费用',
  `is_delete` tinyint(1) unsigned DEFAULT '0' COMMENT '是否已经删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='配送方式区域表';

DROP TABLE IF EXISTS `shop_info`;

CREATE TABLE `shop_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL COMMENT '店铺名称',
  `email` varchar(32) NOT NULL COMMENT '店铺联系email',
  `mobile` varchar(11) NOT NULL COMMENT '店铺手机',
  `province` varchar(15) NOT NULL COMMENT '店铺所在省份',
  `city` varchar(15) NOT NULL COMMENT '店铺所在城市',
  `district` varchar(15) NOT NULL COMMENT '店铺所在区域',
  `address` varchar(32) NOT NULL COMMENT '店铺所在地址',
  `zip` char(6) NOT NULL COMMENT '店铺邮编',
  `logo_path` varchar(100) NOT NULL COMMENT '店铺logo路径',
  `smtp_server` varchar(50) NOT NULL COMMENT '邮件服务器地址',
  `smtp_port` int(10) unsigned NOT NULL DEFAULT '25' COMMENT '邮件服务器端口',
  `smtp_username` varchar(32) NOT NULL COMMENT '邮件服务器登录名',
  `smtp_password` varchar(32) NOT NULL COMMENT '邮件服务器登录密码',
  `smtp_email` varchar(50) NOT NULL COMMENT '发送邮件地址',
  `smtp_ssl` tinyint(1) unsigned DEFAULT '0' COMMENT '是否支持ssl',
  `smtp_replay_email` varchar(50) DEFAULT NULL COMMENT '回复邮件的地址',
  `send_when` text COMMENT '发送邮件的时机',
  `stat_code` text COMMENT '统计代码',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*Data for the table `shop_info` */

insert  into `shop_info`(`id`,`name`,`email`,`mobile`,`province`,`city`,`district`,`address`,`zip`,`logo_path`,`smtp_server`,`smtp_port`,`smtp_username`,`smtp_password`,`smtp_email`,`smtp_ssl`,`smtp_replay_email`,`send_when`,`stat_code`) values (1,'123phpshop','','','上海','上海','黄浦区','','','/uploads/product/20150926053827_428.png','',0,'','','',1,'','',NULL);

/*Table structure for table `theme` */

DROP TABLE IF EXISTS `theme`;

CREATE TABLE `theme` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL COMMENT '模板名称',
  `folder_name` varchar(32) NOT NULL COMMENT '文件夹名称',
  `author` varchar(32) NOT NULL,
  `version` varchar(32) NOT NULL,
  `contact` varchar(32) NOT NULL,
  `intro` text NOT NULL,
  `is_delete` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='模板表';

/*Data for the table `theme` */

insert  into `theme`(`id`,`name`,`folder_name`,`author`,`version`,`contact`,`intro`,`is_delete`) values (1,'默认模板','default','123phpshop团队','v1.0','service@123phpshop.com','123phpshop默认模板',0);

/*Table structure for table `user` */

DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `username` varchar(255) NOT NULL COMMENT '用户名',
  `password` varchar(32) NOT NULL COMMENT '密码',
  `email` varchar(255) DEFAULT NULL COMMENT '邮件',
  `mobile` varchar(255) DEFAULT NULL COMMENT '手机',
  `mobile_confirmed` varchar(255) DEFAULT NULL COMMENT '手机是否已验证',
  `sms_code` varchar(255) DEFAULT NULL COMMENT '手机验证码',
  `gender` tinyint(1) DEFAULT '1' COMMENT '性别',
  `birth_date` date DEFAULT NULL COMMENT '出生日期',
  `province` varchar(11) DEFAULT NULL COMMENT '省份',
  `city` varchar(11) DEFAULT NULL COMMENT '城市',
  `district` varchar(11) DEFAULT NULL COMMENT '区县',
  `address` varchar(32) DEFAULT NULL COMMENT '地址',
  `register_at` varchar(255) NOT NULL COMMENT '注册时间',
  `last_login_at` varchar(255) NOT NULL DEFAULT 'CURRENT_TIMESTAMP' COMMENT '最后一次登录时间',
  `last_login_ip` varchar(15) NOT NULL COMMENT '最后一次登录的ip',
  `is_delete` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否被删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `user_consignee`;

CREATE TABLE `user_consignee` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(32) NOT NULL COMMENT '收货人姓名',
  `mobile` varchar(11) NOT NULL COMMENT '收货人手机号码',
  `province` varchar(10) NOT NULL COMMENT '省份',
  `city` varchar(15) NOT NULL COMMENT '城市',
  `district` varchar(15) NOT NULL COMMENT '地区',
  `address` varchar(100) NOT NULL COMMENT '具体地址',
  `zip` varchar(6) NOT NULL COMMENT '邮政编码',
  `user_id` int(11) unsigned NOT NULL COMMENT '创建人id',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已经被删除',
  `is_default` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为默认收货人',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8 COMMENT='收货人表';

DROP TABLE IF EXISTS `user_favorite`;

CREATE TABLE `user_favorite` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户收藏ID',
  `user_id` int(10) unsigned NOT NULL COMMENT '用户id',
  `product_id` int(10) unsigned NOT NULL COMMENT '产品id',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `is_delete` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='用户收藏表';

DROP TABLE IF EXISTS `user_view_history`;

CREATE TABLE `user_view_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户浏览记录id',
  `user_id` int(10) unsigned NOT NULL COMMENT '用户id',
  `product_id` int(10) unsigned NOT NULL COMMENT '产品id',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1060 DEFAULT CHARSET=utf8 COMMENT='用户浏览记录';