/*
MySQL Data Transfer
Source Host: localhost
Source Database: ivears
Target Host: localhost
Target Database: ivears
Date: 2015-12-08 18:09:29
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for ivears_admin
-- ----------------------------
CREATE TABLE `ivears_admin` (
  `u_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '管理员ID',
  `u_name` varchar(50) NOT NULL COMMENT '管理员用户名',
  `u_passwd` varchar(32) NOT NULL COMMENT '管理员密码',
  `role_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '角色ID',
  `u_ip` varchar(15) NOT NULL COMMENT '管理员登陆IP',
  `u_photo` varchar(100) DEFAULT NULL COMMENT '管理员头像',
  `u_username` varchar(50) DEFAULT NULL COMMENT '姓名',
  `u_sex` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '性别 0：保密 1：男 2：女',
  `u_phone` varchar(11) NOT NULL COMMENT '手机',
  `u_email` varchar(50) NOT NULL COMMENT 'Email',
  `u_qq` varchar(13) DEFAULT NULL COMMENT 'QQ',
  `u_description` text COMMENT '描述',
  `u_countlog` int(11) NOT NULL COMMENT '登陆次数',
  `u_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '启用/停用,1：启用，0：停用',
  `u_lastlogin_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '最后登陆时间',
  `u_create_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `u_update_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '更新时间',
  PRIMARY KEY (`u_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='管理员';

-- ----------------------------
-- Table structure for ivears_admin_log
-- ----------------------------
CREATE TABLE `ivears_admin_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '登陆日志ID',
  `u_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '登陆者ID',
  `u_name` varchar(60) NOT NULL DEFAULT '' COMMENT '登陆管理员',
  `log_create` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '登陆时间',
  `log_ip` varchar(15) NOT NULL COMMENT '登陆IP',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=697 DEFAULT CHARSET=utf8 COMMENT='管理员日志';

-- ----------------------------
-- Table structure for ivears_announce
-- ----------------------------
CREATE TABLE `ivears_announce` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '公告标题',
  `content` text NOT NULL COMMENT '公告内容',
  `starttime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '开始时间',
  `endtime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '结束时间',
  `order` int(5) NOT NULL DEFAULT '1' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否启用：0.否，1.是',
  `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='公告表';

-- ----------------------------
-- Table structure for ivears_article
-- ----------------------------
CREATE TABLE `ivears_article` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL COMMENT '文章标题',
  `image` varchar(200) DEFAULT NULL,
  `content` text NOT NULL COMMENT '文章内容',
  `cid` int(11) NOT NULL COMMENT '文章分类ID',
  `uid` int(11) NOT NULL COMMENT '发布者ID',
  `flag` varchar(20) DEFAULT NULL COMMENT '属性',
  `source` varchar(60) DEFAULT NULL COMMENT '文章来源',
  `author` varchar(50) DEFAULT 'admin' COMMENT '文章作者',
  `colorval` varchar(20) DEFAULT NULL COMMENT '标题颜色',
  `boldval` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否加粗：1.是，0否',
  `keyword` varchar(255) DEFAULT NULL COMMENT '文章关键词（多关键词之间用空格或者“,”隔开）',
  `description` varchar(255) DEFAULT NULL COMMENT '文章描述',
  `hits` int(10) NOT NULL DEFAULT '0' COMMENT '点击数',
  `top` int(2) DEFAULT '0',
  `order` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否审核',
  `seo_title` varchar(200) DEFAULT NULL,
  `seo_keyword` varchar(300) DEFAULT NULL,
  `seo_description` varchar(1000) DEFAULT NULL,
  `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=282 DEFAULT CHARSET=utf8 COMMENT='文章表';

-- ----------------------------
-- Table structure for ivears_category
-- ----------------------------
CREATE TABLE `ivears_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章分类ID',
  `model` varchar(200) DEFAULT NULL,
  `title` varchar(50) NOT NULL COMMENT '分类标题',
  `alias` varchar(32) NOT NULL COMMENT '分类别名',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '父ID',
  `description` text NOT NULL COMMENT '分类描述',
  `seo_keywords` text,
  `seo_title` text,
  `seo_description` text,
  `order` int(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示',
  `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=234 DEFAULT CHARSET=utf8 COMMENT='文章分类';

-- ----------------------------
-- Table structure for ivears_city
-- ----------------------------
CREATE TABLE `ivears_city` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '区域ID',
  `name` varchar(50) NOT NULL COMMENT '区域名称',
  `parent_id` int(11) NOT NULL COMMENT '父ID',
  `is_parent` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否是父类目:0.否，1.是',
  `type` tinyint(1) NOT NULL COMMENT '区域类型，1为国家；2为省/直辖市；3为地级市；4为区/县；',
  `order` tinyint(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否有效:0.否，1.是',
  `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1032710 DEFAULT CHARSET=utf8 COMMENT='区域表';

-- ----------------------------
-- Table structure for ivears_config
-- ----------------------------
CREATE TABLE `ivears_config` (
  `c_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自动增长id',
  `c_module` varchar(100) NOT NULL DEFAULT '' COMMENT '配置模块名称',
  `c_key` varchar(100) NOT NULL DEFAULT '' COMMENT '配置key必须是唯一',
  `c_value` text COMMENT '配置值,多值以逗号分割',
  `c_value_desc` varchar(100) NOT NULL DEFAULT '' COMMENT '配置值描述',
  `c_create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `c_update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '记录最后更新时间',
  PRIMARY KEY (`c_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='系统配置表，配置值使用序列化数组存储';

-- ----------------------------
-- Table structure for ivears_downfile
-- ----------------------------
CREATE TABLE `ivears_downfile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pic` varchar(300) NOT NULL COMMENT '文章缩略图',
  `pics` varchar(1000) NOT NULL COMMENT '文章缩略图',
  `title` varchar(50) NOT NULL COMMENT '文章标题',
  `content` text NOT NULL COMMENT '文章内容',
  `cid` int(11) NOT NULL COMMENT '文章分类ID',
  `uid` int(11) NOT NULL COMMENT '发布者ID',
  `flag` varchar(20) DEFAULT NULL COMMENT '属性',
  `source` varchar(60) DEFAULT NULL COMMENT '文章来源',
  `author` varchar(50) DEFAULT 'admin' COMMENT '文章作者',
  `colorval` varchar(20) DEFAULT NULL COMMENT '标题颜色',
  `boldval` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否加粗：1.是，0否',
  `keyword` varchar(255) DEFAULT NULL COMMENT '文章关键词（多关键词之间用空格或者","隔开）',
  `description` varchar(255) DEFAULT NULL COMMENT '文章描述',
  `hits` int(10) NOT NULL DEFAULT '0' COMMENT '点击数',
  `order` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否审核',
  `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ivears_imagelist
-- ----------------------------
CREATE TABLE `ivears_imagelist` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键，自增',
  `cid` int(11) DEFAULT NULL,
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '链接文字，显示在链接上的文字',
  `image_path` varchar(255) DEFAULT '' COMMENT '链接图片地址',
  `link_url` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址，url',
  `description` text COMMENT '链接描述',
  `color` varchar(50) DEFAULT NULL COMMENT '链接颜色',
  `order` int(11) NOT NULL DEFAULT '0' COMMENT '排序，升序规定前台链接的显示顺序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '链接状态，默认1，正常；0，废弃；2，进入回收站',
  `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '链接添加时间',
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '链接最后修改时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ivears_links
-- ----------------------------
CREATE TABLE `ivears_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键，自增',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '友情链接文字，显示在友情链接上的文字',
  `image_path` varchar(255) DEFAULT '' COMMENT '友情链接图片地址',
  `link_url` varchar(255) NOT NULL DEFAULT '' COMMENT '友情链接地址，url',
  `description` text COMMENT '链接描述',
  `color` varchar(50) DEFAULT NULL COMMENT '链接颜色',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '链接类型:0.文字类型,1.图片类型',
  `order` int(11) NOT NULL DEFAULT '0' COMMENT '排序，升序规定前台友情链接的显示顺序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '友情链接状态，默认1，正常；0，废弃；2，进入回收站',
  `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '友情链接添加时间',
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '友情链接最后修改时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8 COMMENT='友情链接表';

-- ----------------------------
-- Table structure for ivears_member_level
-- ----------------------------
CREATE TABLE `ivears_member_level` (
  `ml_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '等级ID',
  `ml_name` varchar(50) NOT NULL COMMENT '等级名称',
  `ml_description` text NOT NULL COMMENT '等级描述',
  `ml_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示：0.否，1.是',
  `ml_order` tinyint(5) unsigned NOT NULL DEFAULT '0' COMMENT '等级排序',
  `ml_img` varchar(200) DEFAULT NULL,
  `ml_create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `ml_update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '更新时间',
  PRIMARY KEY (`ml_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='会员等级表';

-- ----------------------------
-- Table structure for ivears_members
-- ----------------------------
CREATE TABLE `ivears_members` (
  `m_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) DEFAULT NULL,
  `m_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `m_nickname` varchar(50) DEFAULT '' COMMENT '用户昵称',
  `m_enname` varchar(50) NOT NULL COMMENT '英文名',
  `m_child_name` varchar(100) DEFAULT NULL,
  `m_parent_tel` varchar(100) DEFAULT NULL,
  `m_parent_name` varchar(100) DEFAULT NULL,
  `m_passwd` varchar(32) NOT NULL COMMENT '密码',
  `ml_id` int(11) DEFAULT NULL COMMENT '会员等级ID',
  `c_id` int(11) DEFAULT NULL COMMENT '城市最后一级ID',
  `m_balance` decimal(8,2) DEFAULT '0.00' COMMENT '账户余额',
  `m_sex` tinyint(1) DEFAULT '0' COMMENT '性别：0.保密，1.男，2.女',
  `m_pic` varchar(200) DEFAULT NULL COMMENT '会员头像',
  `m_birthtype` tinyint(1) unsigned DEFAULT '0' COMMENT '生日类型:0.公历生日，1.农历生日',
  `m_birth_time` date DEFAULT '0000-00-00' COMMENT '生日',
  `m_email` varchar(60) DEFAULT NULL COMMENT '邮箱',
  `m_intro` text COMMENT '个人说明',
  `m_login_ip` varchar(60) DEFAULT NULL COMMENT '登陆IP',
  `m_login_time` timestamp NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP COMMENT '登陆时间',
  `m_weibo_uid` varchar(20) DEFAULT NULL COMMENT '对应的新浪微博uid',
  `m_tencent_uid` varchar(20) DEFAULT NULL COMMENT '腾讯微博UID',
  `m_verify_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '电子邮件验证标示 0未验证，1已验证',
  `m_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否审核，0未审核，1已审核',
  `m_reg_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '注册时间',
  `m_reg_ip` varchar(15) NOT NULL COMMENT '注册IP',
  `m_qq` int(15) DEFAULT NULL COMMENT '用户QQ',
  `m_enteruser` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '认证用户:0.未认证，1.已认证',
  `m_update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '更新时间',
  PRIMARY KEY (`m_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='会员表';

-- ----------------------------
-- Table structure for ivears_message
-- ----------------------------
CREATE TABLE `ivears_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '留言id',
  `title` varchar(50) NOT NULL COMMENT '留言标题',
  `company` varchar(200) DEFAULT NULL,
  `content` text NOT NULL COMMENT '留言内容',
  `provinces` varchar(100) DEFAULT NULL,
  `painter` varchar(100) DEFAULT NULL,
  `times` varchar(100) DEFAULT NULL,
  `size` varchar(100) DEFAULT NULL,
  `class` varchar(100) DEFAULT NULL,
  `tel` varchar(200) DEFAULT NULL,
  `m_id` int(11) NOT NULL DEFAULT '0' COMMENT '留言者',
  `address` varchar(100) DEFAULT NULL,
  `nickname` varchar(50) NOT NULL COMMENT '留言姓名',
  `email` varchar(50) NOT NULL COMMENT '留言EMAIL',
  `siteurl` varchar(100) DEFAULT NULL,
  `qq` varchar(14) DEFAULT NULL COMMENT '留言QQ',
  `visible` tinyint(1) NOT NULL COMMENT '是否管理员只能可看:0.否,1.是',
  `ip` varchar(15) NOT NULL COMMENT '留言者IP',
  `audit` tinyint(1) NOT NULL DEFAULT '0' COMMENT '审核:0.未审核,1,已审核',
  `u_id` int(11) DEFAULT NULL COMMENT '留言者id',
  `replyid` int(11) DEFAULT NULL COMMENT '回复id',
  `other` varchar(100) DEFAULT NULL,
  `addtime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '留言时间',
  `updatetime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '留言更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COMMENT='留言表';

-- ----------------------------
-- Table structure for ivears_message_tpl
-- ----------------------------
CREATE TABLE `ivears_message_tpl` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `type` varchar(20) NOT NULL COMMENT '通知模版类型：0.邮件模版，1.短消息模版',
  `name` varchar(50) NOT NULL COMMENT '名称',
  `alias` varchar(50) NOT NULL COMMENT '别名',
  `content` text COMMENT '内容',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态：0.停用，1启用',
  `is_sys` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否系统内置：0否，1是',
  `create_time` timestamp NULL DEFAULT '0000-00-00 00:00:00' COMMENT '添加时间',
  `update_time` timestamp NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ivears_nav
-- ----------------------------
CREATE TABLE `ivears_nav` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '菜单ID',
  `name` varchar(50) NOT NULL COMMENT '菜单名称',
  `alias_name` varchar(50) NOT NULL COMMENT '导航别名',
  `url` text COMMENT '菜单URL',
  `order` int(11) NOT NULL DEFAULT '10' COMMENT '排序',
  `type` varchar(25) NOT NULL DEFAULT 'main' COMMENT '导航类型:main.主导航,bottom.底部导航',
  `target` varchar(15) NOT NULL DEFAULT '_blank' COMMENT '打开方式',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示',
  `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='前台菜单';

-- ----------------------------
-- Table structure for ivears_oauth
-- ----------------------------
CREATE TABLE `ivears_oauth` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '第三方登陆ID',
  `code` varchar(50) NOT NULL COMMENT '代码(唯一标识)',
  `name` varchar(50) NOT NULL COMMENT '名称',
  `config` text NOT NULL COMMENT '以json格式存储配置信息',
  `description` text NOT NULL COMMENT '描述',
  `order` int(11) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `author` varchar(50) NOT NULL COMMENT '作者',
  `version` varchar(50) NOT NULL COMMENT '版本',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='第三方登陆表';

-- ----------------------------
-- Table structure for ivears_orders
-- ----------------------------
CREATE TABLE `ivears_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(100) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `tel` varchar(255) DEFAULT NULL,
  `address` varchar(500) DEFAULT NULL,
  `proid` int(11) DEFAULT NULL,
  `proname` varchar(200) DEFAULT NULL,
  `price` double(10,2) DEFAULT NULL,
  `status` enum('true','false') DEFAULT 'false',
  `remark` varchar(1000) DEFAULT NULL,
  `ip` varchar(100) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ivears_page
-- ----------------------------
CREATE TABLE `ivears_page` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章分类ID',
  `title` varchar(100) NOT NULL COMMENT '标题',
  `keyword` varchar(100) NOT NULL COMMENT '关键词',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '父ID',
  `content` text NOT NULL COMMENT '描述',
  `order` int(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示',
  `seo_title` varchar(200) DEFAULT NULL,
  `seo_keyword` varchar(300) DEFAULT NULL,
  `seo_description` varchar(1000) DEFAULT NULL,
  `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=100 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ivears_payment
-- ----------------------------
CREATE TABLE `ivears_payment` (
  `pay_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) NOT NULL COMMENT '支付方式名称',
  `pay_name` varchar(120) NOT NULL COMMENT '支付方式',
  `pay_code` varchar(20) NOT NULL COMMENT '支付代码',
  `pay_desc` text NOT NULL COMMENT '支付描述',
  `pay_fee` varchar(10) NOT NULL DEFAULT '0' COMMENT '手续费用',
  `pay_config` text NOT NULL COMMENT '配置信息以json格式存入',
  `pay_is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '支付手续费类型',
  `pay_is_online` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否在线支付',
  `pay_order` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '支付排序',
  `pay_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '支付是否启用',
  `pay_author` varchar(100) NOT NULL COMMENT '作者',
  `pay_website` varchar(100) NOT NULL COMMENT '支付网址',
  `pay_version` varchar(20) NOT NULL COMMENT '版本号',
  PRIMARY KEY (`pay_id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='支付方式';

-- ----------------------------
-- Table structure for ivears_product
-- ----------------------------
CREATE TABLE `ivears_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pic` varchar(300) NOT NULL COMMENT '文章缩略图',
  `pics` varchar(1000) NOT NULL COMMENT '文章缩略图',
  `url` varchar(200) DEFAULT NULL,
  `title` varchar(50) NOT NULL COMMENT '文章标题',
  `content` text NOT NULL COMMENT '文章内容',
  `cid` int(11) NOT NULL COMMENT '文章分类ID',
  `uid` int(11) NOT NULL COMMENT '发布者ID',
  `flag` varchar(20) DEFAULT NULL COMMENT '属性',
  `source` varchar(60) DEFAULT NULL COMMENT '文章来源',
  `author` varchar(50) DEFAULT 'admin' COMMENT '文章作者',
  `colorval` varchar(20) DEFAULT NULL COMMENT '标题颜色',
  `boldval` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否加粗：1.是，0否',
  `keyword` varchar(255) DEFAULT NULL COMMENT '文章关键词（多关键词之间用空格或者","隔开）',
  `description` varchar(255) DEFAULT NULL COMMENT '文章描述',
  `hits` int(10) NOT NULL DEFAULT '0' COMMENT '点击数',
  `create_year` varchar(100) DEFAULT NULL,
  `order` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `price` double(11,2) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否审核',
  `pkj` varchar(200) DEFAULT NULL,
  `pfg` varchar(200) DEFAULT NULL,
  `pcate` varchar(200) DEFAULT NULL,
  `top` int(2) DEFAULT '0',
  `seo_title` varchar(200) DEFAULT NULL,
  `seo_keyword` varchar(300) DEFAULT NULL,
  `seo_description` varchar(1000) DEFAULT NULL,
  `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=76 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ivears_role
-- ----------------------------
CREATE TABLE `ivears_role` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户组ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户组名称',
  `status` smallint(2) NOT NULL DEFAULT '1' COMMENT '该用户组是否显示：0为不显示，1为显示',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='角色表';

-- ----------------------------
-- Table structure for ivears_role_access
-- ----------------------------
CREATE TABLE `ivears_role_access` (
  `role_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '节点id',
  `node_id` smallint(6) unsigned NOT NULL COMMENT '角色id'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='角色节点关系表';

-- ----------------------------
-- Table structure for ivears_role_nav
-- ----------------------------
CREATE TABLE `ivears_role_nav` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '菜单id',
  `name` varchar(50) NOT NULL COMMENT '菜单名称',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '菜单启用及停用：1.启用，0.停用',
  `sort` int(11) NOT NULL DEFAULT '10' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='菜单表';

-- ----------------------------
-- Table structure for ivears_role_node
-- ----------------------------
CREATE TABLE `ivears_role_node` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `action` varchar(60) NOT NULL DEFAULT '' COMMENT '节点控制器',
  `action_name` varchar(60) NOT NULL DEFAULT '' COMMENT '节点控制器名称',
  `module` varchar(60) NOT NULL DEFAULT '' COMMENT '节点模型',
  `module_name` varchar(60) NOT NULL DEFAULT '' COMMENT '节点模型名称',
  `nav_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '所属菜单ID',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '节点是否可用:0为禁用,1为启用',
  `sort` smallint(6) NOT NULL DEFAULT '0' COMMENT '节点排序',
  `auth_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '授权模式：1:模块授权(module) 2:操作授权(action) 0:节点授权(node)',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否菜单显示:0.不显示,1.显示',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=141 DEFAULT CHARSET=utf8 COMMENT='节点表';

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `ivears_admin` VALUES ('2', 'admin', '21232f297a57a5a743894a0e4a801fc3', '1', '127.0.0.1', 'upload/images/20140413/13974057649163.jpg', 'billow.wang', '1', '13880713476', '905873908@qq.com', '905873908', '', '427', '1', '2015-12-08 17:53:47', '2013-12-10 00:00:00', '2015-11-29 15:36:23');
INSERT INTO `ivears_admin_log` VALUES ('689', '2', 'admin', '2015-11-29 15:36:33', '127.0.0.1');
INSERT INTO `ivears_admin_log` VALUES ('690', '2', 'admin', '2015-12-03 22:10:30', '127.0.0.1');
INSERT INTO `ivears_admin_log` VALUES ('691', '2', 'admin', '2015-12-04 15:44:49', '127.0.0.1');
INSERT INTO `ivears_admin_log` VALUES ('692', '2', 'admin', '2015-12-05 21:08:21', '127.0.0.1');
INSERT INTO `ivears_admin_log` VALUES ('693', '2', 'admin', '2015-12-07 08:42:15', '127.0.0.1');
INSERT INTO `ivears_admin_log` VALUES ('694', '2', 'admin', '2015-12-07 08:44:17', '127.0.0.1');
INSERT INTO `ivears_admin_log` VALUES ('695', '2', 'admin', '2015-12-07 18:13:53', '127.0.0.1');
INSERT INTO `ivears_admin_log` VALUES ('696', '2', 'admin', '2015-12-08 17:53:47', '127.0.0.1');
INSERT INTO `ivears_article` VALUES ('275', '企业网站建设专家，IVEARS成都艾威尔网络', '/Upload/image/20151208/20151208175516_16100.jpg', '企业网站建设专家，IVEARS成都艾威尔网络', '226', '2', null, 'admin', 'admin', null, '0', '企业网站建设专家，IVEARS成都艾威尔网络', '企业网站建设专家，IVEARS成都艾威尔网络', '0', '0', '0', '1', '', '', '', '2015-11-26 19:17:25', '2015-12-08 17:55:17');
INSERT INTO `ivears_article` VALUES ('276', '招聘php程序员10名', '', '招聘php程序员10名', '231', '2', null, 'admin', 'admin', null, '0', null, '招聘php程序员10名', '0', '0', '0', '1', '', '', '', '2015-11-26 19:59:06', '0000-00-00 00:00:00');
INSERT INTO `ivears_article` VALUES ('277', '公司网站改版上线', '', '公司网站改版上线', '232', '2', null, 'admin', 'admin', null, '0', null, '公司网站改版上线', '0', '0', '0', '1', '', '', '', '2015-12-05 21:14:58', '0000-00-00 00:00:00');
INSERT INTO `ivears_article` VALUES ('278', '多地出台意见鼓励2.5天休假 每周仍需工作40小时', '/Upload/image/20151208/20151208175542_22777.jpg', '多地出台意见鼓励2.5天休假 每周仍需工作40小时', '226', '2', null, 'admin', 'admin', null, '0', null, '多地出台意见鼓励2.5天休假 每周仍需工作40小时', '0', '0', '0', '1', '', '', '', '2015-12-08 17:55:47', '0000-00-00 00:00:00');
INSERT INTO `ivears_article` VALUES ('279', '北上广高房价致人口外溢 燕郊本地人称已买不起房', '/Upload/image/20151208/20151208175612_73671.jpg', '北上广高房价致人口外溢 燕郊本地人称已买不起房', '226', '2', null, 'admin', 'admin', null, '0', null, '北上广高房价致人口外溢 燕郊本地人称已买不起房', '0', '0', '0', '1', '', '', '', '2015-12-08 17:56:17', '0000-00-00 00:00:00');
INSERT INTO `ivears_article` VALUES ('280', '传统银行减免网银转账手续费 反击第三方支付', '', '传统银行减免网银转账手续费 反击第三方支付', '227', '2', null, 'admin', 'admin', null, '0', null, '传统银行减免网银转账手续费 反击第三方支付', '0', '0', '0', '1', '', '', '', '2015-12-08 17:58:48', '0000-00-00 00:00:00');
INSERT INTO `ivears_article` VALUES ('281', '银行与互联网金融联姻已成必然？', '', '银行与互联网金融联姻已成必然？', '227', '2', null, 'admin', 'admin', null, '0', null, '银行与互联网金融联姻已成必然？', '0', '0', '0', '1', '', '', '', '2015-12-08 17:59:25', '0000-00-00 00:00:00');
INSERT INTO `ivears_category` VALUES ('229', 'Product', '产品分类二', '', '0', '', null, null, null, '0', '1', '2015-11-26 19:50:51', '0000-00-00 00:00:00');
INSERT INTO `ivears_category` VALUES ('230', 'Product', '产品分类三', '', '0', '', null, null, null, '0', '1', '2015-11-26 19:50:56', '0000-00-00 00:00:00');
INSERT INTO `ivears_category` VALUES ('231', 'Article', '人才招聘', '人才招聘', '0', '', null, null, null, '0', '1', '2015-11-26 19:58:26', '0000-00-00 00:00:00');
INSERT INTO `ivears_category` VALUES ('228', 'Product', '产品分类一', '', '0', '', null, null, null, '0', '1', '2015-11-26 19:50:46', '0000-00-00 00:00:00');
INSERT INTO `ivears_category` VALUES ('227', 'Article', '行业新闻', '行业新闻', '233', '', null, null, null, '1', '1', '2015-11-26 17:57:33', '0000-00-00 00:00:00');
INSERT INTO `ivears_category` VALUES ('226', 'Article', '公司新闻', '公司新闻', '233', '', null, null, null, '1', '1', '2015-11-26 17:57:24', '0000-00-00 00:00:00');
INSERT INTO `ivears_category` VALUES ('232', 'Article', '公司公告', '公司公告', '0', '', null, null, null, '0', '1', '2015-12-05 21:12:10', '0000-00-00 00:00:00');
INSERT INTO `ivears_category` VALUES ('233', 'Article', '新闻动态', '新闻动态', '0', '', null, null, null, '1', '1', '2015-12-05 21:12:23', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1', '中国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('2', '阿富汗', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('3', '奥兰群岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('4', '阿拉斯加', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('5', '阿尔巴尼亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('6', '阿尔及利亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('7', '东萨摩亚(美)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('8', '安道尔', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('9', '安哥拉', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('10', '安圭拉岛(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('11', '南极', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('12', '安提瓜和巴布达', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('13', '阿根廷', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('14', '亚美尼亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('15', '阿鲁巴岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('16', '澳大利亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('17', '奥地利', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('18', '阿塞拜疆', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('19', '巴林', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('20', '根西岛(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('21', '孟加拉国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('22', '巴巴多斯', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('23', '白俄罗斯', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('24', '比利时', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('25', '伯利兹', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('26', '贝宁', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('27', '百慕大群岛(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('28', '不丹', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('29', '玻利维亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('30', '波斯尼亚和黑塞哥维那', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('31', '博茨瓦纳', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('32', '巴西', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('33', '保加利亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('34', '布基纳法索', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('35', '布隆迪', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('36', '喀麦隆', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('37', '加拿大', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('38', '加那利群岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('39', '佛得角', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('40', '开曼群岛(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('41', '中非', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('42', '乍得', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('43', '智利', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('44', '圣诞岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('45', '科科斯岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('46', '哥伦比亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('47', '科摩罗', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('48', '刚果', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('49', '科克群岛(新)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('50', '哥斯达黎加', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('51', '克罗地亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('52', '古巴', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('53', '塞浦路斯', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('54', '捷克', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('55', '刚果(金)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('56', '丹麦', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('57', '迪戈加西亚岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('58', '吉布提', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('59', '多米尼克国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('60', '多米尼加共和国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('61', '厄瓜多尔', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('62', '埃及', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('63', '萨尔瓦多', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('64', '赤道几内亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('65', '厄立特里亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('66', '爱沙尼亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('67', '埃塞俄比亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('68', '福克兰群岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('69', '法罗群岛(丹)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('70', '斐济', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('71', '芬兰', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('72', '法国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('73', '法属波里尼西亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('74', '加蓬', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('75', '冈比亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('76', '格鲁吉亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('77', '德国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('78', '加纳', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('79', '直布罗陀(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('80', '希腊', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('81', '格陵兰岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('82', '格林纳达', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('83', '瓜德罗普岛(法)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('84', '关岛(美)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('85', '危地马拉', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('86', '几内亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('87', '几内亚比绍', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('88', '法属圭亚那', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('89', '圭亚那', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('90', '海地', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('91', '洪都拉斯', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('92', '匈牙利', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('93', '冰岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('94', '印度', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('95', '印度尼西亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('96', '伊郎', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('97', '伊拉克', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('98', '爱尔兰', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('99', '马恩岛(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('100', '以色列', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('101', '意大利', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('102', '科特迪瓦', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('103', '牙买加', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('104', '日本', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('105', '泽西岛(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('106', '约旦', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('107', '柬埔塞', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('108', '哈萨克斯坦', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('109', '肯尼亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110', '基里巴斯', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('111', '科威特', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('112', '吉尔吉斯斯坦', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('113', '老挝', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('114', '拉脱维亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('115', '黎巴嫩', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('116', '莱索托', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('117', '利比里亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('118', '利比亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('119', '列支敦士登', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120', '立陶宛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('121', '卢森堡', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('122', '马其顿', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('123', '马达加斯加', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('124', '马拉维', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('125', '马来西亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('126', '马尔代夫', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('127', '马里', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('128', '马耳他', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('129', '马绍尔群岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130', '马提尼克(法)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131', '毛里塔尼亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('132', '毛里求斯', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('133', '马约特岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('134', '墨西哥', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('135', '密克罗尼西亚(美)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('136', '中途岛(美)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('137', '摩纳哥', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('138', '蒙古', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('139', '黑山', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140', '蒙特塞拉特岛(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141', '摩洛哥', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('142', '莫桑比克', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('143', '缅甸', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('144', '纳米比亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('145', '瑙鲁', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('146', '尼泊尔', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('147', '荷兰', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('148', '荷属安的列斯群岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('149', '新喀里多尼亚群岛(法)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150', '新西兰', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('151', '尼加拉瓜', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152', '尼日尔', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('153', '尼日利亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('154', '纽埃岛(新)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('155', '诺福克岛(澳)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('156', '朝鲜', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('157', '马里亚纳群岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('158', '挪威', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('159', '阿曼', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('160', '巴基斯坦', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('161', '帕劳(美)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('162', '巴拿马', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('163', '巴布亚新几内亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('164', '巴拉圭', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('165', '秘鲁', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('166', '菲律宾', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('167', '波兰', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('168', '葡萄牙', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('169', '波多黎各(美)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('170', '卡塔尔', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('171', '摩尔多瓦', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('172', '留尼汪岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('173', '罗马尼亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('174', '俄罗斯', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('175', '卢旺达', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('176', '阿森松(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('177', '圣赫勒拿', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('178', '圣克里斯托弗和尼维斯', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('179', '圣卢西亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('180', '圣皮埃尔岛及密克隆岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('181', '圣文森特岛(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('182', '西萨摩亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('183', '圣马力诺', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('184', '圣多美和普林西比', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('185', '沙特阿拉伯', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('186', '塞内加尔', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('187', '塞尔维亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('188', '塞舌尔', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('189', '塞拉利昂', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('190', '新加坡', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('191', '圣马丁(荷)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('192', '斯洛伐克', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('193', '斯洛文尼亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('194', '所罗门群岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('195', '索马里', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('196', '南非', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('197', '南乔治亚与南桑威奇群岛', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('198', '韩国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('199', '西班牙', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('200', '斯里兰卡', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('201', '苏丹', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('202', '苏里南', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('203', '斯瓦尔巴群岛(挪)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('204', '斯威士兰', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('205', '瑞典', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('206', '瑞士', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('207', '叙利亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('208', '塔吉克斯坦', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('209', '泰国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210', '巴哈马国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211', '梵蒂冈', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('212', '东帝汶', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('213', '多哥', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('214', '托克劳群岛(新)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('215', '汤加', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('216', '特立尼达和多巴哥', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('217', '突尼斯', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('218', '土耳其', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('219', '土库曼斯坦', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220', '特克斯和凯科斯群岛(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('221', '图瓦卢', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('222', '乌干达', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('223', '乌克兰', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('224', '阿拉伯联合酋长国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('225', '英国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('226', '坦桑尼亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('227', '美国本土外小岛屿', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('228', '美国', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('229', '乌拉圭', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230', '乌兹别克斯坦', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231', '瓦努阿图', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('232', '委内瑞拉', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('233', '越南', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('234', '维尔京群岛(英)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('235', '维尔京群岛(美)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('236', '瓦里斯和富士那群岛(法)', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('237', '西撒哈拉', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('238', '也门', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('239', '南斯拉夫', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('240', '赞比亚', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('241', '桑给巴尔', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('242', '津巴布韦', '0', '0', '1', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1000', '槟榔屿', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1001', '北海', '1000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1002', '槟城', '1000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1003', '玻璃市', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1004', '大山脚', '1000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1005', '高渊', '1000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1006', '加央', '1003', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1007', '丁加奴', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1008', '甘马挽', '1007', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1009', '瓜拉丁加奴', '1007', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1010', '龙运', '1007', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1011', '马江', '1007', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1012', '实兆', '1007', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1013', '乌鲁', '1007', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1014', '勿述', '1007', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1015', '吉打', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1016', '巴东得腊', '1015', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1017', '笨筒', '1015', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1018', '浮罗交怡', '1015', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1019', '哥打士打', '1015', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1020', '古邦巴素', '1015', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1021', '瓜拉姆达', '1015', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1022', '华玲', '1015', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1023', '居林', '1015', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1024', '万拉峇鲁', '1015', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1025', '吉兰丹', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1026', '巴西富地', '1025', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1027', '巴西马', '1025', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1028', '丹那美拉', '1025', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1029', '道北', '1025', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1030', '登卓', '1025', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1031', '哥打巴鲁', '1025', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1032', '瓜拉吉赖', '1025', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1033', '话望生', '1025', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1034', '马樟', '1025', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1035', '日里', '1025', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1036', '吉隆坡', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1037', '吉隆坡', '1036', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1038', '马六甲', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1039', '马六甲市', '1038', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1040', '亚罗牙也', '1038', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1041', '野新', '1038', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1042', '纳闽', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1043', '纳闽', '1042', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1044', '维多利亚', '1042', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1045', '彭亨', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1046', '百乐', '1045', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1047', '北根', '1045', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1048', '淡马鲁', '1045', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1049', '而连突', '1045', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1050', '关丹', '1045', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1051', '金马仑高原', '1045', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1052', '劳勿', '1045', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1053', '立卑', '1045', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1054', '马兰', '1045', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1055', '文冬', '1045', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1056', '云冰', '1045', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1057', '霹雳', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1058', '安顺', '1057', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1059', '丹绒马林', '1057', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1060', '和丰', '1057', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1061', '紅土坎', '1057', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1062', '华都牙也', '1057', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1063', '江沙', '1057', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1064', '太平', '1057', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1065', '怡保', '1057', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1066', '柔佛', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1067', '笨珍', '1066', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1068', '丰盛港', '1066', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1069', '哥打丁宜', '1066', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1070', '居銮', '1066', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1071', '峇株巴辖', '1066', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1072', '麻坡', '1066', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1073', '昔加末', '1066', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1074', '新山', '1066', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1075', '森美兰', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1076', '波德申', '1075', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1077', '淡边', '1075', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1078', '芙蓉', '1075', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1079', '瓜拉庇劳', '1075', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1080', '林茂', '1075', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1081', '仁保', '1075', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1082', '日叻务', '1075', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1083', '沙巴', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1084', '吧巴', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1085', '保佛', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1086', '比鲁兰', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1087', '必达士', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1088', '兵南邦', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1089', '担布南', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1090', '丹南', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1091', '斗湖', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1092', '斗亚兰', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1093', '哥打基纳巴鲁', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1094', '哥打马鲁都', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1095', '根地咬', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1096', '古达', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1097', '古打毛律', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1098', '古纳', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1099', '瓜拉班尤', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1100', '京那巴登岸', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1101', '兰脑', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1102', '拿笃', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1103', '纳巴湾', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1104', '山打根', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1105', '西比陶', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1106', '仙本那', '1083', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1107', '沙捞越', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1108', '古晋', '1107', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1109', '加帛', '1107', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1110', '林梦', '1107', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1111', '美里', '1107', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1112', '民都鲁', '1107', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1113', '木胶', '1107', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1114', '木中', '1107', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1115', '三马拉汉', '1107', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1116', '斯里阿曼', '1107', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1117', '泗里街', '1107', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1118', '泗务', '1107', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1119', '雪兰莪', '125', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1120', '八打灵', '1119', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1121', '鹅麦', '1119', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1122', '瓜拉冷岳', '1119', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1123', '瓜拉雪兰莪', '1119', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1124', '沙白安南', '1119', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1125', '乌鲁冷岳', '1119', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1126', '乌鲁雪兰莪', '1119', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1127', '雪邦', '1119', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110000', '北京', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110100', '北京市', '110000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110101', '东城区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110102', '西城区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110103', '崇文区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110104', '宣武区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110105', '朝阳区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110106', '丰台区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110107', '石景山区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110108', '海淀区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110109', '门头沟区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110111', '房山区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110112', '通州区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110113', '顺义区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110114', '昌平区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110115', '大兴区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110116', '怀柔区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110117', '平谷区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110228', '密云县', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110229', '延庆县', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('110230', '其它区', '110100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120000', '天津', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120100', '天津市', '120000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120101', '和平区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120102', '河东区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120103', '河西区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120104', '南开区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120105', '河北区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120106', '红桥区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120107', '塘沽区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120108', '汉沽区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120109', '大港区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120110', '东丽区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120111', '西青区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120112', '津南区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120113', '北辰区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120114', '武清区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120115', '宝坻区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120116', '滨海新区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120221', '宁河县', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120223', '静海县', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120225', '蓟县', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('120226', '其它区', '120100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130000', '河北省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130100', '石家庄市', '130000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130102', '长安区', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130103', '桥东区', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130104', '桥西区', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130105', '新华区', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130107', '井陉矿区', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130108', '裕华区', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130121', '井陉县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130123', '正定县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130124', '栾城县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130125', '行唐县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130126', '灵寿县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130127', '高邑县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130128', '深泽县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130129', '赞皇县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130130', '无极县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130131', '平山县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130132', '元氏县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130133', '赵县', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130181', '辛集市', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130182', '藁城市', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130183', '晋州市', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130184', '新乐市', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130185', '鹿泉市', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130186', '其它区', '130100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130200', '唐山市', '130000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130202', '路南区', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130203', '路北区', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130204', '古冶区', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130205', '开平区', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130207', '丰南区', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130208', '丰润区', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130223', '滦县', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130224', '滦南县', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130225', '乐亭县', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130227', '迁西县', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130229', '玉田县', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130230', '唐海县', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130281', '遵化市', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130283', '迁安市', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130284', '其它区', '130200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130300', '秦皇岛市', '130000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130302', '海港区', '130300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130303', '山海关区', '130300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130304', '北戴河区', '130300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130321', '青龙满族自治县', '130300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130322', '昌黎县', '130300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130323', '抚宁县', '130300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130324', '卢龙县', '130300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130398', '其它区', '130300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130399', '经济技术开发区', '130300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130400', '邯郸市', '130000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130402', '邯山区', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130403', '丛台区', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130404', '复兴区', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130406', '峰峰矿区', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130421', '邯郸县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130423', '临漳县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130424', '成安县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130425', '大名县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130426', '涉县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130427', '磁县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130428', '肥乡县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130429', '永年县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130430', '邱县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130431', '鸡泽县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130432', '广平县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130433', '馆陶县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130434', '魏县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130435', '曲周县', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130481', '武安市', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130482', '其它区', '130400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130500', '邢台市', '130000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130502', '桥东区', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130503', '桥西区', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130521', '邢台县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130522', '临城县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130523', '内丘县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130524', '柏乡县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130525', '隆尧县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130526', '任县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130527', '南和县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130528', '宁晋县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130529', '巨鹿县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130530', '新河县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130531', '广宗县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130532', '平乡县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130533', '威县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130534', '清河县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130535', '临西县', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130581', '南宫市', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130582', '沙河市', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130583', '其它区', '130500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130600', '保定市', '130000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130602', '新市区', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130603', '北市区', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130604', '南市区', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130621', '满城县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130622', '清苑县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130623', '涞水县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130624', '阜平县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130625', '徐水县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130626', '定兴县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130627', '唐县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130628', '高阳县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130629', '容城县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130630', '涞源县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130631', '望都县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130632', '安新县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130633', '易县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130634', '曲阳县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130635', '蠡县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130636', '顺平县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130637', '博野县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130638', '雄县', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130681', '涿州市', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130682', '定州市', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130683', '安国市', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130684', '高碑店市', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130698', '高开区', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130699', '其它区', '130600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130700', '张家口市', '130000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130702', '桥东区', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130703', '桥西区', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130705', '宣化区', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130706', '下花园区', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130721', '宣化县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130722', '张北县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130723', '康保县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130724', '沽源县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130725', '尚义县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130726', '蔚县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130727', '阳原县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130728', '怀安县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130729', '万全县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130730', '怀来县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130731', '涿鹿县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130732', '赤城县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130733', '崇礼县', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130734', '其它区', '130700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130800', '承德市', '130000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130802', '双桥区', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130803', '双滦区', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130804', '鹰手营子矿区', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130821', '承德县', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130822', '兴隆县', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130823', '平泉县', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130824', '滦平县', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130825', '隆化县', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130826', '丰宁满族自治县', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130827', '宽城满族自治县', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130828', '围场满族蒙古族自治县', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130829', '其它区', '130800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130900', '沧州市', '130000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130902', '新华区', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130903', '运河区', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130921', '沧县', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130922', '青县', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130923', '东光县', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130924', '海兴县', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130925', '盐山县', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130926', '肃宁县', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130927', '南皮县', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130928', '吴桥县', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130929', '献县', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130930', '孟村回族自治县', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130981', '泊头市', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130982', '任丘市', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130983', '黄骅市', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130984', '河间市', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('130985', '其它区', '130900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131000', '廊坊市', '130000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131002', '安次区', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131003', '广阳区', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131022', '固安县', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131023', '永清县', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131024', '香河县', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131025', '大城县', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131026', '文安县', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131028', '大厂回族自治县', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131051', '开发区', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131052', '燕郊经济技术开发区', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131081', '霸州市', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131082', '三河市', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131083', '其它区', '131000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131100', '衡水市', '130000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131102', '桃城区', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131121', '枣强县', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131122', '武邑县', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131123', '武强县', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131124', '饶阳县', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131125', '安平县', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131126', '故城县', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131127', '景县', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131128', '阜城县', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131181', '冀州市', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131182', '深州市', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('131183', '其它区', '131100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140000', '山西省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140100', '太原市', '140000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140105', '小店区', '140100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140106', '迎泽区', '140100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140107', '杏花岭区', '140100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140108', '尖草坪区', '140100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140109', '万柏林区', '140100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140110', '晋源区', '140100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140121', '清徐县', '140100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140122', '阳曲县', '140100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140123', '娄烦县', '140100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140181', '古交市', '140100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140182', '其它区', '140100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140200', '大同市', '140000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140202', '城区', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140203', '矿区', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140211', '南郊区', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140212', '新荣区', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140221', '阳高县', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140222', '天镇县', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140223', '广灵县', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140224', '灵丘县', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140225', '浑源县', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140226', '左云县', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140227', '大同县', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140228', '其它区', '140200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140300', '阳泉市', '140000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140302', '城区', '140300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140303', '矿区', '140300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140311', '郊区', '140300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140321', '平定县', '140300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140322', '盂县', '140300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140323', '其它区', '140300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140400', '长治市', '140000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140421', '长治县', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140423', '襄垣县', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140424', '屯留县', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140425', '平顺县', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140426', '黎城县', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140427', '壶关县', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140428', '长子县', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140429', '武乡县', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140430', '沁县', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140431', '沁源县', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140481', '潞城市', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140482', '城区', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140483', '郊区', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140484', '高新区', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140485', '其它区', '140400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140500', '晋城市', '140000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140502', '城区', '140500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140521', '沁水县', '140500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140522', '阳城县', '140500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140524', '陵川县', '140500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140525', '泽州县', '140500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140581', '高平市', '140500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140582', '其它区', '140500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140600', '朔州市', '140000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140602', '朔城区', '140600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140603', '平鲁区', '140600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140621', '山阴县', '140600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140622', '应县', '140600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140623', '右玉县', '140600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140624', '怀仁县', '140600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140625', '其它区', '140600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140700', '晋中市', '140000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140702', '榆次区', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140721', '榆社县', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140722', '左权县', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140723', '和顺县', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140724', '昔阳县', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140725', '寿阳县', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140726', '太谷县', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140727', '祁县', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140728', '平遥县', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140729', '灵石县', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140781', '介休市', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140782', '其它区', '140700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140800', '运城市', '140000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140802', '盐湖区', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140821', '临猗县', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140822', '万荣县', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140823', '闻喜县', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140824', '稷山县', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140825', '新绛县', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140826', '绛县', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140827', '垣曲县', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140828', '夏县', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140829', '平陆县', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140830', '芮城县', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140881', '永济市', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140882', '河津市', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140883', '其它区', '140800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140900', '忻州市', '140000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140902', '忻府区', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140921', '定襄县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140922', '五台县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140923', '代县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140924', '繁峙县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140925', '宁武县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140926', '静乐县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140927', '神池县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140928', '五寨县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140929', '岢岚县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140930', '河曲县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140931', '保德县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140932', '偏关县', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140981', '原平市', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('140982', '其它区', '140900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141000', '临汾市', '140000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141002', '尧都区', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141021', '曲沃县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141022', '翼城县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141023', '襄汾县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141024', '洪洞县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141025', '古县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141026', '安泽县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141027', '浮山县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141028', '吉县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141029', '乡宁县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141030', '大宁县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141031', '隰县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141032', '永和县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141033', '蒲县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141034', '汾西县', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141081', '侯马市', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141082', '霍州市', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141083', '其它区', '141000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141100', '吕梁市', '140000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141102', '离石区', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141121', '文水县', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141122', '交城县', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141123', '兴县', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141124', '临县', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141125', '柳林县', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141126', '石楼县', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141127', '岚县', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141128', '方山县', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141129', '中阳县', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141130', '交口县', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141181', '孝义市', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141182', '汾阳市', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('141183', '其它区', '141100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150000', '内蒙古自治区', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150100', '呼和浩特市', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150102', '新城区', '150100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150103', '回民区', '150100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150104', '玉泉区', '150100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150105', '赛罕区', '150100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150121', '土默特左旗', '150100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150122', '托克托县', '150100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150123', '和林格尔县', '150100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150124', '清水河县', '150100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150125', '武川县', '150100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150126', '其它区', '150100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150200', '包头市', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150202', '东河区', '150200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150203', '昆都仑区', '150200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150204', '青山区', '150200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150205', '石拐区', '150200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150206', '白云矿区', '150200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150207', '九原区', '150200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150221', '土默特右旗', '150200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150222', '固阳县', '150200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150223', '达尔罕茂明安联合旗', '150200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150224', '其它区', '150200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150300', '乌海市', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150302', '海勃湾区', '150300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150303', '海南区', '150300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150304', '乌达区', '150300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150305', '其它区', '150300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150400', '赤峰市', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150402', '红山区', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150403', '元宝山区', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150404', '松山区', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150421', '阿鲁科尔沁旗', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150422', '巴林左旗', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150423', '巴林右旗', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150424', '林西县', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150425', '克什克腾旗', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150426', '翁牛特旗', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150428', '喀喇沁旗', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150429', '宁城县', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150430', '敖汉旗', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150431', '其它区', '150400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150500', '通辽市', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150502', '科尔沁区', '150500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150521', '科尔沁左翼中旗', '150500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150522', '科尔沁左翼后旗', '150500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150523', '开鲁县', '150500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150524', '库伦旗', '150500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150525', '奈曼旗', '150500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150526', '扎鲁特旗', '150500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150581', '霍林郭勒市', '150500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150582', '其它区', '150500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150600', '鄂尔多斯市', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150602', '东胜区', '150600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150621', '达拉特旗', '150600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150622', '准格尔旗', '150600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150623', '鄂托克前旗', '150600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150624', '鄂托克旗', '150600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150625', '杭锦旗', '150600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150626', '乌审旗', '150600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150627', '伊金霍洛旗', '150600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150628', '其它区', '150600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150700', '呼伦贝尔市', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150702', '海拉尔区', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150721', '阿荣旗', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150722', '莫力达瓦达斡尔族自治旗', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150723', '鄂伦春自治旗', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150724', '鄂温克族自治旗', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150725', '陈巴尔虎旗', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150726', '新巴尔虎左旗', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150727', '新巴尔虎右旗', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150781', '满洲里市', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150782', '牙克石市', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150783', '扎兰屯市', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150784', '额尔古纳市', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150785', '根河市', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150786', '其它区', '150700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150800', '巴彦淖尔市', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150802', '临河区', '150800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150821', '五原县', '150800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150822', '磴口县', '150800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150823', '乌拉特前旗', '150800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150824', '乌拉特中旗', '150800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150825', '乌拉特后旗', '150800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150826', '杭锦后旗', '150800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150827', '其它区', '150800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150900', '乌兰察布市', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150902', '集宁区', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150921', '卓资县', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150922', '化德县', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150923', '商都县', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150924', '兴和县', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150925', '凉城县', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150926', '察哈尔右翼前旗', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150927', '察哈尔右翼中旗', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150928', '察哈尔右翼后旗', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150929', '四子王旗', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150981', '丰镇市', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('150982', '其它区', '150900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152200', '兴安盟', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152201', '乌兰浩特市', '152200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152202', '阿尔山市', '152200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152221', '科尔沁右翼前旗', '152200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152222', '科尔沁右翼中旗', '152200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152223', '扎赉特旗', '152200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152224', '突泉县', '152200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152225', '其它区', '152200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152500', '锡林郭勒盟', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152501', '二连浩特市', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152502', '锡林浩特市', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152522', '阿巴嘎旗', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152523', '苏尼特左旗', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152524', '苏尼特右旗', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152525', '东乌珠穆沁旗', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152526', '西乌珠穆沁旗', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152527', '太仆寺旗', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152528', '镶黄旗', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152529', '正镶白旗', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152530', '正蓝旗', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152531', '多伦县', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152532', '其它区', '152500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152900', '阿拉善盟', '150000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152921', '阿拉善左旗', '152900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152922', '阿拉善右旗', '152900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152923', '额济纳旗', '152900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('152924', '其它区', '152900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210000', '辽宁省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210100', '沈阳市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210102', '和平区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210103', '沈河区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210104', '大东区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210105', '皇姑区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210106', '铁西区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210111', '苏家屯区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210112', '东陵区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210113', '新城子区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210114', '于洪区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210122', '辽中县', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210123', '康平县', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210124', '法库县', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210181', '新民市', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210182', '浑南新区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210183', '张士开发区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210184', '沈北新区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210185', '其它区', '210100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210200', '大连市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210202', '中山区', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210203', '西岗区', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210204', '沙河口区', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210211', '甘井子区', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210212', '旅顺口区', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210213', '金州区', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210224', '长海县', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210251', '开发区', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210281', '瓦房店市', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210282', '普兰店市', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210283', '庄河市', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210297', '岭前区', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210298', '其它区', '210200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210300', '鞍山市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210302', '铁东区', '210300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210303', '铁西区', '210300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210304', '立山区', '210300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210311', '千山区', '210300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210321', '台安县', '210300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210323', '岫岩满族自治县', '210300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210351', '高新区', '210300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210381', '海城市', '210300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210382', '其它区', '210300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210400', '抚顺市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210402', '新抚区', '210400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210403', '东洲区', '210400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210404', '望花区', '210400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210411', '顺城区', '210400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210421', '抚顺县', '210400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210422', '新宾满族自治县', '210400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210423', '清原满族自治县', '210400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210424', '其它区', '210400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210500', '本溪市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210502', '平山区', '210500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210503', '溪湖区', '210500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210504', '明山区', '210500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210505', '南芬区', '210500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210521', '本溪满族自治县', '210500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210522', '桓仁满族自治县', '210500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210523', '其它区', '210500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210600', '丹东市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210602', '元宝区', '210600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210603', '振兴区', '210600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210604', '振安区', '210600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210624', '宽甸满族自治县', '210600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210681', '东港市', '210600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210682', '凤城市', '210600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210683', '其它区', '210600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210700', '锦州市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210702', '古塔区', '210700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210703', '凌河区', '210700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210711', '太和区', '210700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210726', '黑山县', '210700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210727', '义县', '210700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210781', '凌海市', '210700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210782', '北镇市', '210700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210783', '其它区', '210700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210800', '营口市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210802', '站前区', '210800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210803', '西市区', '210800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210804', '鲅鱼圈区', '210800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210811', '老边区', '210800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210881', '盖州市', '210800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210882', '大石桥市', '210800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210883', '其它区', '210800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210900', '阜新市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210902', '海州区', '210900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210903', '新邱区', '210900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210904', '太平区', '210900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210905', '清河门区', '210900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210911', '细河区', '210900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210921', '阜新蒙古族自治县', '210900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210922', '彰武县', '210900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('210923', '其它区', '210900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211000', '辽阳市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211002', '白塔区', '211000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211003', '文圣区', '211000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211004', '宏伟区', '211000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211005', '弓长岭区', '211000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211011', '太子河区', '211000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211021', '辽阳县', '211000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211081', '灯塔市', '211000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211082', '其它区', '211000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211100', '盘锦市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211102', '双台子区', '211100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211103', '兴隆台区', '211100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211121', '大洼县', '211100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211122', '盘山县', '211100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211123', '其它区', '211100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211200', '铁岭市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211202', '银州区', '211200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211204', '清河区', '211200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211221', '铁岭县', '211200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211223', '西丰县', '211200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211224', '昌图县', '211200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211281', '调兵山市', '211200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211282', '开原市', '211200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211283', '其它区', '211200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211300', '朝阳市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211302', '双塔区', '211300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211303', '龙城区', '211300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211321', '朝阳县', '211300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211322', '建平县', '211300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211324', '喀喇沁左翼蒙古族自治县', '211300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211381', '北票市', '211300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211382', '凌源市', '211300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211383', '其它区', '211300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211400', '葫芦岛市', '210000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211402', '连山区', '211400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211403', '龙港区', '211400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211404', '南票区', '211400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211421', '绥中县', '211400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211422', '建昌县', '211400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211481', '兴城市', '211400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('211482', '其它区', '211400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220000', '吉林省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220100', '长春市', '220000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220102', '南关区', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220103', '宽城区', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220104', '朝阳区', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220105', '二道区', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220106', '绿园区', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220112', '双阳区', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220122', '农安县', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220181', '九台市', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220182', '榆树市', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220183', '德惠市', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220184', '高新技术产业开发区', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220185', '汽车产业开发区', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220186', '经济技术开发区', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220187', '净月旅游开发区', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220188', '其它区', '220100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220200', '吉林市', '220000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220202', '昌邑区', '220200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220203', '龙潭区', '220200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220204', '船营区', '220200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220211', '丰满区', '220200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220221', '永吉县', '220200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220281', '蛟河市', '220200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220282', '桦甸市', '220200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220283', '舒兰市', '220200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220284', '磐石市', '220200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220285', '其它区', '220200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220300', '四平市', '220000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220302', '铁西区', '220300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220303', '铁东区', '220300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220322', '梨树县', '220300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220323', '伊通满族自治县', '220300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220381', '公主岭市', '220300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220382', '双辽市', '220300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220383', '其它区', '220300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220400', '辽源市', '220000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220402', '龙山区', '220400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220403', '西安区', '220400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220421', '东丰县', '220400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220422', '东辽县', '220400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220423', '其它区', '220400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220500', '通化市', '220000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220502', '东昌区', '220500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220503', '二道江区', '220500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220521', '通化县', '220500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220523', '辉南县', '220500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220524', '柳河县', '220500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220581', '梅河口市', '220500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220582', '集安市', '220500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220583', '其它区', '220500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220600', '白山市', '220000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220602', '八道江区', '220600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220621', '抚松县', '220600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220622', '靖宇县', '220600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220623', '长白朝鲜族自治县', '220600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220625', '江源市', '220600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220681', '临江市', '220600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220682', '其它区', '220600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220700', '松原市', '220000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220702', '宁江区', '220700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220721', '前郭尔罗斯蒙古族自治县', '220700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220722', '长岭县', '220700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220723', '乾安县', '220700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220724', '扶余县', '220700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220725', '其它区', '220700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220800', '白城市', '220000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220802', '洮北区', '220800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220821', '镇赉县', '220800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220822', '通榆县', '220800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220881', '洮南市', '220800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220882', '大安市', '220800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('220883', '其它区', '220800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('222400', '延边朝鲜族自治州', '220000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('222401', '延吉市', '222400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('222402', '图们市', '222400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('222403', '敦化市', '222400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('222404', '珲春市', '222400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('222405', '龙井市', '222400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('222406', '和龙市', '222400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('222424', '汪清县', '222400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('222426', '安图县', '222400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('222427', '其它区', '222400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230000', '黑龙江省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230100', '哈尔滨市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230102', '道里区', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230103', '南岗区', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230104', '道外区', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230106', '香坊区', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230107', '动力区', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230108', '平房区', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230109', '松北区', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230111', '呼兰区', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230123', '依兰县', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230124', '方正县', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230125', '宾县', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230126', '巴彦县', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230127', '木兰县', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230128', '通河县', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230129', '延寿县', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230181', '阿城市', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230182', '双城市', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230183', '尚志市', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230184', '五常市', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230185', '阿城市', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230186', '其它区', '230100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230200', '齐齐哈尔市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230202', '龙沙区', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230203', '建华区', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230204', '铁锋区', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230205', '昂昂溪区', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230206', '富拉尔基区', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230207', '碾子山区', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230208', '梅里斯达斡尔族区', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230221', '龙江县', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230223', '依安县', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230224', '泰来县', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230225', '甘南县', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230227', '富裕县', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230229', '克山县', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230230', '克东县', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230231', '拜泉县', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230281', '讷河市', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230282', '其它区', '230200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230300', '鸡西市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230302', '鸡冠区', '230300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230303', '恒山区', '230300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230304', '滴道区', '230300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230305', '梨树区', '230300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230306', '城子河区', '230300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230307', '麻山区', '230300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230321', '鸡东县', '230300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230381', '虎林市', '230300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230382', '密山市', '230300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230383', '其它区', '230300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230400', '鹤岗市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230402', '向阳区', '230400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230403', '工农区', '230400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230404', '南山区', '230400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230405', '兴安区', '230400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230406', '东山区', '230400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230407', '兴山区', '230400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230421', '萝北县', '230400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230422', '绥滨县', '230400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230423', '其它区', '230400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230500', '双鸭山市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230502', '尖山区', '230500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230503', '岭东区', '230500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230505', '四方台区', '230500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230506', '宝山区', '230500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230521', '集贤县', '230500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230522', '友谊县', '230500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230523', '宝清县', '230500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230524', '饶河县', '230500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230525', '其它区', '230500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230600', '大庆市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230602', '萨尔图区', '230600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230603', '龙凤区', '230600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230604', '让胡路区', '230600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230605', '红岗区', '230600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230606', '大同区', '230600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230621', '肇州县', '230600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230622', '肇源县', '230600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230623', '林甸县', '230600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230624', '杜尔伯特蒙古族自治县', '230600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230625', '其它区', '230600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230700', '伊春市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230702', '伊春区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230703', '南岔区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230704', '友好区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230705', '西林区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230706', '翠峦区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230707', '新青区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230708', '美溪区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230709', '金山屯区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230710', '五营区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230711', '乌马河区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230712', '汤旺河区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230713', '带岭区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230714', '乌伊岭区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230715', '红星区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230716', '上甘岭区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230722', '嘉荫县', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230781', '铁力市', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230782', '其它区', '230700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230800', '佳木斯市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230802', '永红区', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230803', '向阳区', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230804', '前进区', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230805', '东风区', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230811', '郊区', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230822', '桦南县', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230826', '桦川县', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230828', '汤原县', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230833', '抚远县', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230881', '同江市', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230882', '富锦市', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230883', '其它区', '230800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230900', '七台河市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230902', '新兴区', '230900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230903', '桃山区', '230900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230904', '茄子河区', '230900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230921', '勃利县', '230900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('230922', '其它区', '230900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231000', '牡丹江市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231002', '东安区', '231000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231003', '阳明区', '231000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231004', '爱民区', '231000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231005', '西安区', '231000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231024', '东宁县', '231000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231025', '林口县', '231000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231081', '绥芬河市', '231000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231083', '海林市', '231000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231084', '宁安市', '231000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231085', '穆棱市', '231000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231086', '其它区', '231000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231100', '黑河市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231102', '爱辉区', '231100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231121', '嫩江县', '231100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231123', '逊克县', '231100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231124', '孙吴县', '231100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231181', '北安市', '231100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231182', '五大连池市', '231100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231183', '其它区', '231100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231200', '绥化市', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231202', '北林区', '231200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231221', '望奎县', '231200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231222', '兰西县', '231200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231223', '青冈县', '231200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231224', '庆安县', '231200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231225', '明水县', '231200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231226', '绥棱县', '231200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231281', '安达市', '231200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231282', '肇东市', '231200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231283', '海伦市', '231200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('231284', '其它区', '231200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('232700', '大兴安岭地区', '230000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('232721', '呼玛县', '232700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('232722', '塔河县', '232700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('232723', '漠河县', '232700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('232724', '加格达奇区', '232700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('232725', '其它区', '232700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310000', '上海', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310100', '上海市', '310000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310101', '黄浦区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310103', '卢湾区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310104', '徐汇区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310105', '长宁区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310106', '静安区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310107', '普陀区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310108', '闸北区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310109', '虹口区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310110', '杨浦区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310112', '闵行区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310113', '宝山区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310114', '嘉定区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310115', '浦东新区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310116', '金山区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310117', '松江区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310118', '青浦区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310119', '南汇区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310120', '奉贤区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310152', '川沙区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310230', '崇明县', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('310231', '其它区', '310100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320000', '江苏省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320100', '南京市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320102', '玄武区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320103', '白下区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320104', '秦淮区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320105', '建邺区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320106', '鼓楼区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320107', '下关区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320111', '浦口区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320113', '栖霞区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320114', '雨花台区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320115', '江宁区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320116', '六合区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320124', '溧水县', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320125', '高淳县', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320126', '其它区', '320100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320200', '无锡市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320202', '崇安区', '320200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320203', '南长区', '320200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320204', '北塘区', '320200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320205', '锡山区', '320200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320206', '惠山区', '320200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320211', '滨湖区', '320200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320281', '江阴市', '320200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320282', '宜兴市', '320200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320296', '新区', '320200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320297', '其它区', '320200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320300', '徐州市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320302', '鼓楼区', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320303', '云龙区', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320304', '九里区', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320305', '贾汪区', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320311', '泉山区', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320321', '丰县', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320322', '沛县', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320323', '铜山县', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320324', '睢宁县', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320381', '新沂市', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320382', '邳州市', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320383', '其它区', '320300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320400', '常州市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320402', '天宁区', '320400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320404', '钟楼区', '320400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320405', '戚墅堰区', '320400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320411', '新北区', '320400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320412', '武进区', '320400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320481', '溧阳市', '320400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320482', '金坛市', '320400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320483', '其它区', '320400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320500', '苏州市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320502', '沧浪区', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320503', '平江区', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320504', '金阊区', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320505', '虎丘区', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320506', '吴中区', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320507', '相城区', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320581', '常熟市', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320582', '张家港市', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320583', '昆山市', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320584', '吴江市', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320585', '太仓市', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320594', '新区', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320595', '园区', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320596', '其它区', '320500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320600', '南通市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320602', '崇川区', '320600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320611', '港闸区', '320600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320612', '通州区', '320600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320621', '海安县', '320600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320623', '如东县', '320600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320681', '启东市', '320600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320682', '如皋市', '320600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320683', '通州市', '320600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320684', '海门市', '320600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320693', '开发区', '320600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320694', '其它区', '320600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320700', '连云港市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320703', '连云区', '320700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320705', '新浦区', '320700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320706', '海州区', '320700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320721', '赣榆县', '320700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320722', '东海县', '320700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320723', '灌云县', '320700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320724', '灌南县', '320700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320725', '其它区', '320700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320800', '淮安市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320802', '清河区', '320800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320803', '楚州区', '320800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320804', '淮阴区', '320800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320811', '清浦区', '320800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320826', '涟水县', '320800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320829', '洪泽县', '320800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320830', '盱眙县', '320800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320831', '金湖县', '320800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320832', '其它区', '320800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320900', '盐城市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320902', '亭湖区', '320900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320903', '盐都区', '320900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320921', '响水县', '320900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320922', '滨海县', '320900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320923', '阜宁县', '320900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320924', '射阳县', '320900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320925', '建湖县', '320900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320981', '东台市', '320900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320982', '大丰市', '320900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('320983', '其它区', '320900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321000', '扬州市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321002', '广陵区', '321000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321003', '邗江区', '321000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321011', '维扬区', '321000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321023', '宝应县', '321000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321081', '仪征市', '321000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321084', '高邮市', '321000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321088', '江都市', '321000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321092', '经济开发区', '321000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321093', '其它区', '321000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321100', '镇江市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321102', '京口区', '321100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321111', '润州区', '321100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321112', '丹徒区', '321100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321181', '丹阳市', '321100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321182', '扬中市', '321100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321183', '句容市', '321100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321184', '其它区', '321100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321200', '泰州市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321202', '海陵区', '321200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321203', '高港区', '321200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321281', '兴化市', '321200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321282', '靖江市', '321200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321283', '泰兴市', '321200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321284', '姜堰市', '321200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321285', '其它区', '321200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321300', '宿迁市', '320000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321302', '宿城区', '321300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321311', '宿豫区', '321300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321322', '沭阳县', '321300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321323', '泗阳县', '321300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321324', '泗洪县', '321300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('321325', '其它区', '321300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330000', '浙江省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330100', '杭州市', '330000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330102', '上城区', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330103', '下城区', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330104', '江干区', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330105', '拱墅区', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330106', '西湖区', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330108', '滨江区', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330109', '萧山区', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330110', '余杭区', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330122', '桐庐县', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330127', '淳安县', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330182', '建德市', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330183', '富阳市', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330185', '临安市', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330186', '其它区', '330100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330200', '宁波市', '330000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330203', '海曙区', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330204', '江东区', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330205', '江北区', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330206', '北仑区', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330211', '镇海区', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330212', '鄞州区', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330225', '象山县', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330226', '宁海县', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330281', '余姚市', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330282', '慈溪市', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330283', '奉化市', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330284', '其它区', '330200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330300', '温州市', '330000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330302', '鹿城区', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330303', '龙湾区', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330304', '瓯海区', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330322', '洞头县', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330324', '永嘉县', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330326', '平阳县', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330327', '苍南县', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330328', '文成县', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330329', '泰顺县', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330381', '瑞安市', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330382', '乐清市', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330383', '其它区', '330300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330400', '嘉兴市', '330000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330402', '南湖区', '330400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330411', '秀洲区', '330400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330421', '嘉善县', '330400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330424', '海盐县', '330400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330481', '海宁市', '330400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330482', '平湖市', '330400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330483', '桐乡市', '330400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330484', '其它区', '330400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330500', '湖州市', '330000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330502', '吴兴区', '330500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330503', '南浔区', '330500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330521', '德清县', '330500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330522', '长兴县', '330500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330523', '安吉县', '330500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330524', '其它区', '330500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330600', '绍兴市', '330000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330602', '越城区', '330600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330621', '绍兴县', '330600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330624', '新昌县', '330600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330681', '诸暨市', '330600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330682', '上虞市', '330600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330683', '嵊州市', '330600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330684', '其它区', '330600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330700', '金华市', '330000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330702', '婺城区', '330700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330703', '金东区', '330700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330723', '武义县', '330700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330726', '浦江县', '330700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330727', '磐安县', '330700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330781', '兰溪市', '330700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330782', '义乌市', '330700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330783', '东阳市', '330700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330784', '永康市', '330700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330785', '其它区', '330700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330800', '衢州市', '330000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330802', '柯城区', '330800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330803', '衢江区', '330800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330822', '常山县', '330800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330824', '开化县', '330800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330825', '龙游县', '330800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330881', '江山市', '330800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330882', '其它区', '330800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330900', '舟山市', '330000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330902', '定海区', '330900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330903', '普陀区', '330900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330921', '岱山县', '330900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330922', '嵊泗县', '330900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('330923', '其它区', '330900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331000', '台州市', '330000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331002', '椒江区', '331000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331003', '黄岩区', '331000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331004', '路桥区', '331000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331021', '玉环县', '331000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331022', '三门县', '331000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331023', '天台县', '331000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331024', '仙居县', '331000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331081', '温岭市', '331000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331082', '临海市', '331000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331083', '其它区', '331000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331100', '丽水市', '330000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331102', '莲都区', '331100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331121', '青田县', '331100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331122', '缙云县', '331100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331123', '遂昌县', '331100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331124', '松阳县', '331100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331125', '云和县', '331100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331126', '庆元县', '331100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331127', '景宁畲族自治县', '331100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331181', '龙泉市', '331100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('331182', '其它区', '331100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340000', '安徽省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340100', '合肥市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340102', '瑶海区', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340103', '庐阳区', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340104', '蜀山区', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340111', '包河区', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340121', '长丰县', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340122', '肥东县', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340123', '肥西县', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340151', '高新区', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340191', '中区', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340192', '其它区', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340200', '芜湖市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340202', '镜湖区', '340200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340203', '弋江区', '340200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340207', '鸠江区', '340200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340208', '三山区', '340200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340221', '芜湖县', '340200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340222', '繁昌县', '340200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340223', '南陵县', '340200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340224', '其它区', '340200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340300', '蚌埠市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340302', '龙子湖区', '340300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340303', '蚌山区', '340300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340304', '禹会区', '340300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340311', '淮上区', '340300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340321', '怀远县', '340300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340322', '五河县', '340300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340323', '固镇县', '340300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340324', '其它区', '340300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340400', '淮南市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340402', '大通区', '340400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340403', '田家庵区', '340400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340404', '谢家集区', '340400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340405', '八公山区', '340400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340406', '潘集区', '340400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340421', '凤台县', '340400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340422', '其它区', '340400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340500', '马鞍山市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340502', '金家庄区', '340500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340503', '花山区', '340500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340504', '雨山区', '340500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340521', '当涂县', '340500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340522', '其它区', '340500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340600', '淮北市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340602', '杜集区', '340600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340603', '相山区', '340600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340604', '烈山区', '340600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340621', '濉溪县', '340600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340622', '其它区', '340600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340700', '铜陵市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340702', '铜官山区', '340700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340703', '狮子山区', '340700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340711', '郊区', '340700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340721', '铜陵县', '340700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340722', '其它区', '340700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340800', '安庆市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340802', '迎江区', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340803', '大观区', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340811', '宜秀区', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340822', '怀宁县', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340823', '枞阳县', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340824', '潜山县', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340825', '太湖县', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340826', '宿松县', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340827', '望江县', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340828', '岳西县', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340881', '桐城市', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('340882', '其它区', '340800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341000', '黄山市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341002', '屯溪区', '341000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341003', '黄山区', '341000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341004', '徽州区', '341000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341021', '歙县', '341000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341022', '休宁县', '341000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341023', '黟县', '341000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341024', '祁门县', '341000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341025', '其它区', '341000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341100', '滁州市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341102', '琅琊区', '341100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341103', '南谯区', '341100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341122', '来安县', '341100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341124', '全椒县', '341100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341125', '定远县', '341100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341126', '凤阳县', '341100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341181', '天长市', '341100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341182', '明光市', '341100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341183', '其它区', '341100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341200', '阜阳市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341202', '颍州区', '341200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341203', '颍东区', '341200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341204', '颍泉区', '341200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341221', '临泉县', '341200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341222', '太和县', '341200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341225', '阜南县', '341200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341226', '颍上县', '341200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341282', '界首市', '341200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341283', '其它区', '341200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341300', '宿州市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341302', '埇桥区', '341300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341321', '砀山县', '341300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341322', '萧县', '341300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341323', '灵璧县', '341300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341324', '泗县', '341300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341325', '其它区', '341300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341400', '巢湖市', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341402', '居巢区', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341421', '庐江县', '340100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341422', '无为县', '340200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341423', '含山县', '340500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341424', '和县', '340500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341500', '六安市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341502', '金安区', '341500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341503', '裕安区', '341500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341521', '寿县', '341500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341522', '霍邱县', '341500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341523', '舒城县', '341500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341524', '金寨县', '341500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341525', '霍山县', '341500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341526', '其它区', '341500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341600', '亳州市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341602', '谯城区', '341600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341621', '涡阳县', '341600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341622', '蒙城县', '341600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341623', '利辛县', '341600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341624', '其它区', '341600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341700', '池州市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341702', '贵池区', '341700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341721', '东至县', '341700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341722', '石台县', '341700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341723', '青阳县', '341700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341724', '其它区', '341700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341800', '宣城市', '340000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341802', '宣州区', '341800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341821', '郎溪县', '341800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341822', '广德县', '341800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341823', '泾县', '341800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341824', '绩溪县', '341800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341825', '旌德县', '341800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341881', '宁国市', '341800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('341882', '其它区', '341800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350000', '福建省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350100', '福州市', '350000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350102', '鼓楼区', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350103', '台江区', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350104', '仓山区', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350105', '马尾区', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350111', '晋安区', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350121', '闽侯县', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350122', '连江县', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350123', '罗源县', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350124', '闽清县', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350125', '永泰县', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350128', '平潭县', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350181', '福清市', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350182', '长乐市', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350183', '其它区', '350100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350200', '厦门市', '350000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350203', '思明区', '350200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350205', '海沧区', '350200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350206', '湖里区', '350200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350211', '集美区', '350200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350212', '同安区', '350200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350213', '翔安区', '350200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350214', '其它区', '350200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350300', '莆田市', '350000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350302', '城厢区', '350300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350303', '涵江区', '350300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350304', '荔城区', '350300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350305', '秀屿区', '350300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350322', '仙游县', '350300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350323', '其它区', '350300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350400', '三明市', '350000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350402', '梅列区', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350403', '三元区', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350421', '明溪县', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350423', '清流县', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350424', '宁化县', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350425', '大田县', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350426', '尤溪县', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350427', '沙县', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350428', '将乐县', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350429', '泰宁县', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350430', '建宁县', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350481', '永安市', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350482', '其它区', '350400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350500', '泉州市', '350000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350502', '鲤城区', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350503', '丰泽区', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350504', '洛江区', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350505', '泉港区', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350521', '惠安县', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350524', '安溪县', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350525', '永春县', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350526', '德化县', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350527', '金门县', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350581', '石狮市', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350582', '晋江市', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350583', '南安市', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350584', '其它区', '350500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350600', '漳州市', '350000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350602', '芗城区', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350603', '龙文区', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350622', '云霄县', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350623', '漳浦县', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350624', '诏安县', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350625', '长泰县', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350626', '东山县', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350627', '南靖县', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350628', '平和县', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350629', '华安县', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350681', '龙海市', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350682', '其它区', '350600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350700', '南平市', '350000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350702', '延平区', '350700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350721', '顺昌县', '350700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350722', '浦城县', '350700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350723', '光泽县', '350700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350724', '松溪县', '350700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350725', '政和县', '350700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350781', '邵武市', '350700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350782', '武夷山市', '350700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350783', '建瓯市', '350700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350784', '建阳市', '350700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350785', '其它区', '350700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350800', '龙岩市', '350000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350802', '新罗区', '350800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350821', '长汀县', '350800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350822', '永定县', '350800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350823', '上杭县', '350800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350824', '武平县', '350800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350825', '连城县', '350800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350881', '漳平市', '350800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350882', '其它区', '350800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350900', '宁德市', '350000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350902', '蕉城区', '350900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350921', '霞浦县', '350900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350922', '古田县', '350900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350923', '屏南县', '350900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350924', '寿宁县', '350900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350925', '周宁县', '350900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350926', '柘荣县', '350900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350981', '福安市', '350900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350982', '福鼎市', '350900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('350983', '其它区', '350900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360000', '江西省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360100', '南昌市', '360000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360102', '东湖区', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360103', '西湖区', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360104', '青云谱区', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360105', '湾里区', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360111', '青山湖区', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360121', '南昌县', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360122', '新建县', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360123', '安义县', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360124', '进贤县', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360125', '红谷滩新区', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360126', '经济技术开发区', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360127', '昌北区', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360128', '其它区', '360100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360200', '景德镇市', '360000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360202', '昌江区', '360200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360203', '珠山区', '360200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360222', '浮梁县', '360200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360281', '乐平市', '360200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360282', '其它区', '360200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360300', '萍乡市', '360000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360302', '安源区', '360300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360313', '湘东区', '360300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360321', '莲花县', '360300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360322', '上栗县', '360300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360323', '芦溪县', '360300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360324', '其它区', '360300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360400', '九江市', '360000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360402', '庐山区', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360403', '浔阳区', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360421', '九江县', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360423', '武宁县', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360424', '修水县', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360425', '永修县', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360426', '德安县', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360427', '星子县', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360428', '都昌县', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360429', '湖口县', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360430', '彭泽县', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360481', '瑞昌市', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360482', '其它区', '360400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360500', '新余市', '360000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360502', '渝水区', '360500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360521', '分宜县', '360500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360522', '其它区', '360500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360600', '鹰潭市', '360000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360602', '月湖区', '360600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360622', '余江县', '360600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360681', '贵溪市', '360600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360682', '其它区', '360600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360700', '赣州市', '360000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360702', '章贡区', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360721', '赣县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360722', '信丰县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360723', '大余县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360724', '上犹县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360725', '崇义县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360726', '安远县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360727', '龙南县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360728', '定南县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360729', '全南县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360730', '宁都县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360731', '于都县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360732', '兴国县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360733', '会昌县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360734', '寻乌县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360735', '石城县', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360751', '黄金区', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360781', '瑞金市', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360782', '南康市', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360783', '其它区', '360700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360800', '吉安市', '360000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360802', '吉州区', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360803', '青原区', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360821', '吉安县', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360822', '吉水县', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360823', '峡江县', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360824', '新干县', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360825', '永丰县', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360826', '泰和县', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360827', '遂川县', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360828', '万安县', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360829', '安福县', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360830', '永新县', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360881', '井冈山市', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360882', '其它区', '360800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360900', '宜春市', '360000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360902', '袁州区', '360900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360921', '奉新县', '360900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360922', '万载县', '360900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360923', '上高县', '360900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360924', '宜丰县', '360900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360925', '靖安县', '360900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360926', '铜鼓县', '360900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360981', '丰城市', '360900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360982', '樟树市', '360900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360983', '高安市', '360900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('360984', '其它区', '360900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361000', '抚州市', '360000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361002', '临川区', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361021', '南城县', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361022', '黎川县', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361023', '南丰县', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361024', '崇仁县', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361025', '乐安县', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361026', '宜黄县', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361027', '金溪县', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361028', '资溪县', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361029', '东乡县', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361030', '广昌县', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361031', '其它区', '361000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361100', '上饶市', '360000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361102', '信州区', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361121', '上饶县', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361122', '广丰县', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361123', '玉山县', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361124', '铅山县', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361125', '横峰县', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361126', '弋阳县', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361127', '余干县', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361128', '鄱阳县', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361129', '万年县', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361130', '婺源县', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361181', '德兴市', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('361182', '其它区', '361100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370000', '山东省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370100', '济南市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370102', '历下区', '370100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370103', '市中区', '370100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370104', '槐荫区', '370100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370105', '天桥区', '370100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370112', '历城区', '370100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370113', '长清区', '370100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370124', '平阴县', '370100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370125', '济阳县', '370100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370126', '商河县', '370100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370181', '章丘市', '370100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370182', '其它区', '370100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370200', '青岛市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370202', '市南区', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370203', '市北区', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370205', '四方区', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370211', '黄岛区', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370212', '崂山区', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370213', '李沧区', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370214', '城阳区', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370251', '开发区', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370281', '胶州市', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370282', '即墨市', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370283', '平度市', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370284', '胶南市', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370285', '莱西市', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370286', '其它区', '370200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370300', '淄博市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370302', '淄川区', '370300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370303', '张店区', '370300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370304', '博山区', '370300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370305', '临淄区', '370300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370306', '周村区', '370300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370321', '桓台县', '370300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370322', '高青县', '370300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370323', '沂源县', '370300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370324', '其它区', '370300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370400', '枣庄市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370402', '市中区', '370400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370403', '薛城区', '370400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370404', '峄城区', '370400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370405', '台儿庄区', '370400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370406', '山亭区', '370400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370481', '滕州市', '370400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370482', '其它区', '370400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370500', '东营市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370502', '东营区', '370500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370503', '河口区', '370500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370521', '垦利县', '370500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370522', '利津县', '370500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370523', '广饶县', '370500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370589', '西城区', '370500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370590', '东城区', '370500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370591', '其它区', '370500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370600', '烟台市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370602', '芝罘区', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370611', '福山区', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370612', '牟平区', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370613', '莱山区', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370634', '长岛县', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370681', '龙口市', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370682', '莱阳市', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370683', '莱州市', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370684', '蓬莱市', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370685', '招远市', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370686', '栖霞市', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370687', '海阳市', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370688', '其它区', '370600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370700', '潍坊市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370702', '潍城区', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370703', '寒亭区', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370704', '坊子区', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370705', '奎文区', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370724', '临朐县', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370725', '昌乐县', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370751', '开发区', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370781', '青州市', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370782', '诸城市', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370783', '寿光市', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370784', '安丘市', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370785', '高密市', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370786', '昌邑市', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370787', '其它区', '370700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370800', '济宁市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370802', '市中区', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370811', '任城区', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370826', '微山县', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370827', '鱼台县', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370828', '金乡县', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370829', '嘉祥县', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370830', '汶上县', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370831', '泗水县', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370832', '梁山县', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370881', '曲阜市', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370882', '兖州市', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370883', '邹城市', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370884', '其它区', '370800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370900', '泰安市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370902', '泰山区', '370900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370903', '岱岳区', '370900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370921', '宁阳县', '370900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370923', '东平县', '370900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370982', '新泰市', '370900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370983', '肥城市', '370900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('370984', '其它区', '370900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371000', '威海市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371002', '环翠区', '371000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371081', '文登市', '371000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371082', '荣成市', '371000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371083', '乳山市', '371000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371084', '其它区', '371000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371100', '日照市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371102', '东港区', '371100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371103', '岚山区', '371100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371121', '五莲县', '371100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371122', '莒县', '371100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371123', '其它区', '371100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371200', '莱芜市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371202', '莱城区', '371200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371203', '钢城区', '371200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371204', '其它区', '371200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371300', '临沂市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371302', '兰山区', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371311', '罗庄区', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371312', '河东区', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371321', '沂南县', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371322', '郯城县', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371323', '沂水县', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371324', '苍山县', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371325', '费县', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371326', '平邑县', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371327', '莒南县', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371328', '蒙阴县', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371329', '临沭县', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371330', '其它区', '371300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371400', '德州市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371402', '德城区', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371421', '陵县', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371422', '宁津县', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371423', '庆云县', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371424', '临邑县', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371425', '齐河县', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371426', '平原县', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371427', '夏津县', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371428', '武城县', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371451', '开发区', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371481', '乐陵市', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371482', '禹城市', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371483', '其它区', '371400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371500', '聊城市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371502', '东昌府区', '371500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371521', '阳谷县', '371500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371522', '莘县', '371500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371523', '茌平县', '371500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371524', '东阿县', '371500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371525', '冠县', '371500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371526', '高唐县', '371500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371581', '临清市', '371500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371582', '其它区', '371500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371600', '滨州市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371602', '滨城区', '371600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371621', '惠民县', '371600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371622', '阳信县', '371600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371623', '无棣县', '371600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371624', '沾化县', '371600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371625', '博兴县', '371600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371626', '邹平县', '371600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371627', '其它区', '371600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371700', '菏泽市', '370000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371702', '牡丹区', '371700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371721', '曹县', '371700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371722', '单县', '371700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371723', '成武县', '371700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371724', '巨野县', '371700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371725', '郓城县', '371700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371726', '鄄城县', '371700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371727', '定陶县', '371700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371728', '东明县', '371700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('371729', '其它区', '371700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410000', '河南省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410100', '郑州市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410102', '中原区', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410103', '二七区', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410104', '管城回族区', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410105', '金水区', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410106', '上街区', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410108', '惠济区', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410122', '中牟县', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410181', '巩义市', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410182', '荥阳市', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410183', '新密市', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410184', '新郑市', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410185', '登封市', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410186', '郑东新区', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410187', '高新区', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410188', '其它区', '410100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410200', '开封市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410202', '龙亭区', '410200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410203', '顺河回族区', '410200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410204', '鼓楼区', '410200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410205', '禹王台区', '410200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410211', '金明区', '410200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410221', '杞县', '410200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410222', '通许县', '410200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410223', '尉氏县', '410200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410224', '开封县', '410200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410225', '兰考县', '410200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410226', '其它区', '410200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410300', '洛阳市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410302', '老城区', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410303', '西工区', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410304', '廛河回族区', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410305', '涧西区', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410306', '吉利区', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410307', '洛龙区', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410322', '孟津县', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410323', '新安县', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410324', '栾川县', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410325', '嵩县', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410326', '汝阳县', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410327', '宜阳县', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410328', '洛宁县', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410329', '伊川县', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410381', '偃师市', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410400', '平顶山市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410402', '新华区', '410400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410403', '卫东区', '410400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410404', '石龙区', '410400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410411', '湛河区', '410400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410421', '宝丰县', '410400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410422', '叶县', '410400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410423', '鲁山县', '410400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410425', '郏县', '410400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410481', '舞钢市', '410400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410482', '汝州市', '410400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410483', '其它区', '410400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410500', '安阳市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410502', '文峰区', '410500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410503', '北关区', '410500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410505', '殷都区', '410500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410506', '龙安区', '410500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410522', '安阳县', '410500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410523', '汤阴县', '410500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410526', '滑县', '410500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410527', '内黄县', '410500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410581', '林州市', '410500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410582', '其它区', '410500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410600', '鹤壁市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410602', '鹤山区', '410600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410603', '山城区', '410600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410611', '淇滨区', '410600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410621', '浚县', '410600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410622', '淇县', '410600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410623', '其它区', '410600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410700', '新乡市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410702', '红旗区', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410703', '卫滨区', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410704', '凤泉区', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410711', '牧野区', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410721', '新乡县', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410724', '获嘉县', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410725', '原阳县', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410726', '延津县', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410727', '封丘县', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410728', '长垣县', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410781', '卫辉市', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410782', '辉县市', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410783', '其它区', '410700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410800', '焦作市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410802', '解放区', '410800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410803', '中站区', '410800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410804', '马村区', '410800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410811', '山阳区', '410800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410821', '修武县', '410800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410822', '博爱县', '410800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410823', '武陟县', '410800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410825', '温县', '410800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410881', '济源市', '410000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410882', '沁阳市', '410800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410883', '孟州市', '410800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410884', '其它区', '410800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410900', '濮阳市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410902', '华龙区', '410900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410922', '清丰县', '410900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410923', '南乐县', '410900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410926', '范县', '410900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410927', '台前县', '410900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410928', '濮阳县', '410900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('410929', '其它区', '410900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411000', '许昌市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411002', '魏都区', '411000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411023', '许昌县', '411000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411024', '鄢陵县', '411000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411025', '襄城县', '411000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411081', '禹州市', '411000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411082', '长葛市', '411000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411083', '其它区', '411000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411100', '漯河市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411102', '源汇区', '411100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411103', '郾城区', '411100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411104', '召陵区', '411100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411121', '舞阳县', '411100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411122', '临颍县', '411100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411123', '其它区', '411100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411200', '三门峡市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411202', '湖滨区', '411200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411221', '渑池县', '411200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411222', '陕县', '411200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411224', '卢氏县', '411200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411281', '义马市', '411200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411282', '灵宝市', '411200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411283', '其它区', '411200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411300', '南阳市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411302', '宛城区', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411303', '卧龙区', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411321', '南召县', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411322', '方城县', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411323', '西峡县', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411324', '镇平县', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411325', '内乡县', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411326', '淅川县', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411327', '社旗县', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411328', '唐河县', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411329', '新野县', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411330', '桐柏县', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411381', '邓州市', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411382', '其它区', '411300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411400', '商丘市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411402', '梁园区', '411400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411403', '睢阳区', '411400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411421', '民权县', '411400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411422', '睢县', '411400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411423', '宁陵县', '411400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411424', '柘城县', '411400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411425', '虞城县', '411400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411426', '夏邑县', '411400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411481', '永城市', '411400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411482', '其它区', '411400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411500', '信阳市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411502', '浉河区', '411500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411503', '平桥区', '411500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411521', '罗山县', '411500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411522', '光山县', '411500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411523', '新县', '411500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411524', '商城县', '411500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411525', '固始县', '411500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411526', '潢川县', '411500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411527', '淮滨县', '411500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411528', '息县', '411500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411529', '其它区', '411500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411600', '周口市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411602', '川汇区', '411600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411621', '扶沟县', '411600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411622', '西华县', '411600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411623', '商水县', '411600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411624', '沈丘县', '411600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411625', '郸城县', '411600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411626', '淮阳县', '411600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411627', '太康县', '411600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411628', '鹿邑县', '411600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411681', '项城市', '411600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411682', '其它区', '411600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411700', '驻马店市', '410000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411702', '驿城区', '411700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411721', '西平县', '411700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411722', '上蔡县', '411700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411723', '平舆县', '411700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411724', '正阳县', '411700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411725', '确山县', '411700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411726', '泌阳县', '411700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411727', '汝南县', '411700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411728', '遂平县', '411700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411729', '新蔡县', '411700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('411730', '其它区', '411700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420000', '湖北省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420100', '武汉市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420102', '江岸区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420103', '江汉区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420104', '硚口区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420105', '汉阳区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420106', '武昌区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420107', '青山区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420111', '洪山区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420112', '东西湖区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420113', '汉南区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420114', '蔡甸区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420115', '江夏区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420116', '黄陂区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420117', '新洲区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420118', '其它区', '420100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420200', '黄石市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420202', '黄石港区', '420200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420203', '西塞山区', '420200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420204', '下陆区', '420200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420205', '铁山区', '420200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420222', '阳新县', '420200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420281', '大冶市', '420200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420282', '其它区', '420200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420300', '十堰市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420302', '茅箭区', '420300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420303', '张湾区', '420300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420321', '郧县', '420300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420322', '郧西县', '420300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420323', '竹山县', '420300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420324', '竹溪县', '420300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420325', '房县', '420300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420381', '丹江口市', '420300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420382', '城区', '420300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420383', '其它区', '420300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420500', '宜昌市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420502', '西陵区', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420503', '伍家岗区', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420504', '点军区', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420505', '猇亭区', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420506', '夷陵区', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420525', '远安县', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420526', '兴山县', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420527', '秭归县', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420528', '长阳土家族自治县', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420529', '五峰土家族自治县', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420551', '葛洲坝区', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420552', '开发区', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420581', '宜都市', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420582', '当阳市', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420583', '枝江市', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420584', '其它区', '420500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420600', '襄阳市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420602', '襄城区', '420600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420606', '樊城区', '420600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420607', '襄州区', '420600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420624', '南漳县', '420600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420625', '谷城县', '420600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420626', '保康县', '420600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420682', '老河口市', '420600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420683', '枣阳市', '420600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420684', '宜城市', '420600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420685', '其它区', '420600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420700', '鄂州市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420702', '梁子湖区', '420700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420703', '华容区', '420700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420704', '鄂城区', '420700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420705', '其它区', '420700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420800', '荆门市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420802', '东宝区', '420800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420804', '掇刀区', '420800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420821', '京山县', '420800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420822', '沙洋县', '420800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420881', '钟祥市', '420800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420882', '其它区', '420800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420900', '孝感市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420902', '孝南区', '420900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420921', '孝昌县', '420900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420922', '大悟县', '420900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420923', '云梦县', '420900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420981', '应城市', '420900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420982', '安陆市', '420900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420984', '汉川市', '420900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('420985', '其它区', '420900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421000', '荆州市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421002', '沙市区', '421000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421003', '荆州区', '421000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421022', '公安县', '421000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421023', '监利县', '421000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421024', '江陵县', '421000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421081', '石首市', '421000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421083', '洪湖市', '421000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421087', '松滋市', '421000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421088', '其它区', '421000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421100', '黄冈市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421102', '黄州区', '421100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421121', '团风县', '421100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421122', '红安县', '421100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421123', '罗田县', '421100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421124', '英山县', '421100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421125', '浠水县', '421100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421126', '蕲春县', '421100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421127', '黄梅县', '421100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421181', '麻城市', '421100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421182', '武穴市', '421100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421183', '其它区', '421100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421200', '咸宁市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421202', '咸安区', '421200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421221', '嘉鱼县', '421200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421222', '通城县', '421200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421223', '崇阳县', '421200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421224', '通山县', '421200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421281', '赤壁市', '421200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421282', '温泉城区', '421200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421283', '其它区', '421200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421300', '随州市', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421302', '曾都区', '421300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421321', '随县', '421300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421381', '广水市', '421300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('421382', '其它区', '421300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('422800', '恩施土家族苗族自治州', '420000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('422801', '恩施市', '422800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('422802', '利川市', '422800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('422822', '建始县', '422800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('422823', '巴东县', '422800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('422825', '宣恩县', '422800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('422826', '咸丰县', '422800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('422827', '来凤县', '422800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('422828', '鹤峰县', '422800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('422829', '其它区', '422800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('429004', '仙桃市', '420000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('429005', '潜江市', '420000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('429006', '天门市', '420000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('429021', '神农架林区', '420000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430000', '湖南省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430100', '长沙市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430102', '芙蓉区', '430100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430103', '天心区', '430100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430104', '岳麓区', '430100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430105', '开福区', '430100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430111', '雨花区', '430100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430121', '长沙县', '430100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430122', '望城县', '430100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430124', '宁乡县', '430100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430181', '浏阳市', '430100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430182', '其它区', '430100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430200', '株洲市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430202', '荷塘区', '430200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430203', '芦淞区', '430200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430204', '石峰区', '430200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430211', '天元区', '430200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430221', '株洲县', '430200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430223', '攸县', '430200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430224', '茶陵县', '430200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430225', '炎陵县', '430200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430281', '醴陵市', '430200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430282', '其它区', '430200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430300', '湘潭市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430302', '雨湖区', '430300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430304', '岳塘区', '430300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430321', '湘潭县', '430300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430381', '湘乡市', '430300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430382', '韶山市', '430300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430383', '其它区', '430300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430400', '衡阳市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430405', '珠晖区', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430406', '雁峰区', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430407', '石鼓区', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430408', '蒸湘区', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430412', '南岳区', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430421', '衡阳县', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430422', '衡南县', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430423', '衡山县', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430424', '衡东县', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430426', '祁东县', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430481', '耒阳市', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430482', '常宁市', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430483', '其它区', '430400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430500', '邵阳市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430502', '双清区', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430503', '大祥区', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430511', '北塔区', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430521', '邵东县', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430522', '新邵县', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430523', '邵阳县', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430524', '隆回县', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430525', '洞口县', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430527', '绥宁县', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430528', '新宁县', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430529', '城步苗族自治县', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430581', '武冈市', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430582', '其它区', '430500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430600', '岳阳市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430602', '岳阳楼区', '430600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430603', '云溪区', '430600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430611', '君山区', '430600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430621', '岳阳县', '430600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430623', '华容县', '430600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430624', '湘阴县', '430600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430626', '平江县', '430600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430681', '汨罗市', '430600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430682', '临湘市', '430600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430683', '其它区', '430600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430700', '常德市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430702', '武陵区', '430700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430703', '鼎城区', '430700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430721', '安乡县', '430700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430722', '汉寿县', '430700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430723', '澧县', '430700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430724', '临澧县', '430700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430725', '桃源县', '430700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430726', '石门县', '430700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430781', '津市市', '430700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430782', '其它区', '430700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430800', '张家界市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430802', '永定区', '430800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430811', '武陵源区', '430800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430821', '慈利县', '430800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430822', '桑植县', '430800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430823', '其它区', '430800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430900', '益阳市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430902', '资阳区', '430900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430903', '赫山区', '430900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430921', '南县', '430900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430922', '桃江县', '430900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430923', '安化县', '430900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430981', '沅江市', '430900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('430982', '其它区', '430900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431000', '郴州市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431002', '北湖区', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431003', '苏仙区', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431021', '桂阳县', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431022', '宜章县', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431023', '永兴县', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431024', '嘉禾县', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431025', '临武县', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431026', '汝城县', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431027', '桂东县', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431028', '安仁县', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431081', '资兴市', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431082', '其它区', '431000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431100', '永州市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431102', '零陵区', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431103', '冷水滩区', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431121', '祁阳县', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431122', '东安县', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431123', '双牌县', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431124', '道县', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431125', '江永县', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431126', '宁远县', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431127', '蓝山县', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431128', '新田县', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431129', '江华瑶族自治县', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431130', '其它区', '431100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431200', '怀化市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431202', '鹤城区', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431221', '中方县', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431222', '沅陵县', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431223', '辰溪县', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431224', '溆浦县', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431225', '会同县', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431226', '麻阳苗族自治县', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431227', '新晃侗族自治县', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431228', '芷江侗族自治县', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431229', '靖州苗族侗族自治县', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431230', '通道侗族自治县', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431281', '洪江市', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431282', '其它区', '431200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431300', '娄底市', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431302', '娄星区', '431300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431321', '双峰县', '431300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431322', '新化县', '431300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431381', '冷水江市', '431300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431382', '涟源市', '431300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('431383', '其它区', '431300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('433100', '湘西土家族苗族自治州', '430000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('433101', '吉首市', '433100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('433122', '泸溪县', '433100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('433123', '凤凰县', '433100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('433124', '花垣县', '433100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('433125', '保靖县', '433100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('433126', '古丈县', '433100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('433127', '永顺县', '433100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('433130', '龙山县', '433100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('433131', '其它区', '433100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440000', '广东省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440100', '广州市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440103', '荔湾区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440104', '越秀区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440105', '海珠区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440106', '天河区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440111', '白云区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440112', '黄埔区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440113', '番禺区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440114', '花都区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440115', '南沙区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440116', '萝岗区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440183', '增城市', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440184', '从化市', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440188', '东山区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440189', '其它区', '440100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440200', '韶关市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440203', '武江区', '440200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440204', '浈江区', '440200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440205', '曲江区', '440200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440222', '始兴县', '440200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440224', '仁化县', '440200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440229', '翁源县', '440200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440232', '乳源瑶族自治县', '440200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440233', '新丰县', '440200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440281', '乐昌市', '440200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440282', '南雄市', '440200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440283', '其它区', '440200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440300', '深圳市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440303', '罗湖区', '440300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440304', '福田区', '440300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440305', '南山区', '440300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440306', '宝安区', '440300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440307', '龙岗区', '440300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440308', '盐田区', '440300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440309', '其它区', '440300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440400', '珠海市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440402', '香洲区', '440400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440403', '斗门区', '440400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440404', '金湾区', '440400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440486', '金唐区', '440400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440487', '南湾区', '440400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440488', '其它区', '440400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440500', '汕头市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440507', '龙湖区', '440500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440511', '金平区', '440500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440512', '濠江区', '440500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440513', '潮阳区', '440500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440514', '潮南区', '440500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440515', '澄海区', '440500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440523', '南澳县', '440500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440524', '其它区', '440500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440600', '佛山市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440604', '禅城区', '440600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440605', '南海区', '440600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440606', '顺德区', '440600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440607', '三水区', '440600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440608', '高明区', '440600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440609', '其它区', '440600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440700', '江门市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440703', '蓬江区', '440700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440704', '江海区', '440700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440705', '新会区', '440700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440781', '台山市', '440700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440783', '开平市', '440700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440784', '鹤山市', '440700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440785', '恩平市', '440700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440786', '其它区', '440700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440800', '湛江市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440802', '赤坎区', '440800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440803', '霞山区', '440800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440804', '坡头区', '440800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440811', '麻章区', '440800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440823', '遂溪县', '440800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440825', '徐闻县', '440800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440881', '廉江市', '440800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440882', '雷州市', '440800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440883', '吴川市', '440800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440884', '其它区', '440800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440900', '茂名市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440902', '茂南区', '440900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440903', '茂港区', '440900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440923', '电白县', '440900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440981', '高州市', '440900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440982', '化州市', '440900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440983', '信宜市', '440900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('440984', '其它区', '440900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441200', '肇庆市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441202', '端州区', '441200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441203', '鼎湖区', '441200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441223', '广宁县', '441200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441224', '怀集县', '441200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441225', '封开县', '441200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441226', '德庆县', '441200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441283', '高要市', '441200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441284', '四会市', '441200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441285', '其它区', '441200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441300', '惠州市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441302', '惠城区', '441300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441303', '惠阳区', '441300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441322', '博罗县', '441300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441323', '惠东县', '441300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441324', '龙门县', '441300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441325', '其它区', '441300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441400', '梅州市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441402', '梅江区', '441400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441421', '梅县', '441400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441422', '大埔县', '441400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441423', '丰顺县', '441400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441424', '五华县', '441400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441426', '平远县', '441400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441427', '蕉岭县', '441400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441481', '兴宁市', '441400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441482', '其它区', '441400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441500', '汕尾市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441502', '城区', '441500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441521', '海丰县', '441500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441523', '陆河县', '441500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441581', '陆丰市', '441500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441582', '其它区', '441500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441600', '河源市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441602', '源城区', '441600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441621', '紫金县', '441600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441622', '龙川县', '441600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441623', '连平县', '441600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441624', '和平县', '441600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441625', '东源县', '441600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441626', '其它区', '441600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441700', '阳江市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441702', '江城区', '441700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441721', '阳西县', '441700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441723', '阳东县', '441700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441781', '阳春市', '441700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441782', '其它区', '441700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441800', '清远市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441802', '清城区', '441800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441821', '佛冈县', '441800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441823', '阳山县', '441800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441825', '连山壮族瑶族自治县', '441800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441826', '连南瑶族自治县', '441800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441827', '清新县', '441800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441881', '英德市', '441800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441882', '连州市', '441800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441883', '其它区', '441800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('441900', '东莞市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('442000', '中山市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445100', '潮州市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445102', '湘桥区', '445100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445121', '潮安县', '445100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445122', '饶平县', '445100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445185', '枫溪区', '445100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445186', '其它区', '445100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445200', '揭阳市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445202', '榕城区', '445200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445221', '揭东县', '445200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445222', '揭西县', '445200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445224', '惠来县', '445200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445281', '普宁市', '445200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445284', '东山区', '445200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445285', '其它区', '445200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445300', '云浮市', '440000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445302', '云城区', '445300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445321', '新兴县', '445300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445322', '郁南县', '445300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445323', '云安县', '445300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445381', '罗定市', '445300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('445382', '其它区', '445300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450000', '广西壮族自治区', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450100', '南宁市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450102', '兴宁区', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450103', '青秀区', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450105', '江南区', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450107', '西乡塘区', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450108', '良庆区', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450109', '邕宁区', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450122', '武鸣县', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450123', '隆安县', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450124', '马山县', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450125', '上林县', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450126', '宾阳县', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450127', '横县', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450128', '其它区', '450100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450200', '柳州市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450202', '城中区', '450200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450203', '鱼峰区', '450200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450204', '柳南区', '450200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450205', '柳北区', '450200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450221', '柳江县', '450200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450222', '柳城县', '450200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450223', '鹿寨县', '450200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450224', '融安县', '450200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450225', '融水苗族自治县', '450200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450226', '三江侗族自治县', '450200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450227', '其它区', '450200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450300', '桂林市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450302', '秀峰区', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450303', '叠彩区', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450304', '象山区', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450305', '七星区', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450311', '雁山区', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450321', '阳朔县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450322', '临桂县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450323', '灵川县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450324', '全州县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450325', '兴安县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450326', '永福县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450327', '灌阳县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450328', '龙胜各族自治县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450329', '资源县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450330', '平乐县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450331', '荔浦县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450332', '恭城瑶族自治县', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450333', '其它区', '450300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450400', '梧州市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450403', '万秀区', '450400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450404', '蝶山区', '450400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450405', '长洲区', '450400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450421', '苍梧县', '450400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450422', '藤县', '450400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450423', '蒙山县', '450400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450481', '岑溪市', '450400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450482', '其它区', '450400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450500', '北海市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450502', '海城区', '450500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450503', '银海区', '450500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450512', '铁山港区', '450500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450521', '合浦县', '450500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450522', '其它区', '450500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450600', '防城港市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450602', '港口区', '450600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450603', '防城区', '450600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450621', '上思县', '450600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450681', '东兴市', '450600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450682', '其它区', '450600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450700', '钦州市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450702', '钦南区', '450700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450703', '钦北区', '450700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450721', '灵山县', '450700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450722', '浦北县', '450700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450723', '其它区', '450700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450800', '贵港市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450802', '港北区', '450800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450803', '港南区', '450800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450804', '覃塘区', '450800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450821', '平南县', '450800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450881', '桂平市', '450800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450882', '其它区', '450800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450900', '玉林市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450902', '玉州区', '450900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450921', '容县', '450900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450922', '陆川县', '450900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450923', '博白县', '450900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450924', '兴业县', '450900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450981', '北流市', '450900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('450982', '其它区', '450900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451000', '百色市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451002', '右江区', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451021', '田阳县', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451022', '田东县', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451023', '平果县', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451024', '德保县', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451025', '靖西县', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451026', '那坡县', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451027', '凌云县', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451028', '乐业县', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451029', '田林县', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451030', '西林县', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451031', '隆林各族自治县', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451032', '其它区', '451000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451100', '贺州市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451102', '八步区', '451100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451121', '昭平县', '451100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451122', '钟山县', '451100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451123', '富川瑶族自治县', '451100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451124', '其它区', '451100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451200', '河池市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451202', '金城江区', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451221', '南丹县', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451222', '天峨县', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451223', '凤山县', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451224', '东兰县', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451225', '罗城仫佬族自治县', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451226', '环江毛南族自治县', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451227', '巴马瑶族自治县', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451228', '都安瑶族自治县', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451229', '大化瑶族自治县', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451281', '宜州市', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451282', '其它区', '451200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451300', '来宾市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451302', '兴宾区', '451300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451321', '忻城县', '451300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451322', '象州县', '451300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451323', '武宣县', '451300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451324', '金秀瑶族自治县', '451300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451381', '合山市', '451300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451382', '其它区', '451300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451400', '崇左市', '450000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451402', '江洲区', '451400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451421', '扶绥县', '451400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451422', '宁明县', '451400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451423', '龙州县', '451400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451424', '大新县', '451400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451425', '天等县', '451400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451481', '凭祥市', '451400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('451482', '其它区', '451400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('460000', '海南省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('460100', '海口市', '460000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('460105', '秀英区', '460100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('460106', '龙华区', '460100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('460107', '琼山区', '460100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('460108', '美兰区', '460100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('460109', '其它区', '460100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('460200', '三亚市', '460000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469001', '五指山市', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469002', '琼海市', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469003', '儋州市', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469005', '文昌市', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469006', '万宁市', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469007', '东方市', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469025', '定安县', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469026', '屯昌县', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469027', '澄迈县', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469028', '临高县', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469030', '白沙黎族自治县', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469031', '昌江黎族自治县', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469033', '乐东黎族自治县', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469034', '陵水黎族自治县', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469035', '保亭黎族苗族自治县', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469036', '琼中黎族苗族自治县', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469037', '西沙群岛', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469038', '南沙群岛', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('469039', '中沙群岛的岛礁及其海域', '460000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('471004', '高新区', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('471005', '其它区', '410300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500000', '重庆', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500100', '重庆市', '500000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500101', '万州区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500102', '涪陵区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500103', '渝中区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500104', '大渡口区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500105', '江北区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500106', '沙坪坝区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500107', '九龙坡区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500108', '南岸区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500109', '北碚区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500110', '万盛区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500111', '双桥区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500112', '渝北区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500113', '巴南区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500114', '黔江区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500115', '长寿区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500222', '綦江县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500223', '潼南县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500224', '铜梁县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500225', '大足县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500226', '荣昌县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500227', '璧山县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500228', '梁平县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500229', '城口县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500230', '丰都县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500231', '垫江县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500232', '武隆县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500233', '忠县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500234', '开县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500235', '云阳县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500236', '奉节县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500237', '巫山县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500238', '巫溪县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500240', '石柱土家族自治县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500241', '秀山土家族苗族自治县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500242', '酉阳土家族苗族自治县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500243', '彭水苗族土家族自治县', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500381', '江津区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500382', '合川区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500383', '永川区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500384', '南川区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('500385', '其它区', '500100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510000', '四川省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510100', '成都市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510104', '锦江区', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510105', '青羊区', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510106', '金牛区', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510107', '武侯区', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510108', '成华区', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510112', '龙泉驿区', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510113', '青白江区', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510114', '新都区', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510115', '温江区', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510121', '金堂县', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510122', '双流县', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510124', '郫县', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510129', '大邑县', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510131', '蒲江县', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510132', '新津县', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510181', '都江堰市', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510182', '彭州市', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510183', '邛崃市', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510184', '崇州市', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510185', '其它区', '510100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510300', '自贡市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510302', '自流井区', '510300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510303', '贡井区', '510300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510304', '大安区', '510300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510311', '沿滩区', '510300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510321', '荣县', '510300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510322', '富顺县', '510300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510323', '其它区', '510300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510400', '攀枝花市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510402', '东区', '510400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510403', '西区', '510400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510411', '仁和区', '510400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510421', '米易县', '510400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510422', '盐边县', '510400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510423', '其它区', '510400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510500', '泸州市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510502', '江阳区', '510500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510503', '纳溪区', '510500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510504', '龙马潭区', '510500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510521', '泸县', '510500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510522', '合江县', '510500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510524', '叙永县', '510500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510525', '古蔺县', '510500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510526', '其它区', '510500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510600', '德阳市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510603', '旌阳区', '510600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510623', '中江县', '510600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510626', '罗江县', '510600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510681', '广汉市', '510600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510682', '什邡市', '510600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510683', '绵竹市', '510600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510684', '其它区', '510600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510700', '绵阳市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510703', '涪城区', '510700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510704', '游仙区', '510700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510722', '三台县', '510700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510723', '盐亭县', '510700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510724', '安县', '510700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510725', '梓潼县', '510700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510726', '北川羌族自治县', '510700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510727', '平武县', '510700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510751', '高新区', '510700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510781', '江油市', '510700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510782', '其它区', '510700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510800', '广元市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510802', '利州区', '510800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510811', '元坝区', '510800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510812', '朝天区', '510800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510821', '旺苍县', '510800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510822', '青川县', '510800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510823', '剑阁县', '510800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510824', '苍溪县', '510800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510825', '其它区', '510800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510900', '遂宁市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510903', '船山区', '510900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510904', '安居区', '510900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510921', '蓬溪县', '510900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510922', '射洪县', '510900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510923', '大英县', '510900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('510924', '其它区', '510900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511000', '内江市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511002', '市中区', '511000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511011', '东兴区', '511000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511024', '威远县', '511000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511025', '资中县', '511000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511028', '隆昌县', '511000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511029', '其它区', '511000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511100', '乐山市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511102', '市中区', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511111', '沙湾区', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511112', '五通桥区', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511113', '金口河区', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511123', '犍为县', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511124', '井研县', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511126', '夹江县', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511129', '沐川县', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511132', '峨边彝族自治县', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511133', '马边彝族自治县', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511181', '峨眉山市', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511182', '其它区', '511100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511300', '南充市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511302', '顺庆区', '511300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511303', '高坪区', '511300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511304', '嘉陵区', '511300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511321', '南部县', '511300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511322', '营山县', '511300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511323', '蓬安县', '511300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511324', '仪陇县', '511300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511325', '西充县', '511300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511381', '阆中市', '511300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511382', '其它区', '511300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511400', '眉山市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511402', '东坡区', '511400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511421', '仁寿县', '511400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511422', '彭山县', '511400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511423', '洪雅县', '511400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511424', '丹棱县', '511400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511425', '青神县', '511400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511426', '其它区', '511400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511500', '宜宾市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511502', '翠屏区', '511500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511521', '宜宾县', '511500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511522', '南溪县', '511500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511523', '江安县', '511500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511524', '长宁县', '511500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511525', '高县', '511500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511526', '珙县', '511500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511527', '筠连县', '511500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511528', '兴文县', '511500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511529', '屏山县', '511500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511530', '其它区', '511500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511600', '广安市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511602', '广安区', '511600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511621', '岳池县', '511600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511622', '武胜县', '511600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511623', '邻水县', '511600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511681', '华蓥市', '511600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511682', '市辖区', '511600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511683', '其它区', '511600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511700', '达州市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511702', '通川区', '511700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511721', '达县', '511700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511722', '宣汉县', '511700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511723', '开江县', '511700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511724', '大竹县', '511700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511725', '渠县', '511700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511781', '万源市', '511700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511782', '其它区', '511700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511800', '雅安市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511802', '雨城区', '511800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511821', '名山县', '511800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511822', '荥经县', '511800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511823', '汉源县', '511800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511824', '石棉县', '511800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511825', '天全县', '511800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511826', '芦山县', '511800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511827', '宝兴县', '511800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511828', '其它区', '511800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511900', '巴中市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511902', '巴州区', '511900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511921', '通江县', '511900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511922', '南江县', '511900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511923', '平昌县', '511900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('511924', '其它区', '511900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('512000', '资阳市', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('512002', '雁江区', '512000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('512021', '安岳县', '512000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('512022', '乐至县', '512000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('512081', '简阳市', '512000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('512082', '其它区', '512000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513200', '阿坝藏族羌族自治州', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513221', '汶川县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513222', '理县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513223', '茂县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513224', '松潘县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513225', '九寨沟县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513226', '金川县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513227', '小金县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513228', '黑水县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513229', '马尔康县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513230', '壤塘县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513231', '阿坝县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513232', '若尔盖县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513233', '红原县', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513234', '其它区', '513200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513300', '甘孜藏族自治州', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513321', '康定县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513322', '泸定县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513323', '丹巴县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513324', '九龙县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513325', '雅江县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513326', '道孚县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513327', '炉霍县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513328', '甘孜县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513329', '新龙县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513330', '德格县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513331', '白玉县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513332', '石渠县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513333', '色达县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513334', '理塘县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513335', '巴塘县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513336', '乡城县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513337', '稻城县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513338', '得荣县', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513339', '其它区', '513300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513400', '凉山彝族自治州', '510000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513401', '西昌市', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513422', '木里藏族自治县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513423', '盐源县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513424', '德昌县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513425', '会理县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513426', '会东县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513427', '宁南县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513428', '普格县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513429', '布拖县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513430', '金阳县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513431', '昭觉县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513432', '喜德县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513433', '冕宁县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513434', '越西县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513435', '甘洛县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513436', '美姑县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513437', '雷波县', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('513438', '其它区', '513400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520000', '贵州省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520100', '贵阳市', '520000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520102', '南明区', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520103', '云岩区', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520111', '花溪区', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520112', '乌当区', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520113', '白云区', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520114', '小河区', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520121', '开阳县', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520122', '息烽县', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520123', '修文县', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520151', '金阳开发区', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520181', '清镇市', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520182', '其它区', '520100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520200', '六盘水市', '520000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520201', '钟山区', '520200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520203', '六枝特区', '520200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520221', '水城县', '520200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520222', '盘县', '520200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520223', '其它区', '520200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520300', '遵义市', '520000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520302', '红花岗区', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520303', '汇川区', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520321', '遵义县', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520322', '桐梓县', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520323', '绥阳县', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520324', '正安县', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520325', '道真仡佬族苗族自治县', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520326', '务川仡佬族苗族自治县', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520327', '凤冈县', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520328', '湄潭县', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520329', '余庆县', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520330', '习水县', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520381', '赤水市', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520382', '仁怀市', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520383', '其它区', '520300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520400', '安顺市', '520000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520402', '西秀区', '520400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520421', '平坝县', '520400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520422', '普定县', '520400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520423', '镇宁布依族苗族自治县', '520400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520424', '关岭布依族苗族自治县', '520400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520425', '紫云苗族布依族自治县', '520400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('520426', '其它区', '520400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522200', '铜仁地区', '520000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522201', '铜仁市', '522200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522222', '江口县', '522200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522223', '玉屏侗族自治县', '522200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522224', '石阡县', '522200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522225', '思南县', '522200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522226', '印江土家族苗族自治县', '522200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522227', '德江县', '522200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522228', '沿河土家族自治县', '522200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522229', '松桃苗族自治县', '522200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522230', '万山特区', '522200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522231', '其它区', '522200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522300', '黔西南布依族苗族自治州', '520000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522301', '兴义市', '522300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522322', '兴仁县', '522300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522323', '普安县', '522300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522324', '晴隆县', '522300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522325', '贞丰县', '522300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522326', '望谟县', '522300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522327', '册亨县', '522300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522328', '安龙县', '522300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522329', '其它区', '522300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522400', '毕节地区', '520000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522401', '毕节市', '522400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522422', '大方县', '522400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522423', '黔西县', '522400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522424', '金沙县', '522400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522425', '织金县', '522400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522426', '纳雍县', '522400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522427', '威宁彝族回族苗族自治县', '522400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522428', '赫章县', '522400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522429', '其它区', '522400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522600', '黔东南苗族侗族自治州', '520000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522601', '凯里市', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522622', '黄平县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522623', '施秉县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522624', '三穗县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522625', '镇远县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522626', '岑巩县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522627', '天柱县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522628', '锦屏县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522629', '剑河县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522630', '台江县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522631', '黎平县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522632', '榕江县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522633', '从江县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522634', '雷山县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522635', '麻江县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522636', '丹寨县', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522637', '其它区', '522600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522700', '黔南布依族苗族自治州', '520000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522701', '都匀市', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522702', '福泉市', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522722', '荔波县', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522723', '贵定县', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522725', '瓮安县', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522726', '独山县', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522727', '平塘县', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522728', '罗甸县', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522729', '长顺县', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522730', '龙里县', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522731', '惠水县', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522732', '三都水族自治县', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('522733', '其它区', '522700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530000', '云南省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530100', '昆明市', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530102', '五华区', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530103', '盘龙区', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530111', '官渡区', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530112', '西山区', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530113', '东川区', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530121', '呈贡县', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530122', '晋宁县', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530124', '富民县', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530125', '宜良县', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530126', '石林彝族自治县', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530127', '嵩明县', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530128', '禄劝彝族苗族自治县', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530129', '寻甸回族彝族自治县', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530181', '安宁市', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530182', '其它区', '530100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530300', '曲靖市', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530302', '麒麟区', '530300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530321', '马龙县', '530300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530322', '陆良县', '530300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530323', '师宗县', '530300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530324', '罗平县', '530300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530325', '富源县', '530300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530326', '会泽县', '530300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530328', '沾益县', '530300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530381', '宣威市', '530300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530382', '其它区', '530300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530400', '玉溪市', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530402', '红塔区', '530400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530421', '江川县', '530400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530422', '澄江县', '530400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530423', '通海县', '530400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530424', '华宁县', '530400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530425', '易门县', '530400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530426', '峨山彝族自治县', '530400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530427', '新平彝族傣族自治县', '530400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530428', '元江哈尼族彝族傣族自治县', '530400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530429', '其它区', '530400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530500', '保山市', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530502', '隆阳区', '530500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530521', '施甸县', '530500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530522', '腾冲县', '530500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530523', '龙陵县', '530500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530524', '昌宁县', '530500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530525', '其它区', '530500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530600', '昭通市', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530602', '昭阳区', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530621', '鲁甸县', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530622', '巧家县', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530623', '盐津县', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530624', '大关县', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530625', '永善县', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530626', '绥江县', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530627', '镇雄县', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530628', '彝良县', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530629', '威信县', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530630', '水富县', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530631', '其它区', '530600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530700', '丽江市', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530702', '古城区', '530700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530721', '玉龙纳西族自治县', '530700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530722', '永胜县', '530700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530723', '华坪县', '530700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530724', '宁蒗彝族自治县', '530700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530725', '其它区', '530700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530800', '普洱市', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530802', '思茅区', '530800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530821', '宁洱哈尼族彝族自治县', '530800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530822', '墨江哈尼族自治县', '530800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530823', '景东彝族自治县', '530800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530824', '景谷傣族彝族自治县', '530800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530825', '镇沅彝族哈尼族拉祜族自治县', '530800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530826', '江城哈尼族彝族自治县', '530800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530827', '孟连傣族拉祜族佤族自治县', '530800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530828', '澜沧拉祜族自治县', '530800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530829', '西盟佤族自治县', '530800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530830', '其它区', '530800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530900', '临沧市', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530902', '临翔区', '530900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530921', '凤庆县', '530900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530922', '云县', '530900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530923', '永德县', '530900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530924', '镇康县', '530900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530925', '双江拉祜族佤族布朗族傣族自治县', '530900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530926', '耿马傣族佤族自治县', '530900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530927', '沧源佤族自治县', '530900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('530928', '其它区', '530900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532300', '楚雄彝族自治州', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532301', '楚雄市', '532300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532322', '双柏县', '532300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532323', '牟定县', '532300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532324', '南华县', '532300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532325', '姚安县', '532300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532326', '大姚县', '532300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532327', '永仁县', '532300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532328', '元谋县', '532300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532329', '武定县', '532300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532331', '禄丰县', '532300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532332', '其它区', '532300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532500', '红河哈尼族彝族自治州', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532501', '个旧市', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532502', '开远市', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532522', '蒙自县', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532523', '屏边苗族自治县', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532524', '建水县', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532525', '石屏县', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532526', '弥勒县', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532527', '泸西县', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532528', '元阳县', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532529', '红河县', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532530', '金平苗族瑶族傣族自治县', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532531', '绿春县', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532532', '河口瑶族自治县', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532533', '其它区', '532500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532600', '文山壮族苗族自治州', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532621', '文山县', '532600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532622', '砚山县', '532600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532623', '西畴县', '532600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532624', '麻栗坡县', '532600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532625', '马关县', '532600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532626', '丘北县', '532600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532627', '广南县', '532600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532628', '富宁县', '532600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532629', '其它区', '532600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532800', '西双版纳傣族自治州', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532801', '景洪市', '532800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532822', '勐海县', '532800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532823', '勐腊县', '532800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532824', '其它区', '532800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532900', '大理白族自治州', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532901', '大理市', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532922', '漾濞彝族自治县', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532923', '祥云县', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532924', '宾川县', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532925', '弥渡县', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532926', '南涧彝族自治县', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532927', '巍山彝族回族自治县', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532928', '永平县', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532929', '云龙县', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532930', '洱源县', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532931', '剑川县', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532932', '鹤庆县', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('532933', '其它区', '532900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533100', '德宏傣族景颇族自治州', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533102', '瑞丽市', '533100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533103', '潞西市', '533100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533122', '梁河县', '533100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533123', '盈江县', '533100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533124', '陇川县', '533100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533125', '其它区', '533100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533300', '怒江傈僳族自治州', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533321', '泸水县', '533300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533323', '福贡县', '533300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533324', '贡山独龙族怒族自治县', '533300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533325', '兰坪白族普米族自治县', '533300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533326', '其它区', '533300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533400', '迪庆藏族自治州', '530000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533421', '香格里拉县', '533400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533422', '德钦县', '533400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533423', '维西傈僳族自治县', '533400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('533424', '其它区', '533400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('540000', '西藏自治区', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('540100', '拉萨市', '540000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('540102', '城关区', '540100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('540121', '林周县', '540100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('540122', '当雄县', '540100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('540123', '尼木县', '540100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('540124', '曲水县', '540100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('540125', '堆龙德庆县', '540100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('540126', '达孜县', '540100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('540127', '墨竹工卡县', '540100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('540128', '其它区', '540100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542100', '昌都地区', '540000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542121', '昌都县', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542122', '江达县', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542123', '贡觉县', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542124', '类乌齐县', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542125', '丁青县', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542126', '察雅县', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542127', '八宿县', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542128', '左贡县', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542129', '芒康县', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542132', '洛隆县', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542133', '边坝县', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542134', '其它区', '542100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542200', '山南地区', '540000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542221', '乃东县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542222', '扎囊县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542223', '贡嘎县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542224', '桑日县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542225', '琼结县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542226', '曲松县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542227', '措美县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542228', '洛扎县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542229', '加查县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542231', '隆子县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542232', '错那县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542233', '浪卡子县', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542234', '其它区', '542200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542300', '日喀则地区', '540000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542301', '日喀则市', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542322', '南木林县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542323', '江孜县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542324', '定日县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542325', '萨迦县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542326', '拉孜县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542327', '昂仁县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542328', '谢通门县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542329', '白朗县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542330', '仁布县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542331', '康马县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542332', '定结县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542333', '仲巴县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542334', '亚东县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542335', '吉隆县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542336', '聂拉木县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542337', '萨嘎县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542338', '岗巴县', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542339', '其它区', '542300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542400', '那曲地区', '540000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542421', '那曲县', '542400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542422', '嘉黎县', '542400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542423', '比如县', '542400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542424', '聂荣县', '542400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542425', '安多县', '542400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542426', '申扎县', '542400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542427', '索县', '542400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542428', '班戈县', '542400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542429', '巴青县', '542400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542430', '尼玛县', '542400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542431', '其它区', '542400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542500', '阿里地区', '540000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542521', '普兰县', '542500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542522', '札达县', '542500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542523', '噶尔县', '542500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542524', '日土县', '542500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542525', '革吉县', '542500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542526', '改则县', '542500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542527', '措勤县', '542500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542528', '其它区', '542500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542600', '林芝地区', '540000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542621', '林芝县', '542600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542622', '工布江达县', '542600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542623', '米林县', '542600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542624', '墨脱县', '542600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542625', '波密县', '542600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542626', '察隅县', '542600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542627', '朗县', '542600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('542628', '其它区', '542600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610000', '陕西省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610100', '西安市', '610000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610102', '新城区', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610103', '碑林区', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610104', '莲湖区', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610111', '灞桥区', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610112', '未央区', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610113', '雁塔区', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610114', '阎良区', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610115', '临潼区', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610116', '长安区', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610122', '蓝田县', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610124', '周至县', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610125', '户县', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610126', '高陵县', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610127', '其它区', '610100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610200', '铜川市', '610000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610202', '王益区', '610200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610203', '印台区', '610200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610204', '耀州区', '610200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610222', '宜君县', '610200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610223', '其它区', '610200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610300', '宝鸡市', '610000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610302', '渭滨区', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610303', '金台区', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610304', '陈仓区', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610322', '凤翔县', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610323', '岐山县', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610324', '扶风县', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610326', '眉县', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610327', '陇县', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610328', '千阳县', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610329', '麟游县', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610330', '凤县', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610331', '太白县', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610332', '其它区', '610300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610400', '咸阳市', '610000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610402', '秦都区', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610403', '杨陵区', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610404', '渭城区', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610422', '三原县', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610423', '泾阳县', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610424', '乾县', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610425', '礼泉县', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610426', '永寿县', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610427', '彬县', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610428', '长武县', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610429', '旬邑县', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610430', '淳化县', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610431', '武功县', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610481', '兴平市', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610482', '其它区', '610400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610500', '渭南市', '610000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610502', '临渭区', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610521', '华县', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610522', '潼关县', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610523', '大荔县', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610524', '合阳县', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610525', '澄城县', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610526', '蒲城县', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610527', '白水县', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610528', '富平县', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610581', '韩城市', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610582', '华阴市', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610583', '其它区', '610500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610600', '延安市', '610000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610602', '宝塔区', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610621', '延长县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610622', '延川县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610623', '子长县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610624', '安塞县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610625', '志丹县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610626', '吴起县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610627', '甘泉县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610628', '富县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610629', '洛川县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610630', '宜川县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610631', '黄龙县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610632', '黄陵县', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610633', '其它区', '610600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610700', '汉中市', '610000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610702', '汉台区', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610721', '南郑县', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610722', '城固县', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610723', '洋县', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610724', '西乡县', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610725', '勉县', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610726', '宁强县', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610727', '略阳县', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610728', '镇巴县', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610729', '留坝县', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610730', '佛坪县', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610731', '其它区', '610700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610800', '榆林市', '610000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610802', '榆阳区', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610821', '神木县', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610822', '府谷县', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610823', '横山县', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610824', '靖边县', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610825', '定边县', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610826', '绥德县', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610827', '米脂县', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610828', '佳县', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610829', '吴堡县', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610830', '清涧县', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610831', '子洲县', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610832', '其它区', '610800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610900', '安康市', '610000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610902', '汉滨区', '610900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610921', '汉阴县', '610900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610922', '石泉县', '610900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610923', '宁陕县', '610900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610924', '紫阳县', '610900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610925', '岚皋县', '610900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610926', '平利县', '610900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610927', '镇坪县', '610900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610928', '旬阳县', '610900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610929', '白河县', '610900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('610930', '其它区', '610900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('611000', '商洛市', '610000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('611002', '商州区', '611000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('611021', '洛南县', '611000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('611022', '丹凤县', '611000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('611023', '商南县', '611000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('611024', '山阳县', '611000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('611025', '镇安县', '611000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('611026', '柞水县', '611000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('611027', '其它区', '611000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620000', '甘肃省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620100', '兰州市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620102', '城关区', '620100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620103', '七里河区', '620100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620104', '西固区', '620100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620105', '安宁区', '620100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620111', '红古区', '620100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620121', '永登县', '620100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620122', '皋兰县', '620100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620123', '榆中县', '620100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620124', '其它区', '620100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620200', '嘉峪关市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620300', '金昌市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620302', '金川区', '620300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620321', '永昌县', '620300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620322', '其它区', '620300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620400', '白银市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620402', '白银区', '620400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620403', '平川区', '620400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620421', '靖远县', '620400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620422', '会宁县', '620400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620423', '景泰县', '620400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620424', '其它区', '620400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620500', '天水市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620502', '秦州区', '620500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620503', '麦积区', '620500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620521', '清水县', '620500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620522', '秦安县', '620500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620523', '甘谷县', '620500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620524', '武山县', '620500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620525', '张家川回族自治县', '620500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620526', '其它区', '620500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620600', '武威市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620602', '凉州区', '620600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620621', '民勤县', '620600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620622', '古浪县', '620600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620623', '天祝藏族自治县', '620600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620624', '其它区', '620600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620700', '张掖市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620702', '甘州区', '620700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620721', '肃南裕固族自治县', '620700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620722', '民乐县', '620700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620723', '临泽县', '620700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620724', '高台县', '620700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620725', '山丹县', '620700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620726', '其它区', '620700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620800', '平凉市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620802', '崆峒区', '620800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620821', '泾川县', '620800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620822', '灵台县', '620800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620823', '崇信县', '620800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620824', '华亭县', '620800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620825', '庄浪县', '620800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620826', '静宁县', '620800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620827', '其它区', '620800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620900', '酒泉市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620902', '肃州区', '620900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620921', '金塔县', '620900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620922', '安西县', '620900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620923', '肃北蒙古族自治县', '620900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620924', '阿克塞哈萨克族自治县', '620900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620981', '玉门市', '620900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620982', '敦煌市', '620900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('620983', '其它区', '620900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621000', '庆阳市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621002', '西峰区', '621000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621021', '庆城县', '621000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621022', '环县', '621000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621023', '华池县', '621000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621024', '合水县', '621000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621025', '正宁县', '621000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621026', '宁县', '621000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621027', '镇原县', '621000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621028', '其它区', '621000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621100', '定西市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621102', '安定区', '621100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621121', '通渭县', '621100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621122', '陇西县', '621100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621123', '渭源县', '621100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621124', '临洮县', '621100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621125', '漳县', '621100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621126', '岷县', '621100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621127', '其它区', '621100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621200', '陇南市', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621202', '武都区', '621200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621221', '成县', '621200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621222', '文县', '621200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621223', '宕昌县', '621200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621224', '康县', '621200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621225', '西和县', '621200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621226', '礼县', '621200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621227', '徽县', '621200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621228', '两当县', '621200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('621229', '其它区', '621200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('622900', '临夏回族自治州', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('622901', '临夏市', '622900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('622921', '临夏县', '622900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('622922', '康乐县', '622900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('622923', '永靖县', '622900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('622924', '广河县', '622900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('622925', '和政县', '622900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('622926', '东乡族自治县', '622900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('622927', '积石山保安族东乡族撒拉族自治县', '622900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('622928', '其它区', '622900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('623000', '甘南藏族自治州', '620000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('623001', '合作市', '623000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('623021', '临潭县', '623000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('623022', '卓尼县', '623000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('623023', '舟曲县', '623000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('623024', '迭部县', '623000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('623025', '玛曲县', '623000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('623026', '碌曲县', '623000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('623027', '夏河县', '623000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('623028', '其它区', '623000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('630000', '青海省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('630100', '西宁市', '630000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('630102', '城东区', '630100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('630103', '城中区', '630100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('630104', '城西区', '630100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('630105', '城北区', '630100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('630121', '大通回族土族自治县', '630100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('630122', '湟中县', '630100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('630123', '湟源县', '630100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('630124', '其它区', '630100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632100', '海东地区', '630000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632121', '平安县', '632100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632122', '民和回族土族自治县', '632100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632123', '乐都县', '632100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632126', '互助土族自治县', '632100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632127', '化隆回族自治县', '632100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632128', '循化撒拉族自治县', '632100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632129', '其它区', '632100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632200', '海北藏族自治州', '630000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632221', '门源回族自治县', '632200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632222', '祁连县', '632200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632223', '海晏县', '632200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632224', '刚察县', '632200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632225', '其它区', '632200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632300', '黄南藏族自治州', '630000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632321', '同仁县', '632300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632322', '尖扎县', '632300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632323', '泽库县', '632300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632324', '河南蒙古族自治县', '632300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632325', '其它区', '632300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632500', '海南藏族自治州', '630000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632521', '共和县', '632500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632522', '同德县', '632500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632523', '贵德县', '632500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632524', '兴海县', '632500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632525', '贵南县', '632500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632526', '其它区', '632500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632600', '果洛藏族自治州', '630000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632621', '玛沁县', '632600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632622', '班玛县', '632600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632623', '甘德县', '632600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632624', '达日县', '632600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632625', '久治县', '632600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632626', '玛多县', '632600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632627', '其它区', '632600', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632700', '玉树藏族自治州', '630000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632721', '玉树县', '632700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632722', '杂多县', '632700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632723', '称多县', '632700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632724', '治多县', '632700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632725', '囊谦县', '632700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632726', '曲麻莱县', '632700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632727', '其它区', '632700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632800', '海西蒙古族藏族自治州', '630000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632801', '格尔木市', '632800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632802', '德令哈市', '632800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632821', '乌兰县', '632800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632822', '都兰县', '632800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632823', '天峻县', '632800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('632824', '其它区', '632800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640000', '宁夏回族自治区', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640100', '银川市', '640000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640104', '兴庆区', '640100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640105', '西夏区', '640100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640106', '金凤区', '640100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640121', '永宁县', '640100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640122', '贺兰县', '640100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640181', '灵武市', '640100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640182', '其它区', '640100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640200', '石嘴山市', '640000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640202', '大武口区', '640200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640205', '惠农区', '640200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640221', '平罗县', '640200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640222', '其它区', '640200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640300', '吴忠市', '640000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640302', '利通区', '640300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640303', '红寺堡区', '640300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640323', '盐池县', '640300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640324', '同心县', '640300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640381', '青铜峡市', '640300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640382', '其它区', '640300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640400', '固原市', '640000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640402', '原州区', '640400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640422', '西吉县', '640400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640423', '隆德县', '640400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640424', '泾源县', '640400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640425', '彭阳县', '640400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640426', '其它区', '640400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640500', '中卫市', '640000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640502', '沙坡头区', '640500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640521', '中宁县', '640500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640522', '海原县', '640500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('640523', '其它区', '640500', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650000', '新疆维吾尔自治区', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650100', '乌鲁木齐市', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650102', '天山区', '650100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650103', '沙依巴克区', '650100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650104', '新市区', '650100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650105', '水磨沟区', '650100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650106', '头屯河区', '650100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650107', '达坂城区', '650100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650108', '东山区', '650100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650109', '米东区', '650100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650121', '乌鲁木齐县', '650100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650122', '其它区', '650100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650200', '克拉玛依市', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650202', '独山子区', '650200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650203', '克拉玛依区', '650200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650204', '白碱滩区', '650200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650205', '乌尔禾区', '650200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('650206', '其它区', '650200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652100', '吐鲁番地区', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652101', '吐鲁番市', '652100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652122', '鄯善县', '652100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652123', '托克逊县', '652100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652124', '其它区', '652100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652200', '哈密地区', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652201', '哈密市', '652200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652222', '巴里坤哈萨克自治县', '652200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652223', '伊吾县', '652200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652224', '其它区', '652200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652300', '昌吉回族自治州', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652301', '昌吉市', '652300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652302', '阜康市', '652300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652303', '米泉市', '652300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652323', '呼图壁县', '652300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652324', '玛纳斯县', '652300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652325', '奇台县', '652300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652327', '吉木萨尔县', '652300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652328', '木垒哈萨克自治县', '652300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652329', '其它区', '652300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652700', '博尔塔拉蒙古自治州', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652701', '博乐市', '652700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652722', '精河县', '652700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652723', '温泉县', '652700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652724', '其它区', '652700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652800', '巴音郭楞蒙古自治州', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652801', '库尔勒市', '652800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652822', '轮台县', '652800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652823', '尉犁县', '652800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652824', '若羌县', '652800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652825', '且末县', '652800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652826', '焉耆回族自治县', '652800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652827', '和静县', '652800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652828', '和硕县', '652800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652829', '博湖县', '652800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652830', '其它区', '652800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652900', '阿克苏地区', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652901', '阿克苏市', '652900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652922', '温宿县', '652900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652923', '库车县', '652900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652924', '沙雅县', '652900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652925', '新和县', '652900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652926', '拜城县', '652900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652927', '乌什县', '652900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652928', '阿瓦提县', '652900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652929', '柯坪县', '652900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('652930', '其它区', '652900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653000', '克孜勒苏柯尔克孜自治州', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653001', '阿图什市', '653000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653022', '阿克陶县', '653000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653023', '阿合奇县', '653000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653024', '乌恰县', '653000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653025', '其它区', '653000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653100', '喀什地区', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653101', '喀什市', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653121', '疏附县', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653122', '疏勒县', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653123', '英吉沙县', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653124', '泽普县', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653125', '莎车县', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653126', '叶城县', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653127', '麦盖提县', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653128', '岳普湖县', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653129', '伽师县', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653130', '巴楚县', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653131', '塔什库尔干塔吉克自治县', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653132', '其它区', '653100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653200', '和田地区', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653201', '和田市', '653200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653221', '和田县', '653200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653222', '墨玉县', '653200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653223', '皮山县', '653200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653224', '洛浦县', '653200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653225', '策勒县', '653200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653226', '于田县', '653200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653227', '民丰县', '653200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('653228', '其它区', '653200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654000', '伊犁哈萨克自治州', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654002', '伊宁市', '654000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654003', '奎屯市', '654000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654021', '伊宁县', '654000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654022', '察布查尔锡伯自治县', '654000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654023', '霍城县', '654000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654024', '巩留县', '654000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654025', '新源县', '654000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654026', '昭苏县', '654000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654027', '特克斯县', '654000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654028', '尼勒克县', '654000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654029', '其它区', '654000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654200', '塔城地区', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654201', '塔城市', '654200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654202', '乌苏市', '654200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654221', '额敏县', '654200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654223', '沙湾县', '654200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654224', '托里县', '654200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654225', '裕民县', '654200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654226', '和布克赛尔蒙古自治县', '654200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654227', '其它区', '654200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654300', '阿勒泰地区', '650000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654301', '阿勒泰市', '654300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654321', '布尔津县', '654300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654322', '富蕴县', '654300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654323', '福海县', '654300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654324', '哈巴河县', '654300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654325', '青河县', '654300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654326', '吉木乃县', '654300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('654327', '其它区', '654300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('659001', '石河子市', '650000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('659002', '阿拉尔市', '650000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('659003', '图木舒克市', '650000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('659004', '五家渠市', '650000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710000', '台湾省', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710100', '台北市', '710000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710101', '中正区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710102', '大同区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710103', '中山区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710104', '松山区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710105', '大安区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710106', '万华区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710107', '信义区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710108', '士林区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710109', '北投区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710110', '内湖区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710111', '南港区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710112', '文山区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710113', '其它区', '710100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710200', '高雄市', '710000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710201', '新兴区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710202', '前金区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710203', '芩雅区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710204', '盐埕区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710205', '鼓山区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710206', '旗津区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710207', '前镇区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710208', '三民区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710209', '左营区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710210', '楠梓区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710211', '小港区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710212', '其它区', '710200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710300', '台南市', '710000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710301', '中西区', '710300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710302', '东区', '710300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710303', '南区', '710300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710304', '北区', '710300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710305', '安平区', '710300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710306', '安南区', '710300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710307', '其它区', '710300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710400', '台中市', '710000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710401', '中区', '710400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710402', '东区', '710400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710403', '南区', '710400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710404', '西区', '710400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710405', '北区', '710400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710406', '北屯区', '710400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710407', '西屯区', '710400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710408', '南屯区', '710400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710409', '其它区', '710400', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710500', '金门县', '710000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710600', '南投县', '710000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710700', '基隆市', '710000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710701', '仁爱区', '710700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710702', '信义区', '710700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710703', '中正区', '710700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710704', '中山区', '710700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710705', '安乐区', '710700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710706', '暖暖区', '710700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710707', '七堵区', '710700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710708', '其它区', '710700', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710800', '新竹市', '710000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710801', '东区', '710800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710802', '北区', '710800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710803', '香山区', '710800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710804', '其它区', '710800', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710900', '嘉义市', '710000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710901', '东区', '710900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710902', '西区', '710900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('710903', '其它区', '710900', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('711100', '新北市', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('711200', '宜兰县', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('711300', '新竹县', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('711400', '桃园县', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('711500', '苗栗县', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('711700', '彰化县', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('711900', '嘉义县', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('712100', '云林县', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('712400', '屏东县', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('712500', '台东县', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('712600', '花莲县', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('712700', '澎湖县', '710000', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810000', '香港特别行政区', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810100', '香港岛', '810000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810101', '中西区', '810100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810102', '湾仔', '810100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810103', '东区', '810100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810104', '南区', '810100', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810200', '九龙', '810000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810201', '九龙城区', '810200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810202', '油尖旺区', '810200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810203', '深水埗区', '810200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810204', '黄大仙区', '810200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810205', '观塘区', '810200', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810300', '新界', '810000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810301', '北区', '810300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810302', '大埔区', '810300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810303', '沙田区', '810300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810304', '西贡区', '810300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810305', '元朗区', '810300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810306', '屯门区', '810300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810307', '荃湾区', '810300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810308', '葵青区', '810300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('810309', '离岛区', '810300', '0', '4', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('820000', '澳门特别行政区', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('820100', '澳门半岛', '820000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('820200', '离岛', '820000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('990000', '海外', '1', '0', '2', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('990100', '海外', '990000', '0', '3', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_city` VALUES ('1032709', '海外', '-1', '0', '0', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_config` VALUES ('1', 'ADMIN_ACCESS', 'EXPIRED_TIME', '500', '登陆超时时间', '2013-05-03 02:25:45', '0000-00-00 00:00:00');
INSERT INTO `ivears_config` VALUES ('2', 'ADMIN_ACCESS', 'SYS_ADMIN', 'admin', '系统管理员', '2013-03-25 16:43:50', '0000-00-00 00:00:00');
INSERT INTO `ivears_config` VALUES ('3', '', '', null, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `ivears_config` VALUES ('5', 'CODE_SET', 'MREGISTER', '1', '会员注册', '2014-04-26 22:08:08', '2014-04-26 22:08:08');
INSERT INTO `ivears_config` VALUES ('6', 'CODE_SET', 'RELOGIN', '1', '前台登陆', '2014-04-26 22:08:08', '2014-04-26 22:08:08');
INSERT INTO `ivears_config` VALUES ('7', 'CODE_SET', 'BALOGIN', '1', '后台登陆', '2014-04-26 22:08:08', '2014-04-26 22:08:08');
INSERT INTO `ivears_config` VALUES ('8', 'CODE_SET', 'BUILDTYPE', '1', '验证码生成类型', '2014-04-26 22:08:08', '2014-04-26 22:08:08');
INSERT INTO `ivears_config` VALUES ('9', 'CODE_SET', 'EXPANDTYPE', 'png', '选择验证码文件类型', '2014-04-26 22:08:08', '2014-04-26 22:08:08');
INSERT INTO `ivears_config` VALUES ('10', 'CODE_SET', 'RECODESIZE', '{\"width\":\"70\",\"height\":\"30\"}', '前台验证码图片大小', '2014-04-26 22:08:08', '2014-04-26 22:08:08');
INSERT INTO `ivears_config` VALUES ('11', 'CODE_SET', 'BACODESIZE', '{\"width\":\"60\",\"height\":\"25\"}', '后台验证码图片大小', '2014-04-26 22:08:08', '2014-04-26 22:08:08');
INSERT INTO `ivears_config` VALUES ('12', 'CODE_SET', 'RECODENUMS', '4', '前台验证码字数', '2014-04-26 22:08:08', '2014-04-26 22:08:08');
INSERT INTO `ivears_config` VALUES ('13', 'CODE_SET', 'BACODENUMS', '4', '后台验证码字数', '2014-04-26 22:08:08', '2014-04-26 22:08:08');
INSERT INTO `ivears_config` VALUES ('14', 'MAILSET', 'MAILSET', '{\"email_type\":\"1\",\"mail_address\":\"info@ivears.com\",\"smtp\":\"ym.smtp.163.com\",\"smtp_user\":\"info@ivears.com\",\"smtp_pwd\":\"11111111\",\"smtp_port\":\"25\",\"test_address\":\"info@ivears.com\"}', '站点信息配置', '2015-11-27 07:49:09', '2015-11-27 07:49:09');
INSERT INTO `ivears_config` VALUES ('15', 'WEBSITE', 'WEBSITE', '{\"site_weburl\":\"http:\\/\\/www.e.com\\/\",\"site_name\":\"IVEARS\\u6210\\u90fd\\u827e\\u5a01\\u5c14\\u7f51\\u7edc\\u79d1\\u6280\\u6709\\u9650\\u516c\\u53f8\",\"site_title\":\"IVEARS\\u6a21\\u677f\\u7f51\\u7ad9\",\"site_keyword\":\"IVEARS\\u6a21\\u677f\\u7f51\\u7ad9,IVEARS,\\u6210\\u90fd\\u827e\\u5a01\\u5c14\\u7f51\\u7edcwww.ivears.com\",\"site_description\":\"IVEARS\\u6a21\\u677f\\u7f51\\u7ad9,IVEARS,\\u6210\\u90fd\\u827e\\u5a01\\u5c14\\u7f51\\u7edcwww.ivears.com\",\"site_icp\":\"\\u8700ICP\\u59078888888\\u53f7\",\"site_400\":\"400-886-3878\",\"site_tel\":\"028-65278981\",\"site_mobile\":\"13880713476\",\"site_email\":\"905873908@qq.com\",\"site_address\":\"\\u56db\\u5ddd\\u6210\\u90fd\\u9ad8\\u65b0\\u533a\\u5929\\u5e9c\\u5927\\u9053\\u73af\\u7403\\u4e2d\\u5fc3W5-1806\",\"site_code\":\"\",\"site_301\":\"0\",\"site_status\":\"1\",\"site_close\":\"sadf\"}', '站点信息配置', '2015-11-29 15:29:15', '2015-11-29 15:29:15');
INSERT INTO `ivears_config` VALUES ('16', 'pay_conf', 'pay_conf', '{\"alipay_id\":\"3423423423423234\",\"alipay_email\":\"wangxiaobo23@eyou.com\",\"alipay_key\":\"asdfasdfasdfasfd\"}', '站点信息配置', '2014-04-16 12:00:22', '2014-04-16 12:00:22');
INSERT INTO `ivears_imagelist` VALUES ('35', '0', '图片轮换', '/Public/Default/Images/20150428051758814.jpg', 'http://www.ivears.com/', '', null, '0', '1', '2015-12-03 22:11:09', '2015-12-08 18:07:36');
INSERT INTO `ivears_imagelist` VALUES ('39', '0', ' 成都艾威尔网络', '/Public/Default/Images/20150428051758814.jpg', 'http://www.ivears.com/', '', null, '0', '1', '2015-12-08 17:57:56', '2015-12-08 18:07:31');
INSERT INTO `ivears_links` VALUES ('61', '成都网站建设', '', 'http://www.ivears.com/', '', null, '0', '10', '1', '2015-12-03 22:19:30', '0000-00-00 00:00:00');
INSERT INTO `ivears_member_level` VALUES ('1', '普通会员', '普通会员介绍', '1', '0', null, '0000-00-00 00:00:00', '2014-04-17 09:13:51');
INSERT INTO `ivears_member_level` VALUES ('3', '金牌会员', '金牌会员', '1', '0', 'upload/images/20140417/13977188227305.jpg', '2014-04-17 13:55:30', '2014-04-17 15:13:46');
INSERT INTO `ivears_members` VALUES ('1', '1', 'test11', '快乐DE小子', '', '幼儿姓名', '138808122132', '家长姓名', 'f696282aa4cd4f614aa995190cf442fe', '3', '0', '0.00', '1', null, '0', '2013-12-12', 'admin@ivears.com', '这家伙什么都没有……', '127.0.0.1', '2014-06-07 16:40:13', null, null, '0', '1', '2013-08-31 09:54:40', '127.0.0.1', '466209365', '0', '2014-06-05 14:15:31');
INSERT INTO `ivears_members` VALUES ('6', '1', 'test22', 'test22', 'test22', '幼儿', '138808122132', '家长', '4d42bf9c18cb04139f918ff0ae68f8a0', null, null, '0.00', '0', null, '0', '0000-00-00', 'asd@126.com', null, null, '2014-06-05 14:25:51', null, null, '0', '1', '2014-06-05 14:24:54', '', null, '0', '2014-06-05 14:25:51');
INSERT INTO `ivears_message_tpl` VALUES ('1', 'mail', '找回密码', 'findpwd', '<p>\r\n	尊敬的{$username}:\r\n</p>\r\n<p style=\"padding-left:30px;\">\r\n	您好, 您刚才在 {$site_name} 申请了重置密码，请点击下面的链接进行重置：\r\n</p>\r\n<p style=\"padding-left:30px;\">\r\n	<a href=\"{$reset_url}\">{$reset_url}</a> \r\n</p>\r\n<p style=\"padding-left:30px;\">\r\n	此链接只能使用一次, 如果失效请重新申请. 如果以上链接无法点击，请将它拷贝到浏览器(例如IE)的地址栏中。\r\n</p>\r\n<p style=\"text-align:right;\">\r\n	{$site_name}\r\n</p>\r\n<p style=\"text-align:right;\">\r\n	{$send_time}\r\n</p>', '1', '1', '2013-08-31 08:28:04', '2013-08-31 09:00:43');
INSERT INTO `ivears_nav` VALUES ('1', '首页', 'index', 'http://www.baidu.com', '10', 'main', '1', '1', '2013-05-18 16:00:00', '2013-05-18 16:00:00');
INSERT INTO `ivears_nav` VALUES ('2', '留言', 'guestbook', '/Guestbook', '10', 'main', '0', '1', '2013-05-29 09:29:33', '0000-00-00 00:00:00');
INSERT INTO `ivears_oauth` VALUES ('1', 'Sina', '新浪微薄登录11', '{\"app_key\":\"\",\"app_secret\":\"\"}', '申请地址：http://open.weibo.com/', '10', '1', 'HUICMS研发团队', '1.0');
INSERT INTO `ivears_oauth` VALUES ('2', 'Tqq', 'QQ微博登录', '{\"app_key\":\"\",\"app_secret\":\"\"}', '申请地址：http://open.t.qq.com/', '10', '1', 'HuiCms研发团队', '1.0');
INSERT INTO `ivears_orders` VALUES ('9', '1432361063338', '王先生', '13219008637', '成都市二环路北三段新空间美壳装饰城5-17', '21', '2吨防爆手拉单轨行车', '1231.00', 'false', 'asdfasdf', '127.0.0.1', '1432361063');
INSERT INTO `ivears_page` VALUES ('88', '关于我们', 'About', '86', '<p style=\"text-align:left;\">\r\n	<img src=\"/Upload/image/20151208/20151208175516_16100.jpg\" alt=\"\" width=\"270\" height=\"270\" title=\"\" align=\"left\" />某某有限公司致力于XX业的发展，专业从事集中润滑系统的研究、开发、制造及销售，凭借公司强大的技术力量和经济实力，不断开发出具有国际先进技术水平的新产品。公司产品广泛适用于数控机械、加工中心、生产线、机床、锻压、纺织、塑料、橡胶、矿山、冶金、建筑、印刷、化工、制药、铸造、食品等各行业的机械设备及大型车辆底盘的集中润滑系统。\r\n</p>\r\n<p>\r\n	<br />\r\n</p>', '0', '1', '', '', '', '2015-08-25 23:21:39', '2015-12-08 18:00:22');
INSERT INTO `ivears_page` VALUES ('90', '公司简介', 'Company', '86', '中国社科院昨天发布2011年《企业社会责任蓝皮书》，对国有、民营和外资企业百强的社会责任发展水平进行大排行。令人尴尬的是，上述企业的平均得分仅为19.7分，三分之二的企业处于“旁观”地位，超过八成的A股上市企业发布的社会责任报告不及格。\r\n　　国企百强的社会责任尚处于起步阶段，平均得分为32.8分，近半国企在旁观;民企百强平均分仅为13.3分，八成在旁观;外企百强平均分仅为12.5分，近八成在旁观。(11月9日 中国网)\r\n　　不得不说，这是一个很让人泄气的统计结果：超过八成的A股上市企业发布的社会责任报告不及格，民企百强八成在旁观，外企百强也是八成在旁观……这样一个让人尴尬的统计数据与其说让这些企业脸红，莫不如说让相关的政府管理部门更脸红。因为当大部分国企、民企、外企都对企业社会责任选择了袖手旁观、漠不关心的时候，只能说明一个问题：我们的社会管理在某些方面出了问题，而且是让企业失去奉献社会责任的大问题。\r\n　　企业社会责任是什么?它是一个企业在创造利润、对股东承担法律责任的同时，承担对员工、消费者、社区和环境的责任。特别是在当代信息社会和工业社会交融的局面下，更是要求企业超越把利润作为唯一目标的传统理念，专注社会责任建设，更加重视在生产过程中对人的价值的关注，对消费者、对环境、对社会的贡献。这是一个现代企业发展的基本“立身”之道，西方国家的大多数企业在实现发展的同时也都遵循这样的理念——惠及民众，反哺社会。\r\n　　“橘生淮南则为橘，生于淮北则为枳”，为什么在西方国家乖乖履行企业社会责任的外资企业到了中国以后就显得那么缺乏社会责任呢，为什么那么多财大气粗的国企和民企也都捂着荷包不想尽一份社会责任呢，我们是不是要从企业的一些顾虑来找找原因呢。\r\n　　首先，这些企业之所以缺乏社会责任感，很重要的一个原因是怕太出名。应该说，对一个企业来说，通过履行社会责任出名是件好事，但在目前的一些地方微观环境里，企业的社会责任尽的太到位了，可能会引来其他的一些麻烦，诸如乡镇政府拉赞助、让你掏钱修路等各种名目的“责任”就都来了，所以很多企业宁愿选择不慈善、不捐助，闷声大发财，而不去惹这样的麻烦。\r\n　　其次，由于一些企业的年度财务报告并不是很透明，在企业社会责任的相关活动中，势必要涉及到一些费用开支，如何处理财务清晰度和股东之间的意见不统一问题也是很麻烦的事，很多企业老总还是本着多一事不如少一事的目的，“低调”做人做事。\r\n　　还有就是目前的对于企业社会责任工作做的比较好的企业，国家相关的优惠和奖励政策不规范，不透明，没有一个统一可预期的标准也是很多企业不想尽社会责任的原因。如果企业因为在就业、社会福利、环境保护方面有突出贡献，政府方面能通过减税等政策加以鼓励，并且严格禁止各种摊派和检查，让企业能顺畅的开展日常生产，相信会有很多企业会因为政策优惠的“诱惑”而积极参加到公益、慈善等社会责任活动来。\r\n　　其实说到社会责任，按照目前严峻的就业形势来说，如果说一个企业能正常经营，维持利润率，解决一部分就业人群，让工人能及时发到工资，该涨工资就涨工资，笔者认为，这也算是尽到了社会责任。反倒是那些凭借垄断地位获取暴利到处撒钱“尽社会责任”的大型国企，该好好反思反思这社会责任尽的水分有多大，是不是该适时的“瘦瘦身”，给民企一些发展空间和利润，让它们也能分一杯羹，更好的解决城市就业，更好的履行社会责任，如果真能如此，相信那时候的企业责任统计数据不会像现在这样让人脸上发烧', '0', '1', '', '', '', '2015-08-25 23:24:22', '2015-11-27 08:56:10');
INSERT INTO `ivears_page` VALUES ('91', '联系我们', '联系我们', '0', '<span style=\"font-size:24px;\">成都艾威尔网络科技有限公司 </span> <br />\r\n<p>\r\n	四川成都高新区天府大道环球中心W5-1806地铁1号线 锦城广场下 <br />\r\n电话：028&nbsp;-65278981<br />\r\n客服热线：400-886-3878\r\n</p>\r\n<p>\r\n	<span>技术咨询QQ：905873908</span> \r\n</p>', '0', '1', '', '', '', '2015-08-26 15:50:31', '2015-12-07 18:19:59');
INSERT INTO `ivears_page` VALUES ('87', '企业文化', 'Culture', '86', '<p style=\"text-align:left;\">\r\n	某某有限公司致力于XX业的发展，专业从事集中润滑系统的研究、开发、制造及销售，凭借公司强大的技术力量和经济实力，不断开发出具有国际先进技术水平的新产品。公司产品广泛适用于数控机械、加工中心、生产线、机床、锻压、纺织、塑料、橡胶、矿山、冶金、建筑、印刷、化工、制药、铸造、食品等各行业的机械设备及大型车辆底盘的集中润滑系统。\r\n</p>\r\n<p>\r\n	公司总部设在xxx，在全国各大城市设有分支机构，服务网络遍及全国。公司内部实行网络化管理，依托先进的计算机辅助设计系统和计算机管理系统，实现规范化运作，在最短的时间内为用户提供高品质的产品。\r\n</p>\r\n<p>\r\n	公司本着技术领先、质量第一、客户至上的原则为广大用户提供满意的服务。\r\n</p>\r\n<p>\r\n	目前公司为国内、外超过2万家的企业提供了网站建设、域名、邮件服务、虚拟主机、网站托管服务，同时为近千家的企业设计开发了基于互联网的各类商务应用和管理软件，是国内具影响力的互联网应用服务商之一。公司将坚持客户导向、应用为本的策略，继续专注于在信息技术领域开拓发展成为企业、政府、家庭信息化的推动者和服务者。正道将秉承\"和谐、参与、激情\"的文化，与客户和合作伙伴齐心协力一起成长，共同发展。 　　公司自2000年创立以来，积极进取，不断创新，凭借良好的企业信誉，独特的经营风格及较强的市场开拓能力，取得了一个又一个的骄人业绩。数年来，xx快速稳健的发展，离不开业内极其优秀的合作伙伴。\r\n</p>', '0', '1', '', '', '', '2015-08-25 23:21:28', '2015-12-08 18:00:36');
INSERT INTO `ivears_page` VALUES ('86', '公司概况', '公司概况', '0', '<p style=\"text-align:left;\">\r\n	<img src=\"http://www.e.com/Public/tongyong/Picture/20140814_093748.jpg\" alt=\"\" width=\"300\" height=\"146\" title=\"\" align=\"left\" />某某有限公司致力于XX业的发展，专业从事集中润滑系统的研究、开发、制造及销售，凭借公司强大的技术力量和经济实力，不断开发出具有国际先进技术水平的新产品。公司产品广泛适用于数控机械、加工中心、生产线、机床、锻压、纺织、塑料、橡胶、矿山、冶金、建筑、印刷、化工、制药、铸造、食品等各行业的机械设备及大型车辆底盘的集中润滑系统。\r\n</p>\r\n<p>\r\n	公司总部设在xxx，在全国各大城市设有分支机构，服务网络遍及全国。公司内部实行网络化管理，依托先进的计算机辅助设计系统和计算机管理系统，实现规范化运作，在最短的时间内为用户提供高品质的产品。\r\n</p>\r\n<p>\r\n	公司本着技术领先、质量第一、客户至上的原则为广大用户提供满意的服务。\r\n</p>\r\n<p>\r\n	目前公司为国内、外超过2万家的企业提供了网站建设、域名、邮件服务、虚拟主机、网站托管服务，同时为近千家的企业设计开发了基于互联网的各类商务应用和管理软件，是国内具影响力的互联网应用服务商之一。公司将坚持客户导向、应用为本的策略，继续专注于在信息技术领域开拓发展成为企业、政府、家庭信息化的推动者和服务者。正道将秉承\"和谐、参与、激情\"的文化，与客户和合作伙伴齐心协力一起成长，共同发展。 　　公司自2000年创立以来，积极进取，不断创新，凭借良好的企业信誉，独特的经营风格及较强的市场开拓能力，取得了一个又一个的骄人业绩。数年来，xx快速稳健的发展，离不开业内极其优秀的合作伙伴。\r\n</p>', '0', '1', '', '', '', '2015-08-25 23:21:07', '2015-12-04 17:22:48');
INSERT INTO `ivears_page` VALUES ('99', '人才招聘', 'Job', '0', '人才招聘人才招聘', '0', '1', '', '', '', '2015-12-07 18:15:33', '0000-00-00 00:00:00');
INSERT INTO `ivears_payment` VALUES ('13', '支付宝', '支付宝', 'Alipay', '支付宝是国内领先的独立第三方支付平台，由阿里巴巴集团创办。致力于为中国电子商务提供“简单、安全、快速”的在线支付解决方案。<a href=\"http://b.alipay.com/\" target=\"_blank\"><font color=\"red\">立即在线申请</font></a>', '0', '{\"alipay_account\":{\"name\":\"\\u652f\\u4ed8\\u5b9d\\u5e10\\u6237\",\"type\":\"text\",\"value\":\"\"},\"alipay_key\":{\"name\":\"\\u4ea4\\u6613\\u5b89\\u5168\\u6821\\u9a8c\\u7801(key)\",\"type\":\"text\",\"value\":\"\"},\"alipay_partner\":{\"name\":\"\\u5408\\u4f5c\\u8005\\u8eab\\u4efd(parterID)\",\"type\":\"text\",\"value\":\"\"},\"service_type\":{\"name\":\"\\u9009\\u62e9\\u63a5\\u53e3\\u7c7b\\u578b\",\"type\":\"select\",\"value\":\"0\",\"range\":[\"\\u4f7f\\u7528\\u62c5\\u4fdd\\u4ea4\\u6613\\u63a5\\u53e3\",\"\\u4f7f\\u7528\\u6807\\u51c6\\u53cc\\u63a5\\u53e3\",\"\\u4f7f\\u7528\\u5373\\u65f6\\u5230\\u8d26\\u4ea4\\u6613\\u63a5\\u53e3\"]}}', '0', '1', '10', '1', 'HUICMS研发团队', 'http://www.alipay.com', '1.0');
INSERT INTO `ivears_product` VALUES ('66', '/Upload/image/20151127/20151127111318_77211.jpg', '', null, '有优异的漆膜性能和外观', '<div align=\"center\">\r\n	<p>\r\n		<br />\r\n	</p>\r\n	<p>\r\n		<span style=\"color:#191919;font-family:Verdana, 微软雅黑;line-height:20px;background-color:#FFFFFF;\">有优异的漆膜性能和外观</span>\r\n	</p>\r\n</div>', '229', '2', null, null, 'admin', null, '0', '', '', '0', null, '96', null, '1', '', '', '', '0', null, null, null, '2015-11-18 17:05:53', '2015-11-27 11:13:26');
INSERT INTO `ivears_product` VALUES ('71', '/Upload/image/20151127/20151127111333_44153.jpg', '', null, '化妆造型1', '<div align=\"center\">\r\n	safd<span style=\"color:#191919;font-family:Verdana, 微软雅黑;line-height:20px;background-color:#FFFFFF;\">有优异的漆膜性能和外观</span> \r\n</div>', '229', '2', null, null, 'admin', null, '0', '', '', '0', null, '33', null, '1', '', '', '', '0', null, null, null, '2015-11-20 16:38:05', '2015-11-27 11:13:39');
INSERT INTO `ivears_product` VALUES ('74', '/Upload/image/20151127/20151127111345_81378.jpg', '', null, '有优异的漆膜性能和外观', '<div align=\"center\">\r\n	<span style=\"color:#191919;font-family:Verdana, 微软雅黑;line-height:20px;background-color:#FFFFFF;\">有优异的漆膜性能和外观</span><br />\r\n</div>', '230', '2', null, null, 'admin', null, '0', '有优异的漆膜性能和外观', '', '0', null, '17', null, '1', '', '', '', '0', null, null, null, '2015-11-20 17:03:07', '2015-11-27 11:13:51');
INSERT INTO `ivears_role` VALUES ('1', '超级管理员', '1');
INSERT INTO `ivears_role` VALUES ('3', '普通', '1');
INSERT INTO `ivears_role_access` VALUES ('3', '7');
INSERT INTO `ivears_role_access` VALUES ('3', '12');
INSERT INTO `ivears_role_access` VALUES ('3', '16');
INSERT INTO `ivears_role_access` VALUES ('3', '20');
INSERT INTO `ivears_role_nav` VALUES ('1', '系统管理', '1', '10');
INSERT INTO `ivears_role_nav` VALUES ('2', '模块管理', '1', '60');
INSERT INTO `ivears_role_nav` VALUES ('3', '控制台', '1', '0');
INSERT INTO `ivears_role_nav` VALUES ('4', '用户管理', '0', '70');
INSERT INTO `ivears_role_nav` VALUES ('5', '内容管理', '1', '80');
INSERT INTO `ivears_role_nav` VALUES ('7', '模板管理', '0', '100');
INSERT INTO `ivears_role_nav` VALUES ('8', '数据', '0', '110');
INSERT INTO `ivears_role_nav` VALUES ('9', '全局', '1', '120');
INSERT INTO `ivears_role_node` VALUES ('4', '', '', 'RoleNode', '节点管理', '1', '1', '50', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('5', 'addRoleNode', '添加节点', 'RoleNode', '节点管理', '1', '1', '30', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('6', 'editRoleNode', '编辑节点', 'RoleNode', '节点管理', '1', '1', '30', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('7', 'index', '节点列表', 'RoleNode', '节点管理', '1', '1', '50', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('9', '', '', 'System', '管理员', '1', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('10', 'index', '管理员列表', 'System', '管理员', '1', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('11', 'pageAddAdmin', '添加管理员', 'System', '管理员', '1', '0', '20', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('12', 'pageEditAdmin', '编辑管理员', 'System', '管理员', '1', '1', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('13', '', '', 'Role', '角色管理', '1', '0', '20', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('14', 'index', '角色列表', 'Role', '角色管理', '1', '0', '20', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('15', 'addRole', '添加角色', 'Role', '角色管理', '1', '0', '20', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('16', 'editRole', '编辑角色', 'Role', '角色管理', '1', '0', '20', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('17', '', '', 'RoleNav', '菜单管理', '1', '0', '40', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('18', 'index', '菜单列表', 'RoleNav', '菜单管理', '1', '0', '40', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('19', 'addRoleNav', '添加菜单', 'RoleNav', '菜单管理', '1', '0', '40', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('20', 'editRoleNav', '编辑菜单', 'RoleNav', '菜单管理', '1', '1', '40', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('21', 'doDelete', '删除菜单', 'RoleNav', '菜单管理', '1', '0', '40', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('22', 'doDelete', '删除节点', 'RoleNode', '节点管理', '1', '0', '30', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('23', 'pageLogList', '管理员登陆日志', 'System', '管理员', '1', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('24', 'doDelete', '删除管理员', 'System', '管理员', '1', '1', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('25', 'doDelete', '删除角色', 'Role', '角色管理', '1', '1', '20', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('26', '', '', 'Links', '友情链接管理', '2', '1', '60', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('27', 'index', '链接列表', 'Links', '友情链接管理', '2', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('28', 'addLinks', '添加链接', 'Links', '友情链接管理', '2', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('29', 'editLinks', '编辑链接', 'Links', '友情链接', '2', '1', '0', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('33', '', '', 'Message', '留言管理', '2', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('34', 'index', '留言列表', 'Message', '留言管理', '2', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('35', '', '', 'Index', '控制台', '3', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('36', 'index', '欢迎页面', 'Index', '控制台', '3', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('37', 'aboutUs', '关于我们', 'Index', '控制台', '3', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('38', 'index', '会员列表', 'Member', '会员管理', '4', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('39', 'addMember', '添加会员', 'Member', '会员管理', '4', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('40', 'editMember', '编辑会员', 'Member', '会员管理', '4', '1', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('42', '', '', 'MemberLevel', '等级管理', '4', '0', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('43', 'index', '等级列表', 'MemberLevel', '等级管理', '4', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('44', 'addMemberLevel', '添加等级', 'MemberLevel', '等级管理', '4', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('45', '', '', 'Article', '内容管理', '5', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('46', 'index', '文章列表', 'Article', '内容管理', '5', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('47', 'addArticle', '添加文章', 'Article', '文章管理', '5', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('48', 'editArticle', '编辑文章', 'Article', '文章管理', '5', '1', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('49', 'doDelete', '删除文章', 'Article', '文章管理', '5', '1', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('50', '', '', 'ArticleCategory', '分类管理', '5', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('115', 'CategoryIndex', '分类管理', 'Article', '文章管理', '5', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('116', 'index', '单页管理', 'Page', '单页管理', '5', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('54', '', '', 'Goods', '商品管理', '6', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('55', 'index', '商品列表', 'Goods', '商品管理', '6', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('56', 'addGoods', '添加商品', 'Goods', '商品管理', '6', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('57', 'editGoods', '编辑商品', 'Goods', '商品管理', '6', '1', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('58', '', '', 'Theme', '模板管理', '7', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('59', 'index', '模板列表', 'Theme', '模板管理', '7', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('60', '', '', 'Orders', '订单管理', '10', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('61', 'index', '订单列表', 'Orders', '订单管理', '10', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('62', '', '', 'Ad', '广告管理', '2', '0', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('63', 'index', '广告列表', 'Ad', '广告管理', '2', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('64', 'addAd', '添加广告', 'Ad', '广告管理', '2', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('65', 'editAd', '编辑广告', 'Ad', '广告管理', '2', '0', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('66', '', '', 'Database', '数据库管理', '8', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('67', 'backup', '数据备份', 'Database', '数据库管理', '8', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('68', 'restore', '数据恢复', 'Database', '数据库管理', '8', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('69', '', '', 'Delivery', '配送设置', '10', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('70', 'index', '配送公司列表', 'Delivery', '配送设置', '10', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('71', 'addDelivery', '添加配送公司', 'Delivery', '配送设置', '10', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('72', 'editDelivery', '编辑配送公司', 'Delivery', '配送设置', '10', '1', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('73', '', '', 'GoodsCategory', '商品分类管理', '6', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('74', 'index', '商品分类列表', 'GoodsCategory', '商品分类管理', '6', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('75', 'addGoodsCategory', '添加商品分类', 'GoodsCategory', '商品分类管理', '6', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('76', 'editGoodsCategory', '编辑商品分类', 'GoodsCategory', '商品分类管理', '6', '1', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('77', '', '', 'Download', '资源下载', '5', '0', '10', '1', '0');
INSERT INTO `ivears_role_node` VALUES ('78', 'index', '资源列表', 'Download', '资源下载', '5', '0', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('79', 'addDownload', '添加资源', 'Download', '资源下载', '5', '0', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('80', 'editDownload', '编辑资源', 'Download', '资源下载', '5', '0', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('81', 'logDatabase', '数据操作日志', 'Database', '数据库管理', '8', '1', '100', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('82', '', '', 'Payment', '支付设置', '2', '0', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('83', 'index', '支付列表', 'Payment', '支付设置', '2', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('85', 'editPayment', '编辑支付接口', 'Payment', '支付设置', '10', '0', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('86', '', '', 'Comment', '商品评论', '6', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('87', 'index', '评论列表', 'Comment', '商品评论', '6', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('88', 'Set', '评论设置', 'Comment', '商品评论', '6', '1', '1', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('89', '', '', 'Brand', '品牌管理', '6', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('90', 'index', '品牌列表', 'Brand', '品牌管理', '6', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('91', 'addBrand', '添加品牌', 'Brand', '品牌管理', '6', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('92', 'editBrand', '编辑品牌', 'Brand', '品牌管理', '6', '1', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('93', '', '', 'Setting', '核心设置', '9', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('94', 'index', '站点设置', 'Setting', '核心设置', '9', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('95', 'cache', '缓存设置', 'Setting', '核心设置', '9', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('96', 'Security', '安全设置', 'Setting', '核心设置', '9', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('97', '', '', 'Customer', '在线客服', '2', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('98', 'index', '客服列表', 'Customer', '在线客服', '2', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('99', 'addCustomer', '添加客服', 'Customer', '在线客服', '2', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('100', 'editCustomer', '编辑客服', 'Customer', '在线客服', '2', '1', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('101', '', '', 'Oauth', '登陆接口', '2', '0', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('102', 'index', '接口列表', 'Oauth', '登陆接口', '2', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('103', '', '', 'Nav', '导航管理', '7', '1', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('104', 'index', '导航设置', 'Nav', '导航管理', '7', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('105', 'addNav', '添加导航', 'Nav', '导航管理', '7', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('106', 'editNav', '编辑导航', 'Nav', '导航管理', '7', '1', '10', '0', '0');
INSERT INTO `ivears_role_node` VALUES ('107', 'index', '通知模版列表', 'MessageTpl', '通知设置', '9', '0', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('108', '', '', 'MessageTpl', '通知设置', '9', '0', '0', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('120', '', '模板管理', 'Product', '模板管理', '5', '0', '10', '1', '1');
INSERT INTO `ivears_role_node` VALUES ('121', 'CategoryIndex', '产品分类', 'Product', '产品列表', '5', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('117', 'index', '图片轮换', 'Imagelist', '图片轮换', '2', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('122', 'index', '产品管理', 'Product', '产品列表', '5', '1', '10', '0', '1');
INSERT INTO `ivears_role_node` VALUES ('140', 'CategoryIndex', '分类管理', 'Imagelist', '分类管理', '2', '1', '10', '0', '1');
