<?php
abstract class HomeAction extends Action{
    /**
     * 基类初始化操作
     * @author billow.wang <admin@ivears.com>
     * @date 2012-04-15
     */
    public function _initialize() {
        $this->_title();        //获取网站标题信息
        $this->_nav();
        $this->_oauth();        //获取登录授权
        $this->_links();
        $this->_announce();
		$this->_REQUESTASSIGN();
        if(!C('site_status')){
            header('Content-Type:text/html; charset=utf-8');
            exit(C('site_close'));
        }
		if(C("site_301")==1){
			rewrite_301();
		}
        import('ORG.Util.Page');
		$modulename= $this->getActionName();
		$this->modulename=$modulename;
		$this->assign("modulename",$modulename);
		if($_REQUEST['catid']){
			$this->getAllCid($_REQUEST['catid']);	
		}
		//die($_SERVER['REQUEST_URI']);
		//print_r($_REQUEST);
    }
    
    public function _title(){
        //SEO
        $config = D("Config")->getCfgByModule("WEBSITE");
        $page_seo = json_decode($config['WEBSITE'],true);
//        echo "<pre>";print_r($page_seo);exit;
        C($page_seo);
        $this->assign($page_seo);
    }
    
    public function _oauth(){
        $oauth = D("Oauth")->where(array('status'=>'1'))->select();
        if(!empty($oauth) && is_array($oauth)){
            foreach($oauth as $key => $val){
                $oauth[$key]['type'] = strtolower($val['code']);
                
            }
        }
//        echo "<pre>";print_r($oauth);exit;
        $this->assign("oauth",$oauth);
    }
	
	public function _REQUESTASSIGN(){
		$arr=$_REQUEST;
		$this->assign($arr);
			
	}
    
    public function _empty() {
        $this->_404();
    }
    
    protected function _404($url = '') {
        if ($url) {
            redirect($url);
        } else {
            send_http_status(404);
            $this->display(TMPL_PATH . '404.html');
            exit;
        }
    }
	
	public function getAllCid($catid){
		if($catid){
			$wherearr=array();
			$childcid_arr=D('category')->where(array('pid'=>$catid))->select();
			if($childcid_arr){
					foreach($childcid_arr  as $key=>$one){
						$wherearr[]=$one['id'];	
					}
				$wherearr[]=$catid;
				$wherestr=implode(',',$wherearr);
				$str=$wherestr;
			}else{
				$str=$catid;
			}			
			$catarr=D('category')->where(array('id'=>$catid))->find();
			$this->assign("catarr",$catarr);	
			if($catarr['pid']){
				$catarr_parr=D('category')->where(array('id'=>$catarr['pid']))->find();
				$this->assign("catarr_parr",$catarr_parr);
			}
			$this->assign("where_str",$str);	
		}		
	}
    
    public function _nav(){
        $nav = D("Nav")->where(array('status'=>'1','`type`'=>'main'))->order('`order` desc')->select();
//        echo "<pre>";print_r($nav);exit;
        $this->assign("nav",$nav);
    }
    
    public function _links(){
        $links = D("Links")->where(array('type'=>'0','status'=>'1'))->order('`order` desc')->select();
        $this->assign("links",$links);
    }
    
    public function _announce(){
        $where = array();
        $where['status'] = '1';
        $where['starttime'] = array('lt',  date("Y-m-d H:i:s"));
        $where['endtime'] = array('gt',  date("Y-m-d H:i:s"));
        $announce = D("Announce")->where($where)->order('`order` DESC')->select();
        //echo "<pre>";print_r(D("Announce")->getLastSql());exit;
        $this->assign("announce",$announce);
    }
    public function _Page($count, $pagesize) {
        $page = new Page($count, $pagesize);
        $page->setConfig("header", "条");
        $page->setConfig('theme', '<li class="pageSelect">共%totalRow%%header%&nbsp;%nowPage%/%totalPage%页&nbsp;%first%&nbsp;%upPage%&nbsp;%prePage%&nbsp;%linkPage%&nbsp;%nextPage%&nbsp;%downPage%&nbsp;%end%</li>');
        return $page;
    }	
}
