<?php
 /**
 * Magic CMS 默认配置
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
if (!defined('KERNEL_PATH'))exit('No direct script access allowed');
$config =  array(
   /********************************基本参数********************************/

		'DEBUG'				   => true,			    //是否开启调试模式，true开启，false关闭
		'DEBUG_TOOL'           => false,
		'LOG_ON'			   => true,            //是否开启出错信息保存到文件，true开启，false不开启
		'LOG_PATH'			   => DATA_PATH.'Log/',      //出错信息存放的目录，出错信息以天为单位存放，一般不需要修改
		'LOG_LEVEL'            => array('FATAL','ERROR','WARNING','SQL'),//写入日志的错误级别
		'ERROR_URL'            => '',			    //出错信息重定向页面，为空采用默认的出错页面，一般不需要修改
		'DEFAULT_TIME_ZONE'    => 'UTC',            //时区
		'CHECK_FILE_CASE'      => False,            //windows区分大小写
		'FILTER_FUNCTION'      => array('htmlspecialchars','strip_tags'), //过滤函数会在Q(),date_format()等函数中使用
    	'MOBILE_SITE'		   => FALSE,		    //是否开启移动站点支持
		'AUTOLOAD_FILE'        => array(),	        //自动加载扩展目录
		'MESSAGE_PATH'         => ROOT_PATH.'Data/Message/',	        //消息存储路径
		'INSTALL_LOCK'                                         => 1,	        //系统安装
		'VERSION'				=> '2.2.1 alpha 政企版',

	/********************************SESSION配置*******************************/

		'SESSION_AUTO_START'   => TRUE,			  //自动开启SESSION
		'SESSION_TYPE'         => '',               //
		'SESSION_OPTIONS'      => array(),          //Session选项
		'SESSION_KEY'	       => 'Magic',             //用户SESSION名

    /********************************COOKIE配置********************************/

        'COOKIE_EXPIRE'        => 0,                 // Coodie有效期
        'COOKIE_DOMAIN'        => '',                // Cookie有效域名
        'COOKIE_PATH'          => '/',               // Cookie路径
        'COOKIE_PREFIX'        => '',                // Cookie前缀 避免冲突

   /********************************URL配置*************************************/

		'URL_REWRITE'		   => False,             //url重写模式
		'PATHINFO_DLI'         => '-',               //模块分隔符，方法， URL_TYPE为1、3时起效
		'PATHINFO_VAR'         => 'r',               //兼容模式get变量
		'HTML_SUFFIX'          => '.html',           //伪静态扩展名
		'VAR_MODULE'           => 'm',               //模块URL变量
		'VAR_CONTROLLER'       => 'c',               //控制器URL变量
		'VAR_ACTION'           => 'a',               //动作URL变量
		'DENY_MODULE'          => array('Common','Plugins'),//禁止使用的模块
		'DEFAULT_MODULE'       => 'Index',           //默认模块
		'DEFAULT_CONTROLLER'   => 'index',           //默认控制器
		'DEFAULT_ACTION'       => 'index',           //默认方法
		'MODULE_PATH'		   => 'Module',         //模块存放目录，一般不需要修改
		'MODULE_SUFFIX'		   => 'Module',          //模块后缀，一般不需要修改
		'MODULE_EXT'		   => array('Plugin'=>'Plugins'),	//扩展模块

		'MODULE_EMPTY'		   => 'Empty',           //空模块	，一般不需要修改

    /********************************分页配置************************************/

		'PAGE_VAR'             => 'page',              //分页GET变量
		'PAGE_ROW'             => 10,                  //页码数量
		'PAGE_SHOW_ROW'        => 2,                   //每页显示条数
		'PAGE_STYLE'           => 2,                   //页码风格
		'PAGE_DESC'            => array('pre' => '上一页', 'next' => '下一页','first' => '首页', 'end' => '尾页', 'unit' => '条'),//分页文字设置

	/********************************数据库配置**********************************/

		//数据库设置
		'DB_DRIVER'            => 'Mysqli',            //数据库驱动
		'DB_HOST'		       => 'localhost',         //数据库主机
		'DB_NAME'		       => 'magic',            //数据库名
		'DB_USER'		       => 'root',              //数据库用户名
		'DB_PASSWORD'          => '123456',            //数据库密码
		'DB_PREFIX'            => 'magic_',            //数据库表前缀
		'DB_PORT'		       => 3306,		           //数据库端口，mysql默认是3306，一般不需要修改
		'DB_CHARSET'           => 'utf8',              //数据库编码，一般不需要修改
		'DB_PCONNECT'          => false,               //数据库持久链接
		'DB_CACHE_TIME'        => -1,		           //缓存时间 -1为不缓存 0为永久缓存
        'DB_CACHE_ROWS'        => 30,                  //缓存最大条数

    /********************************模板配置***********************************/

		'TPL_TAG_LEFT'         => '{',
		'TPL_TAG_RIGHT'        => '}',
		'TPL_PATH'		       => 'Templets/',	        //模板目录，一般不需要修改
		'TPL_SUFFIX'	       => array('.html','.htm','.dwt'),			    //模板后缀，一般不需要修改
		'TPL_STYLE'		       => '',		            //模板样式
		'TPL_TAGS'             => array(),              //模板标签
		'TPL_MOBILE'	       => 'mobile',			    //移动版模板目录
		'TPL_CACHE_PATH'       => DATA_PATH.'Cache/Tpl/',    //模板缓存目录
		'TPL_CACHE_SUFFIX'     => '.php',			       //模板缓存后缀,一般不需要修改
		'TPL_COMPILE_PATH'     => DATA_PATH.'Compile/',      //模板编译目录
	    'TPL_CACHE_TYPE'       => 'file',               //类型:file memcache redis
        'TPL_CACHE_TIME'       => -1,                   //全局默认缓存时间 0为永久缓存 -1 不缓存

	/********************************图像水印********************************/

		'WATER_ON'                                                          => false,        //开关
        	'WATER_TYPE'                                                              => 'text',//水印类型，图片水印或者文字水印
		'WATER_FONT'                                                                                                                                                                              => '../Data/Public/font/font.ttf',   //水印字体
        'WATER_IMG'                                                         => '/Uploads/image/20151023/32761445531083.jpg', //水印图像
        'WATER_POS'                                                                                                                                                                               => 5,           //位置  1~9九个位置  0为随机
        'WATER_PCT'                                                                                                                                                                               => 50,          //透明度
        'WATER_QUALITY'                                                                                                                                                                           => 100,          //压缩比
        'WATER_TEXT'                                                                                                                                                                              => 'Magic CMS', //水印文字
        'WATER_TEXT_COLOR'                                                                                                                                                                        => '#f00f00',   //文字颜色
        'WATER_TEXT_SIZE'                                                                                                                                                                         => 18,          //文字大小
  /********************************图片缩略图********************************/
        'THUMB_ON'                                                                                                                                                                                                    => 1,
	    'THUMB_PREFIX'                                                                                                                                                                                                => '',          //缩略图前缀
        'THUMB_ENDFIX'                                                                                                                                                                                                => '_thumb',    //缩略图后缀
        'THUMB_TYPE'                                                                                                                                                                                                  => 1,
                                              //1:固定宽度,高度自增 2:固定高度,宽度自增 3:固定宽度,高度裁切
                                              //4:固定高度,宽度裁切 5:缩放最大边       6:自动裁切图片
        'THUMB_WIDTH'                                                                                                                                                                                                 => 120,         //缩略图宽度
        'THUMB_HEIGHT'                                                                                                                                                                                                => 60,         //缩略图高度
   /********************************验证码配置********************************/
	    'CODE_FONT'                     => DATA_PATH.'Verify/font.ttf', //字体
		'CODE_STR'                      => '0123456789', //验证码种子
		'CODE_WIDTH'                    => 120,         //宽度
		'CODE_HEIGHT'                   => 33,          //高度
		'CODE_BG_COLOR'                 => '#ffffff',   //背景颜色
		'CODE_LEN'                      => 4,           //文字数量
		'CODE_FONT_SIZE'                => 20,          //字体大小
		'CODE_FONT_COLOR'               => '',   //字体颜色

  /********************************邮箱配置********************************/
		  'SMTP_AUTH' => '1',
		  'SMTP_CHARSET'                                                                                                                                  => 'utf-8',
		  'SMTP_DEBUG' => '0',
		  'SMTP_FROM_TO'                                                                                                                                  => '',
		  'SMTP_HOST'                                                                                                                                  => 'smtp.mxhichina.com.',
		  'SMTP_PASSWORD'                                                                                                                                  => '',
		  'SMTP_PORT'                                                                                                                                  => 25,
		  'SMTP_SSL'            => 0,
		  'SMTP_USERNAME'                                                                                                                                  => '',
	/********************************上传配置********************************/
		'UPLOAD_ALLOW_SIZE'                                                                                                                                                                              => 2048,
		'UPLOAD_SAVE_PATH'                                                                                                                                                                              => '../Uploads/',
		  'UPLOAD_ALLOW_TYPE'        => array('IMAGE'=>array('gif', 'jpg', 'jpeg', 'png', 'bmp'),'MEDIA'=>array('swf', 'flv', 'mp3', 'mp4', 'f4v', 'wav', 'wma', 'wmv', 'mid', 'avi', 'mpg', 'asf', 'rm', 'rmvb'),'FILE'=>array('doc', 'txt', 'docx', 'xls', 'xlsx', 'zip', 'rar', 'gz', 'bz2', 'pdf')),


);