<?php
/**
 * Debug调式处理类
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Author: Shiang.Chin
 * Date:2014/12/31
**/
if (!defined('KERNEL_PATH'))exit('No direct script access allowed');
final class Debug{

    //信息内容
    static $info = array();
    //运行时间
    static $runtime;
    //运行内存占用
    static $memory;
    //内存峰值
    static $memory_peak;
    //所有发送的SQL语句
    static $sqlExeArr = array();
    //编译模板
    static $tpl = array();
    //缓存记录
    static $cache=array("write_s"=>0,"write_f"=>0,"read_s"=>0,"read_f"=>0);


    /**
     * 项目调试开始
     * @access public
     * @param type $start   起始
     * @return void
     */
    static public function start($start){
        self::$runtime[$start] = microtime(true);
        if (function_exists("memory_get_usage")) {
            self::$memory[$start] = memory_get_usage();
        }
        if (function_exists("memory_get_peak_usage")) {
            self::$memory_peak[$start] = false;
        }
    }
    /**
     * 运行时间
     * @param $start
     * @param string $end
     * @param int $decimals
     * @return string
     * @throws Exception
     */
    static public function runtime($start, $end = '', $decimals = 4){
        if (!isset(self::$runtime[$start])) {
            throw new Error('没有设置调试开始点：' . $start);
        }
        if (empty(self::$runtime[$end])) {
            self::$runtime[$end] = microtime(true);
            return number_format(self::$runtime[$end] - self::$runtime[$start], $decimals);
        }
    }

    /**
     * 项目运行内存峰值
     * @access public
     * @param string $start   起始标记
     * @param string $end     结束标记
     * @return int
     */
    static public function memory_perk($start, $end = ''){
        if (!isset(self::$memory_peak[$start]))
            return mt_rand(200000, 1000000);
        if (!empty($end))
            self::$memory_peak[$end] = memory_get_peak_usage();
        return max(self::$memory_peak[$start], self::$memory_peak[$end]);
    }

    /**
     * 显示调试信息
     * @access public
     * @param string $start   起始标记
     * @param string $end     结束标记
     * @return void
     */
    static public function show($start, $end){
        $debug = array();
        $debug['file'] = require_cache();
        $debug['runtime'] = self::runtime($start, $end);
        $debug['memory'] = number_format(self::memory_perk($start, $end) / 1000, 0) . " KB";
        require KERNEL_PATH . '/Tpl/debug.html';
    }

}
