<?php
 /**
 * 日志处理类
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Author: Shiang.Chin
 * Date:2014/12/31
**/
if (!defined('KERNEL_PATH'))exit('No direct script access allowed');
final class Log{
    const FATAL = 'FATAL'; // 严重错误: 导致系统崩溃无法使用
    const ERROR = 'ERROR'; // 一般错误: 一般性错误
    const WARNING = 'WARNING'; // 警告性错误: 需要发出警告的错误
    const NOTICE = 'NOTICE'; // 通知: 程序可以运行但是还不够完美的错误
    const DEBUG = 'DEBUG'; // 调试: 调试信息
    const SQL = 'SQL'; // SQL：SQL语句 注意只在调试模式开启时有效
    //日志信息
    static $log = array();

    /**
     * 记录日志内容
     * @param $message 错误
     * @param string $level 级别
     * @param bool $record 是否记录
     */
    static public function record($message, $level = self::ERROR, $record = false){
        if ($record || in_array($level, C('LOG_LEVEL'))) {
            self::$log[] = date("[ c ]") . "{$level}: {$message}\r\n";
        }
    }

    /**
     * 存储日志内容
     * @access public
     * @param int $type 处理方式
     * @param string $destination 日志文件
     * @param type $extraHeaders 额外信息（发送邮件）
     * @return void
     */
    static public function save($type = 3, $destination = NULL, $extraHeaders = NULL){
        if (empty(self::$log)) return;
        if (is_null($destination)) {
            $destination =  C('LOG_PATH') . date("Y_m_d") . ".log";
        }
        if (is_dir( C('LOG_PATH'))) error_log(implode("", self::$log) . "\r\n", $type, $destination, $extraHeaders);
        self::$log = array();
    }

    /**
     * 写入日志内容
     * @access public
     * @param string $message 日志内容
     * @param string $level 错误等级
     * @param int $type 处理方式
     * @param string $destination 日志文件
     * @param string $extraHeaders
     * @return void
     */
    static public function write($message, $level = self::ERROR, $type = 3, $destination = NULL, $extraHeaders = NULL){

		if (is_null($destination)) {
            $destination =  C('LOG_PATH') . date("Y_m_d") .'_'.rand_str(). ".log";
        }
        if (!is_dir(C('LOG_PATH'))){
			@mkdir(C('LOG_PATH'), 0755);
		}
		error_log(date("[ c ]") . "{$level}: {$message}\r\n", $type, $destination, $extraHeaders);
    }

}