<?php
/**
 * 缓存驱动工厂
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Author: Shiang.Chin
 * Date:2014/12/31
**/
if (!defined('KERNEL_PATH'))exit('No direct script access allowed');
final class CacheFactory
{

    public static $cacheFactory = null; //静态工厂实例
    protected $cacheList = array(); //驱动链接组

    /**
     * 构造函数
     */

    private function __construct()
    {

    }

    /**
     * 返回工厂实例，单例模式
     */
    public static function factory($options)
    {
        $options = is_array($options) ? $options : array();

        //只实例化一个对象
        if (is_null(self::$cacheFactory)) {
            self::$cacheFactory = new CacheFactory();
        }

        $driver = isset($options['driver']) ? $options['driver'] : C("TPL_CACHE_TYPE");
			;
        //静态缓存实例名称
        $driverName = seria($options);

        //对象实例存在
        if (isset(self::$cacheFactory->cacheList[$driverName])) {
            return self::$cacheFactory->cacheList[$driverName];
        }
        $class = 'Cache' . ucwords(strtolower($driver)); //缓存驱动

        if(!class_exists($class)){
            $classFile = DRIVER_PATH . 'Cache/' . $class . '.class.php'; //加载驱动类库文件

            if (!require_cache($classFile)) {
                error("缓存类型指定错误，不存在缓存驱动文件:" . $classFile);
            }
        }
        $cacheObj = new $class($options);
        self::$cacheFactory->cacheList[$driverName] = $cacheObj;

        return self::$cacheFactory->cacheList[$driverName];
    }

}
