<?php

 /**
 * Memcache缓存类
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Author: Shiang.Chin
 * Date:2014/12/31
**/
if (!defined('KERNEL_PATH'))exit('No direct script access allowed');
class CacheMemcache extends Cache {

    /**
     * 缓存对象
     * Memcache缓存处理资源对象
     * @var Object
     */
    protected $memcacheObj;

    /**
     * 构造函数
     * @access public
     * @param array $options 缓存选项必须为数组
     */
    public function __construct($options = array()) {
        //检测Memcache扩展
        if (!extension_loaded('memcache')) {
            throw_exception("Memcache扩展加载失败");
        }
        $this->options['expire'] = isset($options['expire']) ? intval($options['expire']) : intval(C("CACHE_TIME")); //缓存时间
        $this->options['prefix'] = isset($options['prefix']) ? $options['prefix'] : ''; //缓存前缀
        $this->options['length'] = isset($options['length']) ? $options['length'] : 0; //队列长度
        $this->options['zip'] = isset($options['zip']) ? $options['zip'] : TRUE; //队列长度
        $this->options['server'] = isset($options['server']) ? $options['server'] : C("CACHE_MEMCACHE");
        $this->options['save'] = isset($options['save']) ? $options['save'] : true; //记录缓存命中率
        if (!$this->isConnect) {
            $this->connectMemcache();
            $this->isConnect = true;
        }
    }

    /**
     * 连接Memcache
     * @access private
     */
    private function connectMemcache() {
        $host = $this->options['server'];
        $hostArr = is_array(current($host)) ? $host : array($host);
        $this->memcacheObj = new Memcache();
        foreach ($hostArr as $h) {
            $_host = isset($h['host'])?$h['host']:"127.0.0.1";
            $_port = isset($h['port'])?$h['port']:11211;
            $_pconnect = isset($h['pconnect'])?$h['pconnect']:1;
            $_weight = isset($h['weight'])?$h['weight']:1;
            $_timeout = isset($h['timeout'])?$h['timeout']:1;
            $this->memcacheObj->addServer($_host,$_port,$_pconnect,$_weight,$_timeout);
        }
    }

    /**
     * 设置缓存
     * @access public
     * @param void $name 缓存名称
     * @param void $value 缓存数据
     * @param null $expire 缓存时间
     * @return mixed
     */
    public function set($name, $value, $expire = null) {
        //缓存KEY
        $name = $this->options['prefix'] . $name;
        //删除缓存
        if (is_null($value)) {
            return $this->memcacheObj->delete($name);
        }
        //是否压缩数据
        $zip = $this->options['zip'] ? MEMCACHE_COMPRESSED : 0;
        //过期时间
        $expire = is_null($expire) ? $this->options['expire'] : (int) $expire;
        //设置缓存
        $data = $this->memcacheObj->set($name, $value, $zip, $expire);
        return $data;
    }

    /**
     * 获得缓存数据
     * @access public
     * @param string $name  缓存KEY
     * @return boolean
     */
    public function get($name,$ctime=null) {
        //缓存KEY
        $name = $this->options['prefix'] . $name;
        $data = $this->memcacheObj->get($name);
        return $data!==false ? $data : NULL;
    }

    /**
     * 删除缓存
     * @access public
     * @param type $name  缓存KEY
     * @return boolean
     */
    public function del($name) {
        //缓存KEY
        $name = $this->options['prefix'] . $name;
        return $this->memcacheObj->delete($name);
    }

    /**
     * 删除所有缓存数据
     * @return boolean
     */
    public function delAll() {
        return $this->memcacheObj->flush();
    }

}
