<?php
/**
 * 数据库驱动工厂
  * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 */
final class DbFactory
{

    public static $dbFactory = null; //静态工厂实例
    protected $driverList = array(); //驱动组

    /**
     * 构造函数
     */

    private function __construct()
    {

    }

    /**
     * 返回工厂实例，单例模式
     * @param $driver 连接驱动
     * @param $table 表
     * @param bool $full 加表前缀
     * @return bool
     */
    public static function factory($driver, $table, $full){
        //只实例化一个对象
        if (is_null(self::$dbFactory)) {
            self::$dbFactory = new dbFactory();
        }
        if (is_null($driver)) {
            $driver = ucfirst(C("DB_DRIVER"));
        }

        //数据库驱动存在并且数据库连接正常
        if (isset(self::$dbFactory->driverList[$table]) && self::$dbFactory->driverList[$table]->link) {
            return self::$dbFactory->driverList[$table];
        }
        //获得数据库驱动
        if (self::$dbFactory->getDriver($driver, $table, $full)) {
            return self::$dbFactory->driverList[$table];
        } else {
            return false;
        }
    }

    /**
     * 获得数据库驱动接口
     * @param string $driver 驱动
     * @param string $table 数据表
     * @param bool $full 全表名
     * @return mixed
     */
    private function getDriver($driver, $table, $full)
    {
        $class = "Db" . $driver; //数据库驱动
        $this->driverList[$table] = new $class;
        return $this->driverList[$table]->link($table, $full);
    }

    /**
     * 释放连接驱动
     */
    private function close()
    {
        foreach ($this->driverList as $db) {
            $db->close();
        }
    }

    /**
     * 析构函数
     */
    function __destruct()
    {
        $this->close();
    }

}
