<?php
/**
 * 数据库操作接口
  * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 */
interface DbInterface{

    public function connect(); //获得连接   参数为表名

    public function close(); //关闭数据库

    public function exe($sql); //发送没有返回值的sql

    public function query($sql); //有返回值的sql

    public function getInsertId(); //获得最后插入的id

    public function getAffectedRows(); //受影响的行数

    public function getVersion(); //获得版本

    public function beginTrans(); //自动提交模式true开启false关闭

    public function commit(); //提供一个事务

    public function rollback(); //回滚事务

    public function escapeString($str); //数据安全处理

    public function link($table, $full);//获得链接

    /**
     * 设置表
     * @param $table
     * @param $full
     * @return mixed
     */
    public function table($table, $full = false);//设置表
}
