<?php
class ViewTag extends Tag{

	 public $Tag= array(
			'include' => array('block' => 0, 'level' => 5,'method' => true),
            'foreach' => array('block' => 1, 'level' => 5),
			'empty'   => array('block' => 1, 'level' => 5),
			'isset'   => array('block' => 1, 'level' => 5),
			'null'    => array('block' => 1, 'level' => 5),
			'nonull'  => array('block' => 1, 'level' => 5),
		    'noempty' => array('block' => 1, 'level' => 5),
		    'for'     => array('block' => 1, 'level' => 5),
            'if'      => array('block' => 1, 'level' => 5),
            'elseif'  => array('block' => 2, 'level' => 0),
            'else'    => array('block' => 2, 'level' => 0),
            'js'      => array('block' => 0, 'level' => 0),
            'css'     => array('block' => 0, 'level' => 0),

        );


	//캯
    public function __init(){

    }

	  //ģļ
    public function _include($attr, $content, &$view){

		//滻
        $const = get_defined_constants(true);
        foreach ($const['user'] as $k => $v) {
            $attr['file'] = str_replace($k, $v, $attr['file']);
        }
        //ɾ
        $file = str_replace(__HOST__ . '/', '', trim($attr['file']));
        $view = new View();
		$filecontent =  View::getTemplateFile($file);
        return preg_replace("/\<!--{[\s\S]*?}--\>/","",file_get_contents($filecontent));
    }

	//ifǩ
    public function _if($attr, $content, &$view){
		$attr = self::parseAttrValue($attr);
		$php = "<?php if({$attr}){ ?>";
		$php .= $content;
        $php .= '<?php }?>';
        return $php;
    }

	//emptyǩ
    public function _empty($attr, $content){
		$attr = self::parseAttrValue($attr);
		$php = "<?php if (empty($attr)){ ?>";
		$php .= $content;
        $php .= '<?php }?>';
        return $php;
    }

	//noemptyǩ
    public function _noempty($attr, $content){
		$attr = self::parseAttrValue($attr);
		$php = "<?php if (!empty($attr)){ ?>";
		$php .= $content;
        $php .= '<?php }?>';
        return $php;
    }

	//issetǩ
    public function _isset($attr, $content){
		$attr = self::parseAttrValue($attr);
		$php = "<?php if (isset($attr)){ ?>";
		$php .= $content;
        $php .= '<?php }?>';
        return $php;
    }

	//nullǩ
    public function _null($attr, $content){
		$attr = self::parseAttrValue($attr);
		$php = "<?php if ($attr==''){ ?>";
		$php .= $content;
        $php .= '<?php }?>';
        return $php;
    }

	//nullǩ
    public function _nonull($attr, $content){
		$attr = self::parseAttrValue($attr);
		$php = "<?php if ($attr!==''){ ?>";
		$php .= $content;
        $php .= '<?php }?>';
        return $php;
    }

	//elseifǩ
    public function _elseif($attr, $content, &$view){
		$attr = self::parseAttrValue($attr);
        $php = "<?php }else if({$attr}){ ?>";
        return $php;
    }

	//elseǩ
    public function _else($attr, $content, &$view){
		$attr = self::parseAttrValue($attr);
        return "<?php }else{ ?>";
    }


	//foreachǩ
    public function _foreach($attr, $content){
		$attr = self::parseAttrValue($attr);
		$php = "<?php foreach ($attr){?>";
		$php .= $content;
        $php .= '<?php }?>';
        return $php;
    }

	//forǩ
    public function _for($attr, $content){
		$attr = self::parseAttrValue($attr);
		$php = "<?php for ($attr){?>";
		$php .= $content;
        $php .= '<?php }?>';
        return $php;
    }

}