<?php

if (!defined('KERNEL_PATH'))exit('No direct script access allowed');
/**
 * 加密解密处理类
 * 适合cookie与session及url加密解密处理
  * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 */

class Encry {

    static private $auth_key; //加密key
    static private $code = array(); //位运算种子

    /**
     * 生成加密KEY
     * @param $key
     */
    static private function createKey($key) {
        $key = is_null($key) ? C("AUTH_KEY") : $key;
        self::$auth_key = md5($key . $_SERVER['HTTP_USER_AGENT']);
    }

    /**
     * 位加密或解密
     * @param $string 加密或解密内容
     * @param $type 类型:1加密 2解密
     * @param $key
     * @return mixed|string
     */
    static private function cry($string, $type, $key) {
        self::createKey($key);
        $string = $type == 2 ? base64_decode($string) : substr(md5(self::$auth_key . $string), 0, 8) . $string;
        $str_len = strlen($string);
        $data = array();
        $auth_key_length = strlen(self::$auth_key);
        for ($i = 0; $i <= 256; $i++) {
            $data[$i] = ord(self::$auth_key[$i % $auth_key_length]);
        }
        $tmp = '';
        for ($i = $j = 1; $i < 256; $i++) {
            $j = $data[($i + $data[$i]) % 256];
            $tmp = $data[$i];
            $data[$i] = ord($data[$j]);
            $data[$j] = $tmp;
        }
        $code = '';
        $s = '';
        for ($n = $i = $j = 0; $i < $str_len; $i++) {
            $tmp = ($i + ($i % 256)) % 256;
            $j = $data[$tmp] % 256;
            $n = ($tmp + $j) % 256;
            $code = $data[($data[$j] + $data[$n]) % 256];
            $s.=chr(ord($string[$i]) ^ $code);
        }
        if ($type == 1) {
            return str_replace("=", "", base64_encode($s));
        } else {
            if (substr(md5(self::$auth_key . substr($s, 8)), 0, 8) == substr($s, 0, 8)) {
                return substr($s, 8);
            }
            return '';
        }
    }

    /**
     * 加密方法
     * @param string $data 加密字符串
     * @param null $key 密钥
     * @return mixed|string
     */
    static public function encrypt($data, $key = null) {
        return self::cry(serialize($data), 1, $key);
    }

    /**
     * 解密方法
     * @param string $data 解密字符串
     * @param null $key
     * @return mixed
     */
    static public function decrypt($data, $key = null) {
        return unserialize(self::cry($data, 2, $key));
    }

}