 <?php
/**
* ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
*/
 if (!defined('KERNEL_PATH'))exit('No direct script access allowed');
class Files {
	/*
    获取文件名后缀
    @param	string	$filename
    @return	string
     */
	static public function fileext($filename) {
        return addslashes(trim(substr(strrchr($filename, '.'), 1, 10)));
    }

	//写入文件
	static public function writeFiles($filename,$data,$mode='w+'){
		$fso = fopen($filename,$mode) or die($filename.'文件打开失败');
		fwrite($fso,$data);
		fclose($fso);
	}

	//删除文件
	static  public function delFlie($fliename){
		//获取文件编码
		$encoding = String::detect_encoding($fliename,1);
		$fliename = String::auto_charset($fliename,'utf-8',$encoding);
		if (file_exists($fliename)) {
			unlink($fliename);
		}
		return $fliename;
	}

	//删除目录和文件
	static  public function delDFlies($dirName){

		if ($handle = opendir($dirName)) {
			while (false !== ($item = readdir($handle))) {

			   if ($item != '.' && $item != '..'){
				   if (is_dir($dirName.'/'.$item)) {
						self::delDFlies($dirName.'/'.$item);
				   }else{
						@unlink($dirName.'/'.$item);
				   }
			   }
			}
		    closedir($handle);
			if(rmdir($dirName)){
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}

	//获取目录
	static public function getdirs($rootPath = './',$lockPaht='',$model='1'){
		$lockPath = str_replace('\\','/',$lockPaht);
		$CurrentPath = str_replace('\\','/',$rootPath);
		if( false != ($fso=@opendir($CurrentPath))){
			while (false != ($file=@readdir($fso))){
				if ($model==1){
					if( $file!='.' && $file!='..' && !strpos($file,'.') ){
					  $dirList[] = $file;
					}
				}else{
					$fullpath=$CurrentPath.'/'.$file;
					$is_dir	= @is_dir($fullpath);
					if($is_dir=='1'){
						if($file!='..' && $file!='.'){
							$dirList['list'][] = array('name'=>$file,'currentpath'=>urlencode($CurrentPath),'fullpath'=>urlencode($fullpath));
						}else{
							if($file=='..'  && realpath($CurrentPath)!=realpath($lockPath)){
								$dirList['superior'] = array('name'=>dirname($CurrentPath),'currentpath'=>urlencode($CurrentPath));
							}
						}
					}
				}
			}
		}else{
			$dirList[] = '[Path]:\''.$Dir.'\' is not a dir or not found!';
		}
		@closedir($fso);
		$dirList =String::auto_charset($dirList);
		return $dirList;
	}


	//获取文件
	static public function getfile($rootPath='./',$ext='.',$model=1){
		$CurrentPath = str_replace('\\','/',$rootPath);
		if( false != $fso=@opendir($rootPath)){
			while ( false != ($file=@readdir($fso))) {
				if ($model==1){
					if( $file!='.' && $file!='..' && strpos($file,$ext) ){$fileList[] = $file;}
				}else{
					$fullpath= $rootPath.'/'.$file;
					$is_dir	= @is_dir($fullpath);
					if($is_dir=='0' && strpos($file,$ext)){
						$fileList[] = array(
							'name'       =>$file,
							'currentpath'=> urlencode($rootPath),
							'fullpath'   => $fullpath,
							'lastsave'   => date("Y-m-d H:i:s",filemtime($fullpath)),
							'size'       => self::getRealSize(@filesize($fullpath)),
							'ext'        => self::fileext($file)
						);
					}
				}
			}
			@closedir($fso);
			$fileList =String::auto_charset($fileList);
			return $fileList;
		}else{
			$fileList[] = '[Path]:\''.$Dir.'\' is not a dir or not found!';
		}
	}

	 /**
     * 复制目录
     * @param string $olddir 原目录
     * @param string $newdir 目标目录
     * @param bool $strip_space 去空白去注释
     * @return bool
     */
    static public function copy($olddir, $newdir, $strip_space = false){
        $olddir = self::dirPath($olddir);
        $newdir = self::dirPath($newdir);
        if (!is_dir($olddir))
            error("复制失败：" . $olddir . "目录不存在");
        if (!is_dir($newdir))
            self::create($newdir);
        foreach (glob($olddir . '*') as $v) {
            $to = $newdir . basename($v);
            if (is_file($to))
                continue;
            if (is_dir($v)) {
                self::copy($v, $to, $strip_space);
            } else {
                if ($strip_space) {
                    $data = file_get_contents($v);
                    file_put_contents($to, strip_space($data));
                } else {
                    copy($v, $to);
                }
                chmod($to, "0777");
            }
        }
        return true;
    }

	// 单位自动转换函数
    static public function getRealSize($size){
        $kb = 1024;         // Kilobyte
        $mb = 1024 * $kb;   // Megabyte
        $gb = 1024 * $mb;   // Gigabyte
        $tb = 1024 * $gb;   // Terabyte

        if($size < $kb){
            return $size." B";
        }else if($size < $mb){
            return round($size/$kb,2)." KB";
        }else if($size < $gb){
            return round($size/$mb,2)." MB";
        }else if($size < $tb){
            return round($size/$gb,2)." GB";
        }else{
            return round($size/$tb,2)." TB";
        }
    }

	/**
     * @param string $dir_name 目录名
     * @return mixed|string
     */
    static public function dirPath($dir_name){
        $dirname = str_ireplace("\\", "/", $dir_name);
        return substr($dirname, "-1") == "/" ? $dirname : $dirname . "/";
    }

	/**
     * 批量创建目录
     * @param $dirName 目录名数组
     * @param int $auth 权限
     * @return bool
     */
    static public function create($dirName, $auth = 0755){
        $dirPath = self::dirPath($dirName);
        if (is_dir($dirPath))
            return true;
        $dirs = explode('/', $dirPath);
        $dir = '';
        foreach ($dirs as $v) {
            $dir .= $v . '/';
            if (is_dir($dir))
                continue;
            mkdir($dir, $auth);
        }
        return is_dir($dirPath);
    }

	/**
     * 目录下创建安全文件
     * @param $dirName 操作目录
     * @param bool $recursive 为true会递归的对子目录也创建安全文件
     */
    static public function safeFile($dirName, $recursive = false){
        $file = ROOT_PATH . 'TPl/index.html';
        if (!is_dir($dirName)) {
            return;
        }
        $dirPath = self::dirPath($dirName);
        /**
         * 创建安全文件
         */
        if (!is_file($dirPath . 'index.html')) {
            copy($file, $dirPath . 'index.html');
        }
        /**
         * 操作子目录
         */
        if ($recursive) {
            foreach (glob($dirPath . "*") as $d) {
                is_dir($d) and self::safeFile($d);
            }
        }
    }
}
