<?php
/**
 * session处理类
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================

 */
 if (!defined('KERNEL_PATH'))exit('No direct script access allowed');
final class Session{

    /**
     *  开启SESSION
     *  系统会对SESSION开启状态进行自动配置，所以这个方法不要使用
     */
    static function start()
    {
        session_id() || session_start();
    }


    /**
     * 返回SESSION_NAME的值
     * @return type
     */
    static function getSessionName()
    {
        self::start();
        return session_name();
    }

    /**
     * 获得SESSION_ID
     * @return string
     */
    static function getSessionId()
    {
        self::start();
        return session_id();
    }


    /**
     * 删除所有SESSION值，释放SESSION_ID
     */
    static function destroy()
    {
        self::start();
        session_unset();
        session_destroy();
    }

    /**
     * 设置SESSION存储路径
     * @param type $path
     */
    static function setSavePath($path)
    {
        self::start();
        if (!is_dir($path)) {
            Dir::create($path);
        }
        session_save_path($path);
    }


    /**
     *  设置SESSION_ID生命周期
     * @param type $time    SESSION生命周期，秒数
     */
    static function setCookie($time = null)
    {
        $SESSION_COOKIE_LIFETIME = is_null($time) ? C("SESSION_COOKIE_LIFETIME") : $time;
        if ((int)$SESSION_COOKIE_LIFETIME > 0) {
            setcookie(session_name(), session_id(), time() + $SESSION_COOKIE_LIFETIME, '/');
        }
    }

}