<?php
/**
 * 表单验证处理类
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 */
 if (!defined('KERNEL_PATH'))exit('No direct script access allowed');
class Validate{

    /**
     * 内容不能为空
     *
     * @param $name
     * @param $value
     * @param $msg
     *
     * @return bool
     */
    public function _nonull($name, $value, $msg, $arg){
        if (empty($value)) {
            return $msg;
        } else {
            return true;
        }
    }

    /**
     * 邮箱验证
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _email($name, $value, $msg, $arg){
        $preg
            = "/^([a-zA-Z0-9_\-\.])+@([a-zA-Z0-9_-])+((\.[a-zA-Z0-9_-]{2,3}){1,2})$/i";
        if (preg_match($preg, $value)) {
            return true;
        } else {
            return $msg;
        }
    }

    /**
     * 最大长度验证
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _maxlen($name, $value, $msg, $arg){
        if (mb_strlen($value, 'utf-8') <= $arg) {
            return true;
        } else {
            return $msg;
        }
    }

    /**
     * 最小长度验证
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _minlen($name, $value, $msg, $arg){
        if (mb_strlen($value, 'utf-8') >= $arg) {
            return true;
        } else {
            return $msg;
        }
    }

    /**
     * 网址验证
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _http($name, $value, $msg, $arg){
        $preg
            = "/^(http[s]?:)?(\/{2})?([a-z0-9]+\.)?[a-z0-9]+(\.(com|cn|cc|org|net|com.cn))$/i";
        if (preg_match($preg, $value)) {
            return true;
        } else {
            return $msg;
        }
    }

    /**
     * 电话号码
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _tel($name, $value, $msg, $arg){
        $preg = "/(?:\(\d{3,4}\)|\d{3,4}-?)\d{8}/";
        if (preg_match($preg, $value)) {
            return true;
        } else {
            return $msg;
        }
    }

    /**
     * 手机号验证
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _phone($name, $value, $msg, $arg){
        $preg = "/^\d{11}$/";
        if (preg_match($preg, $value)) {
            return true;
        } else {
            return $msg;
        }
    }

    /**
     * 身份证验证
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _identity($name, $value, $msg, $arg)
    {
        $preg = "/^(\d{15}|\d{18})$/";
        if (preg_match($preg, $value)) {
            return true;
        } else {
            return $msg;
        }
    }

    /**
     * 用户名验证
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _user($name, $value, $msg, $arg)
    {
        //用户名长度
        $len = mb_strlen($value, 'utf-8');
        $arg = explode(',', $arg);
        if ($len >= $arg[0] && $len <= $arg[1]) {
            return true;
        } else {
            return $msg;
        }
    }


	/**
     * 用户密码验证
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _psw($name, $value, $msg='密码必须包含是英文字母和数字<br>并且长度必须位6-20位', $arg='6,20'){

	   $arg = explode(',', $arg);
	   if(!preg_match("/([0-9].*([a-zA-Z].*|.*[a-zA-Z]){".$arg[0].",".$arg[1]."}|[a-zA-Z].*([0-9].*|.*[0-9]){".$arg[0].",".$arg[1]."}|.*([0-9].*[a-zA-Z]|[a-zA-Z].*[0-9]){".$arg[0].",".$arg[1]."})/",$value)){
            return true;
        } else {
            return $msg;
        }
    }


    /**
     * 数字范围
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _num($name, $value, $msg, $arg)
    {
        $arg = explode(',', $arg);
        if ($value >= $arg[0] && $value <= $arg[1]) {
            return true;
        } else {
            return $msg;
        }
    }

    /**
     * 正则验证
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _regexp($name, $value, $msg, $preg)
    {
        if (preg_match($preg, $value)) {
            return true;
        } else {
            return $msg;
        }
    }

    /**
     * 两个表单比对
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _confirm($name, $value, $msg, $arg){
        if ($value == $_POST[$arg]) {
            return true;
        } else {
            return $msg;
        }
    }

	/**
     * 两个表单是否相等，相等返回false
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _beq($name, $value, $msg, $arg)
    {
        if ($value == $arg) {
            return $msg;
        } else {
            return true;
        }
    }

	/**
     * 一个值是否大于某值，大于相等返回false
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _gt($name, $value, $msg, $arg)
    {
        if ($value > $arg) {
            return $msg;
        } else {
            return true;
        }
    }

	/**
     * 一个值是否小于某值，大于相等返回false
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _et($name, $value, $msg, $arg)
    {
        if ($value < $arg) {
            return $msg;
        } else {
            return true;
        }
    }

	/**
     * 两个表单是否相等，相等返回true
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _neq($name, $value, $msg, $arg)
    {
        if ($value == $arg) {
			return true;
        } else {
             return $msg;
        }
    }

    /**
     * 中文验证
     *
     * @param $name  变量名
     * @param $value 变量值
     * @param $msg   错误信息
     *
     * @return bool
     */
    public function _china($name, $value, $msg, $arg)
    {
        if (preg_match('/^[\x{4e00}-\x{9fa5}a-z0-9]+$/ui', $value)) {
            return true;
        } else {
            return $msg;
        }
    }

}