<?php
/**
 * Magic CMS 管理员
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
 **/
class IndexModule extends CommonModule{
	public function index(){
		$list = M('user')->where('utype=-1')->order('uid asc')->all();
		$this->assign('list', $list);
		$this->display();
	}

	public function edit(){
		$id = Q('get.id','','intval');

		$role  = M('role')->where('status=1')->all();

		if(!empty($id)){
			$admin = M('user')->where('uid='.$id)->find();
			$this->assign('admin', $admin);
		}

		$this->assign('role',$role);
		$this->display();
	}

	public function save(){
		if(IS_POST){

			$data = Q('post.');
			$data['utype']   = -1;
			$data['regtime'] = strtotime($data['regtime']);
			$data['logtime'] = strtotime($data['logtime']);
			$data['status']  = empty($data['status']) ? 0 : 1;

			if (!session('super_admin')  &&  $data['rid']==1)
				$this->error('不允许私自将自己设置为超级管理员');

			$db = M('user');

			$db->validate = array(
					array('uname', 'nonull', '账户名不能为空'),
					array('uname', 'user:6,20', '账户名长度应为6-20位'),
					array('nickname', 'nonull', '昵称不能为空'),
				);

			if (!$db->create($data)){$this->error($db->error);}

			if(empty($data['uid']) && empty($data['password'])) {
				$this->error('请输入密码');
			}elseif(!empty($data['password']) && $data['password'] != $data['repassword']) {
				$this->error('两次密码不一致');
			}elseif(!empty($data['repassword'])){
				if(!preg_match("/([0-9].*([a-zA-Z].*|.*[a-zA-Z]){6,20}|[a-zA-Z].*([0-9].*|.*[0-9]){6,20}|.*([0-9].*[a-zA-Z]|[a-zA-Z].*[0-9]){6,20})/",$data['repassword']))
					$this->error('密码必须包含是英文字母和数字<br>并且长度必须位6-20位');
				$data['password'] = encrypt($data['repassword']);
			}else{
				unset($data['password'],$data['repassword']);
			}

			if (empty($data['uid'])) {
				if($db->where("uname='".$data['uname']."' AND utype=-1")->find()) $this->error('该管理员已存在！');
					$result = $db->add($data);
			}else{
				$result = $db->save($data);
			}

			$result = $db->replace($data);

			if(session('uid')==$data['uid']) {
				foreach($_SESSION as $key=>$value){
					unset($_SESSION[$key]);
				}
				$msg = '，请重新登录';
			}else{
				$url = '?r=admin';
			}
			if ($result){
				$this->success('保存成功'.$msg,$url);
			}else{
				$this->error('保存失败');
			}

		}else{
			$this->error('非法请求');
		}
	}

	public function del(){
		$id = Q('get.id','','intval');
		if(empty($id)) $this->error('对不起，参数错误');
		$db = M('user');
		$info = $db ->where('uid='.$id)->find();

		if ($info['rid']==1 && $info['uid']==1)
			$this->error('超级管理员账号为内置账号，<br>无法删除，您可以修改账户<br>名或密码');
		if ($id == session('uid'))
			$this->error('删除失败，当前账号正在使用中无法删除');

		$res= $db->where('uid='.$id)->del();

		if($res){
			$this->success('删除成功','?r=admin');
		}else{
			$this->error('删除失败');
		}
	}
}