<?php
 /**
 * SuKeCMS	栏目管理
 * ============================================================================
 * 版权所有 2014 速科网络，并保留所有权利。
 * 网站地址: http://www.sukewl.com；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将SuKeCMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在SuKeCMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Author: Shiang.Chin
 * Date:2014/12/31
**/
class IndexModule extends CommonModule{

	public function index(){
		$pid = Q('get.pid','');
		if(!empty($pid)){$where   = 'pid='.$pid;}
		$list = M()
				->join('__class__ a JOIN __model__ b ON a.model=b.value')
				->field('a.catid,a.pid,a.name,a.status,a.sorter,a.ismenu,b.model,b.value')
				->where($where)
				->order('a.sorter asc')
				->all();
		$this->assign('list',$list);
		$this->display();
	}

	public function edit(){
		$catid=Q('get.id','','intval');
		if (Q('get.model')){$class['model'] = Q('get.model');}
		if (Q('get.pid','','intval')){$class['pid']   = Q('get.pid','1','intval');}
		$model   = M('model')->order('id asc')->all();

		//获取筛选属性值
		if(!empty($catid))
			$class= M('class')->where('catid='.$catid)->find();

		$this->assign('model', $model);
		$this->assign('class', $class);
		$this->assign('list', $this->channeltree());
		$this->display(Q('get.tpl',''));
	}



	public function save(){
		if(IS_POST){
			$data = $_POST;

			if ($data['catid']==$data['pid']) $this->error('上级栏目不能为栏目本身');

			$db = M('class');

			$db->validate = array(
					array('name', 'nonull', '栏目名称不能为空')
				);

			if (!$db->create($data)){$this->error($db->error);}

			if ($data['attribute']==4) {
				if ($data['pid']!=0) {
					$this->error('主频道栏目只能为顶级栏目');
				}

				$checkattr = $db->field('catid,name')->where("model='".$data['model']."' AND attribute=4")->find();

				if ($checkattr && $checkattr['catid']!==$data['catid']) {
					$this->error('主频道栏目只允许设置一个,当前主频道为【'.$checkattr['name'].'】');
				}

			}

			if (empty($data['savepath'])){
				$pypath=String::pinyin($data['name']);  //将汉字转换为拼音
				$data['savepath']='/'.str_replace('?','',$pypath);  //定义保存路径
			}

			$res = $db->replace($data);

			if($res){
				$this->success('栏目保存成功','?r=class');
			}else{
				$this->error('栏目保存失败');
			}
		}else{
			$this->error('非法请求');
		};
	}

	public function quick(){
		if(IS_POST){
			$data = $_POST;
			if ($data['catid']==$data['pid']) $this->error('上级栏目不能为栏目本身');
			$db = M('class');
			$db->validate = array(
					array('name', 'nonull', '栏目名称不能为空',2,3)
				);

			if (!$db->create($data)){$this->error($db->error);}
			if (empty($data['savepath'])){
				$pyPath=String::pinyin($data['name']);  //将汉字转换为拼音
				$data['savepath']='/'.str_replace('?','',$pyPath);
			}
			$res = $db->save($data);

			if($res){
				$this->success('栏目保存成功','?r=class');
			}else{
				$this->error('栏目保存失败');
			}

		}else{
			$this->error('非法请求');
		};
	}

	public function del(){
		$catid = Q('get.id','','intval');
		if(empty($catid)) $this->error('参数错误');
		$result = M('class')->find('pid='.$catid);
		if (!empty($result)){
			$this->error('该栏目下存在子栏目，请先删除子栏目');
		}

		$db = R('class');
		$db ->relation = array(
			'art_library' => array(// 关联表
					'type' => HAS_MANY, // 包含一条主表记录
					'parent_key'  => 'catid', //class 表字段
					'foreign_key' => 'catid', //artrary 表字段

				)
		 );

		$status = $db->del($catid);

		if($status){
			$this->success('栏目删除成功',$_SERVER['HTTP_REFERER']);
		}else{
			$this->error('对不起，栏目删除失败');
		}
	}

	public function sorter(){
		$data['sorter'] = Q('get.sorter','','intval');
		$db = M('class');
		if (empty($data['sorter'])) {
			$this->error('排序不能为空或不能为0');
		}
		$result = $db->data($data)->where('catid='.Q('get.id','','intval'))->update(); //更新信息
		if ($result){
			$this->success('排序更新成功',$_SERVER['HTTP_REFERER']);
		}else{
			$this->error('排序更新失败',$_SERVER['HTTP_REFERER']);
		}
	}

	public function ajaxsub(){
		$catid    = Q('get.id','','intval');
		$data[Q('get.type')]  = Q('get.do','','intval');
		$result = M('class')->data($data)->where('catid='.$catid)->update();
		if ($result){
			$this->success('操作成功',$_SERVER['HTTP_REFERER']);
		}else{
			$this->error('操作失败',$_SERVER['HTTP_REFERER']);
		}
	}
}