<?php
 /**
 * Magic CMS 修复优化表
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class ActionModule extends CommonModule{


	public function index(){
		
		
		$tables  = $_REQUEST['id'];
		$action  = $_REQUEST['action'];
		$reurl   = urldecode($_REQUEST['reurl']);

		if (empty($tables)) {
			$this->error('请选择要表',$reurl);
		}

		if (!is_array($tables)) {
			$tables = array($tables);
		}

		foreach ($tables  as $table) {
			if ($action=='optimize') {
				$result = M()->optimize($table,true);
			}elseif($action=='repair'){
				$result = M()->repair($table,true);
			}elseif($action=='truncate'){
				$result = M()->truncate($table,true);
			}elseif($action=='deltable'){
				$result = M()->dropTable($table,true);
			}
		}

		if ($result){
			$this->success('执行成功',$reurl);
		}else{
			$this->error('执行失败');
		}
	}


	public function editable(){
		$table    = Q('get.table');
		$data     = Q('post.');
		if (M()->tableExists($table,true)) {
			$info = M()->getTableInfo($table,true);
		}else{
			$this->error($table.'表不存在');
		}
		$this->assign('info',$info);
		$this->display();
	}

	public function savetable(){
		$data     = Q('post.');
		if (M()->tableExists($data['oldtable'],true)) {
			$result = M()->alterTable($data,$data['oldtable'],true);
			if ($result){
			$this->success('执行成功','?r=database');
			}else{
				$this->error('执行失败');
			}
		}else{
			$this->error($table.'表不存在');
		}
	}

	public function editfield(){
		$table     = Q('get.table');
		$field     = Q('get.field');
		if (M()->fieldExists($field,$table,true)) {
			$info = M()->getFieldinfo($field,$table,true);
		}else{
			$this->error($field.'字段不存在');
		}
		$this->assign('info',$info);
		$this->display();
	}


	public function savefield(){
		$data     = Q('post.');
		$reurl   = urldecode($_REQUEST['reurl']);
		if (M()->fieldExists($data['oldfield'],$data['table'],true)) {
			$field['name']     = $data['oldfield'];
			$field['length']   = $data['typeval'];
			$field['comment'] = $data['comment'];
			$field['newname']  = $data['field'];
			$field['type']     = $data['type'];
			$field['character']= $data['character'];
			$field['collation']= $data['collation'];

			if ($data['default-type']!=='NUll') {
				$field['value']    = $data['default'];
			}

			if ($data['null']==1) {
				$field['null'] = 1;
			}

			$result = M()->fieldSave($field,$data['table'],true);

			if ($result){
			$this->success('执行成功',$reurl);
			}else{
				$this->error('执行失败');
			}
		}else{
			$this->error($data['oldfield'].'字段不存在');
		}
	}
}