<?php
 /**
 * Magic CMS 数据库管理
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class FieldsModule extends CommonModule{
	public function index(){
		$table = Q('table');

		$list = M()->getAllField($table,true);
		$this->assign('list',$list);
		$this->display('Database/fields');
	}

	public function data(){
		$table = Q('table');
		$field = M()->getAllField($table,true);

		$count = M($table,true)->count();
		$page  = new Page($count,20);
		$list  = M($table,true)->limit($page->limit())->all();

		foreach ($list  as $lkey=>$fields) {
			$html .= '<tr';
			if ($lkey % 2 ==1) {
				$html .= ' class="odd" ';
			}
			$html .= '>';
			$i=0;
			foreach ($field  as $fkey=>$value) {
				if ($value['key']=='PRI') {
					$keys[$lkey][] = $fkey."='".$fields[$fkey]."'";
				}

				$key_str = implode(' AND ',$keys[$lkey]);

				if ($i==0) {

					$html .= '<td width="30" align="center"><input type="checkbox"  value="'.urlencode($key_str).'" name="id[]"></td>';
					$html .= "<td align='center' width='50'><a href='javascript:' onclick='confirms(\"数据删除后将无法恢复，<br>请谨慎操作，确认删除？\",\"?r=database-fields-del&table=".$table."&id=".urlencode($key_str)."\")' ><img src='".__PUBLIC__."/images/ico-00.png' width='15'></a></td>";
				}

				if ($value['type']=='text') {
					$html .= '<td align="center"  height="30" style="position:relative"><textarea name="'.$fkey.'" field-key="'.$key_str.'" field-type="'.$value['type'].'" readonly="readonly" class="finsty ftext">'.htmlspecialchars($fields[$fkey]).'</textarea></td>';
				}else{
					$html .= '<td align="center" height="30"><input type="text" name="'.$fkey.'" field-key="'.$key_str.'" field-type="'.$value['type'].'" readonly="readonly" class="finsty" value="'.htmlspecialchars($fields[$fkey]).'"></td>';
				}
				$i++;
			}
			$html .= '<tr>';
		}
		$this->assign('page',$page->show());
		$this->assign('field',$field);
		$this->assign('html',$html);
		$this->display('Database/data');
	}

	public function ajax(){
		$where = stripslashes($_POST['field_key']);
		$table = stripslashes($_POST['field_table']);
		$field = stripslashes($_POST['field_field']);
		$data[$field]  = stripslashes($_POST['field_val']);
		if($data[$field]!='' && !empty($where) && !empty($table)){
			$db = M($table,true);

			$result = $db->data($data)->where($where)->save();
			if ($result) {
				echo json_encode(array('content' =>'操作成功<script>setTimeout("$(\'.result\').hide()",3000);</script>','sql'=>$db->getLastSql()));
			}else{
				echo json_encode(array('content' =>'操作失败','sql'=>$db->getLastSql()));
			}
		}
	}

	public function delfield(){
		$field = $_REQUEST['id'];
		if (empty($field)) {
			$this->error('请选择要删除的字段');
		}
		$table = stripslashes($_REQUEST['table']);
		if (!is_array($field)) {
			$field = array($field);
		}

		foreach ($field  as $vo) {
			$result = M()->fieldDel($vo,$table,true);
		}

		if ($result) {
			$this->success('删除成功','?r=database-fields&table='.$table);
		}else{
			$this->error('删除失败');
		}
	}

	public function del(){
		$where = $_REQUEST['id'];
		if (empty($where)) {
			$this->error('请选择要删除的数据');
		}
		$table = stripslashes($_REQUEST['table']);
		if (!is_array($where)) {
			$where = array($where);
		}

		foreach ($where  as $value) {
			$result = M($table,true)->where(stripslashes(urldecode($value)))->del();
		}

		if ($result) {
			$this->success('删除成功','?r=database-fields-data&table='.$table);
		}else{
			$this->error('删除失败');
		}
	}
}