<?php

 /**
 * Magic CMS 字段管理
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class IndexModule extends CommonModule{

	public function index(){
		$type  = Q('get.type');
		$value = Q('get.value');
		$list = M('fields')->where($type."='".$value."'")->order('sorter asc')->all();
		$this->assign('value',$value);
		$this->assign('list',$list);
		$this->display();
	}


	public function edit(){
		$value = Q('get.value');
		$fieldid = Q('get.fieldid','','intval');
		$model   = M('model')->where("value='".$value."'")->find();
		$model['tabs'] = empty($model['tabs']) ? '' : explode('~',$model['tabs']);

		if (!empty($fieldid)){
			$field = M('fields')->where('fieldid='.$fieldid)->find();

			//还原属性中的回车
			foreach(unserialize($field['attribute']) as $ak=>$av){
				$reattribute[$ak] = str_replace('~',PHP_EOL,trim($av));
			}

			$this->assign('field',$field);
			$this->assign('attribute',$reattribute);
			$this->assign('dbattribute',unserialize($field['dbattribute']));
		}
		$this->assign('model',$model);
		$this->display();
	}

	public function save($gdataoth=array()){
		if(IS_POST){
			$dbname = array(
				'model'=>'art_'.Q('post.value'),
				'utype'=>'user_'.Q('post.value'),
			);
			$data = Q('post.');

			$dbattribute = Q('post.dbattribute');
			if($data['readonly']==false){
				if($data['key_type']==1){
					$dbattribute['key_type'] = 1;
					$dbattribute['key_name'] = Q('post.field');
				}elseif($data['key_type']==2){
					$dbattribute['key_type'] = 2;
					$dbattribute['key_name'] = Q('post.key_name') ? Q('post.key_name') : Q('post.field');
				}else{
					$dbattribute['key_type'] = 0;
				}
			}
			if($data['key_type']==3){
					$dbattribute['key_type'] = 3;
					$dbattribute['key_name'] = Q('post.key_name') ? Q('post.key_name') : Q('post.field');
			}

			$dbattribute['type'] = Q('post.dbtype');
			$dbattribute['name'] = Q('post.field');
			$dbattribute['isdb'] = Q('post.isdb');

			$attribute           = Q('post.attribute');
			$data[Q('post.type')]= Q('post.value');
			$data['dbattribute'] = serialize($dbattribute);

			 //替换属性中的回车
			foreach($attribute as $ak=>$av){
				$reattribute[$ak] = str_replace(PHP_EOL,'~',trim($av));
			}
			$data['attribute']    = serialize($reattribute);

			$db = M('fields');
			$db->validate = array(
					array('formtype', 'nonull', '请选择字段类型 ',2,3),
				);
			if (!$db->create($data)){$this->error($db->error);}


			if ($dbattribute['isdb']==1) {
				if (empty($dbattribute['name'])) {
					$this->error('请输入数据库字段名');
				}
				if (empty($dbattribute['type'])) {
					$this->error('请选择数据库字段类型');
				}
				if (empty($data['oldfield'])){
					$cdb = M()->fieldAdd($dbattribute,$dbname[Q('post.type')]);
				}else{
					$dbattribute['name']    = $data['oldfield'];
					$dbattribute['newname'] = $data['field'];
					$cdb = M()->fieldSave($dbattribute,$dbname[Q('post.type')]);
				}
				if (!$cdb){
					$this->error('数据库创建失败');
				}
			}

			$res = $db->replace($data);

			if ($res){
				$this->success('保存成功',$_POST['reurl']);
			}else{
				$this->error('添加失败');
			}
		}else{
			$this->error('非法请求');
		}
	}

	public function del(){
		$id      = Q('get.id');
		$field   = Q('get.field');
		$dbname = array(
			'model'=>'art_'.Q('get.model'),
			'utype'=>'user_'.Q('get.value'),
		);
		if (empty($id)){$this->error('参数错误');}
		if(M()->fieldExists($field,$dbname[Q('get.type')])){
			M()->fieldDel($field,$dbname[Q('get.type')]);
		}
		$result = M('fields')->where('fieldid = '.$id)->del();
		if ($result){
			$this->success('删除成功',$_SERVER['HTTP_REFERER']);
		}else{
			$this->error('删除失败',$_SERVER['HTTP_REFERER']);
		}
	}

	public function status(){
		$id              = Q('get.id','','intval');
		$data['status']  = Q('get.status','','intval');
		if (empty($id)){$this->error('参数错误');}
		$result = M('fields')->data($data)->where('fieldid='.$id)->save();
		if ($result){
			$this->success('操作成功',$_SERVER['HTTP_REFERER']);
		}else{
			$this->error('操作失败');
		}
	}


	public function sorter(){
		$data['sorter'] = Q('get.sorter','','intval');
		if(empty($data['sorter'])) {$this->error('排序不能为空或不能为0');}
		$db = M('fields');
		if (!$db->create($data)){$this->error($db->error);}
		$result = $db->data($data)->where('fieldid='.Q('get.fieldid','','intval'))->save(); //更新信息
		if ($result){
			$this->success('排序更新成功',$_SERVER['HTTP_REFERER']);
		}else{
			$this->error('排序更新失败');
		}
	}
}