<?php
 /**
 * Magic CMS 文件管理
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class IndexModule extends CommonModule{

	public function index(){
		$currentpath = $_POST['path']?$_POST['path']:($_GET['path']?$_GET['path']:false);
		//初始化目录
		if($currentpath==false){$currentpath = '../';}
		$dirs  = Files::getdirs($currentpath,'../',2);
		$files = Files::getfile($currentpath,'.',2);
		$this->assign('dirs', $dirs);
		$this->assign('files', $files);
		$this->display();
	}

	//编辑文件
	public function edit(){
		$path = @$_GET['path'];
		$file = @$_GET['file'];
		if (empty($path) || empty($file)){
			$this->alert('参数错误');
		}
		$filepath = $path.'/'.$file;
		if(file_exists($filepath)){
			$content=file_get_contents($filepath);
			$this->assign('file',array(
					'content'=>String::auto_charset($content,String::detect_encoding($content)),
					'name'   =>$file,
					'ext'    =>files::fileext($file)
				  ));
			//转换编码后的文件路径，防止中文错误
			$this->assign('fullpath',String::auto_charset($filepath),String::detect_encoding($content));
		}else{
			$this->alert('文件无法编辑');
		}
		$this->display();
	}

	//保存文件
	public function save(){
		$path = @$_POST['path'];
		$content = $_POST['content'];

		if (empty($path)){
			$this->error('参数错误');
		}
		if(IS_POST){
			$result = @file_put_contents($path,Stripslashes($content));
			if ($result){
				$this->success('保存成功',$_SERVER['HTTP_REFERER']);
			}else{
				$this->error('保存失败');
			}
		}else{
			$this->error('非法请求');
		}
	}


	//删除目录/文件
	public function del(){
		$type    = Q('get.type');
		$prapath = @$_GET['path'];
		if (empty($prapath)){
			$this->error('参数错误');
		}

		if ($type==1){ //删除文件
			$result = Files::delFlie($prapath);
		}elseif($type==2){//删除目录/文件
			$result = Files::delDFlies($prapath);
		}else{
			$this->error('未知操作');
		}
		if ($result){
			$this->success('删除成功',$_SERVER['HTTP_REFERER']);
		}else{
			$this->error('删除失败');
		}
	}

}