<?php
  /**
 * Magic CMS 文件上传
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class UploadModule extends CommonModule{

	public function index(){
    	//保存目录
		$upload_save_path =  C('UPLOAD_SAVE_PATH') ? C('UPLOAD_SAVE_PATH') : '../Uploads/';
		//上传目录
		$upload_path = trim($_GET['dir'])=='' ? 'image' : trim($_GET['dir']);

		//定义上传的文件扩展名
		$ext_type = C('UPLOAD_ALLOW_TYPE');
		if (empty($ext_type)){
			$ext_type = array(
	            'IMAGE'  => array('gif', 'jpg', 'jpeg', 'png', 'bmp'),
	            'MEDIA'  => array('swf', 'flv', 'mp3','mp4','f4v','wav', 'wma', 'wmv', 'mid', 'avi', 'mpg', 'asf', 'rm', 'rmvb'),
	            'FILE'   => array('doc', 'docx', 'xls', 'xlsx', 'zip', 'rar', 'gz', 'bz2','pdf'),
		);}

		//允许上传文件大小
		$file_size = C('UPLOAD_ALLOW_SIZE')=='' ? 2097152 : C('UPLOAD_ALLOW_SIZE');
		$upload   = new Upload($upload_save_path.$upload_path.'/'.date("Ymd"),$ext_type[strtoupper($upload_path)],$file_size);
		$uplofile = $upload->upload();

		if($uplofile){
			if (C('WATER_ON') && in_array($uplofile[0]['ext'],$ext_type['IMAGE'])){
				$water = new Image();
				$water->water($uplofile[0]['path']);
			}
			if (C('THUMB_ON') && in_array($uplofile[0]['ext'],$ext_type['IMAGE'])){
				$thumb = new Image();
				$thumb->thumb($uplofile[0]['path']);
			}
			echo json_encode(array('error' => 0, 'url' =>ltrim($uplofile[0]['path'],'..')));
		}else{
			$this->error($upload->getError());
		}
	}

}