<?php
 /**
 * Magic CMS 模板选择器
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class IndexModule extends CommonModule{

	public function index(){
		//读取端配置
		require(ROOT_PATH.'/Data/Config/config.php');
		$tplpath = ROOT_PATH.C('TPL_PATH').$config['TPL_STYLE'];

		$currentPath = $_POST['path']?$_POST['path']:($_GET['path']?$_GET['path']:false);
		//初始化目录
		if($currentPath==false){$currentPath =$tplpath;}
		$dirs  = Files::getdirs($currentPath,$tplpath,2);
		$files = Files::getfile($currentPath,'.html',2);

		foreach ($files as $key=>$file){
			$path = str_replace($tplpath,'',dirname($file['fullpath']));
			$files[$key]['path'] = empty($path) ? $file['name'] : ltrim($path.'/'.$file['name'],'/');
			$files[$key]['exp']  = $this->getExp($file['fullpath']);
		}

		$this->assign('dirs', $dirs);
		$this->assign('files', $files);
		$this->display();
	}


	/**
	 * 获取模板注释内容
	 * @param $filename 文件内容
	 */
	private function getExp($filename){
		if(file_exists($filename) && preg_match_all("/\<!--{[\s\S]*?}--\>/",file_get_contents($filename),$info)){
			foreach ($info[0] as $k => $v){
				$content = str_replace(array("\r\n", "\r", "\n"),'|',str_replace(array("<!--{","}-->"),"",$v));
				$contarr = explode("|",$content);
				foreach ($contarr as $rk=>$re){
					if (!empty($re)){
						$dd[$rk] = explode(":",$re);
					}
				}
				foreach ($dd as $ck=>$cv){
					$contents[$k][trim($cv[0])] = trim($cv[1]);
				}
			}
			if (count($contents)>1){
				return $contents;
			}else{
				return $contents[0];
			}
		}
	}
}