<?php
 /**
 * Magic CMS 留言板
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class IndexModule extends CommonModule{

	public function index(){
		$count=M('addgbook')->count();
		$page = new Page($count,20);
		$list=M('addgbook')->order('id desc')->limit($page->limit())->select();
		$this->assign('page',$page->show());
		$this->assign('list', $list);
		$this->display();
	}

	public function edit(){
		$id = Q('get.id','','intval');
		if(empty($id)) $this->error('参数错误');
		$guestbook= M('addgbook')->where('id='.$id)->find();
		$ipinfo = Http::doGet('http://ip.taobao.com/service/getIpInfo.php?ip='.$guestbook['ip']);
		$ipinfo = json_decode($ipinfo);

		if ($ipinfo->code==0)
			$this->assign('ipinfo',$ipinfo->data->country.$ipinfo->data->region.$ipinfo->data->city.'['.$ipinfo->data->isp.']');
		$this->assign('guestbook', $guestbook);

		message('gbook',0,$id,'del');

		$this->display();
	}

	public function save(){
		$id=Q('post.id','','intval');
		if(empty($id)) $this->error('参数错误');
		if(IS_POST){
			$data = Q('post.');
			$db   = M('addgbook');
			$db->validate = array(
					array('title', 'nonull', '留言标题不能为空',2,3),
					array('content', 'nonull', '留言内容不能为空',2,3),
					array('datetime', 'nonull', '添加时间不能为空',2,3)
				);

			if (!$db->create($data)){$this->error($db->error);}
			$db->replace($data);
			$this->success('保存成功','?r=guestbook');
		}else{
			$this->error('非法请求');
		};
	}

	function del(){
		$id=Q('get.id','','intval');
		if(empty($id)) $this->error('参数错误');
		$info=M('addgbook')->where('id='.$id)->delete();
		if($info){
			$this->success('留言删除成功','?r=guestbook');
		}else{
			$this->error('该留言不存在');
		}
	}

}