<?php
 /**
 * Magic CMS 后台首页
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class IndexModule extends CommonModule{
	public function index(){

		//超级管理员返回所有菜单
		if(session('super_admin')){
			$node  = M('node')
					->where('menu>0 AND menu<3 AND status=1')
				    ->field('nid,pid,module,controller,action,param,title')
				    ->order('sorter asc')->all();
		}else{
            //普通管理员权限节点
            $node = M()
                ->join(" __access__ a RIGHT JOIN __node__ n ON n.nid=a.nid")
                ->where("n.menu>0 AND n.menu<3  AND n.status=1 AND a.rid=".session('rid'))
                ->order('sorter ASC')
                ->all();
		}

		//快捷面板
		$user_panel = array_columns(M('user_panel')->where('uid='.session('uid'))->field('nid')->order('sorter asc')->all());

	    //设置链接
		if(!empty($node)){
			foreach ($node as $n => $v) {
				$param = empty($v['param']) ? '' : '&param=' . $v['param'];
				$node[$n]['url'] = "?r={$v['module']}-{$v['controller']}-{$v['action']}" . $param;
			}
		}

		foreach ($node as $un => $uv) {
			if(in_array($uv['nid'],$user_panel))
				$panel[] = $uv;
		}

		$node  = Data::channelLevel($node, 0, '&nbsp;','nid');

		$this->assign('user_panel',$panel);
		$this->assign('node',$node);
		$this->display();
	}

	//记事本
	public function note(){
		$action = Q('get.act');
			$db = M('user_note');
			if ($action=='read'){
				$note=$db->where('id=1')->find();
				$this->assign('note',$note);
				echo $this->display('Index/note',null,  null,null,null,false);
			}else{
				$db->data(array('content'=>Q('post.content')))->where('id=1')->save();
			}
	}

	public function welcome(){

		$artlist = M('art_library')->order('pubtime asc')->field('title,catid,id')->where('status=1')->limit(7)->all();
		$cercode = decode(@file_get_contents(ROOT_PATH.'Data/license.cer'));

		$cercode = explode('|',$cercode);
		$this->assign('verInfo',C('ver'));
		$this->assign('artlist',$artlist);
		$this->assign('cercode',$cercode);
        $this->display();
	}
}