<?php
 /**
 * Magic CMS 友情链接
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class IndexModule extends CommonModule{

	public function index(){
		$count =M('addlinks')->count();
		$page  = new Page($count,20);
		$links =M('addlinks')->order('id desc')->limit($page->limit())->all();
		$this->assign('page',$page->show());
		$this->assign('links', $links);
		$this->display();
	}

	public function edit(){
		$id=Q('get.id','','intval');
		if (!empty($id)){
			$links= M('addlinks')->where('id='.$id)->find();
			if (empty($links)){
				$this->error('友情链接不存在');
			}else{
				$this->assign('links', $links);
			}
		}
		$this->display();
	}

	public function save(){
		$id=Q('get.id','','intval');
		if(IS_POST){
			$data=$_POST;
			$db=M('addlinks');
			$db->validate = array(
					array('title', 'nonull', '网站名称不能为空',2,3),
					array('url', 'nonull', '链接地址不能为空',2,3)
				);

			if (!$db->create($data)){$this->error($db->error);}
			$db->replace($data);
			$this->success('保存成功','?r=links');
		}else{
			$this->error('非法请求');
		};
	}

	function del(){
		$id=Q('get.id','','intval');
		if(empty($id)) $this->error('参数错误');
		$info=M('addlinks')->where('id='.$id)->delete();
		if($info){
			$this->success('删除成功','?r=links');
		}else{
			$this->error('该友情链接不存在');
		}
	}


}