<?php
 /**
 * Magic CMS 后台登录
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class IndexModule extends CommonModule{

     /**
     * 用户登录操作
     */
    public function index(){

		if(IS_POST && Q('post.action')=='login'){

			$uname    = Q('post.username');
			$password = Q('post.password');
			$verify   = Q('post.verify');

			$db = M('user');

			$db->validate = array(
				array('username', 'nonull', '请输入用户名'),
				array('password', 'nonull', '请输入密码'),
				array('verify', 'nonull', '请输入验证码'),
				array('verify', 'neq:'.Q('session.verify'), '请输入正确的验证码'),
			);

			if (!$db->create($data)) $this->alert($db->error,'?r=login');

			$user = $db
					->where(array('uname'=>$uname,'password'=>encrypt($password),'utype'=>-1))
					->field('uid,uname,nickname,logtime,status,rid,ip,lognum')
					->find();

			if (!$user)
				$this->alert('用户名不存在或密码错误','?r=login');
			if (!$user['status'])
				$this->alert('对不起，登录失败,该用户被禁用','?r=login');
			if (!$user['rid'])
				$this->alert('对不起，登录失败,该用户没有访问权限','?r=login');
			if($user['rid']==1)
				session('super_admin',1);

			session('uid',     $user['uid']);
			session('uname',   $user['uname']);
			session('nickname',$user['nickname']);
			session('logtime', Date('Y-m-d H:i:s',$user['logtime']));
			session('lognum',  $user['lognum']);
			session('logip',   $user['ip']);

			//更新登录信息
			$db->data(array('ip'=>get_client_ip(),'logtime'=>time()))
				->where(array('uid'=>$user['uid']))
				->save();
			$db->inc('lognum','uid='.$user['uid']);

			echo '<script>window.top.location.href="?r=index"</script>';
		}
		$this->display();
    }

	//显示验证码
	public function verify(){
		$verify = new Verify();
        $verify->show('eD', 20, 4, 5, '#000000', 0, '#68B71A',110, 46, 'png', 'LDXCG', 50, 5, 3);
    }

    // 用户退出
    public function logout(){
		foreach($_SESSION as $key=>$value){
			unset($_SESSION[$key]);
		}
        echo '<script language="javascript" type="text/javascript">window.top.location.href="?r=login"</script>';
    }
}

?>