<?php
 /**
 * Magic CMS 模型管理
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class IndexModule extends CommonModule{

	public function index(){
		$list = M('model')->order('id asc')->all();
		$this->assign('list',$list);
		$this->display();
	}

	public function edit(){
		$id    = Q('get.id','','intval');
		if (!empty($id)){
			$model = M('model')->where("id=$id")->find();
			if(!empty($model['tabs'])) {
				$model['tabs'] = str_replace('~',PHP_EOL,trim($model['tabs']));
			}
			$this->assign('model',$model);
		}
		$this->display();
	}


	public function save(){
		if(IS_POST){
			$data = Q('post.');
			$data['tabs'] = str_replace(PHP_EOL,'~',trim($data['tabs']));
			$db = M('model');
			$db->validate = array(
					array('model', 'nonull', '请输入模型名称',2,3),
					array('value', 'nonull', '请输入数据库表名',2,3),
				);

			if (!$db->create($data)){$this->error($db->error);}

			//新建模型
			if (empty($data['id'])){

				$model_path = ROOT_PATH.'Module/';
				//前台模型文件
				$model_files = array(
					'0'=> 'Article/IndexModule.class.php',
					'1'=> 'Article/ContentModule.class.php'
				);

				foreach ($model_files  as $file) {
					if(!file_exists($model_path.$file)){
						$this->error('模型创建失败，缺少核心缺失！');
					}
				}

				//检测数据库是否存在
				if (M()->tableExists('art_'.$data['value'])){
					$this->error('数据库表名已存在，请重新输入');
				}

				/*===============================================检测通过后开始创建模型==================================================*/

				//复制核心文件
				foreach ($model_files  as $file) {
					if(!Files::copy($model_path.'Article',$model_path.ucfirst($data['value']))){
						$this->error('模型创建失败，创建核心失败，请检测目录写入权限！');
					}
				}
				//创建模型数据库表
				$creadb =  M()->exe("CREATE TABLE `__art_{$data['value']}__` (`pid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '文档ID',`content` text,PRIMARY KEY (`pid`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='".$data['model']."扩展表'");

				//写入系统字段
				if($creadb){

					$sql="INSERT INTO `__fields__` (`utype`,`model`,`field`,`name`,`tips`,`css`,`minlength`,`maxlength`,`pattern`,`errortips`,`formtype`,`attribute`,`attach`,`layout`,`issystem`,`sorter`,`status`,`addattach`,`dbattribute`,`key_type`,`tabs`,`isdb`) VALUES
						  (NULL,'{$data['value']}','status','是否发布','','',0,0,'','','radio','a:2:{s:6:\"option\";s:11:\"是|1~否|0\";s:5:\"value\";s:1:\"1\";}','',0,1,8,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:1:\"1\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"TINYINT\";s:4:\"name\";s:6:\"status\";s:4:\"isdb\";N;}','',-1,''),
						  (NULL,'{$data['value']}','sortrank','置顶选项','','',0,0,'','','select','a:3:{s:6:\"option\";s:0:\"\";s:4:\"type\";s:1:\"1\";s:5:\"value\";s:0:\"\";}','',1,1,9,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:1:\"3\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"TINYINT\";s:4:\"name\";s:8:\"sortrank\";s:4:\"isdb\";N;}','',-1,''),
						  (NULL,'{$data['value']}','weight','权重','权重越小越靠前','',0,0,'','','text','a:2:{s:4:\"size\";s:1:\"5\";s:5:\"value\";s:3:\"100\";}','',2,1,4,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:6:\"weight\";s:4:\"isdb\";N;}','',-1,''),
						  (NULL,'{$data['value']}','content','文档内容','','',0,0,'','','editor','a:4:{s:4:\"type\";s:1:\"0\";s:4:\"cols\";s:3:\"800\";s:4:\"rows\";s:3:\"350\";s:5:\"value\";s:0:\"\";}','',0,1,7,1,'','a:6:{s:8:\"key_name\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:4:\"TEXT\";s:4:\"name\";s:7:\"content\";s:4:\"isdb\";N;}','',-1,''),
						  (NULL,'{$data['value']}','hits','浏览量','','',0,0,'','','text','a:2:{s:4:\"size\";s:1:\"5\";s:5:\"value\";s:0:\"\";}','',2,1,5,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:4:\"hits\";s:4:\"isdb\";s:1:\"1\";}','',-1,1),
						  (NULL,'{$data['value']}','catid','所属栏目','','',0,0,'','请选择所属于栏目','select','a:3:{s:6:\"option\";s:0:\"\";s:4:\"type\";s:1:\"1\";s:5:\"value\";s:0:\"\";}','',1,1,3,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:5:\"catid\";s:4:\"isdb\";N;}','',-1,''),
						  (NULL,'{$data['value']}','pubtime','发布时间','','',0,0,'','','datetime','a:4:{s:6:\"istime\";s:1:\"1\";s:6:\"isinte\";s:1:\"0\";s:4:\"size\";s:2:\"25\";s:6:\"format\";s:19:\"YYYY-MM-DD hh:mm:ss\";}','',0,1,10,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:7:\"pubtime\";s:4:\"isdb\";N;}','',-1,''),
						  (NULL,'{$data['value']}','title','文档标题','','',0,0,'','请输入标题','text','a:2:{s:4:\"size\";s:2:\"60\";s:5:\"value\";s:0:\"\";}','',0,1,1,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:5:\"title\";s:4:\"isdb\";N;}','',-1,''),
						  (NULL,'{$data['value']}','flag','推荐位','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',0,1,2,1,'','a:6:{s:8:\"key_name\";s:4:\"flag\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:4:\"flag\";}',2,-1,1),
					  	  (NULL,'{$data['value']}','abstract','摘要','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',0,1,6,1,'','a:7:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:8:\"abstract\";}','',-1,1)";

					M()->exe($sql);
				}
			}

			$result = $db->replace($data);

			if($result){
				$this->success('保存成功','?r=model');
			}

		}else{
			$this->error('非法请求');
		}
	}

	public function del(){
		$id     = Q('get.id');
		$model  = Q('get.value');

		if ($model){

			Files::delDFlies(ROOT_PATH.'Module/'.ucfirst($model));

			if(M()->tableExists('art_'.$model)){
				M()->dropTable('art_'.$model);
			}
			$result = M('fields')->where("model='".$model."'")->del();
		}

		$result = M('model')->where('id='.$id)->del();

		if ($result){
			$this->success('删除成功',$_SERVER['HTTP_REFERER']);
		}else{
			$this->error('删除失败');
		}
	}

	public function status(){
		$id              = Q('get.id','','intval');
		$data['status']  = Q('get.status','','intval');
		if (empty($id)){$this->error('参数错误');}
		$result = M('model')->data($data)->where('id='.$id)->save();
		if ($result && $node){
			$this->success('操作成功',$_SERVER['HTTP_REFERER']);
		}else{
			$this->error('操作失败');
		}
	}
}