<?php
 /**
 * Magic CMS 系统设置
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class IndexModule extends CommonModule{

	public function __construct(){
		 parent::__construct();
	}

    public function index(){
		//加载前端配置文件
		require(ROOT_PATH . 'Data/Config/config.php');
		$this->assign('config_site',$config);
        $this->display();
    }

	//保存配置
    public function save(){
		if(IS_POST){

			$config_site      = $_POST['site'];
			$config_admin     = $_POST['admin'];
			$config_common	  = $_POST['common'];

			if(empty($config_common['UPLOAD_IMAGE_TYPE']))  $this->error('必须设置允许上传的图片类型');
			if(empty($config_common['UPLOAD_FILE_TYPE']))   $this->error('必须设置允许上传的软件类型');
			if(empty($config_common['UPLOAD_MEDIA_TYPE']))  $this->error('必须设置允许上传的多媒体类型');

			$config_common['UPLOAD_ALLOW_TYPE']="array('IMAGE'=>array('".str_ireplace("|","', '",$config_common['UPLOAD_IMAGE_TYPE'])."'),'MEDIA'=>array('".str_ireplace("|","', '",$config_common['UPLOAD_MEDIA_TYPE'])."'),'FILE'=>array('".str_ireplace("|","', '",$config_common['UPLOAD_FILE_TYPE'])."'))";

			//写入前台配置
			$write_site      = CA(ROOT_PATH    . 'Data/Config/config.php' , $config_site);
			$write_admin     = CA(DATA_PATH     . 'Config/config.php',            $config_admin);
		    $write_common    = CA(CONFIG_PATH . 'Config.class.php',                $config_common);

			if ($write_site && $write_admin && $write_common) {
				$this->success('保存成功','?r=system');
			}else{
				$this->error('保存失败');
			}
		}else{
			$this->error('非法请求');
		}
    }

	public function rewriter(){
			$category = M('class')->where('status=1')->order('sorter asc')->all();
			$rewStr  = "RewriteEngine on \r\n";
			foreach ($category as $rk=>$rv){
				if($rv['attribute']!=3){
				//生成htaccess规则
				$rewStr .= "RewriteRule ^".ltrim($rv['savepath'],'/')."$ /?r=".$rv['model']."&id=".$rv['catid']." [L] \r\n";
				$rewStr .= "RewriteRule ^".ltrim($rv['savepath'],'/')."/$ /?r=".$rv['model']."&id=".$rv['catid']." [L] \r\n";
				$rewStr .= "RewriteRule ^".ltrim($rv['savepath'],'/')."/index.html$ /?r=".$rv['model']."&id=".$rv['catid']." [L] \r\n";
				$rewStr .= "RewriteRule ^".ltrim($rv['savepath'],'/')."/list-([0-9]+)\.html$ /?r=".$rv['model']."&id=".$rv['catid']."&page=$1 [L] \r\n";

				$rewStr .= "RewriteRule ^".ltrim($rv['savepath'],'/')."/([0-9]+)\.html$ /?r=".$rv['model']."-content&id=$1 [L] \r\n";
				$rewStr .= "RewriteRule ^".ltrim($rv['savepath'],'/')."/([0-9]+)-([0-9]+)\.html$ /?r=".$rv['model']."-content&id=$1&page=$2 [L] \r\n";
				//生成IIS规则
				$IISrewStr .= "RewriteRule ^(.*)/".trim($rv['savepath'],'/')."$ /index\.php\?r=list&id=".$rv['id']."\r\n";
				$IISrewStr .= "RewriteRule ^(.*)/".ltrim($rv['savepath'],'/')."$ /index\.php\?r=list&id=".$rv['id']."\r\n";
				$IISrewStr .= "RewriteRule ^(.*)/".ltrim($rv['savepath'],'/')."index.html$ /index\.php\?r=list&id=".$rv['id']."\r\n";
				$IISrewStr .= "RewriteRule ^(.*)/".ltrim($rv['savepath'],'/')."list-([0-9]+)\.html$ /index\.php\?r=list&id=".$rv['id']."&page=$2 \r\n";
				$IISrewStr .= "RewriteRule ^(.*)/".ltrim($rv['savepath'],'/')."([0-9]+)\.html$ /index\.php\?r=list-content&id=".$rv['id']."&aid=$2 \r\n";
				$IISrewStr .= "RewriteRule ^(.*)/".ltrim($rv['savepath'],'/')."([0-9]+)-([0-9]+)\.html$ /index\.php\/?r=list-content&id=".$rv['id']."&aid=$2&page=$3 \r\n";
				}
			}
			$w= files::writeFiles('../.htaccess',$rewStr);
			$IISw= files::writeFiles('../httpd.ini',$IISrewStr);
			if(!$w){
				$this->success('REWRITER规则更新成功');
			}else{
				$this->error('REWRITER规则更新失败');
			}
	}

}