<?php
 /**
 * Magic CMS 模板管理
 * ============================================================================
 * Copyright 2014 大秦科技，并保留所有权利。
 * 网站地址: http://www.qintech.net；
 * ----------------------------------------------------------------------------
 * 未获商业授权之前，不得将Magic CMS用于商业用途（包括但不限于企业网站、经营性网站
 * 以营利为目的或实现盈利的网站）未经官方许可，禁止在Magic CMS的整体或任何部分基础
 * 上以发展任何派生版本、修改版本或第三方版本用于重新分发。如果您未能遵守本协议的
 * 条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。
 * ============================================================================
 * Date:2014/12/31
**/
class IndexModule extends CommonModule{
	public function index(){
		$info = '/info.ini';
		$tpllist = Files::getdirs('../'.TPL_PATH);
		//加载前端配置文件
		require(ROOT_PATH . 'Data/Config/config.php');

		//读取当前模板
		foreach ($tpllist as $k=>$files){
			if(file_exists('../'.TPL_PATH.$files.$info)){
				$content = file_get_contents('../'.TPL_PATH.$files.$info);
				$content = str_replace(PHP_EOL, "|", $content);
				$content = explode('|',$content);
				foreach ($content as $v){
					$list = explode(':',$v);
					$desc[$list[0]] =  $list[1];
				}
				$tpllists[$k]['info'] = $desc;
			}else{
				$tpllists[$k]['info'] = array('name'=>'未知','author'=>'佚名','time'=>'1970-01-01','preview'=>'');
			}
			$tpllists[$k]['title'] = $files;
		}

		$this->assign('tpl',$config['TPL_STYLE']);
		$this->assign('tpllist', $tpllists);
		$this->display();
	}

	public function start(){
		if (!Q('get.tpl'))
			$this->error('参数错误,模板切换失败');

		$reslut = CA(ROOT_PATH    . 'Data/Config/config.php' ,array('TPL_STYLE'=>Q('get.tpl')));

		if ($reslut){
			$this->success('模板切换成功','?r=templets');
		}else{
			$this->error('模板切换失败');
		}
	}
}