

--
-- 表的结构 `mac_access` 
--

CREATE TABLE IF NOT EXISTS `mac_access` (
  `rid` int(11) NOT NULL DEFAULT '0',
  `nid` int(11) DEFAULT '0',
  KEY `nid` (`nid`),
  KEY `rid` (`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC--MagicCMS;

-- -------------------------------------------------------


--
-- 表的结构 `mac_addgbook` 
--

CREATE TABLE IF NOT EXISTS `mac_addgbook` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `tel` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `qq` varchar(100) DEFAULT NULL,
  `datetime` datetime DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `reply` text,
  `content` text,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `company` varchar(255) DEFAULT NULL,
  `area` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1144 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='留言板'--MagicCMS;

-- -------------------------------------------------------


--
-- 表的结构 `mac_addkefu` 
--

CREATE TABLE IF NOT EXISTS `mac_addkefu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) DEFAULT '0',
  `position` varchar(255) DEFAULT 'right' COMMENT '悬浮位置 - left或right',
  `horizontal` int(11) DEFAULT '0' COMMENT '水平方向的位置 - 默认为数字',
  `vertical` int(11) DEFAULT '100' COMMENT '垂直方向的位置 - 默认为null',
  `halfTop` varchar(10) DEFAULT 'true' COMMENT '是否垂直居中位置',
  `minStatue` varchar(10) DEFAULT 'false' COMMENT '是否最小化',
  `hideCloseBtn` varchar(255) DEFAULT 'false' COMMENT '是否隐藏关闭按钮',
  `skin` varchar(255) DEFAULT 'blue' COMMENT '皮肤',
  `rx_status` int(1) DEFAULT '0' COMMENT '是否开启热线',
  `content` text,
  `kfrx` varchar(255) DEFAULT '',
  `ot_status` tinyint(1) DEFAULT '1',
  `ot_content` text,
  `gb_status` int(1) DEFAULT '0' COMMENT '是否开启热线',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='客服'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_addkefu` 
--

INSERT INTO `mac_addkefu` (`id`,`status`,`position`,`horizontal`,`vertical`,`halfTop`,`minStatue`,`hideCloseBtn`,`skin`,`rx_status`,`content`,`kfrx`,`ot_status`,`ot_content`,`gb_status`) VALUES
(1,0,'right',0,200,'true',0,0,'green',0,1419273817,'400-623-0537',0,'',0)--MagicCMS;


--
-- 表的结构 `mac_addlinks` 
--

CREATE TABLE IF NOT EXISTS `mac_addlinks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `pubtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `note` text,
  `logo` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='友情链接'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_addlinks` 
--

INSERT INTO `mac_addlinks` (`id`,`title`,`url`,`pubtime`,`status`,`note`,`logo`) VALUES
(13,'济宁网站建设','http://www.qintech.net','2015-03-30 15:49:52',1,'','')--MagicCMS;


--
-- 表的结构 `mac_addnotice` 
--

CREATE TABLE IF NOT EXISTS `mac_addnotice` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `pubtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `content` text,
  `title` varchar(255) DEFAULT NULL COMMENT '分类名称',
  `status` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='公告'--MagicCMS;

-- -------------------------------------------------------


--
-- 表的结构 `mac_addslide` 
--

CREATE TABLE IF NOT EXISTS `mac_addslide` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL COMMENT '名称',
  `url` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `sorter` int(11) DEFAULT NULL,
  `sgroup` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `sgroup` (`sgroup`),
  KEY `sorter` (`sorter`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='幻灯片'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_addslide` 
--

INSERT INTO `mac_addslide` (`id`,`title`,`url`,`image`,`note`,`status`,`sorter`,`sgroup`) VALUES
(22,'幻灯片一','#','/Uploads/image/20150910/57931441849221.jpg','',1,1,1),
(24,'幻灯片二','#','/Uploads/image/20150910/18051441849198.jpg','',1,0,1)--MagicCMS;


--
-- 表的结构 `mac_art_article` 
--

CREATE TABLE IF NOT EXISTS `mac_art_article` (
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '文章ID',
  `keywords` varchar(250) DEFAULT NULL COMMENT '关键词',
  `description` varchar(250) DEFAULT NULL COMMENT '描述',
  `source` varchar(100) DEFAULT NULL COMMENT '来源',
  `author` varchar(250) DEFAULT NULL COMMENT '作者',
  `content` text COMMENT '内容',
  `paging` tinyint(1) NOT NULL DEFAULT '1',
  `pagingnum` int(11) DEFAULT NULL,
  `subhead` varchar(255) DEFAULT NULL,
  `contenttpl` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文章模型表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_art_article` 
--

INSERT INTO `mac_art_article` (`pid`,`keywords`,`description`,`source`,`author`,`content`,`paging`,`pagingnum`,`subhead`,`contenttpl`) VALUES
(300,'','','','','<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	一、体检时间、地点\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	学员可到以下三个公安局指定的驾驶员体检中心办理拍照、体检手续。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	莘　庄：莘东路508号(近庙泾路口)\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	大柏树：邯郸路98号（近逸仙路）\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	浦　东：沪南路2638号(近申花足球学校)\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	服务时间：周一～周五上午8:30-11:30，下午13:00-17:00）\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	二、需带证件\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	1.初次申领《机动车驾驶证》的学员：\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	A.本市学员必须携带有效期至少四个月的《身份证》原件；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	B.外省市学员必须携带有效期至少四个月的《身份证》原件和本市派出所出具的有效期内的《居住证》或《蓝印户口簿》；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	C.境外人士必须携带《护照》原件及派出所出具的《居留证明》原件；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	D.港、澳、台同胞必须携带《回乡证》或《台胞证》以及派出所出具的《居留证明》原件；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	E.现役军人必须携带《军官证》原件及部队团级以上单位证明原件。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	需注明： 　　①该部队为驻沪部队； 　　②申请人的身份证号； 　　③申请人的居住地址；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	2.原持有E照、F照等各类型的《机动车驾驶证》的加考学员：\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	A.原持有上海驾照的加考学员须具备初领驾驶证一年以上的条件，另须携带原驾驶证正、副本原件、原驾驶证副表(到原副表档案所在的区、县交警支队宣传科抽取)前来报名；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	B.原持有有效外地驾照(E、F照)的加考学员须具备初领驾驶证一年以上的条件，建议携带驾驶证正、副本原件，周一至周五到驾校先办理报名、拍照体检手续，再去上海市车辆管理所(莘庄：沁春路179号)办理过户手续。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	C.曾申领过驾照但已无效的学员，须先到发证地公安局车辆管理所办理注销手续。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	三、体检须知\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	1、年龄：18-70周岁；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	2、身高：不限；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	3、视力：两眼裸视力或者矫正视力达到对数视力表 4.9(即E字表0.8)以上；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	4、辨色力：无红绿色盲；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	5、听力：两耳分别距音叉 50 厘米能辨别声源方向；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	6、上肢：双手拇指健全，每只手其他手指必须有三指健全，肢体和手指运动功能正常；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	7、下肢：运动功能正常，下肢不等长度不得 大于5厘米；\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	8、躯干、颈部：无运动功能障碍。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	四、报名流程\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	1.报名、付费\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	凭本人的身份证至体检站窗口购买拍照、体检券，并索取《机动车驾驶证信息表》、《学习驾驶员健康检查登记表》。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	2.填表、拍照\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	用钢笔或水笔填写《机动车驾驶证信息表》、《学习驾驶员身体健康检查登记表》，照相袋左上角写上自己姓名。并将拍照券、身份证、信息表3件由上而下依次整理，交工作人员，等候拍照。外省市学员须提供《居住证》原件。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	3.领取照片、填体检表\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	拍照完毕后，在拍照室领照窗口等候取照片、身份证，领照时，仔细核对《机动车驾驶员申请表》中的个人信息，并由工作人员剪照核对→至体检室，将2寸照1张、体检券、身份证和已填写好的《上海市学习驾驶员健康检查登记表》4件由上而下依次整理交工作人员→用水笔填写《机动车驾驶人身体条件证明》表→凭身份证、体检券、《机动车驾驶人身体条件证明》、《学习驾驶员健康检查登记表》上流动车体检。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	4.体检\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	先上流动体检车体检（主要项目：握力、背肌力、四肢关节躯干颈部等）→再到体检室检测其余的项目（视力、听力、心电图）→主检室主检→主检合格者凭《学习驾驶员健康检查登记表》回体检车打印\"检测报告\"→再回主检室换取《机动车驾驶人身体条件证明》。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	提示：最后拿到手的是2件：《机动车驾驶人身体条件证明》表、《机动车学习驾驶员身体健康检查报告》。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	5.整理资料\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	a、相片袋（照片）\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	b、报名单（黄单联）\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	c、《机动车驾驶员申请表》\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	d、《机动车驾驶人身体条件证明》表，依次整理，准备办证。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	6.办理入学手续\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	来学校办证大厅相关窗口办理入学手续：窗口索取表格→填写相关表格（按东大厅的样表仔细填写）→窗口交表→窗口领取交规考试教材 　　注：所有表式一律用钢笔或水笔填写\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	7、报名注意事项\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	学员报名请提前一天来电预约;体检不需要空腹，若近视,请带好眼镜（隐形眼镜也可）；报名当天因要拍证件照请不要穿吊带衫或背心;因我处不能刷卡，请准备现金来报名；报名当天须一次性付清包括培训费、代办费和体检费在内的所有费用，如体检不合格，除已发生的体检费外其余费用全额退还。因要填写《驾驶培训合同》，请自备黑色水笔。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	交规学习及考试\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	1.交通法规总复习和考试：学员可事先按《考试题库》进行预习，并可进入《交规自测》进行练习。总复习当天，由本中心资深交规老师为学员进行全面的总复习并告知交通法规正式上机考试“注意事项”。 　　总复习地点：本中心办公大楼二楼“交规教室”。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	2.采集指纹：学员交通法规正式考试当天必须先到本中心办证大厅窗口办理指纹采集手续，以备交通法规正式考试。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	3.交通法规正式考试：当学员接到本中心的电话通知后，必须按通知日期参加教练车队的“开学典礼”，并由车队安排参加当天的交通法规正式（上机）考试。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	交通法规正式考试地点：本中心办公大楼二楼“交规考场”。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	注：参加交通法规正式考试须带好本人身份证原件。\r\n</div>\r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	上海学车闵行区AAA老牌驾校-春申驾校，报名即可优惠，学费透明，星级老师带教，训练和考试都在同一基地，上海闵行范围均可接送，欢迎广大学员前来咨询报名。我们将竭诚为您服务！\r\n</div>',1,0,'',''),
(301,'','','','','<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	昨天的市政府新闻发布会上，在回答关于最近上海的一些驾校开始停止招收非上海户籍的会员，已报名的学员考试长时间排队的质疑时，市政府新闻发言人陈启伟表示，上海所有机动车驾驶员培训学校的招生工作均按照国家有关法规依法开展。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	据介绍，目前有不少外省市人员来上海学车，许多人瞄准了这个商机，出现了各种个体车辆挂靠驾校，甚至借用驾校培训证等现象，这些培训忽视了学员的学车质量，甚至出现了虚报居住证信息，冒用上海居住证明以达到报名驾培目的的情况。因为各地的土地资源都是有限的，上海道路资源也是有限的。从土地资源各方面的情况来讲，不可能容纳太多的人异地学车。为了确保培训质量，本市管理部门根据有关规定，将对驾培机构的本市户籍的学员和外省市户籍取得上海居住证明的学员提供驾培服务。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	陈启伟还介绍，交港局已经紧急发文，明确本市驾培机构的收费标准不能搞区别对待，对违反规定的驾驶员培训机构，一经查实将依法作出严肃处理。近期，交港部门将会同市物价局展开专项检查。针对部分驾培机构无序招生和违规组织异地培训的情况，根据《机动车驾驶证业务工作规范》，市公安局交警总队车管所将于近日起至年底，开展针对违规办理居住证明申领机动车驾驶证的专项整治工作，对居住证明造假的或提供虚假证明办理居住证明的不予安排考试，对违规组织异地培训的驾培机构将暂停考试。\r\n</p>',1,0,'',''),
(302,'','','','','<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	从驾校毕业的新手一天多过一天，新手也是“马路杀手”，于是，前几年兴盛起来的陪驾热，有愈加红火的趋势。何为陪驾，顾名思义，陪着你驾驶，看看你在驾驶上需要改正哪些习惯，需要具备哪些应变能力。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	<span style=\"color:#FF0000;\"> 陪驾160-200元/小时</span>&nbsp;为的是安全\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	据网上不完全了解，陪驾业在近几年内已经如火如荼地发展起来，陪驾的价格也效仿房价，节节攀升。据了解，现如今陪驾市场的收费大致为160-200元/小时不等，2小时起步。陪驾的车辆一般都进行了专业改装，在副驾驶的位置上多了一个脚刹，陪驾公司的营业时间多从早上九点到晚上九点，节假日无休。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	据了解，目前陪驾公司教练，一般都是从正规驾驶学校出来的师傅，不仅具有过硬的专业素质，就成立陪驾公司这件事情上来看，智商更是非一般的高。面对大众的广泛需要，陪驾师傅几乎没有休息日，尽管这样，仍然无法满足广大人民群众对陪驾服务的需求。陪驾教练行程每天爆满，即使预约，还得耐心等待。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	再看人家陪驾公司的服务内容：培养您城区繁华道路、大街小巷的驾驶技巧;路边、小区、停车场泊车技巧;变道、拐弯、调头、倒车等驾驶技巧;雨、雾、雪天、夜晚灯光启动、会车技巧驾驶等等。这内容，怎一个全字了得;这心思，怎一个细腻而论。最后，人家还会送上一段让你怦然心动的话语：咱们不差钱，为了他人安全，为了家庭幸福!\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	陪驾六七次还不够 只为上路后反应更快\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	上周日刚刚找人“陪练”的陆小姐透露，她在陪驾公司已经练习了六七次之多，老公坐在她的车上仍然心惊肉跳，于是她又继续了自己的被陪生活。她表示，之所以如此信赖陪驾公司，是因为坐过同事的车，虽然同事有着四五年驾龄，但一脚油门一脚刹车，还是让自己翻江倒海、痛不欲生，驾驶习惯简直令人发指。陪驾确确实实让自己感受到了好处。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	陪驾的车辆一般都进行了改装，比如陆小姐的陪驾车辆就是一辆比亚迪，副驾位置进行了改装，多了一个脚刹，汽车的舒适性也较驾校的破旧不堪的车子好过无数倍。行驶中，教练会告诉你，在高速上不能猛打方向盘;在车道上，可以减速让车，但是不能随便换道;一辆大车突然出现，你如何做到心中不慌，手动自如。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	如果说驾校是应试教育的话，那么陪驾就是素质教育，教会你更多的是应变能力。上路时，不再是对准哪个点行驶，而是身边一群群行驶的车辆，一些些活生生的人，还有一堆堆现实中的突发情况。因此，陪驾不可少，多些辛苦也让你多一份安全，给别人多一份尊重。\r\n</p>',1,0,'',''),
(303,'','','','','<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	“往左打两圈半，油门、离合、回调，踩刹车再回转两圈半。”盛真心中默念口诀准备10分钟后的倒车考试。这种场景在沪上各大驾校都能见到，由于时间有限，驾校已经成为拿驾照的应试教育。而近日发生在上\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	新闻事件：两天内两起新驾驶员致死事故\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	3月9日，闵行区龙柏四村，一名50多岁的男子在小区倒车时，不慎把61岁的女邻居刘某撞倒致其死亡;3月10日，浦东昌五小区的叶阿婆在小区里散步时，被一辆黑色别克轿车倒车时撞倒，终因伤势过重去世。两天内，接连发生小区内倒车撞人致死事故，引发了社会高度关注。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	新手司机：上路一紧张驾校学的东西都忘了\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	家住闵行区的陶小姐早在2009年就拿到了驾照，可至今实际总里程数才不到2000公里。今年2月底她刚购买了一辆新车，可是在提车当天，刚离开4S店就直接撞在了路边的石柱上，车辆维修费用近万元。“在驾校学的时候，旁边有教练可以关照，可一拿车的时候，一紧张油门踩大了，越想刹车油门踩的越紧，后来就直接撞在路灯柱上了。”陶小姐说，上车紧张让她完全没有应对的方式。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	网友尘庶也表示新手确实应该在刚上路的时候找个有经验的陪驾，他说：“现在大多数人开的都是自动挡，没有离合了，刹车旁边就是油门，一些新手一紧张就会踩错位置。”他表示自己就亲眼目睹过一场新手倒车引发的车祸，一个新手的司机驾驶的自动挡汽车，估计是在后退时踩到了油门，结果一退退到路边另一辆车子上，撞得一塌糊涂。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	驾校：学车只为考试缺乏实践\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	那么驾校的应试教育到底如何?本报记者实地探访学车过程。记者发现，如今的驾校教程就好似一条生产的流水线。考试如何考，教练就怎么教，从学习的第一天起，一切都以考试的重点为中心，而不是如何在路上驾驶为主。比如倒库移库，教练把车子开到哪个点，方向盘打几圈，标杆对准车子哪个点，方向盘再回几圈都告诉学员，当有人数不清打方向盘的圈数时，还可以参考方向盘上面的标记。一位老学员告诉记者，“以前原地打方向盘是为了考场“救急”用的，而现在却变成了常规动作，这种直接告诉你答案的教育模式屡试不爽，考试通过率极高，但是一旦驾驶自己的车子去停车时，倒不倒得准就说不定了。”\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	事实上，这种学车的考试就算临时抱佛脚也能通过，因为学员多，每一位学员摸车的时间没有超过2个小时，教练指导学员的时间就更少了。当记者问起教练练习太少是否会影响考试，教练十分自信地回答说“平时练的少不会碍事，往往在驾考前夕，学校会安排大家进行特训，针对考试的项目，反复练习，以达到通过驾考的目的。所以，就算平时练的少，也不用太担心。只要按着口诀开，基本都能过。”\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	陪驾公司：缺乏规范制约，新手不信任\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	据悉，对于不少新手司机，陪驾公司是个不错的选择，可是现今不少陪驾公司管理上的混乱却让不少新手不敢选择。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	据悉，按照驾驶行业的要求，陪驾人员必须是持证的教练员，但目前许多陪驾公司提供的陪驾人员大部分仅仅是开车熟练并没有明确的资质，而且目前也没有任何一个机构能够对陪驾行业进行资质考核。此外，陪驾时发生的法律责任也不够明确。按照我国现有法 ，陪驾教练仅仅是同乘人员的定义，一旦手司机发生事故，同乘人员是没有法律责任。这又导致如果陪驾服务出现问题，车主很难找到地方维护自身的权益。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	后记：合理规范长效治理\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	随着新手司机的增多，如何有效的避免新手引发的交通事故是管理部门需要重视的话题。记者认为，有关部门应该提高驾校学车的考试方式，从源头上杜绝应试教育般的填鸭式的学车方式。同时，增加陪驾公司正规化法规化的监管，让新手上路的过程中能够有一个过渡过程，尽量减少新手由于上路紧张或者不熟练导致的交通事故。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	同时，每一个新手司机也应该从自己做起，开车时始终遵循谨慎再谨慎的原则，尽量减少由于自身失误所造成的交通事故。\r\n</p>',1,0,'',''),
(304,'','','','','<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	&nbsp; 在学车行情看涨的情势的现今社会，有不少网站都打出了团购学车的优惠，吸引了不少想学车的朋友，但是，近期却有不少消费者发现团购上当，究竟是怎么一回事儿呢?\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	网友杨青和我们分享了她的团购学车经历：\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	今年2月底，我在一网站花200元购买了价值1200元的学车抵用券，凭抵用券到指定驾校学车，只需再支付2500元和100元体检费，总计2800元就能学车。团购成功后，我收到了驾校通知体检的电话，驾校负责人承诺，体检完两周内即会安排签合同，并上车培训。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	但是，等了几个月，眼看就要超过团购券的使用有效期，却始终没有接到学车的通知。打客服电话得到的回答是：由于学车的人太多，驾校一时安排不过来，同时明确表示“使用过期团购券依然有效”。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	8月10日，我终于接到通知去驾校签订了学车合同，并支付了2500元。可没想到，之后等来的不是让我去学车的电话，而是公安局要求去做笔录的电话，她这才知道出事了!\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	后来，我就要求退款，可驾校和网站相互推卸责任，那网站更是以团购券过期，签的合同无效为理由拒绝退款给我。我了解到，原来，受害的不止我一个!\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	了解了杨青的经历之后，我站记者致电了该网站，该网站客服解释说：网站在8月8日换了老板，现在只负责处理8月8日之后的团购服务。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	难道以网站易主的借口就可以不承担用户损失了嘛?\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	市消保委明确表示，网站不能因此推卸责任。市消保委就此事曾多次约谈该网站，但对方一直不予配合。市消保委指出，团购网站在组织团购时负有审核信息的责任，如果消费者购买学车团购券后，无法继续签约学车，团购网站也需承担连带责任。\r\n</p>',1,0,'',''),
(305,'','','','','<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	被誉为史上最为严历的“上海学车限外令”着实让许多外地学员吃惊不已，本来打算报名学车的也纷纷打消了学车的念头。根据“限外令”规定，凡身份证不为本地学员的，都视为外地学员，学车周期估计要在半年左右，而且学车费用基本在8000-10000之间，如此严格的政策确实让许多外地学员伤心不已。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	近日，记者从上海学车相关部门了解到，日前相关部门又出台了上海学车新政，既拥有上海<span style=\"color:#FF0000;\">暂住证或居住证</span>的外地学员都视为本地学员，学车价格和学车时间与本地人一样，据相关负责人介绍，除符合这些条件的外地学员外，上海学生，驻沪部队官兵和执摩托车增驾的学员也享有与本地学员同样的待遇。为此，记者特走访了齐爱驾校、春申驾校、万国驾校、公交驾校、锦隆驾校、晟豪驾校等沪上知名驾校，这些驾校的负责人纷纷表示了相同的意见，既驾校放宽了外地学员在上海学车的限制。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	专家提醒，由于上海学车政策目前尚在调整当中，之于继续放宽或限制外地学员在上海学车尚没定论，他建议想在上海学车的外地学员，应趁现在政策放宽阶段报名学员，以免到时又碰到“限外令”而后悔。\r\n</p>',1,0,'',''),
(306,'','','','','<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	昨天的市政府新闻发布会上，在回答关于最近上海的一些驾校开始停止招收非上海户籍的会员，已报名的学员考试长时间排队的质疑时，市政府新闻发言人陈启伟表示，上海所有机动车驾驶员培训学校的招生工作均按照国家有关法规依法开展。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	据介绍，目前有不少外省市人员来上海学车，许多人瞄准了这个商机，出现了各种个体车辆挂靠驾校，甚至借用驾校培训证等现象，这些培训忽视了学员的学车质量，甚至出现了虚报居住证信息，冒用上海居住证明以达到报名驾培目的的情况。因为各地的土地资源都是有限的，上海道路资源也是有限的。从土地资源各方面的情况来讲，不可能容纳太多的人异地学车。为了确保培训质量，本市管理部门根据有关规定，将对驾培机构的本市户籍的学员和外省市户籍取得上海居住证明的学员提供驾培服务。\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">\r\n	陈启伟还介绍，交港局已经紧急发文，明确本市驾培机构的收费标准不能搞区别对待，对违反规定的驾驶员培训机构，一经查实将依法作出严肃处理。近期，交港部门将会同市物价局展开专项检查。针对部分驾培机构无序招生和违规组织异地培训的情况，根据《机动车驾驶证业务工作规范》，市公安局交警总队车管所将于近日起至年底，开展针对违规办理居住证明申领机动车驾驶证的专项整治工作，对居住证明造假的或提供虚假证明办理居住证明的不予安排考试，对违规组织异地培训的驾培机构将暂停考试。\r\n</p>',1,0,'',''),
(307,'','','','','',1,0,'','')--MagicCMS;


--
-- 表的结构 `mac_art_image` 
--

CREATE TABLE IF NOT EXISTS `mac_art_image` (
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '文章ID',
  `comcount` int(11) DEFAULT '0' COMMENT '评论数量',
  `color` varchar(255) DEFAULT NULL COMMENT '颜色',
  `bold` int(11) DEFAULT '0' COMMENT '加粗',
  `italic` int(11) DEFAULT '0' COMMENT '斜体',
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `content` text,
  `isinter` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否截取摘要',
  `paging` tinyint(1) NOT NULL DEFAULT '1',
  `pagingnum` int(11) DEFAULT NULL,
  `multimg` text,
  `subhead` varchar(255) DEFAULT NULL,
  `contenttpl` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`pid`),
  KEY `cid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='图集模型表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_art_image` 
--

INSERT INTO `mac_art_image` (`pid`,`comcount`,`color`,`bold`,`italic`,`keywords`,`description`,`source`,`author`,`content`,`isinter`,`paging`,`pagingnum`,`multimg`,`subhead`,`contenttpl`) VALUES
(308,0,'',0,0,'','','','','',1,1,0,'a:4:{i:0;a:3:{s:4:\"path\";s:44:\"../Uploads/image/20151031/73681446269404.jpg\";s:4:\"sort\";s:0:\"\";s:4:\"note\";s:0:\"\";}i:1;a:3:{s:4:\"path\";s:44:\"../Uploads/image/20151031/23891446270112.jpg\";s:4:\"sort\";s:0:\"\";s:4:\"note\";s:0:\"\";}i:2;a:3:{s:4:\"path\";s:44:\"../Uploads/image/20151031/16981446270113.jpg\";s:4:\"sort\";s:0:\"\";s:4:\"note\";s:0:\"\";}i:3;a:3:{s:4:\"path\";s:44:\"../Uploads/image/20151031/52701446271736.jpg\";s:4:\"sort\";s:0:\"\";s:4:\"note\";s:0:\"\";}}','','')--MagicCMS;


--
-- 表的结构 `mac_art_library` 
--

CREATE TABLE IF NOT EXISTS `mac_art_library` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL DEFAULT '0' COMMENT '分类id',
  `model` varchar(255) DEFAULT 'article' COMMENT '模型',
  `title` varchar(250) DEFAULT NULL COMMENT '文章标题',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态',
  `image` varchar(200) DEFAULT NULL COMMENT '缩略图',
  `linkurl` varchar(255) DEFAULT NULL COMMENT '外链跳转地址',
  `hits` int(11) DEFAULT '0' COMMENT '浏览量',
  `pubtime` int(11) DEFAULT NULL COMMENT '发布时间',
  `flag` char(100) DEFAULT '' COMMENT '文档自定义属性',
  `abstract` varchar(255) NOT NULL DEFAULT '' COMMENT '摘要',
  `target` varchar(255) DEFAULT NULL COMMENT '打开方式',
  `weight` int(11) DEFAULT NULL COMMENT '权重',
  `sortrank` int(11) DEFAULT NULL COMMENT '置顶',
  PRIMARY KEY (`id`),
  KEY `flag` (`flag`),
  KEY `hits` (`hits`),
  KEY `pid` (`catid`),
  KEY `model` (`model`)
) ENGINE=MyISAM AUTO_INCREMENT=312 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文章信息表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_art_library` 
--

INSERT INTO `mac_art_library` (`id`,`catid`,`model`,`title`,`status`,`image`,`linkurl`,`hits`,`pubtime`,`flag`,`abstract`,`target`,`weight`,`sortrank`) VALUES
(300,8478,'article','学车前之体检报名须知',1,'/Uploads/image/20150910/4661441867869.jpg','',32,1441770447,'c','学车前之体检报名须知 　　一、体检时间、地点 　　学员可到以下三个公安局指定的驾驶员体检中心办理拍照、体检手续。 　　莘　庄：莘东路508号(近庙泾路口) 　　大柏树：邯郸路98号（...','',100,1441770447),
(301,8477,'article','外省市人员在沪学车需居住证明',1,'/Uploads/image/20150910/4661441867869.jpg','',0,1441769935,'c','随着上海学车的条件不断变化，居住证成为外地人在上海学车所必须的材料，居住证的办理过程是很繁琐的，我校为解决此问题，现可代理办理此证。详情请咨询：021-31262085 ......','',100,1441769935),
(302,8477,'article','菜鸟上路心里没谱？找陪驾！最新陪驾信息汇总',1,'/Uploads/image/20150910/4661441867869.jpg','',0,1441770031,'c','菜鸟上路心里没谱？找陪驾！最新陪驾信息汇总','',100,1441770031),
(303,8477,'article','马路新手=马路杀手?多方探究新手频发事故的根源',1,'/Uploads/image/20150910/4661441867869.jpg','',2,1441770074,'c','马路新手=马路杀手?多方探究新手频发事故的根源','',100,1441770074),
(304,8477,'article','上海学车团购券害人害己，专家称不可取',1,'/Uploads/image/20150910/4661441867869.jpg','',0,1441770109,'c','学车团购需谨慎，许多学员因为贪图一时的便宜而上当受骗，春申驾校提醒各位“团购有风险，学员需谨慎”。','',100,1441770109),
(305,8478,'article','上海学车外地学员政策放宽 想学车应趁早',1,'/Uploads/image/20150910/4661441867869.jpg','',2,1441770146,'c','随着上海学车的条件不断变化，居住证成为外地人在上海学车所必须的材料，居住证的办理过程是很繁琐的，我校为解决此问题，现可代理办理此证。详情请咨询：021-31262085','',100,1441770146),
(306,8477,'article','外省市人员在沪学车需居住证明',1,'/Uploads/image/20150910/4661441867869.jpg','',0,1441770183,'c','随着上海学车的条件不断变化，居住证成为外地人在上海学车所必须的材料，居住证的办理过程是很繁琐的，我校为解决此问题，现可代理办理此证。详情请咨询：021-31262085','',100,1441770183),
(307,8476,'article','五月感恩回馈：C2自动挡最快两周开班',1,'/Uploads/image/20150910/4661441867869.jpg','',0,1441770931,'c','','',0,1441770931),
(308,8481,'product','C1周末普通班',1,'/Uploads/image/20150910/4661441867869.jpg','',5,1441867452,'','','',100,1441867452),
(309,8481,'product','C1周末普通班',1,'/Uploads/image/20150910/4661441867869.jpg','',40,1441869061,'','','',100,1441869061)--MagicCMS;


--
-- 表的结构 `mac_art_product` 
--

CREATE TABLE IF NOT EXISTS `mac_art_product` (
  `pid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '文档ID',
  `content` text,
  `status` tinyint(1) DEFAULT NULL,
  `subhead` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `price` int(11) DEFAULT NULL,
  `market_price` int(11) DEFAULT NULL,
  `multimg` text,
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='产品模型表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_art_product` 
--

INSERT INTO `mac_art_product` (`pid`,`content`,`status`,`subhead`,`image`,`price`,`market_price`,`multimg`) VALUES
(308,3333,1,'','/Uploads/image/20151121/15701448124863.jpg',0,0,''),
(309,'',1,'','/Uploads/image/20151121/35901448125579.jpg',0,0,'')--MagicCMS;


--
-- 表的结构 `mac_art_video` 
--

CREATE TABLE IF NOT EXISTS `mac_art_video` (
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '文章ID',
  `comcount` int(11) DEFAULT '0' COMMENT '评论数量',
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `content` text COMMENT '内容',
  `abstract` varchar(255) DEFAULT NULL COMMENT '摘要',
  `isinter` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否截取摘要',
  `video` text,
  `subhead` varchar(255) DEFAULT NULL,
  `reltime` int(11) DEFAULT NULL,
  `duration` varchar(255) DEFAULT NULL,
  `contenttpl` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`pid`),
  KEY `cid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='视频模型表'--MagicCMS;

-- -------------------------------------------------------


--
-- 表的结构 `mac_class` 
--

CREATE TABLE IF NOT EXISTS `mac_class` (
  `catid` int(11) NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级id',
  `model` varchar(11) NOT NULL DEFAULT '1' COMMENT '模型字段  默认为文章模型',
  `sorter` int(11) DEFAULT '0' COMMENT '菜单排序',
  `name` varchar(50) NOT NULL COMMENT '分类名称',
  `subname` varchar(255) DEFAULT NULL COMMENT '栏目副名称',
  `flag` char(20) NOT NULL DEFAULT '0' COMMENT '栏目标识',
  `ismenu` tinyint(1) DEFAULT '0' COMMENT '是否设置为导航菜单',
  `status` tinyint(1) DEFAULT '1' COMMENT '显示状态',
  `contenttpl` varchar(255) DEFAULT NULL COMMENT '内容页模板',
  `channeltpl` varchar(255) DEFAULT NULL COMMENT '栏目页模板',
  `listtpl` varchar(255) DEFAULT NULL COMMENT '列表页模板',
  `content` text COMMENT '栏目内容',
  `savepath` varchar(255) NOT NULL DEFAULT '' COMMENT '保存路径',
  `ico` varchar(255) DEFAULT NULL COMMENT '栏目图标',
  `subico` varchar(255) DEFAULT NULL COMMENT '栏目子图标',
  `attribute` int(11) DEFAULT '1' COMMENT '栏目属性',
  `listoption` tinyint(3) NOT NULL DEFAULT '0' COMMENT '自定义属性',
  `seotitle` varchar(255) DEFAULT NULL COMMENT 'seo标题',
  `keywords` varchar(255) DEFAULT NULL COMMENT '关键词',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `catroute` varchar(255) DEFAULT NULL COMMENT 'url规则',
  `artroute` varchar(255) DEFAULT NULL,
  `tplattr` tinyint(1) DEFAULT '3' COMMENT '模板选项',
  PRIMARY KEY (`catid`),
  KEY `flag` (`flag`),
  KEY `ismenu` (`ismenu`),
  KEY `listoption` (`listoption`),
  KEY `name` (`name`),
  KEY `pid` (`pid`),
  KEY `sorter` (`sorter`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=8486 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='栏目分类表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_class` 
--

INSERT INTO `mac_class` (`catid`,`pid`,`model`,`sorter`,`name`,`subname`,`flag`,`ismenu`,`status`,`contenttpl`,`channeltpl`,`listtpl`,`content`,`savepath`,`ico`,`subico`,`attribute`,`listoption`,`seotitle`,`keywords`,`description`,`catroute`,`artroute`,`tplattr`) VALUES
(8474,0,'article',1,'驾校简介','','',1,1,'article_content.html','article_index.html','article_list.html','<span style=\"font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;color:#FF0000;\"><strong>上海春申驾驶员培训网</strong></span><span style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;\">位于顾戴路3288号，是第五教考基地，春申对在莘庄，七宝，九亭，梅陇，闵行地区的学员就近接送，隶属于上海得派广告有限公司统一对外宣传。目前教考中心多功能教学楼；拥有车辆350辆，道路设施齐全，设有标志、标牌168块，红绿灯2组，坡道2道。培训车辆总计有134辆是上海报名地点与施教地点为一体教考中心。</span> \r\n<div style=\"color:#333333;font-family:微软雅黑;font-size:14px;line-height:28px;white-space:normal;background-color:#FFFFFF;text-align:center;\">\r\n	<br />\r\n<img alt=\"\" src=\"http://www.chunshencar.com/uploads/allimg/141124/1-141124110FBC.jpg\" style=\"max-width:100%;height:auto;width:742px;\" /> \r\n</div>\r\n<br />','/jianjie','','',2,0,'','','','{cpath}','{cpath}/{aid}.html',3),
(8475,0,'product',2,'学车费用','','',1,1,'article_content.html','article_index.html','xcfy.html','','/feiyong','','',1,0,'','','','{cpath}','{cpath}/{aid}.html',3),
(8476,0,'article',3,'优惠活动','','',1,1,'article_content.html','article_index.html','article_list.html','','/youhui','','',1,0,'','','','{cpath}','{cpath}/{aid}.html',3),
(8477,0,'article',4,'新闻动态','','',1,1,'article_content.html','article_index.html','article_list.html','','/news','','',1,0,'','','','{cpath}','{cpath}/{aid}.html',3),
(8478,0,'article',5,'学车指南','','',1,1,'article_content.html','article_index.html','article_list.html','','/zhinan','','',1,0,'','','','{cpath}','{cpath}/{aid}.html',3),
(8479,0,'article',6,'学车位置','','',1,1,'article_content.html','article_index.html','article_list.html','','/weizhi','','',2,0,'','','','{cpath}','{cpath}/{aid}.html',3),
(8480,0,'article',7,'学车流程','','',1,1,'article_content.html','article_index.html','article_list.html','<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	上海学车简易流程：预约报名-体检-交规考-桩考-小路考-大路考--拿驾照!\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	1、电话(<span style=\"margin:0px;padding:0px;color:#FF0000;\"><strong style=\"margin:0px;padding:0px;\">021-3126 2085</strong></span>)或网上预约体检;\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	2、体检老师联系学员确定好具体体检时间、地点;\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	3、体检合格后，1周左右通知正式上车训练;\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	4、安排练车，学习交规理论，同步进行;\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	5、(3-4周后)理论考试;\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	6、(2周后)桩考;\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	7、(3-4周后)小路考;\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	8、(3-4周后)大路考;\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	9、(考试结束后，10个工作日以后)拿驾照<br />\r\n<img alt=\"\" src=\"http://www.chunshencar.com/uploads/allimg/150617/1-15061G33S9644.jpg\" style=\"text-align:center;max-width:100%;height:auto;width:742px;\" /> \r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	<span style=\"margin:0px;padding:0px;color:#FF0000;\"><strong style=\"margin:0px;padding:0px;\">温馨提示：</strong></span>在不发生补考的情况下一般75天左右即可完成。如发生补考，则如下：\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	1、交规考：当场补考一次仍未通过，第二天即可补考；\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	2、倒桩考：当场补考一次仍未通过，满四周后预约考试；\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	3、小路考：当场补考一次仍未通过，满四周后预约考试；\r\n</p>\r\n<p style=\"margin-top:0px;margin-bottom:0px;padding:0px;color:#333333;font-family:微软雅黑;white-space:normal;background-color:#FFFFFF;line-height:24px;font-size:13px;\">\r\n	4、大路考：当场不予补考未通过者，满四周后预约考试；\r\n</p>','/liucheng','','',2,0,'','','','{cpath}','{cpath}/{aid}.html',3),
(8481,8475,'product',1,'普通版','','',0,1,'xcfy_content.html','article_index.html','xcfy.html','','/putongban','','',1,0,'','','','{cpath}','{cpath}/{aid}.html',3),
(8482,8475,'article',2,'快速版','','',0,1,'article_content.html','article_index.html','xcfy.html','','/kuaisuban','','',1,0,'','','','{cpath}','{cpath}/{aid}.html',3),
(8483,8475,'article',3,'VIP班','','',0,1,'article_content.html','article_index.html','xcfy.html','','/VIPban','','',1,0,'','','','{cpath}','{cpath}/{aid}.html',3),
(8484,8475,'article',4,'异地考试','','',0,1,'article_content.html','article_index.html','xcfy.html','','/yidikaoshi','','',1,0,'','','','{cpath}','{cpath}/{aid}.html',3),
(8485,8475,'article',5,'摩托车','','',0,1,'article_content.html','article_index.html','xcfy.html','','/motuoche','','',1,0,'','','','{cpath}','{cpath}/{aid}.html',3)--MagicCMS;


--
-- 表的结构 `mac_fields` 
--

CREATE TABLE IF NOT EXISTS `mac_fields` (
  `fieldid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `utype` varchar(50) DEFAULT NULL COMMENT '会员类型',
  `model` varchar(255) DEFAULT NULL,
  `field` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `tips` text,
  `css` varchar(30) DEFAULT '',
  `minlength` int(10) unsigned NOT NULL DEFAULT '0',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0',
  `pattern` varchar(255) DEFAULT '',
  `errortips` varchar(255) DEFAULT '',
  `formtype` varchar(20) DEFAULT '',
  `attribute` mediumtext,
  `attach` varchar(255) DEFAULT '',
  `layout` tinyint(1) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sorter` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  `addattach` varchar(255) DEFAULT NULL,
  `dbattribute` text,
  `key_type` tinyint(1) DEFAULT NULL,
  `tabs` varchar(255) DEFAULT '-1',
  `isdb` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`fieldid`),
  KEY `model` (`model`)
) ENGINE=MyISAM AUTO_INCREMENT=875 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='字段信息表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_fields` 
--

INSERT INTO `mac_fields` (`fieldid`,`utype`,`model`,`field`,`name`,`tips`,`css`,`minlength`,`maxlength`,`pattern`,`errortips`,`formtype`,`attribute`,`attach`,`layout`,`issystem`,`sorter`,`status`,`addattach`,`dbattribute`,`key_type`,`tabs`,`isdb`) VALUES
(1,'','article','flag','推荐位','请确保上传文件大小未超出系统与PHP.INI设置，否则将导致上传失败','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',0,1,3,1,'','a:6:{s:8:\"key_name\";s:4:\"flag\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:4:\"flag\";}',2,-1,1),
(2,'','article','abstract','摘要','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',0,1,12,1,'','a:7:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:8:\"abstract\";}',0,-1,1),
(3,'','article','title','文档标题','','',0,0,'','请输入标题','text','a:2:{s:4:\"size\";s:2:\"60\";s:5:\"value\";s:0:\"\";}','',0,1,1,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:5:\"title\";s:4:\"isdb\";N;}',0,-1,0),
(109,'','article','subhead','文档副标题','','',0,0,'','','text','a:2:{s:4:\"size\";s:2:\"45\";s:5:\"value\";s:0:\"\";}','',0,0,2,1,'','a:7:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:7:\"subhead\";}',0,-1,1),
(110,'','article','pubtime','发布时间','','',0,0,'','','datetime','a:4:{s:6:\"istime\";s:1:\"1\";s:6:\"isinte\";s:1:\"0\";s:4:\"size\";s:2:\"25\";s:6:\"format\";s:19:\"YYYY-MM-DD hh:mm:ss\";}','',0,1,29,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:7:\"pubtime\";s:4:\"isdb\";N;}',0,0,0),
(111,'','article','catid','所属栏目','','',0,0,'','请选择所属于栏目','select','a:3:{s:6:\"option\";s:0:\"\";s:4:\"type\";s:1:\"1\";s:5:\"value\";s:0:\"\";}','',0,1,6,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:5:\"catid\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(112,'','article','image','缩略图','','',0,0,'','','upload','a:6:{s:4:\"type\";s:1:\"1\";s:5:\"multi\";s:1:\"0\";s:7:\"manager\";s:1:\"0\";s:4:\"view\";s:4:\"true\";s:7:\"butname\";s:12:\"选择图片\";s:4:\"size\";s:0:\"\";}','',0,1,8,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:5:\"image\";s:4:\"isdb\";N;}',0,-1,0),
(113,'','article','author','文章作者','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',1,0,9,1,'','a:7:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:6:\"author\";}',0,-1,1),
(114,'','article','source','文章来源','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',1,0,10,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:6:\"source\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(115,'','article','hits','浏览量','','',0,0,'','','text','a:2:{s:4:\"size\";s:1:\"5\";s:5:\"value\";s:0:\"\";}','',2,1,11,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:4:\"hits\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(116,'','article','content','文档内容','','',0,0,'','','editor','a:4:{s:4:\"type\";s:1:\"0\";s:4:\"cols\";s:3:\"800\";s:4:\"rows\";s:3:\"500\";s:5:\"value\";s:0:\"\";}','',0,1,13,1,'','a:6:{s:8:\"key_name\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:4:\"TEXT\";s:4:\"name\";s:7:\"content\";s:4:\"isdb\";N;}',0,-1,0),
(117,'','article','keywords','关键字','','',0,0,'','','textarea','a:3:{s:4:\"cols\";s:2:\"60\";s:4:\"rows\";s:1:\"2\";s:5:\"value\";s:0:\"\";}','',0,0,27,1,'','a:7:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:8:\"keywords\";}',0,0,1),
(118,'','article','description','描述','','',0,0,'','','textarea','a:3:{s:4:\"cols\";s:2:\"60\";s:4:\"rows\";s:1:\"4\";s:5:\"value\";s:0:\"\";}','',0,0,28,1,'','a:7:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:11:\"description\";}',0,0,1),
(119,'','image','flag','推荐位','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',0,1,3,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:4:\"flag\";s:4:\"isdb\";N;}',0,-1,0),
(120,'','image','abstract','摘要','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',0,1,11,1,'','a:7:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:8:\"abstract\";}',0,-1,1),
(121,'','image','title','图集标题','','',0,0,'','请输入标题','text','a:2:{s:4:\"size\";s:2:\"60\";s:5:\"value\";s:0:\"\";}','',0,1,1,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:5:\"title\";s:4:\"isdb\";N;}',0,-1,0),
(122,'','image','hits','浏览量','','',0,0,'','','text','a:2:{s:4:\"size\";s:1:\"5\";s:5:\"value\";s:0:\"\";}','',2,1,10,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:4:\"hits\";s:4:\"isdb\";N;}',0,-1,0),
(123,'','image','image','缩略图','','',0,0,'','','upload','a:6:{s:4:\"type\";s:1:\"1\";s:5:\"multi\";s:1:\"0\";s:7:\"manager\";s:1:\"0\";s:4:\"view\";s:4:\"true\";s:7:\"butname\";s:12:\"选择图片\";s:4:\"size\";s:0:\"\";}','',0,1,7,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:5:\"image\";s:4:\"isdb\";N;}',0,-1,0),
(124,'','image','catid','所属栏目','','',0,0,'','请输入所属栏目','select','a:3:{s:6:\"option\";s:0:\"\";s:4:\"type\";s:1:\"1\";s:5:\"value\";s:0:\"\";}','',0,1,6,1,'','a:7:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:5:\"catid\";}',0,-1,1),
(125,'','image','pubtime','发布时间','','',0,0,'','','datetime','a:4:{s:6:\"istime\";s:1:\"0\";s:6:\"isinte\";s:1:\"0\";s:4:\"size\";s:2:\"25\";s:6:\"format\";s:19:\"YYYY-MM-DD hh:mm:ss\";}','',0,1,22,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:7:\"pubtime\";s:4:\"isdb\";N;}',0,1,0),
(133,'','video','flag','推荐位','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',0,1,3,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:4:\"flag\";s:4:\"isdb\";N;}',0,-1,0),
(134,'','video','abstract','视频摘要','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',0,1,10,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:8:\"abstract\";s:4:\"isdb\";N;}',0,-1,0),
(135,'','video','title','视频标题','','',0,0,'','请输入标题','text','a:2:{s:4:\"size\";s:2:\"65\";s:5:\"value\";s:0:\"\";}','',0,1,1,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:5:\"title\";s:4:\"isdb\";N;}',0,-1,0),
(136,'','video','hits','浏览量','','',0,0,'','','text','a:2:{s:4:\"size\";s:1:\"5\";s:5:\"value\";s:0:\"\";}','',0,1,12,1,'','a:6:{s:8:\"key_name\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";N;s:4:\"name\";s:4:\"hits\";s:4:\"isdb\";N;}',0,2,0),
(137,'','video','image','缩略图','','',0,0,'','','upload','a:6:{s:4:\"type\";s:1:\"1\";s:5:\"multi\";s:1:\"0\";s:7:\"manager\";s:1:\"0\";s:4:\"view\";s:4:\"true\";s:7:\"butname\";s:12:\"选择图片\";s:4:\"size\";s:0:\"\";}','',0,1,7,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:5:\"image\";s:4:\"isdb\";N;}',0,-1,0),
(138,'','video','catid','所属栏目','','',0,0,'','请输入所属栏目','select','a:3:{s:6:\"option\";s:0:\"\";s:4:\"type\";s:1:\"1\";s:5:\"value\";s:0:\"\";}','',0,1,6,1,'','a:6:{s:8:\"key_name\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";N;s:4:\"name\";s:5:\"catid\";s:4:\"isdb\";N;}',0,-1,0),
(139,'','video','pubtime','发布时间','','',0,0,'','','datetime','a:4:{s:6:\"istime\";s:1:\"0\";s:6:\"isinte\";s:1:\"0\";s:4:\"size\";s:2:\"25\";s:6:\"format\";s:19:\"YYYY-MM-DD hh:mm:ss\";}','',0,1,23,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:7:\"pubtime\";s:4:\"isdb\";N;}',0,2,0),
(196,'','image','content','详细内容','','',0,0,'','','editor','a:4:{s:4:\"type\";s:1:\"0\";s:4:\"cols\";s:3:\"800\";s:4:\"rows\";s:3:\"500\";s:5:\"value\";s:0:\"\";}','',0,1,12,1,'','a:6:{s:8:\"key_name\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:4:\"TEXT\";s:4:\"name\";s:7:\"content\";s:4:\"isdb\";N;}',0,-1,0),
(201,'','image','author','图集作者','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',1,0,8,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:6:\"author\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(202,'','image','source','图集来源','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',1,0,9,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:6:\"source\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(203,'','image','keywords','关键词','','',0,0,'','','textarea','a:3:{s:4:\"cols\";s:2:\"60\";s:4:\"rows\";s:1:\"2\";s:5:\"value\";s:0:\"\";}','',0,0,20,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:8:\"keywords\";s:4:\"isdb\";s:1:\"1\";}',0,1,1),
(204,'','image','description','描述','','',0,0,'','','textarea','a:3:{s:4:\"cols\";s:2:\"60\";s:4:\"rows\";s:1:\"4\";s:5:\"value\";s:0:\"\";}','',0,0,21,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:11:\"description\";s:4:\"isdb\";s:1:\"1\";}',0,1,1),
(217,'','video','author','视频作者','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',2,0,9,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:6:\"author\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(218,'','video','source','视频来源','','',0,0,'','','text','a:2:{s:4:\"size\";s:2:\"20\";s:5:\"value\";s:0:\"\";}','',1,0,8,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:6:\"source\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(238,'','image','multimg','','点击图片，设为封面','',0,0,'','','upload','a:6:{s:4:\"type\";s:1:\"1\";s:5:\"multi\";s:1:\"1\";s:7:\"manager\";s:1:\"0\";s:4:\"view\";s:4:\"true\";s:7:\"butname\";s:18:\"批量上传图集\";s:4:\"size\";s:0:\"\";}','',0,0,6,1,'','a:6:{s:8:\"key_name\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:4:\"TEXT\";s:4:\"name\";s:7:\"multimg\";s:4:\"isdb\";s:1:\"1\";}',0,'图片集',1),
(294,'','video','video','','请确保上传文件大小未超出系统与PHP.INI设置，否则将导致上传失败','',0,0,'','','upload','a:6:{s:4:\"type\";s:1:\"4\";s:5:\"multi\";s:1:\"0\";s:7:\"manager\";s:1:\"0\";s:4:\"view\";s:5:\"false\";s:7:\"butname\";s:18:\"批量上传视频\";s:4:\"size\";s:0:\"\";}','',0,0,11,1,'','a:6:{s:8:\"key_name\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:4:\"TEXT\";s:4:\"name\";s:5:\"video\";s:4:\"isdb\";s:1:\"1\";}',0,0,1),
(374,'','article','weight','权重','权重越小越靠前','',0,0,'','','text','a:2:{s:4:\"size\";s:1:\"5\";s:5:\"value\";s:3:\"100\";}','',2,1,5,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:6:\"weight\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(376,'','article','sortrank','置顶选项','','',0,0,'','','select','a:3:{s:6:\"option\";s:0:\"\";s:4:\"type\";s:1:\"1\";s:5:\"value\";s:0:\"\";}','',1,1,17,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:1:\"3\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"TINYINT\";s:4:\"name\";s:8:\"sortrank\";s:4:\"isdb\";N;}',0,0,0),
(390,'','image','subhead','图集副标题','','',0,0,'','','text','a:2:{s:4:\"size\";s:2:\"45\";s:5:\"value\";s:0:\"\";}','',0,0,2,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:7:\"subhead\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(391,'','image','weight','权重','权重越小越靠前','',0,0,'','','text','a:2:{s:4:\"size\";s:1:\"5\";s:5:\"value\";s:3:\"100\";}','',2,1,5,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:6:\"weight\";s:4:\"isdb\";N;}',0,-1,0),
(393,'','image','sortrank','置顶选项','','',0,0,'','','select','a:3:{s:6:\"option\";s:0:\"\";s:4:\"type\";s:1:\"1\";s:5:\"value\";s:0:\"\";}','',1,1,16,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:1:\"3\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"TINYINT\";s:4:\"name\";s:8:\"sortrank\";s:4:\"isdb\";N;}',0,1,0),
(399,'','image','type_id','所属类型','请选择文档的所属类型，填写相应的信息','',0,0,'','','select','a:3:{s:6:\"option\";s:0:\"\";s:4:\"type\";s:1:\"1\";s:5:\"value\";s:0:\"\";}','',0,1,19,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:7:\"type_id\";s:4:\"isdb\";N;}',0,1,0),
(868,'','product','status','是否发布','','',0,0,'','','radio','a:2:{s:6:\"option\";s:11:\"是|1~否|0\";s:5:\"value\";s:1:\"1\";}','',0,1,18,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:1:\"1\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"TINYINT\";s:4:\"name\";s:6:\"status\";s:4:\"isdb\";N;}',0,-1,0),
(872,'','product','price','销售价格','','',0,0,'','','text','a:2:{s:4:\"size\";s:2:\"10\";s:5:\"value\";s:0:\"\";}','',1,0,12,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:5:\"price\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(873,'','product','market_price','市场价格','','',0,0,'','','text','a:2:{s:4:\"size\";s:2:\"10\";s:5:\"value\";s:0:\"\";}','',2,0,13,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:12:\"market_price\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(410,'','video','subhead','视频副标题','','',0,0,'','','text','a:2:{s:4:\"size\";s:2:\"45\";s:5:\"value\";s:0:\"\";}','',0,0,2,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:7:\"subhead\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(411,'','video','weight','权重','权重越小越靠前','',0,0,'','','text','a:2:{s:4:\"size\";s:1:\"5\";s:5:\"value\";s:3:\"100\";}','',2,1,5,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:6:\"weight\";s:4:\"isdb\";N;}',0,-1,0),
(412,'','video','comment','评论选项','','',0,0,'','','radio','a:2:{s:6:\"option\";s:29:\"允许评论|1~禁止评论|0\";s:5:\"value\";s:1:\"1\";}','',2,1,14,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:1:\"1\";s:5:\"value\";s:1:\"1\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"TINYINT\";s:4:\"name\";s:7:\"comment\";s:4:\"isdb\";N;}',0,2,0),
(413,'','video','sortrank','置顶选项','','',0,0,'','','select','a:3:{s:6:\"option\";s:0:\"\";s:4:\"type\";s:1:\"1\";s:5:\"value\";s:0:\"\";}','',1,1,17,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:1:\"3\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"TINYINT\";s:4:\"name\";s:8:\"sortrank\";s:4:\"isdb\";N;}',0,2,0),
(874,'','product','multimg','','','',0,0,'','','upload','a:7:{s:4:\"type\";s:1:\"1\";s:5:\"multi\";s:1:\"1\";s:7:\"manager\";s:1:\"0\";s:4:\"view\";s:4:\"true\";s:7:\"butname\";s:18:\"批量上传产品\";s:4:\"size\";s:0:\"\";s:5:\"style\";s:1:\"1\";}','',0,0,16,1,'','a:6:{s:8:\"key_name\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:4:\"TEXT\";s:4:\"name\";s:7:\"multimg\";s:4:\"isdb\";s:1:\"1\";}',0,0,1),
(419,'','video','content','详细内容','','',0,0,'','','editor','a:4:{s:4:\"type\";s:1:\"0\";s:4:\"cols\";s:3:\"800\";s:4:\"rows\";s:3:\"500\";s:5:\"value\";s:0:\"\";}','',0,1,13,1,'','a:6:{s:8:\"key_name\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:4:\"TEXT\";s:4:\"name\";s:7:\"content\";s:4:\"isdb\";N;}',0,-1,0),
(420,'','video','keywords','关键字','','',0,0,'','','textarea','a:3:{s:4:\"cols\";s:2:\"60\";s:4:\"rows\";s:1:\"2\";s:5:\"value\";s:0:\"\";}','',0,0,21,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:8:\"keywords\";s:4:\"isdb\";s:1:\"1\";}',0,2,1),
(421,'','video','description','描述','','',0,0,'','','textarea','a:3:{s:4:\"cols\";s:2:\"60\";s:4:\"rows\";s:1:\"4\";s:5:\"value\";s:0:\"\";}','',0,0,22,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:11:\"description\";s:4:\"isdb\";s:1:\"1\";}',0,2,1),
(862,'','product','sortrank','置顶选项','','',0,0,'','','select','a:3:{s:6:\"option\";s:0:\"\";s:4:\"type\";s:1:\"1\";s:5:\"value\";s:0:\"\";}','',0,1,17,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:1:\"3\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"TINYINT\";s:4:\"name\";s:8:\"sortrank\";s:4:\"isdb\";N;}',0,-1,0),
(870,'','product','image','缩略图','','',0,0,'','','upload','a:7:{s:4:\"type\";s:1:\"1\";s:5:\"multi\";s:1:\"0\";s:7:\"manager\";s:1:\"0\";s:4:\"view\";s:4:\"true\";s:7:\"butname\";s:6:\"上传\";s:4:\"size\";s:0:\"\";s:5:\"style\";s:1:\"1\";}','',0,0,7,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:5:\"image\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(860,'','product','weight','权重','权重越小越靠前','',0,0,'','','text','a:2:{s:4:\"size\";s:1:\"5\";s:5:\"value\";s:3:\"100\";}','',2,1,6,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:6:\"weight\";s:4:\"isdb\";N;}',0,-1,0),
(858,'','product','content','产品详情','','',0,0,'','','editor','a:4:{s:4:\"type\";s:1:\"0\";s:4:\"cols\";s:3:\"800\";s:4:\"rows\";s:3:\"350\";s:5:\"value\";s:0:\"\";}','',0,1,8,1,'','a:6:{s:8:\"key_name\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:4:\"TEXT\";s:4:\"name\";s:7:\"content\";s:4:\"isdb\";N;}',0,-1,0),
(857,'','product','hits','浏览量','','',0,0,'','','text','a:2:{s:4:\"size\";s:1:\"5\";s:5:\"value\";s:0:\"\";}','',1,1,11,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:4:\"hits\";s:4:\"isdb\";N;}',0,-1,0),
(856,'','product','catid','所属栏目','','',0,0,'','请选择所属于栏目','select','a:3:{s:6:\"option\";s:0:\"\";s:4:\"type\";s:1:\"1\";s:5:\"value\";s:0:\"\";}','',1,1,5,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:5:\"catid\";s:4:\"isdb\";N;}',0,-1,0),
(855,'','product','pubtime','发布时间','','',0,0,'','','datetime','a:4:{s:6:\"istime\";s:1:\"1\";s:6:\"isinte\";s:1:\"0\";s:4:\"size\";s:2:\"25\";s:6:\"format\";s:19:\"YYYY-MM-DD hh:mm:ss\";}','',0,1,20,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:7:\"pubtime\";s:4:\"isdb\";N;}',0,-1,0),
(533,'','video','reltime','上映时间','','',0,0,'','','datetime','a:4:{s:6:\"istime\";s:1:\"0\";s:6:\"isinte\";s:1:\"0\";s:4:\"size\";s:2:\"15\";s:6:\"format\";s:10:\"YYYY-MM-DD\";}','',2,0,9,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:3:\"INT\";s:4:\"name\";s:7:\"reltime\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(534,'','video','duration','时长','','',0,0,'','','text','a:2:{s:4:\"size\";s:2:\"20\";s:5:\"value\";s:0:\"\";}','',1,0,9,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:8:\"duration\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(535,'','article','contenttpl','内容模板','','',0,0,'','','text','a:2:{s:4:\"size\";s:2:\"35\";s:5:\"value\";s:0:\"\";}','',2,1,18,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:10:\"contenttpl\";s:4:\"isdb\";N;}',0,0,0),
(536,'','image','contenttpl','内容模板','','',0,0,'','','text','a:2:{s:4:\"size\";s:2:\"35\";s:5:\"value\";s:0:\"\";}','',0,0,18,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:10:\"contenttpl\";s:4:\"isdb\";s:1:\"1\";}',0,1,1),
(869,'','product','subhead','产品副标题','','',0,0,'','','text','a:2:{s:4:\"size\";s:2:\"60\";s:5:\"value\";s:0:\"\";}','',0,0,2,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:7:\"subhead\";s:4:\"isdb\";s:1:\"1\";}',0,-1,1),
(854,'','product','title','产品标题','','',0,0,'','请输入产品标题','text','a:2:{s:4:\"size\";s:2:\"60\";s:5:\"value\";s:0:\"\";}','',0,1,1,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:5:\"title\";s:4:\"isdb\";N;}',0,-1,0),
(539,'','video','contenttpl','内容模板','','',0,0,'','','text','a:2:{s:4:\"size\";s:2:\"35\";s:5:\"value\";s:0:\"\";}','',0,0,18,1,'','a:8:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:10:\"contenttpl\";s:4:\"isdb\";s:1:\"1\";}',0,2,1),
(852,'','product','flag','推荐位','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',0,1,3,1,'','a:6:{s:8:\"key_name\";s:4:\"flag\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:4:\"flag\";}',2,-1,1),
(853,'','product','abstract','摘要','','',0,0,'','','text','a:2:{s:4:\"size\";s:0:\"\";s:5:\"value\";s:0:\"\";}','',0,1,7,1,'','a:7:{s:8:\"key_name\";s:0:\"\";s:6:\"length\";s:3:\"255\";s:5:\"value\";s:0:\"\";s:8:\"comments\";s:0:\"\";s:8:\"key_type\";i:0;s:4:\"type\";s:7:\"VARCHAR\";s:4:\"name\";s:8:\"abstract\";}',0,-1,1)--MagicCMS;


--
-- 表的结构 `mac_flag` 
--

CREATE TABLE IF NOT EXISTS `mac_flag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `flag` char(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '',
  `title` char(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '',
  `status` tinyint(1) DEFAULT '1',
  `model` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `flag` (`flag`),
  KEY `model` (`model`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='推荐位表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_flag` 
--

INSERT INTO `mac_flag` (`id`,`flag`,`title`,`status`,`model`) VALUES
(1,'c','推荐',1,-1),
(2,'h','头条',1,-1),
(3,'a','特荐',1,-1),
(4,'f','幻灯',1,-1),
(5,'s','滚动',1,-1)--MagicCMS;


--
-- 表的结构 `mac_model` 
--

CREATE TABLE IF NOT EXISTS `mac_model` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `model` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `tabs` text,
  PRIMARY KEY (`id`),
  KEY `model` (`model`),
  KEY `value` (`value`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=71 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='模型表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_model` 
--

INSERT INTO `mac_model` (`id`,`model`,`value`,`description`,`status`,`tabs`) VALUES
(1,'文章模型','article','',1,'高级参数'),
(3,'图片模型','image','',1,'图片集~高级参数'),
(4,'视频模型','video','',1,'视频列表~所属类型~高级参数'),
(2,'产品模型','product','',1,'产品相册')--MagicCMS;


--
-- 表的结构 `mac_node` 
--

CREATE TABLE IF NOT EXISTS `mac_node` (
  `nid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) NOT NULL DEFAULT '0',
  `menu` int(2) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  `module` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模块',
  `controller` varchar(50) COLLATE utf8_unicode_ci DEFAULT 'index',
  `action` varchar(50) COLLATE utf8_unicode_ci DEFAULT 'index' COMMENT '操作',
  `param` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '参数',
  `title` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sorter` int(10) DEFAULT NULL,
  `pubtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `team` varchar(10) CHARACTER SET utf8 DEFAULT '大秦科技',
  PRIMARY KEY (`nid`),
  KEY `pid` (`pid`),
  KEY `status` (`status`),
  KEY `sorter` (`sorter`)
) ENGINE=MyISAM AUTO_INCREMENT=124 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='节点表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_node` 
--

INSERT INTO `mac_node` (`nid`,`pid`,`menu`,`status`,`module`,`controller`,`action`,`param`,`title`,`sorter`,`pubtime`,`team`) VALUES
(1,0,0,1,'login','index','index','','管理员登陆',0,'0000-00-00 00:00:00','大秦科技'),
(2,0,0,1,'logout','index','index','','管理员退出',8,'0000-00-00 00:00:00','大秦科技'),
(3,0,0,1,'verify','index','index','','验证码',9,'0000-00-00 00:00:00','大秦科技'),
(4,0,1,1,'content','index','index','','内容管理',1,'2015-11-13 13:26:58','大秦科技'),
(6,0,1,1,'module','index','index','','模块管理',4,'2015-11-13 13:35:58','大秦科技'),
(7,0,1,1,'templets','index','index','','模板管理',6,'2015-11-13 13:36:19','大秦科技'),
(9,0,1,1,'setting','index','index','','系统设置',7,'2015-11-13 13:36:28','大秦科技'),
(10,4,1,1,'','','','','内容管理',11,'0000-00-00 00:00:00','大秦科技'),
(11,10,1,1,'archives','index','index','article','文档管理',1,'2015-11-21 21:40:32','大秦科技'),
(12,11,3,1,'archives','index','edit','article','添加/编辑文档',13,'2015-11-21 21:40:38','大秦科技'),
(19,11,3,1,'archives','index','del','','删除文档',20,'2015-11-21 21:40:43','大秦科技'),
(25,10,1,1,'class','index','index','','栏目管理',26,'2015-11-21 21:41:59','大秦科技'),
(27,25,3,1,'class','index','index','','添加/编辑栏目',28,'2015-11-13 09:53:56','大秦科技'),
(29,25,3,1,'class','index','index','','删除栏目',29,'2015-11-13 09:54:21','大秦科技'),
(32,10,1,1,'model','index','index','','模型管理',33,'2015-11-21 21:41:45','大秦科技'),
(33,10,1,1,'flag','index','index','','推荐位管理',36,'2015-11-21 21:42:24','大秦科技'),
(34,32,3,1,'model','index','edit','','添加/编辑模型',34,'2015-11-13 10:02:23','大秦科技'),
(36,32,3,1,'model','index','del','','删除模型',35,'2015-11-13 10:23:44','大秦科技'),
(45,6,1,1,'','','','','模块管理',64,'2015-11-13 10:26:29','大秦科技'),
(46,45,1,1,'guestbook','index','index','','留言板',65,'2015-11-13 10:26:47','大秦科技'),
(47,45,1,1,'links','index','index','','友情链接',68,'2015-11-13 10:27:05','大秦科技'),
(48,50,3,1,'slide','index','index','','添加/编辑幻灯片',72,'2015-11-13 10:29:13','大秦科技'),
(49,50,3,1,'slide','index','index','','删除幻灯片管理',73,'2015-11-13 10:29:25','大秦科技'),
(50,45,1,1,'slide','index','index','','幻灯片管理',71,'2015-11-13 10:27:27','大秦科技'),
(52,45,1,1,'kefu','index','index','','客服设置',80,'2015-11-13 10:28:26','大秦科技'),
(53,0,1,0,'notice','index','index','','公告管理',81,'0000-00-00 00:00:00','大秦科技'),
(54,45,1,1,'linksubmit','index','index','','百度链接推送',82,'2015-11-13 10:28:46','大秦科技'),
(55,7,1,1,'','','','','模板管理',84,'2015-11-13 10:33:40','大秦科技'),
(56,55,1,1,'templets','index','index','','模板列表',85,'2015-11-13 10:34:23','大秦科技'),
(59,55,1,1,'expand','index','index','tpltech','模板教程',88,'2015-11-22 11:26:32','大秦科技'),
(65,70,1,1,'files','index','index','','文件管理',98,'2015-11-21 21:37:15','大秦科技'),
(70,9,1,1,'','','','','系统管理',2,'2015-11-13 10:42:39','大秦科技'),
(71,70,1,1,'setting','index','index','','网站信息',1,'2015-11-13 15:36:10','大秦科技'),
(72,70,1,1,'admin','index','index','','网站管理员',2,'2015-11-13 15:36:27','大秦科技'),
(73,70,1,1,'system','index','index','','系统设置',5,'2015-11-13 10:44:36','大秦科技'),
(74,70,1,1,'database','index','index','','数据库管理',6,'2015-11-13 10:44:50','大秦科技'),
(75,70,1,1,'admin','group','index','','管理员组',3,'2015-11-15 01:11:22','大秦科技'),
(77,47,3,1,'links','index','edit','','添加/编辑友情链接',69,'2015-11-13 10:29:49','大秦科技'),
(79,33,3,1,'flag','index','edit','','添加/编辑推荐位',37,'2015-11-13 10:14:47','大秦科技'),
(81,46,3,1,'guestbook','index','edit','','添加/编辑留言',66,'2015-11-13 10:30:05','大秦科技'),
(92,47,3,1,'links','index','del','','删除友情链接',70,'2015-11-13 10:31:35','大秦科技'),
(94,33,3,1,'flag','index','del','','删除推荐位',38,'2015-11-13 10:19:43','大秦科技'),
(96,46,3,1,'guestbook','index','del','','删除留言',67,'2015-11-13 10:31:52','大秦科技'),
(108,70,1,1,'menu','index','index','','系统菜单管理',8,'2015-11-13 13:37:00','大秦科技'),
(109,72,3,1,'admin','index','edit','','添加/编辑管理员',1,'2015-11-13 13:50:48','大秦科技'),
(110,72,3,1,'admin','index','del','','删除管理员',2,'2015-11-13 13:51:24','大秦科技'),
(111,75,3,1,'admin','group','edit','','添加/编辑管理员组',1,'2015-11-15 01:11:38','大秦科技'),
(112,75,3,1,'rbac','group','index','','删除管理员组',2,'2015-11-15 01:11:52','大秦科技'),
(113,108,3,1,'menu','index','index','','添加/编辑菜单',1,'2015-11-13 13:55:30','大秦科技'),
(114,108,3,1,'menu','index','index','','删除菜单',2,'2015-11-13 13:55:01','大秦科技'),
(115,65,3,1,'files','index','index','','编辑文件',1,'2015-11-13 13:58:10','大秦科技'),
(116,65,3,1,'files','index','del','','删除文件',2,'2015-11-13 13:59:11','大秦科技'),
(117,65,3,1,'files','upload','index','','上传文件',3,'2015-11-19 01:01:34','大秦科技'),
(118,56,3,1,'templets','index','start','','切换模板',1,'2015-11-18 20:20:26','大秦科技'),
(119,74,3,1,'database','export','index','','数据库导出',0,'2015-11-13 14:09:59','大秦科技'),
(120,74,3,1,'database','import','index','','数据库导入',2,'2015-11-13 14:10:09','大秦科技'),
(121,74,3,1,'database','sql','index','','SQL编辑器',3,'2015-11-13 14:09:46','大秦科技'),
(122,74,3,0,'database','fields','index','','字段管理',4,'2015-11-13 14:11:48','大秦科技')--MagicCMS;


--
-- 表的结构 `mac_role` 
--

CREATE TABLE IF NOT EXISTS `mac_role` (
  `rid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `status` tinyint(1) unsigned DEFAULT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `pubtime` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rid`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='权限表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_role` 
--

INSERT INTO `mac_role` (`rid`,`name`,`status`,`desc`,`pubtime`) VALUES
(1,'超级管理员',1,'',''),
(2,'文章编辑员',1,'',1447521837)--MagicCMS;


--
-- 表的结构 `mac_setting` 
--

CREATE TABLE IF NOT EXISTS `mac_setting` (
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` text,
  `type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文章信息表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_setting` 
--

INSERT INTO `mac_setting` (`name`,`value`,`type`) VALUES
('address','山东省济宁市高新区金宇路红星国际SOHO1905',0),
('comname','济宁大秦网络科技有限公司',0),
('contacts','周经理',0),
('copyright','<br>Copyright © 2015 <a href=\"http://www.qintech.net\">大秦科技</a> 版权所有  <a href=\"http://www.miitbeian.gov.cn\" target=\"_blank\"> 备案号: 鲁ICP备15023645号-1</a>',0),
('description','',0),
('email','',0),
('fax','',0),
('keywords','',0),
('logo','/Uploads/image/20150910/70191441858319.png',0),
('mobile','',0),
('qq',878255150,0),
('statistics','',0),
('subhead','',0),
('tel',15206721239,0),
('title','Magic 演示站 政企版',0),
('url','http://192.168.1.23',0),
('wechat','',0)--MagicCMS;


--
-- 表的结构 `mac_user` 
--

CREATE TABLE IF NOT EXISTS `mac_user` (
  `uid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `uname` varchar(100) DEFAULT NULL COMMENT '用户名',
  `nickname` varchar(255) DEFAULT NULL COMMENT '用户昵称',
  `uavatar` varchar(255) DEFAULT NULL COMMENT '用户头像',
  `utype` varchar(50) DEFAULT NULL COMMENT '用户类型',
  `password` varchar(32) DEFAULT NULL COMMENT '用户密码',
  `sex` varchar(255) DEFAULT '保密' COMMENT '性别',
  `logtime` varchar(255) DEFAULT NULL COMMENT '最后登录时间',
  `ip` varchar(20) DEFAULT NULL COMMENT '登录ID',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `lognum` int(10) NOT NULL DEFAULT '0' COMMENT '登录次数',
  `address` int(11) DEFAULT NULL COMMENT '地址',
  `email` varchar(255) DEFAULT NULL COMMENT '用户邮箱',
  `mobile` varchar(255) DEFAULT NULL COMMENT '手机号',
  `regtime` varchar(255) DEFAULT NULL COMMENT '注册时间',
  `qq` varchar(255) DEFAULT NULL COMMENT 'QQ',
  `weixin` varchar(255) DEFAULT NULL COMMENT '微信',
  `weibo` varchar(255) DEFAULT NULL COMMENT '微博',
  `rid` int(5) NOT NULL DEFAULT '0' COMMENT '权限',
  PRIMARY KEY (`uid`),
  KEY `email` (`email`),
  KEY `mobile` (`mobile`),
  KEY `pid` (`rid`),
  KEY `status` (`status`),
  KEY `uname` (`uname`)
) ENGINE=MyISAM AUTO_INCREMENT=329549 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员信息表'--MagicCMS;

-- -------------------------------------------------------

--
-- 表的结构 `mac_user_note` 
--

CREATE TABLE IF NOT EXISTS `mac_user_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` text,
  `update` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='记事本表'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_user_note` 
--

INSERT INTO `mac_user_note` (`id`,`content`,`update`) VALUES
(1,'欢迎使用Magic CMS系统，祝您工作愉快！','2015-11-22 14:35:44')--MagicCMS;


--
-- 表的结构 `mac_user_panel` 
--

CREATE TABLE IF NOT EXISTS `mac_user_panel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT NULL COMMENT '管理员ID',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `nid` int(11) DEFAULT NULL,
  `sorter` int(11) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='管理员面板'--MagicCMS;

-- -------------------------------------------------------


--
-- 转存表中的数据 `mac_user_panel` 
--

INSERT INTO `mac_user_panel` (`id`,`uid`,`title`,`nid`,`sorter`) VALUES
(1,1,'内容管理',11,1),
(2,1,'栏目管理',25,3)--MagicCMS;
