DROP TABLE IF EXISTS `nitc_ad`;
CREATE TABLE IF NOT EXISTS `nitc_ad` (
  `ad_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `language_id` int(10) NOT NULL DEFAULT '1',
  `category` varchar(50) COLLATE utf8_bin NOT NULL,
  `url` varchar(255) COLLATE utf8_bin NOT NULL,
  `name` varchar(255) COLLATE utf8_bin NOT NULL,
  `file` varchar(100) COLLATE utf8_bin NOT NULL,
  `sort_order` int(10) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ad_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_attribute`;
CREATE TABLE IF NOT EXISTS `nitc_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `attr_input_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '1=文本框，2=下拉框，3=复选框,4=文本区域',
  `attr_type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `sort_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_attribute_description`;
CREATE TABLE IF NOT EXISTS `nitc_attribute_description` (
  `attr_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `attr_name` varchar(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `attr_values` text COLLATE utf8_bin NOT NULL,
  UNIQUE KEY `attr_id` (`attr_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_brand`;
CREATE TABLE IF NOT EXISTS `nitc_brand` (
  `brand_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL,
  `brand_name` varchar(100) COLLATE utf8_bin NOT NULL,
  `image` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`brand_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_cart`;
CREATE TABLE IF NOT EXISTS `nitc_cart` (
  `rec_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `session_id` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `product_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `model` varchar(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `weight` decimal(10,2) NOT NULL DEFAULT '0.00',
  `name` varchar(120) COLLATE utf8_bin NOT NULL DEFAULT '',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `quantity` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attr` text COLLATE utf8_bin NOT NULL,
  `is_sale` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`rec_id`),
  KEY `session_id` (`session_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_category`;
CREATE TABLE IF NOT EXISTS `nitc_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `show_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0=列表，1=图片',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`category_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin ;

DROP TABLE IF EXISTS `nitc_category_description`;
CREATE TABLE IF NOT EXISTS `nitc_category_description` (
  `category_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(100) COLLATE utf8_bin NOT NULL,
  `template` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `description` text COLLATE utf8_bin,
  `meta_title` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `meta_description` varchar(500) COLLATE utf8_bin DEFAULT NULL,
  `meta_keyword` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`category_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_channel`;
CREATE TABLE IF NOT EXISTS `nitc_channel` (
  `channel_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `image` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `sort_order` int(3) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '后台隐藏，0=否，1=是',
  `show_type` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '1=系统栏目，2=文章列表，3=图文列表，4=外部链接，5=单页',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`channel_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO `nitc_channel` (`channel_id`, `image`, `parent_id`, `sort_order`, `status`, `is_hide`, `show_type`, `date_added`, `date_modified`) VALUES
(1, '', 0, 1, 1, 1, 1, '2014-10-19 22:52:32', '2014-12-09 22:06:06'),
(2, '', 0, 2, 1, 0, 1, '2014-10-19 23:00:45', '2014-12-10 01:36:41'),
(3, '', 0, 3, 1, 0, 1, '2014-10-19 23:00:59', '2014-12-09 22:07:08'),
(4, '', 0, 4, 1, 0, 1, '2014-10-19 23:01:10', '2014-12-09 22:07:11'),
(5, '', 0, 5, 1, 0, 1, '2014-10-19 23:01:23', '2014-12-09 22:07:13'),
(6, '', 0, 6, 1, 0, 1, '2014-10-19 23:01:39', '2014-12-10 01:44:29'),
(15, '', 2, 16, 1, 0, 5, '2014-11-01 23:36:12', '2014-12-10 23:35:05'),
(14, '', 2, 11, 1, 0, 5, '2014-11-01 23:35:48', '2015-03-19 00:15:14'),
(16, '', 2, 21, 1, 0, 2, '2014-11-01 23:36:31', '2014-12-09 22:07:03'),
(17, '', 2, 26, 1, 0, 2, '2014-11-01 23:36:57', '2014-12-10 23:55:48'),
(18, '', 2, 31, 1, 0, 5, '2014-11-01 23:37:17', '2014-12-09 22:07:04'),
(19, '', 2, 36, 1, 0, 5, '2014-11-01 23:37:33', '2014-12-09 22:07:06'),
(20, '', 0, 41, 1, 1, 1, '2014-12-09 22:58:11', '2014-12-09 22:58:11'),
(21, '', 0, 46, 1, 1, 1, '2014-12-10 01:11:53', '2014-12-10 01:11:53');
(22, '', 0, 51, 1, 1, 1, '2014-12-10 01:11:53', '2014-12-10 01:11:53');


DROP TABLE IF EXISTS `nitc_channel_description`;
CREATE TABLE IF NOT EXISTS `nitc_channel_description` (
  `channel_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(100) COLLATE utf8_bin NOT NULL,
  `image` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `description` text COLLATE utf8_bin,
  `ext_field` longtext COLLATE utf8_bin,
  `template` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `meta_keyword` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `meta_description` varchar(500) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`channel_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO `nitc_channel_description` (`channel_id`, `language_id`, `name`, `image`, `description`, `ext_field`, `template`, `meta_title`, `meta_keyword`, `meta_description`) VALUES
(1, 2, '首页', '', '', 'a:0:{}', '', '', '', ''),
(1, 1, 'Home', '', '', 'a:0:{}', '', '', '', ''),
(2, 2, '公司介绍', '', '', 'a:0:{}', '', '', '', ''),
(2, 1, 'About Us', '', '', 'a:0:{}', '', '', '', ''),
(3, 2, '产品展示', '', '', 'a:0:{}', '', '', '', ''),
(3, 1, 'Products', '', '', 'a:0:{}', '', '', '', ''),
(4, 2, '新闻动态', '', '', 'a:0:{}', '', '', '', ''),
(4, 1, 'News', '', '', 'a:0:{}', '', '', '', ''),
(5, 2, '在线咨询', '', '', 'a:0:{}', '', '', '', ''),
(5, 1, 'Inquiry', '', '', 'a:0:{}', '', '', '', ''),
(6, 2, '联系我们', '', '', 'a:0:{}', '', '', '', ''),
(6, 1, 'Contact Us', '', '', 'a:0:{}', '', '', '', ''),
(18, 2, '企业文化', '', '', 'a:0:{}', '', '', '', ''),
(17, 2, '管理团队', '', '', 'a:0:{}', '', '', '', ''),
(17, 1, 'Management Team', '', '', 'a:0:{}', '', '', '', ''),
(16, 1, 'Founder', '', '', 'a:0:{}', '', '', '', ''),
(14, 2, '公司简介', '', '', 'a:0:{}', '', '', '', ''),
(14, 1, 'Company Profile', '', '', 'a:0:{}', '', '', '', ''),
(15, 2, '发展历程', '', '', 'a:0:{}', '', '', '', ''),
(15, 1, 'History', '', '', 'a:0:{}', '', '', '', ''),
(16, 2, '创始人', '', '', 'a:0:{}', '', '', '', ''),
(18, 1, 'Corporate Culture', '', '', 'a:0:{}', '', '', '', ''),
(19, 2, '品牌故事', '', '', 'a:0:{}', '', '', '', ''),
(19, 1, 'Brand Story', '', '', 'a:0:{}', '', '', '', ''),
(20, 2, '推荐产品', '', '', 'a:0:{}', '', '', '', ''),
(20, 1, 'Featured Products', '', '', 'a:0:{}', '', '', '', ''),
(21, 2, '产品分类', '', '', 'a:0:{}', '', '', '', ''),
(21, 1, 'Product Category', '', '', 'a:0:{}', '', '', '', '');
(22, 2, '手机二维码', '', '', 'a:0:{}', '', '', '', ''),
(22, 1, 'Mobile Code', '', '', 'a:0:{}', '', '', '', '');

DROP TABLE IF EXISTS `nitc_config`;
CREATE TABLE IF NOT EXISTS `nitc_config` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(100) COLLATE utf8_bin NOT NULL,
  `appid` char(18) COLLATE utf8_bin NOT NULL,
  `appsecret` char(32) COLLATE utf8_bin NOT NULL,
  `access_token` char(150) COLLATE utf8_bin NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=2 ;

INSERT INTO `nitc_config` (`id`, `token`, `appid`, `appsecret`, `access_token`, `dateline`) VALUES
(1, 'wxlege', '', '', '', 0);

DROP TABLE IF EXISTS `nitc_customer`;
CREATE TABLE IF NOT EXISTS `nitc_customer` (
  `customer_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) COLLATE utf8_bin NOT NULL,
  `name` varchar(100) COLLATE utf8_bin NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_bin NOT NULL DEFAULT '',
  `telephone` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `mobile` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `fax` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `password` varchar(50) COLLATE utf8_bin NOT NULL DEFAULT '',
  `salt` varchar(10) COLLATE utf8_bin NOT NULL DEFAULT '',
  `customer_group_id` int(11) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(30) COLLATE utf8_bin DEFAULT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_name` (`user_name`),
  KEY `customer_group_id` (`customer_group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_customer_address`;
CREATE TABLE IF NOT EXISTS `nitc_customer_address` (
  `address_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `name` varchar(100) COLLATE utf8_bin NOT NULL DEFAULT '',
  `mobile` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `telephone` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `company` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `address` varchar(128) COLLATE utf8_bin DEFAULT NULL,
  `postcode` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `country_id` int(11) unsigned NOT NULL DEFAULT '0',
  `province_id` int(11) unsigned NOT NULL DEFAULT '0',
  `city_id` int(11) unsigned NOT NULL DEFAULT '0',
  `district_id` int(11) unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`address_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_customer_group`;
CREATE TABLE IF NOT EXISTS `nitc_customer_group` (
  `customer_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_bin NOT NULL,
  `discount` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customer_group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO `nitc_customer_group` (`customer_group_id`, `name`, `discount`) VALUES
(1, '金牌', '0'),
(2, '银牌', '0'),
(3, '铜牌', '0');

DROP TABLE IF EXISTS `nitc_goods_share_log`;
CREATE TABLE IF NOT EXISTS `nitc_goods_share_log` (
  `log_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `goods_id` mediumint(8) NOT NULL,
  `share_time` int(10) NOT NULL,
  `open_id` varchar(64) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin ;

DROP TABLE IF EXISTS `nitc_information`;
CREATE TABLE IF NOT EXISTS `nitc_information` (
  `information_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `channel_id` int(11) NOT NULL,
  `image` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_comment` tinyint(1) NOT NULL DEFAULT '0',
  `is_featured` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `viewed` int(5) NOT NULL DEFAULT '0',
  `share_cnt` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '赞次数',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`information_id`),
  KEY `channel_id` (`channel_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_information_description`;
CREATE TABLE IF NOT EXISTS `nitc_information_description` (
  `information_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_bin NOT NULL,
  `description` text COLLATE utf8_bin,
  `ext_field` longtext COLLATE utf8_bin,
  `template` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `meta_keyword` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`information_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_information_file`;
CREATE TABLE IF NOT EXISTS `nitc_information_file` (
  `information_file_id` int(11) NOT NULL AUTO_INCREMENT,
  `information_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_bin NOT NULL,
  `file` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`information_file_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin ;

DROP TABLE IF EXISTS `nitc_information_image`;
CREATE TABLE IF NOT EXISTS `nitc_information_image` (
  `information_image_id` int(11) NOT NULL AUTO_INCREMENT,
  `information_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_bin NOT NULL,
  `image` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`information_image_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_inquiry`;
CREATE TABLE IF NOT EXISTS `nitc_inquiry` (
  `inquiry_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) unsigned NOT NULL DEFAULT '0',
  `customer_id` int(11) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(250) COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` varchar(100) COLLATE utf8_bin NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `telephone` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `content` text COLLATE utf8_bin,
  `ip` varchar(20) COLLATE utf8_bin DEFAULT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`inquiry_id`),
  KEY `customer_id` (`customer_id`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_language`;
CREATE TABLE IF NOT EXISTS `nitc_language` (
  `language_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_bin NOT NULL,
  `code` varchar(50) COLLATE utf8_bin NOT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`language_id`),
  KEY `code` (`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=7 ;

INSERT INTO `nitc_language` (`language_id`, `name`, `code`, `sort_order`, `status`) VALUES
(1, 'English', 'en', 2, 1),
(2, '简体中文', 'zh_cn', 1, 1);

DROP TABLE IF EXISTS `nitc_mail_templates`;
CREATE TABLE IF NOT EXISTS `nitc_mail_templates` (
  `template_id` tinyint(1) unsigned NOT NULL AUTO_INCREMENT,
  `template_code` varchar(30) COLLATE utf8_bin NOT NULL DEFAULT '',
  `is_html` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `template_subject` varchar(200) COLLATE utf8_bin NOT NULL DEFAULT '',
  `template_content` text COLLATE utf8_bin,
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `template_code` (`template_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=4 ;

INSERT INTO `nitc_mail_templates` (`template_id`, `template_code`, `is_html`, `template_subject`, `template_content`, `date_modified`) VALUES
(1, 'send_password', 1, '找回密码', '<p>{$user_name}，您好!\r\n\r\n您已经进行了密码重置的操作，请点击以下链接(或者复制到您的浏览器):\r\n\r\n{$reset_email}\r\n\r\n以确认您的新密码重置操作!\r\n\r\n{$send_date}</p>', '0000-00-00 00:00:00'),
(2, 'send_inquiry', 1, '咨询信息转发', '咨询主题:{$subject}\r\n咨询内容:\r\n{$content}\r\n日期:{$date_added}\r\n咨询产品:{$product_name}\r\n公司名:{$company_name}\r\n联系人:{$name} {$sex}\r\n邮箱:{$email}\r\n电话:{$tel}\r\n传真:{$fax}\r\n地址:{$address}\r\n国家:{$country}\r\nIP:{$ip}\r\n网站:{$website}', '0000-00-00 00:00:00'),
(3, 'send_shipping', 1, '发货通知', '<p>asdfasfads<br/></p>', '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `nitc_order`;
CREATE TABLE IF NOT EXISTS `nitc_order` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` varchar(26) COLLATE utf8_bin NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `payment_method` varchar(30) COLLATE utf8_bin NOT NULL,
  `payment_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `payment_fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `shipping_method` varchar(30) COLLATE utf8_bin NOT NULL,
  `shipping_no` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `shipping_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `shipping_name` varchar(50) COLLATE utf8_bin NOT NULL,
  `shipping_mobile` varchar(50) COLLATE utf8_bin NOT NULL,
  `shipping_address` varchar(128) COLLATE utf8_bin NOT NULL,
  `shipping_province` int(11) unsigned NOT NULL DEFAULT '0',
  `shipping_city` int(11) unsigned NOT NULL DEFAULT '0',
  `shipping_district` int(11) unsigned NOT NULL DEFAULT '0',
  `shipping_zip` varchar(20) COLLATE utf8_bin NOT NULL,
  `shipping_country` int(11) unsigned NOT NULL DEFAULT '0',
  `shipping_tel` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `shipping_email` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `remark` text COLLATE utf8_bin NOT NULL,
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '0=未付款，1=已付款，2=已发货，3=订单完成，4=订单取消，5=退货，6=无效订单',
  `language_id` int(11) NOT NULL,
  `ip` varchar(40) COLLATE utf8_bin NOT NULL,
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_preordain` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_order_product`;
CREATE TABLE IF NOT EXISTS `nitc_order_product` (
  `order_product_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) unsigned NOT NULL DEFAULT '0',
  `product_id` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8_bin NOT NULL,
  `model` varchar(64) COLLATE utf8_bin NOT NULL,
  `attr` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `quantity` int(11) unsigned NOT NULL DEFAULT '0',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total` decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`order_product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_payment`;
CREATE TABLE IF NOT EXISTS `nitc_payment` (
  `pay_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `pay_code` varchar(20) COLLATE utf8_bin NOT NULL DEFAULT '',
  `pay_name` varchar(120) COLLATE utf8_bin NOT NULL DEFAULT '',
  `pay_fee` varchar(10) COLLATE utf8_bin NOT NULL DEFAULT '0',
  `pay_desc` text COLLATE utf8_bin NOT NULL,
  `pay_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pay_config` text COLLATE utf8_bin NOT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pay_id`),
  UNIQUE KEY `pay_code` (`pay_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=2 ;

INSERT INTO `nitc_payment` (`pay_id`, `pay_code`, `pay_name`, `pay_fee`, `pay_desc`, `pay_order`, `pay_config`, `enabled`, `is_cod`, `is_online`) VALUES
(1, 'alipay', '支付宝', '0', '', 0, '', 1, 0, 1);

DROP TABLE IF EXISTS `nitc_product`;
CREATE TABLE IF NOT EXISTS `nitc_product` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `model` varchar(64) COLLATE utf8_bin NOT NULL,
  `quantity` int(4) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL,
  `weight` decimal(10,3) NOT NULL DEFAULT '0.000',
  `market_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `shop_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `image` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `minimum` int(11) NOT NULL DEFAULT '1',
  `product_nature` varchar(50) COLLATE utf8_bin DEFAULT NULL COMMENT '产品性质',
  `customer_market` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '针对客户市场',
  `differentiated_performance` varchar(50) COLLATE utf8_bin DEFAULT NULL COMMENT '核心差异化表现',
  `regional_advantage` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '区域优势',
  `honor_rank` varchar(50) COLLATE utf8_bin DEFAULT NULL COMMENT '荣誉排名',
  `honor_rank_file` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '荣誉证书',
  `listing_date` varchar(50) COLLATE utf8_bin DEFAULT NULL COMMENT '上市日期',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `is_comment` tinyint(1) NOT NULL DEFAULT '0',
  `is_protection` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐产品',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `viewed` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_product_attr`;
CREATE TABLE IF NOT EXISTS `nitc_product_attr` (
  `product_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL,
  `product_id` int(11) unsigned NOT NULL DEFAULT '0',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0',
  `attr_value` text COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`product_attr_id`),
  KEY `goods_id` (`product_id`),
  KEY `attr_id` (`attr_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=322 ;

DROP TABLE IF EXISTS `nitc_product_description`;
CREATE TABLE IF NOT EXISTS `nitc_product_description` (
  `product_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `brand_id` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8_bin NOT NULL,
  `template` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `video` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `description` text COLLATE utf8_bin,
  `advantages` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '产品独特优势',
  `customer_groups` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '产品独特优势',
  `product_patents` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '产品专利',
  `meta_title` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `meta_keyword` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `meta_description` varchar(500) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`product_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_product_file`;
CREATE TABLE IF NOT EXISTS `nitc_product_file` (
  `product_file_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_bin NOT NULL,
  `file` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_file_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_product_image`;
CREATE TABLE IF NOT EXISTS `nitc_product_image` (
  `product_image_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_bin NOT NULL,
  `image` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_image_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_region`;
CREATE TABLE IF NOT EXISTS `nitc_region` (
  `region_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `region_name` varchar(120) COLLATE utf8_bin NOT NULL DEFAULT '',
  `iso_code_2` varchar(10) COLLATE utf8_bin DEFAULT NULL,
  `region_type` tinyint(1) NOT NULL DEFAULT '2',
  `agency_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`region_id`),
  KEY `parent_id` (`parent_id`),
  KEY `region_type` (`region_type`),
  KEY `agency_id` (`agency_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=3896 ;

INSERT INTO `nitc_region` (`region_id`, `parent_id`, `region_name`, `iso_code_2`, `region_type`, `agency_id`) VALUES
(1, 0, '中国', 'CN', 0, 0),
(2, 1, '北京', NULL, 1, 0),
(3, 1, '安徽', NULL, 1, 0),
(4, 1, '福建', NULL, 1, 0),
(5, 1, '甘肃', NULL, 1, 0),
(6, 1, '广东', NULL, 1, 0),
(7, 1, '广西', NULL, 1, 0),
(8, 1, '贵州', NULL, 1, 0),
(9, 1, '海南', NULL, 1, 0),
(10, 1, '河北', NULL, 1, 0),
(11, 1, '河南', NULL, 1, 0),
(12, 1, '黑龙江', NULL, 1, 0),
(13, 1, '湖北', NULL, 1, 0),
(14, 1, '湖南', NULL, 1, 0),
(15, 1, '吉林', NULL, 1, 0),
(16, 1, '江苏', NULL, 1, 0),
(17, 1, '江西', NULL, 1, 0),
(18, 1, '辽宁', NULL, 1, 0),
(19, 1, '内蒙古', NULL, 1, 0),
(20, 1, '宁夏', NULL, 1, 0),
(21, 1, '青海', NULL, 1, 0),
(22, 1, '山东', NULL, 1, 0),
(23, 1, '山西', NULL, 1, 0),
(24, 1, '陕西', NULL, 1, 0),
(25, 1, '上海', NULL, 1, 0),
(26, 1, '四川', NULL, 1, 0),
(27, 1, '天津', NULL, 1, 0),
(28, 1, '西藏', NULL, 1, 0),
(29, 1, '新疆', NULL, 1, 0),
(30, 1, '云南', NULL, 1, 0),
(31, 1, '浙江', NULL, 1, 0),
(32, 1, '重庆', NULL, 1, 0),
(33, 1, '香港', NULL, 1, 0),
(34, 1, '澳门', NULL, 1, 0),
(35, 1, '台湾', NULL, 1, 0),
(36, 3, '安庆', NULL, 2, 0),
(37, 3, '蚌埠', NULL, 2, 0),
(38, 3, '巢湖', NULL, 2, 0),
(39, 3, '池州', NULL, 2, 0),
(40, 3, '滁州', NULL, 2, 0),
(41, 3, '阜阳', NULL, 2, 0),
(42, 3, '淮北', NULL, 2, 0),
(43, 3, '淮南', NULL, 2, 0),
(44, 3, '黄山', NULL, 2, 0),
(45, 3, '六安', NULL, 2, 0),
(46, 3, '马鞍山', NULL, 2, 0),
(47, 3, '宿州', NULL, 2, 0),
(48, 3, '铜陵', NULL, 2, 0),
(49, 3, '芜湖', NULL, 2, 0),
(50, 3, '宣城', NULL, 2, 0),
(51, 3, '亳州', NULL, 2, 0),
(52, 2, '北京', NULL, 2, 0),
(53, 4, '福州', NULL, 2, 0),
(54, 4, '龙岩', NULL, 2, 0),
(55, 4, '南平', NULL, 2, 0),
(56, 4, '宁德', NULL, 2, 0),
(57, 4, '莆田', NULL, 2, 0),
(58, 4, '泉州', NULL, 2, 0),
(59, 4, '三明', NULL, 2, 0),
(60, 4, '厦门', NULL, 2, 0),
(61, 4, '漳州', NULL, 2, 0),
(62, 5, '兰州', NULL, 2, 0),
(63, 5, '白银', NULL, 2, 0),
(64, 5, '定西', NULL, 2, 0),
(65, 5, '甘南', NULL, 2, 0),
(66, 5, '嘉峪关', NULL, 2, 0),
(67, 5, '金昌', NULL, 2, 0),
(68, 5, '酒泉', NULL, 2, 0),
(69, 5, '临夏', NULL, 2, 0),
(70, 5, '陇南', NULL, 2, 0),
(71, 5, '平凉', NULL, 2, 0),
(72, 5, '庆阳', NULL, 2, 0),
(73, 5, '天水', NULL, 2, 0),
(74, 5, '武威', NULL, 2, 0),
(75, 5, '张掖', NULL, 2, 0),
(76, 6, '广州', NULL, 2, 0),
(77, 6, '深圳', NULL, 2, 0),
(78, 6, '潮州', NULL, 2, 0),
(79, 6, '东莞', NULL, 2, 0),
(80, 6, '佛山', NULL, 2, 0),
(81, 6, '河源', NULL, 2, 0),
(82, 6, '惠州', NULL, 2, 0),
(83, 6, '江门', NULL, 2, 0),
(84, 6, '揭阳', NULL, 2, 0),
(85, 6, '茂名', NULL, 2, 0),
(86, 6, '梅州', NULL, 2, 0),
(87, 6, '清远', NULL, 2, 0),
(88, 6, '汕头', NULL, 2, 0),
(89, 6, '汕尾', NULL, 2, 0),
(90, 6, '韶关', NULL, 2, 0),
(91, 6, '阳江', NULL, 2, 0),
(92, 6, '云浮', NULL, 2, 0),
(93, 6, '湛江', NULL, 2, 0),
(94, 6, '肇庆', NULL, 2, 0),
(95, 6, '中山', NULL, 2, 0),
(96, 6, '珠海', NULL, 2, 0),
(97, 7, '南宁', NULL, 2, 0),
(98, 7, '桂林', NULL, 2, 0),
(99, 7, '百色', NULL, 2, 0),
(100, 7, '北海', NULL, 2, 0),
(101, 7, '崇左', NULL, 2, 0),
(102, 7, '防城港', NULL, 2, 0),
(103, 7, '贵港', NULL, 2, 0),
(104, 7, '河池', NULL, 2, 0),
(105, 7, '贺州', NULL, 2, 0),
(106, 7, '来宾', NULL, 2, 0),
(107, 7, '柳州', NULL, 2, 0),
(108, 7, '钦州', NULL, 2, 0),
(109, 7, '梧州', NULL, 2, 0),
(110, 7, '玉林', NULL, 2, 0),
(111, 8, '贵阳', NULL, 2, 0),
(112, 8, '安顺', NULL, 2, 0),
(113, 8, '毕节', NULL, 2, 0),
(114, 8, '六盘水', NULL, 2, 0),
(115, 8, '黔东南', NULL, 2, 0),
(116, 8, '黔南', NULL, 2, 0),
(117, 8, '黔西南', NULL, 2, 0),
(118, 8, '铜仁', NULL, 2, 0),
(119, 8, '遵义', NULL, 2, 0),
(120, 9, '海口', NULL, 2, 0),
(121, 9, '三亚', NULL, 2, 0),
(122, 9, '白沙', NULL, 2, 0),
(123, 9, '保亭', NULL, 2, 0),
(124, 9, '昌江', NULL, 2, 0),
(125, 9, '澄迈县', NULL, 2, 0),
(126, 9, '定安县', NULL, 2, 0),
(127, 9, '东方', NULL, 2, 0),
(128, 9, '乐东', NULL, 2, 0),
(129, 9, '临高县', NULL, 2, 0),
(130, 9, '陵水', NULL, 2, 0),
(131, 9, '琼海', NULL, 2, 0),
(132, 9, '琼中', NULL, 2, 0),
(133, 9, '屯昌县', NULL, 2, 0),
(134, 9, '万宁', NULL, 2, 0),
(135, 9, '文昌', NULL, 2, 0),
(136, 9, '五指山', NULL, 2, 0),
(137, 9, '儋州', NULL, 2, 0),
(138, 10, '石家庄', NULL, 2, 0),
(139, 10, '保定', NULL, 2, 0),
(140, 10, '沧州', NULL, 2, 0),
(141, 10, '承德', NULL, 2, 0),
(142, 10, '邯郸', NULL, 2, 0),
(143, 10, '衡水', NULL, 2, 0),
(144, 10, '廊坊', NULL, 2, 0),
(145, 10, '秦皇岛', NULL, 2, 0),
(146, 10, '唐山', NULL, 2, 0),
(147, 10, '邢台', NULL, 2, 0),
(148, 10, '张家口', NULL, 2, 0),
(149, 11, '郑州', NULL, 2, 0),
(150, 11, '洛阳', NULL, 2, 0),
(151, 11, '开封', NULL, 2, 0),
(152, 11, '安阳', NULL, 2, 0),
(153, 11, '鹤壁', NULL, 2, 0),
(154, 11, '济源', NULL, 2, 0),
(155, 11, '焦作', NULL, 2, 0),
(156, 11, '南阳', NULL, 2, 0),
(157, 11, '平顶山', NULL, 2, 0),
(158, 11, '三门峡', NULL, 2, 0),
(159, 11, '商丘', NULL, 2, 0),
(160, 11, '新乡', NULL, 2, 0),
(161, 11, '信阳', NULL, 2, 0),
(162, 11, '许昌', NULL, 2, 0),
(163, 11, '周口', NULL, 2, 0),
(164, 11, '驻马店', NULL, 2, 0),
(165, 11, '漯河', NULL, 2, 0),
(166, 11, '濮阳', NULL, 2, 0),
(167, 12, '哈尔滨', NULL, 2, 0),
(168, 12, '大庆', NULL, 2, 0),
(169, 12, '大兴安岭', NULL, 2, 0),
(170, 12, '鹤岗', NULL, 2, 0),
(171, 12, '黑河', NULL, 2, 0),
(172, 12, '鸡西', NULL, 2, 0),
(173, 12, '佳木斯', NULL, 2, 0),
(174, 12, '牡丹江', NULL, 2, 0),
(175, 12, '七台河', NULL, 2, 0),
(176, 12, '齐齐哈尔', NULL, 2, 0),
(177, 12, '双鸭山', NULL, 2, 0),
(178, 12, '绥化', NULL, 2, 0),
(179, 12, '伊春', NULL, 2, 0),
(180, 13, '武汉', NULL, 2, 0),
(181, 13, '仙桃', NULL, 2, 0),
(182, 13, '鄂州', NULL, 2, 0),
(183, 13, '黄冈', NULL, 2, 0),
(184, 13, '黄石', NULL, 2, 0),
(185, 13, '荆门', NULL, 2, 0),
(186, 13, '荆州', NULL, 2, 0),
(187, 13, '潜江', NULL, 2, 0),
(188, 13, '神农架林区', NULL, 2, 0),
(189, 13, '十堰', NULL, 2, 0),
(190, 13, '随州', NULL, 2, 0),
(191, 13, '天门', NULL, 2, 0),
(192, 13, '咸宁', NULL, 2, 0),
(193, 13, '襄樊', NULL, 2, 0),
(194, 13, '孝感', NULL, 2, 0),
(195, 13, '宜昌', NULL, 2, 0),
(196, 13, '恩施', NULL, 2, 0),
(197, 14, '长沙', NULL, 2, 0),
(198, 14, '张家界', NULL, 2, 0),
(199, 14, '常德', NULL, 2, 0),
(200, 14, '郴州', NULL, 2, 0),
(201, 14, '衡阳', NULL, 2, 0),
(202, 14, '怀化', NULL, 2, 0),
(203, 14, '娄底', NULL, 2, 0),
(204, 14, '邵阳', NULL, 2, 0),
(205, 14, '湘潭', NULL, 2, 0),
(206, 14, '湘西', NULL, 2, 0),
(207, 14, '益阳', NULL, 2, 0),
(208, 14, '永州', NULL, 2, 0),
(209, 14, '岳阳', NULL, 2, 0),
(210, 14, '株洲', NULL, 2, 0),
(211, 15, '长春', NULL, 2, 0),
(212, 15, '吉林', NULL, 2, 0),
(213, 15, '白城', NULL, 2, 0),
(214, 15, '白山', NULL, 2, 0),
(215, 15, '辽源', NULL, 2, 0),
(216, 15, '四平', NULL, 2, 0),
(217, 15, '松原', NULL, 2, 0),
(218, 15, '通化', NULL, 2, 0),
(219, 15, '延边', NULL, 2, 0),
(220, 16, '南京', NULL, 2, 0),
(221, 16, '苏州', NULL, 2, 0),
(222, 16, '无锡', NULL, 2, 0),
(223, 16, '常州', NULL, 2, 0),
(224, 16, '淮安', NULL, 2, 0),
(225, 16, '连云港', NULL, 2, 0),
(226, 16, '南通', NULL, 2, 0),
(227, 16, '宿迁', NULL, 2, 0),
(228, 16, '泰州', NULL, 2, 0),
(229, 16, '徐州', NULL, 2, 0),
(230, 16, '盐城', NULL, 2, 0),
(231, 16, '扬州', NULL, 2, 0),
(232, 16, '镇江', NULL, 2, 0),
(233, 17, '南昌', NULL, 2, 0),
(234, 17, '抚州', NULL, 2, 0),
(235, 17, '赣州', NULL, 2, 0),
(236, 17, '吉安', NULL, 2, 0),
(237, 17, '景德镇', NULL, 2, 0),
(238, 17, '九江', NULL, 2, 0),
(239, 17, '萍乡', NULL, 2, 0),
(240, 17, '上饶', NULL, 2, 0),
(241, 17, '新余', NULL, 2, 0),
(242, 17, '宜春', NULL, 2, 0),
(243, 17, '鹰潭', NULL, 2, 0),
(244, 18, '沈阳', NULL, 2, 0),
(245, 18, '大连', NULL, 2, 0),
(246, 18, '鞍山', NULL, 2, 0),
(247, 18, '本溪', NULL, 2, 0),
(248, 18, '朝阳', NULL, 2, 0),
(249, 18, '丹东', NULL, 2, 0),
(250, 18, '抚顺', NULL, 2, 0),
(251, 18, '阜新', NULL, 2, 0),
(252, 18, '葫芦岛', NULL, 2, 0),
(253, 18, '锦州', NULL, 2, 0),
(254, 18, '辽阳', NULL, 2, 0),
(255, 18, '盘锦', NULL, 2, 0),
(256, 18, '铁岭', NULL, 2, 0),
(257, 18, '营口', NULL, 2, 0),
(258, 19, '呼和浩特', NULL, 2, 0),
(259, 19, '阿拉善盟', NULL, 2, 0),
(260, 19, '巴彦淖尔盟', NULL, 2, 0),
(261, 19, '包头', NULL, 2, 0),
(262, 19, '赤峰', NULL, 2, 0),
(263, 19, '鄂尔多斯', NULL, 2, 0),
(264, 19, '呼伦贝尔', NULL, 2, 0),
(265, 19, '通辽', NULL, 2, 0),
(266, 19, '乌海', NULL, 2, 0),
(267, 19, '乌兰察布市', NULL, 2, 0),
(268, 19, '锡林郭勒盟', NULL, 2, 0),
(269, 19, '兴安盟', NULL, 2, 0),
(270, 20, '银川', NULL, 2, 0),
(271, 20, '固原', NULL, 2, 0),
(272, 20, '石嘴山', NULL, 2, 0),
(273, 20, '吴忠', NULL, 2, 0),
(274, 20, '中卫', NULL, 2, 0),
(275, 21, '西宁', NULL, 2, 0),
(276, 21, '果洛', NULL, 2, 0),
(277, 21, '海北', NULL, 2, 0),
(278, 21, '海东', NULL, 2, 0),
(279, 21, '海南', NULL, 2, 0),
(280, 21, '海西', NULL, 2, 0),
(281, 21, '黄南', NULL, 2, 0),
(282, 21, '玉树', NULL, 2, 0),
(283, 22, '济南', NULL, 2, 0),
(284, 22, '青岛', NULL, 2, 0),
(285, 22, '滨州', NULL, 2, 0),
(286, 22, '德州', NULL, 2, 0),
(287, 22, '东营', NULL, 2, 0),
(288, 22, '菏泽', NULL, 2, 0),
(289, 22, '济宁', NULL, 2, 0),
(290, 22, '莱芜', NULL, 2, 0),
(291, 22, '聊城', NULL, 2, 0),
(292, 22, '临沂', NULL, 2, 0),
(293, 22, '日照', NULL, 2, 0),
(294, 22, '泰安', NULL, 2, 0),
(295, 22, '威海', NULL, 2, 0),
(296, 22, '潍坊', NULL, 2, 0),
(297, 22, '烟台', NULL, 2, 0),
(298, 22, '枣庄', NULL, 2, 0),
(299, 22, '淄博', NULL, 2, 0),
(300, 23, '太原', NULL, 2, 0),
(301, 23, '长治', NULL, 2, 0),
(302, 23, '大同', NULL, 2, 0),
(303, 23, '晋城', NULL, 2, 0),
(304, 23, '晋中', NULL, 2, 0),
(305, 23, '临汾', NULL, 2, 0),
(306, 23, '吕梁', NULL, 2, 0),
(307, 23, '朔州', NULL, 2, 0),
(308, 23, '忻州', NULL, 2, 0),
(309, 23, '阳泉', NULL, 2, 0),
(310, 23, '运城', NULL, 2, 0),
(311, 24, '西安', NULL, 2, 0),
(312, 24, '安康', NULL, 2, 0),
(313, 24, '宝鸡', NULL, 2, 0),
(314, 24, '汉中', NULL, 2, 0),
(315, 24, '商洛', NULL, 2, 0),
(316, 24, '铜川', NULL, 2, 0),
(317, 24, '渭南', NULL, 2, 0),
(318, 24, '咸阳', NULL, 2, 0),
(319, 24, '延安', NULL, 2, 0),
(320, 24, '榆林', NULL, 2, 0),
(321, 25, '上海', NULL, 2, 0),
(322, 26, '成都', NULL, 2, 0),
(323, 26, '绵阳', NULL, 2, 0),
(324, 26, '阿坝', NULL, 2, 0),
(325, 26, '巴中', NULL, 2, 0),
(326, 26, '达州', NULL, 2, 0),
(327, 26, '德阳', NULL, 2, 0),
(328, 26, '甘孜', NULL, 2, 0),
(329, 26, '广安', NULL, 2, 0),
(330, 26, '广元', NULL, 2, 0),
(331, 26, '乐山', NULL, 2, 0),
(332, 26, '凉山', NULL, 2, 0),
(333, 26, '眉山', NULL, 2, 0),
(334, 26, '南充', NULL, 2, 0),
(335, 26, '内江', NULL, 2, 0),
(336, 26, '攀枝花', NULL, 2, 0),
(337, 26, '遂宁', NULL, 2, 0),
(338, 26, '雅安', NULL, 2, 0),
(339, 26, '宜宾', NULL, 2, 0),
(340, 26, '资阳', NULL, 2, 0),
(341, 26, '自贡', NULL, 2, 0),
(342, 26, '泸州', NULL, 2, 0),
(343, 27, '天津', NULL, 2, 0),
(344, 28, '拉萨', NULL, 2, 0),
(345, 28, '阿里', NULL, 2, 0),
(346, 28, '昌都', NULL, 2, 0),
(347, 28, '林芝', NULL, 2, 0),
(348, 28, '那曲', NULL, 2, 0),
(349, 28, '日喀则', NULL, 2, 0),
(350, 28, '山南', NULL, 2, 0),
(351, 29, '乌鲁木齐', NULL, 2, 0),
(352, 29, '阿克苏', NULL, 2, 0),
(353, 29, '阿拉尔', NULL, 2, 0),
(354, 29, '巴音郭楞', NULL, 2, 0),
(355, 29, '博尔塔拉', NULL, 2, 0),
(356, 29, '昌吉', NULL, 2, 0),
(357, 29, '哈密', NULL, 2, 0),
(358, 29, '和田', NULL, 2, 0),
(359, 29, '喀什', NULL, 2, 0),
(360, 29, '克拉玛依', NULL, 2, 0),
(361, 29, '克孜勒苏', NULL, 2, 0),
(362, 29, '石河子', NULL, 2, 0),
(363, 29, '图木舒克', NULL, 2, 0),
(364, 29, '吐鲁番', NULL, 2, 0),
(365, 29, '五家渠', NULL, 2, 0),
(366, 29, '伊犁', NULL, 2, 0),
(367, 30, '昆明', NULL, 2, 0),
(368, 30, '怒江', NULL, 2, 0),
(369, 30, '普洱', NULL, 2, 0),
(370, 30, '丽江', NULL, 2, 0),
(371, 30, '保山', NULL, 2, 0),
(372, 30, '楚雄', NULL, 2, 0),
(373, 30, '大理', NULL, 2, 0),
(374, 30, '德宏', NULL, 2, 0),
(375, 30, '迪庆', NULL, 2, 0),
(376, 30, '红河', NULL, 2, 0),
(377, 30, '临沧', NULL, 2, 0),
(378, 30, '曲靖', NULL, 2, 0),
(379, 30, '文山', NULL, 2, 0),
(380, 30, '西双版纳', NULL, 2, 0),
(381, 30, '玉溪', NULL, 2, 0),
(382, 30, '昭通', NULL, 2, 0),
(383, 31, '杭州', NULL, 2, 0),
(384, 31, '湖州', NULL, 2, 0),
(385, 31, '嘉兴', NULL, 2, 0),
(386, 31, '金华', NULL, 2, 0),
(387, 31, '丽水', NULL, 2, 0),
(388, 31, '宁波', NULL, 2, 0),
(389, 31, '绍兴', NULL, 2, 0),
(390, 31, '台州', NULL, 2, 0),
(391, 31, '温州', NULL, 2, 0),
(392, 31, '舟山', NULL, 2, 0),
(393, 31, '衢州', NULL, 2, 0),
(394, 32, '重庆', NULL, 2, 0),
(395, 33, '香港', NULL, 2, 0),
(396, 34, '澳门', NULL, 2, 0),
(397, 35, '台湾', NULL, 2, 0),
(398, 36, '迎江区', NULL, 3, 0),
(399, 36, '大观区', NULL, 3, 0),
(400, 36, '宜秀区', NULL, 3, 0),
(401, 36, '桐城市', NULL, 3, 0),
(402, 36, '怀宁县', NULL, 3, 0),
(403, 36, '枞阳县', NULL, 3, 0),
(404, 36, '潜山县', NULL, 3, 0),
(405, 36, '太湖县', NULL, 3, 0),
(406, 36, '宿松县', NULL, 3, 0),
(407, 36, '望江县', NULL, 3, 0),
(408, 36, '岳西县', NULL, 3, 0),
(409, 37, '中市区', NULL, 3, 0),
(410, 37, '东市区', NULL, 3, 0),
(411, 37, '西市区', NULL, 3, 0),
(412, 37, '郊区', NULL, 3, 0),
(413, 37, '怀远县', NULL, 3, 0),
(414, 37, '五河县', NULL, 3, 0),
(415, 37, '固镇县', NULL, 3, 0),
(416, 38, '居巢区', NULL, 3, 0),
(417, 38, '庐江县', NULL, 3, 0),
(418, 38, '无为县', NULL, 3, 0),
(419, 38, '含山县', NULL, 3, 0),
(420, 38, '和县', NULL, 3, 0),
(421, 39, '贵池区', NULL, 3, 0),
(422, 39, '东至县', NULL, 3, 0),
(423, 39, '石台县', NULL, 3, 0),
(424, 39, '青阳县', NULL, 3, 0),
(425, 40, '琅琊区', NULL, 3, 0),
(426, 40, '南谯区', NULL, 3, 0),
(427, 40, '天长市', NULL, 3, 0),
(428, 40, '明光市', NULL, 3, 0),
(429, 40, '来安县', NULL, 3, 0),
(430, 40, '全椒县', NULL, 3, 0),
(431, 40, '定远县', NULL, 3, 0),
(432, 40, '凤阳县', NULL, 3, 0),
(433, 41, '蚌山区', NULL, 3, 0),
(434, 41, '龙子湖区', NULL, 3, 0),
(435, 41, '禹会区', NULL, 3, 0),
(436, 41, '淮上区', NULL, 3, 0),
(437, 41, '颍州区', NULL, 3, 0),
(438, 41, '颍东区', NULL, 3, 0),
(439, 41, '颍泉区', NULL, 3, 0),
(440, 41, '界首市', NULL, 3, 0),
(441, 41, '临泉县', NULL, 3, 0),
(442, 41, '太和县', NULL, 3, 0),
(443, 41, '阜南县', NULL, 3, 0),
(444, 41, '颖上县', NULL, 3, 0),
(445, 42, '相山区', NULL, 3, 0),
(446, 42, '杜集区', NULL, 3, 0),
(447, 42, '烈山区', NULL, 3, 0),
(448, 42, '濉溪县', NULL, 3, 0),
(449, 43, '田家庵区', NULL, 3, 0),
(450, 43, '大通区', NULL, 3, 0),
(451, 43, '谢家集区', NULL, 3, 0),
(452, 43, '八公山区', NULL, 3, 0),
(453, 43, '潘集区', NULL, 3, 0),
(454, 43, '凤台县', NULL, 3, 0),
(455, 44, '屯溪区', NULL, 3, 0),
(456, 44, '黄山区', NULL, 3, 0),
(457, 44, '徽州区', NULL, 3, 0),
(458, 44, '歙县', NULL, 3, 0),
(459, 44, '休宁县', NULL, 3, 0),
(460, 44, '黟县', NULL, 3, 0),
(461, 44, '祁门县', NULL, 3, 0),
(462, 45, '金安区', NULL, 3, 0),
(463, 45, '裕安区', NULL, 3, 0),
(464, 45, '寿县', NULL, 3, 0),
(465, 45, '霍邱县', NULL, 3, 0),
(466, 45, '舒城县', NULL, 3, 0),
(467, 45, '金寨县', NULL, 3, 0),
(468, 45, '霍山县', NULL, 3, 0),
(469, 46, '雨山区', NULL, 3, 0),
(470, 46, '花山区', NULL, 3, 0),
(471, 46, '金家庄区', NULL, 3, 0),
(472, 46, '当涂县', NULL, 3, 0),
(473, 47, '埇桥区', NULL, 3, 0),
(474, 47, '砀山县', NULL, 3, 0),
(475, 47, '萧县', NULL, 3, 0),
(476, 47, '灵璧县', NULL, 3, 0),
(477, 47, '泗县', NULL, 3, 0),
(478, 48, '铜官山区', NULL, 3, 0),
(479, 48, '狮子山区', NULL, 3, 0),
(480, 48, '郊区', NULL, 3, 0),
(481, 48, '铜陵县', NULL, 3, 0),
(482, 49, '镜湖区', NULL, 3, 0),
(483, 49, '弋江区', NULL, 3, 0),
(484, 49, '鸠江区', NULL, 3, 0),
(485, 49, '三山区', NULL, 3, 0),
(486, 49, '芜湖县', NULL, 3, 0),
(487, 49, '繁昌县', NULL, 3, 0),
(488, 49, '南陵县', NULL, 3, 0),
(489, 50, '宣州区', NULL, 3, 0),
(490, 50, '宁国市', NULL, 3, 0),
(491, 50, '郎溪县', NULL, 3, 0),
(492, 50, '广德县', NULL, 3, 0),
(493, 50, '泾县', NULL, 3, 0),
(494, 50, '绩溪县', NULL, 3, 0),
(495, 50, '旌德县', NULL, 3, 0),
(496, 51, '涡阳县', NULL, 3, 0),
(497, 51, '蒙城县', NULL, 3, 0),
(498, 51, '利辛县', NULL, 3, 0),
(499, 51, '谯城区', NULL, 3, 0),
(500, 52, '东城区', NULL, 3, 0),
(501, 52, '西城区', NULL, 3, 0),
(502, 52, '海淀区', NULL, 3, 0),
(503, 52, '朝阳区', NULL, 3, 0),
(504, 52, '崇文区', NULL, 3, 0),
(505, 52, '宣武区', NULL, 3, 0),
(506, 52, '丰台区', NULL, 3, 0),
(507, 52, '石景山区', NULL, 3, 0),
(508, 52, '房山区', NULL, 3, 0),
(509, 52, '门头沟区', NULL, 3, 0),
(510, 52, '通州区', NULL, 3, 0),
(511, 52, '顺义区', NULL, 3, 0),
(512, 52, '昌平区', NULL, 3, 0),
(513, 52, '怀柔区', NULL, 3, 0),
(514, 52, '平谷区', NULL, 3, 0),
(515, 52, '大兴区', NULL, 3, 0),
(516, 52, '密云县', NULL, 3, 0),
(517, 52, '延庆县', NULL, 3, 0),
(518, 53, '鼓楼区', NULL, 3, 0),
(519, 53, '台江区', NULL, 3, 0),
(520, 53, '仓山区', NULL, 3, 0),
(521, 53, '马尾区', NULL, 3, 0),
(522, 53, '晋安区', NULL, 3, 0),
(523, 53, '福清市', NULL, 3, 0),
(524, 53, '长乐市', NULL, 3, 0),
(525, 53, '闽侯县', NULL, 3, 0),
(526, 53, '连江县', NULL, 3, 0),
(527, 53, '罗源县', NULL, 3, 0),
(528, 53, '闽清县', NULL, 3, 0),
(529, 53, '永泰县', NULL, 3, 0),
(530, 53, '平潭县', NULL, 3, 0),
(531, 54, '新罗区', NULL, 3, 0),
(532, 54, '漳平市', NULL, 3, 0),
(533, 54, '长汀县', NULL, 3, 0),
(534, 54, '永定县', NULL, 3, 0),
(535, 54, '上杭县', NULL, 3, 0),
(536, 54, '武平县', NULL, 3, 0),
(537, 54, '连城县', NULL, 3, 0),
(538, 55, '延平区', NULL, 3, 0),
(539, 55, '邵武市', NULL, 3, 0),
(540, 55, '武夷山市', NULL, 3, 0),
(541, 55, '建瓯市', NULL, 3, 0),
(542, 55, '建阳市', NULL, 3, 0),
(543, 55, '顺昌县', NULL, 3, 0),
(544, 55, '浦城县', NULL, 3, 0),
(545, 55, '光泽县', NULL, 3, 0),
(546, 55, '松溪县', NULL, 3, 0),
(547, 55, '政和县', NULL, 3, 0),
(548, 56, '蕉城区', NULL, 3, 0),
(549, 56, '福安市', NULL, 3, 0),
(550, 56, '福鼎市', NULL, 3, 0),
(551, 56, '霞浦县', NULL, 3, 0),
(552, 56, '古田县', NULL, 3, 0),
(553, 56, '屏南县', NULL, 3, 0),
(554, 56, '寿宁县', NULL, 3, 0),
(555, 56, '周宁县', NULL, 3, 0),
(556, 56, '柘荣县', NULL, 3, 0),
(557, 57, '城厢区', NULL, 3, 0),
(558, 57, '涵江区', NULL, 3, 0),
(559, 57, '荔城区', NULL, 3, 0),
(560, 57, '秀屿区', NULL, 3, 0),
(561, 57, '仙游县', NULL, 3, 0),
(562, 58, '鲤城区', NULL, 3, 0),
(563, 58, '丰泽区', NULL, 3, 0),
(564, 58, '洛江区', NULL, 3, 0),
(565, 58, '清濛开发区', NULL, 3, 0),
(566, 58, '泉港区', NULL, 3, 0),
(567, 58, '石狮市', NULL, 3, 0),
(568, 58, '晋江市', NULL, 3, 0),
(569, 58, '南安市', NULL, 3, 0),
(570, 58, '惠安县', NULL, 3, 0),
(571, 58, '安溪县', NULL, 3, 0),
(572, 58, '永春县', NULL, 3, 0),
(573, 58, '德化县', NULL, 3, 0),
(574, 58, '金门县', NULL, 3, 0),
(575, 59, '梅列区', NULL, 3, 0),
(576, 59, '三元区', NULL, 3, 0),
(577, 59, '永安市', NULL, 3, 0),
(578, 59, '明溪县', NULL, 3, 0),
(579, 59, '清流县', NULL, 3, 0),
(580, 59, '宁化县', NULL, 3, 0),
(581, 59, '大田县', NULL, 3, 0),
(582, 59, '尤溪县', NULL, 3, 0),
(583, 59, '沙县', NULL, 3, 0),
(584, 59, '将乐县', NULL, 3, 0),
(585, 59, '泰宁县', NULL, 3, 0),
(586, 59, '建宁县', NULL, 3, 0),
(587, 60, '思明区', NULL, 3, 0),
(588, 60, '海沧区', NULL, 3, 0),
(589, 60, '湖里区', NULL, 3, 0),
(590, 60, '集美区', NULL, 3, 0),
(591, 60, '同安区', NULL, 3, 0),
(592, 60, '翔安区', NULL, 3, 0),
(593, 61, '芗城区', NULL, 3, 0),
(594, 61, '龙文区', NULL, 3, 0),
(595, 61, '龙海市', NULL, 3, 0),
(596, 61, '云霄县', NULL, 3, 0),
(597, 61, '漳浦县', NULL, 3, 0),
(598, 61, '诏安县', NULL, 3, 0),
(599, 61, '长泰县', NULL, 3, 0),
(600, 61, '东山县', NULL, 3, 0),
(601, 61, '南靖县', NULL, 3, 0),
(602, 61, '平和县', NULL, 3, 0),
(603, 61, '华安县', NULL, 3, 0),
(604, 62, '皋兰县', NULL, 3, 0),
(605, 62, '城关区', NULL, 3, 0),
(606, 62, '七里河区', NULL, 3, 0),
(607, 62, '西固区', NULL, 3, 0),
(608, 62, '安宁区', NULL, 3, 0),
(609, 62, '红古区', NULL, 3, 0),
(610, 62, '永登县', NULL, 3, 0),
(611, 62, '榆中县', NULL, 3, 0),
(612, 63, '白银区', NULL, 3, 0),
(613, 63, '平川区', NULL, 3, 0),
(614, 63, '会宁县', NULL, 3, 0),
(615, 63, '景泰县', NULL, 3, 0),
(616, 63, '靖远县', NULL, 3, 0),
(617, 64, '临洮县', NULL, 3, 0),
(618, 64, '陇西县', NULL, 3, 0),
(619, 64, '通渭县', NULL, 3, 0),
(620, 64, '渭源县', NULL, 3, 0),
(621, 64, '漳县', NULL, 3, 0),
(622, 64, '岷县', NULL, 3, 0),
(623, 64, '安定区', NULL, 3, 0),
(624, 64, '安定区', NULL, 3, 0),
(625, 65, '合作市', NULL, 3, 0),
(626, 65, '临潭县', NULL, 3, 0),
(627, 65, '卓尼县', NULL, 3, 0),
(628, 65, '舟曲县', NULL, 3, 0),
(629, 65, '迭部县', NULL, 3, 0),
(630, 65, '玛曲县', NULL, 3, 0),
(631, 65, '碌曲县', NULL, 3, 0),
(632, 65, '夏河县', NULL, 3, 0),
(633, 66, '嘉峪关市', NULL, 3, 0),
(634, 67, '金川区', NULL, 3, 0),
(635, 67, '永昌县', NULL, 3, 0),
(636, 68, '肃州区', NULL, 3, 0),
(637, 68, '玉门市', NULL, 3, 0),
(638, 68, '敦煌市', NULL, 3, 0),
(639, 68, '金塔县', NULL, 3, 0),
(640, 68, '瓜州县', NULL, 3, 0),
(641, 68, '肃北', NULL, 3, 0),
(642, 68, '阿克塞', NULL, 3, 0),
(643, 69, '临夏市', NULL, 3, 0),
(644, 69, '临夏县', NULL, 3, 0),
(645, 69, '康乐县', NULL, 3, 0),
(646, 69, '永靖县', NULL, 3, 0),
(647, 69, '广河县', NULL, 3, 0),
(648, 69, '和政县', NULL, 3, 0),
(649, 69, '东乡族自治县', NULL, 3, 0),
(650, 69, '积石山', NULL, 3, 0),
(651, 70, '成县', NULL, 3, 0),
(652, 70, '徽县', NULL, 3, 0),
(653, 70, '康县', NULL, 3, 0),
(654, 70, '礼县', NULL, 3, 0),
(655, 70, '两当县', NULL, 3, 0),
(656, 70, '文县', NULL, 3, 0),
(657, 70, '西和县', NULL, 3, 0),
(658, 70, '宕昌县', NULL, 3, 0),
(659, 70, '武都区', NULL, 3, 0),
(660, 71, '崇信县', NULL, 3, 0),
(661, 71, '华亭县', NULL, 3, 0),
(662, 71, '静宁县', NULL, 3, 0),
(663, 71, '灵台县', NULL, 3, 0),
(664, 71, '崆峒区', NULL, 3, 0),
(665, 71, '庄浪县', NULL, 3, 0),
(666, 71, '泾川县', NULL, 3, 0),
(667, 72, '合水县', NULL, 3, 0),
(668, 72, '华池县', NULL, 3, 0),
(669, 72, '环县', NULL, 3, 0),
(670, 72, '宁县', NULL, 3, 0),
(671, 72, '庆城县', NULL, 3, 0),
(672, 72, '西峰区', NULL, 3, 0),
(673, 72, '镇原县', NULL, 3, 0),
(674, 72, '正宁县', NULL, 3, 0),
(675, 73, '甘谷县', NULL, 3, 0),
(676, 73, '秦安县', NULL, 3, 0),
(677, 73, '清水县', NULL, 3, 0),
(678, 73, '秦州区', NULL, 3, 0),
(679, 73, '麦积区', NULL, 3, 0),
(680, 73, '武山县', NULL, 3, 0),
(681, 73, '张家川', NULL, 3, 0),
(682, 74, '古浪县', NULL, 3, 0),
(683, 74, '民勤县', NULL, 3, 0),
(684, 74, '天祝', NULL, 3, 0),
(685, 74, '凉州区', NULL, 3, 0),
(686, 75, '高台县', NULL, 3, 0),
(687, 75, '临泽县', NULL, 3, 0),
(688, 75, '民乐县', NULL, 3, 0),
(689, 75, '山丹县', NULL, 3, 0),
(690, 75, '肃南', NULL, 3, 0),
(691, 75, '甘州区', NULL, 3, 0),
(692, 76, '从化市', NULL, 3, 0),
(693, 76, '天河区', NULL, 3, 0),
(694, 76, '东山区', NULL, 3, 0),
(695, 76, '白云区', NULL, 3, 0),
(696, 76, '海珠区', NULL, 3, 0),
(697, 76, '荔湾区', NULL, 3, 0),
(698, 76, '越秀区', NULL, 3, 0),
(699, 76, '黄埔区', NULL, 3, 0),
(700, 76, '番禺区', NULL, 3, 0),
(701, 76, '花都区', NULL, 3, 0),
(702, 76, '增城区', NULL, 3, 0),
(703, 76, '从化区', NULL, 3, 0),
(704, 76, '市郊', NULL, 3, 0),
(705, 77, '福田区', NULL, 3, 0),
(706, 77, '罗湖区', NULL, 3, 0),
(707, 77, '南山区', NULL, 3, 0),
(708, 77, '宝安区', NULL, 3, 0),
(709, 77, '龙岗区', NULL, 3, 0),
(710, 77, '盐田区', NULL, 3, 0),
(711, 78, '湘桥区', NULL, 3, 0),
(712, 78, '潮安县', NULL, 3, 0),
(713, 78, '饶平县', NULL, 3, 0),
(714, 79, '南城区', NULL, 3, 0),
(715, 79, '东城区', NULL, 3, 0),
(716, 79, '万江区', NULL, 3, 0),
(717, 79, '莞城区', NULL, 3, 0),
(718, 79, '石龙镇', NULL, 3, 0),
(719, 79, '虎门镇', NULL, 3, 0),
(720, 79, '麻涌镇', NULL, 3, 0),
(721, 79, '道滘镇', NULL, 3, 0),
(722, 79, '石碣镇', NULL, 3, 0),
(723, 79, '沙田镇', NULL, 3, 0),
(724, 79, '望牛墩镇', NULL, 3, 0),
(725, 79, '洪梅镇', NULL, 3, 0),
(726, 79, '茶山镇', NULL, 3, 0),
(727, 79, '寮步镇', NULL, 3, 0),
(728, 79, '大岭山镇', NULL, 3, 0),
(729, 79, '大朗镇', NULL, 3, 0),
(730, 79, '黄江镇', NULL, 3, 0),
(731, 79, '樟木头', NULL, 3, 0),
(732, 79, '凤岗镇', NULL, 3, 0),
(733, 79, '塘厦镇', NULL, 3, 0),
(734, 79, '谢岗镇', NULL, 3, 0),
(735, 79, '厚街镇', NULL, 3, 0),
(736, 79, '清溪镇', NULL, 3, 0),
(737, 79, '常平镇', NULL, 3, 0),
(738, 79, '桥头镇', NULL, 3, 0),
(739, 79, '横沥镇', NULL, 3, 0),
(740, 79, '东坑镇', NULL, 3, 0),
(741, 79, '企石镇', NULL, 3, 0),
(742, 79, '石排镇', NULL, 3, 0),
(743, 79, '长安镇', NULL, 3, 0),
(744, 79, '中堂镇', NULL, 3, 0),
(745, 79, '高埗镇', NULL, 3, 0),
(746, 80, '禅城区', NULL, 3, 0),
(747, 80, '南海区', NULL, 3, 0),
(748, 80, '顺德区', NULL, 3, 0),
(749, 80, '三水区', NULL, 3, 0),
(750, 80, '高明区', NULL, 3, 0),
(751, 81, '东源县', NULL, 3, 0),
(752, 81, '和平县', NULL, 3, 0),
(753, 81, '源城区', NULL, 3, 0),
(754, 81, '连平县', NULL, 3, 0),
(755, 81, '龙川县', NULL, 3, 0),
(756, 81, '紫金县', NULL, 3, 0),
(757, 82, '惠阳区', NULL, 3, 0),
(758, 82, '惠城区', NULL, 3, 0),
(759, 82, '大亚湾', NULL, 3, 0),
(760, 82, '博罗县', NULL, 3, 0),
(761, 82, '惠东县', NULL, 3, 0),
(762, 82, '龙门县', NULL, 3, 0),
(763, 83, '江海区', NULL, 3, 0),
(764, 83, '蓬江区', NULL, 3, 0),
(765, 83, '新会区', NULL, 3, 0),
(766, 83, '台山市', NULL, 3, 0),
(767, 83, '开平市', NULL, 3, 0),
(768, 83, '鹤山市', NULL, 3, 0),
(769, 83, '恩平市', NULL, 3, 0),
(770, 84, '榕城区', NULL, 3, 0),
(771, 84, '普宁市', NULL, 3, 0),
(772, 84, '揭东县', NULL, 3, 0),
(773, 84, '揭西县', NULL, 3, 0),
(774, 84, '惠来县', NULL, 3, 0),
(775, 85, '茂南区', NULL, 3, 0),
(776, 85, '茂港区', NULL, 3, 0),
(777, 85, '高州市', NULL, 3, 0),
(778, 85, '化州市', NULL, 3, 0),
(779, 85, '信宜市', NULL, 3, 0),
(780, 85, '电白县', NULL, 3, 0),
(781, 86, '梅县', NULL, 3, 0),
(782, 86, '梅江区', NULL, 3, 0),
(783, 86, '兴宁市', NULL, 3, 0),
(784, 86, '大埔县', NULL, 3, 0),
(785, 86, '丰顺县', NULL, 3, 0),
(786, 86, '五华县', NULL, 3, 0),
(787, 86, '平远县', NULL, 3, 0),
(788, 86, '蕉岭县', NULL, 3, 0),
(789, 87, '清城区', NULL, 3, 0),
(790, 87, '英德市', NULL, 3, 0),
(791, 87, '连州市', NULL, 3, 0),
(792, 87, '佛冈县', NULL, 3, 0),
(793, 87, '阳山县', NULL, 3, 0),
(794, 87, '清新县', NULL, 3, 0),
(795, 87, '连山', NULL, 3, 0),
(796, 87, '连南', NULL, 3, 0),
(797, 88, '南澳县', NULL, 3, 0),
(798, 88, '潮阳区', NULL, 3, 0),
(799, 88, '澄海区', NULL, 3, 0),
(800, 88, '龙湖区', NULL, 3, 0),
(801, 88, '金平区', NULL, 3, 0),
(802, 88, '濠江区', NULL, 3, 0),
(803, 88, '潮南区', NULL, 3, 0),
(804, 89, '城区', NULL, 3, 0),
(805, 89, '陆丰市', NULL, 3, 0),
(806, 89, '海丰县', NULL, 3, 0),
(807, 89, '陆河县', NULL, 3, 0),
(808, 90, '曲江县', NULL, 3, 0),
(809, 90, '浈江区', NULL, 3, 0),
(810, 90, '武江区', NULL, 3, 0),
(811, 90, '曲江区', NULL, 3, 0),
(812, 90, '乐昌市', NULL, 3, 0),
(813, 90, '南雄市', NULL, 3, 0),
(814, 90, '始兴县', NULL, 3, 0),
(815, 90, '仁化县', NULL, 3, 0),
(816, 90, '翁源县', NULL, 3, 0),
(817, 90, '新丰县', NULL, 3, 0),
(818, 90, '乳源', NULL, 3, 0),
(819, 91, '江城区', NULL, 3, 0),
(820, 91, '阳春市', NULL, 3, 0),
(821, 91, '阳西县', NULL, 3, 0),
(822, 91, '阳东县', NULL, 3, 0),
(823, 92, '云城区', NULL, 3, 0),
(824, 92, '罗定市', NULL, 3, 0),
(825, 92, '新兴县', NULL, 3, 0),
(826, 92, '郁南县', NULL, 3, 0),
(827, 92, '云安县', NULL, 3, 0),
(828, 93, '赤坎区', NULL, 3, 0),
(829, 93, '霞山区', NULL, 3, 0),
(830, 93, '坡头区', NULL, 3, 0),
(831, 93, '麻章区', NULL, 3, 0),
(832, 93, '廉江市', NULL, 3, 0),
(833, 93, '雷州市', NULL, 3, 0),
(834, 93, '吴川市', NULL, 3, 0),
(835, 93, '遂溪县', NULL, 3, 0),
(836, 93, '徐闻县', NULL, 3, 0),
(837, 94, '肇庆市', NULL, 3, 0),
(838, 94, '高要市', NULL, 3, 0),
(839, 94, '四会市', NULL, 3, 0),
(840, 94, '广宁县', NULL, 3, 0),
(841, 94, '怀集县', NULL, 3, 0),
(842, 94, '封开县', NULL, 3, 0),
(843, 94, '德庆县', NULL, 3, 0),
(844, 95, '石岐街道', NULL, 3, 0),
(845, 95, '东区街道', NULL, 3, 0),
(846, 95, '西区街道', NULL, 3, 0),
(847, 95, '环城街道', NULL, 3, 0),
(848, 95, '中山港街道', NULL, 3, 0),
(849, 95, '五桂山街道', NULL, 3, 0),
(850, 96, '香洲区', NULL, 3, 0),
(851, 96, '斗门区', NULL, 3, 0),
(852, 96, '金湾区', NULL, 3, 0),
(853, 97, '邕宁区', NULL, 3, 0),
(854, 97, '青秀区', NULL, 3, 0),
(855, 97, '兴宁区', NULL, 3, 0),
(856, 97, '良庆区', NULL, 3, 0),
(857, 97, '西乡塘区', NULL, 3, 0),
(858, 97, '江南区', NULL, 3, 0),
(859, 97, '武鸣县', NULL, 3, 0),
(860, 97, '隆安县', NULL, 3, 0),
(861, 97, '马山县', NULL, 3, 0),
(862, 97, '上林县', NULL, 3, 0),
(863, 97, '宾阳县', NULL, 3, 0),
(864, 97, '横县', NULL, 3, 0),
(865, 98, '秀峰区', NULL, 3, 0),
(866, 98, '叠彩区', NULL, 3, 0),
(867, 98, '象山区', NULL, 3, 0),
(868, 98, '七星区', NULL, 3, 0),
(869, 98, '雁山区', NULL, 3, 0),
(870, 98, '阳朔县', NULL, 3, 0),
(871, 98, '临桂县', NULL, 3, 0),
(872, 98, '灵川县', NULL, 3, 0),
(873, 98, '全州县', NULL, 3, 0),
(874, 98, '平乐县', NULL, 3, 0),
(875, 98, '兴安县', NULL, 3, 0),
(876, 98, '灌阳县', NULL, 3, 0),
(877, 98, '荔浦县', NULL, 3, 0),
(878, 98, '资源县', NULL, 3, 0),
(879, 98, '永福县', NULL, 3, 0),
(880, 98, '龙胜', NULL, 3, 0),
(881, 98, '恭城', NULL, 3, 0),
(882, 99, '右江区', NULL, 3, 0),
(883, 99, '凌云县', NULL, 3, 0),
(884, 99, '平果县', NULL, 3, 0),
(885, 99, '西林县', NULL, 3, 0),
(886, 99, '乐业县', NULL, 3, 0),
(887, 99, '德保县', NULL, 3, 0),
(888, 99, '田林县', NULL, 3, 0),
(889, 99, '田阳县', NULL, 3, 0),
(890, 99, '靖西县', NULL, 3, 0),
(891, 99, '田东县', NULL, 3, 0),
(892, 99, '那坡县', NULL, 3, 0),
(893, 99, '隆林', NULL, 3, 0),
(894, 100, '海城区', NULL, 3, 0),
(895, 100, '银海区', NULL, 3, 0),
(896, 100, '铁山港区', NULL, 3, 0),
(897, 100, '合浦县', NULL, 3, 0),
(898, 101, '江州区', NULL, 3, 0),
(899, 101, '凭祥市', NULL, 3, 0),
(900, 101, '宁明县', NULL, 3, 0),
(901, 101, '扶绥县', NULL, 3, 0),
(902, 101, '龙州县', NULL, 3, 0),
(903, 101, '大新县', NULL, 3, 0),
(904, 101, '天等县', NULL, 3, 0),
(905, 102, '港口区', NULL, 3, 0),
(906, 102, '防城区', NULL, 3, 0),
(907, 102, '东兴市', NULL, 3, 0),
(908, 102, '上思县', NULL, 3, 0),
(909, 103, '港北区', NULL, 3, 0),
(910, 103, '港南区', NULL, 3, 0),
(911, 103, '覃塘区', NULL, 3, 0),
(912, 103, '桂平市', NULL, 3, 0),
(913, 103, '平南县', NULL, 3, 0),
(914, 104, '金城江区', NULL, 3, 0),
(915, 104, '宜州市', NULL, 3, 0),
(916, 104, '天峨县', NULL, 3, 0),
(917, 104, '凤山县', NULL, 3, 0),
(918, 104, '南丹县', NULL, 3, 0),
(919, 104, '东兰县', NULL, 3, 0),
(920, 104, '都安', NULL, 3, 0),
(921, 104, '罗城', NULL, 3, 0),
(922, 104, '巴马', NULL, 3, 0),
(923, 104, '环江', NULL, 3, 0),
(924, 104, '大化', NULL, 3, 0),
(925, 105, '八步区', NULL, 3, 0),
(926, 105, '钟山县', NULL, 3, 0),
(927, 105, '昭平县', NULL, 3, 0),
(928, 105, '富川', NULL, 3, 0),
(929, 106, '兴宾区', NULL, 3, 0),
(930, 106, '合山市', NULL, 3, 0),
(931, 106, '象州县', NULL, 3, 0),
(932, 106, '武宣县', NULL, 3, 0),
(933, 106, '忻城县', NULL, 3, 0),
(934, 106, '金秀', NULL, 3, 0),
(935, 107, '城中区', NULL, 3, 0),
(936, 107, '鱼峰区', NULL, 3, 0),
(937, 107, '柳北区', NULL, 3, 0),
(938, 107, '柳南区', NULL, 3, 0),
(939, 107, '柳江县', NULL, 3, 0),
(940, 107, '柳城县', NULL, 3, 0),
(941, 107, '鹿寨县', NULL, 3, 0),
(942, 107, '融安县', NULL, 3, 0),
(943, 107, '融水', NULL, 3, 0),
(944, 107, '三江', NULL, 3, 0),
(945, 108, '钦南区', NULL, 3, 0),
(946, 108, '钦北区', NULL, 3, 0),
(947, 108, '灵山县', NULL, 3, 0),
(948, 108, '浦北县', NULL, 3, 0),
(949, 109, '万秀区', NULL, 3, 0),
(950, 109, '蝶山区', NULL, 3, 0),
(951, 109, '长洲区', NULL, 3, 0),
(952, 109, '岑溪市', NULL, 3, 0),
(953, 109, '苍梧县', NULL, 3, 0),
(954, 109, '藤县', NULL, 3, 0),
(955, 109, '蒙山县', NULL, 3, 0),
(956, 110, '玉州区', NULL, 3, 0),
(957, 110, '北流市', NULL, 3, 0),
(958, 110, '容县', NULL, 3, 0),
(959, 110, '陆川县', NULL, 3, 0),
(960, 110, '博白县', NULL, 3, 0),
(961, 110, '兴业县', NULL, 3, 0),
(962, 111, '南明区', NULL, 3, 0),
(963, 111, '云岩区', NULL, 3, 0),
(964, 111, '花溪区', NULL, 3, 0),
(965, 111, '乌当区', NULL, 3, 0),
(966, 111, '白云区', NULL, 3, 0),
(967, 111, '小河区', NULL, 3, 0),
(968, 111, '金阳新区', NULL, 3, 0),
(969, 111, '新天园区', NULL, 3, 0),
(970, 111, '清镇市', NULL, 3, 0),
(971, 111, '开阳县', NULL, 3, 0),
(972, 111, '修文县', NULL, 3, 0),
(973, 111, '息烽县', NULL, 3, 0),
(974, 112, '西秀区', NULL, 3, 0),
(975, 112, '关岭', NULL, 3, 0),
(976, 112, '镇宁', NULL, 3, 0),
(977, 112, '紫云', NULL, 3, 0),
(978, 112, '平坝县', NULL, 3, 0),
(979, 112, '普定县', NULL, 3, 0),
(980, 113, '毕节市', NULL, 3, 0),
(981, 113, '大方县', NULL, 3, 0),
(982, 113, '黔西县', NULL, 3, 0),
(983, 113, '金沙县', NULL, 3, 0),
(984, 113, '织金县', NULL, 3, 0),
(985, 113, '纳雍县', NULL, 3, 0),
(986, 113, '赫章县', NULL, 3, 0),
(987, 113, '威宁', NULL, 3, 0),
(988, 114, '钟山区', NULL, 3, 0),
(989, 114, '六枝特区', NULL, 3, 0),
(990, 114, '水城县', NULL, 3, 0),
(991, 114, '盘县', NULL, 3, 0),
(992, 115, '凯里市', NULL, 3, 0),
(993, 115, '黄平县', NULL, 3, 0),
(994, 115, '施秉县', NULL, 3, 0),
(995, 115, '三穗县', NULL, 3, 0),
(996, 115, '镇远县', NULL, 3, 0),
(997, 115, '岑巩县', NULL, 3, 0),
(998, 115, '天柱县', NULL, 3, 0),
(999, 115, '锦屏县', NULL, 3, 0),
(1000, 115, '剑河县', NULL, 3, 0),
(1001, 115, '台江县', NULL, 3, 0),
(1002, 115, '黎平县', NULL, 3, 0),
(1003, 115, '榕江县', NULL, 3, 0),
(1004, 115, '从江县', NULL, 3, 0),
(1005, 115, '雷山县', NULL, 3, 0),
(1006, 115, '麻江县', NULL, 3, 0),
(1007, 115, '丹寨县', NULL, 3, 0),
(1008, 116, '都匀市', NULL, 3, 0),
(1009, 116, '福泉市', NULL, 3, 0),
(1010, 116, '荔波县', NULL, 3, 0),
(1011, 116, '贵定县', NULL, 3, 0),
(1012, 116, '瓮安县', NULL, 3, 0),
(1013, 116, '独山县', NULL, 3, 0),
(1014, 116, '平塘县', NULL, 3, 0),
(1015, 116, '罗甸县', NULL, 3, 0),
(1016, 116, '长顺县', NULL, 3, 0),
(1017, 116, '龙里县', NULL, 3, 0),
(1018, 116, '惠水县', NULL, 3, 0),
(1019, 116, '三都', NULL, 3, 0),
(1020, 117, '兴义市', NULL, 3, 0),
(1021, 117, '兴仁县', NULL, 3, 0),
(1022, 117, '普安县', NULL, 3, 0),
(1023, 117, '晴隆县', NULL, 3, 0),
(1024, 117, '贞丰县', NULL, 3, 0),
(1025, 117, '望谟县', NULL, 3, 0),
(1026, 117, '册亨县', NULL, 3, 0),
(1027, 117, '安龙县', NULL, 3, 0),
(1028, 118, '铜仁市', NULL, 3, 0),
(1029, 118, '江口县', NULL, 3, 0),
(1030, 118, '石阡县', NULL, 3, 0),
(1031, 118, '思南县', NULL, 3, 0),
(1032, 118, '德江县', NULL, 3, 0),
(1033, 118, '玉屏', NULL, 3, 0),
(1034, 118, '印江', NULL, 3, 0),
(1035, 118, '沿河', NULL, 3, 0),
(1036, 118, '松桃', NULL, 3, 0),
(1037, 118, '万山特区', NULL, 3, 0),
(1038, 119, '红花岗区', NULL, 3, 0),
(1039, 119, '务川县', NULL, 3, 0),
(1040, 119, '道真县', NULL, 3, 0),
(1041, 119, '汇川区', NULL, 3, 0),
(1042, 119, '赤水市', NULL, 3, 0),
(1043, 119, '仁怀市', NULL, 3, 0),
(1044, 119, '遵义县', NULL, 3, 0),
(1045, 119, '桐梓县', NULL, 3, 0),
(1046, 119, '绥阳县', NULL, 3, 0),
(1047, 119, '正安县', NULL, 3, 0),
(1048, 119, '凤冈县', NULL, 3, 0),
(1049, 119, '湄潭县', NULL, 3, 0),
(1050, 119, '余庆县', NULL, 3, 0),
(1051, 119, '习水县', NULL, 3, 0),
(1052, 119, '道真', NULL, 3, 0),
(1053, 119, '务川', NULL, 3, 0),
(1054, 120, '秀英区', NULL, 3, 0),
(1055, 120, '龙华区', NULL, 3, 0),
(1056, 120, '琼山区', NULL, 3, 0),
(1057, 120, '美兰区', NULL, 3, 0),
(1058, 137, '市区', NULL, 3, 0),
(1059, 137, '洋浦开发区', NULL, 3, 0),
(1060, 137, '那大镇', NULL, 3, 0),
(1061, 137, '王五镇', NULL, 3, 0),
(1062, 137, '雅星镇', NULL, 3, 0),
(1063, 137, '大成镇', NULL, 3, 0),
(1064, 137, '中和镇', NULL, 3, 0),
(1065, 137, '峨蔓镇', NULL, 3, 0),
(1066, 137, '南丰镇', NULL, 3, 0),
(1067, 137, '白马井镇', NULL, 3, 0),
(1068, 137, '兰洋镇', NULL, 3, 0),
(1069, 137, '和庆镇', NULL, 3, 0),
(1070, 137, '海头镇', NULL, 3, 0),
(1071, 137, '排浦镇', NULL, 3, 0),
(1072, 137, '东成镇', NULL, 3, 0),
(1073, 137, '光村镇', NULL, 3, 0),
(1074, 137, '木棠镇', NULL, 3, 0),
(1075, 137, '新州镇', NULL, 3, 0),
(1076, 137, '三都镇', NULL, 3, 0),
(1077, 137, '其他', NULL, 3, 0),
(1078, 138, '长安区', NULL, 3, 0),
(1079, 138, '桥东区', NULL, 3, 0),
(1080, 138, '桥西区', NULL, 3, 0),
(1081, 138, '新华区', NULL, 3, 0),
(1082, 138, '裕华区', NULL, 3, 0),
(1083, 138, '井陉矿区', NULL, 3, 0),
(1084, 138, '高新区', NULL, 3, 0),
(1085, 138, '辛集市', NULL, 3, 0),
(1086, 138, '藁城市', NULL, 3, 0),
(1087, 138, '晋州市', NULL, 3, 0),
(1088, 138, '新乐市', NULL, 3, 0),
(1089, 138, '鹿泉市', NULL, 3, 0),
(1090, 138, '井陉县', NULL, 3, 0),
(1091, 138, '正定县', NULL, 3, 0),
(1092, 138, '栾城县', NULL, 3, 0),
(1093, 138, '行唐县', NULL, 3, 0),
(1094, 138, '灵寿县', NULL, 3, 0),
(1095, 138, '高邑县', NULL, 3, 0),
(1096, 138, '深泽县', NULL, 3, 0),
(1097, 138, '赞皇县', NULL, 3, 0),
(1098, 138, '无极县', NULL, 3, 0),
(1099, 138, '平山县', NULL, 3, 0),
(1100, 138, '元氏县', NULL, 3, 0),
(1101, 138, '赵县', NULL, 3, 0),
(1102, 139, '新市区', NULL, 3, 0),
(1103, 139, '南市区', NULL, 3, 0),
(1104, 139, '北市区', NULL, 3, 0),
(1105, 139, '涿州市', NULL, 3, 0),
(1106, 139, '定州市', NULL, 3, 0),
(1107, 139, '安国市', NULL, 3, 0),
(1108, 139, '高碑店市', NULL, 3, 0),
(1109, 139, '满城县', NULL, 3, 0),
(1110, 139, '清苑县', NULL, 3, 0),
(1111, 139, '涞水县', NULL, 3, 0),
(1112, 139, '阜平县', NULL, 3, 0),
(1113, 139, '徐水县', NULL, 3, 0),
(1114, 139, '定兴县', NULL, 3, 0),
(1115, 139, '唐县', NULL, 3, 0),
(1116, 139, '高阳县', NULL, 3, 0),
(1117, 139, '容城县', NULL, 3, 0),
(1118, 139, '涞源县', NULL, 3, 0),
(1119, 139, '望都县', NULL, 3, 0),
(1120, 139, '安新县', NULL, 3, 0),
(1121, 139, '易县', NULL, 3, 0),
(1122, 139, '曲阳县', NULL, 3, 0),
(1123, 139, '蠡县', NULL, 3, 0),
(1124, 139, '顺平县', NULL, 3, 0),
(1125, 139, '博野县', NULL, 3, 0),
(1126, 139, '雄县', NULL, 3, 0),
(1127, 140, '运河区', NULL, 3, 0),
(1128, 140, '新华区', NULL, 3, 0),
(1129, 140, '泊头市', NULL, 3, 0),
(1130, 140, '任丘市', NULL, 3, 0),
(1131, 140, '黄骅市', NULL, 3, 0),
(1132, 140, '河间市', NULL, 3, 0),
(1133, 140, '沧县', NULL, 3, 0),
(1134, 140, '青县', NULL, 3, 0),
(1135, 140, '东光县', NULL, 3, 0),
(1136, 140, '海兴县', NULL, 3, 0),
(1137, 140, '盐山县', NULL, 3, 0),
(1138, 140, '肃宁县', NULL, 3, 0),
(1139, 140, '南皮县', NULL, 3, 0),
(1140, 140, '吴桥县', NULL, 3, 0),
(1141, 140, '献县', NULL, 3, 0),
(1142, 140, '孟村', NULL, 3, 0),
(1143, 141, '双桥区', NULL, 3, 0),
(1144, 141, '双滦区', NULL, 3, 0),
(1145, 141, '鹰手营子矿区', NULL, 3, 0),
(1146, 141, '承德县', NULL, 3, 0),
(1147, 141, '兴隆县', NULL, 3, 0),
(1148, 141, '平泉县', NULL, 3, 0),
(1149, 141, '滦平县', NULL, 3, 0),
(1150, 141, '隆化县', NULL, 3, 0),
(1151, 141, '丰宁', NULL, 3, 0),
(1152, 141, '宽城', NULL, 3, 0),
(1153, 141, '围场', NULL, 3, 0),
(1154, 142, '从台区', NULL, 3, 0),
(1155, 142, '复兴区', NULL, 3, 0),
(1156, 142, '邯山区', NULL, 3, 0),
(1157, 142, '峰峰矿区', NULL, 3, 0),
(1158, 142, '武安市', NULL, 3, 0),
(1159, 142, '邯郸县', NULL, 3, 0),
(1160, 142, '临漳县', NULL, 3, 0),
(1161, 142, '成安县', NULL, 3, 0),
(1162, 142, '大名县', NULL, 3, 0),
(1163, 142, '涉县', NULL, 3, 0),
(1164, 142, '磁县', NULL, 3, 0),
(1165, 142, '肥乡县', NULL, 3, 0),
(1166, 142, '永年县', NULL, 3, 0),
(1167, 142, '邱县', NULL, 3, 0),
(1168, 142, '鸡泽县', NULL, 3, 0),
(1169, 142, '广平县', NULL, 3, 0),
(1170, 142, '馆陶县', NULL, 3, 0),
(1171, 142, '魏县', NULL, 3, 0),
(1172, 142, '曲周县', NULL, 3, 0),
(1173, 143, '桃城区', NULL, 3, 0),
(1174, 143, '冀州市', NULL, 3, 0),
(1175, 143, '深州市', NULL, 3, 0),
(1176, 143, '枣强县', NULL, 3, 0),
(1177, 143, '武邑县', NULL, 3, 0),
(1178, 143, '武强县', NULL, 3, 0),
(1179, 143, '饶阳县', NULL, 3, 0),
(1180, 143, '安平县', NULL, 3, 0),
(1181, 143, '故城县', NULL, 3, 0),
(1182, 143, '景县', NULL, 3, 0),
(1183, 143, '阜城县', NULL, 3, 0),
(1184, 144, '安次区', NULL, 3, 0),
(1185, 144, '广阳区', NULL, 3, 0),
(1186, 144, '霸州市', NULL, 3, 0),
(1187, 144, '三河市', NULL, 3, 0),
(1188, 144, '固安县', NULL, 3, 0),
(1189, 144, '永清县', NULL, 3, 0),
(1190, 144, '香河县', NULL, 3, 0),
(1191, 144, '大城县', NULL, 3, 0),
(1192, 144, '文安县', NULL, 3, 0),
(1193, 144, '大厂', NULL, 3, 0),
(1194, 145, '海港区', NULL, 3, 0),
(1195, 145, '山海关区', NULL, 3, 0),
(1196, 145, '北戴河区', NULL, 3, 0),
(1197, 145, '昌黎县', NULL, 3, 0),
(1198, 145, '抚宁县', NULL, 3, 0),
(1199, 145, '卢龙县', NULL, 3, 0),
(1200, 145, '青龙', NULL, 3, 0),
(1201, 146, '路北区', NULL, 3, 0),
(1202, 146, '路南区', NULL, 3, 0),
(1203, 146, '古冶区', NULL, 3, 0),
(1204, 146, '开平区', NULL, 3, 0),
(1205, 146, '丰南区', NULL, 3, 0),
(1206, 146, '丰润区', NULL, 3, 0),
(1207, 146, '遵化市', NULL, 3, 0),
(1208, 146, '迁安市', NULL, 3, 0),
(1209, 146, '滦县', NULL, 3, 0),
(1210, 146, '滦南县', NULL, 3, 0),
(1211, 146, '乐亭县', NULL, 3, 0),
(1212, 146, '迁西县', NULL, 3, 0),
(1213, 146, '玉田县', NULL, 3, 0),
(1214, 146, '唐海县', NULL, 3, 0),
(1215, 147, '桥东区', NULL, 3, 0),
(1216, 147, '桥西区', NULL, 3, 0),
(1217, 147, '南宫市', NULL, 3, 0),
(1218, 147, '沙河市', NULL, 3, 0),
(1219, 147, '邢台县', NULL, 3, 0),
(1220, 147, '临城县', NULL, 3, 0),
(1221, 147, '内丘县', NULL, 3, 0),
(1222, 147, '柏乡县', NULL, 3, 0),
(1223, 147, '隆尧县', NULL, 3, 0),
(1224, 147, '任县', NULL, 3, 0),
(1225, 147, '南和县', NULL, 3, 0),
(1226, 147, '宁晋县', NULL, 3, 0),
(1227, 147, '巨鹿县', NULL, 3, 0),
(1228, 147, '新河县', NULL, 3, 0),
(1229, 147, '广宗县', NULL, 3, 0),
(1230, 147, '平乡县', NULL, 3, 0),
(1231, 147, '威县', NULL, 3, 0),
(1232, 147, '清河县', NULL, 3, 0),
(1233, 147, '临西县', NULL, 3, 0),
(1234, 148, '桥西区', NULL, 3, 0),
(1235, 148, '桥东区', NULL, 3, 0),
(1236, 148, '宣化区', NULL, 3, 0),
(1237, 148, '下花园区', NULL, 3, 0),
(1238, 148, '宣化县', NULL, 3, 0),
(1239, 148, '张北县', NULL, 3, 0),
(1240, 148, '康保县', NULL, 3, 0),
(1241, 148, '沽源县', NULL, 3, 0),
(1242, 148, '尚义县', NULL, 3, 0),
(1243, 148, '蔚县', NULL, 3, 0),
(1244, 148, '阳原县', NULL, 3, 0),
(1245, 148, '怀安县', NULL, 3, 0),
(1246, 148, '万全县', NULL, 3, 0),
(1247, 148, '怀来县', NULL, 3, 0),
(1248, 148, '涿鹿县', NULL, 3, 0),
(1249, 148, '赤城县', NULL, 3, 0),
(1250, 148, '崇礼县', NULL, 3, 0),
(1251, 149, '金水区', NULL, 3, 0),
(1252, 149, '邙山区', NULL, 3, 0),
(1253, 149, '二七区', NULL, 3, 0),
(1254, 149, '管城区', NULL, 3, 0),
(1255, 149, '中原区', NULL, 3, 0),
(1256, 149, '上街区', NULL, 3, 0),
(1257, 149, '惠济区', NULL, 3, 0),
(1258, 149, '郑东新区', NULL, 3, 0),
(1259, 149, '经济技术开发区', NULL, 3, 0),
(1260, 149, '高新开发区', NULL, 3, 0),
(1261, 149, '出口加工区', NULL, 3, 0),
(1262, 149, '巩义市', NULL, 3, 0),
(1263, 149, '荥阳市', NULL, 3, 0),
(1264, 149, '新密市', NULL, 3, 0),
(1265, 149, '新郑市', NULL, 3, 0),
(1266, 149, '登封市', NULL, 3, 0),
(1267, 149, '中牟县', NULL, 3, 0),
(1268, 150, '西工区', NULL, 3, 0),
(1269, 150, '老城区', NULL, 3, 0),
(1270, 150, '涧西区', NULL, 3, 0),
(1271, 150, '瀍河回族区', NULL, 3, 0),
(1272, 150, '洛龙区', NULL, 3, 0),
(1273, 150, '吉利区', NULL, 3, 0),
(1274, 150, '偃师市', NULL, 3, 0),
(1275, 150, '孟津县', NULL, 3, 0),
(1276, 150, '新安县', NULL, 3, 0),
(1277, 150, '栾川县', NULL, 3, 0),
(1278, 150, '嵩县', NULL, 3, 0),
(1279, 150, '汝阳县', NULL, 3, 0),
(1280, 150, '宜阳县', NULL, 3, 0),
(1281, 150, '洛宁县', NULL, 3, 0),
(1282, 150, '伊川县', NULL, 3, 0),
(1283, 151, '鼓楼区', NULL, 3, 0),
(1284, 151, '龙亭区', NULL, 3, 0),
(1285, 151, '顺河回族区', NULL, 3, 0),
(1286, 151, '金明区', NULL, 3, 0),
(1287, 151, '禹王台区', NULL, 3, 0),
(1288, 151, '杞县', NULL, 3, 0),
(1289, 151, '通许县', NULL, 3, 0),
(1290, 151, '尉氏县', NULL, 3, 0),
(1291, 151, '开封县', NULL, 3, 0),
(1292, 151, '兰考县', NULL, 3, 0),
(1293, 152, '北关区', NULL, 3, 0),
(1294, 152, '文峰区', NULL, 3, 0),
(1295, 152, '殷都区', NULL, 3, 0),
(1296, 152, '龙安区', NULL, 3, 0),
(1297, 152, '林州市', NULL, 3, 0),
(1298, 152, '安阳县', NULL, 3, 0),
(1299, 152, '汤阴县', NULL, 3, 0),
(1300, 152, '滑县', NULL, 3, 0),
(1301, 152, '内黄县', NULL, 3, 0),
(1302, 153, '淇滨区', NULL, 3, 0),
(1303, 153, '山城区', NULL, 3, 0),
(1304, 153, '鹤山区', NULL, 3, 0),
(1305, 153, '浚县', NULL, 3, 0),
(1306, 153, '淇县', NULL, 3, 0),
(1307, 154, '济源市', NULL, 3, 0),
(1308, 155, '解放区', NULL, 3, 0),
(1309, 155, '中站区', NULL, 3, 0),
(1310, 155, '马村区', NULL, 3, 0),
(1311, 155, '山阳区', NULL, 3, 0),
(1312, 155, '沁阳市', NULL, 3, 0),
(1313, 155, '孟州市', NULL, 3, 0),
(1314, 155, '修武县', NULL, 3, 0),
(1315, 155, '博爱县', NULL, 3, 0),
(1316, 155, '武陟县', NULL, 3, 0),
(1317, 155, '温县', NULL, 3, 0),
(1318, 156, '卧龙区', NULL, 3, 0),
(1319, 156, '宛城区', NULL, 3, 0),
(1320, 156, '邓州市', NULL, 3, 0),
(1321, 156, '南召县', NULL, 3, 0),
(1322, 156, '方城县', NULL, 3, 0),
(1323, 156, '西峡县', NULL, 3, 0),
(1324, 156, '镇平县', NULL, 3, 0),
(1325, 156, '内乡县', NULL, 3, 0),
(1326, 156, '淅川县', NULL, 3, 0),
(1327, 156, '社旗县', NULL, 3, 0),
(1328, 156, '唐河县', NULL, 3, 0),
(1329, 156, '新野县', NULL, 3, 0),
(1330, 156, '桐柏县', NULL, 3, 0),
(1331, 157, '新华区', NULL, 3, 0),
(1332, 157, '卫东区', NULL, 3, 0),
(1333, 157, '湛河区', NULL, 3, 0),
(1334, 157, '石龙区', NULL, 3, 0),
(1335, 157, '舞钢市', NULL, 3, 0),
(1336, 157, '汝州市', NULL, 3, 0),
(1337, 157, '宝丰县', NULL, 3, 0),
(1338, 157, '叶县', NULL, 3, 0),
(1339, 157, '鲁山县', NULL, 3, 0),
(1340, 157, '郏县', NULL, 3, 0),
(1341, 158, '湖滨区', NULL, 3, 0),
(1342, 158, '义马市', NULL, 3, 0),
(1343, 158, '灵宝市', NULL, 3, 0),
(1344, 158, '渑池县', NULL, 3, 0),
(1345, 158, '陕县', NULL, 3, 0),
(1346, 158, '卢氏县', NULL, 3, 0),
(1347, 159, '梁园区', NULL, 3, 0),
(1348, 159, '睢阳区', NULL, 3, 0),
(1349, 159, '永城市', NULL, 3, 0),
(1350, 159, '民权县', NULL, 3, 0),
(1351, 159, '睢县', NULL, 3, 0),
(1352, 159, '宁陵县', NULL, 3, 0),
(1353, 159, '虞城县', NULL, 3, 0),
(1354, 159, '柘城县', NULL, 3, 0),
(1355, 159, '夏邑县', NULL, 3, 0),
(1356, 160, '卫滨区', NULL, 3, 0),
(1357, 160, '红旗区', NULL, 3, 0),
(1358, 160, '凤泉区', NULL, 3, 0),
(1359, 160, '牧野区', NULL, 3, 0),
(1360, 160, '卫辉市', NULL, 3, 0),
(1361, 160, '辉县市', NULL, 3, 0),
(1362, 160, '新乡县', NULL, 3, 0),
(1363, 160, '获嘉县', NULL, 3, 0),
(1364, 160, '原阳县', NULL, 3, 0),
(1365, 160, '延津县', NULL, 3, 0),
(1366, 160, '封丘县', NULL, 3, 0),
(1367, 160, '长垣县', NULL, 3, 0),
(1368, 161, '浉河区', NULL, 3, 0),
(1369, 161, '平桥区', NULL, 3, 0),
(1370, 161, '罗山县', NULL, 3, 0),
(1371, 161, '光山县', NULL, 3, 0),
(1372, 161, '新县', NULL, 3, 0),
(1373, 161, '商城县', NULL, 3, 0),
(1374, 161, '固始县', NULL, 3, 0),
(1375, 161, '潢川县', NULL, 3, 0),
(1376, 161, '淮滨县', NULL, 3, 0),
(1377, 161, '息县', NULL, 3, 0),
(1378, 162, '魏都区', NULL, 3, 0),
(1379, 162, '禹州市', NULL, 3, 0),
(1380, 162, '长葛市', NULL, 3, 0),
(1381, 162, '许昌县', NULL, 3, 0),
(1382, 162, '鄢陵县', NULL, 3, 0),
(1383, 162, '襄城县', NULL, 3, 0),
(1384, 163, '川汇区', NULL, 3, 0),
(1385, 163, '项城市', NULL, 3, 0),
(1386, 163, '扶沟县', NULL, 3, 0),
(1387, 163, '西华县', NULL, 3, 0),
(1388, 163, '商水县', NULL, 3, 0),
(1389, 163, '沈丘县', NULL, 3, 0),
(1390, 163, '郸城县', NULL, 3, 0),
(1391, 163, '淮阳县', NULL, 3, 0),
(1392, 163, '太康县', NULL, 3, 0),
(1393, 163, '鹿邑县', NULL, 3, 0),
(1394, 164, '驿城区', NULL, 3, 0),
(1395, 164, '西平县', NULL, 3, 0),
(1396, 164, '上蔡县', NULL, 3, 0),
(1397, 164, '平舆县', NULL, 3, 0),
(1398, 164, '正阳县', NULL, 3, 0),
(1399, 164, '确山县', NULL, 3, 0),
(1400, 164, '泌阳县', NULL, 3, 0),
(1401, 164, '汝南县', NULL, 3, 0),
(1402, 164, '遂平县', NULL, 3, 0),
(1403, 164, '新蔡县', NULL, 3, 0),
(1404, 165, '郾城区', NULL, 3, 0),
(1405, 165, '源汇区', NULL, 3, 0),
(1406, 165, '召陵区', NULL, 3, 0),
(1407, 165, '舞阳县', NULL, 3, 0),
(1408, 165, '临颍县', NULL, 3, 0),
(1409, 166, '华龙区', NULL, 3, 0),
(1410, 166, '清丰县', NULL, 3, 0),
(1411, 166, '南乐县', NULL, 3, 0),
(1412, 166, '范县', NULL, 3, 0),
(1413, 166, '台前县', NULL, 3, 0),
(1414, 166, '濮阳县', NULL, 3, 0),
(1415, 167, '道里区', NULL, 3, 0),
(1416, 167, '南岗区', NULL, 3, 0),
(1417, 167, '动力区', NULL, 3, 0),
(1418, 167, '平房区', NULL, 3, 0),
(1419, 167, '香坊区', NULL, 3, 0),
(1420, 167, '太平区', NULL, 3, 0),
(1421, 167, '道外区', NULL, 3, 0),
(1422, 167, '阿城区', NULL, 3, 0),
(1423, 167, '呼兰区', NULL, 3, 0),
(1424, 167, '松北区', NULL, 3, 0),
(1425, 167, '尚志市', NULL, 3, 0),
(1426, 167, '双城市', NULL, 3, 0),
(1427, 167, '五常市', NULL, 3, 0),
(1428, 167, '方正县', NULL, 3, 0),
(1429, 167, '宾县', NULL, 3, 0),
(1430, 167, '依兰县', NULL, 3, 0),
(1431, 167, '巴彦县', NULL, 3, 0),
(1432, 167, '通河县', NULL, 3, 0),
(1433, 167, '木兰县', NULL, 3, 0),
(1434, 167, '延寿县', NULL, 3, 0),
(1435, 168, '萨尔图区', NULL, 3, 0),
(1436, 168, '红岗区', NULL, 3, 0),
(1437, 168, '龙凤区', NULL, 3, 0),
(1438, 168, '让胡路区', NULL, 3, 0),
(1439, 168, '大同区', NULL, 3, 0),
(1440, 168, '肇州县', NULL, 3, 0),
(1441, 168, '肇源县', NULL, 3, 0),
(1442, 168, '林甸县', NULL, 3, 0),
(1443, 168, '杜尔伯特', NULL, 3, 0),
(1444, 169, '呼玛县', NULL, 3, 0),
(1445, 169, '漠河县', NULL, 3, 0),
(1446, 169, '塔河县', NULL, 3, 0),
(1447, 170, '兴山区', NULL, 3, 0),
(1448, 170, '工农区', NULL, 3, 0),
(1449, 170, '南山区', NULL, 3, 0),
(1450, 170, '兴安区', NULL, 3, 0),
(1451, 170, '向阳区', NULL, 3, 0),
(1452, 170, '东山区', NULL, 3, 0),
(1453, 170, '萝北县', NULL, 3, 0),
(1454, 170, '绥滨县', NULL, 3, 0),
(1455, 171, '爱辉区', NULL, 3, 0),
(1456, 171, '五大连池市', NULL, 3, 0),
(1457, 171, '北安市', NULL, 3, 0),
(1458, 171, '嫩江县', NULL, 3, 0),
(1459, 171, '逊克县', NULL, 3, 0),
(1460, 171, '孙吴县', NULL, 3, 0),
(1461, 172, '鸡冠区', NULL, 3, 0),
(1462, 172, '恒山区', NULL, 3, 0),
(1463, 172, '城子河区', NULL, 3, 0),
(1464, 172, '滴道区', NULL, 3, 0),
(1465, 172, '梨树区', NULL, 3, 0),
(1466, 172, '虎林市', NULL, 3, 0),
(1467, 172, '密山市', NULL, 3, 0),
(1468, 172, '鸡东县', NULL, 3, 0),
(1469, 173, '前进区', NULL, 3, 0),
(1470, 173, '郊区', NULL, 3, 0),
(1471, 173, '向阳区', NULL, 3, 0),
(1472, 173, '东风区', NULL, 3, 0),
(1473, 173, '同江市', NULL, 3, 0),
(1474, 173, '富锦市', NULL, 3, 0);
INSERT INTO `nitc_region` (`region_id`, `parent_id`, `region_name`, `iso_code_2`, `region_type`, `agency_id`) VALUES
(1475, 173, '桦南县', NULL, 3, 0),
(1476, 173, '桦川县', NULL, 3, 0),
(1477, 173, '汤原县', NULL, 3, 0),
(1478, 173, '抚远县', NULL, 3, 0),
(1479, 174, '爱民区', NULL, 3, 0),
(1480, 174, '东安区', NULL, 3, 0),
(1481, 174, '阳明区', NULL, 3, 0),
(1482, 174, '西安区', NULL, 3, 0),
(1483, 174, '绥芬河市', NULL, 3, 0),
(1484, 174, '海林市', NULL, 3, 0),
(1485, 174, '宁安市', NULL, 3, 0),
(1486, 174, '穆棱市', NULL, 3, 0),
(1487, 174, '东宁县', NULL, 3, 0),
(1488, 174, '林口县', NULL, 3, 0),
(1489, 175, '桃山区', NULL, 3, 0),
(1490, 175, '新兴区', NULL, 3, 0),
(1491, 175, '茄子河区', NULL, 3, 0),
(1492, 175, '勃利县', NULL, 3, 0),
(1493, 176, '龙沙区', NULL, 3, 0),
(1494, 176, '昂昂溪区', NULL, 3, 0),
(1495, 176, '铁峰区', NULL, 3, 0),
(1496, 176, '建华区', NULL, 3, 0),
(1497, 176, '富拉尔基区', NULL, 3, 0),
(1498, 176, '碾子山区', NULL, 3, 0),
(1499, 176, '梅里斯达斡尔区', NULL, 3, 0),
(1500, 176, '讷河市', NULL, 3, 0),
(1501, 176, '龙江县', NULL, 3, 0),
(1502, 176, '依安县', NULL, 3, 0),
(1503, 176, '泰来县', NULL, 3, 0),
(1504, 176, '甘南县', NULL, 3, 0),
(1505, 176, '富裕县', NULL, 3, 0),
(1506, 176, '克山县', NULL, 3, 0),
(1507, 176, '克东县', NULL, 3, 0),
(1508, 176, '拜泉县', NULL, 3, 0),
(1509, 177, '尖山区', NULL, 3, 0),
(1510, 177, '岭东区', NULL, 3, 0),
(1511, 177, '四方台区', NULL, 3, 0),
(1512, 177, '宝山区', NULL, 3, 0),
(1513, 177, '集贤县', NULL, 3, 0),
(1514, 177, '友谊县', NULL, 3, 0),
(1515, 177, '宝清县', NULL, 3, 0),
(1516, 177, '饶河县', NULL, 3, 0),
(1517, 178, '北林区', NULL, 3, 0),
(1518, 178, '安达市', NULL, 3, 0),
(1519, 178, '肇东市', NULL, 3, 0),
(1520, 178, '海伦市', NULL, 3, 0),
(1521, 178, '望奎县', NULL, 3, 0),
(1522, 178, '兰西县', NULL, 3, 0),
(1523, 178, '青冈县', NULL, 3, 0),
(1524, 178, '庆安县', NULL, 3, 0),
(1525, 178, '明水县', NULL, 3, 0),
(1526, 178, '绥棱县', NULL, 3, 0),
(1527, 179, '伊春区', NULL, 3, 0),
(1528, 179, '带岭区', NULL, 3, 0),
(1529, 179, '南岔区', NULL, 3, 0),
(1530, 179, '金山屯区', NULL, 3, 0),
(1531, 179, '西林区', NULL, 3, 0),
(1532, 179, '美溪区', NULL, 3, 0),
(1533, 179, '乌马河区', NULL, 3, 0),
(1534, 179, '翠峦区', NULL, 3, 0),
(1535, 179, '友好区', NULL, 3, 0),
(1536, 179, '上甘岭区', NULL, 3, 0),
(1537, 179, '五营区', NULL, 3, 0),
(1538, 179, '红星区', NULL, 3, 0),
(1539, 179, '新青区', NULL, 3, 0),
(1540, 179, '汤旺河区', NULL, 3, 0),
(1541, 179, '乌伊岭区', NULL, 3, 0),
(1542, 179, '铁力市', NULL, 3, 0),
(1543, 179, '嘉荫县', NULL, 3, 0),
(1544, 180, '江岸区', NULL, 3, 0),
(1545, 180, '武昌区', NULL, 3, 0),
(1546, 180, '江汉区', NULL, 3, 0),
(1547, 180, '硚口区', NULL, 3, 0),
(1548, 180, '汉阳区', NULL, 3, 0),
(1549, 180, '青山区', NULL, 3, 0),
(1550, 180, '洪山区', NULL, 3, 0),
(1551, 180, '东西湖区', NULL, 3, 0),
(1552, 180, '汉南区', NULL, 3, 0),
(1553, 180, '蔡甸区', NULL, 3, 0),
(1554, 180, '江夏区', NULL, 3, 0),
(1555, 180, '黄陂区', NULL, 3, 0),
(1556, 180, '新洲区', NULL, 3, 0),
(1557, 180, '经济开发区', NULL, 3, 0),
(1558, 181, '仙桃市', NULL, 3, 0),
(1559, 182, '鄂城区', NULL, 3, 0),
(1560, 182, '华容区', NULL, 3, 0),
(1561, 182, '梁子湖区', NULL, 3, 0),
(1562, 183, '黄州区', NULL, 3, 0),
(1563, 183, '麻城市', NULL, 3, 0),
(1564, 183, '武穴市', NULL, 3, 0),
(1565, 183, '团风县', NULL, 3, 0),
(1566, 183, '红安县', NULL, 3, 0),
(1567, 183, '罗田县', NULL, 3, 0),
(1568, 183, '英山县', NULL, 3, 0),
(1569, 183, '浠水县', NULL, 3, 0),
(1570, 183, '蕲春县', NULL, 3, 0),
(1571, 183, '黄梅县', NULL, 3, 0),
(1572, 184, '黄石港区', NULL, 3, 0),
(1573, 184, '西塞山区', NULL, 3, 0),
(1574, 184, '下陆区', NULL, 3, 0),
(1575, 184, '铁山区', NULL, 3, 0),
(1576, 184, '大冶市', NULL, 3, 0),
(1577, 184, '阳新县', NULL, 3, 0),
(1578, 185, '东宝区', NULL, 3, 0),
(1579, 185, '掇刀区', NULL, 3, 0),
(1580, 185, '钟祥市', NULL, 3, 0),
(1581, 185, '京山县', NULL, 3, 0),
(1582, 185, '沙洋县', NULL, 3, 0),
(1583, 186, '沙市区', NULL, 3, 0),
(1584, 186, '荆州区', NULL, 3, 0),
(1585, 186, '石首市', NULL, 3, 0),
(1586, 186, '洪湖市', NULL, 3, 0),
(1587, 186, '松滋市', NULL, 3, 0),
(1588, 186, '公安县', NULL, 3, 0),
(1589, 186, '监利县', NULL, 3, 0),
(1590, 186, '江陵县', NULL, 3, 0),
(1591, 187, '潜江市', NULL, 3, 0),
(1592, 188, '神农架林区', NULL, 3, 0),
(1593, 189, '张湾区', NULL, 3, 0),
(1594, 189, '茅箭区', NULL, 3, 0),
(1595, 189, '丹江口市', NULL, 3, 0),
(1596, 189, '郧县', NULL, 3, 0),
(1597, 189, '郧西县', NULL, 3, 0),
(1598, 189, '竹山县', NULL, 3, 0),
(1599, 189, '竹溪县', NULL, 3, 0),
(1600, 189, '房县', NULL, 3, 0),
(1601, 190, '曾都区', NULL, 3, 0),
(1602, 190, '广水市', NULL, 3, 0),
(1603, 191, '天门市', NULL, 3, 0),
(1604, 192, '咸安区', NULL, 3, 0),
(1605, 192, '赤壁市', NULL, 3, 0),
(1606, 192, '嘉鱼县', NULL, 3, 0),
(1607, 192, '通城县', NULL, 3, 0),
(1608, 192, '崇阳县', NULL, 3, 0),
(1609, 192, '通山县', NULL, 3, 0),
(1610, 193, '襄城区', NULL, 3, 0),
(1611, 193, '樊城区', NULL, 3, 0),
(1612, 193, '襄阳区', NULL, 3, 0),
(1613, 193, '老河口市', NULL, 3, 0),
(1614, 193, '枣阳市', NULL, 3, 0),
(1615, 193, '宜城市', NULL, 3, 0),
(1616, 193, '南漳县', NULL, 3, 0),
(1617, 193, '谷城县', NULL, 3, 0),
(1618, 193, '保康县', NULL, 3, 0),
(1619, 194, '孝南区', NULL, 3, 0),
(1620, 194, '应城市', NULL, 3, 0),
(1621, 194, '安陆市', NULL, 3, 0),
(1622, 194, '汉川市', NULL, 3, 0),
(1623, 194, '孝昌县', NULL, 3, 0),
(1624, 194, '大悟县', NULL, 3, 0),
(1625, 194, '云梦县', NULL, 3, 0),
(1626, 195, '长阳', NULL, 3, 0),
(1627, 195, '五峰', NULL, 3, 0),
(1628, 195, '西陵区', NULL, 3, 0),
(1629, 195, '伍家岗区', NULL, 3, 0),
(1630, 195, '点军区', NULL, 3, 0),
(1631, 195, '猇亭区', NULL, 3, 0),
(1632, 195, '夷陵区', NULL, 3, 0),
(1633, 195, '宜都市', NULL, 3, 0),
(1634, 195, '当阳市', NULL, 3, 0),
(1635, 195, '枝江市', NULL, 3, 0),
(1636, 195, '远安县', NULL, 3, 0),
(1637, 195, '兴山县', NULL, 3, 0),
(1638, 195, '秭归县', NULL, 3, 0),
(1639, 196, '恩施市', NULL, 3, 0),
(1640, 196, '利川市', NULL, 3, 0),
(1641, 196, '建始县', NULL, 3, 0),
(1642, 196, '巴东县', NULL, 3, 0),
(1643, 196, '宣恩县', NULL, 3, 0),
(1644, 196, '咸丰县', NULL, 3, 0),
(1645, 196, '来凤县', NULL, 3, 0),
(1646, 196, '鹤峰县', NULL, 3, 0),
(1647, 197, '岳麓区', NULL, 3, 0),
(1648, 197, '芙蓉区', NULL, 3, 0),
(1649, 197, '天心区', NULL, 3, 0),
(1650, 197, '开福区', NULL, 3, 0),
(1651, 197, '雨花区', NULL, 3, 0),
(1652, 197, '开发区', NULL, 3, 0),
(1653, 197, '浏阳市', NULL, 3, 0),
(1654, 197, '长沙县', NULL, 3, 0),
(1655, 197, '望城县', NULL, 3, 0),
(1656, 197, '宁乡县', NULL, 3, 0),
(1657, 198, '永定区', NULL, 3, 0),
(1658, 198, '武陵源区', NULL, 3, 0),
(1659, 198, '慈利县', NULL, 3, 0),
(1660, 198, '桑植县', NULL, 3, 0),
(1661, 199, '武陵区', NULL, 3, 0),
(1662, 199, '鼎城区', NULL, 3, 0),
(1663, 199, '津市市', NULL, 3, 0),
(1664, 199, '安乡县', NULL, 3, 0),
(1665, 199, '汉寿县', NULL, 3, 0),
(1666, 199, '澧县', NULL, 3, 0),
(1667, 199, '临澧县', NULL, 3, 0),
(1668, 199, '桃源县', NULL, 3, 0),
(1669, 199, '石门县', NULL, 3, 0),
(1670, 200, '北湖区', NULL, 3, 0),
(1671, 200, '苏仙区', NULL, 3, 0),
(1672, 200, '资兴市', NULL, 3, 0),
(1673, 200, '桂阳县', NULL, 3, 0),
(1674, 200, '宜章县', NULL, 3, 0),
(1675, 200, '永兴县', NULL, 3, 0),
(1676, 200, '嘉禾县', NULL, 3, 0),
(1677, 200, '临武县', NULL, 3, 0),
(1678, 200, '汝城县', NULL, 3, 0),
(1679, 200, '桂东县', NULL, 3, 0),
(1680, 200, '安仁县', NULL, 3, 0),
(1681, 201, '雁峰区', NULL, 3, 0),
(1682, 201, '珠晖区', NULL, 3, 0),
(1683, 201, '石鼓区', NULL, 3, 0),
(1684, 201, '蒸湘区', NULL, 3, 0),
(1685, 201, '南岳区', NULL, 3, 0),
(1686, 201, '耒阳市', NULL, 3, 0),
(1687, 201, '常宁市', NULL, 3, 0),
(1688, 201, '衡阳县', NULL, 3, 0),
(1689, 201, '衡南县', NULL, 3, 0),
(1690, 201, '衡山县', NULL, 3, 0),
(1691, 201, '衡东县', NULL, 3, 0),
(1692, 201, '祁东县', NULL, 3, 0),
(1693, 202, '鹤城区', NULL, 3, 0),
(1694, 202, '靖州', NULL, 3, 0),
(1695, 202, '麻阳', NULL, 3, 0),
(1696, 202, '通道', NULL, 3, 0),
(1697, 202, '新晃', NULL, 3, 0),
(1698, 202, '芷江', NULL, 3, 0),
(1699, 202, '沅陵县', NULL, 3, 0),
(1700, 202, '辰溪县', NULL, 3, 0),
(1701, 202, '溆浦县', NULL, 3, 0),
(1702, 202, '中方县', NULL, 3, 0),
(1703, 202, '会同县', NULL, 3, 0),
(1704, 202, '洪江市', NULL, 3, 0),
(1705, 203, '娄星区', NULL, 3, 0),
(1706, 203, '冷水江市', NULL, 3, 0),
(1707, 203, '涟源市', NULL, 3, 0),
(1708, 203, '双峰县', NULL, 3, 0),
(1709, 203, '新化县', NULL, 3, 0),
(1710, 204, '城步', NULL, 3, 0),
(1711, 204, '双清区', NULL, 3, 0),
(1712, 204, '大祥区', NULL, 3, 0),
(1713, 204, '北塔区', NULL, 3, 0),
(1714, 204, '武冈市', NULL, 3, 0),
(1715, 204, '邵东县', NULL, 3, 0),
(1716, 204, '新邵县', NULL, 3, 0),
(1717, 204, '邵阳县', NULL, 3, 0),
(1718, 204, '隆回县', NULL, 3, 0),
(1719, 204, '洞口县', NULL, 3, 0),
(1720, 204, '绥宁县', NULL, 3, 0),
(1721, 204, '新宁县', NULL, 3, 0),
(1722, 205, '岳塘区', NULL, 3, 0),
(1723, 205, '雨湖区', NULL, 3, 0),
(1724, 205, '湘乡市', NULL, 3, 0),
(1725, 205, '韶山市', NULL, 3, 0),
(1726, 205, '湘潭县', NULL, 3, 0),
(1727, 206, '吉首市', NULL, 3, 0),
(1728, 206, '泸溪县', NULL, 3, 0),
(1729, 206, '凤凰县', NULL, 3, 0),
(1730, 206, '花垣县', NULL, 3, 0),
(1731, 206, '保靖县', NULL, 3, 0),
(1732, 206, '古丈县', NULL, 3, 0),
(1733, 206, '永顺县', NULL, 3, 0),
(1734, 206, '龙山县', NULL, 3, 0),
(1735, 207, '赫山区', NULL, 3, 0),
(1736, 207, '资阳区', NULL, 3, 0),
(1737, 207, '沅江市', NULL, 3, 0),
(1738, 207, '南县', NULL, 3, 0),
(1739, 207, '桃江县', NULL, 3, 0),
(1740, 207, '安化县', NULL, 3, 0),
(1741, 208, '江华', NULL, 3, 0),
(1742, 208, '冷水滩区', NULL, 3, 0),
(1743, 208, '零陵区', NULL, 3, 0),
(1744, 208, '祁阳县', NULL, 3, 0),
(1745, 208, '东安县', NULL, 3, 0),
(1746, 208, '双牌县', NULL, 3, 0),
(1747, 208, '道县', NULL, 3, 0),
(1748, 208, '江永县', NULL, 3, 0),
(1749, 208, '宁远县', NULL, 3, 0),
(1750, 208, '蓝山县', NULL, 3, 0),
(1751, 208, '新田县', NULL, 3, 0),
(1752, 209, '岳阳楼区', NULL, 3, 0),
(1753, 209, '君山区', NULL, 3, 0),
(1754, 209, '云溪区', NULL, 3, 0),
(1755, 209, '汨罗市', NULL, 3, 0),
(1756, 209, '临湘市', NULL, 3, 0),
(1757, 209, '岳阳县', NULL, 3, 0),
(1758, 209, '华容县', NULL, 3, 0),
(1759, 209, '湘阴县', NULL, 3, 0),
(1760, 209, '平江县', NULL, 3, 0),
(1761, 210, '天元区', NULL, 3, 0),
(1762, 210, '荷塘区', NULL, 3, 0),
(1763, 210, '芦淞区', NULL, 3, 0),
(1764, 210, '石峰区', NULL, 3, 0),
(1765, 210, '醴陵市', NULL, 3, 0),
(1766, 210, '株洲县', NULL, 3, 0),
(1767, 210, '攸县', NULL, 3, 0),
(1768, 210, '茶陵县', NULL, 3, 0),
(1769, 210, '炎陵县', NULL, 3, 0),
(1770, 211, '朝阳区', NULL, 3, 0),
(1771, 211, '宽城区', NULL, 3, 0),
(1772, 211, '二道区', NULL, 3, 0),
(1773, 211, '南关区', NULL, 3, 0),
(1774, 211, '绿园区', NULL, 3, 0),
(1775, 211, '双阳区', NULL, 3, 0),
(1776, 211, '净月潭开发区', NULL, 3, 0),
(1777, 211, '高新技术开发区', NULL, 3, 0),
(1778, 211, '经济技术开发区', NULL, 3, 0),
(1779, 211, '汽车产业开发区', NULL, 3, 0),
(1780, 211, '德惠市', NULL, 3, 0),
(1781, 211, '九台市', NULL, 3, 0),
(1782, 211, '榆树市', NULL, 3, 0),
(1783, 211, '农安县', NULL, 3, 0),
(1784, 212, '船营区', NULL, 3, 0),
(1785, 212, '昌邑区', NULL, 3, 0),
(1786, 212, '龙潭区', NULL, 3, 0),
(1787, 212, '丰满区', NULL, 3, 0),
(1788, 212, '蛟河市', NULL, 3, 0),
(1789, 212, '桦甸市', NULL, 3, 0),
(1790, 212, '舒兰市', NULL, 3, 0),
(1791, 212, '磐石市', NULL, 3, 0),
(1792, 212, '永吉县', NULL, 3, 0),
(1793, 213, '洮北区', NULL, 3, 0),
(1794, 213, '洮南市', NULL, 3, 0),
(1795, 213, '大安市', NULL, 3, 0),
(1796, 213, '镇赉县', NULL, 3, 0),
(1797, 213, '通榆县', NULL, 3, 0),
(1798, 214, '江源区', NULL, 3, 0),
(1799, 214, '八道江区', NULL, 3, 0),
(1800, 214, '长白', NULL, 3, 0),
(1801, 214, '临江市', NULL, 3, 0),
(1802, 214, '抚松县', NULL, 3, 0),
(1803, 214, '靖宇县', NULL, 3, 0),
(1804, 215, '龙山区', NULL, 3, 0),
(1805, 215, '西安区', NULL, 3, 0),
(1806, 215, '东丰县', NULL, 3, 0),
(1807, 215, '东辽县', NULL, 3, 0),
(1808, 216, '铁西区', NULL, 3, 0),
(1809, 216, '铁东区', NULL, 3, 0),
(1810, 216, '伊通', NULL, 3, 0),
(1811, 216, '公主岭市', NULL, 3, 0),
(1812, 216, '双辽市', NULL, 3, 0),
(1813, 216, '梨树县', NULL, 3, 0),
(1814, 217, '前郭尔罗斯', NULL, 3, 0),
(1815, 217, '宁江区', NULL, 3, 0),
(1816, 217, '长岭县', NULL, 3, 0),
(1817, 217, '乾安县', NULL, 3, 0),
(1818, 217, '扶余县', NULL, 3, 0),
(1819, 218, '东昌区', NULL, 3, 0),
(1820, 218, '二道江区', NULL, 3, 0),
(1821, 218, '梅河口市', NULL, 3, 0),
(1822, 218, '集安市', NULL, 3, 0),
(1823, 218, '通化县', NULL, 3, 0),
(1824, 218, '辉南县', NULL, 3, 0),
(1825, 218, '柳河县', NULL, 3, 0),
(1826, 219, '延吉市', NULL, 3, 0),
(1827, 219, '图们市', NULL, 3, 0),
(1828, 219, '敦化市', NULL, 3, 0),
(1829, 219, '珲春市', NULL, 3, 0),
(1830, 219, '龙井市', NULL, 3, 0),
(1831, 219, '和龙市', NULL, 3, 0),
(1832, 219, '安图县', NULL, 3, 0),
(1833, 219, '汪清县', NULL, 3, 0),
(1834, 220, '玄武区', NULL, 3, 0),
(1835, 220, '鼓楼区', NULL, 3, 0),
(1836, 220, '白下区', NULL, 3, 0),
(1837, 220, '建邺区', NULL, 3, 0),
(1838, 220, '秦淮区', NULL, 3, 0),
(1839, 220, '雨花台区', NULL, 3, 0),
(1840, 220, '下关区', NULL, 3, 0),
(1841, 220, '栖霞区', NULL, 3, 0),
(1842, 220, '浦口区', NULL, 3, 0),
(1843, 220, '江宁区', NULL, 3, 0),
(1844, 220, '六合区', NULL, 3, 0),
(1845, 220, '溧水县', NULL, 3, 0),
(1846, 220, '高淳县', NULL, 3, 0),
(1847, 221, '沧浪区', NULL, 3, 0),
(1848, 221, '金阊区', NULL, 3, 0),
(1849, 221, '平江区', NULL, 3, 0),
(1850, 221, '虎丘区', NULL, 3, 0),
(1851, 221, '吴中区', NULL, 3, 0),
(1852, 221, '相城区', NULL, 3, 0),
(1853, 221, '园区', NULL, 3, 0),
(1854, 221, '新区', NULL, 3, 0),
(1855, 221, '常熟市', NULL, 3, 0),
(1856, 221, '张家港市', NULL, 3, 0),
(1857, 221, '玉山镇', NULL, 3, 0),
(1858, 221, '巴城镇', NULL, 3, 0),
(1859, 221, '周市镇', NULL, 3, 0),
(1860, 221, '陆家镇', NULL, 3, 0),
(1861, 221, '花桥镇', NULL, 3, 0),
(1862, 221, '淀山湖镇', NULL, 3, 0),
(1863, 221, '张浦镇', NULL, 3, 0),
(1864, 221, '周庄镇', NULL, 3, 0),
(1865, 221, '千灯镇', NULL, 3, 0),
(1866, 221, '锦溪镇', NULL, 3, 0),
(1867, 221, '开发区', NULL, 3, 0),
(1868, 221, '吴江市', NULL, 3, 0),
(1869, 221, '太仓市', NULL, 3, 0),
(1870, 222, '崇安区', NULL, 3, 0),
(1871, 222, '北塘区', NULL, 3, 0),
(1872, 222, '南长区', NULL, 3, 0),
(1873, 222, '锡山区', NULL, 3, 0),
(1874, 222, '惠山区', NULL, 3, 0),
(1875, 222, '滨湖区', NULL, 3, 0),
(1876, 222, '新区', NULL, 3, 0),
(1877, 222, '江阴市', NULL, 3, 0),
(1878, 222, '宜兴市', NULL, 3, 0),
(1879, 223, '天宁区', NULL, 3, 0),
(1880, 223, '钟楼区', NULL, 3, 0),
(1881, 223, '戚墅堰区', NULL, 3, 0),
(1882, 223, '郊区', NULL, 3, 0),
(1883, 223, '新北区', NULL, 3, 0),
(1884, 223, '武进区', NULL, 3, 0),
(1885, 223, '溧阳市', NULL, 3, 0),
(1886, 223, '金坛市', NULL, 3, 0),
(1887, 224, '清河区', NULL, 3, 0),
(1888, 224, '清浦区', NULL, 3, 0),
(1889, 224, '楚州区', NULL, 3, 0),
(1890, 224, '淮阴区', NULL, 3, 0),
(1891, 224, '涟水县', NULL, 3, 0),
(1892, 224, '洪泽县', NULL, 3, 0),
(1893, 224, '盱眙县', NULL, 3, 0),
(1894, 224, '金湖县', NULL, 3, 0),
(1895, 225, '新浦区', NULL, 3, 0),
(1896, 225, '连云区', NULL, 3, 0),
(1897, 225, '海州区', NULL, 3, 0),
(1898, 225, '赣榆县', NULL, 3, 0),
(1899, 225, '东海县', NULL, 3, 0),
(1900, 225, '灌云县', NULL, 3, 0),
(1901, 225, '灌南县', NULL, 3, 0),
(1902, 226, '崇川区', NULL, 3, 0),
(1903, 226, '港闸区', NULL, 3, 0),
(1904, 226, '经济开发区', NULL, 3, 0),
(1905, 226, '启东市', NULL, 3, 0),
(1906, 226, '如皋市', NULL, 3, 0),
(1907, 226, '通州市', NULL, 3, 0),
(1908, 226, '海门市', NULL, 3, 0),
(1909, 226, '海安县', NULL, 3, 0),
(1910, 226, '如东县', NULL, 3, 0),
(1911, 227, '宿城区', NULL, 3, 0),
(1912, 227, '宿豫区', NULL, 3, 0),
(1913, 227, '宿豫县', NULL, 3, 0),
(1914, 227, '沭阳县', NULL, 3, 0),
(1915, 227, '泗阳县', NULL, 3, 0),
(1916, 227, '泗洪县', NULL, 3, 0),
(1917, 228, '海陵区', NULL, 3, 0),
(1918, 228, '高港区', NULL, 3, 0),
(1919, 228, '兴化市', NULL, 3, 0),
(1920, 228, '靖江市', NULL, 3, 0),
(1921, 228, '泰兴市', NULL, 3, 0),
(1922, 228, '姜堰市', NULL, 3, 0),
(1923, 229, '云龙区', NULL, 3, 0),
(1924, 229, '鼓楼区', NULL, 3, 0),
(1925, 229, '九里区', NULL, 3, 0),
(1926, 229, '贾汪区', NULL, 3, 0),
(1927, 229, '泉山区', NULL, 3, 0),
(1928, 229, '新沂市', NULL, 3, 0),
(1929, 229, '邳州市', NULL, 3, 0),
(1930, 229, '丰县', NULL, 3, 0),
(1931, 229, '沛县', NULL, 3, 0),
(1932, 229, '铜山县', NULL, 3, 0),
(1933, 229, '睢宁县', NULL, 3, 0),
(1934, 230, '城区', NULL, 3, 0),
(1935, 230, '亭湖区', NULL, 3, 0),
(1936, 230, '盐都区', NULL, 3, 0),
(1937, 230, '盐都县', NULL, 3, 0),
(1938, 230, '东台市', NULL, 3, 0),
(1939, 230, '大丰市', NULL, 3, 0),
(1940, 230, '响水县', NULL, 3, 0),
(1941, 230, '滨海县', NULL, 3, 0),
(1942, 230, '阜宁县', NULL, 3, 0),
(1943, 230, '射阳县', NULL, 3, 0),
(1944, 230, '建湖县', NULL, 3, 0),
(1945, 231, '广陵区', NULL, 3, 0),
(1946, 231, '维扬区', NULL, 3, 0),
(1947, 231, '邗江区', NULL, 3, 0),
(1948, 231, '仪征市', NULL, 3, 0),
(1949, 231, '高邮市', NULL, 3, 0),
(1950, 231, '江都市', NULL, 3, 0),
(1951, 231, '宝应县', NULL, 3, 0),
(1952, 232, '京口区', NULL, 3, 0),
(1953, 232, '润州区', NULL, 3, 0),
(1954, 232, '丹徒区', NULL, 3, 0),
(1955, 232, '丹阳市', NULL, 3, 0),
(1956, 232, '扬中市', NULL, 3, 0),
(1957, 232, '句容市', NULL, 3, 0),
(1958, 233, '东湖区', NULL, 3, 0),
(1959, 233, '西湖区', NULL, 3, 0),
(1960, 233, '青云谱区', NULL, 3, 0),
(1961, 233, '湾里区', NULL, 3, 0),
(1962, 233, '青山湖区', NULL, 3, 0),
(1963, 233, '红谷滩新区', NULL, 3, 0),
(1964, 233, '昌北区', NULL, 3, 0),
(1965, 233, '高新区', NULL, 3, 0),
(1966, 233, '南昌县', NULL, 3, 0),
(1967, 233, '新建县', NULL, 3, 0),
(1968, 233, '安义县', NULL, 3, 0),
(1969, 233, '进贤县', NULL, 3, 0),
(1970, 234, '临川区', NULL, 3, 0),
(1971, 234, '南城县', NULL, 3, 0),
(1972, 234, '黎川县', NULL, 3, 0),
(1973, 234, '南丰县', NULL, 3, 0),
(1974, 234, '崇仁县', NULL, 3, 0),
(1975, 234, '乐安县', NULL, 3, 0),
(1976, 234, '宜黄县', NULL, 3, 0),
(1977, 234, '金溪县', NULL, 3, 0),
(1978, 234, '资溪县', NULL, 3, 0),
(1979, 234, '东乡县', NULL, 3, 0),
(1980, 234, '广昌县', NULL, 3, 0),
(1981, 235, '章贡区', NULL, 3, 0),
(1982, 235, '于都县', NULL, 3, 0),
(1983, 235, '瑞金市', NULL, 3, 0),
(1984, 235, '南康市', NULL, 3, 0),
(1985, 235, '赣县', NULL, 3, 0),
(1986, 235, '信丰县', NULL, 3, 0),
(1987, 235, '大余县', NULL, 3, 0),
(1988, 235, '上犹县', NULL, 3, 0),
(1989, 235, '崇义县', NULL, 3, 0),
(1990, 235, '安远县', NULL, 3, 0),
(1991, 235, '龙南县', NULL, 3, 0),
(1992, 235, '定南县', NULL, 3, 0),
(1993, 235, '全南县', NULL, 3, 0),
(1994, 235, '宁都县', NULL, 3, 0),
(1995, 235, '兴国县', NULL, 3, 0),
(1996, 235, '会昌县', NULL, 3, 0),
(1997, 235, '寻乌县', NULL, 3, 0),
(1998, 235, '石城县', NULL, 3, 0),
(1999, 236, '安福县', NULL, 3, 0),
(2000, 236, '吉州区', NULL, 3, 0),
(2001, 236, '青原区', NULL, 3, 0),
(2002, 236, '井冈山市', NULL, 3, 0),
(2003, 236, '吉安县', NULL, 3, 0),
(2004, 236, '吉水县', NULL, 3, 0),
(2005, 236, '峡江县', NULL, 3, 0),
(2006, 236, '新干县', NULL, 3, 0),
(2007, 236, '永丰县', NULL, 3, 0),
(2008, 236, '泰和县', NULL, 3, 0),
(2009, 236, '遂川县', NULL, 3, 0),
(2010, 236, '万安县', NULL, 3, 0),
(2011, 236, '永新县', NULL, 3, 0),
(2012, 237, '珠山区', NULL, 3, 0),
(2013, 237, '昌江区', NULL, 3, 0),
(2014, 237, '乐平市', NULL, 3, 0),
(2015, 237, '浮梁县', NULL, 3, 0),
(2016, 238, '浔阳区', NULL, 3, 0),
(2017, 238, '庐山区', NULL, 3, 0),
(2018, 238, '瑞昌市', NULL, 3, 0),
(2019, 238, '九江县', NULL, 3, 0),
(2020, 238, '武宁县', NULL, 3, 0),
(2021, 238, '修水县', NULL, 3, 0),
(2022, 238, '永修县', NULL, 3, 0),
(2023, 238, '德安县', NULL, 3, 0),
(2024, 238, '星子县', NULL, 3, 0),
(2025, 238, '都昌县', NULL, 3, 0),
(2026, 238, '湖口县', NULL, 3, 0),
(2027, 238, '彭泽县', NULL, 3, 0),
(2028, 239, '安源区', NULL, 3, 0),
(2029, 239, '湘东区', NULL, 3, 0),
(2030, 239, '莲花县', NULL, 3, 0),
(2031, 239, '芦溪县', NULL, 3, 0),
(2032, 239, '上栗县', NULL, 3, 0),
(2033, 240, '信州区', NULL, 3, 0),
(2034, 240, '德兴市', NULL, 3, 0),
(2035, 240, '上饶县', NULL, 3, 0),
(2036, 240, '广丰县', NULL, 3, 0),
(2037, 240, '玉山县', NULL, 3, 0),
(2038, 240, '铅山县', NULL, 3, 0),
(2039, 240, '横峰县', NULL, 3, 0),
(2040, 240, '弋阳县', NULL, 3, 0),
(2041, 240, '余干县', NULL, 3, 0),
(2042, 240, '波阳县', NULL, 3, 0),
(2043, 240, '万年县', NULL, 3, 0),
(2044, 240, '婺源县', NULL, 3, 0),
(2045, 241, '渝水区', NULL, 3, 0),
(2046, 241, '分宜县', NULL, 3, 0),
(2047, 242, '袁州区', NULL, 3, 0),
(2048, 242, '丰城市', NULL, 3, 0),
(2049, 242, '樟树市', NULL, 3, 0),
(2050, 242, '高安市', NULL, 3, 0),
(2051, 242, '奉新县', NULL, 3, 0),
(2052, 242, '万载县', NULL, 3, 0),
(2053, 242, '上高县', NULL, 3, 0),
(2054, 242, '宜丰县', NULL, 3, 0),
(2055, 242, '靖安县', NULL, 3, 0),
(2056, 242, '铜鼓县', NULL, 3, 0),
(2057, 243, '月湖区', NULL, 3, 0),
(2058, 243, '贵溪市', NULL, 3, 0),
(2059, 243, '余江县', NULL, 3, 0),
(2060, 244, '沈河区', NULL, 3, 0),
(2061, 244, '皇姑区', NULL, 3, 0),
(2062, 244, '和平区', NULL, 3, 0),
(2063, 244, '大东区', NULL, 3, 0),
(2064, 244, '铁西区', NULL, 3, 0),
(2065, 244, '苏家屯区', NULL, 3, 0),
(2066, 244, '东陵区', NULL, 3, 0),
(2067, 244, '沈北新区', NULL, 3, 0),
(2068, 244, '于洪区', NULL, 3, 0),
(2069, 244, '浑南新区', NULL, 3, 0),
(2070, 244, '新民市', NULL, 3, 0),
(2071, 244, '辽中县', NULL, 3, 0),
(2072, 244, '康平县', NULL, 3, 0),
(2073, 244, '法库县', NULL, 3, 0),
(2074, 245, '西岗区', NULL, 3, 0),
(2075, 245, '中山区', NULL, 3, 0),
(2076, 245, '沙河口区', NULL, 3, 0),
(2077, 245, '甘井子区', NULL, 3, 0),
(2078, 245, '旅顺口区', NULL, 3, 0),
(2079, 245, '金州区', NULL, 3, 0),
(2080, 245, '开发区', NULL, 3, 0),
(2081, 245, '瓦房店市', NULL, 3, 0),
(2082, 245, '普兰店市', NULL, 3, 0),
(2083, 245, '庄河市', NULL, 3, 0),
(2084, 245, '长海县', NULL, 3, 0),
(2085, 246, '铁东区', NULL, 3, 0),
(2086, 246, '铁西区', NULL, 3, 0),
(2087, 246, '立山区', NULL, 3, 0),
(2088, 246, '千山区', NULL, 3, 0),
(2089, 246, '岫岩', NULL, 3, 0),
(2090, 246, '海城市', NULL, 3, 0),
(2091, 246, '台安县', NULL, 3, 0),
(2092, 247, '本溪', NULL, 3, 0),
(2093, 247, '平山区', NULL, 3, 0),
(2094, 247, '明山区', NULL, 3, 0),
(2095, 247, '溪湖区', NULL, 3, 0),
(2096, 247, '南芬区', NULL, 3, 0),
(2097, 247, '桓仁', NULL, 3, 0),
(2098, 248, '双塔区', NULL, 3, 0),
(2099, 248, '龙城区', NULL, 3, 0),
(2100, 248, '喀喇沁左翼蒙古族自治县', NULL, 3, 0),
(2101, 248, '北票市', NULL, 3, 0),
(2102, 248, '凌源市', NULL, 3, 0),
(2103, 248, '朝阳县', NULL, 3, 0),
(2104, 248, '建平县', NULL, 3, 0),
(2105, 249, '振兴区', NULL, 3, 0),
(2106, 249, '元宝区', NULL, 3, 0),
(2107, 249, '振安区', NULL, 3, 0),
(2108, 249, '宽甸', NULL, 3, 0),
(2109, 249, '东港市', NULL, 3, 0),
(2110, 249, '凤城市', NULL, 3, 0),
(2111, 250, '顺城区', NULL, 3, 0),
(2112, 250, '新抚区', NULL, 3, 0),
(2113, 250, '东洲区', NULL, 3, 0),
(2114, 250, '望花区', NULL, 3, 0),
(2115, 250, '清原', NULL, 3, 0),
(2116, 250, '新宾', NULL, 3, 0),
(2117, 250, '抚顺县', NULL, 3, 0),
(2118, 251, '阜新', NULL, 3, 0),
(2119, 251, '海州区', NULL, 3, 0),
(2120, 251, '新邱区', NULL, 3, 0),
(2121, 251, '太平区', NULL, 3, 0),
(2122, 251, '清河门区', NULL, 3, 0),
(2123, 251, '细河区', NULL, 3, 0),
(2124, 251, '彰武县', NULL, 3, 0),
(2125, 252, '龙港区', NULL, 3, 0),
(2126, 252, '南票区', NULL, 3, 0),
(2127, 252, '连山区', NULL, 3, 0),
(2128, 252, '兴城市', NULL, 3, 0),
(2129, 252, '绥中县', NULL, 3, 0),
(2130, 252, '建昌县', NULL, 3, 0),
(2131, 253, '太和区', NULL, 3, 0),
(2132, 253, '古塔区', NULL, 3, 0),
(2133, 253, '凌河区', NULL, 3, 0),
(2134, 253, '凌海市', NULL, 3, 0),
(2135, 253, '北镇市', NULL, 3, 0),
(2136, 253, '黑山县', NULL, 3, 0),
(2137, 253, '义县', NULL, 3, 0),
(2138, 254, '白塔区', NULL, 3, 0),
(2139, 254, '文圣区', NULL, 3, 0),
(2140, 254, '宏伟区', NULL, 3, 0),
(2141, 254, '太子河区', NULL, 3, 0),
(2142, 254, '弓长岭区', NULL, 3, 0),
(2143, 254, '灯塔市', NULL, 3, 0),
(2144, 254, '辽阳县', NULL, 3, 0),
(2145, 255, '双台子区', NULL, 3, 0),
(2146, 255, '兴隆台区', NULL, 3, 0),
(2147, 255, '大洼县', NULL, 3, 0),
(2148, 255, '盘山县', NULL, 3, 0),
(2149, 256, '银州区', NULL, 3, 0),
(2150, 256, '清河区', NULL, 3, 0),
(2151, 256, '调兵山市', NULL, 3, 0),
(2152, 256, '开原市', NULL, 3, 0),
(2153, 256, '铁岭县', NULL, 3, 0),
(2154, 256, '西丰县', NULL, 3, 0),
(2155, 256, '昌图县', NULL, 3, 0),
(2156, 257, '站前区', NULL, 3, 0),
(2157, 257, '西市区', NULL, 3, 0),
(2158, 257, '鲅鱼圈区', NULL, 3, 0),
(2159, 257, '老边区', NULL, 3, 0),
(2160, 257, '盖州市', NULL, 3, 0),
(2161, 257, '大石桥市', NULL, 3, 0),
(2162, 258, '回民区', NULL, 3, 0),
(2163, 258, '玉泉区', NULL, 3, 0),
(2164, 258, '新城区', NULL, 3, 0),
(2165, 258, '赛罕区', NULL, 3, 0),
(2166, 258, '清水河县', NULL, 3, 0),
(2167, 258, '土默特左旗', NULL, 3, 0),
(2168, 258, '托克托县', NULL, 3, 0),
(2169, 258, '和林格尔县', NULL, 3, 0),
(2170, 258, '武川县', NULL, 3, 0),
(2171, 259, '阿拉善左旗', NULL, 3, 0),
(2172, 259, '阿拉善右旗', NULL, 3, 0),
(2173, 259, '额济纳旗', NULL, 3, 0),
(2174, 260, '临河区', NULL, 3, 0),
(2175, 260, '五原县', NULL, 3, 0),
(2176, 260, '磴口县', NULL, 3, 0),
(2177, 260, '乌拉特前旗', NULL, 3, 0),
(2178, 260, '乌拉特中旗', NULL, 3, 0),
(2179, 260, '乌拉特后旗', NULL, 3, 0),
(2180, 260, '杭锦后旗', NULL, 3, 0),
(2181, 261, '昆都仑区', NULL, 3, 0),
(2182, 261, '青山区', NULL, 3, 0),
(2183, 261, '东河区', NULL, 3, 0),
(2184, 261, '九原区', NULL, 3, 0),
(2185, 261, '石拐区', NULL, 3, 0),
(2186, 261, '白云矿区', NULL, 3, 0),
(2187, 261, '土默特右旗', NULL, 3, 0),
(2188, 261, '固阳县', NULL, 3, 0),
(2189, 261, '达尔罕茂明安联合旗', NULL, 3, 0),
(2190, 262, '红山区', NULL, 3, 0),
(2191, 262, '元宝山区', NULL, 3, 0),
(2192, 262, '松山区', NULL, 3, 0),
(2193, 262, '阿鲁科尔沁旗', NULL, 3, 0),
(2194, 262, '巴林左旗', NULL, 3, 0),
(2195, 262, '巴林右旗', NULL, 3, 0),
(2196, 262, '林西县', NULL, 3, 0),
(2197, 262, '克什克腾旗', NULL, 3, 0),
(2198, 262, '翁牛特旗', NULL, 3, 0),
(2199, 262, '喀喇沁旗', NULL, 3, 0),
(2200, 262, '宁城县', NULL, 3, 0),
(2201, 262, '敖汉旗', NULL, 3, 0),
(2202, 263, '东胜区', NULL, 3, 0),
(2203, 263, '达拉特旗', NULL, 3, 0),
(2204, 263, '准格尔旗', NULL, 3, 0),
(2205, 263, '鄂托克前旗', NULL, 3, 0),
(2206, 263, '鄂托克旗', NULL, 3, 0),
(2207, 263, '杭锦旗', NULL, 3, 0),
(2208, 263, '乌审旗', NULL, 3, 0),
(2209, 263, '伊金霍洛旗', NULL, 3, 0),
(2210, 264, '海拉尔区', NULL, 3, 0),
(2211, 264, '莫力达瓦', NULL, 3, 0),
(2212, 264, '满洲里市', NULL, 3, 0),
(2213, 264, '牙克石市', NULL, 3, 0),
(2214, 264, '扎兰屯市', NULL, 3, 0),
(2215, 264, '额尔古纳市', NULL, 3, 0),
(2216, 264, '根河市', NULL, 3, 0),
(2217, 264, '阿荣旗', NULL, 3, 0),
(2218, 264, '鄂伦春自治旗', NULL, 3, 0),
(2219, 264, '鄂温克族自治旗', NULL, 3, 0),
(2220, 264, '陈巴尔虎旗', NULL, 3, 0),
(2221, 264, '新巴尔虎左旗', NULL, 3, 0),
(2222, 264, '新巴尔虎右旗', NULL, 3, 0),
(2223, 265, '科尔沁区', NULL, 3, 0),
(2224, 265, '霍林郭勒市', NULL, 3, 0),
(2225, 265, '科尔沁左翼中旗', NULL, 3, 0),
(2226, 265, '科尔沁左翼后旗', NULL, 3, 0),
(2227, 265, '开鲁县', NULL, 3, 0),
(2228, 265, '库伦旗', NULL, 3, 0),
(2229, 265, '奈曼旗', NULL, 3, 0),
(2230, 265, '扎鲁特旗', NULL, 3, 0),
(2231, 266, '海勃湾区', NULL, 3, 0),
(2232, 266, '乌达区', NULL, 3, 0),
(2233, 266, '海南区', NULL, 3, 0),
(2234, 267, '化德县', NULL, 3, 0),
(2235, 267, '集宁区', NULL, 3, 0),
(2236, 267, '丰镇市', NULL, 3, 0),
(2237, 267, '卓资县', NULL, 3, 0),
(2238, 267, '商都县', NULL, 3, 0),
(2239, 267, '兴和县', NULL, 3, 0),
(2240, 267, '凉城县', NULL, 3, 0),
(2241, 267, '察哈尔右翼前旗', NULL, 3, 0),
(2242, 267, '察哈尔右翼中旗', NULL, 3, 0),
(2243, 267, '察哈尔右翼后旗', NULL, 3, 0),
(2244, 267, '四子王旗', NULL, 3, 0),
(2245, 268, '二连浩特市', NULL, 3, 0),
(2246, 268, '锡林浩特市', NULL, 3, 0),
(2247, 268, '阿巴嘎旗', NULL, 3, 0),
(2248, 268, '苏尼特左旗', NULL, 3, 0),
(2249, 268, '苏尼特右旗', NULL, 3, 0),
(2250, 268, '东乌珠穆沁旗', NULL, 3, 0),
(2251, 268, '西乌珠穆沁旗', NULL, 3, 0),
(2252, 268, '太仆寺旗', NULL, 3, 0),
(2253, 268, '镶黄旗', NULL, 3, 0),
(2254, 268, '正镶白旗', NULL, 3, 0),
(2255, 268, '正蓝旗', NULL, 3, 0),
(2256, 268, '多伦县', NULL, 3, 0),
(2257, 269, '乌兰浩特市', NULL, 3, 0),
(2258, 269, '阿尔山市', NULL, 3, 0),
(2259, 269, '科尔沁右翼前旗', NULL, 3, 0),
(2260, 269, '科尔沁右翼中旗', NULL, 3, 0),
(2261, 269, '扎赉特旗', NULL, 3, 0),
(2262, 269, '突泉县', NULL, 3, 0),
(2263, 270, '西夏区', NULL, 3, 0),
(2264, 270, '金凤区', NULL, 3, 0),
(2265, 270, '兴庆区', NULL, 3, 0),
(2266, 270, '灵武市', NULL, 3, 0),
(2267, 270, '永宁县', NULL, 3, 0),
(2268, 270, '贺兰县', NULL, 3, 0),
(2269, 271, '原州区', NULL, 3, 0),
(2270, 271, '海原县', NULL, 3, 0),
(2271, 271, '西吉县', NULL, 3, 0),
(2272, 271, '隆德县', NULL, 3, 0),
(2273, 271, '泾源县', NULL, 3, 0),
(2274, 271, '彭阳县', NULL, 3, 0),
(2275, 272, '惠农县', NULL, 3, 0),
(2276, 272, '大武口区', NULL, 3, 0),
(2277, 272, '惠农区', NULL, 3, 0),
(2278, 272, '陶乐县', NULL, 3, 0),
(2279, 272, '平罗县', NULL, 3, 0),
(2280, 273, '利通区', NULL, 3, 0),
(2281, 273, '中卫县', NULL, 3, 0),
(2282, 273, '青铜峡市', NULL, 3, 0),
(2283, 273, '中宁县', NULL, 3, 0),
(2284, 273, '盐池县', NULL, 3, 0),
(2285, 273, '同心县', NULL, 3, 0),
(2286, 274, '沙坡头区', NULL, 3, 0),
(2287, 274, '海原县', NULL, 3, 0),
(2288, 274, '中宁县', NULL, 3, 0),
(2289, 275, '城中区', NULL, 3, 0),
(2290, 275, '城东区', NULL, 3, 0),
(2291, 275, '城西区', NULL, 3, 0),
(2292, 275, '城北区', NULL, 3, 0),
(2293, 275, '湟中县', NULL, 3, 0),
(2294, 275, '湟源县', NULL, 3, 0),
(2295, 275, '大通', NULL, 3, 0),
(2296, 276, '玛沁县', NULL, 3, 0),
(2297, 276, '班玛县', NULL, 3, 0),
(2298, 276, '甘德县', NULL, 3, 0),
(2299, 276, '达日县', NULL, 3, 0),
(2300, 276, '久治县', NULL, 3, 0),
(2301, 276, '玛多县', NULL, 3, 0),
(2302, 277, '海晏县', NULL, 3, 0),
(2303, 277, '祁连县', NULL, 3, 0),
(2304, 277, '刚察县', NULL, 3, 0),
(2305, 277, '门源', NULL, 3, 0),
(2306, 278, '平安县', NULL, 3, 0),
(2307, 278, '乐都县', NULL, 3, 0),
(2308, 278, '民和', NULL, 3, 0),
(2309, 278, '互助', NULL, 3, 0),
(2310, 278, '化隆', NULL, 3, 0),
(2311, 278, '循化', NULL, 3, 0),
(2312, 279, '共和县', NULL, 3, 0),
(2313, 279, '同德县', NULL, 3, 0),
(2314, 279, '贵德县', NULL, 3, 0),
(2315, 279, '兴海县', NULL, 3, 0),
(2316, 279, '贵南县', NULL, 3, 0),
(2317, 280, '德令哈市', NULL, 3, 0),
(2318, 280, '格尔木市', NULL, 3, 0),
(2319, 280, '乌兰县', NULL, 3, 0),
(2320, 280, '都兰县', NULL, 3, 0),
(2321, 280, '天峻县', NULL, 3, 0),
(2322, 281, '同仁县', NULL, 3, 0),
(2323, 281, '尖扎县', NULL, 3, 0),
(2324, 281, '泽库县', NULL, 3, 0),
(2325, 281, '河南蒙古族自治县', NULL, 3, 0),
(2326, 282, '玉树县', NULL, 3, 0),
(2327, 282, '杂多县', NULL, 3, 0),
(2328, 282, '称多县', NULL, 3, 0),
(2329, 282, '治多县', NULL, 3, 0),
(2330, 282, '囊谦县', NULL, 3, 0),
(2331, 282, '曲麻莱县', NULL, 3, 0),
(2332, 283, '市中区', NULL, 3, 0),
(2333, 283, '历下区', NULL, 3, 0),
(2334, 283, '天桥区', NULL, 3, 0),
(2335, 283, '槐荫区', NULL, 3, 0),
(2336, 283, '历城区', NULL, 3, 0),
(2337, 283, '长清区', NULL, 3, 0),
(2338, 283, '章丘市', NULL, 3, 0),
(2339, 283, '平阴县', NULL, 3, 0),
(2340, 283, '济阳县', NULL, 3, 0),
(2341, 283, '商河县', NULL, 3, 0),
(2342, 284, '市南区', NULL, 3, 0),
(2343, 284, '市北区', NULL, 3, 0),
(2344, 284, '城阳区', NULL, 3, 0),
(2345, 284, '四方区', NULL, 3, 0),
(2346, 284, '李沧区', NULL, 3, 0),
(2347, 284, '黄岛区', NULL, 3, 0),
(2348, 284, '崂山区', NULL, 3, 0),
(2349, 284, '胶州市', NULL, 3, 0),
(2350, 284, '即墨市', NULL, 3, 0),
(2351, 284, '平度市', NULL, 3, 0),
(2352, 284, '胶南市', NULL, 3, 0),
(2353, 284, '莱西市', NULL, 3, 0),
(2354, 285, '滨城区', NULL, 3, 0),
(2355, 285, '惠民县', NULL, 3, 0),
(2356, 285, '阳信县', NULL, 3, 0),
(2357, 285, '无棣县', NULL, 3, 0),
(2358, 285, '沾化县', NULL, 3, 0),
(2359, 285, '博兴县', NULL, 3, 0),
(2360, 285, '邹平县', NULL, 3, 0),
(2361, 286, '德城区', NULL, 3, 0),
(2362, 286, '陵县', NULL, 3, 0),
(2363, 286, '乐陵市', NULL, 3, 0),
(2364, 286, '禹城市', NULL, 3, 0),
(2365, 286, '宁津县', NULL, 3, 0),
(2366, 286, '庆云县', NULL, 3, 0),
(2367, 286, '临邑县', NULL, 3, 0),
(2368, 286, '齐河县', NULL, 3, 0),
(2369, 286, '平原县', NULL, 3, 0),
(2370, 286, '夏津县', NULL, 3, 0),
(2371, 286, '武城县', NULL, 3, 0),
(2372, 287, '东营区', NULL, 3, 0),
(2373, 287, '河口区', NULL, 3, 0),
(2374, 287, '垦利县', NULL, 3, 0),
(2375, 287, '利津县', NULL, 3, 0),
(2376, 287, '广饶县', NULL, 3, 0),
(2377, 288, '牡丹区', NULL, 3, 0),
(2378, 288, '曹县', NULL, 3, 0),
(2379, 288, '单县', NULL, 3, 0),
(2380, 288, '成武县', NULL, 3, 0),
(2381, 288, '巨野县', NULL, 3, 0),
(2382, 288, '郓城县', NULL, 3, 0),
(2383, 288, '鄄城县', NULL, 3, 0),
(2384, 288, '定陶县', NULL, 3, 0),
(2385, 288, '东明县', NULL, 3, 0),
(2386, 289, '市中区', NULL, 3, 0),
(2387, 289, '任城区', NULL, 3, 0),
(2388, 289, '曲阜市', NULL, 3, 0),
(2389, 289, '兖州市', NULL, 3, 0),
(2390, 289, '邹城市', NULL, 3, 0),
(2391, 289, '微山县', NULL, 3, 0),
(2392, 289, '鱼台县', NULL, 3, 0),
(2393, 289, '金乡县', NULL, 3, 0),
(2394, 289, '嘉祥县', NULL, 3, 0),
(2395, 289, '汶上县', NULL, 3, 0),
(2396, 289, '泗水县', NULL, 3, 0),
(2397, 289, '梁山县', NULL, 3, 0),
(2398, 290, '莱城区', NULL, 3, 0),
(2399, 290, '钢城区', NULL, 3, 0),
(2400, 291, '东昌府区', NULL, 3, 0),
(2401, 291, '临清市', NULL, 3, 0),
(2402, 291, '阳谷县', NULL, 3, 0),
(2403, 291, '莘县', NULL, 3, 0),
(2404, 291, '茌平县', NULL, 3, 0),
(2405, 291, '东阿县', NULL, 3, 0),
(2406, 291, '冠县', NULL, 3, 0),
(2407, 291, '高唐县', NULL, 3, 0),
(2408, 292, '兰山区', NULL, 3, 0),
(2409, 292, '罗庄区', NULL, 3, 0),
(2410, 292, '河东区', NULL, 3, 0),
(2411, 292, '沂南县', NULL, 3, 0),
(2412, 292, '郯城县', NULL, 3, 0),
(2413, 292, '沂水县', NULL, 3, 0),
(2414, 292, '苍山县', NULL, 3, 0),
(2415, 292, '费县', NULL, 3, 0),
(2416, 292, '平邑县', NULL, 3, 0),
(2417, 292, '莒南县', NULL, 3, 0),
(2418, 292, '蒙阴县', NULL, 3, 0),
(2419, 292, '临沭县', NULL, 3, 0),
(2420, 293, '东港区', NULL, 3, 0),
(2421, 293, '岚山区', NULL, 3, 0),
(2422, 293, '五莲县', NULL, 3, 0),
(2423, 293, '莒县', NULL, 3, 0),
(2424, 294, '泰山区', NULL, 3, 0),
(2425, 294, '岱岳区', NULL, 3, 0),
(2426, 294, '新泰市', NULL, 3, 0),
(2427, 294, '肥城市', NULL, 3, 0),
(2428, 294, '宁阳县', NULL, 3, 0),
(2429, 294, '东平县', NULL, 3, 0),
(2430, 295, '荣成市', NULL, 3, 0),
(2431, 295, '乳山市', NULL, 3, 0),
(2432, 295, '环翠区', NULL, 3, 0),
(2433, 295, '文登市', NULL, 3, 0),
(2434, 296, '潍城区', NULL, 3, 0),
(2435, 296, '寒亭区', NULL, 3, 0),
(2436, 296, '坊子区', NULL, 3, 0),
(2437, 296, '奎文区', NULL, 3, 0),
(2438, 296, '青州市', NULL, 3, 0),
(2439, 296, '诸城市', NULL, 3, 0),
(2440, 296, '寿光市', NULL, 3, 0),
(2441, 296, '安丘市', NULL, 3, 0),
(2442, 296, '高密市', NULL, 3, 0),
(2443, 296, '昌邑市', NULL, 3, 0),
(2444, 296, '临朐县', NULL, 3, 0),
(2445, 296, '昌乐县', NULL, 3, 0),
(2446, 297, '芝罘区', NULL, 3, 0),
(2447, 297, '福山区', NULL, 3, 0),
(2448, 297, '牟平区', NULL, 3, 0),
(2449, 297, '莱山区', NULL, 3, 0),
(2450, 297, '开发区', NULL, 3, 0),
(2451, 297, '龙口市', NULL, 3, 0),
(2452, 297, '莱阳市', NULL, 3, 0),
(2453, 297, '莱州市', NULL, 3, 0),
(2454, 297, '蓬莱市', NULL, 3, 0),
(2455, 297, '招远市', NULL, 3, 0),
(2456, 297, '栖霞市', NULL, 3, 0),
(2457, 297, '海阳市', NULL, 3, 0),
(2458, 297, '长岛县', NULL, 3, 0),
(2459, 298, '市中区', NULL, 3, 0),
(2460, 298, '山亭区', NULL, 3, 0),
(2461, 298, '峄城区', NULL, 3, 0),
(2462, 298, '台儿庄区', NULL, 3, 0),
(2463, 298, '薛城区', NULL, 3, 0),
(2464, 298, '滕州市', NULL, 3, 0),
(2465, 299, '张店区', NULL, 3, 0),
(2466, 299, '临淄区', NULL, 3, 0),
(2467, 299, '淄川区', NULL, 3, 0),
(2468, 299, '博山区', NULL, 3, 0),
(2469, 299, '周村区', NULL, 3, 0),
(2470, 299, '桓台县', NULL, 3, 0),
(2471, 299, '高青县', NULL, 3, 0),
(2472, 299, '沂源县', NULL, 3, 0),
(2473, 300, '杏花岭区', NULL, 3, 0),
(2474, 300, '小店区', NULL, 3, 0),
(2475, 300, '迎泽区', NULL, 3, 0),
(2476, 300, '尖草坪区', NULL, 3, 0),
(2477, 300, '万柏林区', NULL, 3, 0),
(2478, 300, '晋源区', NULL, 3, 0),
(2479, 300, '高新开发区', NULL, 3, 0),
(2480, 300, '民营经济开发区', NULL, 3, 0),
(2481, 300, '经济技术开发区', NULL, 3, 0),
(2482, 300, '清徐县', NULL, 3, 0),
(2483, 300, '阳曲县', NULL, 3, 0),
(2484, 300, '娄烦县', NULL, 3, 0),
(2485, 300, '古交市', NULL, 3, 0),
(2486, 301, '城区', NULL, 3, 0),
(2487, 301, '郊区', NULL, 3, 0),
(2488, 301, '沁县', NULL, 3, 0),
(2489, 301, '潞城市', NULL, 3, 0),
(2490, 301, '长治县', NULL, 3, 0),
(2491, 301, '襄垣县', NULL, 3, 0),
(2492, 301, '屯留县', NULL, 3, 0),
(2493, 301, '平顺县', NULL, 3, 0),
(2494, 301, '黎城县', NULL, 3, 0),
(2495, 301, '壶关县', NULL, 3, 0),
(2496, 301, '长子县', NULL, 3, 0),
(2497, 301, '武乡县', NULL, 3, 0),
(2498, 301, '沁源县', NULL, 3, 0),
(2499, 302, '城区', NULL, 3, 0),
(2500, 302, '矿区', NULL, 3, 0),
(2501, 302, '南郊区', NULL, 3, 0),
(2502, 302, '新荣区', NULL, 3, 0),
(2503, 302, '阳高县', NULL, 3, 0),
(2504, 302, '天镇县', NULL, 3, 0),
(2505, 302, '广灵县', NULL, 3, 0),
(2506, 302, '灵丘县', NULL, 3, 0),
(2507, 302, '浑源县', NULL, 3, 0),
(2508, 302, '左云县', NULL, 3, 0),
(2509, 302, '大同县', NULL, 3, 0),
(2510, 303, '城区', NULL, 3, 0),
(2511, 303, '高平市', NULL, 3, 0),
(2512, 303, '沁水县', NULL, 3, 0),
(2513, 303, '阳城县', NULL, 3, 0),
(2514, 303, '陵川县', NULL, 3, 0),
(2515, 303, '泽州县', NULL, 3, 0),
(2516, 304, '榆次区', NULL, 3, 0),
(2517, 304, '介休市', NULL, 3, 0),
(2518, 304, '榆社县', NULL, 3, 0),
(2519, 304, '左权县', NULL, 3, 0),
(2520, 304, '和顺县', NULL, 3, 0),
(2521, 304, '昔阳县', NULL, 3, 0),
(2522, 304, '寿阳县', NULL, 3, 0),
(2523, 304, '太谷县', NULL, 3, 0),
(2524, 304, '祁县', NULL, 3, 0),
(2525, 304, '平遥县', NULL, 3, 0),
(2526, 304, '灵石县', NULL, 3, 0),
(2527, 305, '尧都区', NULL, 3, 0),
(2528, 305, '侯马市', NULL, 3, 0),
(2529, 305, '霍州市', NULL, 3, 0),
(2530, 305, '曲沃县', NULL, 3, 0),
(2531, 305, '翼城县', NULL, 3, 0),
(2532, 305, '襄汾县', NULL, 3, 0),
(2533, 305, '洪洞县', NULL, 3, 0),
(2534, 305, '吉县', NULL, 3, 0),
(2535, 305, '安泽县', NULL, 3, 0),
(2536, 305, '浮山县', NULL, 3, 0),
(2537, 305, '古县', NULL, 3, 0),
(2538, 305, '乡宁县', NULL, 3, 0),
(2539, 305, '大宁县', NULL, 3, 0),
(2540, 305, '隰县', NULL, 3, 0),
(2541, 305, '永和县', NULL, 3, 0),
(2542, 305, '蒲县', NULL, 3, 0),
(2543, 305, '汾西县', NULL, 3, 0),
(2544, 306, '离石市', NULL, 3, 0),
(2545, 306, '离石区', NULL, 3, 0),
(2546, 306, '孝义市', NULL, 3, 0),
(2547, 306, '汾阳市', NULL, 3, 0),
(2548, 306, '文水县', NULL, 3, 0),
(2549, 306, '交城县', NULL, 3, 0),
(2550, 306, '兴县', NULL, 3, 0),
(2551, 306, '临县', NULL, 3, 0),
(2552, 306, '柳林县', NULL, 3, 0),
(2553, 306, '石楼县', NULL, 3, 0),
(2554, 306, '岚县', NULL, 3, 0),
(2555, 306, '方山县', NULL, 3, 0),
(2556, 306, '中阳县', NULL, 3, 0),
(2557, 306, '交口县', NULL, 3, 0),
(2558, 307, '朔城区', NULL, 3, 0),
(2559, 307, '平鲁区', NULL, 3, 0),
(2560, 307, '山阴县', NULL, 3, 0),
(2561, 307, '应县', NULL, 3, 0),
(2562, 307, '右玉县', NULL, 3, 0),
(2563, 307, '怀仁县', NULL, 3, 0),
(2564, 308, '忻府区', NULL, 3, 0),
(2565, 308, '原平市', NULL, 3, 0),
(2566, 308, '定襄县', NULL, 3, 0),
(2567, 308, '五台县', NULL, 3, 0),
(2568, 308, '代县', NULL, 3, 0),
(2569, 308, '繁峙县', NULL, 3, 0),
(2570, 308, '宁武县', NULL, 3, 0),
(2571, 308, '静乐县', NULL, 3, 0),
(2572, 308, '神池县', NULL, 3, 0),
(2573, 308, '五寨县', NULL, 3, 0),
(2574, 308, '岢岚县', NULL, 3, 0),
(2575, 308, '河曲县', NULL, 3, 0),
(2576, 308, '保德县', NULL, 3, 0),
(2577, 308, '偏关县', NULL, 3, 0),
(2578, 309, '城区', NULL, 3, 0),
(2579, 309, '矿区', NULL, 3, 0),
(2580, 309, '郊区', NULL, 3, 0),
(2581, 309, '平定县', NULL, 3, 0),
(2582, 309, '盂县', NULL, 3, 0),
(2583, 310, '盐湖区', NULL, 3, 0),
(2584, 310, '永济市', NULL, 3, 0),
(2585, 310, '河津市', NULL, 3, 0),
(2586, 310, '临猗县', NULL, 3, 0),
(2587, 310, '万荣县', NULL, 3, 0),
(2588, 310, '闻喜县', NULL, 3, 0),
(2589, 310, '稷山县', NULL, 3, 0),
(2590, 310, '新绛县', NULL, 3, 0),
(2591, 310, '绛县', NULL, 3, 0),
(2592, 310, '垣曲县', NULL, 3, 0),
(2593, 310, '夏县', NULL, 3, 0),
(2594, 310, '平陆县', NULL, 3, 0),
(2595, 310, '芮城县', NULL, 3, 0),
(2596, 311, '莲湖区', NULL, 3, 0),
(2597, 311, '新城区', NULL, 3, 0),
(2598, 311, '碑林区', NULL, 3, 0),
(2599, 311, '雁塔区', NULL, 3, 0),
(2600, 311, '灞桥区', NULL, 3, 0),
(2601, 311, '未央区', NULL, 3, 0),
(2602, 311, '阎良区', NULL, 3, 0),
(2603, 311, '临潼区', NULL, 3, 0),
(2604, 311, '长安区', NULL, 3, 0),
(2605, 311, '蓝田县', NULL, 3, 0),
(2606, 311, '周至县', NULL, 3, 0),
(2607, 311, '户县', NULL, 3, 0),
(2608, 311, '高陵县', NULL, 3, 0),
(2609, 312, '汉滨区', NULL, 3, 0),
(2610, 312, '汉阴县', NULL, 3, 0),
(2611, 312, '石泉县', NULL, 3, 0),
(2612, 312, '宁陕县', NULL, 3, 0),
(2613, 312, '紫阳县', NULL, 3, 0),
(2614, 312, '岚皋县', NULL, 3, 0),
(2615, 312, '平利县', NULL, 3, 0),
(2616, 312, '镇坪县', NULL, 3, 0),
(2617, 312, '旬阳县', NULL, 3, 0),
(2618, 312, '白河县', NULL, 3, 0),
(2619, 313, '陈仓区', NULL, 3, 0),
(2620, 313, '渭滨区', NULL, 3, 0),
(2621, 313, '金台区', NULL, 3, 0),
(2622, 313, '凤翔县', NULL, 3, 0),
(2623, 313, '岐山县', NULL, 3, 0),
(2624, 313, '扶风县', NULL, 3, 0),
(2625, 313, '眉县', NULL, 3, 0),
(2626, 313, '陇县', NULL, 3, 0),
(2627, 313, '千阳县', NULL, 3, 0),
(2628, 313, '麟游县', NULL, 3, 0),
(2629, 313, '凤县', NULL, 3, 0),
(2630, 313, '太白县', NULL, 3, 0),
(2631, 314, '汉台区', NULL, 3, 0),
(2632, 314, '南郑县', NULL, 3, 0),
(2633, 314, '城固县', NULL, 3, 0),
(2634, 314, '洋县', NULL, 3, 0),
(2635, 314, '西乡县', NULL, 3, 0),
(2636, 314, '勉县', NULL, 3, 0),
(2637, 314, '宁强县', NULL, 3, 0),
(2638, 314, '略阳县', NULL, 3, 0),
(2639, 314, '镇巴县', NULL, 3, 0),
(2640, 314, '留坝县', NULL, 3, 0),
(2641, 314, '佛坪县', NULL, 3, 0),
(2642, 315, '商州区', NULL, 3, 0),
(2643, 315, '洛南县', NULL, 3, 0),
(2644, 315, '丹凤县', NULL, 3, 0),
(2645, 315, '商南县', NULL, 3, 0),
(2646, 315, '山阳县', NULL, 3, 0),
(2647, 315, '镇安县', NULL, 3, 0),
(2648, 315, '柞水县', NULL, 3, 0),
(2649, 316, '耀州区', NULL, 3, 0),
(2650, 316, '王益区', NULL, 3, 0),
(2651, 316, '印台区', NULL, 3, 0),
(2652, 316, '宜君县', NULL, 3, 0),
(2653, 317, '临渭区', NULL, 3, 0),
(2654, 317, '韩城市', NULL, 3, 0),
(2655, 317, '华阴市', NULL, 3, 0),
(2656, 317, '华县', NULL, 3, 0),
(2657, 317, '潼关县', NULL, 3, 0),
(2658, 317, '大荔县', NULL, 3, 0),
(2659, 317, '合阳县', NULL, 3, 0),
(2660, 317, '澄城县', NULL, 3, 0),
(2661, 317, '蒲城县', NULL, 3, 0),
(2662, 317, '白水县', NULL, 3, 0),
(2663, 317, '富平县', NULL, 3, 0),
(2664, 318, '秦都区', NULL, 3, 0),
(2665, 318, '渭城区', NULL, 3, 0),
(2666, 318, '杨陵区', NULL, 3, 0),
(2667, 318, '兴平市', NULL, 3, 0),
(2668, 318, '三原县', NULL, 3, 0),
(2669, 318, '泾阳县', NULL, 3, 0),
(2670, 318, '乾县', NULL, 3, 0),
(2671, 318, '礼泉县', NULL, 3, 0),
(2672, 318, '永寿县', NULL, 3, 0),
(2673, 318, '彬县', NULL, 3, 0),
(2674, 318, '长武县', NULL, 3, 0),
(2675, 318, '旬邑县', NULL, 3, 0),
(2676, 318, '淳化县', NULL, 3, 0),
(2677, 318, '武功县', NULL, 3, 0),
(2678, 319, '吴起县', NULL, 3, 0),
(2679, 319, '宝塔区', NULL, 3, 0),
(2680, 319, '延长县', NULL, 3, 0),
(2681, 319, '延川县', NULL, 3, 0),
(2682, 319, '子长县', NULL, 3, 0),
(2683, 319, '安塞县', NULL, 3, 0),
(2684, 319, '志丹县', NULL, 3, 0),
(2685, 319, '甘泉县', NULL, 3, 0),
(2686, 319, '富县', NULL, 3, 0),
(2687, 319, '洛川县', NULL, 3, 0),
(2688, 319, '宜川县', NULL, 3, 0),
(2689, 319, '黄龙县', NULL, 3, 0),
(2690, 319, '黄陵县', NULL, 3, 0),
(2691, 320, '榆阳区', NULL, 3, 0),
(2692, 320, '神木县', NULL, 3, 0),
(2693, 320, '府谷县', NULL, 3, 0),
(2694, 320, '横山县', NULL, 3, 0),
(2695, 320, '靖边县', NULL, 3, 0),
(2696, 320, '定边县', NULL, 3, 0),
(2697, 320, '绥德县', NULL, 3, 0),
(2698, 320, '米脂县', NULL, 3, 0),
(2699, 320, '佳县', NULL, 3, 0),
(2700, 320, '吴堡县', NULL, 3, 0),
(2701, 320, '清涧县', NULL, 3, 0),
(2702, 320, '子洲县', NULL, 3, 0),
(2703, 321, '长宁区', NULL, 3, 0),
(2704, 321, '闸北区', NULL, 3, 0),
(2705, 321, '闵行区', NULL, 3, 0),
(2706, 321, '徐汇区', NULL, 3, 0),
(2707, 321, '浦东新区', NULL, 3, 0),
(2708, 321, '杨浦区', NULL, 3, 0),
(2709, 321, '普陀区', NULL, 3, 0),
(2710, 321, '静安区', NULL, 3, 0),
(2711, 321, '卢湾区', NULL, 3, 0),
(2712, 321, '虹口区', NULL, 3, 0),
(2713, 321, '黄浦区', NULL, 3, 0),
(2714, 321, '南汇区', NULL, 3, 0),
(2715, 321, '松江区', NULL, 3, 0),
(2716, 321, '嘉定区', NULL, 3, 0),
(2717, 321, '宝山区', NULL, 3, 0),
(2718, 321, '青浦区', NULL, 3, 0),
(2719, 321, '金山区', NULL, 3, 0),
(2720, 321, '奉贤区', NULL, 3, 0),
(2721, 321, '崇明县', NULL, 3, 0),
(2722, 322, '青羊区', NULL, 3, 0),
(2723, 322, '锦江区', NULL, 3, 0),
(2724, 322, '金牛区', NULL, 3, 0),
(2725, 322, '武侯区', NULL, 3, 0),
(2726, 322, '成华区', NULL, 3, 0),
(2727, 322, '龙泉驿区', NULL, 3, 0),
(2728, 322, '青白江区', NULL, 3, 0),
(2729, 322, '新都区', NULL, 3, 0),
(2730, 322, '温江区', NULL, 3, 0),
(2731, 322, '高新区', NULL, 3, 0),
(2732, 322, '高新西区', NULL, 3, 0),
(2733, 322, '都江堰市', NULL, 3, 0),
(2734, 322, '彭州市', NULL, 3, 0),
(2735, 322, '邛崃市', NULL, 3, 0),
(2736, 322, '崇州市', NULL, 3, 0),
(2737, 322, '金堂县', NULL, 3, 0),
(2738, 322, '双流县', NULL, 3, 0),
(2739, 322, '郫县', NULL, 3, 0),
(2740, 322, '大邑县', NULL, 3, 0),
(2741, 322, '蒲江县', NULL, 3, 0),
(2742, 322, '新津县', NULL, 3, 0),
(2743, 322, '都江堰市', NULL, 3, 0),
(2744, 322, '彭州市', NULL, 3, 0),
(2745, 322, '邛崃市', NULL, 3, 0),
(2746, 322, '崇州市', NULL, 3, 0),
(2747, 322, '金堂县', NULL, 3, 0),
(2748, 322, '双流县', NULL, 3, 0),
(2749, 322, '郫县', NULL, 3, 0),
(2750, 322, '大邑县', NULL, 3, 0),
(2751, 322, '蒲江县', NULL, 3, 0),
(2752, 322, '新津县', NULL, 3, 0),
(2753, 323, '涪城区', NULL, 3, 0),
(2754, 323, '游仙区', NULL, 3, 0),
(2755, 323, '江油市', NULL, 3, 0),
(2756, 323, '盐亭县', NULL, 3, 0),
(2757, 323, '三台县', NULL, 3, 0),
(2758, 323, '平武县', NULL, 3, 0),
(2759, 323, '安县', NULL, 3, 0),
(2760, 323, '梓潼县', NULL, 3, 0),
(2761, 323, '北川县', NULL, 3, 0),
(2762, 324, '马尔康县', NULL, 3, 0),
(2763, 324, '汶川县', NULL, 3, 0),
(2764, 324, '理县', NULL, 3, 0),
(2765, 324, '茂县', NULL, 3, 0),
(2766, 324, '松潘县', NULL, 3, 0),
(2767, 324, '九寨沟县', NULL, 3, 0),
(2768, 324, '金川县', NULL, 3, 0),
(2769, 324, '小金县', NULL, 3, 0),
(2770, 324, '黑水县', NULL, 3, 0),
(2771, 324, '壤塘县', NULL, 3, 0),
(2772, 324, '阿坝县', NULL, 3, 0),
(2773, 324, '若尔盖县', NULL, 3, 0),
(2774, 324, '红原县', NULL, 3, 0),
(2775, 325, '巴州区', NULL, 3, 0),
(2776, 325, '通江县', NULL, 3, 0),
(2777, 325, '南江县', NULL, 3, 0),
(2778, 325, '平昌县', NULL, 3, 0),
(2779, 326, '通川区', NULL, 3, 0),
(2780, 326, '万源市', NULL, 3, 0),
(2781, 326, '达县', NULL, 3, 0),
(2782, 326, '宣汉县', NULL, 3, 0),
(2783, 326, '开江县', NULL, 3, 0),
(2784, 326, '大竹县', NULL, 3, 0),
(2785, 326, '渠县', NULL, 3, 0),
(2786, 327, '旌阳区', NULL, 3, 0),
(2787, 327, '广汉市', NULL, 3, 0),
(2788, 327, '什邡市', NULL, 3, 0),
(2789, 327, '绵竹市', NULL, 3, 0),
(2790, 327, '罗江县', NULL, 3, 0),
(2791, 327, '中江县', NULL, 3, 0),
(2792, 328, '康定县', NULL, 3, 0),
(2793, 328, '丹巴县', NULL, 3, 0),
(2794, 328, '泸定县', NULL, 3, 0),
(2795, 328, '炉霍县', NULL, 3, 0),
(2796, 328, '九龙县', NULL, 3, 0),
(2797, 328, '甘孜县', NULL, 3, 0),
(2798, 328, '雅江县', NULL, 3, 0),
(2799, 328, '新龙县', NULL, 3, 0),
(2800, 328, '道孚县', NULL, 3, 0),
(2801, 328, '白玉县', NULL, 3, 0),
(2802, 328, '理塘县', NULL, 3, 0),
(2803, 328, '德格县', NULL, 3, 0),
(2804, 328, '乡城县', NULL, 3, 0),
(2805, 328, '石渠县', NULL, 3, 0),
(2806, 328, '稻城县', NULL, 3, 0),
(2807, 328, '色达县', NULL, 3, 0),
(2808, 328, '巴塘县', NULL, 3, 0),
(2809, 328, '得荣县', NULL, 3, 0),
(2810, 329, '广安区', NULL, 3, 0),
(2811, 329, '华蓥市', NULL, 3, 0),
(2812, 329, '岳池县', NULL, 3, 0),
(2813, 329, '武胜县', NULL, 3, 0),
(2814, 329, '邻水县', NULL, 3, 0),
(2815, 330, '利州区', NULL, 3, 0),
(2816, 330, '元坝区', NULL, 3, 0),
(2817, 330, '朝天区', NULL, 3, 0),
(2818, 330, '旺苍县', NULL, 3, 0),
(2819, 330, '青川县', NULL, 3, 0),
(2820, 330, '剑阁县', NULL, 3, 0),
(2821, 330, '苍溪县', NULL, 3, 0),
(2822, 331, '峨眉山市', NULL, 3, 0),
(2823, 331, '乐山市', NULL, 3, 0),
(2824, 331, '犍为县', NULL, 3, 0),
(2825, 331, '井研县', NULL, 3, 0),
(2826, 331, '夹江县', NULL, 3, 0),
(2827, 331, '沐川县', NULL, 3, 0),
(2828, 331, '峨边', NULL, 3, 0),
(2829, 331, '马边', NULL, 3, 0),
(2830, 332, '西昌市', NULL, 3, 0),
(2831, 332, '盐源县', NULL, 3, 0),
(2832, 332, '德昌县', NULL, 3, 0),
(2833, 332, '会理县', NULL, 3, 0),
(2834, 332, '会东县', NULL, 3, 0),
(2835, 332, '宁南县', NULL, 3, 0),
(2836, 332, '普格县', NULL, 3, 0),
(2837, 332, '布拖县', NULL, 3, 0),
(2838, 332, '金阳县', NULL, 3, 0),
(2839, 332, '昭觉县', NULL, 3, 0),
(2840, 332, '喜德县', NULL, 3, 0),
(2841, 332, '冕宁县', NULL, 3, 0),
(2842, 332, '越西县', NULL, 3, 0),
(2843, 332, '甘洛县', NULL, 3, 0),
(2844, 332, '美姑县', NULL, 3, 0),
(2845, 332, '雷波县', NULL, 3, 0),
(2846, 332, '木里', NULL, 3, 0);
INSERT INTO `nitc_region` (`region_id`, `parent_id`, `region_name`, `iso_code_2`, `region_type`, `agency_id`) VALUES
(2847, 333, '东坡区', NULL, 3, 0),
(2848, 333, '仁寿县', NULL, 3, 0),
(2849, 333, '彭山县', NULL, 3, 0),
(2850, 333, '洪雅县', NULL, 3, 0),
(2851, 333, '丹棱县', NULL, 3, 0),
(2852, 333, '青神县', NULL, 3, 0),
(2853, 334, '阆中市', NULL, 3, 0),
(2854, 334, '南部县', NULL, 3, 0),
(2855, 334, '营山县', NULL, 3, 0),
(2856, 334, '蓬安县', NULL, 3, 0),
(2857, 334, '仪陇县', NULL, 3, 0),
(2858, 334, '顺庆区', NULL, 3, 0),
(2859, 334, '高坪区', NULL, 3, 0),
(2860, 334, '嘉陵区', NULL, 3, 0),
(2861, 334, '西充县', NULL, 3, 0),
(2862, 335, '市中区', NULL, 3, 0),
(2863, 335, '东兴区', NULL, 3, 0),
(2864, 335, '威远县', NULL, 3, 0),
(2865, 335, '资中县', NULL, 3, 0),
(2866, 335, '隆昌县', NULL, 3, 0),
(2867, 336, '东  区', NULL, 3, 0),
(2868, 336, '西  区', NULL, 3, 0),
(2869, 336, '仁和区', NULL, 3, 0),
(2870, 336, '米易县', NULL, 3, 0),
(2871, 336, '盐边县', NULL, 3, 0),
(2872, 337, '船山区', NULL, 3, 0),
(2873, 337, '安居区', NULL, 3, 0),
(2874, 337, '蓬溪县', NULL, 3, 0),
(2875, 337, '射洪县', NULL, 3, 0),
(2876, 337, '大英县', NULL, 3, 0),
(2877, 338, '雨城区', NULL, 3, 0),
(2878, 338, '名山县', NULL, 3, 0),
(2879, 338, '荥经县', NULL, 3, 0),
(2880, 338, '汉源县', NULL, 3, 0),
(2881, 338, '石棉县', NULL, 3, 0),
(2882, 338, '天全县', NULL, 3, 0),
(2883, 338, '芦山县', NULL, 3, 0),
(2884, 338, '宝兴县', NULL, 3, 0),
(2885, 339, '翠屏区', NULL, 3, 0),
(2886, 339, '宜宾县', NULL, 3, 0),
(2887, 339, '南溪县', NULL, 3, 0),
(2888, 339, '江安县', NULL, 3, 0),
(2889, 339, '长宁县', NULL, 3, 0),
(2890, 339, '高县', NULL, 3, 0),
(2891, 339, '珙县', NULL, 3, 0),
(2892, 339, '筠连县', NULL, 3, 0),
(2893, 339, '兴文县', NULL, 3, 0),
(2894, 339, '屏山县', NULL, 3, 0),
(2895, 340, '雁江区', NULL, 3, 0),
(2896, 340, '简阳市', NULL, 3, 0),
(2897, 340, '安岳县', NULL, 3, 0),
(2898, 340, '乐至县', NULL, 3, 0),
(2899, 341, '大安区', NULL, 3, 0),
(2900, 341, '自流井区', NULL, 3, 0),
(2901, 341, '贡井区', NULL, 3, 0),
(2902, 341, '沿滩区', NULL, 3, 0),
(2903, 341, '荣县', NULL, 3, 0),
(2904, 341, '富顺县', NULL, 3, 0),
(2905, 342, '江阳区', NULL, 3, 0),
(2906, 342, '纳溪区', NULL, 3, 0),
(2907, 342, '龙马潭区', NULL, 3, 0),
(2908, 342, '泸县', NULL, 3, 0),
(2909, 342, '合江县', NULL, 3, 0),
(2910, 342, '叙永县', NULL, 3, 0),
(2911, 342, '古蔺县', NULL, 3, 0),
(2912, 343, '和平区', NULL, 3, 0),
(2913, 343, '河西区', NULL, 3, 0),
(2914, 343, '南开区', NULL, 3, 0),
(2915, 343, '河北区', NULL, 3, 0),
(2916, 343, '河东区', NULL, 3, 0),
(2917, 343, '红桥区', NULL, 3, 0),
(2918, 343, '东丽区', NULL, 3, 0),
(2919, 343, '津南区', NULL, 3, 0),
(2920, 343, '西青区', NULL, 3, 0),
(2921, 343, '北辰区', NULL, 3, 0),
(2922, 343, '塘沽区', NULL, 3, 0),
(2923, 343, '汉沽区', NULL, 3, 0),
(2924, 343, '大港区', NULL, 3, 0),
(2925, 343, '武清区', NULL, 3, 0),
(2926, 343, '宝坻区', NULL, 3, 0),
(2927, 343, '经济开发区', NULL, 3, 0),
(2928, 343, '宁河县', NULL, 3, 0),
(2929, 343, '静海县', NULL, 3, 0),
(2930, 343, '蓟县', NULL, 3, 0),
(2931, 344, '城关区', NULL, 3, 0),
(2932, 344, '林周县', NULL, 3, 0),
(2933, 344, '当雄县', NULL, 3, 0),
(2934, 344, '尼木县', NULL, 3, 0),
(2935, 344, '曲水县', NULL, 3, 0),
(2936, 344, '堆龙德庆县', NULL, 3, 0),
(2937, 344, '达孜县', NULL, 3, 0),
(2938, 344, '墨竹工卡县', NULL, 3, 0),
(2939, 345, '噶尔县', NULL, 3, 0),
(2940, 345, '普兰县', NULL, 3, 0),
(2941, 345, '札达县', NULL, 3, 0),
(2942, 345, '日土县', NULL, 3, 0),
(2943, 345, '革吉县', NULL, 3, 0),
(2944, 345, '改则县', NULL, 3, 0),
(2945, 345, '措勤县', NULL, 3, 0),
(2946, 346, '昌都县', NULL, 3, 0),
(2947, 346, '江达县', NULL, 3, 0),
(2948, 346, '贡觉县', NULL, 3, 0),
(2949, 346, '类乌齐县', NULL, 3, 0),
(2950, 346, '丁青县', NULL, 3, 0),
(2951, 346, '察雅县', NULL, 3, 0),
(2952, 346, '八宿县', NULL, 3, 0),
(2953, 346, '左贡县', NULL, 3, 0),
(2954, 346, '芒康县', NULL, 3, 0),
(2955, 346, '洛隆县', NULL, 3, 0),
(2956, 346, '边坝县', NULL, 3, 0),
(2957, 347, '林芝县', NULL, 3, 0),
(2958, 347, '工布江达县', NULL, 3, 0),
(2959, 347, '米林县', NULL, 3, 0),
(2960, 347, '墨脱县', NULL, 3, 0),
(2961, 347, '波密县', NULL, 3, 0),
(2962, 347, '察隅县', NULL, 3, 0),
(2963, 347, '朗县', NULL, 3, 0),
(2964, 348, '那曲县', NULL, 3, 0),
(2965, 348, '嘉黎县', NULL, 3, 0),
(2966, 348, '比如县', NULL, 3, 0),
(2967, 348, '聂荣县', NULL, 3, 0),
(2968, 348, '安多县', NULL, 3, 0),
(2969, 348, '申扎县', NULL, 3, 0),
(2970, 348, '索县', NULL, 3, 0),
(2971, 348, '班戈县', NULL, 3, 0),
(2972, 348, '巴青县', NULL, 3, 0),
(2973, 348, '尼玛县', NULL, 3, 0),
(2974, 349, '日喀则市', NULL, 3, 0),
(2975, 349, '南木林县', NULL, 3, 0),
(2976, 349, '江孜县', NULL, 3, 0),
(2977, 349, '定日县', NULL, 3, 0),
(2978, 349, '萨迦县', NULL, 3, 0),
(2979, 349, '拉孜县', NULL, 3, 0),
(2980, 349, '昂仁县', NULL, 3, 0),
(2981, 349, '谢通门县', NULL, 3, 0),
(2982, 349, '白朗县', NULL, 3, 0),
(2983, 349, '仁布县', NULL, 3, 0),
(2984, 349, '康马县', NULL, 3, 0),
(2985, 349, '定结县', NULL, 3, 0),
(2986, 349, '仲巴县', NULL, 3, 0),
(2987, 349, '亚东县', NULL, 3, 0),
(2988, 349, '吉隆县', NULL, 3, 0),
(2989, 349, '聂拉木县', NULL, 3, 0),
(2990, 349, '萨嘎县', NULL, 3, 0),
(2991, 349, '岗巴县', NULL, 3, 0),
(2992, 350, '乃东县', NULL, 3, 0),
(2993, 350, '扎囊县', NULL, 3, 0),
(2994, 350, '贡嘎县', NULL, 3, 0),
(2995, 350, '桑日县', NULL, 3, 0),
(2996, 350, '琼结县', NULL, 3, 0),
(2997, 350, '曲松县', NULL, 3, 0),
(2998, 350, '措美县', NULL, 3, 0),
(2999, 350, '洛扎县', NULL, 3, 0),
(3000, 350, '加查县', NULL, 3, 0),
(3001, 350, '隆子县', NULL, 3, 0),
(3002, 350, '错那县', NULL, 3, 0),
(3003, 350, '浪卡子县', NULL, 3, 0),
(3004, 351, '天山区', NULL, 3, 0),
(3005, 351, '沙依巴克区', NULL, 3, 0),
(3006, 351, '新市区', NULL, 3, 0),
(3007, 351, '水磨沟区', NULL, 3, 0),
(3008, 351, '头屯河区', NULL, 3, 0),
(3009, 351, '达坂城区', NULL, 3, 0),
(3010, 351, '米东区', NULL, 3, 0),
(3011, 351, '乌鲁木齐县', NULL, 3, 0),
(3012, 352, '阿克苏市', NULL, 3, 0),
(3013, 352, '温宿县', NULL, 3, 0),
(3014, 352, '库车县', NULL, 3, 0),
(3015, 352, '沙雅县', NULL, 3, 0),
(3016, 352, '新和县', NULL, 3, 0),
(3017, 352, '拜城县', NULL, 3, 0),
(3018, 352, '乌什县', NULL, 3, 0),
(3019, 352, '阿瓦提县', NULL, 3, 0),
(3020, 352, '柯坪县', NULL, 3, 0),
(3021, 353, '阿拉尔市', NULL, 3, 0),
(3022, 354, '库尔勒市', NULL, 3, 0),
(3023, 354, '轮台县', NULL, 3, 0),
(3024, 354, '尉犁县', NULL, 3, 0),
(3025, 354, '若羌县', NULL, 3, 0),
(3026, 354, '且末县', NULL, 3, 0),
(3027, 354, '焉耆', NULL, 3, 0),
(3028, 354, '和静县', NULL, 3, 0),
(3029, 354, '和硕县', NULL, 3, 0),
(3030, 354, '博湖县', NULL, 3, 0),
(3031, 355, '博乐市', NULL, 3, 0),
(3032, 355, '精河县', NULL, 3, 0),
(3033, 355, '温泉县', NULL, 3, 0),
(3034, 356, '呼图壁县', NULL, 3, 0),
(3035, 356, '米泉市', NULL, 3, 0),
(3036, 356, '昌吉市', NULL, 3, 0),
(3037, 356, '阜康市', NULL, 3, 0),
(3038, 356, '玛纳斯县', NULL, 3, 0),
(3039, 356, '奇台县', NULL, 3, 0),
(3040, 356, '吉木萨尔县', NULL, 3, 0),
(3041, 356, '木垒', NULL, 3, 0),
(3042, 357, '哈密市', NULL, 3, 0),
(3043, 357, '伊吾县', NULL, 3, 0),
(3044, 357, '巴里坤', NULL, 3, 0),
(3045, 358, '和田市', NULL, 3, 0),
(3046, 358, '和田县', NULL, 3, 0),
(3047, 358, '墨玉县', NULL, 3, 0),
(3048, 358, '皮山县', NULL, 3, 0),
(3049, 358, '洛浦县', NULL, 3, 0),
(3050, 358, '策勒县', NULL, 3, 0),
(3051, 358, '于田县', NULL, 3, 0),
(3052, 358, '民丰县', NULL, 3, 0),
(3053, 359, '喀什市', NULL, 3, 0),
(3054, 359, '疏附县', NULL, 3, 0),
(3055, 359, '疏勒县', NULL, 3, 0),
(3056, 359, '英吉沙县', NULL, 3, 0),
(3057, 359, '泽普县', NULL, 3, 0),
(3058, 359, '莎车县', NULL, 3, 0),
(3059, 359, '叶城县', NULL, 3, 0),
(3060, 359, '麦盖提县', NULL, 3, 0),
(3061, 359, '岳普湖县', NULL, 3, 0),
(3062, 359, '伽师县', NULL, 3, 0),
(3063, 359, '巴楚县', NULL, 3, 0),
(3064, 359, '塔什库尔干', NULL, 3, 0),
(3065, 360, '克拉玛依市', NULL, 3, 0),
(3066, 361, '阿图什市', NULL, 3, 0),
(3067, 361, '阿克陶县', NULL, 3, 0),
(3068, 361, '阿合奇县', NULL, 3, 0),
(3069, 361, '乌恰县', NULL, 3, 0),
(3070, 362, '石河子市', NULL, 3, 0),
(3071, 363, '图木舒克市', NULL, 3, 0),
(3072, 364, '吐鲁番市', NULL, 3, 0),
(3073, 364, '鄯善县', NULL, 3, 0),
(3074, 364, '托克逊县', NULL, 3, 0),
(3075, 365, '五家渠市', NULL, 3, 0),
(3076, 366, '阿勒泰市', NULL, 3, 0),
(3077, 366, '布克赛尔', NULL, 3, 0),
(3078, 366, '伊宁市', NULL, 3, 0),
(3079, 366, '布尔津县', NULL, 3, 0),
(3080, 366, '奎屯市', NULL, 3, 0),
(3081, 366, '乌苏市', NULL, 3, 0),
(3082, 366, '额敏县', NULL, 3, 0),
(3083, 366, '富蕴县', NULL, 3, 0),
(3084, 366, '伊宁县', NULL, 3, 0),
(3085, 366, '福海县', NULL, 3, 0),
(3086, 366, '霍城县', NULL, 3, 0),
(3087, 366, '沙湾县', NULL, 3, 0),
(3088, 366, '巩留县', NULL, 3, 0),
(3089, 366, '哈巴河县', NULL, 3, 0),
(3090, 366, '托里县', NULL, 3, 0),
(3091, 366, '青河县', NULL, 3, 0),
(3092, 366, '新源县', NULL, 3, 0),
(3093, 366, '裕民县', NULL, 3, 0),
(3094, 366, '和布克赛尔', NULL, 3, 0),
(3095, 366, '吉木乃县', NULL, 3, 0),
(3096, 366, '昭苏县', NULL, 3, 0),
(3097, 366, '特克斯县', NULL, 3, 0),
(3098, 366, '尼勒克县', NULL, 3, 0),
(3099, 366, '察布查尔', NULL, 3, 0),
(3100, 367, '盘龙区', NULL, 3, 0),
(3101, 367, '五华区', NULL, 3, 0),
(3102, 367, '官渡区', NULL, 3, 0),
(3103, 367, '西山区', NULL, 3, 0),
(3104, 367, '东川区', NULL, 3, 0),
(3105, 367, '安宁市', NULL, 3, 0),
(3106, 367, '呈贡县', NULL, 3, 0),
(3107, 367, '晋宁县', NULL, 3, 0),
(3108, 367, '富民县', NULL, 3, 0),
(3109, 367, '宜良县', NULL, 3, 0),
(3110, 367, '嵩明县', NULL, 3, 0),
(3111, 367, '石林县', NULL, 3, 0),
(3112, 367, '禄劝', NULL, 3, 0),
(3113, 367, '寻甸', NULL, 3, 0),
(3114, 368, '兰坪', NULL, 3, 0),
(3115, 368, '泸水县', NULL, 3, 0),
(3116, 368, '福贡县', NULL, 3, 0),
(3117, 368, '贡山', NULL, 3, 0),
(3118, 369, '宁洱', NULL, 3, 0),
(3119, 369, '思茅区', NULL, 3, 0),
(3120, 369, '墨江', NULL, 3, 0),
(3121, 369, '景东', NULL, 3, 0),
(3122, 369, '景谷', NULL, 3, 0),
(3123, 369, '镇沅', NULL, 3, 0),
(3124, 369, '江城', NULL, 3, 0),
(3125, 369, '孟连', NULL, 3, 0),
(3126, 369, '澜沧', NULL, 3, 0),
(3127, 369, '西盟', NULL, 3, 0),
(3128, 370, '古城区', NULL, 3, 0),
(3129, 370, '宁蒗', NULL, 3, 0),
(3130, 370, '玉龙', NULL, 3, 0),
(3131, 370, '永胜县', NULL, 3, 0),
(3132, 370, '华坪县', NULL, 3, 0),
(3133, 371, '隆阳区', NULL, 3, 0),
(3134, 371, '施甸县', NULL, 3, 0),
(3135, 371, '腾冲县', NULL, 3, 0),
(3136, 371, '龙陵县', NULL, 3, 0),
(3137, 371, '昌宁县', NULL, 3, 0),
(3138, 372, '楚雄市', NULL, 3, 0),
(3139, 372, '双柏县', NULL, 3, 0),
(3140, 372, '牟定县', NULL, 3, 0),
(3141, 372, '南华县', NULL, 3, 0),
(3142, 372, '姚安县', NULL, 3, 0),
(3143, 372, '大姚县', NULL, 3, 0),
(3144, 372, '永仁县', NULL, 3, 0),
(3145, 372, '元谋县', NULL, 3, 0),
(3146, 372, '武定县', NULL, 3, 0),
(3147, 372, '禄丰县', NULL, 3, 0),
(3148, 373, '大理市', NULL, 3, 0),
(3149, 373, '祥云县', NULL, 3, 0),
(3150, 373, '宾川县', NULL, 3, 0),
(3151, 373, '弥渡县', NULL, 3, 0),
(3152, 373, '永平县', NULL, 3, 0),
(3153, 373, '云龙县', NULL, 3, 0),
(3154, 373, '洱源县', NULL, 3, 0),
(3155, 373, '剑川县', NULL, 3, 0),
(3156, 373, '鹤庆县', NULL, 3, 0),
(3157, 373, '漾濞', NULL, 3, 0),
(3158, 373, '南涧', NULL, 3, 0),
(3159, 373, '巍山', NULL, 3, 0),
(3160, 374, '潞西市', NULL, 3, 0),
(3161, 374, '瑞丽市', NULL, 3, 0),
(3162, 374, '梁河县', NULL, 3, 0),
(3163, 374, '盈江县', NULL, 3, 0),
(3164, 374, '陇川县', NULL, 3, 0),
(3165, 375, '香格里拉县', NULL, 3, 0),
(3166, 375, '德钦县', NULL, 3, 0),
(3167, 375, '维西', NULL, 3, 0),
(3168, 376, '泸西县', NULL, 3, 0),
(3169, 376, '蒙自县', NULL, 3, 0),
(3170, 376, '个旧市', NULL, 3, 0),
(3171, 376, '开远市', NULL, 3, 0),
(3172, 376, '绿春县', NULL, 3, 0),
(3173, 376, '建水县', NULL, 3, 0),
(3174, 376, '石屏县', NULL, 3, 0),
(3175, 376, '弥勒县', NULL, 3, 0),
(3176, 376, '元阳县', NULL, 3, 0),
(3177, 376, '红河县', NULL, 3, 0),
(3178, 376, '金平', NULL, 3, 0),
(3179, 376, '河口', NULL, 3, 0),
(3180, 376, '屏边', NULL, 3, 0),
(3181, 377, '临翔区', NULL, 3, 0),
(3182, 377, '凤庆县', NULL, 3, 0),
(3183, 377, '云县', NULL, 3, 0),
(3184, 377, '永德县', NULL, 3, 0),
(3185, 377, '镇康县', NULL, 3, 0),
(3186, 377, '双江', NULL, 3, 0),
(3187, 377, '耿马', NULL, 3, 0),
(3188, 377, '沧源', NULL, 3, 0),
(3189, 378, '麒麟区', NULL, 3, 0),
(3190, 378, '宣威市', NULL, 3, 0),
(3191, 378, '马龙县', NULL, 3, 0),
(3192, 378, '陆良县', NULL, 3, 0),
(3193, 378, '师宗县', NULL, 3, 0),
(3194, 378, '罗平县', NULL, 3, 0),
(3195, 378, '富源县', NULL, 3, 0),
(3196, 378, '会泽县', NULL, 3, 0),
(3197, 378, '沾益县', NULL, 3, 0),
(3198, 379, '文山县', NULL, 3, 0),
(3199, 379, '砚山县', NULL, 3, 0),
(3200, 379, '西畴县', NULL, 3, 0),
(3201, 379, '麻栗坡县', NULL, 3, 0),
(3202, 379, '马关县', NULL, 3, 0),
(3203, 379, '丘北县', NULL, 3, 0),
(3204, 379, '广南县', NULL, 3, 0),
(3205, 379, '富宁县', NULL, 3, 0),
(3206, 380, '景洪市', NULL, 3, 0),
(3207, 380, '勐海县', NULL, 3, 0),
(3208, 380, '勐腊县', NULL, 3, 0),
(3209, 381, '红塔区', NULL, 3, 0),
(3210, 381, '江川县', NULL, 3, 0),
(3211, 381, '澄江县', NULL, 3, 0),
(3212, 381, '通海县', NULL, 3, 0),
(3213, 381, '华宁县', NULL, 3, 0),
(3214, 381, '易门县', NULL, 3, 0),
(3215, 381, '峨山', NULL, 3, 0),
(3216, 381, '新平', NULL, 3, 0),
(3217, 381, '元江', NULL, 3, 0),
(3218, 382, '昭阳区', NULL, 3, 0),
(3219, 382, '鲁甸县', NULL, 3, 0),
(3220, 382, '巧家县', NULL, 3, 0),
(3221, 382, '盐津县', NULL, 3, 0),
(3222, 382, '大关县', NULL, 3, 0),
(3223, 382, '永善县', NULL, 3, 0),
(3224, 382, '绥江县', NULL, 3, 0),
(3225, 382, '镇雄县', NULL, 3, 0),
(3226, 382, '彝良县', NULL, 3, 0),
(3227, 382, '威信县', NULL, 3, 0),
(3228, 382, '水富县', NULL, 3, 0),
(3229, 383, '西湖区', NULL, 3, 0),
(3230, 383, '上城区', NULL, 3, 0),
(3231, 383, '下城区', NULL, 3, 0),
(3232, 383, '拱墅区', NULL, 3, 0),
(3233, 383, '滨江区', NULL, 3, 0),
(3234, 383, '江干区', NULL, 3, 0),
(3235, 383, '萧山区', NULL, 3, 0),
(3236, 383, '余杭区', NULL, 3, 0),
(3237, 383, '市郊', NULL, 3, 0),
(3238, 383, '建德市', NULL, 3, 0),
(3239, 383, '富阳市', NULL, 3, 0),
(3240, 383, '临安市', NULL, 3, 0),
(3241, 383, '桐庐县', NULL, 3, 0),
(3242, 383, '淳安县', NULL, 3, 0),
(3243, 384, '吴兴区', NULL, 3, 0),
(3244, 384, '南浔区', NULL, 3, 0),
(3245, 384, '德清县', NULL, 3, 0),
(3246, 384, '长兴县', NULL, 3, 0),
(3247, 384, '安吉县', NULL, 3, 0),
(3248, 385, '南湖区', NULL, 3, 0),
(3249, 385, '秀洲区', NULL, 3, 0),
(3250, 385, '海宁市', NULL, 3, 0),
(3251, 385, '嘉善县', NULL, 3, 0),
(3252, 385, '平湖市', NULL, 3, 0),
(3253, 385, '桐乡市', NULL, 3, 0),
(3254, 385, '海盐县', NULL, 3, 0),
(3255, 386, '婺城区', NULL, 3, 0),
(3256, 386, '金东区', NULL, 3, 0),
(3257, 386, '兰溪市', NULL, 3, 0),
(3258, 386, '市区', NULL, 3, 0),
(3259, 386, '佛堂镇', NULL, 3, 0),
(3260, 386, '上溪镇', NULL, 3, 0),
(3261, 386, '义亭镇', NULL, 3, 0),
(3262, 386, '大陈镇', NULL, 3, 0),
(3263, 386, '苏溪镇', NULL, 3, 0),
(3264, 386, '赤岸镇', NULL, 3, 0),
(3265, 386, '东阳市', NULL, 3, 0),
(3266, 386, '永康市', NULL, 3, 0),
(3267, 386, '武义县', NULL, 3, 0),
(3268, 386, '浦江县', NULL, 3, 0),
(3269, 386, '磐安县', NULL, 3, 0),
(3270, 387, '莲都区', NULL, 3, 0),
(3271, 387, '龙泉市', NULL, 3, 0),
(3272, 387, '青田县', NULL, 3, 0),
(3273, 387, '缙云县', NULL, 3, 0),
(3274, 387, '遂昌县', NULL, 3, 0),
(3275, 387, '松阳县', NULL, 3, 0),
(3276, 387, '云和县', NULL, 3, 0),
(3277, 387, '庆元县', NULL, 3, 0),
(3278, 387, '景宁', NULL, 3, 0),
(3279, 388, '海曙区', NULL, 3, 0),
(3280, 388, '江东区', NULL, 3, 0),
(3281, 388, '江北区', NULL, 3, 0),
(3282, 388, '镇海区', NULL, 3, 0),
(3283, 388, '北仑区', NULL, 3, 0),
(3284, 388, '鄞州区', NULL, 3, 0),
(3285, 388, '余姚市', NULL, 3, 0),
(3286, 388, '慈溪市', NULL, 3, 0),
(3287, 388, '奉化市', NULL, 3, 0),
(3288, 388, '象山县', NULL, 3, 0),
(3289, 388, '宁海县', NULL, 3, 0),
(3290, 389, '越城区', NULL, 3, 0),
(3291, 389, '上虞市', NULL, 3, 0),
(3292, 389, '嵊州市', NULL, 3, 0),
(3293, 389, '绍兴县', NULL, 3, 0),
(3294, 389, '新昌县', NULL, 3, 0),
(3295, 389, '诸暨市', NULL, 3, 0),
(3296, 390, '椒江区', NULL, 3, 0),
(3297, 390, '黄岩区', NULL, 3, 0),
(3298, 390, '路桥区', NULL, 3, 0),
(3299, 390, '温岭市', NULL, 3, 0),
(3300, 390, '临海市', NULL, 3, 0),
(3301, 390, '玉环县', NULL, 3, 0),
(3302, 390, '三门县', NULL, 3, 0),
(3303, 390, '天台县', NULL, 3, 0),
(3304, 390, '仙居县', NULL, 3, 0),
(3305, 391, '鹿城区', NULL, 3, 0),
(3306, 391, '龙湾区', NULL, 3, 0),
(3307, 391, '瓯海区', NULL, 3, 0),
(3308, 391, '瑞安市', NULL, 3, 0),
(3309, 391, '乐清市', NULL, 3, 0),
(3310, 391, '洞头县', NULL, 3, 0),
(3311, 391, '永嘉县', NULL, 3, 0),
(3312, 391, '平阳县', NULL, 3, 0),
(3313, 391, '苍南县', NULL, 3, 0),
(3314, 391, '文成县', NULL, 3, 0),
(3315, 391, '泰顺县', NULL, 3, 0),
(3316, 392, '定海区', NULL, 3, 0),
(3317, 392, '普陀区', NULL, 3, 0),
(3318, 392, '岱山县', NULL, 3, 0),
(3319, 392, '嵊泗县', NULL, 3, 0),
(3320, 393, '衢州市', NULL, 3, 0),
(3321, 393, '江山市', NULL, 3, 0),
(3322, 393, '常山县', NULL, 3, 0),
(3323, 393, '开化县', NULL, 3, 0),
(3324, 393, '龙游县', NULL, 3, 0),
(3325, 394, '合川区', NULL, 3, 0),
(3326, 394, '江津区', NULL, 3, 0),
(3327, 394, '南川区', NULL, 3, 0),
(3328, 394, '永川区', NULL, 3, 0),
(3329, 394, '南岸区', NULL, 3, 0),
(3330, 394, '渝北区', NULL, 3, 0),
(3331, 394, '万盛区', NULL, 3, 0),
(3332, 394, '大渡口区', NULL, 3, 0),
(3333, 394, '万州区', NULL, 3, 0),
(3334, 394, '北碚区', NULL, 3, 0),
(3335, 394, '沙坪坝区', NULL, 3, 0),
(3336, 394, '巴南区', NULL, 3, 0),
(3337, 394, '涪陵区', NULL, 3, 0),
(3338, 394, '江北区', NULL, 3, 0),
(3339, 394, '九龙坡区', NULL, 3, 0),
(3340, 394, '渝中区', NULL, 3, 0),
(3341, 394, '黔江开发区', NULL, 3, 0),
(3342, 394, '长寿区', NULL, 3, 0),
(3343, 394, '双桥区', NULL, 3, 0),
(3344, 394, '綦江县', NULL, 3, 0),
(3345, 394, '潼南县', NULL, 3, 0),
(3346, 394, '铜梁县', NULL, 3, 0),
(3347, 394, '大足县', NULL, 3, 0),
(3348, 394, '荣昌县', NULL, 3, 0),
(3349, 394, '璧山县', NULL, 3, 0),
(3350, 394, '垫江县', NULL, 3, 0),
(3351, 394, '武隆县', NULL, 3, 0),
(3352, 394, '丰都县', NULL, 3, 0),
(3353, 394, '城口县', NULL, 3, 0),
(3354, 394, '梁平县', NULL, 3, 0),
(3355, 394, '开县', NULL, 3, 0),
(3356, 394, '巫溪县', NULL, 3, 0),
(3357, 394, '巫山县', NULL, 3, 0),
(3358, 394, '奉节县', NULL, 3, 0),
(3359, 394, '云阳县', NULL, 3, 0),
(3360, 394, '忠县', NULL, 3, 0),
(3361, 394, '石柱', NULL, 3, 0),
(3362, 394, '彭水', NULL, 3, 0),
(3363, 394, '酉阳', NULL, 3, 0),
(3364, 394, '秀山', NULL, 3, 0),
(3365, 395, '沙田区', NULL, 3, 0),
(3366, 395, '东区', NULL, 3, 0),
(3367, 395, '观塘区', NULL, 3, 0),
(3368, 395, '黄大仙区', NULL, 3, 0),
(3369, 395, '九龙城区', NULL, 3, 0),
(3370, 395, '屯门区', NULL, 3, 0),
(3371, 395, '葵青区', NULL, 3, 0),
(3372, 395, '元朗区', NULL, 3, 0),
(3373, 395, '深水埗区', NULL, 3, 0),
(3374, 395, '西贡区', NULL, 3, 0),
(3375, 395, '大埔区', NULL, 3, 0),
(3376, 395, '湾仔区', NULL, 3, 0),
(3377, 395, '油尖旺区', NULL, 3, 0),
(3378, 395, '北区', NULL, 3, 0),
(3379, 395, '南区', NULL, 3, 0),
(3380, 395, '荃湾区', NULL, 3, 0),
(3381, 395, '中西区', NULL, 3, 0),
(3382, 395, '离岛区', NULL, 3, 0),
(3383, 396, '澳门', NULL, 3, 0),
(3384, 397, '台北', NULL, 3, 0),
(3385, 397, '高雄', NULL, 3, 0),
(3386, 397, '基隆', NULL, 3, 0),
(3387, 397, '台中', NULL, 3, 0),
(3388, 397, '台南', NULL, 3, 0),
(3389, 397, '新竹', NULL, 3, 0),
(3390, 397, '嘉义', NULL, 3, 0),
(3391, 397, '宜兰县', NULL, 3, 0),
(3392, 397, '桃园县', NULL, 3, 0),
(3393, 397, '苗栗县', NULL, 3, 0),
(3394, 397, '彰化县', NULL, 3, 0),
(3395, 397, '南投县', NULL, 3, 0),
(3396, 397, '云林县', NULL, 3, 0),
(3397, 397, '屏东县', NULL, 3, 0),
(3398, 397, '台东县', NULL, 3, 0),
(3399, 397, '花莲县', NULL, 3, 0),
(3400, 397, '澎湖县', NULL, 3, 0),
(3401, 3, '合肥', NULL, 2, 0),
(3402, 3401, '庐阳区', NULL, 3, 0),
(3403, 3401, '瑶海区', NULL, 3, 0),
(3404, 3401, '蜀山区', NULL, 3, 0),
(3405, 3401, '包河区', NULL, 3, 0),
(3406, 3401, '长丰县', NULL, 3, 0),
(3407, 3401, '肥东县', NULL, 3, 0),
(3408, 3401, '肥西县', NULL, 3, 0),
(3802, 0, '南乔治亚和南德桑威奇群岛', 'GS', 0, 0),
(3801, 0, '南极洲', 'AQ', 0, 0),
(3800, 0, '南非', 'ZA', 0, 0),
(3799, 0, '纳米比亚', 'NA', 0, 0),
(3798, 0, '墨西哥', 'MX', 0, 0),
(3797, 0, '莫桑比克', 'MZ', 0, 0),
(3796, 0, '摩纳哥', 'MC', 0, 0),
(3795, 0, '摩洛哥', 'MA', 0, 0),
(3794, 0, '摩尔多瓦', 'MD', 0, 0),
(3793, 0, '缅甸', 'MM', 0, 0),
(3792, 0, '密克罗尼西亚', 'FM', 0, 0),
(3791, 0, '秘鲁', 'PE', 0, 0),
(3790, 0, '孟加拉国', 'BD', 0, 0),
(3789, 0, '蒙特塞拉特', 'MS', 0, 0),
(3788, 0, '蒙古', 'MN', 0, 0),
(3787, 0, '美属维尔京群岛', 'VI', 0, 0),
(3786, 0, '美属外岛', 'UM', 0, 0),
(3785, 0, '美属萨摩亚', 'AS', 0, 0),
(3784, 0, '美国', 'US', 0, 0),
(3783, 0, '毛利塔尼亚', 'MR', 0, 0),
(3782, 0, '毛里求斯', 'MU', 0, 0),
(3781, 0, '马约特岛', 'YT', 0, 0),
(3780, 0, '马提尼克岛', 'MQ', 0, 0),
(3779, 0, '马绍尔群岛', 'MH', 0, 0),
(3778, 0, '马其顿, 前南斯拉夫共和国', 'MK', 0, 0),
(3777, 0, '马里', 'ML', 0, 0),
(3776, 0, '马来西亚', 'MY', 0, 0),
(3775, 0, '马拉维', 'MW', 0, 0),
(3774, 0, '马耳他', 'MT', 0, 0),
(3773, 0, '马尔代夫', 'MV', 0, 0),
(3772, 0, '马恩岛', 'IM', 0, 0),
(3771, 0, '马达加斯加', 'MG', 0, 0),
(3770, 0, '罗马尼亚', 'RO', 0, 0),
(3769, 0, '卢旺达', 'RW', 0, 0),
(3768, 0, '卢森堡', 'LU', 0, 0),
(3767, 0, '留尼汪岛', 'RE', 0, 0),
(3766, 0, '列支敦士登', 'LI', 0, 0),
(3765, 0, '利比亚', 'LY', 0, 0),
(3764, 0, '利比里亚', 'LR', 0, 0),
(3763, 0, '立陶宛', 'LT', 0, 0),
(3762, 0, '黎巴嫩', 'LB', 0, 0),
(3761, 0, '老挝', 'LA', 0, 0),
(3760, 0, '莱索托', 'LS', 0, 0),
(3759, 0, '拉脱维亚', 'LV', 0, 0),
(3758, 0, '库拉索', 'CW', 0, 0),
(3757, 0, '库可群岛', 'CK', 0, 0),
(3756, 0, '肯尼亚', 'KE', 0, 0),
(3755, 0, '克罗地亚', 'HR', 0, 0),
(3754, 0, '科威特', 'KW', 0, 0),
(3753, 0, '科特迪瓦共和国', 'CI', 0, 0),
(3752, 0, '科摩罗联盟', 'KM', 0, 0),
(3751, 0, '科科斯群岛(基灵群岛)', 'CC', 0, 0),
(3750, 0, '开曼群岛', 'KY', 0, 0),
(3749, 0, '卡塔尔', 'QA', 0, 0),
(3748, 0, '喀麦隆', 'CM', 0, 0),
(3747, 0, '津巴布韦', 'ZW', 0, 0),
(3746, 0, '捷克共和国', 'CZ', 0, 0),
(3745, 0, '柬埔寨', 'KH', 0, 0),
(3744, 0, '加蓬', 'GA', 0, 0),
(3743, 0, '加纳', 'GH', 0, 0),
(3742, 0, '加拿大', 'CA', 0, 0),
(3741, 0, '几内亚比绍', 'GW', 0, 0),
(3740, 0, '几内亚', 'GN', 0, 0),
(3739, 0, '吉尔吉斯斯坦', 'KG', 0, 0),
(3738, 0, '吉布提', 'DJ', 0, 0),
(3737, 0, '基里巴斯', 'KI', 0, 0),
(3736, 0, '洪都拉斯', 'HN', 0, 0),
(3735, 0, '黑山共和国', 'ME', 0, 0),
(3734, 0, '赫德和麦克唐纳群岛', 'HM', 0, 0),
(3733, 0, '荷兰', 'NL', 0, 0),
(3732, 0, '韩国', 'KR', 0, 0),
(3731, 0, '海地', 'HT', 0, 0),
(3730, 0, '哈萨克斯坦', 'KZ', 0, 0),
(3729, 0, '圭亚那', 'GY', 0, 0),
(3728, 0, '关岛', 'GU', 0, 0),
(3727, 0, '瓜德罗普岛', 'GP', 0, 0),
(3726, 0, '古巴', 'CU', 0, 0),
(3725, 0, '格鲁吉亚', 'GE', 0, 0),
(3724, 0, '格陵兰', 'GL', 0, 0),
(3723, 0, '格林纳达', 'GD', 0, 0),
(3722, 0, '格恩西岛', 'GG', 0, 0),
(3721, 0, '哥斯达黎加', 'CR', 0, 0),
(3720, 0, '哥伦比亚', 'CO', 0, 0),
(3719, 0, '刚果共和国', 'CG', 0, 0),
(3718, 0, '刚果(DRC)', 'CD', 0, 0),
(3717, 0, '冈比亚', 'GM', 0, 0),
(3716, 0, '福克兰群岛(马尔维纳斯群岛)', 'FK', 0, 0),
(3715, 0, '佛得角', 'CV', 0, 0),
(3714, 0, '芬兰', 'FI', 0, 0),
(3713, 0, '斐济群岛', 'FJ', 0, 0),
(3712, 0, '菲律宾', 'PH', 0, 0),
(3711, 0, '梵蒂冈城', 'VA', 0, 0),
(3710, 0, '法属南极地区', 'TF', 0, 0),
(3709, 0, '法属圭亚那', 'GF', 0, 0),
(3708, 0, '法属波利尼西亚', 'PF', 0, 0),
(3707, 0, '法罗群岛', 'FO', 0, 0),
(3706, 0, '法国', 'FR', 0, 0),
(3705, 0, '厄立特里亚', 'ER', 0, 0),
(3704, 0, '厄瓜多尔', 'EC', 0, 0),
(3703, 0, '俄罗斯', 'RU', 0, 0),
(3702, 0, '多米尼克', 'DM', 0, 0),
(3701, 0, '多米尼加共和国', 'DO', 0, 0),
(3700, 0, '多哥', 'TG', 0, 0),
(3699, 0, '东帝汶', 'TL', 0, 0),
(3698, 0, '德国', 'DE', 0, 0),
(3697, 0, '丹麦', 'DK', 0, 0),
(3696, 0, '赤道几内亚', 'GQ', 0, 0),
(3695, 0, '朝鲜', 'KP', 0, 0),
(3694, 0, '布韦岛', 'BV', 0, 0),
(3693, 0, '布隆迪', 'BI', 0, 0),
(3692, 0, '布基纳法索', 'BF', 0, 0),
(3691, 0, '不丹', 'BT', 0, 0),
(3690, 0, '博内尔', 'BQ', 0, 0),
(3689, 0, '博茨瓦纳', 'BW', 0, 0),
(3688, 0, '伯利兹', 'BZ', 0, 0),
(3687, 0, '玻利维亚', 'BO', 0, 0),
(3686, 0, '波斯尼亚和黑塞哥维那', 'BA', 0, 0),
(3685, 0, '波兰', 'PL', 0, 0),
(3684, 0, '波多黎各', 'PR', 0, 0),
(3683, 0, '冰岛', 'IS', 0, 0),
(3682, 0, '比利时', 'BE', 0, 0),
(3681, 0, '贝宁', 'BJ', 0, 0),
(3680, 0, '北马里亚纳群岛', 'MP', 0, 0),
(3679, 0, '保加利亚', 'BG', 0, 0),
(3678, 0, '百慕大群岛', 'BM', 0, 0),
(3677, 0, '白俄罗斯', 'BY', 0, 0),
(3676, 0, '巴西', 'BR', 0, 0),
(3675, 0, '巴拿马', 'PA', 0, 0),
(3674, 0, '巴林', 'BH', 0, 0),
(3673, 0, '巴勒斯坦民族权力机构', 'PS', 0, 0),
(3672, 0, '巴拉圭', 'PY', 0, 0),
(3671, 0, '巴基斯坦', 'PK', 0, 0),
(3670, 0, '巴哈马', 'BS', 0, 0),
(3669, 0, '巴布亚新几内亚', 'PG', 0, 0),
(3668, 0, '巴巴多斯', 'BB', 0, 0),
(3667, 0, '澳门特别行政区', 'MO', 0, 0),
(3666, 0, '澳大利亚', 'AU', 0, 0),
(3665, 0, '奥兰岛', 'AX', 0, 0),
(3664, 0, '奥地利', 'AT', 0, 0),
(3663, 0, '安提瓜和巴布达', 'AG', 0, 0),
(3662, 0, '安圭拉岛', 'AI', 0, 0),
(3661, 0, '安哥拉', 'AO', 0, 0),
(3660, 0, '安道尔', 'AD', 0, 0),
(3659, 0, '爱沙尼亚', 'EE', 0, 0),
(3658, 0, '爱尔兰', 'IE', 0, 0),
(3657, 0, '埃塞俄比亚', 'ET', 0, 0),
(3656, 0, '埃及', 'EG', 0, 0),
(3655, 0, '阿塞拜疆', 'AZ', 0, 0),
(3654, 0, '阿曼', 'OM', 0, 0),
(3653, 0, '阿鲁巴', 'AW', 0, 0),
(3652, 0, '阿拉伯联合酋长国', 'AE', 0, 0),
(3651, 0, '阿根廷', 'AR', 0, 0),
(3650, 0, '阿富汗', 'AF', 0, 0),
(3649, 0, '阿尔及利亚', 'DZ', 0, 0),
(3648, 0, '阿尔巴尼亚', 'AL', 0, 0),
(3803, 0, '瑙鲁', 'NR', 0, 0),
(3804, 0, '尼泊尔', 'NP', 0, 0),
(3805, 0, '尼加拉瓜', 'NI', 0, 0),
(3806, 0, '尼日尔', 'NE', 0, 0),
(3807, 0, '尼日利亚', 'NG', 0, 0),
(3808, 0, '纽埃', 'NU', 0, 0),
(3809, 0, '挪威', 'NO', 0, 0),
(3810, 0, '诺福克岛', 'NF', 0, 0),
(3811, 0, '帕劳群岛', 'PW', 0, 0),
(3812, 0, '皮特凯恩群岛', 'PN', 0, 0),
(3813, 0, '葡萄牙', 'PT', 0, 0),
(3814, 0, '日本', 'JP', 0, 0),
(3815, 0, '瑞典', 'SE', 0, 0),
(3816, 0, '瑞士', 'CH', 0, 0),
(3817, 0, '萨尔瓦多', 'SV', 0, 0),
(3818, 0, '萨摩亚', 'WS', 0, 0),
(3819, 0, '塞尔维亚共和国', 'RS', 0, 0),
(3820, 0, '塞拉利昂', 'SL', 0, 0),
(3821, 0, '塞内加尔', 'SN', 0, 0),
(3822, 0, '塞浦路斯', 'CY', 0, 0),
(3823, 0, '塞舌尔', 'SC', 0, 0),
(3824, 0, '沙巴岛', 'XS', 0, 0),
(3825, 0, '沙特阿拉伯', 'SA', 0, 0),
(3826, 0, '圣巴泰勒米岛', 'BL', 0, 0),
(3827, 0, '圣诞岛', 'CX', 0, 0),
(3828, 0, '圣多美和普林西比', 'ST', 0, 0),
(3829, 0, '圣赫勒拿岛', 'SH', 0, 0),
(3830, 0, '圣基茨和尼维斯', 'KN', 0, 0),
(3831, 0, '圣卢西亚', 'LC', 0, 0),
(3832, 0, '法属圣马丁岛', 'MF', 0, 0),
(3833, 0, '荷属圣马丁岛', 'SX', 0, 0),
(3834, 0, '圣马力诺', 'SM', 0, 0),
(3835, 0, '圣皮埃尔岛和密克隆岛', 'PM', 0, 0),
(3836, 0, '圣文森特和格林纳丁斯', 'VC', 0, 0),
(3837, 0, '圣尤斯特歇斯岛', 'XE', 0, 0),
(3838, 0, '斯里兰卡', 'LK', 0, 0),
(3839, 0, '斯洛伐克', 'SK', 0, 0),
(3840, 0, '斯洛文尼亚', 'SI', 0, 0),
(3841, 0, '斯威士兰', 'SZ', 0, 0),
(3842, 0, '苏丹', 'SD', 0, 0),
(3843, 0, '苏里南', 'SR', 0, 0),
(3844, 0, '所罗门群岛', 'SB', 0, 0),
(3845, 0, '索马里', 'SO', 0, 0),
(3846, 0, '塔吉克斯坦', 'TJ', 0, 0),
(3847, 0, '台湾', 'TW', 0, 0),
(3848, 0, '泰国', 'TH', 0, 0),
(3849, 0, '坦桑尼亚', 'TZ', 0, 0),
(3850, 0, '汤加', 'TO', 0, 0),
(3851, 0, '特克斯和凯科斯群岛', 'TC', 0, 0),
(3852, 0, '特立尼达和多巴哥', 'TT', 0, 0),
(3853, 0, '突尼斯', 'TN', 0, 0),
(3854, 0, '图瓦卢', 'TV', 0, 0),
(3855, 0, '土耳其', 'TR', 0, 0),
(3856, 0, '土库曼斯坦', 'TM', 0, 0),
(3857, 0, '托克劳', 'TK', 0, 0),
(3858, 0, '瓦利斯和富图纳', 'WF', 0, 0),
(3859, 0, '瓦努阿图', 'VU', 0, 0),
(3860, 0, '危地马拉', 'GT', 0, 0),
(3861, 0, '维尔京群岛(英属)', 'VG', 0, 0),
(3862, 0, '委内瑞拉', 'VE', 0, 0),
(3863, 0, '文莱', 'BN', 0, 0),
(3864, 0, '乌干达', 'UG', 0, 0),
(3865, 0, '乌克兰', 'UA', 0, 0),
(3866, 0, '乌拉圭', 'UY', 0, 0),
(3867, 0, '乌兹别克斯坦', 'UZ', 0, 0),
(3868, 0, '西班牙', 'ES', 0, 0),
(3869, 0, '希腊', 'GR', 0, 0),
(3870, 0, '香港特别行政区', 'HK', 0, 0),
(3871, 0, '新加坡', 'SG', 0, 0),
(3872, 0, '新喀里多尼亚', 'NC', 0, 0),
(3873, 0, '新西兰', 'NZ', 0, 0),
(3874, 0, '匈牙利', 'HU', 0, 0),
(3875, 0, '叙利亚', 'SY', 0, 0),
(3876, 0, '牙买加', 'JM', 0, 0),
(3877, 0, '亚美尼亚', 'AM', 0, 0),
(3878, 0, '扬马延岛', 'SJ', 0, 0),
(3879, 0, '也门', 'YE', 0, 0),
(3880, 0, '伊拉克', 'IQ', 0, 0),
(3881, 0, '伊朗', 'IR', 0, 0),
(3882, 0, '以色列', 'IL', 0, 0),
(3883, 0, '意大利', 'IT', 0, 0),
(3884, 0, '印度', 'IN', 0, 0),
(3885, 0, '印度尼西亚', 'ID', 0, 0),
(3886, 0, '英国', 'UK', 0, 0),
(3887, 0, '英属印度洋领地', 'IO', 0, 0),
(3888, 0, '约旦', 'JO', 0, 0),
(3889, 0, '越南', 'VN', 0, 0),
(3890, 0, '赞比亚', 'ZM', 0, 0),
(3891, 0, '泽西', 'JE', 0, 0),
(3892, 0, '乍得', 'TD', 0, 0),
(3893, 0, '直布罗陀', 'GI', 0, 0),
(3894, 0, '智利', 'CL', 0, 0),
(3895, 0, '中非共和国', 'CF', 0, 0);

DROP TABLE IF EXISTS `nitc_review`;
CREATE TABLE IF NOT EXISTS `nitc_review` (
  `review_id` int(11) NOT NULL AUTO_INCREMENT,
  `id_value` int(11) unsigned NOT NULL DEFAULT '0',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `customer_id` int(11) unsigned NOT NULL DEFAULT '0',
  `type` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '1=产品评论，2=文章评论，3=订单评论',
  `author` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `content` text COLLATE utf8_bin NOT NULL,
  `rating` int(1) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `is_reply` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`review_id`),
  KEY `id_value` (`id_value`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_sessions`;
CREATE TABLE IF NOT EXISTS `nitc_sessions` (
  `sesskey` varchar(32) COLLATE utf8_bin NOT NULL,
  `expiry` int(10) unsigned NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL,
  `adminid` mediumint(8) unsigned NOT NULL,
  `ip` varchar(15) COLLATE utf8_bin NOT NULL,
  `data` longtext COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`sesskey`),
  KEY `expiry` (`expiry`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_setting`;
CREATE TABLE IF NOT EXISTS `nitc_setting` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `code` varchar(30) COLLATE utf8_bin NOT NULL DEFAULT '',
  `title` varchar(30) COLLATE utf8_bin NOT NULL DEFAULT '',
  `range` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  `type` varchar(10) COLLATE utf8_bin NOT NULL DEFAULT '',
  `value` text COLLATE utf8_bin NOT NULL,
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO `nitc_setting` (`id`, `parent_id`, `code`, `title`, `range`, `type`, `value`, `sort_order`) VALUES
(1, 0, 'basic', '站点设置', '', 'group', '', 0),
(5, 0, 'smtp', '邮件服务器设置', '', 'group', '', 0),
(6, 1, 'weburl', '手机网址', '', 'text', '', 0),
(7, 1, 'cache_time', '缓存存活时间(秒)', '', 'text', '3600', 0),
(8, 1, 'url_rewrite', 'URL重写', '0|||禁用,1|||启用', 'select', '1', 0),
(9, 1, 'enable_gzip', '是否启用Gzip模式', '0|||否,1|||是', 'select', '0', 0),
(10, 5, 'mail_type', '邮件转发方式', '0|||采用服务器内置的Mail服务,1|||采用其他的SMTP服务', 'select', '0', 0),
(11, 5, 'smtp_host', '邮件服务器地址', '', 'text', 'localhost', 0),
(12, 5, 'smtp_port', '服务器端口', '', 'text', '25', 0),
(13, 5, 'smtp_user', '邮件发送帐号', '', 'text', '', 0),
(14, 5, 'smtp_pass', '帐号密码', '', 'password', '', 0),
(15, 5, 'smtp_mail', '邮件回复地址', '', 'text', '', 0),
(32, 1, 'start_image', '引导图', '', 'textarea', '', 0),
(31, 1, 'app_ico', '应用图标', '', 'file', '', 0),
(20, 1, 'product_list_num', '产品列表页显示数量', '', 'text', '20', 0),
(21, 1, 'company_info_list_num', '频道列表页显示数量', '', 'text', '20', 0),
(22, 1, 'site_email', '系统邮箱', '', 'text', '', 0),
(23, 1, 'site_name', '站点名称', '', 'text', 'NITC网站管理系统', 0),
(24, 0, 'weixin', '微信设置', '', 'group', '', 0),
(25, 24, 'wx_token', 'Token', '', 'text', '', 0),
(26, 24, 'wx_appid', 'AppId', '', 'text', '', 0),
(27, 24, 'wx_appsecret', 'AppSecret', '', 'text', '', 0),
(28, 24, 'wx_access_token', 'Access Token', '', 'hidden', '', 0),
(29, 24, 'wx_dateline', 'Dateline', '', 'hidden', '', 0),
(30, 1, 'template', '模版', '', 'hidden', 'default', 0);

DROP TABLE IF EXISTS `nitc_shipping`;
CREATE TABLE IF NOT EXISTS `nitc_shipping` (
  `shipping_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `shipping_code` varchar(20) COLLATE utf8_bin NOT NULL DEFAULT '',
  `shipping_name` varchar(120) COLLATE utf8_bin NOT NULL DEFAULT '',
  `shipping_desc` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `configure` text COLLATE utf8_bin,
  `shipping_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`shipping_id`),
  KEY `shipping_code` (`shipping_code`,`enabled`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=2 ;

INSERT INTO `nitc_shipping` (`shipping_id`, `shipping_code`, `shipping_name`, `shipping_desc`, `enabled`, `configure`, `shipping_order`) VALUES
(1, 'express', '快递', '江、浙、沪地区首重为15元/KG，其他地区18元/KG， 续重均为5-6元/KG， 云南地区为8元', 1, 'a:5:{i:0;a:2:{s:4:"name";s:8:"item_fee";s:5:"value";s:1:"6";}i:1;a:2:{s:4:"name";s:8:"base_fee";s:5:"value";s:2:"12";}i:2;a:2:{s:4:"name";s:8:"step_fee";s:5:"value";s:2:"12";}i:3;a:2:{s:4:"name";s:10:"free_money";s:5:"value";s:0:"";}i:4;a:2:{s:4:"name";s:16:"fee_compute_mode";s:5:"value";s:9:"by_number";}}', 0);

DROP TABLE IF EXISTS `nitc_url_alias`;
CREATE TABLE IF NOT EXISTS `nitc_url_alias` (
  `url_alias_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8_bin NOT NULL,
  `language_id` int(11) unsigned NOT NULL DEFAULT '0',
  `id` int(11) unsigned NOT NULL DEFAULT '0',
  `query` varchar(255) COLLATE utf8_bin NOT NULL,
  `keyword` varchar(255) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`url_alias_id`),
  KEY `keyword` (`keyword`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=319 ;

INSERT INTO `nitc_url_alias` (`url_alias_id`, `type`, `language_id`, `id`, `query`, `keyword`) VALUES
(252, 'channel', 1, 5, 'index.php?action=channel&id=5&language_id=1', 'channel-c-5-1.html'),
(247, 'channel', 2, 3, 'index.php?action=channel&id=3&language_id=2', 'channel-c-3-2.html'),
(248, 'channel', 1, 3, 'index.php?action=channel&id=3&language_id=1', 'channel-c-3-1.html'),
(249, 'channel', 2, 4, 'index.php?action=channel&id=4&language_id=2', 'channel-c-4-2.html'),
(250, 'channel', 1, 4, 'index.php?action=channel&id=4&language_id=1', 'channel-c-4-1.html'),
(251, 'channel', 2, 5, 'index.php?action=channel&id=5&language_id=2', 'channel-c-5-2.html'),
(253, 'information', 2, 3, 'index.php?action=information&id=3&language_id=2', 'info-d-3-2.html'),
(246, 'channel', 1, 19, 'index.php?action=channel&id=19&language_id=1', 'channel-c-19-1.html'),
(245, 'channel', 2, 19, 'index.php?action=channel&id=19&language_id=2', 'channel-c-19-2.html'),
(244, 'channel', 1, 18, 'index.php?action=channel&id=18&language_id=1', 'channel-c-18-1.html'),
(243, 'channel', 2, 18, 'index.php?action=channel&id=18&language_id=2', 'channel-c-18-2.html'),
(242, 'channel', 1, 16, 'index.php?action=channel&id=16&language_id=1', 'channel-c-16-1.html'),
(241, 'channel', 2, 16, 'index.php?action=channel&id=16&language_id=2', 'channel-c-16-2.html'),
(298, 'channel', 1, 15, 'index.php?action=channel&id=15&language_id=1', 'channel-c-15-1.html'),
(297, 'channel', 2, 15, 'index.php?action=channel&id=15&language_id=2', 'channel-c-15-2.html'),
(286, 'channel', 1, 6, 'index.php?action=channel&id=6&language_id=1', 'channel-c-6-1.html'),
(285, 'channel', 2, 6, 'index.php?action=channel&id=6&language_id=2', 'channel-c-6-2.html'),
(282, 'channel', 1, 2, 'index.php?action=channel&id=2&language_id=1', 'channel-c-2-1.html'),
(254, 'information', 1, 3, 'index.php?action=information&id=3&language_id=1', 'info-d-3-1.html'),
(281, 'channel', 2, 2, 'index.php?action=channel&id=2&language_id=2', 'channel-c-2-2.html'),
(232, 'channel', 1, 1, 'index.php?action=channel&id=1&language_id=1', 'channel-c-1-1.html'),
(231, 'channel', 2, 1, 'index.php?action=channel&id=1&language_id=2', 'channel-c-1-2.html'),
(257, 'channel', 2, 20, 'index.php?action=channel&id=20&language_id=2', 'channel-c-20-2.html'),
(258, 'channel', 1, 20, 'index.php?action=channel&id=20&language_id=1', 'channel-c-20-1.html'),
(259, 'category', 2, 7, 'index.php?action=category&id=7&language_id=2', 'category-c-7-2.html'),
(260, 'category', 1, 7, 'index.php?action=category&id=7&language_id=1', 'category-c-7-1.html'),
(261, 'category', 2, 6, 'index.php?action=category&id=6&language_id=2', 'category-c-6-2.html'),
(262, 'category', 1, 6, 'index.php?action=category&id=6&language_id=1', 'category-c-6-1.html'),
(316, 'product', 1, 18, 'index.php?action=product&id=18&language_id=1', 'product-p-18-1.html'),
(315, 'product', 2, 18, 'index.php?action=product&id=18&language_id=2', 'product-p-18-2.html'),
(267, 'information', 2, 2, 'index.php?action=information&id=2&language_id=2', 'info-d-2-2.html'),
(268, 'information', 1, 2, 'index.php?action=information&id=2&language_id=1', 'info-d-2-1.html'),
(269, 'information', 2, 10, 'index.php?action=information&id=10&language_id=2', 'info-d-10-2.html'),
(270, 'information', 1, 10, 'index.php?action=information&id=10&language_id=1', 'info-d-10-1.html'),
(278, 'channel', 1, 21, 'index.php?action=channel&id=21&language_id=1', 'channel-c-21-1.html'),
(277, 'channel', 2, 21, 'index.php?action=channel&id=21&language_id=2', 'channel-c-21-2.html'),
(294, 'information', 1, 12, 'index.php?action=information&id=12&language_id=1', 'info-d-12-1.html'),
(293, 'information', 2, 12, 'index.php?action=information&id=12&language_id=2', 'info-d-12-2.html'),
(299, 'channel', 2, 17, 'index.php?action=channel&id=17&language_id=2', 'channel-c-17-2.html'),
(300, 'channel', 1, 17, 'index.php?action=channel&id=17&language_id=1', 'channel-c-17-1.html'),
(301, 'information', 2, 8, 'index.php?action=information&id=8&language_id=2', 'info-d-8-2.html'),
(302, 'information', 1, 8, 'index.php?action=information&id=8&language_id=1', 'info-d-8-1.html'),
(303, 'information', 2, 7, 'index.php?action=information&id=7&language_id=2', 'info-d-7-2.html'),
(304, 'information', 1, 7, 'index.php?action=information&id=7&language_id=1', 'info-d-7-1.html'),
(305, 'information', 2, 13, 'index.php?action=information&id=13&language_id=2', 'info-d-13-2.html'),
(306, 'information', 1, 13, 'index.php?action=information&id=13&language_id=1', 'info-d-13-1.html'),
(307, 'category', 2, 14, 'index.php?action=category&id=14&language_id=2', 'category-c-14-2.html'),
(308, 'category', 1, 14, 'index.php?action=category&id=14&language_id=1', 'category-c-14-1.html'),
(309, 'category', 2, 15, 'index.php?action=category&id=15&language_id=2', 'category-c-15-2.html'),
(310, 'category', 1, 15, 'index.php?action=category&id=15&language_id=1', 'category-c-15-1.html'),
(311, 'category', 2, 16, 'index.php?action=category&id=16&language_id=2', 'category-c-16-2.html'),
(312, 'category', 1, 16, 'index.php?action=category&id=16&language_id=1', 'category-c-16-1.html');

DROP TABLE IF EXISTS `nitc_user`;
CREATE TABLE IF NOT EXISTS `nitc_user` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(20) COLLATE utf8_bin NOT NULL DEFAULT '',
  `password` varchar(40) COLLATE utf8_bin NOT NULL DEFAULT '',
  `salt` varchar(9) COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `email` varchar(96) COLLATE utf8_bin NOT NULL DEFAULT '',
  `ip` varchar(40) COLLATE utf8_bin NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL,
  `permission` text COLLATE utf8_bin NOT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_ip` varchar(20) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_wx_menu`;
CREATE TABLE IF NOT EXISTS `nitc_wx_menu` (
  `menu_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_bin NOT NULL DEFAULT '',
  `type` varchar(50) COLLATE utf8_bin NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  `parent_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '50',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`menu_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_wx_reply`;
CREATE TABLE IF NOT EXISTS `nitc_wx_reply` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_bin NOT NULL,
  `keyword` varchar(100) COLLATE utf8_bin NOT NULL,
  `type` varchar(50) COLLATE utf8_bin NOT NULL,
  `contents` text COLLATE utf8_bin,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT INTO `nitc_wx_reply` (`id`, `name`, `keyword`, `type`, `contents`, `count`, `status`, `date_added`, `date_modified`) VALUES
(1, '', 'welcome', 'text', '', 0, 1, '0000-00-00 00:00:00', '');

DROP TABLE IF EXISTS `nitc_wx_send`;
CREATE TABLE IF NOT EXISTS `nitc_wx_send` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `subject` varchar(100) COLLATE utf8_bin NOT NULL,
  `type` varchar(50) COLLATE utf8_bin NOT NULL,
  `contents` text COLLATE utf8_bin NOT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `nitc_wx_user`;
CREATE TABLE IF NOT EXISTS `nitc_wx_user` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `subscribe` tinyint(1) unsigned NOT NULL,
  `wxid` char(28) COLLATE utf8_bin NOT NULL,
  `nickname` varchar(200) COLLATE utf8_bin NOT NULL,
  `sex` tinyint(1) unsigned NOT NULL,
  `city` varchar(100) COLLATE utf8_bin NOT NULL,
  `country` varchar(100) COLLATE utf8_bin NOT NULL,
  `province` varchar(100) COLLATE utf8_bin NOT NULL,
  `language` varchar(50) COLLATE utf8_bin NOT NULL,
  `headimgurl` varchar(200) COLLATE utf8_bin NOT NULL,
  `subscribe_time` int(10) unsigned NOT NULL,
  `localimgurl` varchar(200) COLLATE utf8_bin NOT NULL,
  `setp` smallint(2) unsigned NOT NULL,
  `uname` varchar(50) COLLATE utf8_bin NOT NULL,
  `coupon` varchar(30) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

