<?php
define('IN_SITE', true);
require('./includes/init.php');
include_once('includes/cls_json.php');
$json = new JSON;
$result = array('error' => '', 'content' => '', 'message' => '');

$act = isset($_REQUEST['act']) ? trim($_REQUEST['act']) : 'index';

if ($act == 'login') {
	if (!empty($_SESSION['user_name'])) {
		header("Location: user.php?act=index&lang_id=" . $language_id);
	}
	$smarty -> display($_CFG['template'] . '/login.dwt');
	die();
}

if ($act == 'register') {
	$smarty -> display($_CFG['template'] . '/register.dwt');
	die();
}

if ($act == 'do_login') {
	$user_name = isset($_REQUEST['user_name']) ? strip_tags($_REQUEST['user_name']):'';
	$password = isset($_REQUEST['password']) ? strip_tags($_REQUEST['password']):'';

	if (empty($user_name)) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_username_empty'];
		die($json -> encode($result));
	}

	if (empty($password)) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_password_empty'];
		die($json -> encode($result));
	}

	$customer = $db -> getRow("SELECT customer_id,user_name,password,salt,customer_group_id from  " . $site -> table('customer') . " WHERE user_name='$user_name'");

	if (empty($customer)) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_username_password_error'];
		die($json -> encode($result));
	} else if ($customer['password'] != $site -> compile_password($password . $customer['salt'])) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_username_password_error'];
		die($json -> encode($result));
	} else {
		$_SESSION['user_name'] = $customer['user_name'];
		$_SESSION['customer_id'] = $customer['customer_id'];
		$_SESSION['customer_group_id'] = $customer['customer_group_id'];
		$result['error'] = 0;
		$result['title'] = $_LANG['prompt'];
		$result['message'] = $_LANG['user_login_sucess'];
		die($json -> encode($result));
	}
	die();
}

if ($act == 'do_register') {
	$mobile = isset($_POST['mobile']) ? strip_tags(trim($_POST['mobile'])):'';
	$email = isset($_POST['email']) ? strip_tags(trim($_POST['email'])):'';
	$password = isset($_POST['password']) ? strip_tags($_POST['password']):'';
	$confirm_password = isset($_POST['confirm_password']) ? strip_tags($_POST['confirm_password']):'';

	$user_name = empty($mobile) ? $email : $mobile;

	if (empty($mobile) && empty($email)) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_mobile_email_empty'];
		die($json -> encode($result));
	}

	if (!empty($mobile) && !preg_match("/1[3458]{1}\d{9}$/", $mobile)) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_mobile_error'];
		die($json -> encode($result));
	}

	if (!empty($email) && !is_email($email)) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_email_error'];
		die($json -> encode($result));
	}

	if (empty($password)) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_password_empty'];
		die($json -> encode($result));
	}

	if ($password != $confirm_password) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_password_error'];
		die($json -> encode($result));
	}

	$row = $db -> getRow("SELECT user_name from  " . $site -> table('customer') . " where user_name='$user_name'");
	if ($row) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_account_error'];
		die($json -> encode($result));
	}

	$salt = rand(100, 999);
	$password = $site -> compile_password($password . $salt);

	$db -> query("INSERT INTO " . $site -> table('customer') . " (user_name,email,mobile,password,salt,ip,date_added,status) VALUES ('" . $user_name . "','" . $email . "','" . $mobile . "','" . $password . "','" . $salt . "','" . real_ip() . "','" . date('Y-m-d H:i:s', time()) . "',1)");

	$_SESSION['user_name'] = $user_name;
	$_SESSION['customer_id'] = $db -> insert_id();
	$_SESSION['customer_group_id'] = 0;
	$result['error'] = 0;
	$result['title'] = $_LANG['prompt'];
	$result['message'] = $_LANG['user_reg_sucess'];
	die($json -> encode($result));
}

if ($act == 'logout') {
	unset($_SESSION['user_name']);
	unset($_SESSION['customer_id']);
	$sess -> destroy_session();
	header("Location: user.php?act=login&lang_id=" . $language_id);
	die();
}

if ($act == 'get_password') {
	if (isset($_POST['mobile_email'])) {
		$mobile_email = isset($_REQUEST['mobile_email']) ? strip_tags(trim($_REQUEST['mobile_email'])):'';
		if (empty($mobile)) {
			$result['error'] = 1;
			$result['title'] = $_LANG['error'];
			$result['message'] = $_LANG['user_mobile_email_empty'];
			die($json -> encode($result));
		}

		$password = rand(100000, 999999);

		if (strpos($mobile_email, '@') > 0) {
			$row = $db -> getRow("SELECT customer_id,user_name,name,email,salt from  " . $site -> table('customer') . " where email='$email'");
			if (empty($row)) {
				$result['error'] = 0;
				$result['title'] = $_LANG['prompt'];
				$result['message'] = $_LANG['user_email_empty'];
				die($json -> encode($result));
			}
			$status = send_mail($row['name'], $row['email'], $_LANG['user_find_password'], $_LANG['user_your_password'] . $password);
		} else {
			$row = $db -> getRow("SELECT customer_id,user_name,mobile from  " . $site -> table('customer') . " where mobile='$mobile'");
			if (empty($row)) {
				$result['error'] = 0;
				$result['title'] = $_LANG['prompt'];
				$result['message'] = $_LANG['user_mobile_not_exist'];
				die($json -> encode($result));
			}
			$status = send_msg($row['mobile'], $_LANG['user_your_password'] . $password);
		}

		if ($status === true) {
			$db -> query("UPDATE  " . $site -> table('customer') . " SET password='" . $site -> compile_password($password . $row['salt']) . "' WHERE customer_id=" . $row['customer_id']);
			$result['error'] = 1;
			$result['title'] = $_LANG['error'];
			$result['message'] = $_LANG['user_send_sucess'];
			die($json -> encode($result));
		} else {
			$result['error'] = 1;
			$result['title'] = $_LANG['error'];
			$result['message'] = $_LANG['user_send_error'];
			die($json -> encode($result));
		}
	}
	$smarty -> display($_CFG['template'] . '/get_password.dwt');
	die();
}

if ($act == 'index') {
	if (empty($_SESSION['user_name'])) {
		header("Location: user.php?act=login&lang_id=" . $language_id);
	}

	$customer = $db -> getRow("SELECT * from  " . $site -> table('customer') . " WHERE customer_id=" . $_SESSION['customer_id']);
	$smarty -> assign('customer', $customer);
	$smarty -> display($_CFG['template'] . '/user/index.dwt');
}

if ($act == 'info') {
	if (empty($_SESSION['user_name'])) {
		header("Location: user.php?act=login&lang_id=" . $language_id);
	}
	$customer = $db -> getRow("SELECT * from  " . $site -> table('customer') . " WHERE customer_id=" . $_SESSION['customer_id']);

	if (isset($_POST['name'])) {
		$name = isset($_POST['name']) ? trim(strip_tags($_POST['name'])) : '';
		$email = isset($_POST['email']) ? trim(strip_tags($_POST['email'])) : '';
		$telephone = isset($_POST['telephone']) ? trim(strip_tags($_POST['telephone'])) : '';
		$mobile = isset($_POST['mobile']) ? trim(strip_tags($_POST['mobile'])) : '';
		$fax = isset($_POST['fax']) ? trim(strip_tags($_POST['fax'])) : '';
		$password = isset($_POST['password']) ? trim(strip_tags($_POST['password'])) : '';

		if (empty($name)) {
			$result['error'] = 1;
			$result['title'] = $_LANG['error'];
			$result['message'] = $_LANG['user_name_empty'];
			die($json -> encode($result));
		}

		if (empty($email)) {
			$result['error'] = 1;
			$result['title'] = $_LANG['error'];
			$result['message'] = $_LANG['user_email_empty'];
			die($json -> encode($result));
		}

		if (!empty($email) && !is_email($email)) {
			$result['error'] = 1;
			$result['title'] = $_LANG['error'];
			$result['message'] = $_LANG['user_email_error'];
			die($json -> encode($result));
		}

		if (empty($mobile)) {
			$result['error'] = 1;
			$result['title'] = $_LANG['error'];
			$result['message'] = $_LANG['user_mobile_empty'];
			die($json -> encode($result));
		}

		if (!empty($mobile) && !preg_match("/^13[0-9]{1}[0-9]{8}$|15[0189]{1}[0-9]{8}$|189[0-9]{8}$/", $mobile)) {
			$result['error'] = 1;
			$result['title'] = $_LANG['error'];
			$result['message'] = $_LANG['user_mobile_error'];
			die($json -> encode($result));
		}

		$row = $db -> getRow("SELECT user_name FROM  " . $site -> table('customer') . " WHERE email='$email' AND customer_id<>" . $_SESSION['customer_id']);
		if ($row) {
			$result['error'] = 1;
			$result['title'] = $_LANG['error'];
			$result['message'] = $_LANG['user_email_exist'];
			die($json -> encode($result));
		}

		$row = $db -> getRow("SELECT user_name FROM  " . $site -> table('customer') . " WHERE mobile='$mobile' AND customer_id<>" . $_SESSION['customer_id']);

		if ($row) {
			$result['error'] = 1;
			$result['title'] = $_LANG['error'];
			$result['message'] = $_LANG['user_mobile_exist'];
			die($json -> encode($result));
		}

		if (empty($password)) {
			$password = $customer['password'];
		} else {
			$password = $site -> compile_password($password . $customer['salt']);
		}

		$db -> query("UPDATE  " . $site -> table('customer') . " SET name='" . $name . "',email='" . $email . "',telephone='" . $telephone . "',mobile='" . $mobile . "',fax='" . $fax . "',password='" . $password . "' WHERE customer_id=" . $_SESSION['customer_id']);

		$result['error'] = 0;
		$result['title'] = $_LANG['prompt'];
		$result['message'] = $_LANG['user_submit_sucess'];
		die($json -> encode($result));
	}

	$smarty -> assign('customer', $customer);
	$smarty -> display($_CFG['template'] . '/user/edit_info.dwt');
}

if ($act == 'order') {
	if (empty($_SESSION['user_name'])) {
		header("Location: user.php?act=login&lang_id=" . $language_id);
	}

	$order_arr = array();
	$order = $db -> getAll("SELECT * FROM  " . $site -> table('order') . " WHERE customer_id=" . $_SESSION['customer_id'] . " AND is_delete=0 ORDER BY order_id DESC");
	foreach($order as $val) {
		$val['status_txt'] = get_order_status($val['status']);
		$order_arr[] = $val;
	}
	$smarty -> assign('order', $order_arr);
	$smarty -> display($_CFG['template'] . '/user/order.dwt');
	die();
}

if ($act == 'order_detail') {
	if (empty($_SESSION['user_name'])) {
		header("Location: user.php?act=login&lang_id=" . $language_id);
	}
	$order_id = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;

	$order = $db -> getRow("SELECT * FROM  " . $site -> table('order') . " WHERE order_id=" . $order_id . " AND customer_id=" . $_SESSION['customer_id'] . " AND is_delete=0");
	if (empty($order)) {
		return ;
	}

	$province_name = '';
	$city_name = '';
	$district_name = '';

	$province = get_region($order['shipping_province']);
	if ($province) {
		$province_name = $province['region_name'];
	}

	$city = get_region($order['shipping_city']);
	if ($city) {
		$city_name = $city['region_name'];
	}

	$district = get_region($order['shipping_district']);
	if ($district) {
		$district_name = $district['region_name'];
	}

	$payment = get_payment($order['payment_method']);

	$order['payment_method'] = $payment['pay_name'];
	$order['address'] = $province_name . $city_name . $district_name . $order['address'];
	$order['status_txt'] = get_order_status($order['status']);

	$order_product_arr = array();
	$order_product = $db -> getAll("SELECT * from  " . $site -> table('order_product') . " where order_id=" . $order_id);

	foreach($order_product as $val) {
		$val['url'] = get_url('product_detail', $val['product_id']);
		$order_product_arr[] = $val;
	}

	$order['total_amount'] = number_format($order['order_amount'] + $order['shipping_fee'], 2);
	$smarty -> assign('order', $order);
	$smarty -> assign('order_product', $order_product);
	$smarty -> display($_CFG['template'] . '/user/order_detail.dwt');
	die();
}

if ($act == 'order_cancel') {
	$result = array();
	if (empty($_SESSION['user_name'])) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_no_login'];
		die($json -> encode($result));
	}

	$order_id = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;
	$order = $db -> getRow("SELECT * FROM  " . $site -> table('order') . " WHERE order_id=" . $order_id . " AND customer_id=" . $_SESSION['customer_id'] . " AND is_delete=0 AND status = " . OS_UNPAYED);
	if (empty($order)) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_order_not_exist'];
		die($json -> encode($result));
	}

	$db -> query("UPDATE  " . $site -> table('order') . " SET status=" . OS_CANCELED . " WHERE order_id=" . $order_id);

	$result['error'] = 0;
	$result['title'] = $_LANG['prompt'];
	$result['message'] = $_LANG['user_order_cancel'];
	die($json -> encode($result));
}

if ($act == 'order_receiving') {
	$result = array();
	if (empty($_SESSION['user_name'])) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_no_login'];
		die($json -> encode($result));
	}

	$order_id = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;
	$order = $db -> getRow("SELECT * FROM  " . $site -> table('order') . " WHERE order_id=" . $order_id . " AND customer_id=" . $_SESSION['customer_id'] . " AND is_delete=0 AND status = " . OS_SHIPPED);
	if (empty($order)) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_order_not_exist'];
		die($json -> encode($result));
	}

	$db -> query("UPDATE  " . $site -> table('order') . " SET status=" . OS_COMPLETE . " WHERE order_id=" . $order_id);

	$result['error'] = 0;
	$result['title'] = $_LANG['prompt'];
	$result['message'] = $_LANG['user_receipt_success'];
	die($json -> encode($result));
}

if ($act == 'order_return') {
	$result = array();
	if (empty($_SESSION['user_name'])) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_no_login'];
		die($json -> encode($result));
	}

	$order_id = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;
	$order = $db -> getRow("SELECT * FROM  " . $site -> table('order') . " WHERE order_id=" . $order_id . " AND customer_id=" . $_SESSION['customer_id'] . " AND is_delete=0 AND status = " . OS_SHIPPED);
	if (empty($order)) {
		$result['error'] = 1;
		$result['title'] = $_LANG['error'];
		$result['message'] = $_LANG['user_order_not_exist'];
		die($json -> encode($result));
	}

	$db -> query("UPDATE  " . $site -> table('order') . " SET status=" . OS_RETURNED . " WHERE order_id=" . $order_id);

	$result['error'] = 0;
	$result['title'] = $_LANG['prompt'];
	$result['message'] = $_LANG['user_submit_sucess'];
	die($json -> encode($result));
}

if ($act == 'order_payment') {
}

if ($act == 'address') {
	if (empty($_SESSION['user_name'])) {
		header("Location: user.php?act=login&lang_id=" . $language_id);
	}
	$address_id = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;

	if ($address_id) {
		$address = $db -> getRow("SELECT * FROM  " . $site -> table('customer_address') . " WHERE address_id=" . $address_id . " AND customer_id=" . $_SESSION['customer_id']);
		if (empty($address)) {
			return ;
		}
		$address['country'] = get_region($address['country_id'])['region_name'];

		$smarty -> assign('address', $address);
		$smarty -> display($_CFG['template'] . '/user/edit_address.dwt');
	}
}

?>