<?php
require_once("sonsin.db.conf.php");


class sonsin_db {
	var $seleLink = null;
	var $modiLink = null;
	var $insertID = 0;
	var $fetchMod = MYSQL_ASSOC;
	var $errornum = 0;
	var $tblFields = null;
	var $dateStyle = "Y-m-d H:i:s";
	
	function sonsin_db($ar) {
		if(is_array($ar['sele']) && is_array($ar['modi'])) {
			$limit_server = true;
		} else {
			$limit_server = false;
		}
		
		if($limit_server) {
			$trynum = 1;
			$rand = mt_rand(1, count($ar['sele'])) - 1;
			while(!$this->seleLink = @mysql_pconnect($ar['sele'][$rand]['host'], $ar['sele'][$rand]['user'], $ar['sele'][$rand]['pswd'])) {
				$rand = mt_rand(1, count($ar['sele'])) - 1;
				if($trynum >= count($ar['sele'])) {
					$this->errornum = '1001';
					break;
				}
				$trynum ++;
			}
			
			if(!@mysql_select_db($ar['sele'][$rand]['db'], $this->seleLink)) {
				$this->errornum = '1002';
			}
			
			
			$trynum = 1;
			$rand = mt_rand(1, count($ar['modi'])) - 1;
			while(!$this->modiLink = @mysql_pconnect($ar['modi'][$rand]['host'], $ar['modi'][$rand]['user'], $ar['modi'][$rand]['pswd'])) {
				$rand = mt_rand(1, count($ar['modi'])) - 1;
				if($trynum >= count($ar['modi'])) {
					$this->errornum = '1001';
					break;
				}
				$trynum ++;
			}
			
			if(!@mysql_select_db($ar['modi'][$rand]['db'], $this->modiLink)) {
				$this->errornum = '1002';
			}
		} else {
			$trynum = 1;
			$rand = mt_rand(1, count($ar)) - 1;
			while(!$this->seleLink = @mysql_pconnect($ar[$rand]['host'], $ar[$rand]['user'], $ar[$rand]['pswd'])) {
				$rand = mt_rand(1, count($ar)) - 1;
				if($trynum >= count($ar)) {
					$this->errornum = '1001';
					break;
				}
				$trynum ++;
			}

			if(!@mysql_select_db($ar[$rand]['db'], $this->seleLink)) {
				$this->errornum = '1002';
			}
		}
	}
	
	function fetchRow($sql) {
		$Rs = $this->query($sql, 'sele');
		
		if($this->errornum != 0) {
			return;
		}
		
		while($ar = @mysql_fetch_array($Rs, $this->fetchMod)) {
			if(is_array($this->tblFields[$ar["moudle"]])){
				foreach($this->tblFields[$ar["moudle"]] as $val){
					preg_match("/<{$val}>[^<]*<\/{$val}>/im", $ar["content"], $tmp);
					
					$ar[$val] = $tmp ? preg_replace("/<\/?{$val}>/i", "", $tmp[0]) : "";
					$ar[$val] = $this->htmldecode($ar[$val]);
					
					if(in_array($val, $this->getDateTimeFields()) && !preg_match("/[^0-9]+/", $ar[$i][$val]))
					{
						$ar[$val] = date($this->dateStyle, intVal($ar[$val]));
					}
				}
				unset($ar["moudle"], $ar["content"]);
			}
			break;
		}
		
		return is_array($ar) ? $ar : array();
	}
	
	function fetchAll($sql) {
		$Rs = $this->query($sql, 'sele');

		if($this->errornum != 0) {
			return;
		}
		
		$i = 0;		
		while($ar[] = @mysql_fetch_array($Rs, $this->fetchMod)) {
			if(is_array($this->tblFields[$ar[$i]["moudle"]])){
				foreach($this->tblFields[$ar[$i]["moudle"]] as $val){
					preg_match("/<{$val}>[^<]*<\/{$val}>/i", $ar[$i]["content"], $tmp);
					$ar[$i][$val] = $tmp ? preg_replace("/<\/?{$val}>/i", "", $tmp[0]) : "";
					$ar[$i][$val] = $this->htmldecode($ar[$i][$val]);
					
					if(in_array($val, $this->getDateTimeFields()) && !preg_match("/[^0-9]+/", $ar[$i][$val]))
					{
						$ar[$i][$val] = date($this->dateStyle, intVal($ar[$i][$val]));
					}
				}
			}
			unset($ar[$i]["moudle"], $ar[$i]["content"]);
			$i++;
		}
		return is_array($ar) ? $ar : array();
	}
	
	function insert($sql) {
		return $this->query($sql, 'modi');
	}
	
	function update($sql) {
		return $this->query($sql, 'modi');
	}
	
	function delete($sql) {
		return $this->query($sql, 'modi');
	}
	
	function getLink($mode) {
		$links = array(
			'sele' => $this->seleLink,
			'modi' => $this->modiLink
		);
		
		$link = in_array($mode, array('sele', 'modi')) ? $links[$mode] : null;
		if($link == null) {
			foreach($links as $val) {
				if($val != null) {
					$link = $val;
				}
			}
		}
		
		return $link;
	}
	
	function query($sql, $mode) {
		$this->errornum = 0;
		$link = $this->getLink($mode);
		$Rs = @mysql_query($sql, $link);
		if(!$Rs) {
			$this->errornum = mysql_errno();
		}
		
		if($mode != 'sele') {
			$this->insertID = @mysql_insert_id($link);
			$Rs = mysql_affected_rows($link) >= 0;
		}

		return $Rs;
	}
	
	function setFetchMode($mode) {
		if(in_array($mode, array(1, 2, 3))) {
			$this->fetchMode = $mode;
		}
	}
	
	function getDateTimeFields()
	{
		$ar = array();
		if(!is_null(CONF_DEFAULT_DATETIME_FIELD))
		{
			$ar = explode(",", CONF_DEFAULT_DATETIME_FIELD);
		}
		
		return $ar;
	}
	
	function htmldecode($str)
	{
		$src = array('&amp;', '&quot;', '&#039;', '&lt;', '&gt;');
		$res = array('&','"',"'",'<','>');
		
		foreach($src as $k => $v)
		{
			$str = preg_replace("/". $v . "/i", $res[$k], $str);
		}
		
		return $str; 	
	}
}

class SonsinAct {
	var $dbObj = null;
	var $errornum = 0;
	var $tblName = null;
	var $tblFields = null; 
	var $insertID = 0;
	var $moudle = null;

	function SonsinAct() {
		$this->dbObj = new sonsin_db($GLOBALS["DB_CONN_STR"]);
		$this->errornum = $this->dbObj->errornum;
		$this->InitTabFields();
	}
	
	function SetDateStyle($style)
	{
		if(empty($style))
		{
			return;
		}
		
		$arTmp = array();		
		for($i = 0;$i < strlen($style); $i++)
		{
			$tmp = substr($style, $i, 1);
			if(ord($tmp) > 127)
			{
				$tmp = substr($style, $i, 2);
				$i++;
			}
			
			$arTmp[count($arTmp)] = $tmp;
		}
		
		$style = array();
		foreach($arTmp as $key => $val)
		{
			$val = strtolower($val);
			if(preg_match("/[a-z]{1}/i", $val))
			{
				if(in_array($val, array("y", "m", "n", "j", "d", "g", "h", "i", "s")))
				{
					$style[count($style)] = $arTmp[$key];				
				}
			}
			else
			{
				$style[count($style)] = $arTmp[$key];
			}
		}
		$style = join("", $style);
		
		if(strlen($style) < 1)
		{
			return;
		}
		
		$this->dbObj->dateStyle = $style;
	}
	
	function InitTabFields() {
		require_once("ServiceKey.php");
		require_once("class.nusoap.php");
		
		@session_start();		
		if(!is_array($_SESSION["tblNames"]))
		{
			$getProcID = array(
					'APID' => SONSIN_APID,
		    	'CorpID' => SONSIN_USERID,
					'ServiceKey' => '',
					'TimeStamp' => time()
			);
			$getProcID['ServiceKey'] = getServiceKey($getProcID);
			
			$client = new nu_soapclient(SERVER_URI . "procid.php");
				
			$ar = $client->call('GetProcID', $getProcID, SONSIN_NAMESPACE, SONSIN_NAMESPACE . 'GetProcID');
			
			if(is_array($ar))
			{
				if($ar['ResultCode'] != "3000")
				{
					$TransactionID = 'SONSIN';
				}
				else
				{
					$TransactionID = unserialize(base64_decode($ar['ResultMsg']));
				}
				unset($getProcID, $client, $ar);
				$getRecord = array(
					'APID' => SONSIN_APID,
					'UserID' => SONSIN_USERID,
					'ServiceKey' => "",
					'TimeStamp' => time(),
					'TransactionID' => $TransactionID,
					'ProcessRecord' => array(
						"tblName" => 'TABS',
						'CPage' => "1",
						'PSize' => "5000"
					)
				);
				
				$getRecord['ProcessRecord'] = serialize($getRecord['ProcessRecord']);
				$getRecord['ServiceKey'] = getServiceKey($getRecord);
				
				$client = new nu_soapclient(SERVER_URI . "list.php");

				$ar = $client->call('GetRecord', $getRecord, SONSIN_NAMESPACE, SONSIN_NAMESPACE . 'GetRecord');
				
				if(is_array($ar) && $ar['ResultCode'] == "3000")
				{
					$ar['ResultMsg'] = unserialize(base64_decode($ar['ResultMsg']));
					$ar['ResultMsg'] = $ar['ResultMsg']['RECORD'];
					
					foreach($ar['ResultMsg'] as $val)
					{
						$_SESSION["tblNames"][$val["tbname"]] = unserialize(base64_decode($val['tbfield']));
					}
					$this->SetFieldInFile(base64_encode(serialize($_SESSION["tblNames"])));
				}
				else
				{
					$_SESSION["tblNames"] = $this->GetFieldByFile();					
				}
			}
			else
			{
				
				$_SESSION["tblNames"] = $this->GetFieldByFile();
			}
		}
		$this->dbObj->tblFields = $_SESSION["tblNames"];
	}
	
	function SeleTable($tblName) {
		$this->tblName = "tbrecord";
		$this->moudle = $tblName;
		$this->tblFields = $this->dbObj->tblFields[$tblName];
	}

	function AddOne($postlist) {
		$tmp = array();
		$sql = "INSERT INTO $this->tblName (moudle, content) VALUES ('" . $this->moudle . "',";
		
		foreach($this->tblFields as $val) {
			$tmp[$val] = isset($postlist[$val]) ? $postlist[$val] : '';
			$tmp[$val] = "<{$val}>" . htmlspecialchars($tmp[$val]) . "</{$val}>";
		}
		
		$sql = $sql . "'" . (join("", $tmp)) . "');";
		
		$this->dbObj->insert($sql);
		$this->insertID = $this->dbObj->insertID;
		$this->errornum = $this->dbObj->errornum;
		return $this->errornum == 0;
	}
	
	function ModOne($postlist) {
		$ar = $this->GetOne(array("id" => array("opera" => "=", "value" => $postlist["id"])));
		foreach($this->tblFields as $val){
			if(!isset($postlist[$val])) $postlist[$val] = $ar[$val];
		}
		
		$tmp = array();
		$sql = "update $this->tblName set content = '";

		foreach($this->tblFields as $val) {
			if($val == "id")continue;
			$tmp[$val] = "<{$val}>" . htmlspecialchars($postlist[$val]) . "</{$val}>";
		}
		$ID = $postlist["id"];unset($postlist["id"]);
		
		$sql = $sql . (join("", $tmp)) . "' where id = $ID;";

		$this->dbObj->update($sql);
		$this->errornum = $this->dbObj->errornum;
		return $this->errornum == 0;
	}
	
	function DelOne($DeleteID) {
		if(!is_array($DeleteID)) {
			$DeleteID = array($DeleteID);
		}
		
		foreach($DeleteID as $key => $val) {
			if(!preg_match("/[0-9]+/", $val)) {
				$DeleteID[$key] = 0;
			}
		}
		
		$sql = "delete from $this->tblName where id in(" . join(",", $DeleteID) . ");";
		$this->dbObj->delete($sql);
		$this->errornum = $this->dbObj->errornum;
		return $this->errornum == 0;
	}
	
	function GetOne($condition = array()) {
		$sql = "select * from $this->tblName where moudle = '{$this->moudle}' ";

		if(count($condition) == 0) {
			$condition['id'] = array('opera' => '=', 'value' => '0');
		}
		
		foreach($condition as $key => $val) {
			if($key != "id")
			{
				switch($val["opera"])
				{
					case "=":
					$val["opera"] = "like";
					$val["value"] = "%<{$key}>{$val["value"]}</{$key}>%";
					break;
					
					case "like":
					$val["value"] = "%<{$key}>%{$val["value"]}%</{$key}>%";
					break;
					
					default:
					continue;
				}
				$key = "content";
			}
			
			$sql .= "and $key {$val['opera']} '{$val['value']}' ";
		}
		
		$sql .= ' order by id desc limit 0,1';
		$ar = $this->dbObj->fetchRow($sql);
				
		$this->errornum = $this->dbObj->errornum;
		
		return $ar;
	}
	
	function GetAll($CPage = 1, $PSize = 20, $condition = array()) {
		$sql = "select * from $this->tblName where moudle = '{$this->moudle}' ";
		$Condition = "";
		if(is_array($condition))
		foreach($condition as $key => $val) {
			if($key != "id")
			{
				switch($val["opera"])
				{
					case "=":
					$val["opera"] = "like";
					$val["value"] = "%<{$key}>{$val["value"]}</{$key}>%";
					break;
					
					case "like":
					$val["value"] = "%<{$key}>%{$val["value"]}%</{$key}>%";
					break;
					
					default:
					continue;
				}
				$key = "content";
			}
			
			$Condition .= "and content {$val['opera']} '{$val['value']}' ";
		}
		
		$sql .= "{$Condition}order by id desc";
		
		if($PSize != "all")
		{
			if($CPage < 1) {
				$CPage = 1;
			}
			
			if($PSize < 1) {
				$PSize = 20;
			}		
			$sql .= " limit ". (($CPage - 1) * $PSize) . ",{$PSize}";
		}
		//echo htmlspecialchars($sql) . "<br>";
		$ar["RECORD"] = $this->dbObj->fetchAll($sql);
		unset($ar["RECORD"][count($ar["RECORD"]) - 1]);

		if($PSize != "all")
		{
			/*ȡҳ*/
			$sql = "select count(id) as MyCount from $this->tblName Where moudle = '{$this->moudle}' {$Condition}";
			$Rs = $this->dbObj->fetchRow($sql);
			$MyCount = $Rs['MyCount'] ? $Rs['MyCount'] : 0;
			
			$Pages = ceil($MyCount/$PSize);
			
			if($CPage > $Pages) {
				$CPage = $Pages;
			}
			
			if($CPage - 5 >= 1) {
				$start = $CPage;
			} else {
				$start = 1;
			}
			
			if($CPage + 5 <= $Pages) {
				$end = $CPage + 5;
			} else {
				$end = $Pages;
			}
			
			for($i = $start,$j=0; $i <= $end; $i++,$j++) {
				$ar["PAGE"]['Pages'][$j] = $i;
			}
			
			if($ar["PAGE"]['Pages']) {
				$ar["PAGE"]['CPage'] = $CPage;
			} else
			{
				$ar = array();
			}
		}
		$this->errornum = $this->dbObj->errornum;
			
		return $ar;
	}
	
	function GetPage($condition = array(), $CPage = 1, $PSize = 20) {
		if($CPage < 1) {
			$CPage = 1;
		}
		
		if($PSize < 1) {
			$PSize = 20;
		}	
		
		$sql = "select count(id) as MyCount from $this->tblName Where moudle = '{$this->moudle}' ";
		
		if(is_array($condition))
		if(is_array($condition))
		foreach($condition as $key => $val) {
			if($key != "id")
			{
				switch($val["opera"])
				{
					case "=":
					$val["opera"] = "like";
					$val["value"] = "%<{$key}>{$val["value"]}</{$key}>%";
					break;
					
					case "like":
					$val["value"] = "%<{$key}>%{$val["value"]}%</{$key}>%";
					break;
					
					default:
					continue;
				}
				$key = "content";
			}
			
			$sql .= "and content {$val['opera']} '{$val['value']}' ";
		}
		
		$Rs = $this->dbObj->fetchRow($sql);
		$MyCount = $Rs['MyCount'] ? $Rs['MyCount'] : 0;
		
		$Pages = ceil($MyCount/$PSize);
		
		if($CPage > $Pages) {
			$CPage = $Pages;
		}
		
		if($CPage - 5 >= 1) {
			$start = $CPage;
		} else {
			$start = 1;
		}
		
		if($CPage + 5 <= $Pages) {
			$end = $CPage + 5;
		} else {
			$end = $Pages;
		}
		
		for($i = $start,$j=0; $i <= $end; $i++,$j++) {
			$ar['Pages'][$j] = $i;
		}
		if($ar['Pages']) {
			$ar['CPage'] = $CPage;
		} else
		{
			$ar = array();
		}
		
		return $ar;
	}
	
	function Execute($sql)
	{
		$this->dbObj->query($sql, "sele");
		return $this->errornum == 0;
	}
	
	
	function GetFieldByFile()
	{
		$text = @file_get_contents($this->GetSysIni());
		if($text !== false)
		{
			return unserialize(base64_decode($text));
		}
		else
		{
			return "";
		}
	}
	
	function SetFieldInFile($fields)
	{
		$hd = @fopen($this->GetSysIni(), "w+");
		@fwrite($hd, $fields);
		@fclose($hd);
	}
	
	function GetSysIni()
	{
		$file = "maincls";
		$i = 1;
		while(!file_exists($file) && $i < 10)
		{
			$file = "../{$file}";
			$i++;
		}
		
		return "$file/sys.ini";
	}
}
?>