<?php
class model{
	public $db;
	public $table; 
	function __construct($db=false){
		if(!$db){
			$this->db=new Db_class(MYSQL_HOST,MYSQL_USER,MYSQL_PWD,MYSQL_DB,MYSQL_CHARSET);			 
		}else{
			$this->db=$db;
		}
	}
	
	/**
	*执行sql语句
	*/
	public function query($sql){
		 
		return $this->db->query($sql);
	}
	
	/**
	 * 将结果集解析成数组
	 */
	public function fetch_array($res,$result_type=MYSQL_ASSOC){
		return $this->db->fetch_array($res,$result_type);	
	}
	
	/**
	 * 从结果集中取一行
	 */
	public function fetch_row($res){
		return $this->db->fetch_row($res);	
	}
	
	/**
	*获取全部数据
	*/
	public function getAll($sql,$cache=0,$expire=60){
		return $this->db->getAll($sql,$cache,$expire);
	}
	/**
	*获取一个字段数据
	*/
	public function getOne($sql,$cache=0,$expire=60){
		return $this->db->getOne($sql,$cache,$expire);
	}
	/**
	*获取一列数据
	*/
	public function getCols($sql,$cache=0,$expire=60){
		return $this->db->getCOls($sql,$cache,$expire);
	}
	/**
	*获取一行数据
	*/
	public function getRow($sql,$cache=0,$expire=60){
		return $this->db->getRow($sql,$cache,$expire);
	}
	/**
	*获取全部数据
	* data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function select($option=array(),&$rscount=false,$cache=0,$expire=60){
		return $this->db->select($this->table,$option,$rscount,$cache,$expire);
	}
	/**
	*获取一个字段
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function selectOne($data=array(),$cache=0,$expire=60){
		return $this->db->selectOne($this->table,$data,$cache,$expire);
	}
	/**
	*获取一行信息
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function selectRow($data=array(),$cache=0,$expire=60){
		return $this->db->selectRow($this->table,$data,$cache,$expire);
	}
	/**
	*获取一列信息
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function selectCols($data=array(),&$rscount=false,$cache=0,$expire=60){
		return $this->db->selectCols($this->table,$data,$rscount,$cache,$expire);
	}
	/*
	*获取记录总数
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function getCount($w=array(),$cache=0,$expire=60){
		return $this->db->getCount($this->table,$w,$cache,$expire);
	}
	/**
	*插入数据
	*data array("title"=>'aaa');
	*/
	public function insert($data){
		return $this->db->insert($this->table,$data);
	}
	/**
	*更新数据
	*data array("title"=>'aaa');
	*where array("id"=>1)
	*/
	public function update($data,$where=""){
		return $this->db->update($this->table,$data,$where);
	}
	/**
	/*修改数字类型
	*/
	public function changenum($fields,$num,$w){
		$this->db->query("UPDATE ".TABLE_PRE."{$this->table} SET $fields=$fields+{$num} WHERE $w ");
	}
	/**
	*删除数据
	*where array("id"=>1)
	*/
	public function delete($where=""){
		return $this->db->delete($this->table,$where);
	}
	
}
