-- phpMyAdmin SQL Dump
-- version 3.5.2
-- http://www.phpmyadmin.net
--
-- 主机: localhost
-- 生成日期: 2014 年 03 月 11 日 14:40
-- 服务器版本: 5.5.25a
-- PHP 版本: 5.4.4

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- 数据库: `hck`
--

-- --------------------------------------------------------

--
-- 表的结构 `hck_activity`
--

CREATE TABLE IF NOT EXISTS `hck_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL COMMENT '活动标题',
  `siteid` smallint(6) NOT NULL COMMENT '分站id',
  `userid` int(11) NOT NULL COMMENT '用户id',
  `keywords` varchar(255) NOT NULL COMMENT 'seo关键词',
  `description` varchar(255) NOT NULL COMMENT 'seo描述',
  `info` varchar(255) NOT NULL COMMENT '简介',
  `status` tinyint(1) NOT NULL COMMENT '状态 0未审核 1通过',
  `dateline` int(11) NOT NULL COMMENT '添加时间',
  `clicks` int(11) NOT NULL COMMENT '点击数',
  `replys` int(11) NOT NULL COMMENT '回复数',
  `content` text NOT NULL COMMENT '内容',
  `starttime` int(11) NOT NULL COMMENT '开始时间',
  `endtime` int(11) NOT NULL COMMENT '结束时间',
  `nickname` varchar(20) NOT NULL COMMENT '昵称',
  `address` varchar(255) NOT NULL COMMENT '活动地址',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='活动表' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_activity_topic`
--

CREATE TABLE IF NOT EXISTS `hck_activity_topic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` smallint(6) NOT NULL COMMENT '分站',
  `act_id` int(11) NOT NULL COMMENT '活动id',
  `userid` int(11) NOT NULL COMMENT '用户id',
  `nickname` varchar(20) NOT NULL COMMENT '用户昵称',
  `status` tinyint(4) NOT NULL COMMENT '状态0审核 1未审核',
  `dateline` int(11) NOT NULL COMMENT '发布时间',
  `f_user_id` int(11) NOT NULL COMMENT '回复的主题用户',
  `f_id` int(11) NOT NULL COMMENT '回复的主题id',
  `content` varchar(255) NOT NULL COMMENT '回复内容',
  PRIMARY KEY (`id`),
  KEY `act_id` (`act_id`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='活动主题表' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_activity_user`
--

CREATE TABLE IF NOT EXISTS `hck_activity_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` smallint(6) NOT NULL COMMENT '分站id',
  `act_id` int(11) NOT NULL COMMENT '活动id',
  `userid` int(11) NOT NULL COMMENT '用户id',
  `status` tinyint(4) NOT NULL COMMENT '状态 0未审核  1通过 ',
  `dateline` int(11) NOT NULL COMMENT '参与时间',
  `telephone` varchar(15) NOT NULL COMMENT '联系电话',
  `nickname` varchar(20) NOT NULL COMMENT '昵称',
  `info` varchar(255) NOT NULL COMMENT '简介',
  `logo` varchar(225) NOT NULL COMMENT '用户头像',
  PRIMARY KEY (`id`),
  KEY `act_user` (`act_id`,`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='参与活动的用户表' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_ad`
--

CREATE TABLE IF NOT EXISTS `hck_ad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cname` varchar(20) NOT NULL COMMENT '广告位',
  `title` varchar(50) NOT NULL COMMENT '广告名称',
  `url` varchar(255) NOT NULL COMMENT '广告链接',
  `info` varchar(255) NOT NULL COMMENT '广告描述',
  `starttime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '开始时间',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结束时间',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `showid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '是否显示',
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分站id',
  `imgurl` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '图片地址',
  `price` decimal(7,2) NOT NULL COMMENT '价格',
  `status` tinyint(1) NOT NULL COMMENT '状态 0不显示 1显示',
  `orderindex` tinyint(1) NOT NULL COMMENT '排序 越大排越前面',
  PRIMARY KEY (`id`),
  KEY `cname_id` (`cname`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='广告表' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_admin`
--

CREATE TABLE IF NOT EXISTS `hck_admin` (
  `adminid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `adminname` varchar(20) COLLATE utf8_bin NOT NULL COMMENT '管理员名称',
  `password` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '管理员id',
  `email` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '邮箱',
  `zuid` smallint(2) unsigned NOT NULL DEFAULT '0' COMMENT '所属组',
  `isfounder` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否创始人',
  PRIMARY KEY (`adminid`),
  KEY `adminname` (`adminname`),
  KEY `zuid` (`zuid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='管理员表' AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_admin_log`
--

CREATE TABLE IF NOT EXISTS `hck_admin_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '登陆者ip',
  `dateline` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '登陆时间',
  `logdesc` varchar(400) COLLATE utf8_bin NOT NULL COMMENT '登陆日志',
  `adminname` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '登陆管理员名称',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='管理员登陆记录' AUTO_INCREMENT=41 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_admin_zu`
--

CREATE TABLE IF NOT EXISTS `hck_admin_zu` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `title` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '组名称',
  `orderindex` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '组排序',
  `content` text COLLATE utf8_bin NOT NULL COMMENT '组权限内容',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='管理员组' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_art`
--

CREATE TABLE IF NOT EXISTS `hck_art` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT '分站id',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '店铺id',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `title` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '标题',
  `dateline` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发表时间',
  `keyword` varchar(125) COLLATE utf8_bin NOT NULL COMMENT 'seo关键词',
  `des` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '描述',
  `click` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '点击数',
  `catid` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '一级分类',
  `isding` tinyint(4) unsigned NOT NULL DEFAULT '0' COMMENT '是否置顶',
  `ishot` tinyint(4) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门',
  `isnew` tinyint(4) unsigned NOT NULL DEFAULT '0' COMMENT '是否最新 ',
  `istop` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐',
  `catid_2nd` int(11) NOT NULL COMMENT '二级分类',
  `catid_3nd` int(11) NOT NULL COMMENT '三级分类',
  PRIMARY KEY (`id`),
  KEY `catid_siteid_id` (`catid`,`siteid`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='文章表' AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_art_cat`
--

CREATE TABLE IF NOT EXISTS `hck_art_cat` (
  `catid` int(6) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT '站点id',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '店铺id',
  `cname` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '分类名称',
  `title` varchar(200) COLLATE utf8_bin NOT NULL COMMENT 'seo标题',
  `orderid` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `pid` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类 id',
  `keyword` varchar(200) COLLATE utf8_bin NOT NULL COMMENT 'seo关键词',
  `info` varchar(250) COLLATE utf8_bin NOT NULL COMMENT 'seo描述',
  `cattpl` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '栏目模版',
  `listtpl` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '列表模版',
  `contpl` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '内容模版',
  `t` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型 0栏目 1列表',
  PRIMARY KEY (`catid`),
  KEY `orderid` (`orderid`),
  KEY `shopid` (`shopid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='文章分类表' AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_art_comment`
--

CREATE TABLE IF NOT EXISTS `hck_art_comment` (
  `rid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '评论id',
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT '分站id',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '店铺id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '评论主题id',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `dateline` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '评论时间id',
  `title` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '标题',
  `content` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '内容',
  `ip` varchar(30) COLLATE utf8_bin NOT NULL,
  `reply` varchar(1000) COLLATE utf8_bin NOT NULL COMMENT '回复',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态 0未审核 1显示 2禁止',
  `username` varchar(30) COLLATE utf8_bin NOT NULL COMMENT '发表者名称',
  PRIMARY KEY (`rid`),
  KEY `shopid_status_rid` (`shopid`,`status`,`rid`),
  KEY `pid_shopid_status_rid` (`pid`,`shopid`,`status`,`rid`),
  KEY `userid_rid` (`userid`,`rid`),
  KEY `pid_status_rid` (`pid`,`status`,`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='文章评论表' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_art_data`
--

CREATE TABLE IF NOT EXISTS `hck_art_data` (
  `id` int(11) unsigned NOT NULL,
  `content` text COLLATE utf8_bin NOT NULL COMMENT '文章内容',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='文章内容表';

-- --------------------------------------------------------

--
-- 表的结构 `hck_at`
--

CREATE TABLE IF NOT EXISTS `hck_at` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '@用户id',
  `touserid` int(11) NOT NULL DEFAULT '0' COMMENT '@对象用户id',
  `content` text CHARACTER SET utf8 NOT NULL COMMENT '内容',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `dateline` int(11) NOT NULL DEFAULT '0' COMMENT '发表时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='用户@表' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_blog`
--

CREATE TABLE IF NOT EXISTS `hck_blog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` int(10) unsigned NOT NULL COMMENT '分站id',
  `userid` int(10) unsigned NOT NULL COMMENT '用户id',
  `nickname` char(20) NOT NULL COMMENT '昵称',
  `dateline` int(10) unsigned NOT NULL COMMENT '发表时间',
  `content` varchar(255) NOT NULL COMMENT '内容',
  `status` tinyint(1) NOT NULL COMMENT '状态',
  `forbid` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否禁止 1禁止 0显示',
  `fuserid` int(10) unsigned NOT NULL COMMENT '原帖 用户id',
  `fnickname` char(20) NOT NULL COMMENT '原帖昵称',
  `comments` mediumint(8) unsigned NOT NULL COMMENT '评论数',
  `forwards` mediumint(8) unsigned NOT NULL COMMENT '转发数',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='说说表' AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_blog_comment`
--

CREATE TABLE IF NOT EXISTS `hck_blog_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` smallint(6) NOT NULL DEFAULT '0',
  `blogid` int(11) NOT NULL DEFAULT '0' COMMENT '说说id',
  `userid` mediumint(9) NOT NULL COMMENT '用户id',
  `nickname` varchar(20) CHARACTER SET utf8 NOT NULL COMMENT '用户昵称',
  `content` text CHARACTER SET utf8 NOT NULL COMMENT '评论内容',
  `dateline` int(11) NOT NULL COMMENT '开始时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  `forbid` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否禁止',
  `newdateline` int(11) NOT NULL DEFAULT '0' COMMENT '更新的时间',
  PRIMARY KEY (`id`),
  KEY `picid` (`blogid`,`userid`),
  KEY `uid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='说说评论表' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_cai`
--

CREATE TABLE IF NOT EXISTS `hck_cai` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT '分站id',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '店铺id',
  `title` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '标题',
  `catid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `isding` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否置顶',
  `reply` smallint(6) NOT NULL DEFAULT '0' COMMENT '回复数',
  `img` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '图片',
  `des` varchar(255) COLLATE utf8_bin NOT NULL COMMENT 'seo描述',
  `keyword` varchar(200) COLLATE utf8_bin NOT NULL COMMENT 'seo关键词',
  `author` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '作者',
  `cainum` smallint(6) unsigned NOT NULL DEFAULT '10' COMMENT '美食数量',
  `dateline` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发布时间',
  `thum_img` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '缩略图',
  `delicious` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '好吃',
  `ishot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门',
  `isnew` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否最新',
  `visible` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
  `price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '价格',
  `doid` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '做法',
  `weiid` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '味道',
  `promote` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否促销',
  `undelicious` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '难吃',
  `lowprice` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '促销价格',
  `oos` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '缺货',
  `middle_img` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '中图片',
  `orders` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '购买数',
  `week1` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '星期一 0不上线 1上线',
  `week2` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `week3` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `week4` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `week5` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `week6` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `week7` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `click` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '点击数',
  `favs` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '收藏数',
  `grade` int(11) NOT NULL COMMENT '积分',
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`),
  KEY `shopid` (`shopid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='菜单表' AUTO_INCREMENT=20 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_caipu`
--

CREATE TABLE IF NOT EXISTS `hck_caipu` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '描述',
  `cat_id` int(11) NOT NULL COMMENT '一级分类',
  `cat_id_two` int(11) NOT NULL COMMENT '二级分类',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `keywords` varchar(255) NOT NULL COMMENT '关键',
  `description` varchar(255) NOT NULL,
  `maincai` varchar(255) NOT NULL COMMENT '主料',
  `othercai` varchar(255) NOT NULL COMMENT '其他菜',
  `content` text NOT NULL COMMENT '内容',
  `userid` int(11) NOT NULL COMMENT '用户id',
  `dateline` int(11) NOT NULL COMMENT '添加时间',
  `isrecommend` tinyint(4) NOT NULL COMMENT '是否推荐',
  `imgurl` varchar(255) NOT NULL COMMENT '图片地址',
  `tagname` varchar(255) NOT NULL COMMENT '标签名称',
  `wei_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '味道',
  `do_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '做法',
  PRIMARY KEY (`id`),
  KEY `cat_id` (`cat_id`,`cat_id_two`,`id`),
  KEY `cat_id_id` (`cat_id`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='菜谱表' AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_caipu_cat`
--

CREATE TABLE IF NOT EXISTS `hck_caipu_cat` (
  `catid` smallint(6) NOT NULL AUTO_INCREMENT,
  `pid` smallint(6) NOT NULL COMMENT '上级分类',
  `cname` varchar(20) NOT NULL COMMENT '分类名称',
  `orderindex` tinyint(4) NOT NULL COMMENT '排序',
  `title` varchar(225) NOT NULL,
  `keywords` varchar(225) NOT NULL,
  `description` varchar(225) NOT NULL,
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='菜谱分类表' AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_caipu_tags`
--

CREATE TABLE IF NOT EXISTS `hck_caipu_tags` (
  `tagid` int(11) NOT NULL AUTO_INCREMENT,
  `tagname` varchar(10) NOT NULL COMMENT '标签名称',
  `status` tinyint(1) NOT NULL COMMENT '状态 0不显示 1显示',
  `orderindex` tinyint(4) NOT NULL COMMENT '排序',
  `c_num` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '菜谱数量',
  PRIMARY KEY (`tagid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='菜谱标签' AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_caipu_tags_index`
--

CREATE TABLE IF NOT EXISTS `hck_caipu_tags_index` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tagid` int(11) NOT NULL COMMENT '标签id',
  `caipu_id` int(11) NOT NULL COMMENT '菜谱id',
  PRIMARY KEY (`id`),
  KEY `tagid_cid` (`tagid`,`caipu_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='菜谱标签索引' AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_cai_cat`
--

CREATE TABLE IF NOT EXISTS `hck_cai_cat` (
  `catid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT '站点id',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '店铺id',
  `cname` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '分类名称',
  `orderid` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`catid`),
  KEY `shopid` (`shopid`),
  KEY `orderid` (`orderid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='美食分类表' AUTO_INCREMENT=16 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_cai_comment`
--

CREATE TABLE IF NOT EXISTS `hck_cai_comment` (
  `rid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `pid` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `dateline` int(11) unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) COLLATE utf8_bin NOT NULL,
  `content` varchar(255) COLLATE utf8_bin NOT NULL,
  `reply` varchar(255) COLLATE utf8_bin NOT NULL,
  `ip` varchar(50) COLLATE utf8_bin NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `username` varchar(30) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `pid_status_rid` (`pid`,`status`,`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='美食评论表  同文章评论' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_cai_data`
--

CREATE TABLE IF NOT EXISTS `hck_cai_data` (
  `id` mediumint(9) NOT NULL,
  `content` text CHARACTER SET utf8 NOT NULL COMMENT '内容',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='美食内容表';

-- --------------------------------------------------------

--
-- 表的结构 `hck_cai_do`
--

CREATE TABLE IF NOT EXISTS `hck_cai_do` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `dname` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '做法名称',
  `orderid` smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='美食做法' AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_cai_ping`
--

CREATE TABLE IF NOT EXISTS `hck_cai_ping` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `caiid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ctype` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1好吃 2难吃',
  `ip` varchar(50) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `caiid` (`caiid`,`userid`),
  KEY `shopid` (`shopid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='美食点评' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_cai_tags`
--

CREATE TABLE IF NOT EXISTS `hck_cai_tags` (
  `caiid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `tagname` varchar(30) COLLATE utf8_bin NOT NULL,
  KEY `caiid` (`caiid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='美食标签';

-- --------------------------------------------------------

--
-- 表的结构 `hck_cai_wei`
--

CREATE TABLE IF NOT EXISTS `hck_cai_wei` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `wname` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '味道名称',
  `orderid` smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='美食味道' AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_city`
--

CREATE TABLE IF NOT EXISTS `hck_city` (
  `cityid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `provinceid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '一级区域id',
  `city` varchar(30) COLLATE utf8_bin NOT NULL COMMENT '名称',
  `orderindex` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `lat` decimal(9,6) NOT NULL COMMENT '纬度',
  `lng` decimal(9,6) NOT NULL COMMENT '精度',
  PRIMARY KEY (`cityid`),
  KEY `orderindex` (`orderindex`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='二级区域' AUTO_INCREMENT=6 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_config`
--

CREATE TABLE IF NOT EXISTS `hck_config` (
  `id` tinyint(1) NOT NULL AUTO_INCREMENT,
  `opentime` tinyint(4) NOT NULL DEFAULT '0' COMMENT '开业时间',
  `phone_on` tinyint(4) NOT NULL DEFAULT '0' COMMENT '开通短信',
  `phone_user` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '短信用户',
  `phone_pwd` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '短信密码',
  `phone_num` varchar(20) COLLATE utf8_bin NOT NULL COMMENT '短信号码',
  `smtphost` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '邮箱服务器',
  `smtpport` smallint(6) NOT NULL DEFAULT '0' COMMENT '邮箱端口',
  `smtpemail` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '发送的邮箱',
  `smtpuser` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '邮箱用户',
  `smtppwd` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '邮箱密码',
  `water_on` tinyint(4) NOT NULL DEFAULT '0' COMMENT '水印开启',
  `water_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '水印类型',
  `water_pos` tinyint(4) NOT NULL DEFAULT '0' COMMENT '水印位置',
  `water_str` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '水印文字',
  `water_img` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '水印图片',
  `water_size` tinyint(4) NOT NULL DEFAULT '0' COMMENT '水印大小',
  `rewrite_on` tinyint(1) NOT NULL DEFAULT '0' COMMENT '伪静态开关',
  `sina_on` tinyint(4) NOT NULL DEFAULT '0' COMMENT '新浪注册',
  `qq_on` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'qq注册',
  `sina_user` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '新浪app',
  `sina_pwd` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '新浪app密码',
  `qq_user` varchar(100) COLLATE utf8_bin NOT NULL COMMENT 'qq用户',
  `qq_pwd` varchar(100) COLLATE utf8_bin NOT NULL COMMENT 'qq密码',
  `spread_on` tinyint(4) NOT NULL DEFAULT '0' COMMENT '推广设置',
  `spread_discount` tinyint(4) NOT NULL DEFAULT '0' COMMENT '推广折扣',
  `grade_on` tinyint(4) NOT NULL DEFAULT '0' COMMENT '积分开关',
  `thumb_width` smallint(6) NOT NULL DEFAULT '0' COMMENT '缩略图 宽度',
  `thumb_height` smallint(6) NOT NULL DEFAULT '0' COMMENT '缩略图高度',
  `alipay` tinyint(1) NOT NULL DEFAULT '0' COMMENT '阿里支付',
  `tenpay` tinyint(1) NOT NULL DEFAULT '0' COMMENT '财付通支付',
  `maxgrade` smallint(6) NOT NULL DEFAULT '0' COMMENT '签到最大积分',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='站点配置表' AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_fav_cai`
--

CREATE TABLE IF NOT EXISTS `hck_fav_cai` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT '站点id',
  `shopid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '店铺id',
  `caiid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '菜id',
  `userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `shopname` varchar(20) NOT NULL COMMENT '店铺名称',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='收藏美食表' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_fav_shop`
--

CREATE TABLE IF NOT EXISTS `hck_fav_shop` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT '站点id',
  `shopid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '店铺id',
  `userid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `dateline` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '时间',
  PRIMARY KEY (`id`),
  KEY `shopid` (`shopid`,`userid`),
  KEY `userid` (`userid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='收藏店铺表' AUTO_INCREMENT=10 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_flash`
--

CREATE TABLE IF NOT EXISTS `hck_flash` (
  `fid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) NOT NULL DEFAULT '0',
  `ftitle` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '广告标题',
  `furl` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '广告链接',
  `fimg` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '广告图片',
  `forder` tinyint(4) unsigned NOT NULL DEFAULT '0' COMMENT '广告排序',
  PRIMARY KEY (`fid`),
  KEY `shopid` (`shopid`),
  KEY `siteid_fid` (`siteid`,`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='flash轮播表' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_follow`
--

CREATE TABLE IF NOT EXISTS `hck_follow` (
  `userid` mediumint(9) NOT NULL,
  `touserid` mediumint(9) NOT NULL,
  `status` tinyint(1) NOT NULL COMMENT '1关注 2双向关注',
  `dateline` int(11) NOT NULL DEFAULT '0',
  KEY `uid` (`userid`,`touserid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='用户关注表';

-- --------------------------------------------------------

--
-- 表的结构 `hck_goods`
--

CREATE TABLE IF NOT EXISTS `hck_goods` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `catid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `title` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '标题',
  `thumb_img` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '缩略图',
  `middle_img` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '中图',
  `img` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '大图',
  `info` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '简介',
  `price` decimal(8,2) NOT NULL COMMENT '价格',
  `grade` mediumint(9) unsigned NOT NULL COMMENT '所需积分',
  `content` text COLLATE utf8_bin NOT NULL COMMENT '内容',
  `orders` mediumint(9) unsigned NOT NULL COMMENT '兑换次数',
  `visible` tinyint(1) unsigned NOT NULL,
  `comments` mediumint(9) unsigned NOT NULL COMMENT '评论数',
  `clicks` mediumint(9) unsigned NOT NULL COMMENT '点击数',
  `isrecommend` tinyint(1) unsigned NOT NULL,
  `isnew` tinyint(1) unsigned NOT NULL,
  `ishot` tinyint(1) unsigned NOT NULL,
  `keyword` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '关键字',
  `dateline` int(11) unsigned NOT NULL,
  `payprice` decimal(7,2) NOT NULL COMMENT '支付价格',
  PRIMARY KEY (`id`),
  KEY `catid_id` (`catid`,`id`),
  KEY `visible_catid` (`visible`,`catid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='积分商品表' AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_goods_cat`
--

CREATE TABLE IF NOT EXISTS `hck_goods_cat` (
  `catid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `cname` varchar(20) COLLATE utf8_bin NOT NULL,
  `orderindex` smallint(6) unsigned NOT NULL,
  `t` tinyint(1) unsigned NOT NULL,
  `cattpl` varchar(50) COLLATE utf8_bin NOT NULL,
  `listtpl` varchar(50) COLLATE utf8_bin NOT NULL,
  `contpl` varchar(50) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`catid`),
  KEY `orderindex` (`orderindex`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_goods_comment`
--

CREATE TABLE IF NOT EXISTS `hck_goods_comment` (
  `rid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `pid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `userid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `dateline` int(11) NOT NULL DEFAULT '0',
  `title` varchar(100) COLLATE utf8_bin NOT NULL,
  `content` varchar(2000) COLLATE utf8_bin NOT NULL,
  `reply` varchar(1000) COLLATE utf8_bin NOT NULL,
  `ip` varchar(50) COLLATE utf8_bin NOT NULL,
  `status` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `username` varchar(30) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `pid_status_rid` (`pid`,`status`,`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_goods_order`
--

CREATE TABLE IF NOT EXISTS `hck_goods_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `orderno` varchar(50) COLLATE utf8_bin NOT NULL,
  `goodsid` mediumint(8) unsigned NOT NULL,
  `grade` mediumint(9) unsigned NOT NULL,
  `userid` mediumint(9) unsigned NOT NULL,
  `nickname` varchar(20) COLLATE utf8_bin NOT NULL,
  `address` varchar(50) COLLATE utf8_bin NOT NULL,
  `status` tinyint(2) unsigned NOT NULL,
  `phone` varchar(20) COLLATE utf8_bin NOT NULL,
  `email` varchar(20) COLLATE utf8_bin NOT NULL,
  `content` text COLLATE utf8_bin NOT NULL,
  `sendtype` tinyint(4) unsigned NOT NULL,
  `isvalid` tinyint(1) unsigned NOT NULL,
  `money` decimal(8,2) NOT NULL,
  `dateline` int(11) unsigned NOT NULL,
  `goodsname` varchar(30) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `orderno` (`orderno`),
  KEY `dateline_id` (`dateline`,`id`),
  KEY `sendtype_id` (`sendtype`,`id`),
  KEY `userid_isvalid_id` (`userid`,`isvalid`,`id`),
  KEY `isvalid_id` (`isvalid`,`id`),
  KEY `isvalid_dateline_id` (`isvalid`,`dateline`,`id`),
  KEY `userid_sendtype_grade` (`userid`,`sendtype`,`grade`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_grade`
--

CREATE TABLE IF NOT EXISTS `hck_grade` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `grade` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_grade_log`
--

CREATE TABLE IF NOT EXISTS `hck_grade_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `content` varchar(200) COLLATE utf8_bin NOT NULL,
  `grade` decimal(8,2) NOT NULL,
  `dateline` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=12 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_groupbuy`
--

CREATE TABLE IF NOT EXISTS `hck_groupbuy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL,
  `img` varchar(200) NOT NULL,
  `siteid` smallint(6) NOT NULL,
  `shopid` int(11) NOT NULL,
  `catid` smallint(5) unsigned NOT NULL,
  `joins` mediumint(8) unsigned NOT NULL,
  `minjoins` smallint(5) unsigned NOT NULL,
  `goodsprice` decimal(9,1) NOT NULL,
  `groupprice` decimal(9,1) NOT NULL,
  `endtime` int(11) NOT NULL,
  `shopname` varchar(20) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `isrecommend` tinyint(4) NOT NULL,
  `info` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `provinceid` int(10) unsigned NOT NULL,
  `cityid` int(10) unsigned NOT NULL,
  `townid` int(10) unsigned NOT NULL,
  `goods_num` int(11) NOT NULL COMMENT '库存数',
  `grouptype` tinyint(4) NOT NULL DEFAULT '0' COMMENT '团购方式',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_groupbuy_category`
--

CREATE TABLE IF NOT EXISTS `hck_groupbuy_category` (
  `catid` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL,
  `cname` varchar(25) NOT NULL,
  `orderindex` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_groupbuy_order`
--

CREATE TABLE IF NOT EXISTS `hck_groupbuy_order` (
  `orderid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `groupid` int(10) unsigned NOT NULL,
  `userid` int(10) unsigned NOT NULL,
  `phone` varchar(20) NOT NULL,
  `address` varchar(100) NOT NULL,
  `goodsnum` smallint(5) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  `status` tinyint(1) NOT NULL,
  `groupprice` decimal(8,2) NOT NULL,
  `totalprice` decimal(8,2) NOT NULL,
  `nickname` varchar(20) NOT NULL,
  `ispay` tinyint(1) unsigned NOT NULL,
  `intime` int(11) NOT NULL DEFAULT '0' COMMENT '生效时间',
  `shopid` int(11) NOT NULL,
  PRIMARY KEY (`orderid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_guest`
--

CREATE TABLE IF NOT EXISTS `hck_guest` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) COLLATE utf8_bin NOT NULL,
  `content` varchar(255) COLLATE utf8_bin NOT NULL,
  `dateline` int(11) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(50) COLLATE utf8_bin NOT NULL,
  `reply` varchar(255) COLLATE utf8_bin NOT NULL,
  `qq` int(11) NOT NULL DEFAULT '0',
  `email` varchar(100) COLLATE utf8_bin NOT NULL,
  `phone` varchar(20) COLLATE utf8_bin NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `username` varchar(50) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `status_id` (`status`,`id`),
  KEY `status_shopid_id` (`status`,`shopid`,`id`),
  KEY `userid_id` (`userid`,`id`),
  KEY `userid_shopid_id` (`userid`,`shopid`,`id`),
  KEY `shopid_id` (`shopid`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_hotarea`
--

CREATE TABLE IF NOT EXISTS `hck_hotarea` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL,
  `title` varchar(50) COLLATE utf8_bin NOT NULL,
  `lat` decimal(9,6) NOT NULL,
  `lng` decimal(9,6) NOT NULL,
  `orderindex` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_html`
--

CREATE TABLE IF NOT EXISTS `hck_html` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `userid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) COLLATE utf8_bin NOT NULL,
  `keyword` varchar(200) COLLATE utf8_bin NOT NULL,
  `des` varchar(255) COLLATE utf8_bin NOT NULL,
  `tagname` varchar(20) COLLATE utf8_bin NOT NULL,
  `content` text COLLATE utf8_bin NOT NULL,
  `orderid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `isnav` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `catid` tinyint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tagname` (`tagname`),
  KEY `shopid` (`shopid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_html_cat`
--

CREATE TABLE IF NOT EXISTS `hck_html_cat` (
  `catid` tinyint(4) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `cname` varchar(100) COLLATE utf8_bin NOT NULL,
  `orderid` tinyint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`catid`),
  KEY `shopid` (`shopid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_link`
--

CREATE TABLE IF NOT EXISTS `hck_link` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `title` varchar(50) COLLATE utf8_bin NOT NULL,
  `linkurl` varchar(100) COLLATE utf8_bin NOT NULL,
  `linkimg` varchar(100) COLLATE utf8_bin NOT NULL,
  `linktype` tinyint(1) NOT NULL DEFAULT '0',
  `orderid` smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_message`
--

CREATE TABLE IF NOT EXISTS `hck_message` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) unsigned NOT NULL,
  `content` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  `status` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `status_id` (`status`,`id`),
  KEY `userid_status_id` (`userid`,`status`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_nav`
--

CREATE TABLE IF NOT EXISTS `hck_nav` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `title` varchar(30) COLLATE utf8_bin NOT NULL,
  `navurl` varchar(100) COLLATE utf8_bin NOT NULL,
  `orderid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `ctype` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `pid` smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `shopid` (`shopid`),
  KEY `pid` (`pid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_order`
--

CREATE TABLE IF NOT EXISTS `hck_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `userid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `isvalid` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `money` decimal(9,2) NOT NULL DEFAULT '0.00',
  `dateline` int(11) unsigned NOT NULL DEFAULT '0',
  `orderno` varchar(20) COLLATE utf8_bin NOT NULL,
  `ssid` varchar(60) COLLATE utf8_bin NOT NULL,
  `orderphone` varchar(30) COLLATE utf8_bin NOT NULL,
  `orderaddress` varchar(200) COLLATE utf8_bin NOT NULL,
  `orderuser` varchar(100) COLLATE utf8_bin NOT NULL,
  `sendtype` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '配送状态',
  `senddes` text COLLATE utf8_bin NOT NULL,
  `ispay` tinyint(4) unsigned NOT NULL DEFAULT '0' COMMENT '余额支付',
  `iscomment` tinyint(1) unsigned NOT NULL,
  `orderinfo` text COLLATE utf8_bin NOT NULL,
  `received` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '已收货',
  `grade` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `orderno` (`orderno`),
  KEY `money` (`money`),
  KEY `shopid_isvalid_id` (`shopid`,`isvalid`,`id`),
  KEY `userid_isvalid_siteid_id` (`userid`,`isvalid`,`siteid`,`id`),
  KEY `sendtype_money` (`sendtype`,`money`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=15 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_ordershare`
--

CREATE TABLE IF NOT EXISTS `hck_ordershare` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL,
  `shopid` smallint(5) unsigned NOT NULL,
  `userid` int(10) unsigned NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`),
  KEY `shopid` (`shopid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_order_cai`
--

CREATE TABLE IF NOT EXISTS `hck_order_cai` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `orderid` int(11) unsigned NOT NULL DEFAULT '0',
  `caiid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `cainum` smallint(6) unsigned NOT NULL DEFAULT '0',
  `title` varchar(50) COLLATE utf8_bin NOT NULL,
  `price` decimal(8,2) NOT NULL,
  `grade` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `shopid` (`shopid`),
  KEY `orderid` (`orderid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=18 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_photo`
--

CREATE TABLE IF NOT EXISTS `hck_photo` (
  `pid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) NOT NULL DEFAULT '0',
  `title` varchar(100) COLLATE utf8_bin NOT NULL,
  `info` text COLLATE utf8_bin NOT NULL,
  `keyword` varchar(200) COLLATE utf8_bin NOT NULL,
  `des` varchar(255) COLLATE utf8_bin NOT NULL,
  `ctime` int(11) NOT NULL DEFAULT '0',
  `logo` varchar(200) COLLATE utf8_bin NOT NULL,
  `isnew` tinyint(4) NOT NULL DEFAULT '0',
  `isding` tinyint(4) NOT NULL DEFAULT '0',
  `ishot` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_photo_pic`
--

CREATE TABLE IF NOT EXISTS `hck_photo_pic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) NOT NULL DEFAULT '0',
  `pid` smallint(6) NOT NULL DEFAULT '0',
  `picurl` varchar(400) COLLATE utf8_bin NOT NULL,
  `thumb_picurl` varchar(100) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_pm`
--

CREATE TABLE IF NOT EXISTS `hck_pm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` smallint(6) NOT NULL DEFAULT '0',
  `userid` mediumint(9) NOT NULL DEFAULT '0',
  `touserid` mediumint(9) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `dateline` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `useridstatus` tinyint(1) NOT NULL DEFAULT '0',
  `touseridstatus` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`userid`,`touserid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_pm_index`
--

CREATE TABLE IF NOT EXISTS `hck_pm_index` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) NOT NULL,
  `siteid` smallint(6) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL,
  `touserid` int(11) NOT NULL,
  PRIMARY KEY (`cid`),
  KEY `id` (`id`,`userid`,`touserid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_province`
--

CREATE TABLE IF NOT EXISTS `hck_province` (
  `provinceid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `province` varchar(50) NOT NULL,
  `orderindex` tinyint(4) unsigned NOT NULL,
  `lat` decimal(9,6) NOT NULL,
  `lng` decimal(9,6) NOT NULL,
  PRIMARY KEY (`provinceid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_qiandao`
--

CREATE TABLE IF NOT EXISTS `hck_qiandao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `dateline` int(11) NOT NULL,
  `xinqing` varchar(20) NOT NULL,
  `content` varchar(255) NOT NULL,
  `siteid` smallint(6) NOT NULL,
  `day` varchar(20) NOT NULL,
  `times` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid_day` (`userid`,`day`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_room`
--

CREATE TABLE IF NOT EXISTS `hck_room` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` int(6) NOT NULL DEFAULT '0',
  `room_name` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '包间名称',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '包间状态',
  `room_men` smallint(2) NOT NULL DEFAULT '0' COMMENT '包间最大人数',
  `room_pic` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '包间图片',
  `room_desc` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '包间简介',
  `room_content` text COLLATE utf8_bin NOT NULL COMMENT '包间详情',
  `dateline` int(11) NOT NULL COMMENT '发布时间',
  `userid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_roomorder`
--

CREATE TABLE IF NOT EXISTS `hck_roomorder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` int(9) NOT NULL DEFAULT '0',
  `roomid` mediumint(8) unsigned NOT NULL COMMENT '房间id',
  `room_name` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '房间名称',
  `room_men` tinyint(4) NOT NULL COMMENT '房间人数',
  `nickname` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '客户名称',
  `telephone` varchar(30) COLLATE utf8_bin NOT NULL COMMENT '客户联系电话',
  `info` text COLLATE utf8_bin NOT NULL COMMENT '客户提交的信息',
  `dateline` int(11) NOT NULL COMMENT '客户下单时间',
  `status` tinyint(4) NOT NULL COMMENT '状态 0未审核 1审核通过 2已结束 99 已删除',
  `userid` mediumint(9) NOT NULL COMMENT '用户id',
  `reply` text COLLATE utf8_bin NOT NULL COMMENT '回复内容',
  `order_time` int(11) NOT NULL COMMENT '预定时间',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_sendarea`
--

CREATE TABLE IF NOT EXISTS `hck_sendarea` (
  `catid` mediumint(9) NOT NULL AUTO_INCREMENT,
  `pid` mediumint(9) NOT NULL,
  `cname` varchar(255) COLLATE utf8_bin NOT NULL,
  `orderid` smallint(6) NOT NULL,
  `shopid` smallint(6) NOT NULL,
  `info` text COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_seo`
--

CREATE TABLE IF NOT EXISTS `hck_seo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `m` char(10) NOT NULL,
  `a` char(10) NOT NULL,
  `cname` varchar(20) NOT NULL,
  `title` varchar(225) NOT NULL,
  `description` varchar(225) NOT NULL,
  `keywords` varchar(225) NOT NULL,
  `siteid` smallint(6) NOT NULL DEFAULT '0',
  `object_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_session`
--

CREATE TABLE IF NOT EXISTS `hck_session` (
  `id` char(100) NOT NULL,
  `data` varchar(5000) DEFAULT NULL,
  `dateline` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shop`
--

CREATE TABLE IF NOT EXISTS `hck_shop` (
  `shopid` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `gid` tinyint(4) NOT NULL,
  `catid` int(10) unsigned NOT NULL,
  `amid` smallint(5) unsigned NOT NULL COMMENT '人均消费',
  `smid` smallint(5) unsigned NOT NULL COMMENT '起送金额',
  `status` tinyint(1) unsigned NOT NULL,
  `balance` decimal(8,1) NOT NULL,
  `tixian` varchar(255) NOT NULL,
  `userid` int(10) unsigned NOT NULL,
  `shopname` varchar(255) NOT NULL,
  `grade` decimal(6,2) unsigned NOT NULL,
  `logo` varchar(255) NOT NULL,
  `provinceid` tinyint(4) unsigned NOT NULL,
  `cityid` smallint(6) unsigned NOT NULL,
  `townid` mediumint(9) unsigned NOT NULL,
  `qq` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `info` varchar(255) NOT NULL,
  `visible` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `shopno` varchar(255) NOT NULL,
  `starttime` int(11) unsigned NOT NULL,
  `endtime` int(10) unsigned NOT NULL,
  `lasttime` int(11) unsigned NOT NULL,
  `lat` decimal(9,6) NOT NULL,
  `lng` decimal(9,6) NOT NULL,
  `sendarea` varchar(255) NOT NULL,
  `isrecommend` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `address` varchar(255) NOT NULL,
  `orders` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `favs` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `ishot` tinyint(1) unsigned NOT NULL,
  `isnew` tinyint(1) unsigned NOT NULL,
  `content` text NOT NULL,
  `jf_all` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `jf_fuwu` decimal(2,1) unsigned NOT NULL,
  `jf_kouwei` decimal(2,1) unsigned NOT NULL,
  `jf_jiage` decimal(2,1) unsigned NOT NULL,
  `jf_shijian` decimal(2,1) unsigned NOT NULL,
  `sendmeter` smallint(6) NOT NULL DEFAULT '1000',
  `clicks` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`shopid`),
  KEY `siteid_shopid` (`siteid`,`shopid`),
  KEY `siteid_isnew_shopid` (`siteid`,`isnew`,`shopid`),
  KEY `siteid_ishot_shopid` (`siteid`,`ishot`,`shopid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=32 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shopadmin`
--

CREATE TABLE IF NOT EXISTS `hck_shopadmin` (
  `adminid` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `adminname` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `password` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `rank` tinyint(4) NOT NULL DEFAULT '0',
  `email` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`adminid`),
  KEY `adminname` (`adminname`),
  KEY `siteid` (`siteid`),
  KEY `shopid_adminid` (`shopid`,`adminid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shopadmin_log`
--

CREATE TABLE IF NOT EXISTS `hck_shopadmin_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) COLLATE utf8_bin NOT NULL,
  `ztime` int(11) NOT NULL DEFAULT '0',
  `logdesc` varchar(400) COLLATE utf8_bin NOT NULL,
  `adminname` varchar(50) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shoparea`
--

CREATE TABLE IF NOT EXISTS `hck_shoparea` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) NOT NULL DEFAULT '0',
  `provinceid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `cityid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `townid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `shopid` (`shopid`,`provinceid`,`cityid`,`townid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=18 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shopcar`
--

CREATE TABLE IF NOT EXISTS `hck_shopcar` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `userid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `ssid` varchar(60) COLLATE utf8_bin NOT NULL,
  `caiid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `cainum` smallint(6) unsigned NOT NULL DEFAULT '0',
  `title` varchar(50) COLLATE utf8_bin NOT NULL,
  `price` decimal(8,2) NOT NULL,
  `grade` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`),
  KEY `userid` (`userid`,`ssid`),
  KEY `shopid` (`shopid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=20 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shopconfig`
--

CREATE TABLE IF NOT EXISTS `hck_shopconfig` (
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `opentime` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `starthour` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `endhour` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `startminute` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `endminute` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `showweek` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `minprice` decimal(8,2) NOT NULL,
  `sendarea` varchar(255) COLLATE utf8_bin NOT NULL,
  `email` varchar(255) COLLATE utf8_bin NOT NULL,
  `isemail` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `isphone` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phone` varchar(20) COLLATE utf8_bin NOT NULL,
  `sendprice` decimal(4,1) unsigned NOT NULL DEFAULT '0.0',
  `ordertype` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `telephone` varchar(15) COLLATE utf8_bin NOT NULL,
  KEY `shopid` (`shopid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shop_avgmoney`
--

CREATE TABLE IF NOT EXISTS `hck_shop_avgmoney` (
  `amid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL,
  `cname` varchar(25) NOT NULL,
  `orderindex` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`amid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shop_cat`
--

CREATE TABLE IF NOT EXISTS `hck_shop_cat` (
  `catid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL,
  `cname` varchar(25) NOT NULL,
  `orderindex` tinyint(3) unsigned NOT NULL,
  `gid` tinyint(1) NOT NULL,
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shop_check`
--

CREATE TABLE IF NOT EXISTS `hck_shop_check` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL,
  `siteid` smallint(5) unsigned NOT NULL,
  `shopid` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `shopname` varchar(20) NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  `content` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shop_comment`
--

CREATE TABLE IF NOT EXISTS `hck_shop_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL,
  `shopid` mediumint(8) unsigned NOT NULL,
  `ctype` tinyint(1) NOT NULL COMMENT '评价类型 店铺 美食',
  `userid` mediumint(8) unsigned NOT NULL,
  `nickname` varchar(25) COLLATE utf8_bin NOT NULL,
  `orderid` int(10) unsigned NOT NULL,
  `orderno` varchar(20) COLLATE utf8_bin NOT NULL,
  `caiid` mediumint(8) unsigned NOT NULL,
  `jf_fuwu` tinyint(2) unsigned NOT NULL COMMENT '服务',
  `jf_kouwei` tinyint(2) unsigned NOT NULL COMMENT '口味',
  `jf_shijian` tinyint(2) unsigned NOT NULL COMMENT '时间',
  `jf_jiage` tinyint(1) unsigned NOT NULL COMMENT '价格',
  `jf_all` tinyint(1) NOT NULL,
  `status` tinyint(2) unsigned NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  `content` varchar(255) COLLATE utf8_bin NOT NULL,
  `reply` varchar(255) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `siteid_id` (`siteid`,`id`),
  KEY `shopid_status_id` (`shopid`,`status`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shop_data`
--

CREATE TABLE IF NOT EXISTS `hck_shop_data` (
  `shopid` int(11) NOT NULL,
  `content` mediumtext,
  PRIMARY KEY (`shopid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shop_group`
--

CREATE TABLE IF NOT EXISTS `hck_shop_group` (
  `gid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `title` varchar(25) NOT NULL,
  `orderindex` tinyint(4) NOT NULL,
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shop_paylog`
--

CREATE TABLE IF NOT EXISTS `hck_shop_paylog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `shopid` int(10) unsigned NOT NULL,
  `money` decimal(8,1) NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  `content` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shop_sendmoney`
--

CREATE TABLE IF NOT EXISTS `hck_shop_sendmoney` (
  `smid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL,
  `cname` varchar(25) NOT NULL,
  `orderindex` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`smid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_shop_tixian`
--

CREATE TABLE IF NOT EXISTS `hck_shop_tixian` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `shopid` int(10) unsigned NOT NULL,
  `shopname` varchar(30) NOT NULL,
  `money` int(11) NOT NULL,
  `status` tinyint(3) unsigned NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  `info` varchar(255) NOT NULL,
  `reply` varchar(255) NOT NULL,
  `redateline` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `money` (`money`),
  KEY `shopid_status` (`shopid`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_sites`
--

CREATE TABLE IF NOT EXISTS `hck_sites` (
  `siteid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `sitename` varchar(20) NOT NULL,
  `lat` decimal(9,6) NOT NULL,
  `lng` decimal(9,6) NOT NULL,
  `orderindex` smallint(5) unsigned NOT NULL,
  `domain` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`siteid`),
  KEY `orderindex` (`orderindex`),
  KEY `lat_lng` (`lat`,`lng`),
  KEY `domain` (`domain`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_stole`
--

CREATE TABLE IF NOT EXISTS `hck_stole` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(225) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `title` varchar(225) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_stole_rule`
--

CREATE TABLE IF NOT EXISTS `hck_stole_rule` (
  `id` int(11) NOT NULL,
  `title` varchar(225) NOT NULL,
  `catid` int(11) NOT NULL,
  `s_title` text NOT NULL,
  `e_title` text,
  `s_author` text,
  `e_author` text,
  `s_content` text,
  `e_content` text,
  `status` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `hck_sysmsg`
--

CREATE TABLE IF NOT EXISTS `hck_sysmsg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL COMMENT '消息标题',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态 1 显示 0不显示',
  `dateline` int(11) NOT NULL DEFAULT '0' COMMENT '时间',
  `content` mediumtext NOT NULL,
  `type_id` tinyint(4) NOT NULL COMMENT '类型 1用户  2商家',
  `start_time` int(11) NOT NULL,
  `end_time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_sysmsg_shop`
--

CREATE TABLE IF NOT EXISTS `hck_sysmsg_shop` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shopid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `msgid` int(11) NOT NULL DEFAULT '0' COMMENT '消息id',
  `status` tinyint(4) DEFAULT '0' COMMENT '状态 0 未读 1已读',
  `dateline` int(11) NOT NULL DEFAULT '0' COMMENT '获取时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户的系统消息' AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_sysmsg_user`
--

CREATE TABLE IF NOT EXISTS `hck_sysmsg_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `msgid` int(11) NOT NULL DEFAULT '0' COMMENT '消息id',
  `status` tinyint(4) DEFAULT '0' COMMENT '状态 0 未读 1已读',
  `dateline` int(11) NOT NULL DEFAULT '0' COMMENT '获取时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户的系统消息' AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_town`
--

CREATE TABLE IF NOT EXISTS `hck_town` (
  `townid` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `provinceid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `cityid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `town` varchar(50) NOT NULL,
  `orderindex` smallint(6) unsigned NOT NULL DEFAULT '0',
  `lat` decimal(9,6) NOT NULL,
  `lng` decimal(9,6) NOT NULL,
  PRIMARY KEY (`townid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_user`
--

CREATE TABLE IF NOT EXISTS `hck_user` (
  `userid` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(50) COLLATE utf8_bin NOT NULL,
  `password` varchar(100) COLLATE utf8_bin NOT NULL,
  `email` varchar(200) COLLATE utf8_bin NOT NULL,
  `logo` varchar(255) COLLATE utf8_bin NOT NULL,
  `address` varchar(200) COLLATE utf8_bin NOT NULL,
  `phone` varchar(30) COLLATE utf8_bin NOT NULL,
  `qq` int(11) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `nickname` varchar(50) COLLATE utf8_bin NOT NULL,
  `grade` decimal(9,2) NOT NULL DEFAULT '0.00' COMMENT '消费积分',
  `usegrade` decimal(9,2) NOT NULL,
  `fuserid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '推荐人',
  `dateline` int(11) unsigned NOT NULL DEFAULT '0',
  `shopid` int(11) unsigned NOT NULL,
  `followers` mediumint(8) unsigned NOT NULL,
  `followeds` mediumint(8) unsigned NOT NULL,
  `balance` decimal(8,1) unsigned NOT NULL,
  `info` varchar(255) CHARACTER SET utf8 NOT NULL,
  `blogs` smallint(5) unsigned NOT NULL,
  `lat` decimal(9,6) NOT NULL,
  `lng` decimal(9,6) NOT NULL,
  `salt` char(4) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`userid`),
  KEY `username` (`username`),
  KEY `dateline` (`dateline`),
  KEY `status_userid` (`status`,`userid`),
  KEY `fuserid` (`fuserid`),
  KEY `nickname_userid` (`nickname`,`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=7 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_userapi`
--

CREATE TABLE IF NOT EXISTS `hck_userapi` (
  `xid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `xuserid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'x用户id',
  `xusername` varchar(30) COLLATE utf8_bin NOT NULL COMMENT 'x用户名',
  `xfrom` varchar(20) COLLATE utf8_bin NOT NULL COMMENT '来自哪个插件',
  `uid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '站点id',
  `bind` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否已经绑定',
  `openid` varchar(40) COLLATE utf8_bin NOT NULL,
  `accesstoken` varchar(40) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`xid`),
  KEY `uid` (`uid`),
  KEY `xuserid` (`xuserid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_user_address`
--

CREATE TABLE IF NOT EXISTS `hck_user_address` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(9) unsigned NOT NULL,
  `address` varchar(255) NOT NULL,
  `telephone` varchar(15) NOT NULL,
  `truename` varchar(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid_id` (`userid`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_user_bonus`
--

CREATE TABLE IF NOT EXISTS `hck_user_bonus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_id` smallint(6) NOT NULL DEFAULT '1',
  `userid` smallint(6) NOT NULL DEFAULT '0',
  `bonus` decimal(7,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=6 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_user_bonus_log`
--

CREATE TABLE IF NOT EXISTS `hck_user_bonus_log` (
  `logid` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT '0',
  `siteid` smallint(6) NOT NULL DEFAULT '1',
  `content` varchar(255) COLLATE utf8_bin NOT NULL,
  `bonus` decimal(7,2) NOT NULL DEFAULT '0.00',
  `dateline` int(11) NOT NULL DEFAULT '0',
  `ftype` varchar(20) COLLATE utf8_bin NOT NULL,
  `orderno` varchar(50) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`logid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=114 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_user_gps`
--

CREATE TABLE IF NOT EXISTS `hck_user_gps` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(9) NOT NULL,
  `lat` decimal(9,6) NOT NULL,
  `lng` decimal(9,6) NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_user_paylog`
--

CREATE TABLE IF NOT EXISTS `hck_user_paylog` (
  `logid` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT '0',
  `content` varchar(255) COLLATE utf8_bin NOT NULL,
  `money` decimal(8,1) NOT NULL DEFAULT '0.0',
  `dateline` int(11) NOT NULL DEFAULT '0',
  `ftype` varchar(20) COLLATE utf8_bin NOT NULL,
  `orderno` varchar(50) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`logid`),
  KEY `orderno` (`orderno`),
  KEY `userid_logid` (`userid`,`logid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=9 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_user_rank`
--

CREATE TABLE IF NOT EXISTS `hck_user_rank` (
  `id` tinyint(4) unsigned NOT NULL AUTO_INCREMENT,
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `rank_name` varchar(50) COLLATE utf8_bin NOT NULL,
  `min_grade` int(11) unsigned NOT NULL DEFAULT '0',
  `max_grade` int(11) unsigned NOT NULL DEFAULT '0',
  `discount` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_vote`
--

CREATE TABLE IF NOT EXISTS `hck_vote` (
  `vid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `title` varchar(50) COLLATE utf8_bin NOT NULL,
  `vtype` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `dateline` int(11) unsigned NOT NULL DEFAULT '0',
  `detail` text COLLATE utf8_bin NOT NULL,
  `vtoption` text COLLATE utf8_bin NOT NULL,
  `logo` varchar(200) COLLATE utf8_bin NOT NULL,
  `isding` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `showtype` tinyint(4) unsigned NOT NULL DEFAULT '0' COMMENT '展示形式',
  `mustlogin` tinyint(4) unsigned NOT NULL DEFAULT '0' COMMENT '是否登录',
  PRIMARY KEY (`vid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_vote_sele`
--

CREATE TABLE IF NOT EXISTS `hck_vote_sele` (
  `sid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `tid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `orderid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `vid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `vcount` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`sid`),
  KEY `tid` (`tid`,`vid`),
  KEY `vid` (`vid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_vote_tt`
--

CREATE TABLE IF NOT EXISTS `hck_vote_tt` (
  `tid` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) NOT NULL DEFAULT '0',
  `title` varchar(200) COLLATE utf8_bin NOT NULL,
  `img` varchar(200) COLLATE utf8_bin NOT NULL,
  `url` varchar(200) COLLATE utf8_bin NOT NULL,
  `catid` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_vote_ttcat`
--

CREATE TABLE IF NOT EXISTS `hck_vote_ttcat` (
  `catid` smallint(6) NOT NULL AUTO_INCREMENT,
  `siteid` smallint(5) unsigned NOT NULL DEFAULT '1',
  `shopid` mediumint(9) NOT NULL DEFAULT '0',
  `cname` varchar(100) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`catid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_vote_user`
--

CREATE TABLE IF NOT EXISTS `hck_vote_user` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `shopid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `vid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `userid` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(50) COLLATE utf8_bin NOT NULL,
  `dateline` int(11) NOT NULL DEFAULT '0',
  `sid` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vid` (`vid`,`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_web`
--

CREATE TABLE IF NOT EXISTS `hck_web` (
  `id` tinyint(4) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(6) NOT NULL DEFAULT '0',
  `webname` varchar(20) COLLATE utf8_bin NOT NULL,
  `webtitle` varchar(200) COLLATE utf8_bin NOT NULL,
  `webkey` varchar(200) COLLATE utf8_bin NOT NULL,
  `webdesc` varchar(500) COLLATE utf8_bin NOT NULL,
  `weboff` tinyint(4) NOT NULL DEFAULT '0',
  `webmsn` varchar(200) COLLATE utf8_bin NOT NULL,
  `webqq` varchar(200) COLLATE utf8_bin NOT NULL,
  `beian` varchar(100) COLLATE utf8_bin NOT NULL,
  `weburl` varchar(100) COLLATE utf8_bin NOT NULL,
  `address` varchar(100) COLLATE utf8_bin NOT NULL,
  `phone` varchar(20) COLLATE utf8_bin NOT NULL,
  `offwhy` text COLLATE utf8_bin NOT NULL,
  `webgg` text COLLATE utf8_bin NOT NULL,
  `weblogo` varchar(200) COLLATE utf8_bin NOT NULL,
  `wapurl` varchar(50) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_webstats`
--

CREATE TABLE IF NOT EXISTS `hck_webstats` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8_bin NOT NULL,
  `title` varchar(255) COLLATE utf8_bin NOT NULL,
  `stype` tinyint(1) NOT NULL,
  `dateline` int(11) NOT NULL,
  `logo` varchar(255) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_weibo_config`
--

CREATE TABLE IF NOT EXISTS `hck_weibo_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nickname` varchar(20) NOT NULL,
  `siteid` smallint(6) NOT NULL,
  `token_users` text,
  `seocontent` text COMMENT 'seo信息',
  `catids` text COMMENT '分类id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_weibo_souser`
--

CREATE TABLE IF NOT EXISTS `hck_weibo_souser` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `screen_name` varchar(20) DEFAULT NULL COMMENT '昵称',
  `location` varchar(20) DEFAULT NULL COMMENT '位置',
  `description` varchar(225) DEFAULT NULL COMMENT '描述',
  `avatar_large` varchar(225) DEFAULT NULL COMMENT '头像',
  `friends_count` smallint(6) DEFAULT NULL COMMENT '关注数',
  `domain` varchar(20) DEFAULT NULL COMMENT '域名',
  `followers_count` int(11) DEFAULT NULL COMMENT '粉丝数',
  `statuses_count` int(11) DEFAULT NULL COMMENT '微博数',
  `status` tinyint(4) DEFAULT '0' COMMENT '状态  0未索引 1已索引 2已获取标签',
  `step` tinyint(4) DEFAULT NULL COMMENT '级别 第几次索引的',
  `visible` tinyint(1) NOT NULL COMMENT '1为显示 0为隐藏',
  `tags` varchar(225) NOT NULL COMMENT '用户标签',
  `gender` char(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `follwers_count` (`visible`,`followers_count`) USING BTREE,
  KEY `statuses_count` (`visible`,`statuses_count`) USING BTREE,
  KEY `v_id` (`visible`,`id`),
  KEY `uid` (`uid`),
  KEY `status` (`status`,`followers_count`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_weixin`
--

CREATE TABLE IF NOT EXISTS `hck_weixin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(32) NOT NULL DEFAULT '' COMMENT '微信token',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '微信名',
  `dateline` int(11) NOT NULL DEFAULT '0',
  `shopid` int(11) NOT NULL DEFAULT '0',
  `siteid` int(11) NOT NULL DEFAULT '1',
  `imgurl` varchar(225) DEFAULT NULL COMMENT '二维码',
  `logo` varchar(225) DEFAULT NULL COMMENT 'logo',
  `imgsdata` text COMMENT '截图',
  `appid` varchar(64) DEFAULT NULL,
  `appkey` varchar(64) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `isshow` tinyint(1) DEFAULT '0',
  `ysid` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='微信公众号' AUTO_INCREMENT=6 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_weixin_command`
--

CREATE TABLE IF NOT EXISTS `hck_weixin_command` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wid` int(11) NOT NULL DEFAULT '0' COMMENT '微信id',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '命令名称',
  `command` varchar(32) NOT NULL DEFAULT '' COMMENT '命令',
  `type_id` tinyint(4) NOT NULL DEFAULT '0' COMMENT '命令类型',
  `content` text COMMENT '内容',
  `dateline` int(11) NOT NULL DEFAULT '0',
  `siteid` int(11) NOT NULL DEFAULT '1',
  `shopid` int(11) NOT NULL DEFAULT '0',
  `sc_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `wid` (`wid`),
  KEY `command` (`command`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='微信公众号' AUTO_INCREMENT=6 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_weixin_menu`
--

CREATE TABLE IF NOT EXISTS `hck_weixin_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siteid` int(11) NOT NULL DEFAULT '1',
  `userid` int(11) NOT NULL DEFAULT '0',
  `shopid` int(11) NOT NULL DEFAULT '0',
  `wid` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `orderindex` tinyint(4) NOT NULL DEFAULT '0',
  `title` varchar(20) DEFAULT NULL COMMENT '名称',
  `w_type` varchar(10) DEFAULT '类型',
  `w_key` varchar(32) DEFAULT NULL,
  `w_url` varchar(225) DEFAULT NULL,
  `sc_id` int(11) NOT NULL DEFAULT '0',
  `content` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `wid` (`wid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='微信自定义菜单' AUTO_INCREMENT=7 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_weixin_reply`
--

CREATE TABLE IF NOT EXISTS `hck_weixin_reply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` tinyint(4) DEFAULT '0' COMMENT '1回复成功，0回复不成功',
  `openid` varchar(32) NOT NULL,
  `msgtype` char(10) NOT NULL COMMENT '消息类型',
  `createtime` int(11) DEFAULT '0',
  `content` text COMMENT '文本消息内容',
  `msgid` varchar(32) DEFAULT NULL COMMENT 'msgid ',
  `picurl` varchar(250) DEFAULT NULL COMMENT '图片消息url',
  `mediaid` varchar(32) DEFAULT NULL,
  `thumbmediaid` varchar(32) DEFAULT NULL,
  `format` varchar(12) DEFAULT NULL,
  `location_x` varchar(20) DEFAULT NULL COMMENT '地址位置x轴',
  `location_y` varchar(20) DEFAULT NULL COMMENT '地理位置y轴',
  `scale` int(11) DEFAULT '0' COMMENT '地图缩放大小',
  `label` varchar(200) DEFAULT NULL COMMENT '地理位置信息',
  `title` varchar(100) DEFAULT NULL COMMENT '图文消息标题',
  `description` varchar(500) DEFAULT NULL COMMENT '图文消息说明',
  `url` varchar(150) DEFAULT NULL COMMENT '消息链接',
  `siteid` int(11) DEFAULT '1',
  `wid` int(11) DEFAULT '0',
  `fromusername` varchar(32) DEFAULT NULL,
  `tousername` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_weixin_sucai`
--

CREATE TABLE IF NOT EXISTS `hck_weixin_sucai` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `dateline` int(11) NOT NULL DEFAULT '0',
  `shopid` int(11) NOT NULL DEFAULT '0',
  `siteid` int(11) NOT NULL DEFAULT '0',
  `content` mediumtext,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `imgurl` varchar(225) DEFAULT '' COMMENT '封面',
  `description` varchar(225) DEFAULT NULL,
  `wid` int(11) NOT NULL DEFAULT '0',
  `linkurl` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`),
  KEY `shopid` (`shopid`),
  KEY `pid` (`pid`),
  KEY `wid` (`wid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='微信素材' AUTO_INCREMENT=15 ;

-- --------------------------------------------------------

--
-- 表的结构 `hck_weixin_user`
--

CREATE TABLE IF NOT EXISTS `hck_weixin_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `openid` varchar(64) DEFAULT NULL,
  `dateline` int(11) NOT NULL DEFAULT '0' COMMENT '第一次互动时间',
  `add_time` int(11) DEFAULT NULL COMMENT '关注事件',
  `last_time` int(11) NOT NULL DEFAULT '0' COMMENT '最后回复事件',
  `del_time` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `siteid` int(11) NOT NULL DEFAULT '1',
  `nickname` varchar(32) DEFAULT NULL,
  `sex` tinyint(4) DEFAULT NULL,
  `city` varchar(12) DEFAULT NULL,
  `country` varchar(24) DEFAULT NULL,
  `province` varchar(12) DEFAULT NULL,
  `user_head` varchar(225) DEFAULT NULL,
  `update_time` int(11) DEFAULT '0' COMMENT '更新信息时间',
  `reply_num` int(11) NOT NULL DEFAULT '0',
  `wid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `openid` (`openid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='微信用户表' AUTO_INCREMENT=2 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
