// JavaScript Document
;SkyPhone.cache=(function(S,$){
	var set=function(key,val,expire){
		key=key.replace(/\W/i,"_");
		if(typeof(expire)=="undefined"){
			expire=36000000;//默认永不过期
		}
		
		var data={
			data:val,
			expire: Date.parse(new Date())+expire*1000	
		};
		window.localStorage.setItem(key,JSON.stringify(data));
	};
	
	var get=function(key){
		key=key.replace(/\W/i,"_");
		var data=window.localStorage.getItem(key);
		
		if(data==null){
			return false;
		}else{
			var arr=JSON.parse(data);
			if(arr.expire<=Date.parse(new Date())){
				return false;
			}else{
				return arr;
			}
		}		
	};
	
	var del=function(key){
		key=key.replace(/\W/i,"_");
		window.localStorage.removeItem(key);
	}
	
	var clear = function(){
        var storage = window.localStorage;
        for(var key in storage){
            storage.removeItem(key);
        }
    }
	return {
		get : get,
		set : set,
		del : del,
		clear : clear
	}
	
})(SkyPhone,Zepto);