if (!Ext.ModelManager.isRegistered('ContactPageSetting')){
Ext.define('ContactPageSetting', {
	extend : 'Ext.form.Panel',
	alias  : 'widget.ContactPageSetting',
	
	id : 'widget.ContactPageSetting',
	title : '联系我们页面设置',
	closable : true,
	autoScroll : true,
    bodyPadding: 10,
    buttonAlign : 'left',
	defaultType: 'textfield',
    fieldDefaults : {
        msgTarget: 'side',
        labelWidth: 100,
        labelAlign: 'right'
    },
	
	initComponent : function() {
		var pageSettings =  Ext.create('Ext.data.Store', {
			model: 'PageSetting',
			proxy: {
				type: 'ajax',
				url: 'page_settings_get.php',
				reader: {
					type: 'json',
					root: 'settings'
				}
			},
			listeners: {
				'load': function(store, records, options) {
					if(records && records.length>0){
						this.getForm().loadRecord(records[0]);
					}
				},
				scope: this
			}
		});
		pageSettings.load();
		
		Ext.apply(this, {
			items: [{
				fieldLabel: '餐厅联系Email',
				width: 400,
				name: 'RESTAURANT_CONTACT_EMAIL'
	    	},{
        		xtype: 'label',
        		text: '餐厅可以通过这个Email联系你。',
        		cls: 'form_tips'
        	},{
				fieldLabel: '餐厅联系电话',
				width: 400,
				name: 'RESTAURANT_CONTACT_PHONE'
	    	},{
        		xtype: 'label',
        		text: '餐厅可以通过这个电话联系你 。',
        		cls: 'form_tips'
        	},{
				fieldLabel: '媒体联系Email',
				width: 400,
				name: 'PRESS_CONTACT_EMAIL'
	    	},{
        		xtype: 'label',
        		text: '媒体可以通过这个Email联系你。',
        		cls: 'form_tips'
        	},{
				fieldLabel: '媒体联系电话',
				width: 400,
				name: 'PRESS_CONTACT_PHONE'
	    	},{
        		xtype: 'label',
        		text: '媒体可以通过这个电话联系你 。',
        		cls: 'form_tips'
        	},{
				fieldLabel: '商务洽谈Email',
				width: 400,
				name: 'BUSINESS_CONTACT_EMAIL'
	    	},{
        		xtype: 'label',
        		text: '要商务洽谈可以通过这个Email联系你。',
        		cls: 'form_tips'
        	},{
				fieldLabel: '商务洽谈电话',
				width: 400,
				name: 'BUSINESS_CONTACT_PHONE'
	    	},{
        		xtype: 'label',
        		text: '要商务洽谈可以通过这个电话联系你。',
        		cls: 'form_tips'
        	}],
		    buttons: [{
	            text: '保存',
	            handler: this.submitForm,
	            scope: this
	        },{
	            text: '重置',
	            handler: function() {this.getForm().reset();},
	            scope: this
	        }]
		});
		this.callParent(arguments);
	},
	
	submitForm : function() {
		var form = this.getForm();
		if (form.isValid()) {
			this.submit({
				url:'page_settings_save.php',
				waitTitle : '请稍候',
				waitMsg : '正在保存系统配置...',
				method : 'POST',
		        success: this.saveSettingsSuccess,
		        failure: this.saveSettingsFailure,
		        scope: this
		    });
		}
		else {
			showErrorMsg('某些输入项不符合规定，请检查各字段的输入。','输入有误。');
		}
	},
	
	saveSettingsSuccess : function (form, action) {
		showSuccessMsg('保存帮助页设置成功。');
	},
	
	saveSettingsFailure : function (form, action) {
		showFormFailureMsg( action, '保存帮助页设置失败');
	}
});
}