if (!Ext.ModelManager.isRegistered('CustomLogWidget')){
Ext.define('CustomLogWidget', {
	extend : 'Ext.grid.Panel',
	alias  : 'widget.CustomLogWidget',
	
	initComponent : function() {
		this.store = Ext.create('Ext.data.Store',{
			autoDestroy: true,
			model: 'CustomLog',
			pageSize: 20,
			proxy: {
				type: 'ajax',
				url: 'customlogs.php',
				reader: {
					type: 'json',
					root: 'customlogs',
					totalProperty: 'total',
					id: 'id'
				}
			},
			autoLoad: true
		});
		
		
		Ext.apply(this, {
			id : 'widget.CustomLogWidget',
			title : '客户操作日志',
			closable : true,
			autoScroll : true,
	        columns: [
	        	{
	        		xtype	 : 'rownumberer',
	                width    : 40
	        	},
	        	{
	                text     : '用户名',
	                width    : 80,
	                sortable : true,
	                dataIndex: 'Username'
	            },
	            {
	                text     : '电子邮箱',
	                width    : 180,
	                sortable : true,
	                dataIndex: 'Email'
	            },
	            {
	                text     : '手机号码',
	                width    : 120,
	                sortable : true,
	                dataIndex: 'Mobile'
	            },
	            {
	                text     : '操作时间',
	                width    : 140,
	                sortable : true,
	                dataIndex: 'OpTime'
	            },
	            {
	                text     : 'IP地址',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'IP'
	            },
	            {
	                text     : '操作种类',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Operation'
	            },
	            {
	                text     : '附加数据或描述',
	                flex	 : 1,
	                minWidth : 200,
	                sortable : true,
	                dataIndex: 'Data'
	            }
	        ],
	        dockedItems: [{
				xtype: 'pagingtoolbar',
				store: this.store,   // same store GridPanel is using
				dock: 'bottom',
				displayInfo: true
			},{
				xtype: 'toolbar',
				items: ['搜索',{
					xtype: 'textfield',
					name: 'searchText',
					tooltip:{text:'可以在此输入用户名、电子邮箱、手机号码、附加数据或描述等进行模糊查询。',title:'搜索提示'},
					hideLabel: true,
					width: 130,
					listeners: {
						 change: {
						 	fn: function(field, newValue, oldValue) {
						 		this.searchText = newValue;
						 	},
						 	scope: this,
							buffer: 100
						 },
						 afterrender: {
						 	fn: function(field) {
							 		if(field.tooltip.text){   
					                    new Ext.ToolTip({
					                        target:field.id,
					                        trackMouse:false,
					                        draggable:true,
					                        maxWidth:300,
					                        minWidth:100,
					                        title:"<span style='color:green'>" + field.tooltip.title + "</span>",
					                        html:"<span style='color:green'>" + field.tooltip.text + "</span>"
					                    }); 
					                }  
							 	}
						 }
					}
				},'　从',{
					xtype: 'datefield',
					width: 100,
					name: 'searchDateFrom',
					hideLabel: true,
					maxValue: new Date(),
					format: 'Y-m-d',
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchDateFrom = newValue;
						}
					}
				},'',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchHourFrom',
					id: 'custom_log_widget_search_hour_from',
					hideLabel: true,
					minValue: 0,
					maxValue: 23,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchHourFrom = newValue;
						}
					}
				},':',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchMinuteFrom',
					id: 'custom_log_widget_search_minute_from',
					hideLabel: true,
					minValue: 0,
					maxValue: 59,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchMinuteFrom = newValue;
						}
					}
				},'　到',{
					xtype: 'datefield',
					width: 100,
					name: 'searchDateEnd',
					hideLabel: true,
					maxValue: new Date(),
					format: 'Y-m-d',
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchDateEnd = newValue;
						}
					}
				},'',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchHourEnd',
					id: 'custom_log_widget_search_hour_end',
					hideLabel: true,
					minValue: 0,
					maxValue: 23,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchHourEnd = newValue;
						}
					}
				},':',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchMinuteEnd',
					id: 'custom_log_widget_search_minute_end',
					hideLabel: true,
					minValue: 0,
					maxValue: 59,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchMinuteEnd = newValue;
						}
					}
				},'　IP',{
					xtype: 'textfield',
					name: 'searchIP',
					hideLabel: true,
					width: 110,
					listeners: {
						 change: {
						 	fn: function(field, newValue, oldValue) {
						 		this.searchIP = newValue;
						 	},
						 	scope: this,
							buffer: 100
						 }
					}
				},'　操作类型',{
					xtype: 'combo',
					width: 80,
					name: 'searchOperation',
					hideLabel: true,
					store: [
	                    ['','全部'],
	                    ['添加','添加'],
						['注册','注册'],
						['登录','登录'],
						['登出','登出'],
						['设置','设置'],
						['留言','留言'],
						['订餐','订餐']
	                ],
	                lazyRender: true,
	                listClass: 'x-combo-list-small',
	                listeners: {
						scope: this,
						'select' : function(combobox, value){
							this.searchOperation = value[0].data.field1;
						}
					}
				},{
					text:'开始搜索',
					tooltip:'开始搜索',
					iconCls:'search',
					scope: this,
					handler: this.startSearch
				}]
			}]
		});
		this.callParent(arguments);
	},
	
	startSearch : function() {
		var store = this.store;
		var proxy = store.getProxy();
		proxy.extraParams.searchText = this.searchText;
		if(this.searchDateFrom!='' && this.searchDateFrom!=null){
			if(this.searchHourFrom==null || this.searchHourFrom==''){
				this.searchHourFrom = 0;
				Ext.getCmp('custom_log_widget_search_hour_from').setValue(0);
			}
			if(this.searchMinuteFrom==null || this.searchMinuteFrom==''){
				this.searchMinuteFrom = 0;
				Ext.getCmp('custom_log_widget_search_minute_from').setValue(0);
			}
		}
		proxy.extraParams.searchDateFrom = this.searchDateFrom;
		proxy.extraParams.searchHourFrom = this.searchHourFrom;
		proxy.extraParams.searchMinuteFrom = this.searchMinuteFrom;
		if(this.searchDateEnd!='' && this.searchDateEnd!=null){
			if(this.searchHourEnd==null || this.searchHourEnd==''){
				this.searchHourEnd = 23;
				Ext.getCmp('custom_log_widget_search_hour_end').setValue(23);
			}
			if(this.searchMinuteEnd==null || this.searchMinuteEnd==''){
				this.searchMinuteEnd = 59;
				Ext.getCmp('custom_log_widget_search_minute_end').setValue(59);
			}
		}
		proxy.extraParams.searchDateEnd = this.searchDateEnd;
		proxy.extraParams.searchHourEnd = this.searchHourEnd;
		proxy.extraParams.searchMinuteEnd = this.searchMinuteEnd;
		proxy.extraParams.searchIP = this.searchIP;
		proxy.extraParams.searchOperation = this.searchOperation;
		store.loadPage(1);
	}
});
}