if (!Ext.ModelManager.isRegistered('GiftSettingWidget')) {
	Ext
			.define(
					'GiftSettingWidget',
					{
						extend : 'Ext.grid.Panel',
						alias : 'widget.GiftSettingWidget',
						theGiftEdit : null,
						theGiftEdit_add : null,
						initComponent : function() {
							this.store = Ext.create('Ext.data.Store', {
								autoDestroy : true,
								model : 'gift',
								pageSize : 20,
								proxy : {
									type : 'ajax',
									url : 'gift.php',
									method : "POST",
									extraParams : {
										'action' : 'init'
									},
									reader : {
										type : 'json',
										root : 'gifts',
										totalProperty : 'total',
										id : 'id'
									}
								},
								autoLoad : true
							});
							gift_store = this.store;// 给外部变量赋值
						
							Ext
									.apply(
											this,
											{
												id : 'widget.GiftSettingWidget',
												title : '礼品管理',
												closable : true,
												autoScroll : true,
												listeners : {
													'select' : function() {
														// 让删除和修改按钮变得可用
														Ext.getCmp('gift_edit')
																.setDisabled(
																		false);
														Ext.getCmp(
																'gift_delete')
																.setDisabled(
																		false);
													}
												},
												columns : [
														{
															xtype : 'rownumberer',
															width : 40
														},
														{
															text : 'id',
															width : 80,
															sortable : true,
															dataIndex : 'id',
															hidden : true
														},
														{
															text : '礼品名称',
															width : 180,
															sortable : true,
															editor : {
																allowBlank : false,
																blankText : '礼品名称不能为空'
															},
															dataIndex : 'lpName'
														},
														{
															text : 'imgPath',
															hidden : true,
															width : 120,
															sortable : true,
															dataIndex : 'lpImgPath'
														},
														{
															text : '所需积分',
															width : 140,
															sortable : true,
															editor : {
																allowBlank : false,
																blankText : '积分不能为空'
															},
															dataIndex : 'lpScore'
														},
														{
															text : '剩余数量',
															width : 100,
															sortable : true,
															editor : {
																allowBlank : false,
																blankText : '剩余数量不能为空'
															},
															dataIndex : 'lpCount'
														},
														{
															text : '礼品描述',
															width : 300,
															sortable : true,
															editor : 'textfield',
															dataIndex : 'lpDes'
														},
														{
															xtype : 'actioncolumn',
															flex : 1,
															items : [ {
																icon : 'images/database_go.png',
																altText : '上传图片',
																tooltip : '点击上传该礼品的图片',
																handler : this.createImgUploadWin,
																scope : this
															} ]
														} ],
												plugins : [ this
														.createEdit_plugins() ],
												dockedItems : [
														{
															xtype : 'pagingtoolbar',
															store : this.store, // same
															dock : 'bottom',
															displayInfo : true
														},
														{
															xtype : 'toolbar',
															items : [
																	'搜索',
																	{
																		xtype : 'textfield',
																		name : 'searchText',
																		tooltip : {
																			text : '可以在此输入礼品名称进行模糊查询。',
																			title : '搜索提示'
																		},
																		hideLabel : true,
																		width : 130,
																		listeners : {
																			change : {
																				fn : function(
																						field,
																						newValue,
																						oldValue) {
																					this.searchText = newValue;
																					// alert(newValue);
																				},
																				scope : this,
																				buffer : 100
																			}
																		
																		}
																	},
																	{
																		text : '开始搜索',
																		tooltip : '开始搜索',
																		iconCls : 'search',
																		scope : this,
																		handler : this.startSearch
																	},
																	{
																		id : 'gift_add',
																		text : '添加礼品',
																		tooltip : '添加一个礼品',
																		iconCls : 'add',
																		scope : this,
																		handler : function() {
																			gift_store
																					.insert(
																							0,
																							0);
																			this.theGiftEdit
																					.startEdit(
																							0,
																							0);
																		}
																	},
																	'-',
																	{
																		id : 'gift_edit',
																		text : '修改礼品',
																		tooltip : '修改所选的礼品的信息',
																		disabled : true,
																		iconCls : 'edit',
																		scope : this,
																		handler : function() {
																			var item = this
																					.getSelectionModel().selected
																					.first();
																			if (item) {
																				var rowIndex = gift_store
																						.indexOf(item);
																				this.theGiftEdit
																						.startEdit(
																								rowIndex,
																								0);
																			}

																		}
																	},
																	'-',
																	{
																		id : 'gift_delete',
																		text : '删除礼品',
																		tooltip : '删除所选的礼品',
																		disabled : true,
																		iconCls : 'delete',
																		scope : this,
																		handler : function() {
																			var giftId = 0;

																			var item = this
																					.getSelectionModel().selected
																					.first();
																			if (item) {
																				var rowIndex = gift_store
																						.indexOf(item);
																				giftId = gift_store
																						.getAt(
																								rowIndex)
																						.get(
																								'id');
																			}

																			Ext.Ajax
																					.request({
																						url : 'gift_edit.php',
																						method : 'POST',
																						params : {
																							m : 'del',
																							giftId : giftId,
																						},
																						success : function(
																								response) {
																							var text = response.responseText;
																							var json = Ext.JSON
																									.decode(text);
																							if (json.success == true) {
																								Ext.Msg
																										.alert(
																												'提示',
																												'删除成功！');
																								gift_store
																										.load();
																							} else {
																								Ext.Msg
																										.alert(
																												'提示',
																												'删除失败，请重试！');
																							}
																						}
																					});
																		}
																	} ]
														} ]
											});

							this.callParent(arguments);
						},
						createImgUploadWin : function(grid, rowIndex) {
							var gift_id = grid.store.data.items[rowIndex].data.id;// 获得餐品的Id
							var giftImgPath = grid.store.data.items[rowIndex].data.lpImgPath;// 获得餐品的图片地址
							Ext.create(
									'Ext.window.Window',
									{
										id : 'img_upload_win',
										title : '上传图片',
										width : 400,
										height : 200,
										layout : 'fit',
										items : this.createUploadPanel(gift_id,
												giftImgPath)
									}).show();
						},
						createUploadPanel : function(gift_id, giftImgPath) {// 创建上传图片的FormPanel
							this.panel_ = Ext
									.create(
											'Ext.form.Panel',
											{
												width : 390,
												fileUpload : true,
												// Fields will be arranged
												// vertically, stretched to full
												// width
												layout : 'anchor',
												defaults : {
													anchor : '100%'
												},
												items : [ {
													scope : this,
													xtype : 'filefield',
													name : 'my_gift_img',
													fieldLabel : '请选择礼品图片',
													labelWidth : 100,
													msgTarget : 'side',
													allowBlank : false,
													anchor : '100%',
													buttonText : ' 选择 '
												} ],
												buttons : [
														{
															text : '重置',
															handler : function() {
																this
																		.up(
																				'form')
																		.getForm()
																		.reset();
															}
														},
														{
															text : '提交',
															formBind : true,
															disabled : true,
															handler : function() {
																var form = this
																		.up(
																				'form')
																		.getForm();
																if (form
																		.isValid()) {
																	form
																			.submit({
																				clientValidation : true,

																				// 'upload_dish_img.php',
																				url : 'upload_gift_img.php',
																				params : {
																					giftId : gift_id,
																					giftImagePath : giftImgPath
																				},

																				success : function(
																						vform,
																						action) {
																					var path = action.result.path;// 图片的解读路径
																					gift_store
																							.load();
																					Ext
																							.getCmp(
																									'img_upload_win')
																							.close();
																					Ext.Msg
																							.alert(
																									'上传成功',
																									'图片已经上传成功！');
																					vform
																							.reset();

																				},
																				failure : function(
																						vform,
																						action) {
																					Ext.Msg
																							.alert(
																									'上传失败',
																									action.result.errors);
																					vform
																							.reset();
																				}
																			});
																}
															}
														} ]
											});
							return this.panel_;
						},

						startSearch : function() {
							var store = this.store;
							var proxy = store.getProxy();
							proxy.extraParams.query = this.searchText;
							proxy.extraParams.action = 'query';
							store.loadPage(1);
//							if (this.searchDateFrom != ''
//									&& this.searchDateFrom != null) {
//								if (this.searchHourFrom == null
//										|| this.searchHourFrom == '') {
//									this.searchHourFrom = 0;
//									Ext
//											.getCmp(
//													'custom_log_widget_search_hour_from')
//											.setValue(0);
//								}
//								if (this.searchMinuteFrom == null
//										|| this.searchMinuteFrom == '') {
//									this.searchMinuteFrom = 0;
//									Ext
//											.getCmp(
//													'custom_log_widget_search_minute_from')
//											.setValue(0);
//								}
//							}
//							proxy.extraParams.searchDateFrom = this.searchDateFrom;
//							proxy.extraParams.searchHourFrom = this.searchHourFrom;
//							proxy.extraParams.searchMinuteFrom = this.searchMinuteFrom;
//							if (this.searchDateEnd != ''
//									&& this.searchDateEnd != null) {
//								if (this.searchHourEnd == null
//										|| this.searchHourEnd == '') {
//									this.searchHourEnd = 23;
//									Ext
//											.getCmp(
//													'custom_log_widget_search_hour_end')
//											.setValue(23);
//								}
//								if (this.searchMinuteEnd == null
//										|| this.searchMinuteEnd == '') {
//									this.searchMinuteEnd = 59;
//									Ext
//											.getCmp(
//													'custom_log_widget_search_minute_end')
//											.setValue(59);
//								}
//							}
//							proxy.extraParams.searchDateEnd = this.searchDateEnd;
//							proxy.extraParams.searchHourEnd = this.searchHourEnd;
//							proxy.extraParams.searchMinuteEnd = this.searchMinuteEnd;
//							proxy.extraParams.searchIP = this.searchIP;
//							proxy.extraParams.searchOperation = this.searchOperation;
							
						},
						createEdit_plugins : function() {
							this.theGiftEdit = Ext
									.create(
											'Ext.grid.plugin.RowEditing',
											{
												clicksToEdit : 2, // 双击进入编辑
												clicksToMoveEditor : 1, // 编辑过程中单击其他行开始编辑其他行
												autoCancel : false, // 编辑过程中单击其他行是否自动取消本行的数据保存，否
												errorSummary : true,
												listeners : {
													'canceledit' : function(
															grid, eOpts) {
														var giftId = grid.record.data.id;//
														if (giftId) {
														} else {
															gift_store
																	.removeAt(0);
														}
													},
													'edit' : function(editor, e) {// 就是保存事件
														var giftId = editor.record.data.id;//
														var lpCount = editor.record.data.lpCount;
														var lpDes = editor.record.data.lpDes;
														var lpName = editor.record.data.lpName;
														var lpScore = editor.record.data.lpScore;
														var lpImgPath = editor.record.data.lpImgPath;
														// console.log(editor.record.data);
														Ext.Ajax
																.request({
																	url : 'gift_edit.php',
																	method : 'POST',
																	params : {
																		m : 'edit',
																		giftId : giftId,
																		count : lpCount,
																		des : lpDes,
																		name : lpName,
																		score : lpScore,
																		imgPath : lpImgPath
																	},
																	success : function(
																			response) {
																		var text = response.responseText;
																		var json = Ext.JSON
																				.decode(text);
																		if (json.success == true) {
																			Ext.Msg
																					.alert(
																							'提示',
																							'更新成功！');
																			gift_store
																					.load();
																		} else {
																			Ext.Msg
																					.alert(
																							'提示',
																							'更新失败，请重试！');
																		}
																	}
																});
													}

												}
											});
							return this.theGiftEdit;
						}
					});

}
var gift_store = null;