if (!Ext.ModelManager.isRegistered('HelpPageSetting')){
Ext.define('HelpPageSetting', {
	extend : 'Ext.form.Panel',
	alias  : 'widget.HelpPageSetting',
	
	id : 'widget.HelpPageSetting',
	title : '帮助页面设置',
	closable : true,
	autoScroll : true,
    buttonAlign : 'left',
	
	initComponent : function() {
		var pageSettings =  Ext.create('Ext.data.Store', {
			model: 'PageSetting',
			proxy: {
				type: 'ajax',
				url: 'page_settings_get.php',
				reader: {
					type: 'json',
					root: 'settings'
				}
			},
			listeners: {
				'load': function(store, records, options) {
					if(records && records.length>0){
						this.getForm().loadRecord(records[0]);
					}
				},
				scope: this
			}
		});
		pageSettings.load();
		
		Ext.apply(this, {
			items: [{
				width: 640,
				height: '100%',
				padding: 10,
		        xtype: 'htmleditor',
		        enableColors: false,
				name: 'HELP_PAGE',
		        enableAlignments: false
		    }],
		    buttons: [{
	            text: '保存',
	            handler: this.submitForm,
	            scope: this
	        },{
	            text: '重置',
	            handler: function() {this.getForm().reset();},
	            scope: this
	        }]
		});
		this.callParent(arguments);
	},
	
	submitForm : function() {
		var form = this.getForm();
		if (form.isValid()) {
			this.submit({
				url:'page_settings_save.php',
				waitTitle : '请稍候',
				waitMsg : '正在保存系统配置...',
				method : 'POST',
		        success: this.saveSettingsSuccess,
		        failure: this.saveSettingsFailure,
		        scope: this
		    });
		}
		else {
			showErrorMsg('某些输入项不符合规定，请检查各字段的输入。','输入有误。');
		}
	},
	
	saveSettingsSuccess : function (form, action) {
		showSuccessMsg('保存帮助页设置成功。');
	},
	
	saveSettingsFailure : function (form, action) {
		showFormFailureMsg( action, '保存帮助页设置失败');
	}
});
}